/**************************************************************************
* This file is part of the WebIssues program
* Copyright (C) 2006 Michał Męciński
* Copyright (C) 2007-2008 WebIssues Team
*
* This program is free software; you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation; either version 2 of the License, or
* (at your option) any later version.
**************************************************************************/

#ifndef ICONLOADER_H
#define ICONLOADER_H

#include <QPixmap>
#include <QIcon>

namespace WebIssues
{

/**
* Class for loading icons and pixmaps.
*
* Icons and pixmaps are cached for faster access.
*/
class IconLoader
{
public:
    /**
    * Load the pixmap with the given name and size.
    *
    * @param name Name of the image file.
    *
    * @param size Size of the pixmap.
    */
    static QPixmap pixmap( const QString& name, int size = 16 );

    /**
    * Load the pixmap with an overlay image.
    *
    * @param name Name of the image file.
    *
    * @param overlay Name of the overlay image file.
    *
    * @param size Size of the pixmap.
    */
    static QPixmap overlayedPixmap( const QString& name, const QString& overlay, int size = 16 );

    /**
    * Creating an icon with the given name.
    *
    * The icon contains all available image sizes.
    *
    * @param name Name of the image file.
    */
    static QIcon icon( const QString& name );
};

}

#endif
