package WebGUI::Help::Asset_EventManagementSystem;    ## Be sure to change the package name to match your filename.
use strict;

##Stub document for creating help documents.

our $HELP = {

    'event management system main template' => {
        source    => 'sub view',
        title     => 'main template help title',
        body      => 'main template help body',
        variables => [
            { 'name' => 'addBadgeUrl',          required => 1 },
            { 'name' => 'buildBadgeUrl',        required => 1 },
            { 'name' => 'manageBadgeGroupsUrl', required => 1  },
            { 'name' => 'getBadgesUrl',         required => 1  },
            { 'name' => 'canEdit' },
            { 'name' => 'lookupRegistrantUrl',  required => 1  },
        ],
        isa   => [
            {   namespace => "Asset_EventManagementSystem",
                tag       => "ems asset template variables"
            },
            {   namespace => "Asset_Template",
                tag       => "template variables"
            },
            {   namespace => "Asset_Wobject",
                tag       => "wobject template variables"
            },
        ],
        fields  => [],
        related => [],
    },

    'ems badge builder template' => {
        source    => 'sub www_buildBadge',
        title     => 'badge builder template',
        body      => '',
        variables => [
            { 'name' => 'addTicketUrl'},
            { 'name' => 'addRibbonUrl'},
            { 'name' => 'addTokenUrl'},
            { 'name' => 'importTicketsUrl'},
            { 'name' => 'exportTicketsUrl'},
            { 'name' => 'printRemainingTicketsUrl'},
            { 'name' => 'canEdit'},
            { 'name' => 'hasBadge'},
            { 'name' => 'badgeId'},
            { 'name' => 'getTicketsUrl', required => 1,},
            { 'name' => 'getRibbonsUrl', required => 1,},
            { 'name' => 'whichTab',      required => 1,},
            { 'name' => 'getTokensUrl',  required => 1,},
            { 'name' => 'whichTab',      required => 1,},
            {
                name        => 'lookupBadgeUrl',
                description => 'lookupRegistrantUrl',
            },
            { 'name' => 'url',      required => 1,},
            { 'name' => 'viewCartUrl'},
            { 'name' => 'customRequestUrl',      required => 1,},
            { 'name' => 'manageEventMetaFieldsUrl'},
            { 'name' => 'otherBadgesInCart',
              'variables' => [
                { 'name' => 'badgeUrl'},
                { 'name' => 'badgeLabel'},
              ],
            },
        ],
        isa   => [
            {   namespace => "Asset_EventManagementSystem",
                tag       => "ems asset template variables"
            },
            {   namespace => "Asset_Template",
                tag       => "template variables"
            },
            {   namespace => "Asset_Wobject",
                tag       => "wobject template variables"
            },
        ],
        fields  => [],
        related => [],
    },

    'ems lookup registrant template' => {
        source    => 'sub www_lookupRegistrant',
        title     => 'lookup registrant template',
        body      => '',
        variables => [
            { 'name' => 'buyBadgeUrl'},
            { 'name' => 'viewEventsUrl'},
            { 'name' => 'viewCartUrl'},
            { 'name' => 'getRegistrantsUrl', required => 1},
            { 'name' => 'isRegistrationStaff'},
        ],
        isa   => [
            {   namespace => "Asset_Template",
                tag       => "template variables"
            },
        ],
        fields  => [],
        related => [],
    },

    'ems print badge template' => {
        source    => 'sub www_printBadge',
        title     => 'print badge template',
        body      => '',
        variables => [
            { 'name' => 'badgeTitle'},
            { 'name' => 'badgeId'},
            { 'name' => 'badgeNumber'},
            { 'name' => 'badgeAssetId'},
            { 'name' => 'emsAssetId'},
            { 'name' => 'userId'},
            { 'name' => 'name'},
            { 'name' => 'address1'},
            { 'name' => 'address2'},
            { 'name' => 'address3'},
            { 'name' => 'city'},
            { 'name' => 'state'},
            { 'name' => 'zipcode'},
            { 'name' => 'country'},
            { 'name' => 'phoneNumber'},
            { 'name' => 'organization'},
            { 'name' => 'email'},
            { 'name' => 'notes'},
            { 'name' => 'purchaseComplete'},
            { 'name' => 'hasCheckedIn'},
            { 'name' => 'transactionItemId'},
        ],
        isa   => [
            {   namespace => "Asset_Template",
                tag       => "template variables"
            },
        ],
        fields  => [],
        related => [],
    },

    'ems view badge template' => {
        source    => 'sub view',
        title     => 'view badge template',
        body      => '',
        variables => [
            { 'name' => 'error',
              'description' => 'ems view badge error' },
            { 'name' => 'addressBook'},
            { 'name' => 'formHeader',
              'required' => 1 },
            { 'name' => 'formFooter',
              'required' => 1 },
            { 'name' => 'name',
              'description'=> 'ems view badge name' },
            { 'name' => 'organization',
              'description'=> 'ems view badge organization' },
            { 'name' => 'address1',
              'description'=> 'ems view badge address1' },
            { 'name' => 'address2',
              'description'=> 'ems view badge address2' },
            { 'name' => 'address3',
              'description'=> 'ems view badge address3' },
            { 'name' => 'city',
              'description'=> 'ems view badge city' },
            { 'name' => 'state',
              'description'=> 'ems view badge state' },
            { 'name' => 'zipcode',
              'description'=> 'ems view badge zipcode' },
            { 'name' => 'country',
              'description'=> 'ems view badge country' },
            { 'name' => 'phoneNumber',
              'description'=> 'ems view badge phone' },
            { 'name' => 'email',
              'description'=> 'ems view badge email' },
            { 'name' => 'submitAddress',
              'description'=> 'ems view badge submitAddress' },
            { 'name' => 'title',
              'description'=> 'ems view badge title' },
            { 'name' => 'description',
              'description'=> 'ems view badge description' },
        ],
        isa   => [
            {   namespace => "Asset_Template",
                tag       => "template variables"
            },
        ],
        fields  => [],
        related => [],
    },

    'ems print ticket template' => {
        source    => 'sub www_printTicket',
        title     => 'print ticket template',
        body      => '',
        variables => [
            { 'name' => 'ticketTitle'},
            { 'name' => 'ticketStart'},
            { 'name' => 'ticketDuration'},
            { 'name' => 'ticketLocation'},
            { 'name' => 'ticketEventNumber'},
            { 'name' => 'badgeId'},
            { 'name' => 'badgeNumber'},
            { 'name' => 'badgeAssetId'},
            { 'name' => 'emsAssetId'},
            { 'name' => 'userId'},
            { 'name' => 'name'},
            { 'name' => 'address1'},
            { 'name' => 'address2'},
            { 'name' => 'address3'},
            { 'name' => 'city'},
            { 'name' => 'state'},
            { 'name' => 'zipcode'},
            { 'name' => 'country'},
            { 'name' => 'phoneNumber'},
            { 'name' => 'organization'},
            { 'name' => 'email'},
            { 'name' => 'notes'},
            { 'name' => 'purchaseComplete'},
            { 'name' => 'hasCheckedIn'},
            { 'name' => 'transactionItemId'},
        ],
        isa   => [
            {   namespace => "Asset_Template",
                tag       => "template variables"
            },
        ],
        fields  => [],
        related => [],
    },

    'ems print remaining ticket template' => {
        source    => 'sub www_printRemainingTickets',
        title     => 'print remaining ticket template help',
        body      => '',
        variables => [
            { 'name' => 'tickets_loop',
              'variables' => [
                { 'name' => 'ticketTitle'},
                { 'name' => 'ticketStart'},
                { 'name' => 'ticketDuration'},
                { 'name' => 'ticketLocation'},
                { 'name' => 'ticketEventNumber'},
                { 'name' => 'ticketMeta_[LABEL]'},
                { 'name' => 'seatsRemaining'},
                { 'name' => 'seatsAvailable'},
                { 'name' => 'price'},
                { 'name' => 'relatedRibbons'},
                { 'name' => 'relatedBadgeGroups'},
                { 'name' => 'eventMetaData'},
                { 'name' => 'title'},
                { 'name' => 'menuTitle'},
                { 'name' => 'url'},
                { 'name' => 'synopsis'},
                { 'name' => 'assetId'},
                { 'name' => 'assetSize'},
                { 'name' => 'creationDate'},
                { 'name' => 'encryptPage'},
                { 'name' => 'extraHeadTags'},
                { 'name' => 'extraHeadTagsPacked'},
                { 'name' => 'groupIdEdit'},
                { 'name' => 'groupIdView'},
                { 'name' => 'inheritUrlFromParent'},
                { 'name' => 'isExportable'},
                { 'name' => 'isHidden'},
                { 'name' => 'isPrototype'},
                { 'name' => 'isPackage'},
                { 'name' => 'lastModified'},
                { 'name' => 'newWindow'},
                { 'name' => 'ownerUserId'},
                { 'name' => 'revisedBy'},
                { 'name' => 'revisionDate'},
                { 'name' => 'skipNotification'},
                { 'name' => 'tagId'},
                { 'name' => 'usePackedHeadTags'},
              ],
            },
        ],
        isa   => [
            {   namespace => "Asset_EventManagementSystem",
                tag       => "ems asset template variables"
            },
            {   namespace => "Asset_Template",
                tag       => "template variables"
            },
            {   namespace => "Asset_Wobject",
                tag       => "wobject template variables"
            },
        ],
        fields  => [],
        related => [],
    },

    'ems asset template variables' => {
        source    => 'sub definition',
        title     => 'ems asset template variables',
        body      => '',
        variables => [
            {
                name        => 'timezone',
                description => 'timezone help',
            },
            {
                name        => 'templateId',
                description => 'templateId help',
            },
            {
                name        => 'badgeBuilderTemplateId',
                description => 'badgeBuilderTemplateId help',
            },
            {
                name        => 'lookupRegistrantTemplateId',
                description => 'lookupRegistrantTemplateId help',
            },
            {
                name        => 'printBadgeTemplateId',
                description => 'printBadgeTemplateId help',
            },
            {
                name        => 'printTicketTemplateId',
                description => 'printTicketTemplateId help',
            },
            {
                name        => 'badgeInstructions',
                description => 'badgeInstructions help',
            },
            {
                name        => 'ticketInstructions',
                description => 'ticketInstructions help',
            },
            {
                name        => 'ribbonInstructions',
                description => 'ribbonInstructions help',
            },
            {
                name        => 'tokenInstructions',
                description => 'tokenInstructions help',
            },
            {
                name        => 'registrationStaffGroupId',
                description => 'registrationStaffGroupId help',
            },
        ],
        fields  => [],
        related => [],
    },

};

1;    ##All perl modules must return true
