#include <math.h>

#include <qregexp.h>
#include <qpoint.h>
#include <stdlib.h>

#include "misc.h"

QString qpointToString (const QPoint &p)
{
	return "(" + QString("%1").arg(p.x()) +","+ QString ("%1").arg (p.y()) +")";
}

QString qpointfToString (const QPointF &p)
{
	return "(" + QString("%1").arg(p.x()) +","+ QString ("%1").arg (p.y()) +")";
}

ostream &operator<< (ostream &stream, QPoint const &p)
{ 
	stream << "("<<p.x()<<","<<p.y()<<")";
	return stream;
}

ostream &operator<< (ostream &stream, QPointF const &p)
{ 
	stream << "("<<p.x()<<","<<p.y()<<")";
	return stream;
}

qreal getAngle(const QPointF &p)
{	
	// Calculate angle of vector to y-axis
	if (p.y()==0)
	{
		if (p.x()>=0)
			return M_PI_2;
		else
			return 3* M_PI_2;
	} else
	{
		if (p.y()>0) 
			return (qreal)(M_PI  - atan ( (qreal)(p.x()) / (qreal)(p.y()) ) );
		else	
			if (p.x()<0)
				return (qreal)( 2*M_PI - atan ( (qreal)(p.x()) / (qreal)(p.y()) ) );
			else	
				return (qreal)( - atan ( (qreal)(p.x()) / (qreal)(p.y()) ) );
	}	
}

QPointF normalise(const QPointF &p)
{	
	// Calculate normalised position (fixed length) 

	qreal px=p.x();
	qreal py=p.y();
	qreal x;
	qreal y;
	qreal r=150;

	if (px==0)
	{
		x=0;
		if (py>=0)
			y=r;
		else
			y=-r;
	} else
	{
		qreal sign;
		qreal a;
		if (px>0) 
			sign=1; 
		else 
			sign=-1;
		
		a=atan (py / px);
		x=cos (a) * r *sign;
		y=sin (a) * r *sign;
	}	
	return QPoint ((int) (x),(int) (y));
}


// returns masked "<" ">" "&"
QString quotemeta(const QString &s)
{
	QString r=s;
    QRegExp  rx("&(?!amp;)");
    r.replace ( rx,"&amp;");
    rx.setPattern( ">");
    r.replace ( rx,"&gt;");
    rx.setPattern( "<");
    r.replace ( rx,"&lt;");
    rx.setPattern( "\"");
    r.replace ( rx,"&quot;");
    return r;
}


qreal max(qreal a, qreal b)
{
	if (a>b)
		return a;
	return b;
}

int xmlObj::actindent=0;		// make instance of actindent

xmlObj::xmlObj()
{
    indentwidth=4;
}


// returns <s at />
QString xmlObj::singleElement(QString s, QString at)
{
    return indent() + "<" + s +" " + at +" " + "/>\n";
}

// returns <s>
QString xmlObj::beginElement(QString s)
{
    return indent() + "<" + s + ">\n";
}

// returns <s at>
QString xmlObj::beginElement(QString s, QString at)
{
    return indent() + "<" + s + " " + at + ">\n";
}

// returns </s>
QString xmlObj::endElement(QString s)
{
    return indent() + "</" + s + ">\n";
}

// returns  at="val"
QString xmlObj::attribut(QString at, QString val)
{
    return " " + at + "=\"" + quotemeta (val) + "\""; 
}

// returns <s> val </s>
QString xmlObj::valueElement(QString el, QString val)
{
    return indent() + "<" + el + ">" + quotemeta(val) + "</" +el + ">\n";
}

// returns <s at> val </s>
QString xmlObj::valueElement(QString el, QString val, QString at)
{
    return indent() + "<" + el + " " + at + ">" + quotemeta(val) + "</" +el + ">\n";
}

void xmlObj::incIndent()
{
    actindent++;
}	

void xmlObj::decIndent()
{
    actindent--;
    if (actindent<0) actindent=0;
}	

QString xmlObj::indent()
{
    QString s;
    int i;
    for (i=0; i<actindent*indentwidth; i++)
    {
		s= s + " ";
    }
    return s;
}	

