
// fileview.h
// Copyright (c) 1998-2010 by The VoxBo Development Team

// This file is part of VoxBo
// 
// VoxBo is free software: you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
// 
// VoxBo is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with VoxBo.  If not, see <http://www.gnu.org/licenses/>.
// 
// For general information on VoxBo, including the latest complete
// source code and binary distributions, manual, and associated files,
// see the VoxBo home page at: http://www.voxbo.org/
// 
// original version written by Tom King

#ifndef FILEVIEW_H
#define FILEVIEW_H

#include "dir.h"
#include <qvariant.h>
#include <q3mainwindow.h>
//Added by qt3to4:
#include <Q3ActionGroup>
#include <Q3GridLayout>
#include <Q3HBoxLayout>
#include <Q3VBoxLayout>
#include <QLabel>
#include <Q3PopupMenu>
#include "vbprefs.h"
#include "vbpreplib.h"
#include <qmessagebox.h>
#include <qinputdialog.h>
#include <qvariant.h>
#include <qdialog.h>

class Q3HBox;
class Q3VBoxLayout;
class Q3HBoxLayout;
class Q3GridLayout;
class QAction;
class Q3ActionGroup;
class Q3ToolBar;
class Q3PopupMenu;
class Q3ButtonGroup;
class QLabel;
class QLineEdit;
class Q3ListView;
class Q3ListViewItem;
class QPushButton;
class QComboBox;

class fileview : public QDialog
{
  Q_OBJECT

public:
  fileview( QWidget* parent = 0, const char* name = 0, bool modal=false, Qt::WFlags fl = Qt::WType_TopLevel );
  ~fileview();

  QPushButton* pbDirectory;
  QLineEdit* leDirectory;
  QLineEdit* leFileNamePattern;
  Q3HBox* grpFileBorder;
  Q3ListView* lvFiles;
  void SetDirectory(string);
  void ShowImageInformation(bool x);
  void Go();
  void ShowDirectoriesAlso(bool x);
  static tokenlist ReturnFiles(); 
protected:
private:
  bool showdirs;
  bool okayed;
  string directory;
  int numSiblings();
  int numSelected();
  static tokenlist returnedFiles;
  tokenlist returnSelectedFiles();
signals:
  void doneSignal(tokenlist);
public slots:
  bool Okayed();
protected slots:
  void NoHandler();
  void Handler();
  void HandleUp();
  void HandleHome();
  void HandleRoot();
  void HandleNewWD();
  void Selected(Q3ListViewItem* item);
  void populateListBox();
  void Cancel();
  void grayDir();
};

#endif // FILEVIEW_H
