
// voxbo.h
// VoxBo headers
// Copyright (c) 1998,1999 by The VoxBo Development Team

// This file is part of VoxBo
// 
// VoxBo is free software: you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
// 
// VoxBo is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with VoxBo.  If not, see <http://www.gnu.org/licenses/>.
// 
// For general information on VoxBo, including the latest complete
// source code and binary distributions, manual, and associated files,
// see the VoxBo home page at: http://www.voxbo.org/
//
// original version written by Dan Kimberg

#include <stdio.h>
#include <math.h>
#include <sys/types.h>
#include <sys/wait.h>
#include <sys/stat.h>
#include <sys/signal.h>
#include <sys/socket.h>
#include <sys/utsname.h>
#include <sys/time.h>
#include <fcntl.h>
#include <unistd.h>
#include <dirent.h>
#include <stdlib.h>
#include <string.h>
#include <netdb.h>
#include <netinet/in.h>
#include <time.h>
#include <signal.h>
#include <errno.h>
#include <pwd.h>
#include <ctype.h>
#include <algorithm>
#include <vector>
#include <string>
#include <iostream>
#include <fstream>
// #include <sstream>
#include "vbutil.h"
#include "vbprefs.h"
#include "vbjobspec.h"

#define MAXFILENAME 128
#define MAXHOSTS 64                   // maximum number of eligible hosts
#define MAXFILES 512                  // maximum number of files in a job
#define MAXTAGLEN 32                  // maximum length of scan tag in chars

#ifndef STRINGLEN
#define STRINGLEN 512                 // used widely for lots of stuff
#endif

#ifndef TRUE
#define TRUE 1
#endif
#ifndef FALSE
#define FALSE 0
#endif

// FIXME this file is in serious disrepair

// VOXBO functions, declared here mostly for vbsingle

//int server_sleep(int s);
//int server_create();
int getvoxbolock();
void returnvoxbolock();
int reassignstdio(string &fname);
int find_voxbo_server(VBJobSpec &js,HI &myhost);
int send_voxbo_job(int socket,VBJobSpec *js,HI &myhost);
int run_job(VBJobSpec &js);
//void ping_hosts();
//void update_hostlist();

//void setjobinfo_update_hostlist(VBJobSpec newjs);

void process_vbx();
int process_jobrunning(int snum,int jnum,pid_t pid,pid_t childpid);
int process_setseqinfo(int ss,string newstatusinfo);
int process_killsequence(int ss,string newstatus);
int process_setjobinfo(int ss,int jj,string newstatusinfo);
int process_email(string recipient,string fname);
int process_adminemail(string fname);
int process_hostupdate(string hh);
int process_missing(int snum,int jnum,pid_t pid);
int process_retry(string line);
int do_retry(int snum,int jnum,int generations);
int process_saveline(string line);

//int send_email(string msg);
//VBSequence *findsequence(int snum);
//VBJobSpec *findjob(int snum,int jnum);

string handle_server_gimme(tokenlist &args,string username);
string handle_server_changejobstatus(tokenlist &args,string username);
string handle_server_setseqinfo(tokenlist &args,string username);
string handle_server_killsequence(tokenlist &args,string username);
void populate_running_jobs(map<int,VBSequence> &seqlist,vector<VBHost> &hostlist);

int haltsequence(tokenlist &args,string username);

int server_add(string shortname,string hostname);
int server_delete(string shortname);
void send_hosts(int ns);
void send_sequences(int ns);
void read_serverlist();
void print_diagnostics(string arg);
void vbscheduler_help();
void vbscheduler_version();

// VBHost *findhost(string hname);

void tell_scheduler(string buf);
int tell_scheduler(string msg,string &returnmsg);
