/*
** This file is part of the ViTE project.
**
** This software is governed by the CeCILL-A license under French law
** and abiding by the rules of distribution of free software. You can
** use, modify and/or redistribute the software under the terms of the
** CeCILL-A license as circulated by CEA, CNRS and INRIA at the following
** URL: "http://www.cecill.info".
** 
** As a counterpart to the access to the source code and rights to copy,
** modify and redistribute granted by the license, users are provided
** only with a limited warranty and the software's author, the holder of
** the economic rights, and the successive licensors have only limited
** liability.
** 
** In this respect, the user's attention is drawn to the risks associated
** with loading, using, modifying and/or developing or reproducing the
** software by the user in light of its specific status of free software,
** that may mean that it is complicated to manipulate, and that also
** therefore means that it is reserved for developers and experienced
** professionals having in-depth computer knowledge. Users are therefore
** encouraged to load and test the software's suitability as regards
** their requirements in conditions enabling the security of their
** systems and/or data to be ensured and, more generally, to use and
** operate it in the same conditions as regards security.
** 
** The fact that you are presently reading this means that you have had
** knowledge of the CeCILL-A license and that you accept its terms.
**
**
** ViTE developpers are (for version 0.* to 1.0):
**
**        - COULOMB Kevin
**        - FAVERGE Mathieu
**        - JAZEIX Johnny
**        - LAGRASSE Olivier
**        - MARCOUEILLE Jule
**        - NOISETTE Pascal
**        - REDONDY Arthur
**        - VUCHENER Clément 
**
*/
/*!
 *\file Parser.hpp
 *\brief This file contains the abstract layer for the parser.
 */

#ifndef PARSER_HPP
#define PARSER_HPP

#include <string>
#include "../trace/Trace.hpp"

#ifndef VITE_DEBUG
  #include "../message/Errors.hpp"
#else
// For debugging
  #include "../../tests/stubs/Errors.hpp"
#endif

/*! 
 * \class Parser Parser.hpp "../parser/src/Parser.hpp"
 * \brief Contains the definition of the parser interface.
 */

class Parser{

public:
    /*!
     *  \fn parse(std::string filename, Trace &trace) = 0
     *  \param filename the name of the file to parse
     *  \param trace the structure of data to fill
     */
    virtual void parse(std::string filename, Trace &trace) = 0;
    virtual ~Parser() {};


    /*!
     *  \fn const int get_size_loaded() const = 0;
     *  \return the scale of the size already loaded of the file by the parser. (between 0 and 1)
     */
    virtual float get_size_loaded() const = 0;
    
    /*!
     *  \fn is_end_of_parsing() const
     *  \brief true is the parsing is finished
     *  \return boolean
     */
    virtual bool is_end_of_parsing() const = 0;
};

#endif // PARSER_HPP
