/*
** This file is part of the ViTE project.
**
** This software is governed by the CeCILL-A license under French law
** and abiding by the rules of distribution of free software. You can
** use, modify and/or redistribute the software under the terms of the
** CeCILL-A license as circulated by CEA, CNRS and INRIA at the following
** URL: "http://www.cecill.info".
** 
** As a counterpart to the access to the source code and rights to copy,
** modify and redistribute granted by the license, users are provided
** only with a limited warranty and the software's author, the holder of
** the economic rights, and the successive licensors have only limited
** liability.
** 
** In this respect, the user's attention is drawn to the risks associated
** with loading, using, modifying and/or developing or reproducing the
** software by the user in light of its specific status of free software,
** that may mean that it is complicated to manipulate, and that also
** therefore means that it is reserved for developers and experienced
** professionals having in-depth computer knowledge. Users are therefore
** encouraged to load and test the software's suitability as regards
** their requirements in conditions enabling the security of their
** systems and/or data to be ensured and, more generally, to use and
** operate it in the same conditions as regards security.
** 
** The fact that you are presently reading this means that you have had
** knowledge of the CeCILL-A license and that you accept its terms.
**
**
** ViTE developpers are (for version 0.* to 1.0):
**
**        - COULOMB Kevin
**        - FAVERGE Mathieu
**        - JAZEIX Johnny
**        - LAGRASSE Olivier
**        - MARCOUEILLE Jule
**        - NOISETTE Pascal
**        - REDONDY Arthur
**        - VUCHENER Clément 
**
*/
#include "Line.hpp"

using namespace std;

Line::Line(){
    _line_count = 0;
}

Line::Line(Line &){
}

Line::Line(string &filename){
    open(filename.c_str());
}


Line::~Line(){
    if(!_tokens.empty()){
        _tokens.clear();
    }
}

void Line::open(const char *filename){
    _line_count = 0;
    _source.open(filename);
    _is_eof = false;
}

void Line::print() const{
    const unsigned int token_size = _tokens.size();
    cout << "-" ;
    for(unsigned int i = 0 ; i < token_size ; i ++)
        cout << _tokens[i] << " " ;
    cout << "-" << endl;
}

bool Line::starts_with(const string &s) const{
    if(!_tokens.empty())
        return _tokens[0] == s;
    else // tokens is empty
        return false;
}

bool Line::item(unsigned int i, string &e) const{
    if (i >= _tokens.size())
        return false;
    e = _tokens[i];
    return true;
}

unsigned int Line::length() const{
    return _tokens.size();
}

void Line::clear(){
    _tokens.clear();
}

bool Line::is_eof() const{
    return _is_eof;
}

void Line::newline(){
    if(!_tokens.empty()){
        clear();
    }
    string *tok;
    
    _line_count++;
    while ((tok = _source.read_token()) != NULL){

        if (*tok == "\n"){
            return;
        }
        _tokens.push_back(*tok);
    }
    _is_eof = true;
}

unsigned int Line::get_line_count() const{
    return _line_count;
}
