#!/usr/bin/python
# -*- coding: utf-8 -*-

# This file is part of Videoporama
# Videoporama is a program to make diaporama export in video file
# Copyright (C) 2007-2009  Olivier Ponchaut <opvg@edpnet.be>

# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License along
# with this program; if not, write to the Free Software Foundation, Inc.,
# 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.

import sys
import os
from subprocess import *
from xml.dom import minidom
from xml.dom.minidom import Document
from process import *
from PyQt4.QtCore import *
from PyQt4.QtGui import *
from __builtin__ import hex as hexp
from interface import *
from main_win import *
from statusconf import *
from about import *
from firsttime import *
if os.name == 'nt' :
  from configuration_win import *
else :
  from configuration import *

class videoporama :
    index=-1
    def __init__(self,args):
      z=self.checkfirsttime(args)
      self.home=os.path.expanduser("~")
      self.lastdir=self.home
      # Qt application 
      self.qtapp=QApplication(args)
      locale = QLocale.system().name()      
      qtTranslator = QTranslator()
      if qtTranslator.load(u"./locale/videoporama_"+unicode(locale[0:2])+u".qm") :
        self.qtapp.installTranslator(qtTranslator)
      # Difference between Posix and Nt plateforme
      if os.name == 'nt' :
        actionButton="triggered()"
        self.configFile=u'idv_config_win.xml'
      else :
        actionButton="activated()"
        self.configFile=u'idv_config.xml'

      # Main windows 
      self.win=Gui_Main()
      self.win.statusbar.showMessage(self.qtapp.translate("main","Ready"))
      self.win.timeline.horizontalHeader().hide()
      self.win.timeline.verticalHeader().hide()
      self.win.timeline.setRowCount(1)
      self.win.timeline.setRowHeight(0,75)
      self.win.actionRemove.setDisabled(True)
      self.win.actionEmpty.setDisabled(True)
      self.win.actionMove_left.setDisabled(True)
      self.win.actionMove_right.setDisabled(True)
      self.win.serie.setDisabled(True)
      self.pfilee=0
      self.saveas=0
      self.index=-1
      sizes=QFontDatabase.standardSizes()
      Ssizes=QStringList()
      for size in sizes :
        Ssizes.append(str(size))
      self.win.fontSize.insertItems(0,Ssizes)
      self.win.fontSize.setCurrentIndex(6)
      FD=QFont(self.win.fontComboBox.currentText(),int(self.win.fontSize.currentText()))
      self.changeFont(FD)
      bckcol=QPalette()
      bckcol.setColor(QPalette.Base,Qt.black)
      self.win.fontColor.setPalette(bckcol)

      ### Check ffmpeg and sox abilities
      self.fmsg = 0
      self.msgffmpeg = QStringList()
      self.listformats = QStringList()
      self.convertformat = []
      
      f = subprocess.Popen("ffmpeg -version", shell=True, stdout=subprocess.PIPE, stderr=subprocess.PIPE)
      
      self.ffmpeglib=[[0,"raw","RAW DV (dv)",""],[1,"VCD","VCD",""],[2,"SVCD","SVCD",""],[3,"DVD","DVD",""],[4,"flv","Flash FLV",""],[5,"libtheora","Theora (ogg)","--enable-libtheora"],[6,"mjpeg","MJPEG (avi)",""],[7,"libxvid","Xvid (avi)","--enable-libxvid"],[8,"libx264","H264 (avi)","--enable-libx264"]]

      verffmpeg = f.communicate()[1]
      for ff in self.ffmpeglib :
        if verffmpeg.find(ff[3]) == -1 :
          self.fmsg = 1
          self.msgffmpeg.append(self.qtapp.translate("main","The ffmpeg package installed don't include %1 and isn't able to encode in %2. This format will be disable in the user interface.").arg(QString(ff[1])).arg(QString(ff[2])))
        else :
          self.win.outputfileformat.addItem(ff[2])
          self.listformats.append(ff[2])       
          self.convertformat.append((ff[0],ff[2]))
      s = subprocess.Popen("sox -h", shell=True, stdout=subprocess.PIPE, stderr=subprocess.PIPE).communicate()[0]
      self.soxErr=[1,1,1]
      self.msgsox = [u"",u"",u""]
      if s.find("wav") == -1 :
        self.soxErr[0] = 0
        self.msgsox[0] = self.qtapp.translate("main","Wav Format is not supported by your version of Sox. Add required package from your distribution unless you won't be able to make video.")
      if s.find("ogg") == -1 :
        self.soxErr[1] = 0
        self.msgsox[1] = self.qtapp.translate("main","Ogg Format is not supported by your version of Sox. Add required package from your distribution unless you won't be able to use ogg sound file.")
        #print "Format OGG non supporté par sox"
      if s.find("mp3") == -1 :
        self.soxErr[2] = 0
        self.msgsox[2] = self.qtapp.translate("main","Mp3 Format is not supported by your version of Sox. Add required package from your distribution unless you won't be able to use mp3 sound file.")
        #print "Format MP3 non supporté par sox"

      # Loading configuration data
      fo=open(self.templatedir+self.configFile,'r')
      # Import configurations data from xml file
      self.config=minidom.parse(fo)
      fo.close()
      try :
        self.T=self.config.getElementsByTagName('tmpdir')[0].childNodes[0].nodeValue+"/"
      except :
        self.T=self.home
      if not self.T.endswith(u"/") :
        self.T=self.T+os.sep
      try:
        self.I=self.config.getElementsByTagName('imgmgkdir')[0].childNodes[0].nodeValue
      except:
        self.I=""
      if not self.I.endswith(u"/") :
        self.I=self.I+os.sep
      # Load template data
      fo=open(self.templatedir+u'template_data.idv','r')
      # Import configurations data from xml file
      self.datat=minidom.parse(fo)
      fo.close()
          
      # Create transition list
      self.LstTransi()
      self.win.typet.addItems(self.lstT)
      self.win.transiopt.addItem(self.qtapp.translate("main","No Option"))
      # Display default values and configs
      self.affichedata(self.templatedir+u'template_data.idv')
      # Display main window
      self.win.show()

      message = u""
      if z :
        message = message + self.qtapp.translate("main","Configuration files hasn't been found \nUser configuration has been created at ")+self.templatedir+self.qtapp.translate("main","\nDon't forget to check the configuration \nAnd to define the temporary directory \n(Edit -> Configuration) \n")        

      if int(self.config.getElementsByTagName('chk')[0].childNodes[0].nodeValue)!=2 :
        self.verifconfig()

      if z == 1 or self.fmsg == 1 or self.soxErr[0] == 0 or self.soxErr[1] == 0 or self.soxErr[2] == 0 :
        self.firsttime=FirstTime(self.win)
        message = message + unicode(self.msgffmpeg.join("\n")) +u"\n"+ self.msgsox[0]+u"\n"+self.msgsox[1]+u"\n"+self.msgsox[2]
        
        self.firsttime.info.setText(message)
        self.firsttime.show()
        self.firsttime.connect(self.firsttime.ok,SIGNAL("clicked()"),self.firsttime,SLOT("close()"))


      
      # Qt SLOT/SIGNAL connection
      self.qtapp.connect(self.win.actionSave_As,SIGNAL(actionButton),self.saveasprojet)
      self.qtapp.connect(self.win.action_Exit,SIGNAL(actionButton),self.cleanexit)
      self.qtapp.connect(self.win.action_About,SIGNAL(actionButton),self.about)
      self.qtapp.connect(self.qtapp, SIGNAL("lastWindowClosed()"),self.cleanexit)
      self.qtapp.connect(self.win.action_New,SIGNAL(actionButton),self.newprojet)
      self.qtapp.connect(self.win.action_Open,SIGNAL(actionButton),self.openprojet)
      self.qtapp.connect(self.win.action_Save,SIGNAL(actionButton),self.saveprojet)
      self.qtapp.connect(self.win.actionConfiguration,SIGNAL(actionButton),self.conf)
      self.qtapp.connect(self.win.actionAdd,SIGNAL(actionButton),self.add)
      self.qtapp.connect(self.win.bgcolor,SIGNAL("lostFocus()"),self.chbgcolor)
      self.qtapp.connect(self.win.bgfile,SIGNAL("lostFocus()"),self.chbgfile)
      self.qtapp.connect(self.win.bgcolora,SIGNAL("clicked()"),self.bgcolora)
      self.qtapp.connect(self.win.soundfile,SIGNAL("lostFocus()"),self.chsndfile)
      self.qtapp.connect(self.win.bgfilea,SIGNAL("clicked()"),self.bgfilea)
      self.qtapp.connect(self.win.soundfilea,SIGNAL("clicked()"),self.sndfilea)
      self.qtapp.connect(self.win.typet,SIGNAL("currentIndexChanged(int)"),self.chgTrOption)
      self.qtapp.connect(self.win.transiopt,SIGNAL("currentIndexChanged(int)"),self.chgopttransi)
      self.qtapp.connect(self.win.time,SIGNAL("valueChanged(int)"),self.chtime)
      self.qtapp.connect(self.win.actionMove_right,SIGNAL(actionButton),self.up)
      self.qtapp.connect(self.win.actionMove_left,SIGNAL(actionButton),self.down)
      self.qtapp.connect(self.win.actionRemove,SIGNAL(actionButton),self.delete)
      self.qtapp.connect(self.win.actionEmpty,SIGNAL(actionButton),self.empty)
      self.qtapp.connect(self.win.outputfilea,SIGNAL("clicked()"),self.outputfile)
      self.qtapp.connect(self.win.outputfile,SIGNAL("editingFinished()"),self.choutputfile)
      self.qtapp.connect(self.win.timeline,SIGNAL("itemSelectionChanged()"),self.selectionListe)
      self.qtapp.connect(self.win.imgformat,SIGNAL("activated(int)"),self.setImgFormat)
      self.qtapp.connect(self.win.videof,SIGNAL("activated(int)"),self.choixvideof)
      self.qtapp.connect(self.win.outputfileformat,SIGNAL("activated(int)"),self.choixoutputformat)
      self.qtapp.connect(self.win.speedt,SIGNAL("activated(int)"),self.choixspeedt)
      self.qtapp.connect(self.win.start,SIGNAL("clicked()"),self.process)
      self.qtapp.connect(self.win.fontComboBox,SIGNAL("currentFontChanged(QFont)"),self.changeFont)
      self.qtapp.connect(self.win.bold,SIGNAL("released()"),self.setBold)
      self.qtapp.connect(self.win.Italic,SIGNAL("released()"),self.setItalic)
      self.qtapp.connect(self.win.Souligne,SIGNAL("released()"),self.setUnderline)
      self.qtapp.connect(self.win.fontColorB,SIGNAL("pressed()"),self.setTextColor)
      self.qtapp.connect(self.win.textLeft,SIGNAL("pressed()"),self.setTextLeft)
      self.qtapp.connect(self.win.textCenter,SIGNAL("pressed()"),self.setTextCenter)
      self.qtapp.connect(self.win.textRight,SIGNAL("pressed()"),self.setTextRight)
      self.qtapp.connect(self.win.addText,SIGNAL("pressed()"),self.addTextToImage)
      #self.qtapp.connect(self.win.angle,SIGNAL("valueChanged(int)"),self.rotateText)
      self.qtapp.connect(self.win.option,SIGNAL("currentChanged(int)"),self.setTabZoom)
      self.qtapp.connect(self.win.updateText,SIGNAL("pressed()"),self.updateTextImage)
      self.qtapp.connect(self.win.deleteText,SIGNAL("pressed()"),self.deleteTextImage)
      self.qtapp.connect(self.win.emptyText,SIGNAL("pressed()"),self.emptyText)
      self.qtapp.connect(self.win.fontSize,SIGNAL("currentIndexChanged(QString)"),self.changeSizeFont)
      self.qtapp.connect(self.win.textEdit,SIGNAL("currentCharFormatChanged(QTextCharFormat)"),self.updateFont)
      self.qtapp.connect(self.win.chkZoom,SIGNAL("stateChanged(int)"),self.chkZoomAction)
      self.qtapp.connect(self.win.validZoom,SIGNAL("pressed()"),self.validZoomAction)
      self.qtapp.connect(self.win.startZoomSize,SIGNAL("valueChanged(int)"),self.startZoomSize)
      self.qtapp.connect(self.win.endZoomSize,SIGNAL("valueChanged(int)"),self.endZoomSize)
      self.qtapp.connect(self.win.startPreview,SIGNAL("pressed()"),self.preview)
      self.qtapp.connect(self.win.serie,SIGNAL(actionButton),self.serie)
      self.qtapp.connect(self.win.actionVideo_player,SIGNAL(actionButton),self.mplayerview)
     
      self.qtapp.exec_()
 
    def mplayerview(self) :
      self.mpview = Mplayer(taille=(400,300), choixWidget=(Mplayer.PAS_PRECEDENT_SUIVANT,Mplayer.CURSEUR_A_PART,Mplayer.PARCOURIR))
      self.mpview.setWindowTitle(self.qtapp.translate("main","Video Player"))
      self.mpview.show()

    def validZoomAction(self) :
      if (self.index != -1) :
        scene=self.win.preview.scene()
        item=self.win.timeline.cellWidget(0,self.index).selectZoomBox(1)
        item2=self.win.timeline.cellWidget(0,self.index).selectZoomBox(0)
        if self.win.imgformat.currentIndex() == 0 :
          a=120
        else :
          a=90
        dessin=QPixmap(160,a)
        dessin2=QPixmap(160,a)
        if (item != None and item2 != None) :
          item.hide()
          item2.hide()
          scene.render(QPainter(dessin),QRectF(0,0,160,a),item.sceneBoundingRect()) 
          self.win.startZoomView.setPixmap(dessin)
          scene.render(QPainter(dessin2),QRectF(0,0,160,a),item2.sceneBoundingRect()) 
          self.win.endZoomView.setPixmap(dessin2)
          item.show()
          item2.show()
                  
    def startZoomSize(self,zoom) :
      if (self.index != -1) :
        scene=self.win.preview.scene()
        item=self.win.timeline.cellWidget(0,self.index).selectZoomBox(1)
        try :
          wcdr=scene.width()*zoom/100
          hcdr=wcdr*self.imgheight/self.imgwidth
          item.setRect(0,0,wcdr,hcdr)
        except :
          None

    def endZoomSize(self,zoom) :
      if (self.index != -1) :
        scene=self.win.preview.scene()
        item=self.win.timeline.cellWidget(0,self.index).selectZoomBox(0)
        try :
          wcdr=scene.width()*zoom/100
          hcdr=wcdr*self.imgheight/self.imgwidth
          item.setRect(0,0,wcdr,hcdr)
        except :
          None

    def chkZoomAction(self,chk) :
      if (self.index != -1) :
        image=self.win.timeline.cellWidget(0,self.index)
        image.setChkZoom(chk)
        if (chk==0 and image.selectZoomBox(1)!=None and image.selectZoomBox(0)!=None) :
          image.composeZoom.removeItem(image.selectZoomBox(1))
          image.composeZoom.removeItem(image.selectZoomBox(0))
        else :
          if (image.selectZoomBox(1)==None and image.selectZoomBox(0)==None) :
            wcdr=image.composeZoom.width()*self.win.startZoomSize.value()/100
            hcdr=wcdr*self.imgheight/self.imgwidth
            image.setZoomBox(0,0,wcdr,hcdr,1)
            wcdr=image.composeZoom.width()*self.win.endZoomSize.value()/100
            hcdr=wcdr*self.imgheight/self.imgwidth
            image.setZoomBox(0,0,wcdr,hcdr,0)
 
    def setTabZoom(self,n) :
      if (self.index != -1) :
        image=self.win.timeline.cellWidget(0,self.index)
        if n==3 :
          scene=image.setZoom()
          self.win.preview.setScene(scene)
          self.win.preview.show()
          self.win.preview.fitInView(scene.sceneRect(),Qt.KeepAspectRatio)
          self.win.preview.setInteractive(True)
          self.win.preview.setDragMode(QGraphicsView.ScrollHandDrag)
          self.validZoomAction()
        else :
          self.win.preview.setScene(image.Qscene())
          self.win.preview.show()
          self.win.preview.fitInView(0,0,self.imgwidth,self.imgheight,Qt.KeepAspectRatio)
 
    def changeFont(self,font) :
      self.win.textEdit.setFocus()
      self.win.textEdit.setCurrentFont(font)
      self.setItalic()
      self.setBold()
      self.setUnderline()
      self.changeSizeFont(self.win.fontSize.currentText())
      
    def changeSizeFont(self,size) :
      self.win.textEdit.setFocus()
      self.win.textEdit.setFontPointSize(int(size))
  
    def setItalic(self) :
      state=self.win.Italic.isChecked()
      self.win.textEdit.setFocus()
      self.win.textEdit.setFontItalic(state)
      
    def setBold(self) :
      state=self.win.bold.isChecked()
      self.win.textEdit.setFocus()
      if state :
        self.win.textEdit.setFontWeight(75)
      else :
        self.win.textEdit.setFontWeight(50)
    
    def setUnderline(self) :
      state=self.win.Souligne.isChecked()
      self.win.textEdit.setFocus()
      self.win.textEdit.setFontUnderline(state)
      
    def setTextLeft(self) :
      if (not self.win.textLeft.isChecked()) :
        self.win.textCenter.setChecked(0)
        self.win.textRight.setChecked(0)
        self.win.textEdit.selectAll()
        self.win.textEdit.setAlignment(Qt.AlignLeft)
      else :
        self.win.textLeft.setChecked(0)
      
    def setTextCenter(self) :
      self.win.textLeft.setDown(0)
      self.win.textCenter.setDown(1)
      self.win.textRight.setDown(0)
      self.win.textEdit.selectAll()
      self.win.textEdit.setAlignment(Qt.AlignCenter)
      
    def setTextRight(self) :
      self.win.textLeft.setDown(0)
      self.win.textCenter.setDown(0)
      self.win.textRight.setDown(1)
      self.win.textEdit.selectAll()
      self.win.textEdit.setAlignment(Qt.AlignRight)
      
    def setTextColor(self) :
      colorb=QColorDialog.getColor(Qt.black,self.win)
      self.win.textEdit.setFocus()
      self.win.textEdit.setTextColor(colorb)
      bckcol=QPalette()
      bckcol.setColor(QPalette.Base,colorb)
      self.win.fontColor.setPalette(bckcol)
      
    def addTextToImage(self) :
      try :
        self.win.preview.setInteractive(True)
        self.win.preview.setDragMode(QGraphicsView.ScrollHandDrag)
        scene=self.win.preview.scene()
        text=QGraphicsTextItem()
        text.setHtml(self.win.textEdit.toHtml())
        text.scale(self.win.timeline.cellWidget(0,self.index).txtzoom,self.win.timeline.cellWidget(0,self.index).txtzoom)
        text.setTextWidth(self.win.timeline.cellWidget(0,self.index).txtwide)
        text.setZValue(101)
        text.setAcceptDrops(1)
        text.setFlags(QGraphicsItem.ItemIsMovable | QGraphicsItem.ItemIsSelectable)
        data=QVariant("Texte")
        text.setData(0,data)
        scene.addItem(text)
        self.win.timeline.cellWidget(0,self.index).updatePix()
      except :
        None

    def updateTextImage(self) :
      try :
        item = self.win.timeline.cellWidget(0,self.index).selectItem()
        if item != None :
          item.setHtml(self.win.textEdit.toHtml())
          self.win.timeline.cellWidget(0,self.index).updatePix()
      except :
        None

    def deleteTextImage(self) :
      try :
        item = self.win.timeline.cellWidget(0,self.index).selectItem()
        if item != None :
          self.win.preview.scene().removeItem(item)
          self.win.timeline.cellWidget(0,self.index).updatePix()
      except :
        None
        
    def displayEditText(self) :
      try :
        item = self.win.timeline.cellWidget(0,self.index).selectItem()
        if item != None :
          self.win.textEdit.setHtml(item.toHtml())
      #self.win.timeline.cellWidget(0,self.index).updatePix()
      except :
        None

    def emptyText(self) :
      self.win.textEdit.clear()
        
    def rotateText(self,angle) :
      item = self.win.timeline.cellWidget(0,self.index).selectItem()
      if item != None :
        item.rotate(angle)
        self.win.timeline.cellWidget(0,self.index).updatePix()
        
    def updateFont(self,x=0) :
      font=self.win.textEdit.currentFont()
      self.win.fontComboBox.setEditText(font.family())
      i=self.win.fontSize.findText(str(int(font.pointSize())))
      self.win.fontSize.setCurrentIndex(i)
      self.win.Italic.setDown(x.fontItalic())
      self.win.Souligne.setDown(x.fontUnderline())
      if x.fontWeight() >= 63 :
        b=1
      else :
        b=0
      self.win.bold.setDown(b)
      
    ### First time open function ###
    def checkfirsttime(self,p) : #OK QT4
      a, b, c, d = 0, 0, 0, 0
      pathname = os.path.dirname (sys.argv[0])
      refdir = os.getcwdu() + u"/template/"  #unicode(os.path.abspath (pathname))
      print p[1]
      if p[1]=="-o" :
        h=os.path.expanduser("~")
        self.templatedir=h+"/.videoporama/"
      else :
        self.templatedir=refdir
              
      if (not os.path.exists(self.templatedir)) :
        print "Configuration directory doesn't exist"
        print "Create configuration directory at "+self.templatedir
        commands.getstatusoutput("mkdir "+self.templatedir)
      if (not os.path.exists(self.templatedir+"/idv_config.xml")) :
        c=1
        a=commands.getstatusoutput("cp "+refdir+"idv_config.xml "+self.templatedir+u"idv_config.xml")
      if (not os.path.exists(self.templatedir+"/template_data.idv")) :
        d=1
        b=commands.getstatusoutput("cp "+refdir+"template_data.idv "+self.templatedir+"template_data.idv")
      if (c or d) :
        print "Configuration files not find (First time open ?)"
        if (a==c and b==d) :
          return False
        else :
          return True
      else :
        return False
       
    ### About section ###
    def about(self) :
      aboutw=About(self.win)
      aboutw.show()
      self.qtapp.connect(aboutw.closeabout,SIGNAL("clicked()"),aboutw,SLOT("close()"))
    
    ### GUI_main - source files section ###
    def cleanexit(self): # Function to clean temporary directory before exiting application
      for file in os.listdir(unicode(self.T).encode('utf-8')) :                     
        if QString(file).endsWith(u".ppm") and QString(file).startsWith(u"img_") :
          os.remove(unicode(self.T).encode('utf-8')+os.sep+file)
        if file == u"black.ppm".encode('utf-8') or file == u"audio.tmp.wav".encode('utf-8') :
          os.remove(unicode(self.T).encode('utf-8')+os.sep+file)
      self.qtapp.quit()
      
    def selectionListe(self): # Function to display selected image - QT4 OK
      self.index = self.win.timeline.currentColumn()
      self.setTabZoom(self.win.option.currentIndex())
      image=self.win.timeline.cellWidget(0,self.index)
      try :
        optt=int(image.opttransi)
        self.win.typet.setCurrentIndex(int(image.typet))
        self.win.bgcolor.setText(self.colortohex(image.bgcolor))
        self.chbgcolor()
        self.win.bgfile.setText(image.bgfile)
        self.win.time.setValue(int(image.time))
        self.win.speedt.setCurrentIndex(int(image.speedt))
        self.win.transiopt.setCurrentIndex(optt)
        self.win.chkZoom.setChecked(image.zoom)
      except :
        None

      if self.index == 0 :
        self.win.actionMove_left.setDisabled(True)
      else :
        self.win.actionMove_left.setEnabled(True)
      if self.index == (self.win.timeline.columnCount()-1) :
        self.win.actionMove_right.setDisabled(True)
      else :
        self.win.actionMove_right.setEnabled(True)
      self.win.actionRemove.setEnabled(True)
        
    def displayLenght(self) : #QT4 OK
      self.totimage=0
      if self.win.videof.currentText()=="NTSC" :
        self.n=1
        imgpsec=30
        ips=float(30000/1001)
      else :
        self.n=0
        imgpsec=25
        ips=imgpsec
      dicspeed={"0":1,"1":2,"2":4,"3":5,"4":10,"5":20}
      speedtrans=dicspeed[str(self.config.getElementsByTagName('speedt')[0].childNodes[0].nodeValue)]
      frametransition = 100 / speedtrans
      k=0
      while k<self.win.timeline.columnCount() :
        self.totimage += self.win.timeline.cellWidget(0,k).imagetime(self.n)[1]+self.win.timeline.cellWidget(0,k).imagetime(self.n)[2]
        k+=1
      self.totimage+=frametransition

      sec=float(self.totimage) / ips
      seconde=str(sec % 60).split(".")
      minute=int(sec / 60)
      heure=int(minute / 60)
      timesnd="%s:%s:%s.%s" % (str(heure).rjust(2,'0'),str(minute).rjust(2,'0'),seconde[0].rjust(2,'0'),seconde[1].ljust(3,'0')[0:3])
      self.win.duration.setText(timesnd)

    def findDir(self,urlfile) :
      sl=urlfile.split("/")
      if not sl.isEmpty() :
        sl.removeAt(len(sl)-1)
      dirl=sl.join("/")
      return dirl+"/"

    def add(self): #QT4 OK
      files=QFileDialog.getOpenFileNames(self.win,self.qtapp.translate("main","File Dialog"),self.lastdir, "Images(*.jpg *.JPG *.png *.PNG *.gif *.GIF *.xpm *.XPM)")
      self.win.repaint()
      try :
        self.lastdir=self.findDir(files[0])
      except :
        None
      try :
        bgf=self.config.getElementsByTagName('bgfile')[0].childNodes[0].nodeValue
      except :
        bgf=""
      for file in files :
        k=self.win.timeline.columnCount()
        if file != "" :
          self.DisplayThumb(file,k,
            self.config.getElementsByTagName('time')[0].childNodes[0].nodeValue,
            bgf,
            self.config.getElementsByTagName('bgcolor')[0].childNodes[0].nodeValue,
            self.config.getElementsByTagName('typet')[0].childNodes[0].nodeValue,
            0,
            self.config.getElementsByTagName('speedt')[0].childNodes[0].nodeValue)
      if self.win.timeline.columnCount() != 0 :
        self.win.serie.setEnabled(True)
        self.win.actionEmpty.setEnabled(True)
      self.displayLenght()
      
    def DisplayThumb(self,file,col,time=1,bgfile="",bgcolor=0,typet=0,opttransi=0,speedt=3,zoom=0) : #QT4 OK
      compose=QGraphicsScene()
      compose.setSceneRect(0, 0, self.imgwidth, self.imgheight)
      if bgfile != "" :
        bkgpix = QPixmap(bgfile)
        bgim = compose.addPixmap(bkgpix.scaled(self.imgwidth,self.imgheight,Qt.IgnoreAspectRatio,Qt.SmoothTransformation))
        bgim.setData(0,QVariant(QString("backgroundi")))
      else :
        bgim=compose.addRect(0,0,self.imgwidth,self.imgheight,QPen(Qt.NoPen),QBrush(self.toqcolor(bgcolor)))
        bgim.setData(0,QVariant(QString("backgroundc")))
      bgim.setZValue(1)  
      pix=QPixmap(file)
      im=compose.addPixmap(pix.scaled(self.imgwidth,self.imgheight,Qt.KeepAspectRatio,Qt.SmoothTransformation))
      im.setData(0,QVariant(QString("image")))
      we=im.pixmap().width()
      hi=im.pixmap().height()
      im.setZValue(20)
      im.setPos((self.imgwidth-we)/2,(self.imgheight-hi)/2)
      
      self.qtapp.connect(compose,SIGNAL("selectionChanged ()"),self.displayEditText)
      pixl=myLabel(file,compose,col,time,bgfile,bgcolor,typet,opttransi,speedt,self.imgformat,0,self.win.videof.currentIndex())
      self.win.timeline.insertColumn(col)
      self.win.timeline.setColumnWidth(col,pixl.wpix)
      self.win.timeline.setCellWidget(0,col,pixl)
      self.win.repaint()
      return compose
      
    def getTrOptionLst(self,tr) : #OK QT4
      LS=QStringList()
      if tr < 4 :
        LS.append(self.qtapp.translate("main","No Option"))
      elif tr >= 4 and tr < 7 :
        LS.append(self.qtapp.translate("main","Left2Right"))
        LS.append(self.qtapp.translate("main","Right2Left"))
        LS.append(self.qtapp.translate("main","Top2Bottom"))
        LS.append(self.qtapp.translate("main","Bottom2Top"))
      elif tr == 7 :
        b=os.listdir(os.getcwd()+"/luma/")
        for c in b :
          d=os.path.splitext(c)
          LS.append(d[0])
      return LS
 
    def LstTransi(self): #QT4 OK
      self.lstT=QStringList()
      self.lstT.append(self.qtapp.translate("main","None"))
      self.lstT.append(self.qtapp.translate("main","Fade"))
      self.lstT.append(self.qtapp.translate("main","Appear"))
      self.lstT.append(self.qtapp.translate("main","Disappear"))
      self.lstT.append(self.qtapp.translate("main","Slide"))
      self.lstT.append(self.qtapp.translate("main","Cube"))
      self.lstT.append(self.qtapp.translate("main","Push"))
      self.lstT.append(self.qtapp.translate("main","Luma"))
    
    def chgTrOption(self,index) : #OK QT4
      try :
        z=self.getTrOptionLst(index)
        self.win.transiopt.clear()
        self.win.transiopt.addItems(z)
        self.win.timeline.cellWidget(0,self.index).typet=index
        self.displayLenght()
      except :
        None
    
    def choutputfile(self): #OK QT4
      of=self.win.outputfile.text()
      if not of.isEmpty() :
        if of.startsWith(u"~/") :
          of.replace(0,1,self.home)
          self.win.outputfile.setText(of)
        if not of.startsWith(u"/") :
          of=self.T+of
          self.win.outputfile.setText(of)
      self.updatexml(self.data,"outputfile",unicode(self.win.outputfile.text()))
      
    def outputfile(self): #OK QT4
      file=QFileDialog.getSaveFileName(self.win, self.qtapp.translate("main","File Dialog"),self.home, "")
      self.win.outputfile.setText(file)
      self.updatexml(self.data,"outputfile",unicode(file))
      
      
    def empty(self): #OK QT4
      i=0
      while i<self.win.timeline.columnCount() :
        self.win.timeline.removeColumn(i)
      self.win.preview.hide()
      self.win.bgfile.clear()
      self.win.bgcolor.clear()
      self.displayLenght()
      self.win.serie.setDisabled(True)
      self.win.actionMove_left.setDisabled(True)
      self.win.actionMove_right.setDisabled(True)
      self.win.actionRemove.setDisabled(True)
      self.win.actionEmpty.setDisabled(True)
      
    def delete(self): #OK QT4
      i = self.index
      if i > -1 :
        self.win.timeline.removeColumn(i)
        self.displayLenght()
        j = self.win.timeline.columnCount()
        if j == 0 :
          self.win.serie.setDisabled(True)
          self.win.actionMove_left.setDisabled(True)
          self.win.actionMove_right.setDisabled(True)
          self.win.actionRemove.setDisabled(True)
          self.win.actionEmpty.setDisabled(True)
        else :
          if i == 0 :
            self.win.timeline.setCurrentCell(0,0)
          elif i >= j :
            self.win.timeline.setCurrentCell(0,i-1)
          else :
            self.win.timeline.setCurrentCell(0,i)
      
    def up(self): #OK QT4
      if self.index!=(self.win.timeline.columnCount()-1) :
        i=self.index
        pict=self.win.timeline.cellWidget(0,i).copy()
        nc=i+2
        self.win.timeline.insertColumn(nc)
        self.win.timeline.setColumnWidth(nc,pict.wpix)
        self.win.timeline.setCellWidget(0,nc,pict)
        self.win.timeline.removeColumn(i)
        self.win.timeline.cellWidget(0,i).col=i
        self.win.timeline.cellWidget(0,(i+1)).col=i+1
        self.win.timeline.setCurrentCell(0,i+1)
      
    def down(self): #OK QT4
      if self.index!=0 :
        i=self.index
        pict=self.win.timeline.cellWidget(0,i).copy()
        b=i+1
        nc=i-1
        self.win.timeline.insertColumn(nc)
        self.win.timeline.setColumnWidth(nc,pict.wpix)
        self.win.timeline.setCellWidget(0,nc,pict)
        self.win.timeline.removeColumn(b)
        self.win.timeline.cellWidget(0,i).col=i
        self.win.timeline.cellWidget(0,nc).col=nc
        self.win.timeline.setCurrentCell(0,nc)
    
    ### GUI_main - Options section ###
    def chbgcolor(self): #OK QT4 !!!
      try :
        c=int(str("0x"+self.win.bgcolor.text()),16)
        self.win.timeline.cellWidget(0,self.index).bgcolor=c
        bckcol=QPalette()
        bckcol.setColor(QPalette.Base,self.toqcolor(c))
        self.win.bgcolor.setPalette(bckcol)
        self.update_bg_pix()
      except :
        None

    def bgcolora(self): # OK QT4 !!!
      colorb=QColorDialog.getColor(self.toqcolor(self.data.getElementsByTagName('bgcolor')[0].childNodes[0].nodeValue),self.win)
      red=colorb.red()
      green=colorb.green()
      blue=colorb.blue()
      xcolor=red*65536+green*256+blue
      try :
        self.win.timeline.cellWidget(0,self.index).bgcolor=xcolor
      except :
        None
      self.win.bgcolor.setText(self.colortohex(xcolor))
      self.chbgcolor()
      
    def update_bg_pix(self) :
      scene=self.win.timeline.cellWidget(0,self.index).scene
      bgcolor=self.win.timeline.cellWidget(0,self.index).bgcolor
      bgfile=self.win.timeline.cellWidget(0,self.index).bgfile
      shapelst=scene.items()
      for shape in shapelst :
        if shape.data(0).toString() == QString("backgroundc") :
          if bgfile == "" :
            shape.setBrush(QBrush(self.toqcolor(bgcolor)))
          else :
            scene.removeItem(shape)
            bkgpix = QPixmap(bgfile)
            bgim = scene.addPixmap(bkgpix.scaled(self.imgwidth,self.imgheight,Qt.KeepAspectRatio,Qt.SmoothTransformation))
            bgim.setData(0,QVariant(QString("backgroundi")))
        elif shape.data(0).toString() == QString("backgroundi") :
          if bgfile=="" :
            scene.removeItem(shape)
            bgcol = scene.addRect(0,0,self.imgwidth,self.imgheight,QPen(),QBrush(self.toqcolor(bgcolor)))
            bgcol.setData(0,QVariant(QString("backgroundc")))
          else :
            bkgpix = QPixmap(bgfile)
            shape.setPixmap(bkgpix.scaled(self.imgwidth,self.imgheight,Qt.KeepAspectRatio,Qt.SmoothTransformation))
      self.win.timeline.cellWidget(0,self.index).updatePix()
    
    def colortohex(self,color): #OK QT4 !!!
      r=int(int(color)/65536)
      g=int((int(color)-r*65536)/256)
      b=int(int(color)-r*65536-g*256)
      rr=hexp(r)
      gg=hexp(g)
      bb=hexp(b)
      colorh=unicode(rr.strip("0x").upper().rjust(2,"0")+gg.strip("0x").upper().rjust(2,"0")+bb.strip("0x").upper().rjust(2,"0"))
      return colorh
    
    def toqcolor(self,color): #OK QT4
      r=int(int(color)/65536)
      g=int((int(color)-r*65536)/256)
      b=int(int(color)-r*65536-g*256)
      qcolor=QColor(r,g,b)
      return qcolor

    def chbgfile(self): #OK QT4
      try :
        self.win.timeline.cellWidget(0,self.index).bgfile=self.win.bgfile.text()
        self.update_bg_pix()
      except :
        None

    def bgfilea(self): #OK QT4
      file=QFileDialog.getOpenFileName(self.win, self.qtapp.translate("main","File Dialog"),self.lastdir, "Images(*.jpg *.JPG *.png *.PNG *.gif *.GIF *.xpm *.XPM)")
      self.win.bgfile.setText(file)
      self.lastdir=os.path.split(unicode(file))[0]
      self.chbgfile()
          
    def chgopttransi(self,index): #OK QT4
      try :
        self.win.timeline.cellWidget(0,self.index).opttransi=index
      except :
        None

    def chtime(self,val): #OK QT4
      try :
        self.win.timeline.cellWidget(0,self.index).time=val
        self.displayLenght()
      except :
        None

    def chsndfile(self): #OK QT4
      self.updatexml(self.data,"sndfile",unicode(self.win.soundfile.text()))

    def sndfilea(self): #OK QT4
      file=QFileDialog.getOpenFileName(self.win, self.qtapp.translate("main","File Dialog"),self.lastdir, "Sound(*.wav *.WAV *.mp3 *.MP3 *.ogg *.OGG)")
      self.win.soundfile.setText(file)
      self.updatexml(self.data,"sndfile",unicode(file))
      self.lastdir=os.path.split(unicode(file))[0]
      
    def setImgFormat(self,imgF) :
      self.updatexml(self.data,"imgformat",unicode(imgF))
      self.prjReload()

    def prjReload(self) :
      self.projetfile=self.T+u"/tmp.idv"
      self.pfilee=1
      self.saveprojet()
      self.empty()
      self.win.outputfile.clear()
      self.win.bgfile.clear()
      self.win.bgcolor.clear()
      self.win.soundfile.clear()
      self.pfilee=0
      self.affichedata(self.T+u"/tmp.idv")
    
    def choixvideof(self,txt): #OK QT4
      self.updatexml(self.data,"videof",unicode(txt))     
      self.displayLenght()
      self.prjReload()

    def choixoutputformat(self,txt): #OK QT4
      self.updatexml(self.data,"outputf",unicode(txt))

    def choixspeedt(self,txt): #OK QT4
      try :
        self.win.timeline.cellWidget(0,self.index).speedt=txt
        self.displayLenght()
      except :
        None
 
    ### GUI Main - Preview montage section ###
    def preview(self) :
      if self.pfilee==0 :
        self.projetfile=self.T+u"tmp.idv"
        self.pfilee=1
        self.saveprojet()
        self.pfilee=0
      else :
        self.saveprojet()
      k=0
      while k<self.win.timeline.columnCount() :
        self.win.timeline.cellWidget(0,k).export2ppm(self.T+u"img_"+unicode(k)+u".ppm",384,288,self.imgwidth,self.imgheight)
        k+=1
      self.prevmontage=process(self.data,self.config,self.win,self.listformats[1],self.imgformat,self)
      self.prevmontage.preview()
      self.prevmontage.start()
      
 
    ### GUI_Main - process section ###
    def process(self) : 
      if self.pfilee==0 :
        self.projetfile=self.T+u"tmp.idv"
        self.pfilee=1
        self.saveprojet()
        self.pfilee=0
      else :
        self.saveprojet()
      k=0
      while k<self.win.timeline.columnCount() :
        self.win.timeline.cellWidget(0,k).export2ppm(self.T+u"img_"+unicode(k)+u".ppm",self.imgwidthF,self.imgheightF,self.imgwidth,self.imgheight)
        k+=1

      self.prc=process(self.data,self.config,self.win,self.convertformat[self.win.outputfileformat.currentIndex()],self.imgformat,self)

      if self.prc.err==0 :
        self.showprog=ShowProgress(self.win,self.prc.totimage,self.prc)
        self.showprog.show()

        self.prc.start()
        self.qtapp.connect(self.prc,SIGNAL("image"),self.displayProcessImg)
        self.qtapp.connect(self.prc,SIGNAL("frame"),self.infoFrame)
        self.qtapp.connect(self.prc,SIGNAL("text"),self.infoProgress)
        #self.qtapp.connect(self.showprog,SIGNAL("cleantmp"),self.prc.cleantmp)

    def displayProcessImg(self,img) :
      self.showprog.viewimg.setScene(self.win.timeline.cellWidget(0,img).Qscene())
      self.showprog.viewimg.fitInView(0,0,self.win.timeline.cellWidget(0,img).imgwidth,self.imgheight,Qt.KeepAspectRatio)

    def infoFrame(self,frame) :
      txt=self.qtapp.translate("Show","processing frame ")+str(frame)+self.qtapp.translate("Show"," from ")+str(self.prc.totimage)
      self.showprog.info.setText(txt)
      self.showprog.progressBar1.setValue(frame)

    def infoProgress(self,txt) :
      self.showprog.label1.setText(txt)


    ### GUI_Main - File menu section ###
    def newprojet(self): #OK QT4
      self.empty()
      self.win.outputfile.clear()
      self.win.soundfile.clear()
      self.pfilee=0
      self.affichedata(self.templatedir+u'template_data.idv')

    def openprojet(self): #OK QT4
      self.empty()
      self.win.outputfile.clear()
      self.win.bgfile.clear()
      self.win.bgcolor.clear()
      self.win.soundfile.clear()
      try :
        self.projetfile=QFileDialog.getOpenFileName(self.win, self.qtapp.translate("main","File Dialog"),self.home, "*.idv")
        self.pfilee=1
        self.affichedata(unicode(self.projetfile))
      except :
        print "erreur ouverture"
        self.pfilee=0

    def saveprojet(self): #OK QT4
      if self.pfilee==0 or self.saveas==1 :
        tmppf=unicode(QFileDialog.getSaveFileName(self.win,self.qtapp.translate("main","File Dialog"),self.home, "*.idv"))
        if tmppf.endswith(u'.idv') :
          self.projetfile=tmppf
        else :
          self.projetfile=tmppf+u".idv"
      
      b=self.data.getElementsByTagName('inputfile')[0]
      c=b.childNodes
      while b.hasChildNodes() :
        b.removeChild(c[0])
      nitem=self.win.timeline.columnCount()
      i=0
      doc = Document()
      while i<nitem :
        node=doc.createElement(u"img")
        node.setAttribute(u"transition",unicode(self.win.timeline.cellWidget(0,i).typet))
        node.setAttribute(u"tr_option",unicode(self.win.timeline.cellWidget(0,i).opttransi))
        node.setAttribute(u"speedt",unicode(self.win.timeline.cellWidget(0,i).speedt))
        node.setAttribute(u"time",unicode(self.win.timeline.cellWidget(0,i).time))
        node.setAttribute(u"bgcolor",unicode(self.win.timeline.cellWidget(0,i).bgcolor))
        node.setAttribute(u"bgfile",unicode(self.win.timeline.cellWidget(0,i).bgfile))
        node.setAttribute(u"urlimage",unicode(self.win.timeline.cellWidget(0,i).urlim))
        if self.win.timeline.cellWidget(0,i).zoom==2 :
          startZoom=self.win.timeline.cellWidget(0,i).getZoomBoxInfo(1)
          endZoom=self.win.timeline.cellWidget(0,i).getZoomBoxInfo(0)
          if (startZoom != None and endZoom != None) :
            node.setAttribute(u"zoom",unicode("2"))
            node.setAttribute(u"zoomStart",unicode(startZoom))
            node.setAttribute(u"zoomEnd",unicode(endZoom))
          else :
            node.setAttribute(u"zoom",unicode("0"))
          
        c=b.appendChild(node)
        for item in self.win.timeline.cellWidget(0,i).scene.items() : 
          if (item.data(0).toString()) == "Texte" :
            tor=doc.createElement(u"ftext")
            tor.setAttribute(u"x",unicode(item.x()))
            tor.setAttribute(u"y",unicode(item.y()))
            tor.setAttribute(u"width",u"310")
            txt=item.toHtml()
            txt.replace(u"<",u"[")
            txt.replace(u">",u"]")
            tor.setAttribute(u"text",unicode(txt))
            d=c.appendChild(tor)
        i=i+1
      
      try:
        fisa=open(self.projetfile,'w')
        fisa.write(self.data.toxml('utf-8')) 
        self.pfilee=1
        fisa.close()
      except:
        None

    def saveasprojet(self):
      self.saveas=1
      self.saveprojet()
    
    ### GUI_Main - Display data section ###
    def affichedata(self,xmlfile): #OK QT4
      fo2=open(xmlfile,'r')
      #Import configurations data from xml file
      self.data=minidom.parse(fo2)
      fo2.close()
      # Options display
      
      # Set sound file
      try:
        self.win.soundfile.setText(self.data.getElementsByTagName('sndfile')[0].childNodes[0].nodeValue)
      except:
        None
      # Set video format
      try:
        self.win.videof.setCurrentIndex(int(self.data.getElementsByTagName('videof')[0].childNodes[0].nodeValue))
      except :
        None

      # Set image format
      try:
        self.win.imgformat.setCurrentIndex(int(self.data.getElementsByTagName('imgformat')[0].childNodes[0].nodeValue))
        self.imgformat=self.win.imgformat.currentIndex()
      except:
        self.imgformat=0
      
      if self.imgformat==1 :
        if self.win.videof.currentIndex()==3 :
          self.imgwidth=1280
          self.imgwidthF=1280
          self.imgheight=720
          self.imgheightF=720
        elif self.win.videof.currentIndex()==4 :
          self.imgwidth=1920
          self.imgwidthF=1920
          self.imgheight=1080
          self.imgheightF=1080
        elif self.win.videof.currentIndex()==5 :
          self.imgwidth=512
          self.imgwidthF=384
          self.imgheight=288
          self.imgheightF=288
        elif self.win.videof.currentIndex()==6 :
          self.imgwidth=640
          self.imgwidthF=640
          self.imgheight=360
          self.imgheightF=480
        else :
          self.imgwidth=1024
          self.imgwidthF=720
          self.imgheight=576
          if self.win.videof.currentIndex()==1 :
            self.imgheightF=480
          else :
            self.imgheightF=576
      else :
        if self.win.videof.currentIndex()==3 :
          self.imgwidth=960
          self.imgwidthF=960
          self.imgheight=720
          self.imgheightF=720
        elif self.win.videof.currentIndex()==4 :
          self.imgwidth=1440
          self.imgwidthF=1440
          self.imgheight=1080
          self.imgheightF=1080
        elif self.win.videof.currentIndex()==5 :
          self.imgwidth=384
          self.imgwidthF=384
          self.imgheight=288
          self.imgheightF=288
        elif self.win.videof.currentIndex()==6 :
          self.imgwidth=640
          self.imgwidthF=640
          self.imgheight=480
          self.imgheightF=480
        else :
          self.imgwidth=768
          self.imgwidthF=720
          self.imgheight=576
          if self.win.videof.currentIndex()==1 :
            self.imgheightF=480
          else :
            self.imgheightF=576
      
      # Set output file format
      try:
        self.win.outputfileformat.setCurrentIndex(int(self.data.getElementsByTagName('outputf')[0].childNodes[0].nodeValue))
      except:
        None
      # Set file to export the project
      try:
        self.win.outputfile.setText(self.data.getElementsByTagName('outputfile')[0].childNodes[0].nodeValue)
      except:
        None
      k=0
      for pictfile in self.data.getElementsByTagName('img'):
        try :
          compose=self.DisplayThumb(pictfile.getAttribute("urlimage"),k,
              pictfile.getAttribute("time"),
              pictfile.getAttribute("bgfile"),
              pictfile.getAttribute("bgcolor"),
              pictfile.getAttribute("transition"),
              pictfile.getAttribute("tr_option"),
              pictfile.getAttribute("speedt"))
        except :
          compose=self.DisplayThumb(pictfile.childNodes[0].nodeValue,k,
              "2","","0","0","0","3")
        
        if pictfile.getAttribute("zoom") == "2" :
          self.win.timeline.cellWidget(0,k).setZoom()
          self.win.timeline.cellWidget(0,k).setChkZoom(2)
          start=pictfile.getAttribute("zoomStart").split(":")
          end=pictfile.getAttribute("zoomEnd").split(":")
          self.win.timeline.cellWidget(0,k).setZoomBox(float(start[0]),float(start[1]),float(start[2]),float(start[3]),1)
          self.win.timeline.cellWidget(0,k).setZoomBox(float(end[0]),float(end[1]),float(end[2]),float(end[3]),0)
        else :
          self.win.timeline.cellWidget(0,k).setChkZoom(0)
          
        for texte in pictfile.getElementsByTagName('ftext') :
          try :  
            Txt=QString(unicode(texte.getAttribute("text")))
            Txt.replace(u"[",u"<")
            Txt.replace(u"]",u">")
            text1=QGraphicsTextItem(u"hello")
            text1.setHtml(Txt)
            Txt=text1.toHtml() # permet d'enlever le paragraphe ajouté et inutile.
            Txt.replace(u'<p style=" margin-top:0px; margin-bottom:0px; margin-left:0px; margin-right:0px; -qt-block-indent:0; text-indent:0px;"> </p>',u"")
            text1.setHtml(Txt)
            
            text1.setTextWidth(self.win.timeline.cellWidget(0,k).txtwide)
            text1.scale(self.win.timeline.cellWidget(0,k).txtzoom,self.win.timeline.cellWidget(0,k).txtzoom)
            text1.setPos(float(texte.getAttribute("x")),float(texte.getAttribute("y")))
            text1.setZValue(101)
            text1.setAcceptDrops(1)
            text1.setFlags(QGraphicsItem.ItemIsMovable | QGraphicsItem.ItemIsSelectable)
            data=QVariant("Texte")
            text1.setData(0,data)
            
            compose.addItem(text1)
          except :
            None
        self.win.timeline.cellWidget(0,k).updatePix()
        k+=1
      if self.win.timeline.columnCount() != 0 :
        self.win.serie.setEnabled(True)
        self.win.actionRemove.setEnabled(True)
        self.win.actionEmpty.setEnabled(True)
      self.displayLenght()    
      
    ### Serie functions window section
    # Init function
    def serie(self) :
      self.winserie=Lot(self.lstT,self.lastdir,self.win)
      self.winserie.fromc.setMaximum(self.win.timeline.columnCount())
      self.winserie.toc.setMaximum(self.win.timeline.columnCount())
      self.winserie.show()
      self.qtapp.connect(self.winserie.buttonBox,SIGNAL("accepted()"),self.processSerie)
      
    def processSerie(self) :
      if self.winserie.tableImage.rowCount() != 0 :
        i=0
        while i < self.winserie.tableImage.rowCount() :        
          self.changeImageOption(self.winserie.tableImage.item(i,0).text(),self.winserie.tableImage.item(i,1).text(),self.winserie.tableImage.item(i,2).text())
          i += 1
    
    def changeImageOption(self,imF,imL,opt) :
      option=opt.split(":")
      i=int(imF)-1
      while i <= (int(imL)-1) :
        self.win.timeline.cellWidget(0,i).time=option[0]
        self.win.timeline.cellWidget(0,i).bgfile=option[1]
        self.win.timeline.cellWidget(0,i).bgcolor=int("0x"+str(option[2]),16)
        self.win.timeline.cellWidget(0,i).speedt=option[3]
        self.win.timeline.cellWidget(0,i).typet=option[4]
        self.win.timeline.cellWidget(0,i).opttransi=option[5]
        self.win.timeline.cellWidget(0,i).updatePix()
	self.win.timeline.setCurrentCell(0,i)
	self.selectionListe()
	i += 1
      self.displayLenght()
        
    ### Configuration window section ###
    # Init function
    def conf(self) : #OK QT4
      self.winconfig=Configuration(self.win)
      self.winconfig.typet.insertItems(0,self.lstT)
      self.winconfig.outputf.addItems(self.listformats)
      self.afficheconfig()
      self.winconfig.show()
      self.qtapp.connect(self.winconfig.cancel,SIGNAL("clicked()"),self.winconfig,SLOT("close()"))
      self.qtapp.connect(self.winconfig.chk,SIGNAL("clicked()"),self.verifconfig)
      self.qtapp.connect(self.winconfig.tmpdirbut,SIGNAL("clicked()"),self.tmpdir)
      if os.name != 'nt' :
        self.qtapp.connect(self.winconfig.imgmgkbut,SIGNAL("clicked()"),self.imgmgkdir)
        self.qtapp.connect(self.winconfig.mjpegtoolsbut,SIGNAL("clicked()"),self.mjpegtoolsdir)
        self.qtapp.connect(self.winconfig.soxbut,SIGNAL("clicked()"),self.soxdir)
      self.qtapp.connect(self.winconfig.bgcolora,SIGNAL("clicked()"),self.bgcoloraconf)
      self.qtapp.connect(self.winconfig.bgfilea,SIGNAL("clicked()"),self.bgfileaconf)
      self.qtapp.connect(self.winconfig.imgformat,SIGNAL("activated(int)"),self.confimgformat)
      self.qtapp.connect(self.winconfig.videof,SIGNAL("activated(int)"),self.confvideof)
      self.qtapp.connect(self.winconfig.outputf,SIGNAL("activated(int)"),self.confoutputf)
      self.qtapp.connect(self.winconfig.speedt,SIGNAL("activated(int)"),self.choixspeedtconf)
      self.qtapp.connect(self.winconfig.typet,SIGNAL("activated(int)"),self.choixtypetconf)
      self.qtapp.connect(self.winconfig.time,SIGNAL("valueChanged(int)"),self.choixtimeconf)
      self.qtapp.connect(self.winconfig.saveconfig,SIGNAL("clicked()"),self.saveconfig)

    def afficheconfig(self): #OK QT4
      try:
        self.winconfig.tmpdir.setText(self.config.getElementsByTagName('tmpdir')[0].childNodes[0].nodeValue)
      except:
        None
      try:
        self.winconfig.imgmgkdir.setText(self.config.getElementsByTagName('imgmgkdir')[0].childNodes[0].nodeValue)
      except:
        None
      try:
        self.winconfig.mjpegtoolsdir.setText(self.config.getElementsByTagName('mjpegtoolsdir')[0].childNodes[0].nodeValue)
      except:
        None
      try:
        self.winconfig.soxdir.setText(self.config.getElementsByTagName('soxdir')[0].childNodes[0].nodeValue)
      except:
        None
      try:
        self.winconfig.videof.setCurrentIndex(int(self.datat.getElementsByTagName('videof')[0].childNodes[0].nodeValue))
      except:
        None
      try:
        self.winconfig.imgformat.setCurrentIndex(int(self.datat.getElementsByTagName('imgformat')[0].childNodes[0].nodeValue))
      except:
        None
      try:
        self.winconfig.outputf.setCurrentIndex(int(self.datat.getElementsByTagName('outputf')[0].childNodes[0].nodeValue))
      except:
        None
      # Display standards options
      # Set picture display time without transition time
      try:
        self.winconfig.time.setValue(int(self.config.getElementsByTagName('time')[0].childNodes[0].nodeValue))
      except:
        None
      # Set transition speed
      try:
        self.winconfig.speedt.setCurrentIndex(int(self.config.getElementsByTagName('speedt')[0].childNodes[0].nodeValue))
      except:
        None
      # Set transition type
      try:
        self.winconfig.typet.setCurrentIndex(int(self.config.getElementsByTagName('typet')[0].childNodes[0].nodeValue))
      except:
        None
      # Set background file
      try:
        self.winconfig.bgfile.setText(self.config.getElementsByTagName('bgfile')[0].childNodes[0].nodeValue)
      except:
        None
      # Set background color
      try:
        xcolor=self.config.getElementsByTagName('bgcolor')[0].childNodes[0].nodeValue
      except :
        xcolor=0
        self.updatexml(self.data,"bgcolor",u"0")
      qp=QPalette()
      qp.setColor(QPalette.Base,self.toqcolor(xcolor))
      self.winconfig.bgcolor.setPalette(qp)
      self.winconfig.bgcolor.setText(self.colortohex(xcolor))

    # Action button to look for directory
    def tmpdir(self): #OK QT4
      folder=QFileDialog.getExistingDirectory(self.winconfig, self.qtapp.translate("main","Directory Dialog"), self.home)
      self.winconfig.tmpdir.setText(folder)
      self.updatexml(self.config,"tmpdir",unicode(folder),1)
      self.T=unicode(folder)+os.sep
    
    def imgmgkdir(self): #OK QT4
      folder=QFileDialog.getExistingDirectory(self.winconfig, self.qtapp.translate("main","Directory Dialog"), self.home)
      self.winconfig.imgmgkdir.setText(folder)
      self.updatexml(self.config,"imgmgkdir",unicode(folder),1)
    
    def mjpegtoolsdir(self): #OK QT4
      folder=QFileDialog.getExistingDirectory(self.winconfig, self.qtapp.translate("main","Directory Dialog"), self.home)
      self.winconfig.mjpegtoolsdir.setText(folder)
      self.updatexml(self.config,"mjpegtoolsdir",unicode(folder),1)
    
    def soxdir(self): #OK QT4
      folder=QFileDialog.getExistingDirectory(self.winconfig, self.qtapp.translate("main","Directory Dialog"), self.home)
      self.winconfig.soxdir.setText(folder)
      self.updatexml(self.config,"soxdir",unicode(folder),1)
    
    def bgfileaconf(self): #OK QT4
      file=QFileDialog.getOpenFileName(self.winconfig, self.qtapp.translate("main","File Dialog"),self.home, "Image(*.jpg *.JPG *.png *.PNG *.gif *.GIF *.xpm *.XPM)")
      self.winconfig.bgfile.setText(file)
      self.updatexml(self.config,"bgfile",unicode(file),1)
    
    def bgcoloraconf(self): #OK QT4
      color=QColorDialog.getColor(self.toqcolor(self.datat.getElementsByTagName('bgcolor')[0].childNodes[0].nodeValue),self.winconfig)
      qp=QPalette()
      qp.setColor(QPalette.Base,color)
      self.winconfig.bgcolor.setPalette(qp)
      red=color.red()
      green=color.green()
      blue=color.blue()
      xcolor=red*65536+green*256+blue
      self.updatexml(self.config,"bgcolor",unicode(xcolor),1)
      self.winconfig.bgcolor.setText(self.colortohex(xcolor))
      
    def choixspeedtconf(self,txt): #OK QT4
      self.updatexml(self.config,"speedt",unicode(txt),1)
    
    def choixtypetconf(self,txt): #OK QT4
      self.updatexml(self.config,"typet",unicode(txt),1)
    
    def choixtimeconf(self,txt): #OK QT4
      self.updatexml(self.config,"time",unicode(txt),1)
    
    def confimgformat(self,txt): #OK QT4
      self.updatexml(self.datat,"imgformat",unicode(txt),1)

    def confvideof(self,txt): #OK QT4
      self.updatexml(self.datat,"videof",unicode(txt),1)

    def confoutputf(self,txt): #OK QT4
      self.updatexml(self.datat,"outputf",unicode(txt),1)
    
    def saveconfig(self): #OK QT4
      fisa=open(self.templatedir+self.configFile,'w')
      fisa.write(self.config.toxml('utf-8'))
      fisa.close()
      fisa=open(self.templatedir+'template_data.idv','w')
      fisa.write(self.datat.toxml('utf-8'))
      fisa.close()
      self.winconfig.close()
    
    ### Verification of configuration section ###
    def verifconfig(self): #OK QT4
      pathname = os.path.dirname (sys.argv[0])
      refdir = os.path.abspath (pathname) + "/icons/"
      ok=QIcon(QPixmap(refdir+"ok.png"))
      nok=QIcon(QPixmap(refdir+"nok.png"))
      self.statconf=StatusConf(self.win)
      if os.name != 'nt' :
        dico=[['imgmgkdir','ffmpeg','FFmpeg'],['mjpegtoolsdir','mpeg2enc','MJpegTools'],['soxdir','sox','SoX']]
        for x in dico :
          try:
            a=os.listdir(self.config.getElementsByTagName(x[0])[0].childNodes[0].nodeValue)
            i=0
            if x[1] in a :
              self.statconf.status.addItem(QListWidgetItem(ok,x[2]+self.qtapp.translate("main"," is correctly configured")))
            else :
              self.statconf.status.addItem(QListWidgetItem(nok,x[2]+" "+self.qtapp.translate("main","not found, check the configuration")))
          except:
            self.statconf.status.addItem(QListWidgetItem(nok,x[2]+" "+self.qtapp.translate("main",": The configuration directory is not define, check the configuration")))
            None
      try :
        tmpdir=self.config.getElementsByTagName("tmpdir")[0].childNodes[0].nodeValue
      except :
        tmpdir=""
      if tmpdir =="" :
        self.statconf.status.addItem(QListWidgetItem(nok,self.qtapp.translate("main","The temporary directory is not define")))
      else :
        if os.access(tmpdir,os.F_OK) :
          if os.access(tmpdir,os.W_OK) :
            self.statconf.status.addItem(QListWidgetItem(ok,self.qtapp.translate("main","The temporary directory is writable")))
          else :
            self.statconf.status.addItem(QListWidgetItem(nok,self.qtapp.translate("main","The temporary directory is not writable")))
        else :
          self.statconf.status.addItem(QListWidgetItem(nok,self.qtapp.translate("main","The temporary directory doesn't exist")))

      if self.msgffmpeg.isEmpty() == False :
        for ffmpegerr in self.msgffmpeg :
          self.statconf.status.addItem(QListWidgetItem(nok,ffmpegerr))
      else :
        self.statconf.status.addItem(QListWidgetItem(ok,self.qtapp.translate("main","Ffmpeg support the format H264 with libx264")))
      s = 0
      suppFormat = [u"Wav",u"Ogg",u"Mp3"]
      for mSox in self.msgsox :
        if mSox != u"" :
          self.statconf.status.addItem(QListWidgetItem(nok,mSox))
        else :
          self.statconf.status.addItem(QListWidgetItem(ok,self.qtapp.translate("main","The %1 format is readable by Sox").arg(suppFormat[s])))
        s += 1

      c=int(self.config.getElementsByTagName('chk')[0].childNodes[0].nodeValue)
      self.statconf.chk.setChecked(bool(c)) 
      self.qtapp.connect(self.statconf.closew,SIGNAL("clicked()"),self.statconf,SLOT("close()"))
      self.statconf.connect(self.statconf.chk,SIGNAL("stateChanged(int)"),self.chkdisplay)
      self.statconf.show()

    def chkdisplay(self,state): #OK QT4
      self.updatexml(self.config,"chk",unicode(state))
      fisa=open(self.templatedir+self.configFile,'w')
      if fisa.write(self.config.toxml()) :
        fisa.close()
      
    ### Generic function to update DOM tree section ###
    def updatexml(self,dom,tag,txt,cf=0): #OK QT4
      doc = Document()
      node=doc.createTextNode(unicode(txt))
      try :
        of=dom.getElementsByTagName(tag)[0]
        of.replaceChild(node,of.childNodes[0])
      except :
        try :
          of=dom.getElementsByTagName(tag)[0]
          of.appendChild(node)
        except :
          if cf==0 :
            of2=dom.getElementsByTagName("options")[0]
          else :
            of2=dom.getElementsByTagName("configuration")[0]
          node2=doc.createElement(tag)
          node2.appendChild(node)
          of2.appendChild(node2)

