/*
    Tucnak - VHF contest log
    Copyright (C) 2002-2006  Ladislav Vaiz <ok1zia@nagano.cz>

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public
    License along with this library; if not, write to the Free
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/

#include "header.h"


char *get_wwl(char *buf, char *wwl){
    safe_strncpy(buf, wwl,5);
    return buf;
}


void draw_one_bigdigit(struct terminal *term,int x, int y, int num){
    switch(num%10){
        case 0:
            fill_area(term,x,y,3,5,COL_INV);
            fill_area(term,x+1,y+1,1,3,COL_NORM);
            break;
        case 1:
            fill_area(term,x,y,3,5,COL_INV);
            fill_area(term,x+2,y,1,4,COL_NORM);
            fill_area(term,x,y+1,1,3,COL_NORM);
            break;
        case 2:
            fill_area(term,x,y,3,5,COL_INV);
            fill_area(term,x,y+1,2,1,COL_NORM);
            fill_area(term,x+1,y+3,2,1,COL_NORM);
            break;
        case 3:
            fill_area(term,x,y,3,5,COL_INV);
            fill_area(term,x,y+1,2,1,COL_NORM);
            fill_area(term,x,y+3,2,1,COL_NORM);
            break;
        case 4:
            fill_area(term,x,y,3,5,COL_INV);
            fill_area(term,x+1,y,1,2,COL_NORM);
            fill_area(term,x,y+3,2,2,COL_NORM);
            break;
        case 5:
            fill_area(term,x,y,3,5,COL_INV);
            fill_area(term,x+1,y+1,2,1,COL_NORM);
            fill_area(term,x,y+3,2,1,COL_NORM);
            break;
        case 6:
            fill_area(term,x,y,3,5,COL_INV);
            fill_area(term,x+1,y+1,2,1,COL_NORM);
            fill_area(term,x+1,y+3,1,1,COL_NORM);
            break;
        case 7:
            fill_area(term,x,y,3,5,COL_INV);
            fill_area(term,x,y+1,2,4,COL_NORM);
            break;
        case 8:
            fill_area(term,x,y,3,5,COL_INV);
            fill_area(term,x+1,y+1,1,1,COL_NORM);
            fill_area(term,x+1,y+3,1,1,COL_NORM);
            break;
        case 9:
            fill_area(term,x,y,3,5,COL_INV);
            fill_area(term,x+1,y+1,1,1,COL_NORM);
            fill_area(term,x,y+3,2,1,COL_NORM);
            break;

    }
}

void draw_bigdigit(struct terminal *term, int x, int y, int num){
   int qsonr=num;
   
   if (qsonr>=10000) set_char(term,x-2,y+2,'+');
   
   if (qsonr>=1000) {
       draw_one_bigdigit(term,x,y,(qsonr/1000)%10);
   }else{
       x-=2;
   }

   draw_one_bigdigit(term,x+4 ,y, (qsonr/100)%10); 
   draw_one_bigdigit(term,x+8 ,y, (qsonr/10)%10); 
   draw_one_bigdigit(term,x+12,y, qsonr%10); 
    
}








struct stats *init_stats(){
    struct stats *st;

    st = (struct stats *)g_new0(struct stats, 1); 

    st->wwls = g_hash_table_new(g_str_hash, g_str_equal);
    st->dxcs = g_hash_table_new(g_str_hash, g_str_equal);
    st->excs = g_hash_table_new(g_str_hash, g_str_equal);
    st->calls = g_hash_table_new(g_str_hash, g_str_equal);
    
    clear_stats(st);
    
    return st;
}


void free_stats(struct stats *st){

    clear_stats(st);
    
    g_hash_table_destroy(st->wwls);
    g_hash_table_destroy(st->dxcs);
    g_hash_table_destroy(st->excs);
    g_hash_table_destroy(st->calls);
    g_free(st);
    
}


void clear_stats(struct stats *st){
 /*   dbg("clear_stats(%p)\n", st);*/
    
    st->first_date = G_MAXINT;
    st->last_date  = 0;
    
    st->nqsos = 0;
    st->nqsop = 0;
    st->nwwlp = 0;
    st->nexcp = 0;
    st->ndxcp = 0;
    st->ntotal = 0;
    
    g_hash_table_foreach_remove(st->wwls, free_gpointer_item, NULL);
    g_hash_table_foreach_remove(st->dxcs, free_gpointer_item, NULL);
    g_hash_table_foreach_remove(st->excs, free_gpointer_item, NULL);
    g_hash_table_foreach_remove(st->calls, free_gpointer_item, NULL);
    
    if (st->odxcall)     {g_free(st->odxcall);     st->odxcall      = NULL;}
    if (st->odxwwl)      {g_free(st->odxwwl);      st->odxwwl       = NULL;}
    if (st->odxoperator) {g_free(st->odxoperator); st->odxoperator  = NULL;}
    st->odxqrb_int = 0;
}

int find_preferred_dxc(int type, char *dxc){
	char *prefs9[]  = {"ES","LA","LY","OH","OH0","OJ0","OY","OZ","SM","TF","YL",NULL};
	char *prefs10[] = {"G","GD","GI","GJ","GM","GU","GW",NULL};
    char *prefs11[] = {"F",NULL}; 
	char **prefs;
	int multi=1;
	int i;
	
	switch(type){
		case 9: 
			prefs=prefs9;
			multi=3;
			break;
		case 10: 
			prefs=prefs10;
			multi=5;
			break;
		case 11: 
			prefs=prefs11;
			multi=3;
			break;
		default:
			return 1;	
	}

	for (i=0; prefs[i]!=NULL; i++){
		if (strcasecmp(dxc,prefs[i])==0) return multi;
	}
	return 1;
	
}
/* set and dirty */
#define SAD_INT(item,value) {if (q->item!=value) b->dirty_save=1;q->item=value;}

void update_stats(struct stats *st, struct band *b, struct qso *q){
    gint date,qsop,anew;
    gchar s[120];
    gchar s1[120];
    gpointer orig_key;
    gint *orig_value;
    gint wwls, dxcs, excs;

/*    dbg("update_stats(%p, %c, %p)\n", st, b->bandchar, q);*/
    if (!q->error){
        date = atoi(q->date_str);
        if (date < st->first_date) st->first_date = date;
        if (date > st->last_date)  st->last_date  = date;
    }
    
    if (q->error) {
        SAD_INT(new,0);
        SAD_INT(qsop,0);
        SAD_INT(susploc,0);
        SAD_INT(unkcall,0);
        return;
    }
    st->nqsos++;

    
/*    dbg("update_stats(%s) calls->size=%d \n", q->qsonrs, g_hash_table_size(st->calls));
    dbg("   dupe=%d  qsop=%d \n", q->dupe, q->qsop);*/
    
    get_raw_call(s, q->callsign);
    if (g_hash_table_lookup_extended(st->calls, s, &orig_key, (gpointer) &orig_value)){
        SAD_INT(dupe,1);
    }else{
        g_hash_table_insert(st->calls, g_strdup(s), NULL);
        SAD_INT(dupe,0);
    }
    
    switch (ctest->qsop_method){
        case 1: /* rounded distance */
            qsop = iaru_round(q->qrb) * ctest->qsomult;
            break;
        case 2: /* 1 */
            qsop = ctest->qsomult;
            break;
		case 3: /* FIXME! it's really correct? */
			qsop = ((q->qrb/50)*2+1 ) * ctest->qsomult;
			break;	
        case 4: /* WWL ring */
            qsop = qsopwr(ctest->pwwlo, q->locator) * ctest->qsomult;
            break;
		case 5: /* statute miles (anglicka mile) */
			qsop = q->qrb/1.6094 * ctest->qsomult;	
			break;
		case 6: /* 1 * qso-points multi + 1 point for CW QSO FIXME! bug in taclog? */
			qsop = ctest->qsomult;
			if (q->mode==MOD_CW_CW) q->qsop++;
			break;
		case 7: /* distance(min 50) */	
			qsop = (q->qrb>50 ? q->qrb : 50) * ctest->qsomult;
			break;
		case 8: /* distance(min 10) */	
			qsop = (q->qrb>10 ? q->qrb : 10) * ctest->qsomult;
			break;
		case 9:
		case 10:
		case 11:
			qsop = ctest->qsomult * 
				find_preferred_dxc(ctest->qsop_method,
						get_dxcc(dw,s,q->callsign));
			break;

            
    }
    if (q->dupe) qsop=0;
    SAD_INT(qsop,qsop);
    
/*    dbg("   dupe=%d  qsop=%d \n", q->dupe, q->qsop);*/
    
    st->nqsop += q->qsop;

    
    if ((int)q->qrb > st->odxqrb_int){
        if (st->odxcall)     { g_free(st->odxcall);     st->odxcall = NULL; }
        if (st->odxwwl)      { g_free(st->odxwwl);      st->odxwwl  = NULL; }
        if (st->odxoperator) { g_free(st->odxoperator); st->odxoperator  = NULL;}
         
        st->odxqrb_int  = (int)q->qrb;
        st->odxcall     = g_strdup(q->callsign);
        st->odxwwl      = g_strdup(q->locator);  
        st->odxoperator = g_strdup(q->operator);
    }

    q->unkcall=!find_wwl_by_call(cw, q->callsign);
    q->susploc = get_susp(cw, dw, q->callsign, q->locator);
    
    anew=q->new;

    if (ctest->wwlused){    
        get_wwl(s, q->locator);
	if (ctest->modesep){
		g_strlcpy(s1, s, 120);
		sprintf(s, "%i %s", q->mode, s1);
	}
        if (g_hash_table_lookup_extended(st->wwls, s, &orig_key, (gpointer) &orig_value)){
            (*orig_value)++; 
            anew &= ~NEW_WWL;
        }else{
            *orig_value++; 
            orig_value = g_new(gint, 1);
            *orig_value = 1;
            g_hash_table_insert(st->wwls, g_strdup(s), orig_value);
            anew |= NEW_WWL;
        }
    }
    
 
    get_dxcc(dw, s, q->callsign);
    if (ctest->modesep){
	    g_strlcpy(s1, s, 120);
    	sprintf(s, "%i %s", q->mode, s1);
    }
    if (g_hash_table_lookup_extended(st->dxcs, s, &orig_key, (gpointer) &orig_value)){
        (*orig_value)++; 
        anew &= ~NEW_DXC;
    }else{
        orig_value = g_new(gint, 1);
        *orig_value = 1;
        g_hash_table_insert(st->dxcs, g_strdup(s), orig_value);
        anew |= NEW_DXC;
    }
        

    if (ctest->excused){
        safe_strncpy0(s, q->exc, 20);
	    if (ctest->modesep){
		    g_strlcpy(s1, s, 120);
    		sprintf(s, "%i %s", q->mode, s1);
	    }
        if (g_hash_table_lookup_extended(st->excs, s, &orig_key, (gpointer) &orig_value)){
            (*orig_value)++; 
            anew &= ~NEW_EXC;
        }else{
            orig_value = g_new(gint, 1);
            *orig_value = 1;
            g_hash_table_insert(st->excs, g_strdup(s), orig_value);
            anew |= NEW_EXC;
        }
    }    
    
    SAD_INT(new,anew);
    
    wwls = g_hash_table_size(st->wwls);
    dxcs = g_hash_table_size(st->dxcs);
    excs = g_hash_table_size(st->excs);

    switch (ctest->total_method){
        case 1:      
            st->ntotal = ( st->nqsop +
                           wwls * ctest->wwlbonu + 
                           dxcs * ctest->dxcbonu +
                           excs * ctest->excbonu 
                         ) *
                           (ctest->wwlmult ? wwls * ctest->wwlmult : 1 ) *
                           (ctest->dxcmult ? dxcs * ctest->dxcmult : 1 ) *
                           (ctest->excmult ? excs * ctest->excmult : 1 )
                         ;  
            break;              
        case 2:      
            st->ntotal = ( st->nqsop +
                           wwls * ctest->wwlbonu + 
                           dxcs * ctest->dxcbonu +
                           excs * ctest->excbonu 
                         ) *
                         ( wwls * ctest->wwlmult +
                           dxcs * ctest->dxcmult +
                           excs * ctest->excmult 
                         );  
            break;              
    }
}

void recalc_stats(struct stats *st, struct band *b){
    struct qso *q;
    int i;
    
    if (!b->dirty_stats) return;
            
    dbg("%c ", b->bandchar);        
/*    ST_START;*/
    clear_stats(st);

    for (i=0; i<b->qsos->len; i++){
        q = get_qso(b, i);
        update_stats(st, b, q);
    }
    recalc_statsfifo(b);
    b->dirty_stats = 0;
  /*  ST_STOP;*/
}

void recalc_all_stats(struct contest *ctest){
    int i;
    struct band *band;

    for (i=0; i<ctest->bands->len; i++){
        band = (struct band *)g_ptr_array_index(ctest->bands, i);
        band->dirty_stats = 1;
        recalc_stats(band->stats, band);
            
    }
}

void recalc_all_qrbqtf(struct contest *ctest){
    int i, j;
    struct band *band;
	struct qso *q;

    for (i=0; i<ctest->bands->len; i++){
        band = (struct band *)g_ptr_array_index(ctest->bands, i);
		
		for (j=0; j<band->qsos->len; j++){
			q = get_qso(band, j);
			compute_qrbqtf(q);
		}

        for (j=0; j<TMP_QSOS;j++){
            int qtf_int;
            double qrb, qtf;
            
            if (!band->tmpqsos[j].locator || !*band->tmpqsos[j].locator) break;
            
            /* CHANGE look at add_tmqso_locator */
            qrbqtf(ctest->pwwlo, band->tmpqsos[j].locator, &qrb, &qtf, NULL);
            qtf_int=(int)(qtf+0.5);
            if (qrb < 0.1) {
                qtf_int=0;
            }  
            band->tmpqsos[j].qrb=qrb;
            band->tmpqsos[j].qtf=qtf_int;
        }
    }
}

#define STATS_X 2
#define STATS_Y 2

void redraw_stats(struct stats *st){
    gchar *c;
    char s[256];
	struct rotar *rot;
    
    print_text(term,STATS_X,STATS_Y,-1,TEXT(T_SES_ODX),COL_NORM);
    if (st->odxcall && st->odxwwl){
        c = g_strdup_printf(TEXT(T_SES_ODX_DATA), st->odxcall, st->odxwwl, st->odxqrb_int, st->odxoperator);
        print_text(term,STATS_X+5,STATS_Y,term->x-QSONR_WIDTH-BAND_WIDTH-8, c,COL_NORM);
        g_free(c);
    }    
    print_text(term,STATS_X,STATS_Y+2,term->x-QSONR_WIDTH-BAND_WIDTH-3,TEXT(T_SES_STAT_TIT),COL_NORM);
    c = g_strdup_printf("%4d  %6d  %4d  %4d   %4d  %7d",
            st->nqsos, st->nqsop, 
            g_hash_table_size(st->excs), 
            g_hash_table_size(st->wwls), 
            g_hash_table_size(st->dxcs),
            st->ntotal);
    print_text(term,STATS_X,STATS_Y+3,term->x-QSONR_WIDTH-BAND_WIDTH-3,c,COL_NORM);
    g_free(c);

    if (st->nqsos){
        c = g_strdup_printf(TEXT(T_SES_AVG), (double)st->ntotal/(double)st->nqsos);
        print_text(term,term->x-QSONR_WIDTH-BAND_WIDTH,ORIG_Y+1,BAND_WIDTH-1, c, COL_NORM); 
        g_free(c);
    }
    
    c = g_strdup_printf(TEXT(T_SES_WPM), cwda->speed);
    print_text(term,term->x-QSONR_WIDTH-BAND_WIDTH,ORIG_Y+2,BAND_WIDTH-1, c, COL_NORM); 
    g_free(c);

	rot=get_rotar(0);
    if (rot){
        sprintf(s,"RotA: %3d %+d ",rot->qtf, rot->elev); 
        print_text(term,term->x-QSONR_WIDTH-BAND_WIDTH,ORIG_Y+3,BAND_WIDTH-1, s, COL_NORM); 
    }
	rot=get_rotar(1);
    if (rot){
        sprintf(s,"RotB: %3d %+d ",rot->qtf, rot->elev); 
        print_text(term,term->x-QSONR_WIDTH-BAND_WIDTH,ORIG_Y+4,BAND_WIDTH-1, s, COL_NORM); 
    }
    
}


#define F b->statsfifo

void sf_wwl_func(gpointer key, gpointer value, gpointer user_data){
    gchar       *wwl;
    gint        *count;
    GIndexArray *ia;
    
    
    wwl   = (gchar *)       key;  
    count = (gint *)        value;
    ia    = (GIndexArray *) user_data;

    g_index_array_add(ia, g_strdup_printf("%s:%4d     ", wwl, *count));
}

#define COLS 4
void add_sf_wwls(struct band *b){
    GString *gs;
    GIndexArray *ia;
    int i,j,k,lines;
    gchar *c;
    
    fifo_addf(F, "");
    fifo_addf(F, TEXT(T_SF_WWLS), g_hash_table_size(b->stats->wwls));
    fifo_addf(F, TEXT(T_SF_WWLS_UNDER));
    
    ia = g_index_array_new();
    g_hash_table_foreach(b->stats->wwls, sf_wwl_func, ia);
    g_index_array_qsort(ia, compare_gstring);

    j = 0;
    gs = g_string_new("");
    lines=(ia->len+COLS-1)/COLS;
    
    for (i=0; i<lines ; i++){
        for (j=0;j<COLS; j++){
            k = i+j*lines;
            if (k>=ia->len) continue;
            c = (gchar *)g_index_array_index(ia, k);
            g_string_append(gs, c);        
        }
        fifo_addf(F, "%s", gs->str);
        g_string_truncate(gs, 0);
    }
    g_string_free(gs,1);
    g_index_array_free_all(ia);
}

void sf_dxc_func(gpointer key, gpointer value, gpointer user_data){
    gchar       *dxc;
    gint        *count;
    GIndexArray *ia;
    
    
    dxc   = (gchar *)       key;  
    count = (gint *)        value;
    ia    = (GIndexArray *) user_data;

    g_index_array_add(ia, g_strdup_printf("%4s:%4d     ", dxc, *count));
}

#undef COLS
#define COLS 4
void add_sf_dxcs(struct band *b){
    GString *gs;
    GIndexArray *ia;
    int i,j,k,lines;
    gchar *c;
    
    fifo_addf(F, "");
    fifo_addf(F, TEXT(T_SF_DXCS), g_hash_table_size(b->stats->dxcs));
    fifo_addf(F, TEXT(T_SF_DXCS_UNDER));
    
    ia = g_index_array_new();
    g_hash_table_foreach(b->stats->dxcs, sf_dxc_func, ia);
    g_index_array_qsort(ia, compare_gstring);

    j = 0;
    gs = g_string_new("");
    lines = (ia->len+COLS-1)/COLS;
    for (i=0; i<lines ; i++){
        for (j=0;j<COLS; j++){
            k = i+j*lines;
            if (k>=ia->len) continue;
            c = (gchar *)g_index_array_index(ia, k);
            g_string_append(gs, c);        
        }
        fifo_addf(F, "%s", gs->str);
        g_string_truncate(gs, 0);
    }
    g_string_free(gs,1);
    g_index_array_free_all(ia);
}

void add_sf_wkd_wwls(struct band *b){
    int w,len, lines, i, j, myw, myh;
    GString *gs;

    fifo_addf(F, "");
    fifo_addf(F, TEXT(T_SF_WKD_WWLS), g_hash_table_size(b->stats->wwls));
    fifo_addf(F, TEXT(T_SF_WKD_WWLS_UNDER));
    
    w=term->x - 2;
    len = w / 5;
    lines = len;
    
    myh = qthwr(ctest->pwwlo, 0);
    myw = qthwr(ctest->pwwlo, 1);

   /* fifo_addf(F, "w: %d, h:%d ", myw, myh);*/

    gs=g_string_new("");
    
    for(i=0; i<lines ; i++){
        g_string_truncate(gs,0);
        for (j=0; j<len; j++){
            char s[10];
            int aw, ah;
            
            aw = lines-i - lines/2; 
            ah = j - len/2;

            if (aw==0 && ah==0){
                g_string_append(gs, ">QTH<");
                continue;
            }
            mkwwl4(s, aw+ myw , ah + myh);

            if (g_hash_table_lookup(b->stats->wwls, s)){
                g_string_append(gs, "     ");
                continue;
            }
            g_string_sprintfa(gs, " %s", s); 
            
        }
        fifo_addf(F, "%s", gs->str);
    }
    g_string_free(gs, 1);
}


void add_sf_cnt_in_wwls(struct band *b){
    int w,len, lines, i, j, myw, myh;
    GString *gs;

    fifo_addf(F, "");
    fifo_addf(F, TEXT(T_SF_QSO_WWL4), g_hash_table_size(b->stats->wwls));
    fifo_addf(F, TEXT(T_SF_QSO_WWL4_UNDER));
    
    w=term->x - 2;
    len = w / 5;
    lines = len;
    
    myh = qthwr(ctest->pwwlo, 0);
    myw = qthwr(ctest->pwwlo, 1);

    /*fifo_addf(F, "w: %d, h:%d ", myw, myh);*/

    gs=g_string_new("");
    
    for(i=0; i<lines ; i++){
        g_string_truncate(gs,0);
        for (j=0; j<len; j++){
            char s[10];
            gint *cnt;
            int aw, ah;
            
            
            aw = lines-i - lines/2; 
            ah = j - len/2;

            mkwwl4(s, aw+ myw , ah + myh);

            if ((cnt = (gint *)g_hash_table_lookup(b->stats->wwls, s))!=NULL){
                if (aw==0 && ah==0){
                    g_string_sprintfa(gs, ">%3d<", *cnt);
                }else{
                    g_string_sprintfa(gs, " %3d ", *cnt); 
                }
                continue;
            }
            g_string_append(gs, "     ");
        }
        fifo_addf(F, "%s", gs->str);
    }
    g_string_free(gs, 1);
}

void add_sf_top_dx(struct band *b)
{
#define TOPS_NUM	10
	int i, cnt;
	signed int j;
	struct qso *q, *top[TOPS_NUM];

	memset(top, 0, TOPS_NUM * sizeof(struct qso *));
	for (i = 0; i < b->qsos->len; i++) {
		if (!top[0]) { /* init first item */
			q = get_qso(b, i);
			if (!q->error && !q->dupe) {
				cnt = 0;
				top[cnt++] = q;
				/*dbg("init: %s %u\n=\n", top[0]->callsign, (int) top[0]->qrb);*/
			}
			continue;
		}

		q = get_qso(b, i);
		/*dbg("selected %u: %s %u\n", i, q->callsign, (int) q->qrb);*/
		if (q->error || q->dupe)
			continue;

		if (cnt >= TOPS_NUM)
			cnt = TOPS_NUM - 1;
		
		/* initialize or find top dx and sort top array */
		if (!top[cnt] || q->qrb > top[cnt]->qrb) {
			for (j = cnt; j >= 0; j--) {
				if (j && q->qrb > top[j - 1]->qrb) {
					top[j] = top[j - 1]; /* move down */
					/*dbg("down %u: %s %u\n", j, top[j]->callsign, (int) top[j]->qrb);*/
				} else {
					top[j] = q; /* insert */
					cnt++;
					/*dbg("insert %u: %s %u\n", j, top[j]->callsign, (int) top[j]->qrb);*/
					break;
				}
			}
		}
	}

	fifo_addf(F, "");
	fifo_addf(F, TEXT(T_SF_TOP_DX), TOPS_NUM);
	fifo_addf(F, TEXT(T_SF_TOP_DX_UNDER));
	for (i = 0; i < TOPS_NUM && i < b->qsos->len && top[i]; i++) {
		q = top[i];
		fifo_addf(F, "%-12s  %-6s  %u km  (%s)", q->callsign, q->locator, (int) q->qrb, q->operator);
	}
}


void recalc_statsfifo(struct band *b){
    
    if (!b || !b->dirty_statsf) return;

/*    ST_START;*/
    free_fifo(F);
    F = init_fifo(1000);
    F->withouttime = 1;

    fifo_addf(F, "");
    fifo_addf(F, TEXT(T_SF_STATS_BAND), b->pband);
    fifo_addf(F, TEXT(T_SF_STATS_BAND_UNDER));
    fifo_addf(F, "");

    if (b->stats->nqsos>0){
        fifo_addf(F, TEXT(T_SF_AVG_PTS), ((double)b->stats->ntotal) / ((double)b->stats->nqsos));
        fifo_addf(F, TEXT(T_SF_AVG_QSOP), ((double)b->stats->nqsop) / ((double)b->stats->nqsos));
    }
    fifo_addf(F, "");

    add_sf_wkd_wwls(b);
    add_sf_cnt_in_wwls(b);
    add_sf_wwls(b);
    add_sf_dxcs(b);
	add_sf_top_dx(b);

    fifo_addf(F, "");
    b->dirty_statsf = 0;
    /*ST_STOP;*/
}

/* Exports statistics of actual band to a text file */
void export_stats_fifo(void) {
	gchar *fname;
	int i;
	
	fname = NULL;
	for (i = 0; 1; i++) {
		struct stat st;
		
		fname = g_strdup_printf("%s/stat%c%d.txt", ctest->directory, aband->bandchar, i);
		if (stat(fname, &st) != 0)
			break;

		g_free(fname);
		fname = NULL;
	}
	
	recalc_statsfifo(aband);
	save_fifo_to_file(aband->statsfifo, fname);
	
	g_free(fname);
}
