/*
    Tucnak - VHF contest log
    Copyright (C) 2002-2006  Ladislav Vaiz <ok1zia@nagano.cz>
    and authors of web browser Links 0.96

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public
    License along with this library; if not, write to the Free
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/

#include <header.h>

#include <sched.h>

#ifdef HAVE_GC
#include <leak_detector.h>
#endif

int retval = RET_OK;
int starting_sbrk;

void unhandle_basic_signals(struct terminal *);

    
void sig_terminate(struct terminal *t)
{
    unhandle_basic_signals(t);
    terminate = 1;
    retval = RET_SIGNAL;
}

void sig_intr(struct terminal *t)
{
    if (!t) {
        unhandle_basic_signals(t);
        terminate = 1;
    } else {
        unhandle_basic_signals(t);
        exit_prog(t, NULL, NULL);
    }
}

void sig_ctrl_c(struct terminal *t)
{
    if (!is_blocked()) kbd_ctrl_c();
}

void sig_ign(void *x)
{
}

void sig_tstp(struct terminal *t)
{
#ifdef SIGSTOP
    int pid = getpid();
    block_itrm(0);
#if defined (SIGCONT) && defined(SIGTTOU)
    if (!fork()) {
        sleep(1);
        kill(pid, SIGCONT);
        exit(0);
    }
#endif
    raise(SIGSTOP);
#endif
}

void sig_cont(struct terminal *t)
{
    if (!unblock_itrm(0)) /*redraw_terminal_cls(t)*/resize_terminal();
    /*else register_bottom_half(raise, SIGSTOP);*/
}

void sig_segv(struct terminal *t){
    printf("\n\n\n  sig_segv()  \n\n\n");
/*    signal(SIGSEGV, SIG_DFL);*/
    install_signal_handler(SIGSEGV, NULL, NULL, 0);
    ssbd_safe_abort(ssbd);
    cwdaemon_safe_abort(cwda);
    raise(SIGSEGV);
}   
    
void handle_basic_signals(struct terminal *term)
{
    install_signal_handler(SIGHUP, (void (*)(void *))sig_intr, term, 0);
    install_signal_handler(SIGINT, (void (*)(void *))sig_ctrl_c, term, 0);
    install_signal_handler(SIGTERM, (void (*)(void *))sig_terminate, term, 0);
#ifdef SIGTSTP
    install_signal_handler(SIGTSTP, (void (*)(void *))sig_tstp, term, 0);
#endif
#ifdef SIGTTIN
    install_signal_handler(SIGTTIN, (void (*)(void *))sig_tstp, term, 0);
#endif
#ifdef SIGTTOU
    install_signal_handler(SIGTTOU, (void (*)(void *))sig_ign, term, 0);
#endif
#ifdef SIGCONT
    install_signal_handler(SIGCONT, (void (*)(void *))sig_cont, term, 0);
#endif
    install_signal_handler(SIGSEGV, (void (*)(void *))sig_segv, term, 1);
}

/*void handle_slave_signals(struct terminal *term)
{
    install_signal_handler(SIGHUP, (void (*)(void *))sig_terminate, term, 0);
    install_signal_handler(SIGINT, (void (*)(void *))sig_terminate, term, 0);
    install_signal_handler(SIGTERM, (void (*)(void *))sig_terminate, term, 0);
#ifdef SIGTSTP
    install_signal_handler(SIGTSTP, (void (*)(void *))sig_tstp, term, 0);
#endif
#ifdef SIGTTIN
    install_signal_handler(SIGTTIN, (void (*)(void *))sig_tstp, term, 0);
#endif
#ifdef SIGTTOU
    install_signal_handler(SIGTTOU, (void (*)(void *))sig_ign, term, 0);
#endif
#ifdef SIGCONT
    install_signal_handler(SIGCONT, (void (*)(void *))sig_cont, term, 0);
#endif
}*/

void unhandle_terminal_signals(struct terminal *term)
{
    install_signal_handler(SIGHUP, NULL, NULL, 0);
    install_signal_handler(SIGINT, NULL, NULL, 0);
#ifdef SIGTSTP
    install_signal_handler(SIGTSTP, NULL, NULL, 0);
#endif
#ifdef SIGTTIN
    install_signal_handler(SIGTTIN, NULL, NULL, 0);
#endif
#ifdef SIGTTOU
    install_signal_handler(SIGTTOU, NULL, NULL, 0);
#endif
#ifdef SIGCONT
    install_signal_handler(SIGCONT, NULL, NULL, 0);
#endif
    install_signal_handler(SIGSEGV, NULL, NULL, 0);
}

void unhandle_basic_signals(struct terminal *term)
{
    install_signal_handler(SIGHUP, NULL, NULL, 0);
    install_signal_handler(SIGINT, NULL, NULL, 0);
    install_signal_handler(SIGTERM, NULL, NULL, 0);
#ifdef SIGTSTP
    install_signal_handler(SIGTSTP, NULL, NULL, 0);
#endif
#ifdef SIGTTIN
    install_signal_handler(SIGTTIN, NULL, NULL, 0);
#endif
#ifdef SIGTTOU
    install_signal_handler(SIGTTOU, NULL, NULL, 0);
#endif
#ifdef SIGCONT
    install_signal_handler(SIGCONT, NULL, NULL, 0);
#endif
    install_signal_handler(SIGSEGV, NULL, NULL, 0);
}

int attach_terminal(int in, int out, int ctl, void *info, int len)
{
    /*struct terminal *term;*/
    int fd[2];
    if (c_pipe(fd)) {
        mem_free(info);
        error("ERROR: can't create pipe for internal communication");
        return -1;
    }
    fcntl(fd[0], F_SETFL, O_NONBLOCK);
    fcntl(fd[1], F_SETFL, O_NONBLOCK);
    handle_trm(in, out, out, fd[1], ctl, info, len);
    mem_free(info);
    if ((term = init_term(fd[0], out, win_func))) {
        handle_basic_signals(term); /* OK, this is race condition, but it must be so; GPM installs it's own buggy TSTP handler */
        return fd[1];
    }
    close(fd[0]);
    close(fd[1]);
    return -1;
}

/*struct status dump_stat;*/
int dump_pos;

int ac;
char **av;

char *path_to_exe;

/*int init_b = 0;*/

void *create_session_info(int cp, char *url, int *ll)                  
{                                                                               
        int l = strlen(url);                                                    
        int *i;                                                                 
        *ll = 2 * sizeof(int) + l;                                              
        if (!(i = mem_alloc(2 * sizeof(int) + l))) return NULL;                 
        i[0] = cp;                                                              
        i[1] = l;                                                               
        memcpy(i + 2, url, l);                                                  
        return i;                                                               
}                                                                               

char system_name[MAX_STR_LEN];
char *tucnak_home = NULL;
int first_use = 0;

void get_system_name(void)
{
    FILE *f;
    char *p;
    memset(system_name, 0, MAX_STR_LEN);
    if (!(f = popen("uname -srm", "r"))) goto fail;
    if (fread(system_name, 1, MAX_STR_LEN - 1, f) <= 0) {
        pclose(f);
        goto fail;
    }
    pclose(f);
    for (p = system_name; *p; p++) if (*p < ' ') {
        *p = 0;
        break;
    }
    if (system_name[0]) return;
    fail:
    strcpy(system_name, SYSTEM_NAME);
}

char *get_home(int *n)
{
    struct stat st;
    char *home = stracpy(getenv("HOME"));
    char *home_tucnak;
    char *config_dir = stracpy(getenv("CONFIG_DIR"));

    if (n) *n = 1;
    if (!home) {
        int i;
        home = stracpy(path_to_exe);
        if (!home) {
            if (config_dir) mem_free(config_dir);
            return NULL;
        }
        for (i = strlen(home) - 1; i >= 0; i--) if (dir_sep(home[i])) {
            home[i + 1] = 0;
            goto br;
        }
        home[0] = 0;
        br:;
    }
    while (home[0] && dir_sep(home[strlen(home) - 1])) home[strlen(home) - 1] = 0;
    if (home[0]) add_to_strn(&home, "/");
    home_tucnak = stracpy(home);
    if (config_dir)     
    {
        add_to_strn(&home_tucnak, config_dir);
        while (home_tucnak[0] && dir_sep(home_tucnak[strlen(home_tucnak) - 1])) home_tucnak[strlen(home_tucnak) - 1] = 0;
        if (stat(home_tucnak, &st) != -1 && S_ISDIR(st.st_mode)) {
            add_to_strn(&home_tucnak, "/tucnak");
            } else {
            fprintf(stderr, "CONFIG_DIR set to %s. But directory %s doesn't exist.\n\007", config_dir, home_tucnak);
            sleep(3);
            mem_free(home_tucnak);
            home_tucnak = stracpy(home);
            add_to_strn(&home_tucnak, "tucnak");        
        }
        mem_free(config_dir);
    } else add_to_strn(&home_tucnak, "tucnak");
    if (stat(home_tucnak, &st)) {
        if (!mkdir(home_tucnak, 0777)) goto home_creat;
        if (config_dir) goto failed;
        goto first_failed;
    }
    if (S_ISDIR(st.st_mode)) goto home_ok;
    first_failed:
    mem_free(home_tucnak);
    home_tucnak = stracpy(home);
    add_to_strn(&home_tucnak, "tucnak");
    if (stat(home_tucnak, &st)) {
        if (!mkdir(home_tucnak, 0777)) goto home_creat;
        goto failed;
    }
    if (S_ISDIR(st.st_mode)) goto home_ok;
    failed:
    mem_free(home_tucnak);
    mem_free(home);
    return NULL;

    home_ok:
    if (n) *n = 0;
    home_creat:
#ifdef HAVE_CHMOD
    chmod(home_tucnak, 0700);
#endif
    add_to_strn(&home_tucnak, "/");
    mem_free(home);
    return home_tucnak;
}

void init_home(void)
{
    get_system_name();
    tucnak_home = get_home(&first_use);
    if (!tucnak_home) {
        fprintf(stderr, "Unable to find or create tucnak config directory. Please check, that you have $HOME variable set correctly and that you have write permission to your home directory.\n\007");
        sleep(3);
        return;
    }
}


void init(void)
{
    void *info;
    int len;
    
    parse_options(ac, av);
    init_debug();

    init_trans();
    init_rc();
    term_spec_init();
	
    set_sigcld();
    init_home();
    init_keymaps();
    	
    if (!((info = create_session_info(0, "", &len)) && attach_terminal(get_input_handle(), get_output_handle(), get_ctl_handle(), info, len) != -1)) {
        retval = RET_FATAL;
        terminate = 1;
    } 
    
	glog = init_fifo(1000);        
    gtalk = init_fifo(1000);        
    gsked = init_fifo(1000);        

    
	read_rc_files();

    
	cw = init_cw();
    dw = init_dw();
    wizz = init_wizz();
	namedb = init_namedb();
	sdevlist = init_sdevlist();
    init_rotars();

    disable_screensaver();
    
	read_cw_files(cw);
    read_dw_files(dw);
    read_wizz_files(wizz);
	read_namedb_files(namedb);
	/*read_ebw_files(cw,namedb);*/
    
    net = init_net();
    cwda = init_cwdaemon();
    ssbd = init_ssbd();

    spotdb = init_spotdb();
    
    
    /*check_susp();*/
    
#ifdef HAVE_SDL
/*    if (!gfx){
        gfx = init_gfx();
    }*/
    
#endif
}

void terminate_all_subsystems(void)
{
#ifdef HAVE_SDL
    free_gfx();
#endif
    free_dw(dw);
    free_cw(cw);
    free_wizz(wizz);
	free_namedb(namedb);
    free_rotars();
	free_sdevlist(sdevlist);
    free_spotdb(spotdb);
    free_net(net);
    free_cwdaemon(cwda);
    free_ssbd(ssbd);
	
    free_fifo(glog);
    free_fifo(gtalk);
    free_fifo(gsked);
	
    check_bottom_halves();
    check_bottom_halves();
	check_bottom_halves();

    free_namelist();
    free_all_itrms();
    shrink_memory(1);

    free_history_lists();
    free_term_specs();
    free_keymaps();
    free_conv_table();
    check_bottom_halves();
    check_bottom_halves();
    destroy_all_terminals();

    if (tucnak_home) mem_free(tucnak_home);

    shutdown_trans();
    terminate_osdep();
    free_debug();
}

int main(int argc, char *argv[])
{
    
#ifdef GAVE_GC    
    GC_find_leak = 1;
#endif 
    

    path_to_exe = argv[0];
    ac = argc;
    av = (char **)argv;

    starting_sbrk = (int)sbrk;
    dbg("\n\n");
    select_loop(init);
    terminate_all_subsystems();

    check_memory_leaks();
    
#ifdef HAVE_GC    
    dbg("CHECK_LEAKS()\n");
    CHECK_LEAKS();
    CHECK_LEAKS();
    CHECK_LEAKS();
    dbg("END\n");
#endif    
    return retval;
}


void shrink_memory(int u)
{
/*  shrink_dns_cache(u);
    shrink_format_cache(u);
    garbage_collection(u);
    delete_unused_format_cache_entries();*/
}
