/*
    Tucnak - VHF contest log
    Copyright (C) 2002-2006  Ladislav Vaiz <ok1zia@nagano.cz>

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public
    License along with this library; if not, write to the Free
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/

#include "header.h"

#define HTML_STR(item) ((item)?qh(gs2, item):"")
#define HTML_STR_UC(item) ((item)?uc(qh(gs2, item)):"")

#define HTML_QSO_STR(item) g_string_sprintfa(gs, "<td>%s </td> ", qh(gs2, item));
#define HTML_QSO_INT(item) g_string_sprintfa(gs, "<td align=\"right\">%d </td> ", item);

#define HTML_HDR(item) g_string_sprintfa(gs, "<th bgcolor=\"#e4b97c\"><font color=\"#800000\">%s</font></th>\n", item);
gchar *qh(GString *gs, gchar *s){
	char *c;

    g_string_truncate(gs,0);
    if (!s) return gs->str;
    
	for (c=s; *c!='\0'; c++) {
        switch (*c){
            case '<':
                g_string_append(gs, "&lt;");
                break;
            case '>':
                g_string_append(gs, "&gt;");
                break;
            case '"':
                g_string_append(gs, "&quot;");
                break;
            case '&':
                g_string_append(gs, "&amp;");
                break;
            case '\'':
                g_string_append(gs, "&#39;");
                break;
            default:
                g_string_append_c(gs, *c);    
        }
    }
	return gs->str;
}
  
int write_html_header(struct band *b, struct config_band *confb, FILE *f){
    GString *gs, *gs2;
    int ret;
    
    gs = g_string_sized_new(1024);
    gs2 = g_string_sized_new(1024);

    g_string_sprintfa(gs, 
"<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\">\n"
"<html><head>\n"
"<meta http-equiv=\"content-type\" content=\"text/html; charset=iso-8859-2\">\n"
"<style type=\"text/css\">\n"
"body {\n"
"    font-size: 12pt;\n"
/*"    font-family: Tahoma, Helvetica, Arial, sans-serif}\n"*/
"    font-family: Courier, Courier-new}\n"

"a {\n"
"    font-weight: bold}\n"

"h1, h2, h3, h4 {\n"
"    font-family: Tahoma, Helvetica, Arial, sans-serif;\n"
"    color: #f8f8f8};\n"

"h2 {\n"
"    margin-top: 20;\n"
"    margin-bottom: 5;\n"
"    margin-left:10 }\n"
/*
input {                                                                        
    padding: 2px;
    margin: 2px;
    font-weight: normal; 
    font-size: 12px; 
    color: #000000; 
    font-family: sans-serif}                                                                               

li {
    margin-bottom: 20px
}

p.stress{
    font-style: italic}
      */
"table.qsos {\n"
"    border: black 2px solid;\n"
"    padding: 5px;\n"
"    background: #606060}\n"

"th {\n"
"    padding-left: 5px;\n"
"    padding-right: 5px}\n"

"td {\n"
"    padding-left: 5px;\n"
"    padding-right: 5px}\n"


"</style>");

    g_string_sprintfa(gs, 
"<title>%s", uc(qh(gs2, ctest->pcall)));
    g_string_sprintfa(gs, 
" - %s</title>\n", qh(gs2, ctest->tname));
    
    g_string_sprintfa(gs, 
"</head>\n<body text=\"#ffffff\" bgcolor=\"#3f4e66\" link=\"#ddad6a\" vlink=\"#cd9d5a\" alink=\"#edbd7a\">"
"<center>\n");
    

    g_string_sprintfa(gs, 
"<center><h1>%s", uc(qh(gs2, ctest->pcall)));
    g_string_sprintfa(gs, 
" - %s</h1></center>\n", qh(gs2, ctest->tname));
    
/*    if (!b->qsos->len)
        g_string_sprintfa(gs, "<p>Date=%s</p>\n", qh(gs2, ctest->cdate)); 
    else
        g_string_sprintfa(gs, "<p>Date=%d - %d</p>\n", b->stats->first_date, b->stats->last_date); 
 */
/*   g_string_sprintfa(gs, "</tr>\n");*/
    ret=fprintf(f, "%s", gs->str) != gs->len;
    g_string_free(gs, TRUE);
    g_string_free(gs2, TRUE);
    
    return ret;
}
    
int write_band_header(struct band *b, struct config_band *confb, FILE *f){
    GString *gs, *gs2;
    int ret;
    
    gs = g_string_sized_new(1024);
    gs2 = g_string_sized_new(1024);

    g_string_sprintfa(gs, "<h2>Band %s</h2>", qh(gs2, confb->adifband));
    g_string_sprintfa(gs, "<p>QSOs: %d<br>", b->stats->nqsos);
    g_string_sprintfa(gs, "Points: %d<br>", b->stats->ntotal);
    g_string_sprintfa(gs, "WWLs: %d<br>", g_hash_table_size(b->stats->wwls));
    g_string_sprintfa(gs, "DXCCs: %d<br>", g_hash_table_size(b->stats->dxcs));
    if (b->stats->nqsos){
        g_string_sprintfa(gs, "AVG: %5.2f pts/km<br>", (double)b->stats->ntotal/(double)b->stats->nqsos);
    }
    g_string_sprintfa(gs, "</p>");
    g_string_sprintfa(gs, "<img src=\"snap%c0.%s\" width=800 height=600 alt=\"polar map for %s\">",b->bandchar,SHOTEXT,b->pband);
	g_string_sprintfa(gs, "<br><br>\n\n<table class=\"qsos\">\n");
	g_string_sprintfa(gs, "<tr>\n");
    HTML_HDR("DATE");
	/*HTML_HDR("BAND");*/
	HTML_HDR("MODE");
	HTML_HDR("TIME");
	HTML_HDR("CALLSIGN");
	HTML_HDR("TX");
	HTML_HDR("RX");
	HTML_HDR("LOCATOR");
	HTML_HDR("QRB");
	HTML_HDR("REMARK");
    
	g_string_sprintfa(gs, "</tr>\n");
    ret=fprintf(f, "%s", gs->str) != gs->len;
    g_string_free(gs, TRUE);
    g_string_free(gs2, TRUE);
    
    return ret;
}

int write_band_footer(struct band *b, struct config_band *confb, FILE *f){
    GString *gs, *gs2;
    int ret=0;

    gs = g_string_sized_new(1024);
    gs2 = g_string_sized_new(1024);

    g_string_sprintfa(gs,"</table>\n\n");
    ret=fprintf(f, "%s", gs->str) != gs->len;
    g_string_free(gs, TRUE);
    g_string_free(gs2, TRUE);
    return ret;
}
    
int write_html_footer(struct band *x_b, struct config_band *x_confb, FILE *f){
    GString *gs, *gs2;
    int ret;

    gs = g_string_sized_new(1024);
    gs2 = g_string_sized_new(1024);

/*    g_string_sprintfa(gs,"</table>\n\n");*/
    
    g_string_sprintfa(gs, "<p>Created by <a href=\"http://tucnak.nagano.cz\">TUCNAK</a> ver. %s</p>\n", VERSION_STRING);

    g_string_sprintfa(gs, 
"<p>\n"
"<a href=\"http://validator.w3.org/check/referer\">\n"
"<img border=\"0\" src=\"valid-html401.png\"\n"
"     alt=\"Valid HTML 4.01!\" height=\"31\" width=\"88\"></a>&nbsp;\n"
"\n"

"<a href=\"http://www.anybrowser.org/campaign/\">"
"<img src=\"bestviewed.gif\" alt=\"Viewable with any browser\"" 
"     width=\"80\" height=\"31\" border=\"0\"></a>&nbsp;"
"</p><br><br>\n"
"</center>"
"</body></html>\n");
    ret=fprintf(f, "%s", gs->str) != gs->len;
    g_string_free(gs, TRUE);
    g_string_free(gs2, TRUE);
    return ret;
}

int write_html_qsos(struct band *b, struct config_band *confb, FILE *f){
    struct qso *q;
    GString *gs, *gs2;
    int i,j;
    int ret;
	char *html_modes[]={
		"?",
		"SSB",
		"CW",
		"CWs",
		"CWr",
		"AM",
		"FM",
		"RTTY",
		"SSTV",
		"ATV"
	};
		

    gs = g_string_new("");
    gs2 = g_string_new("");
    
    
    j=0;
    for (i=0; i<b->qsos->len; i++){
        char time[10];
        gchar *c;
        
        q = get_qso(b, i); 
        if (q->error) continue;
		
		if (j++%2)
            g_string_sprintfa(gs, "<tr bgcolor=\"#505050\">\n");
        else
     		g_string_sprintfa(gs, "<tr bgcolor=\"#606060\">\n");

        strcpy(time, q->time_str);
        time[2]='.'; time[3]=q->time_str[2]; time[4]=q->time_str[3]; time[5]='\0';
        
		HTML_QSO_STR(q->date_str);
     	HTML_QSO_STR(html_modes[abs(q->mode)%10]);
		HTML_QSO_STR(time);
        HTML_QSO_STR(q->callsign);

        c = g_strdup_printf("%s %s", q->rsts, q->qsonrs);
		HTML_QSO_STR(c);
        g_free(c);
        
        c = g_strdup_printf("%s %s", q->rstr, q->qsonrr);
		HTML_QSO_STR(c);
        g_free(c);

		HTML_QSO_STR(q->locator);
		HTML_QSO_INT((int)q->qrb);
		HTML_QSO_STR(q->remark);
        
		g_string_sprintfa(gs, "</tr>\n");
    }
    
    ret=fprintf(f, "%s", gs->str) != gs->len;
    g_string_free(gs, TRUE);
    g_string_free(gs2, TRUE);
    
    return ret;
}


int export_all_bands_html(){
    struct band *band;
    struct config_band *confb;
    int i, err;
    gchar *filename;
    FILE *f;
    char callbuf[20];
    int ignoreerror=0;
    int header_saved=0;
    
    if (!ctest) return -1;
    
    dbg("export_all_bands_html()\n");
	
	filename = g_strdup_printf("%s/%s_%s.html",
					ctest->directory,
					ctest->cdate,
					uc(get_raw_call(callbuf,ctest->pcall)));
        
	f=fopen(filename,"wt");
	if (!f) {
		if (!ignoreerror) { errbox(TEXT(T_CANT_WRITE), errno); ignoreerror=1;}
		g_free(filename);
		return -1;
	}
    
    err = 0;
	
    for (i=0; i<ctest->bands->len; i++){
        band = g_ptr_array_index(ctest->bands, i);
        confb = get_config_band_by_bandchar(band->bandchar);

        if (band->stats->nqsos <=0) continue;

        if (!header_saved){
            err|=write_html_header(band,confb,f);
            header_saved=1;
        }
        err|=write_band_header(band,confb,f);
        err|=write_html_qsos  (band,confb,f);
        err|=write_band_footer(band,confb,f);
    }
    write_html_footer(NULL, NULL, f);
	
	fclose(f);
	if (err) {
		if (!ignoreerror) { errbox(TEXT(T_CANT_WRITE), 0); ignoreerror=1; }
		g_free(filename);
		return -1;
	}
	log_addf(TEXT(T_SAVED_S), filename);
	g_free(filename);
    return 0;
}

