/**
 * Copyright (C) 2007-2012 Lawrence Murray
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the Free
 * Software Foundation; either version 2 of the License, or (at your option)
 * any later version.
 * 
 * @author Lawrence Murray <lawrence@indii.org>
 * $Rev: 363 $
 * $Date: 2012-01-22 18:45:43 +0800 (Sun, 22 Jan 2012) $
 */
#ifndef INDII_TINT_GUI_PREPROCESSPANE_HPP
#define INDII_TINT_GUI_PREPROCESSPANE_HPP

#include "../model/ClusterModel.hpp"
#include "../model/ClusterModelObserver.hpp"
#include "../../gui/Pane.hpp"

#include "wx/spinctrl.h"
#include "wx/textctrl.h"

namespace indii {
/**
 * Preprocess settings pane.
 */
class PreProcessPane : public Pane, public ClusterModelObserver {
public:
  /**
   * Constructor.
   *
   * @param parent Parent.
   */
  PreProcessPane(wxWindow* parent);

  /**
   * Set model.
   *
   * @param model Model.
   */
  void setModel(ClusterModel* model);  

  /*
   * Handle model changes.
   */
  virtual void notifyNumRepetitionsChange();
  virtual void notifyMaxPixelsChange();
  virtual void notifySaturationThresholdChange();

  /*
   * Handle control events.
   */
  void OnSpinReps(wxSpinEvent& evt);
  void OnSpinSat(wxSpinEvent& evt);
  void OnTextMaxPixels(wxCommandEvent& evt);

  /**
   * Context sensitive help.
   */
  void OnHelp(wxHelpEvent& evt);

private:
  /**
   * Cluster model.
   */
  ClusterModel* model;

  /*
   * Controls.
   */
  wxSpinCtrl *spinReps, *spinSat;
  wxTextCtrl *textMaxPixels;

  /*
   * Control ids.
   */
  enum ID {
    ID_SPIN_REPS,
    ID_SPIN_SAT,
    ID_TEXT_MAX_PIXELS,
  };

  DECLARE_EVENT_TABLE()
};
}

#endif
