/**
 * Copyright (C) 2007-2012 Lawrence Murray
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the Free
 * Software Foundation; either version 2 of the License, or (at your option)
 * any later version.
 * 
 * @author Lawrence Murray <lawrence@indii.org>
 * $Rev: 398 $
 * $Date: 2012-02-19 21:47:34 +0800 (Sun, 19 Feb 2012) $
 */
#include "FileImageResource.hpp"

using namespace indii;

FileImageResource::FileImageResource(const wxString& path) {
  /* original image */
  original = new wxImage();
  if (!original->LoadFile(path)) {
    throw 1;
  }
  
  /* caches */
  lowCache = new ImageCache(original, false);
  highCache = new ImageCache(original, true);
}

FileImageResource::~FileImageResource() {
  delete lowCache;
  delete highCache;  
  delete original;
}
