/* TABLIX, PGA highschool timetable generator                              */
/* Copyright (C) 2002 Tomaz Solc                                           */

/* This program is free software; you can redistribute it and/or modify    */
/* it under the terms of the GNU General Public License as published by    */
/* the Free Software Foundation; either version 2 of the License, or       */
/* (at your option) any later version.                                     */

/* This program is distributed in the hope that it will be useful,         */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of          */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the           */
/* GNU General Public License for more details.                            */

/* You should have received a copy of the GNU General Public License       */
/* along with this program; if not, write to the Free Software             */
/* Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA */

/* $Id: teacher_holes.c,v 1.4 2003/10/28 20:41:26 avian Exp $ */

/* 
 * AUTHOR:
 *  
 *  Tomaz Solc <tomaz.solc@siol.net>
 *
 * DESCRIPTION:
 *
 *  Adds a weight for each hole (free period) in the teacher's timetable. For 
 *  example: two free periods surrounded by non-free periods add two weights.
 *
 */

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include "data.h"
#include "gettext.h"

int grade_function(chromo *t, int *cpnt, int *tpnt, int **start, int **lead)
{
	int a,b,c;
	int first,last;
	int free,nonfree;
	int sum;

	sum=0;

        for(c=0;c<tmapnum;c++) {
                for(a=0;a<DAYS;a++) {
                        b=0;
			first=-1;
			last=-1;
			free=0;
			nonfree=0;
                        while (b<PERIODS) {
                                if (*tpnt==-1) {
					free++;
				} else {
					nonfree++;
					last=b;
					if (first==-1) first=b;
				}
                                b++;
				tpnt++;
                        }

			if (last!=-1) sum=sum+(PERIODS-nonfree-first-(PERIODS-1-last));
                }
        };
	return(sum);
};
