// This is a very simple binary clock.
// It still needs some tweaking to look good in every situation,
// but at the moment it's good enough to demonstrate that
// non-analog clocks are possible too ;)

maxWidth = 70;
maxHeight = 40;

dotCol = getColor("Dot", 0.5, 0.5, 0.5);

if (showSeconds) {
	scale = Math.min(screenHeight/3, screenWidth/6);
	yOffset = screenHeight/2 - scale*3/2; 
}
else {
	scale = Math.min(screenHeight/2, screenWidth/6);
	yOffset = screenHeight/2 - scale;
}

function printNumber(n, maxN, line) {
	i = n;
	maxI = maxN;
	pos = 0;	
	while (maxI > 0) {
		if (i%2==1) {
			obj1 = defineLayer("dot.png");
			obj2 = defineLayer("dot_highlight.png");
			obj1.color.r = dotCol.r;
			obj1.color.g = dotCol.g;
			obj1.color.b = dotCol.b;
			obj1.scaleX = obj1.scaleY = obj2.scaleX = obj2.scaleY = scale;
			obj1.moveX = obj2.moveX = screenWidth - (pos+1)*scale;
			obj1.moveY = obj2.moveY = line*scale + yOffset;
		}
		else {
			obj = defineLayer("nodot.png");
			obj.scaleX = obj.scaleY = scale;
			obj.moveX = screenWidth - (pos+1)*scale;
			obj.moveY = line*scale + yOffset;
		}
		i = Math.floor(i/2);
		maxI = Math.floor(maxI/2);
		++pos;
	} 
}

if (showSeconds) {
	printNumber(second, 59, 0);
	printNumber(minute, 59, 1);
	printNumber(hour, 23, 2);
}
else {
	printNumber(minute, 59, 0);
	printNumber(hour, 23, 1);
}

function widthForHeight(height) {
	if (showSeconds) return Math.min(maxWidth, height*2);
	else return Math.min(maxWidth, height*3);
}

function heightForWidth(width) {
	if (showSeconds) return Math.min(maxHeight, width/2);
	else return Math.min(maxWidth, width/3);
}