#include "miastoplusa.h"
#include "mr_pcre/mr_pcre.h"

using namespace std;

MiastoplusaSMS::MiastoplusaSMS(Config &config) : GenericSMS(config)
{
	mp_user = config["miastoplusa_user"];
	mp_pass = config["miastoplusa_pass"];
	mp_notify = config.isTrue("notify");
}

bool MiastoplusaSMS::Send(const std::string &phone_no, const std::string &message)
{
	bool ok = false;
	CURLcode status;
	Curl_Form form;
	Curl_Result result;
	
	curl.SSL_ignore();
	curl.AutoReferer();
	curl.FollowLocation();
	curl.SetOpt(CURLOPT_COOKIEFILE, "");
	
	while (true) {
		status = curl.PerformGet("http://www.miastoplusa.pl/");
		if (status) throw Exception("[1] - get http://www.miastoplusa.pl/");

		form.AddField("login", mp_user);
		form.AddField("password", mp_pass);
		form.AddField("x", "0");
		form.AddField("y", "0");
		form.AddField("secureLogin", "on");
		status = curl.PerformPost("https://www.miastoplusa.pl/auth/LoginCitizen.do", form.PostFields());
		if (status) throw Exception("[2] - post https://www.miastoplusa.pl/auth/LoginCitizen.do");

		form.Reset();
		form.AddField("smsType", "10");
		form.AddField("prefix", "48");
		form.AddField("phoneNumber", phone_no);
		form.AddField("message", message);
		form.AddField("notifyCode", mp_notify ? "30" : "0");
		form.AddField("validity", "48");
		form.AddField("sendDay", "-1");
		form.AddField("sendHour", "0");
		form.AddField("sendMin", "0");
		form.AddField("archiveMessage", "0");
		form.AddField("flashMessage", "0");
		form.AddField("userId", "0");
		form.AddField("groupId", "0");
		form.AddField("templateCategory", "0");
		form.AddField("targetURL", "/sms/send_sms.jsp");
		status = curl.PerformPost("http://www.miastoplusa.pl/sms/SendSMS2.do", form.PostFields());
		if (status) throw Exception("[3] - post http://www.miastoplusa.pl/sms/SendSMS2.do");
		
		ok = curl.Body().find("SMS przekazany do wysania") != string::npos;
		if (!ok) {
			PcreWrap::Array match;
			if (PcreWrap::pcre_match_all("bgcolor=\"#F4C8B6\">(&nbsp;)*([^\\.]*).*<\\/td><\\/tr>", 
				curl.Body(), "mi", match)) 
				throw Exception("[3] - " + match[0][1]);
		}
		
		curl.PerformGet("http://www.miastoplusa.pl/minimal/logout_frameset.jsp");
		
		break;
	}
	
	return ok;
}

bool MiastoplusaSMS::ShowStats()
{
	bool ok = false;
	CURLcode status;
	Curl_Form form;
	Curl_Result result;
	PcreWrap::Array match;
	string st_plus, st_inne;
	
	curl.SSL_ignore();
	curl.AutoReferer();
	curl.FollowLocation();
	curl.SetOpt(CURLOPT_COOKIEFILE, "");
	
	while (true) {
		status = curl.PerformGet("http://www.miastoplusa.pl/");
		if (status) throw Exception("[1] - get http://www.miastoplusa.pl/");

		form.AddField("login", mp_user);
		form.AddField("password", mp_pass);
		form.AddField("x", "0");
		form.AddField("y", "0");
		form.AddField("secureLogin", "on");
		status = curl.PerformPost("https://www.miastoplusa.pl/auth/LoginCitizen.do", form.PostFields());
		if (status) throw Exception("[2] - post https://www.miastoplusa.pl/auth/LoginCitizen.do");
		
		form.Reset();
		form.AddField("targetURL", "/sms/send_sms.jsp");
		status = curl.PerformPost("http://www.miastoplusa.pl/sms/SendSMS2.do", form.PostFields());
		if (status) throw Exception("[3] - post http://www.miastoplusa.pl/sms/SendSMS2.do");
		
		if (PcreWrap::pcre_match_all("do sieci Plus GSM<\\/td><td align(.*?)>(.*?)<\\/td><\\/tr>", 
			curl.Body(), "mi", match)) {
			st_plus = match[0][1];
			if (PcreWrap::pcre_match_all("do innych sieci<\\/td><td align(.*?)>(.*?)<\\/td><\\/tr>",
				curl.Body(), "mi", match)) {
				st_inne = match[0][1];
				ok = true;
			}
		}
		
		cout << "Twoje SMSy do sieci Plus GSM (" << st_plus << "), do innych sieci (" << st_inne << ")." << endl;
		
		curl.PerformGet("http://www.miastoplusa.pl/minimal/logout_frameset.jsp");
		
		break;
	}
	
	return ok;
}
