/////////////////////////////////////////////////////////////////////////////
// File:        iterator.h
// Author:      Cesar Mauri Loba (cesar at crea-si dot com)
// Copyright:   (C) 2010 Cesar Mauri Loba - CREA Software Systems
// 
//  This program is free software: you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation, either version 3 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program.  If not, see <http://www.gnu.org/licenses/>.
/////////////////////////////////////////////////////////////////////////////
#ifndef SPCORE_ITERATOR_H
#define SPCORE_ITERATOR_H

#include "include/spcore/baseobj.h"
#include <vector>
using namespace std;
#include <map>
using namespace std;

namespace spcore {

template<class T>
class IIterator : public IBaseObject {
  protected:
    virtual ~IIterator();


  public:
    virtual void First() = 0;

    virtual void Next() = 0;

    virtual bool IsDone() const = 0;

    virtual T CurrentItem() const = 0;

};
template<class T>
IIterator<T>::~IIterator() {
}

template<class T>
class CIteratorVector : public IIterator<T> {
  public:
    CIteratorVector(const vector<T> & vector);

    virtual ~CIteratorVector();

    virtual void First();

    virtual void Next();

    virtual bool IsDone() const;

    virtual T CurrentItem() const;


  private:
    const vector<T>* m_vector;

	typename vector<T>::const_iterator m_iterator;

};
template<class T>
CIteratorVector<T>::CIteratorVector(const vector<T> & vector) {
  	m_vector= &vector;
  	m_iterator= vector.begin();
}

template<class T>
CIteratorVector<T>::~CIteratorVector() {
  	m_vector= NULL;
}

template<class T>
void CIteratorVector<T>::First() {
  	m_iterator= m_vector->begin();
}

template<class T>
void CIteratorVector<T>::Next() {
  	++m_iterator;
}

template<class T>
bool CIteratorVector<T>::IsDone() const {
  	return (m_iterator== m_vector->end());
}

template<class T>
T CIteratorVector<T>::CurrentItem() const {
  	return (*m_iterator);
}

template<class KEY, class VALUE>
class CIteratorMap : public IIterator<VALUE> {
  public:
    CIteratorMap(const map<KEY,VALUE> & map);

    virtual ~CIteratorMap();

    virtual void First();

    virtual void Next();

    virtual bool IsDone() const;

    virtual VALUE CurrentItem() const;


  private:
    const map<KEY,VALUE>* m_map;

    typename map<KEY,VALUE>::const_iterator m_iterator;

};
template<class KEY, class VALUE>
CIteratorMap<KEY, VALUE>::CIteratorMap(const map<KEY,VALUE> & map) {
  	m_map= &map;
  	m_iterator= map.begin();
}

template<class KEY, class VALUE>
CIteratorMap<KEY, VALUE>::~CIteratorMap() {
  	m_map= NULL;
}

template<class KEY, class VALUE>
void CIteratorMap<KEY, VALUE>::First() {
  	m_iterator= m_map->begin();
}

template<class KEY, class VALUE>
void CIteratorMap<KEY, VALUE>::Next() {
  	++m_iterator;
}

template<class KEY, class VALUE>
bool CIteratorMap<KEY, VALUE>::IsDone() const {
  	return (m_iterator== m_map->end());
}

template<class KEY, class VALUE>
VALUE CIteratorMap<KEY, VALUE>::CurrentItem() const {
  	return (m_iterator->second);
}

} // namespace spcore
#endif
