/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cfg;

import org.hibernate.MappingException;
import org.hibernate.annotations.AccessType;
import org.hibernate.cfg.PropertyData;
import org.hibernate.reflection.XClass;
import org.hibernate.reflection.XProperty;

public class PropertyInferredData
implements PropertyData {
    private final String defaultAccess;
    private final XProperty property;

    public PropertyInferredData(XProperty property, String propertyAccessor) {
        this.property = property;
        this.defaultAccess = propertyAccessor;
    }

    public String getDefaultAccess() throws MappingException {
        AccessType access = this.property.getAnnotation(AccessType.class);
        return access != null ? access.value() : this.defaultAccess;
    }

    public String getPropertyName() throws MappingException {
        return this.property.getName();
    }

    public XClass getPropertyClass() throws MappingException {
        return this.property.getType();
    }

    public XClass getClassOrElement() throws MappingException {
        return this.property.getClassOrElementClass();
    }

    public String getClassOrElementName() throws MappingException {
        return this.property.getClassOrElementClass().getName();
    }

    public String getTypeName() throws MappingException {
        return this.property.getType().getName();
    }

    public XProperty getProperty() {
        return this.property;
    }
}

