/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.internal.marshall;

import com.db4o.ObjectContainer;
import com.db4o.internal.Buffer;
import com.db4o.internal.Db4oTypeImpl;
import com.db4o.internal.HandlerRegistry;
import com.db4o.internal.ObjectContainerBase;
import com.db4o.internal.Transaction;
import com.db4o.internal.TypeHandler4;
import com.db4o.internal.marshall.InternalReadContext;

public abstract class AbstractReadContext
implements InternalReadContext {
    protected final Transaction _transaction;
    protected Buffer _buffer;
    protected int _activationDepth;

    protected AbstractReadContext(Transaction transaction) {
        this._transaction = transaction;
    }

    protected AbstractReadContext(Transaction transaction, Buffer buffer) {
        this._transaction = transaction;
        this._buffer = buffer;
    }

    public Buffer buffer(Buffer buffer) {
        Buffer buffer2 = this._buffer;
        this._buffer = buffer;
        return buffer2;
    }

    public Buffer buffer() {
        return this._buffer;
    }

    public ObjectContainerBase container() {
        return this._transaction.container();
    }

    public ObjectContainer objectContainer() {
        return this.container();
    }

    public Transaction transaction() {
        return this._transaction;
    }

    public byte readByte() {
        return this._buffer.readByte();
    }

    public void readBytes(byte[] byArray) {
        this._buffer.readBytes(byArray);
    }

    public int readInt() {
        return this._buffer.readInt();
    }

    public long readLong() {
        return this._buffer.readLong();
    }

    public Object read(TypeHandler4 typeHandler4) {
        TypeHandler4 typeHandler42 = this.correctHandlerVersion(typeHandler4);
        if (!this.isIndirected(typeHandler42)) {
            return typeHandler42.read(this);
        }
        int n = this.readInt();
        this.readInt();
        int n2 = this.offset();
        this.seek(n);
        Object object = typeHandler42.read(this);
        this.seek(n2);
        return object;
    }

    public Object readObject() {
        int n = this.readInt();
        int n2 = this.activationDepth() - 1;
        if (this.peekPersisted()) {
            return this.container().peekPersisted(this.transaction(), n, n2, false);
        }
        Object object = this.container().getByID2(this.transaction(), n);
        if (object instanceof Db4oTypeImpl) {
            n2 = ((Db4oTypeImpl)object).adjustReadDepth(n2);
        }
        this.container().stillToActivate(this.transaction(), object, n2);
        return object;
    }

    private boolean peekPersisted() {
        return false;
    }

    public Object readObject(TypeHandler4 typeHandler4) {
        TypeHandler4 typeHandler42 = this.correctHandlerVersion(typeHandler4);
        if (!this.isIndirected(typeHandler42)) {
            return typeHandler42.read(this);
        }
        int n = this.readInt();
        this.readInt();
        if (n == 0) {
            return null;
        }
        int n2 = this.offset();
        this.seek(n);
        Object object = typeHandler42.read(this);
        this.seek(n2);
        return object;
    }

    public int activationDepth() {
        return this._activationDepth;
    }

    public void activationDepth(int n) {
        this._activationDepth = n;
    }

    public int offset() {
        return this._buffer.offset();
    }

    public void seek(int n) {
        this._buffer.seek(n);
    }

    public boolean isIndirected(TypeHandler4 typeHandler4) {
        if (this.handlerVersion() == 0) {
            return false;
        }
        return this.handlerRegistry().isVariableLength(typeHandler4);
    }

    private HandlerRegistry handlerRegistry() {
        return this.container().handlers();
    }

    public boolean oldHandlerVersion() {
        return this.handlerVersion() != 2;
    }

    public TypeHandler4 correctHandlerVersion(TypeHandler4 typeHandler4) {
        if (!this.oldHandlerVersion()) {
            return typeHandler4;
        }
        return this.container().handlers().correctHandlerVersion(typeHandler4, this.handlerVersion());
    }

    public abstract int handlerVersion();
}

