/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.internal.cs;

import com.db4o.foundation.BlockingQueue;
import com.db4o.foundation.BlockingQueueStoppedException;
import com.db4o.internal.cs.BroadcastFilter;
import com.db4o.internal.cs.ObjectServerImpl;
import com.db4o.internal.cs.ServerMessageDispatcher;
import com.db4o.internal.cs.messages.MCommittedInfo;

public class CommittedCallbacksDispatcher
implements Runnable {
    private boolean _stopped;
    private final BlockingQueue _committedInfosQueue;
    private final ObjectServerImpl _server;

    public CommittedCallbacksDispatcher(ObjectServerImpl objectServerImpl, BlockingQueue blockingQueue) {
        this._server = objectServerImpl;
        this._committedInfosQueue = blockingQueue;
    }

    public void run() {
        while (!this._stopped) {
            MCommittedInfo mCommittedInfo;
            try {
                mCommittedInfo = (MCommittedInfo)this._committedInfosQueue.next();
            }
            catch (BlockingQueueStoppedException blockingQueueStoppedException) {
                break;
            }
            this._server.broadcastMsg(mCommittedInfo, new BroadcastFilter(){

                public boolean accept(ServerMessageDispatcher serverMessageDispatcher) {
                    return serverMessageDispatcher.caresAboutCommitted();
                }
            });
        }
    }

    public void stop() {
        this._committedInfosQueue.stop();
        this._stopped = true;
    }
}

