/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.type;

import java.io.Serializable;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.dom4j.Element;
import org.dom4j.Node;
import org.hibernate.EntityMode;
import org.hibernate.Hibernate;
import org.hibernate.HibernateException;
import org.hibernate.MappingException;
import org.hibernate.collection.PersistentCollection;
import org.hibernate.engine.CollectionKey;
import org.hibernate.engine.EntityEntry;
import org.hibernate.engine.Mapping;
import org.hibernate.engine.PersistenceContext;
import org.hibernate.engine.SessionFactoryImplementor;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.persister.collection.CollectionPersister;
import org.hibernate.persister.collection.QueryableCollection;
import org.hibernate.persister.entity.Joinable;
import org.hibernate.proxy.HibernateProxy;
import org.hibernate.proxy.LazyInitializer;
import org.hibernate.type.AbstractType;
import org.hibernate.type.AssociationType;
import org.hibernate.type.ForeignKeyDirection;
import org.hibernate.type.Type;
import org.hibernate.util.ArrayHelper;
import org.hibernate.util.MarkerObject;

public abstract class CollectionType
extends AbstractType
implements AssociationType {
    private static final Object NOT_NULL_COLLECTION = new MarkerObject("NOT NULL COLLECTION");
    public static final Object UNFETCHED_COLLECTION = new MarkerObject("UNFETCHED COLLECTION");
    private final String role;
    private final String foreignKeyPropertyName;
    private final boolean isEmbeddedInXML;

    public CollectionType(String role, String foreignKeyPropertyName, boolean isEmbeddedInXML) {
        this.role = role;
        this.foreignKeyPropertyName = foreignKeyPropertyName;
        this.isEmbeddedInXML = isEmbeddedInXML;
    }

    public boolean isEmbeddedInXML() {
        return this.isEmbeddedInXML;
    }

    public String getRole() {
        return this.role;
    }

    public Object indexOf(Object collection, Object element) {
        throw new UnsupportedOperationException("generic collections don't have indexes");
    }

    public boolean contains(Object collection, Object childObject, SessionImplementor session) {
        Iterator elems = this.getElementsIterator(collection, session);
        while (elems.hasNext()) {
            LazyInitializer li;
            Object element = elems.next();
            if (element instanceof HibernateProxy && !(li = ((HibernateProxy)element).getHibernateLazyInitializer()).isUninitialized()) {
                element = li.getImplementation();
            }
            if (element != childObject) continue;
            return true;
        }
        return false;
    }

    public boolean isCollectionType() {
        return true;
    }

    public final boolean isEqual(Object x, Object y, EntityMode entityMode) {
        return x == y || x instanceof PersistentCollection && ((PersistentCollection)x).isWrapper(y) || y instanceof PersistentCollection && ((PersistentCollection)y).isWrapper(x);
    }

    public int compare(Object x, Object y, EntityMode entityMode) {
        return 0;
    }

    public int getHashCode(Object x, EntityMode entityMode) {
        throw new UnsupportedOperationException("cannot perform lookups on collections");
    }

    public abstract PersistentCollection instantiate(SessionImplementor var1, CollectionPersister var2, Serializable var3) throws HibernateException;

    public Object nullSafeGet(ResultSet rs, String name, SessionImplementor session, Object owner) throws HibernateException, SQLException {
        return this.nullSafeGet(rs, new String[]{name}, session, owner);
    }

    public Object nullSafeGet(ResultSet rs, String[] name, SessionImplementor session, Object owner) throws HibernateException, SQLException {
        return this.resolve(null, session, owner);
    }

    public final void nullSafeSet(PreparedStatement st, Object value, int index, boolean[] settable, SessionImplementor session) throws HibernateException, SQLException {
    }

    public void nullSafeSet(PreparedStatement st, Object value, int index, SessionImplementor session) throws HibernateException, SQLException {
    }

    public int[] sqlTypes(Mapping session) throws MappingException {
        return ArrayHelper.EMPTY_INT_ARRAY;
    }

    public int getColumnSpan(Mapping session) throws MappingException {
        return 0;
    }

    public String toLoggableString(Object value, SessionFactoryImplementor factory) throws HibernateException {
        if (value == null) {
            return "null";
        }
        if (!Hibernate.isInitialized(value)) {
            return "<uninitialized>";
        }
        return this.renderLoggableString(value, factory);
    }

    protected String renderLoggableString(Object value, SessionFactoryImplementor factory) throws HibernateException {
        if (Element.class.isInstance(value)) {
            return ((Element)value).asXML();
        }
        ArrayList<String> list = new ArrayList<String>();
        Type elemType = this.getElementType(factory);
        Iterator iter = this.getElementsIterator(value);
        while (iter.hasNext()) {
            list.add(elemType.toLoggableString(iter.next(), factory));
        }
        return ((Object)list).toString();
    }

    public Object deepCopy(Object value, EntityMode entityMode, SessionFactoryImplementor factory) throws HibernateException {
        return value;
    }

    public String getName() {
        return this.getReturnedClass().getName() + '(' + this.getRole() + ')';
    }

    public Iterator getElementsIterator(Object collection, SessionImplementor session) {
        if (session.getEntityMode() == EntityMode.DOM4J) {
            SessionFactoryImplementor factory = session.getFactory();
            CollectionPersister persister = factory.getCollectionPersister(this.getRole());
            Type elementType = persister.getElementType();
            List elements = ((Element)collection).elements(persister.getElementNodeName());
            ArrayList<Object> results = new ArrayList<Object>();
            for (int i = 0; i < elements.size(); ++i) {
                Element value = (Element)elements.get(i);
                results.add(elementType.fromXMLNode((Node)value, factory));
            }
            return results.iterator();
        }
        return this.getElementsIterator(collection);
    }

    protected Iterator getElementsIterator(Object collection) {
        return ((Collection)collection).iterator();
    }

    public boolean isMutable() {
        return false;
    }

    public Serializable disassemble(Object value, SessionImplementor session, Object owner) throws HibernateException {
        Serializable key = this.getKeyOfOwner(owner, session);
        if (key == null) {
            return null;
        }
        return this.getPersister(session).getKeyType().disassemble(key, session, owner);
    }

    public Object assemble(Serializable cached, SessionImplementor session, Object owner) throws HibernateException {
        if (cached == null) {
            return null;
        }
        Serializable key = (Serializable)this.getPersister(session).getKeyType().assemble(cached, session, owner);
        return this.resolveKey(key, session, owner);
    }

    private boolean isOwnerVersioned(SessionImplementor session) throws MappingException {
        return this.getPersister(session).getOwnerEntityPersister().isVersioned();
    }

    private CollectionPersister getPersister(SessionImplementor session) {
        return session.getFactory().getCollectionPersister(this.role);
    }

    public boolean isDirty(Object old, Object current, SessionImplementor session) throws HibernateException {
        return this.isOwnerVersioned(session) && super.isDirty(old, current, session);
    }

    public boolean isDirty(Object old, Object current, boolean[] checkable, SessionImplementor session) throws HibernateException {
        return this.isDirty(old, current, session);
    }

    public abstract PersistentCollection wrap(SessionImplementor var1, Object var2);

    public boolean isAssociationType() {
        return true;
    }

    public ForeignKeyDirection getForeignKeyDirection() {
        return ForeignKeyDirection.FOREIGN_KEY_TO_PARENT;
    }

    public Serializable getKeyOfOwner(Object owner, SessionImplementor session) {
        EntityEntry entityEntry = session.getPersistenceContext().getEntry(owner);
        if (entityEntry == null) {
            return null;
        }
        if (this.foreignKeyPropertyName == null) {
            return entityEntry.getId();
        }
        Object id = entityEntry.getLoadedState() != null ? entityEntry.getLoadedValue(this.foreignKeyPropertyName) : entityEntry.getPersister().getPropertyValue(owner, this.foreignKeyPropertyName, session.getEntityMode());
        Type keyType = this.getPersister(session).getKeyType();
        if (!keyType.getReturnedClass().isInstance(id)) {
            id = (Serializable)keyType.semiResolve(entityEntry.getLoadedValue(this.foreignKeyPropertyName), session, owner);
        }
        return (Serializable)id;
    }

    public Object hydrate(ResultSet rs, String[] name, SessionImplementor session, Object owner) {
        return NOT_NULL_COLLECTION;
    }

    public Object resolve(Object value, SessionImplementor session, Object owner) throws HibernateException {
        return this.resolveKey(this.getKeyOfOwner(owner, session), session, owner);
    }

    private Object resolveKey(Serializable key, SessionImplementor session, Object owner) {
        return key == null ? null : this.getCollection(key, session, owner);
    }

    public Object semiResolve(Object value, SessionImplementor session, Object owner) throws HibernateException {
        throw new UnsupportedOperationException("collection mappings may not form part of a property-ref");
    }

    public boolean isArrayType() {
        return false;
    }

    public boolean useLHSPrimaryKey() {
        return this.foreignKeyPropertyName == null;
    }

    public String getRHSUniqueKeyPropertyName() {
        return null;
    }

    public Joinable getAssociatedJoinable(SessionFactoryImplementor factory) throws MappingException {
        return (Joinable)((Object)factory.getCollectionPersister(this.role));
    }

    public boolean isModified(Object old, Object current, boolean[] checkable, SessionImplementor session) throws HibernateException {
        return false;
    }

    public String getAssociatedEntityName(SessionFactoryImplementor factory) throws MappingException {
        try {
            QueryableCollection collectionPersister = (QueryableCollection)factory.getCollectionPersister(this.role);
            if (!collectionPersister.getElementType().isEntityType()) {
                throw new MappingException("collection was not an association: " + collectionPersister.getRole());
            }
            return collectionPersister.getElementPersister().getEntityName();
        }
        catch (ClassCastException cce) {
            throw new MappingException("collection role is not queryable " + this.role);
        }
    }

    public Object replaceElements(Object original, Object target, Object owner, Map copyCache, SessionImplementor session) {
        Collection result = (Collection)target;
        boolean isPC = result instanceof PersistentCollection;
        boolean wasOriginalDirty = original instanceof PersistentCollection && ((PersistentCollection)original).isDirty();
        result.clear();
        Type elemType = this.getElementType(session.getFactory());
        Iterator iter = ((Collection)original).iterator();
        while (iter.hasNext()) {
            result.add(elemType.replace(iter.next(), null, session, owner, copyCache));
        }
        if (result instanceof PersistentCollection && !wasOriginalDirty) {
            ((PersistentCollection)((Object)result)).clearDirty();
        }
        return result;
    }

    protected Object instantiateResult(Object original) {
        return this.instantiate(-1);
    }

    public abstract Object instantiate(int var1);

    public Object replace(Object original, Object target, SessionImplementor session, Object owner, Map copyCache) throws HibernateException {
        if (original == null) {
            return null;
        }
        if (!Hibernate.isInitialized(original)) {
            return target;
        }
        Object result = target == null || target == original ? this.instantiateResult(original) : target;
        result = this.replaceElements(original, result, owner, copyCache, session);
        if (original == target) {
            this.replaceElements(result, target, owner, copyCache, session);
            result = target;
        }
        return result;
    }

    public final Type getElementType(SessionFactoryImplementor factory) throws MappingException {
        return factory.getCollectionPersister(this.getRole()).getElementType();
    }

    public String toString() {
        return this.getClass().getName() + '(' + this.getRole() + ')';
    }

    public String getOnCondition(String alias, SessionFactoryImplementor factory, Map enabledFilters) throws MappingException {
        return this.getAssociatedJoinable(factory).filterFragment(alias, enabledFilters);
    }

    public Object getCollection(Serializable key, SessionImplementor session, Object owner) throws HibernateException {
        CollectionPersister persister = this.getPersister(session);
        PersistenceContext persistenceContext = session.getPersistenceContext();
        EntityMode entityMode = session.getEntityMode();
        if (entityMode == EntityMode.DOM4J && !this.isEmbeddedInXML) {
            return UNFETCHED_COLLECTION;
        }
        PersistentCollection collection = persistenceContext.getCollectionLoadContext().getLoadingCollection(persister, key, entityMode);
        if (collection == null && (collection = persistenceContext.useUnownedCollection(new CollectionKey(persister, key, entityMode))) == null) {
            collection = this.instantiate(session, persister, key);
            collection.setOwner(owner);
            persistenceContext.addUninitializedCollection(persister, collection, key);
            if (this.initializeImmediately(entityMode)) {
                session.initializeCollection(collection, false);
            } else if (!persister.isLazy()) {
                persistenceContext.addNonLazyCollection(collection);
            }
            if (this.hasHolder(entityMode)) {
                session.getPersistenceContext().addCollectionHolder(collection);
            }
        }
        collection.setOwner(owner);
        return collection.getValue();
    }

    public boolean hasHolder(EntityMode entityMode) {
        return entityMode == EntityMode.DOM4J;
    }

    protected boolean initializeImmediately(EntityMode entityMode) {
        return entityMode == EntityMode.DOM4J;
    }

    public String getLHSPropertyName() {
        return this.foreignKeyPropertyName;
    }

    public boolean isXMLElement() {
        return true;
    }

    public Object fromXMLNode(Node xml, Mapping factory) throws HibernateException {
        return xml;
    }

    public void setToXMLNode(Node node, Object value, SessionFactoryImplementor factory) throws HibernateException {
        if (!this.isEmbeddedInXML) {
            node.detach();
        } else {
            CollectionType.replaceNode(node, (Element)value);
        }
    }

    public boolean isAlwaysDirtyChecked() {
        return true;
    }

    public boolean[] toColumnNullness(Object value, Mapping mapping) {
        return ArrayHelper.EMPTY_BOOLEAN_ARRAY;
    }
}

