/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect;

import java.util.ArrayList;
import java.util.List;
import org.hibernate.Hibernate;
import org.hibernate.HibernateException;
import org.hibernate.QueryException;
import org.hibernate.dialect.DB2Dialect;
import org.hibernate.dialect.function.SQLFunction;
import org.hibernate.dialect.function.SQLFunctionTemplate;
import org.hibernate.dialect.function.VarArgsSQLFunction;
import org.hibernate.engine.Mapping;
import org.hibernate.engine.SessionFactoryImplementor;
import org.hibernate.id.TableHiLoGenerator;
import org.hibernate.sql.CaseFragment;
import org.hibernate.sql.DerbyCaseFragment;
import org.hibernate.type.Type;

public class DerbyDialect
extends DB2Dialect {
    public DerbyDialect() {
        this.registerFunction("concat", new VarArgsSQLFunction(Hibernate.STRING, "(", "||", ")"));
        this.registerFunction("trim", new DerbyTrimFunctionEmulation());
    }

    public String getIdentityColumnString() {
        return "not null generated always as identity";
    }

    public CaseFragment createCaseFragment() {
        return new DerbyCaseFragment();
    }

    public boolean dropConstraints() {
        return true;
    }

    public Class getNativeIdentifierGeneratorClass() {
        return TableHiLoGenerator.class;
    }

    public boolean supportsSequences() {
        return false;
    }

    public boolean supportsLimit() {
        return false;
    }

    public boolean supportsLimitOffset() {
        return false;
    }

    public String getQuerySequencesString() {
        return null;
    }

    public static class DerbyTrimFunctionEmulation
    implements SQLFunction {
        private static final SQLFunction LEADING_SPACE_TRIM = new SQLFunctionTemplate(Hibernate.STRING, "ltrim( ?1 )");
        private static final SQLFunction TRAILING_SPACE_TRIM = new SQLFunctionTemplate(Hibernate.STRING, "rtrim( ?1 )");
        private static final SQLFunction BOTH_SPACE_TRIM = new SQLFunctionTemplate(Hibernate.STRING, "ltrim( rtrim( ?1 ) )");
        private static final SQLFunction BOTH_SPACE_TRIM_FROM = new SQLFunctionTemplate(Hibernate.STRING, "ltrim( rtrim( ?2 ) )");

        public Type getReturnType(Type columnType, Mapping mapping) throws QueryException {
            return Hibernate.STRING;
        }

        public boolean hasArguments() {
            return true;
        }

        public boolean hasParenthesesIfNoArguments() {
            return false;
        }

        public String render(List args, SessionFactoryImplementor factory) throws QueryException {
            if (args.size() == 1) {
                return BOTH_SPACE_TRIM.render(args, factory);
            }
            if ("from".equalsIgnoreCase((String)args.get(0))) {
                return BOTH_SPACE_TRIM_FROM.render(args, factory);
            }
            boolean leading = true;
            boolean trailing = true;
            String trimCharacter = null;
            String trimSource = null;
            int potentialTrimCharacterArgIndex = 1;
            String firstArg = (String)args.get(0);
            if ("leading".equalsIgnoreCase(firstArg)) {
                trailing = false;
            } else if ("trailing".equalsIgnoreCase(firstArg)) {
                leading = false;
            } else if (!"both".equalsIgnoreCase(firstArg)) {
                potentialTrimCharacterArgIndex = 0;
            }
            String potentialTrimCharacter = (String)args.get(potentialTrimCharacterArgIndex);
            if ("from".equalsIgnoreCase(potentialTrimCharacter)) {
                trimCharacter = "' '";
                trimSource = (String)args.get(potentialTrimCharacterArgIndex + 1);
            } else if (potentialTrimCharacterArgIndex + 1 >= args.size()) {
                trimCharacter = "' '";
                trimSource = potentialTrimCharacter;
            } else {
                trimCharacter = potentialTrimCharacter;
                trimSource = "from".equalsIgnoreCase((String)args.get(potentialTrimCharacterArgIndex + 1)) ? (String)args.get(potentialTrimCharacterArgIndex + 2) : (String)args.get(potentialTrimCharacterArgIndex + 1);
            }
            ArrayList<String> argsToUse = null;
            argsToUse = new ArrayList<String>();
            argsToUse.add(trimSource);
            argsToUse.add(trimCharacter);
            if (trimCharacter.equals("' '")) {
                if (leading && trailing) {
                    return BOTH_SPACE_TRIM.render(argsToUse, factory);
                }
                if (leading) {
                    return LEADING_SPACE_TRIM.render(argsToUse, factory);
                }
                return TRAILING_SPACE_TRIM.render(argsToUse, factory);
            }
            throw new HibernateException("cannot specify trim character when using Derby as Derby does not support the ANSI trim function, not does it support a replace function to properly emmulate it");
        }
    }
}

