/*
 * Decompiled with CFR 0.152.
 */
package com.google.streamhtmlparser;

import com.google.streamhtmlparser.HtmlParser;
import com.google.streamhtmlparser.ParseException;
import com.google.streamhtmlparser.impl.HtmlParserImpl;
import java.util.Set;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HtmlParserFactory {
    private static final Logger logger = Logger.getLogger(HtmlParserFactory.class.getName());
    private static final HtmlParser parserInDefaultAttr = HtmlParserFactory.createParser();
    private static final HtmlParser parserInDefaultAttrQ = HtmlParserFactory.createParser();
    private static final HtmlParser parserInUriAttrComplete = HtmlParserFactory.createParser();
    private static final HtmlParser parserInUriAttrQComplete = HtmlParserFactory.createParser();
    private static final HtmlParser parserInUriAttrPartial = HtmlParserFactory.createParser();
    private static final HtmlParser parserInUriAttrQPartial = HtmlParserFactory.createParser();
    private static final HtmlParser parserInJsAttr = HtmlParserFactory.createParser();
    private static final HtmlParser parserInJsAttrQ = HtmlParserFactory.createParser();
    private static final HtmlParser parserInQJsAttr = HtmlParserFactory.createParser();
    private static final HtmlParser parserInStyleAttr = HtmlParserFactory.createParser();
    private static final HtmlParser parserInStyleAttrQ = HtmlParserFactory.createParser();
    private static final HtmlParser parserInJsQ = HtmlParserFactory.createParser();
    private static boolean initSuccess = false;

    private HtmlParserFactory() {
    }

    public static HtmlParser createParser() {
        return new HtmlParserImpl();
    }

    public static HtmlParser createParserInMode(HtmlParser.Mode mode, Set<ModeOptions> options) {
        HtmlParserFactory.requireInitialized();
        if (options != null && options.contains((Object)ModeOptions.JS_QUOTED)) {
            return HtmlParserFactory.createParser(parserInJsQ);
        }
        HtmlParserImpl parser = new HtmlParserImpl();
        parser.resetMode(mode);
        return parser;
    }

    public static HtmlParser createParser(HtmlParser aHtmlParser) {
        HtmlParserFactory.requireInitialized();
        return new HtmlParserImpl((HtmlParserImpl)aHtmlParser);
    }

    public static HtmlParser createParserInAttribute(HtmlParser.ATTR_TYPE attrtype, boolean quoted, Set<AttributeOptions> options) {
        HtmlParser parser;
        HtmlParserFactory.requireInitialized();
        switch (attrtype) {
            case REGULAR: {
                parser = HtmlParserFactory.createParser(quoted ? parserInDefaultAttrQ : parserInDefaultAttr);
                break;
            }
            case URI: {
                if (options != null && options.contains((Object)AttributeOptions.URL_PARTIAL)) {
                    parser = HtmlParserFactory.createParser(quoted ? parserInUriAttrQPartial : parserInUriAttrPartial);
                    break;
                }
                parser = HtmlParserFactory.createParser(quoted ? parserInUriAttrQComplete : parserInUriAttrComplete);
                break;
            }
            case JS: {
                if (quoted) {
                    if (options != null && options.contains((Object)AttributeOptions.JS_QUOTED)) {
                        parser = HtmlParserFactory.createParser(parserInQJsAttr);
                        break;
                    }
                    parser = HtmlParserFactory.createParser(parserInJsAttrQ);
                    break;
                }
                parser = HtmlParserFactory.createParser(parserInJsAttr);
                break;
            }
            case STYLE: {
                parser = HtmlParserFactory.createParser(quoted ? parserInStyleAttrQ : parserInStyleAttr);
                break;
            }
            case NONE: {
                parser = HtmlParserFactory.createParserInMode(HtmlParser.Mode.HTML_IN_TAG, null);
                break;
            }
            default: {
                throw new IllegalArgumentException("Did not recognize ATTR_TYPE given: " + (Object)((Object)attrtype));
            }
        }
        return parser;
    }

    private static void initializeParsers() throws ParseException {
        parserInDefaultAttr.parse("<xparsertag htmlparser=");
        parserInDefaultAttrQ.parse("<xparsertag htmlparser=\"");
        parserInUriAttrComplete.parse("<xparsertag src=");
        parserInUriAttrQComplete.parse("<xparsertag src=\"");
        String fakeUrlPrefix = "http://example.com/fakequeryparam=";
        parserInUriAttrPartial.parse("<xparsertag src=http://example.com/fakequeryparam=");
        parserInUriAttrQPartial.parse("<xparsertag src=\"http://example.com/fakequeryparam=");
        parserInJsAttr.parse("<xparsertag onmouse=");
        parserInJsAttrQ.parse("<xparsertag onmouse=\"");
        parserInQJsAttr.parse("<xparsertag onmouse=\"'");
        parserInJsQ.resetMode(HtmlParser.Mode.JS);
        parserInJsQ.parse("var fakeparservar='");
        parserInStyleAttr.parse("<xparsertag style=");
        parserInStyleAttrQ.parse("<xparsertag style=\"");
    }

    private static void requireInitialized() {
        if (!initSuccess) {
            throw new AssertionError((Object)"HtmlParserFactory failed initialization.");
        }
    }

    static {
        try {
            HtmlParserFactory.initializeParsers();
            initSuccess = true;
        }
        catch (ParseException e) {
            String error = HtmlParserFactory.class.getName() + " Failed initialization: " + e.getMessage();
            logger.severe(error);
            System.err.println(error);
            e.printStackTrace();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ModeOptions {
        JS_QUOTED;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum AttributeOptions {
        JS_QUOTED,
        URL_PARTIAL;

    }
}

