/*
 * Decompiled with CFR 0.152.
 */
package com.google.doclava;

import com.google.clearsilver.jsilver.data.Data;
import com.google.doclava.ContainerInfo;
import com.google.doclava.ParsedTagInfo;
import com.google.doclava.SourcePositionInfo;
import com.google.doclava.TagInfo;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ParamTagInfo
extends ParsedTagInfo {
    static final Pattern PATTERN = Pattern.compile("([^ \t\r\n]+)[ \t\r\n]+(.*)", 32);
    private boolean mIsTypeParameter;
    private String mParameterComment;
    private String mParameterName;

    ParamTagInfo(String name, String kind, String text, ContainerInfo base, SourcePositionInfo sp) {
        super(name, kind, text, base, sp);
        Matcher m = PATTERN.matcher(text);
        if (m.matches()) {
            this.mParameterName = m.group(1);
            this.mParameterComment = m.group(2);
            int len = this.mParameterName.length();
            this.mIsTypeParameter = len > 2 && this.mParameterName.charAt(0) == '<' && this.mParameterName.charAt(len - 1) == '>';
        } else {
            this.mParameterName = text.trim();
            this.mParameterComment = "";
            this.mIsTypeParameter = false;
        }
        this.setCommentText(this.mParameterComment);
    }

    ParamTagInfo(String name, String kind, String text, boolean isTypeParameter, String parameterComment, String parameterName, ContainerInfo base, SourcePositionInfo sp) {
        super(name, kind, text, base, sp);
        this.mIsTypeParameter = isTypeParameter;
        this.mParameterComment = parameterComment;
        this.mParameterName = parameterName;
    }

    public boolean isTypeParameter() {
        return this.mIsTypeParameter;
    }

    public String parameterComment() {
        return this.mParameterComment;
    }

    public String parameterName() {
        return this.mParameterName;
    }

    public void makeHDF(Data data, String base) {
        data.setValue(base + ".name", this.parameterName());
        data.setValue(base + ".isTypeParameter", this.isTypeParameter() ? "1" : "0");
        TagInfo.makeHDF(data, base + ".comment", this.commentTags());
    }

    public static void makeHDF(Data data, String base, ParamTagInfo[] tags) {
        for (int i = 0; i < tags.length; ++i) {
            if ("".equals(tags[i].parameterComment())) continue;
            tags[i].makeHDF(data, base + "." + i);
        }
    }
}

