/*
 * Decompiled with CFR 0.152.
 */
package com.google.clearsilver.jsilver.values;

import com.google.clearsilver.jsilver.autoescape.EscapeMode;
import com.google.clearsilver.jsilver.data.Data;
import com.google.clearsilver.jsilver.data.DataContext;
import com.google.clearsilver.jsilver.data.TypeConverter;
import com.google.clearsilver.jsilver.values.VariantValue;

public class VariableValue
extends VariantValue {
    private final String name;
    private final DataContext dataContext;
    private boolean gotRef = false;
    private Data reference;

    public VariableValue(String name, DataContext dataContext) {
        super(EscapeMode.ESCAPE_NONE, false);
        this.dataContext = dataContext;
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public Data getReference() {
        if (!this.gotRef) {
            this.reference = this.dataContext.findVariable(this.name, false);
            this.gotRef = true;
        }
        return this.reference;
    }

    protected String value() {
        Data data = this.getReference();
        return data == null ? null : data.getValue();
    }

    public boolean exists() {
        return TypeConverter.exists(this.getReference());
    }

    public String toString() {
        return this.name;
    }

    public EscapeMode getEscapeMode() {
        Data data = this.getReference();
        if (data == null) {
            return super.getEscapeMode();
        }
        return data.getEscapeMode();
    }
}

