/*
 * Decompiled with CFR 0.152.
 */
package com.google.clearsilver.jsilver.functions.html;

import com.google.clearsilver.jsilver.functions.TextFilter;
import com.google.clearsilver.jsilver.functions.escape.HtmlEscapeFunction;
import com.google.clearsilver.jsilver.functions.escape.SimpleEscapingFunction;
import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class TextHtmlFunction
implements TextFilter {
    private static final String EMAIL_REGEXP = "[^]\\[@:;<>\\\"()\\s\\p{Cntrl}]+@[-+a-zA-Z0-9]+\\.[-+a-zA-Z0-9\\.]+[-+a-zA-Z0-9]";
    private static final String WITH_SCHEME_REGEXP = "(?:http|https|ftp|mailto):[^\\s>\"]*";
    private static final String WITHOUT_SCHEME_REGEXP = "www\\.[-a-z0-9\\.]+[^\\s;\">]*";
    private static final Pattern LINKABLES = Pattern.compile("([^]\\[@:;<>\\\"()\\s\\p{Cntrl}]+@[-+a-zA-Z0-9]+\\.[-+a-zA-Z0-9\\.]+[-+a-zA-Z0-9])|((?:http|https|ftp|mailto):[^\\s>\"]*)|(www\\.[-a-z0-9\\.]+[^\\s;\">]*)", 2);
    private static final int EMAIL_GROUP = 1;
    private static final int WITH_SCHEME_GROUP = 2;
    private final HtmlEscapeFunction htmlEscaper = new HtmlEscapeFunction(false);
    private final SimpleEscapingFunction htmlCharEscaper = new SimpleEscapingFunction(new char[]{'<', '>', '&', '\n', '\r'}){

        protected String getEscapeString(char c) {
            switch (c) {
                case '<': {
                    return "&lt;";
                }
                case '>': {
                    return "&gt;";
                }
                case '&': {
                    return "&amp;";
                }
                case '\n': {
                    return "<br/>\n";
                }
                case '\r': {
                    return "";
                }
            }
            return null;
        }
    };

    public void filter(String in, Appendable out) throws IOException {
        boolean hasAsciiArt = this.hasAsciiArt(in);
        if (hasAsciiArt) {
            out.append("<tt>");
        }
        this.splitAndConvert(in, out);
        if (hasAsciiArt) {
            out.append("</tt>");
        }
    }

    private void splitAndConvert(String in, Appendable out) throws IOException {
        Matcher matcher = LINKABLES.matcher(in);
        int end = in.length();
        int regionStart = 0;
        while (matcher.find()) {
            int matchStart = matcher.start();
            int matchEnd = matcher.end();
            this.htmlCharEscaper.filter(((Object)in.subSequence(regionStart, matchStart)).toString(), out);
            if (in.charAt(matchEnd - 1) == ',' || in.charAt(matchEnd - 1) == '.') {
                --matchEnd;
            }
            if (matcher.group(1) != null) {
                this.formatEmail(in, matchStart, matchEnd, out);
            } else {
                this.formatUrl(in, matchStart, matchEnd, matcher.group(2) == null, out);
            }
            regionStart = matchEnd;
        }
        this.htmlCharEscaper.filter(in.substring(regionStart, end), out);
    }

    private void formatEmail(String in, int start, int end, Appendable out) throws IOException {
        String emailPart = in.substring(start, end);
        out.append("<a href=\"mailto:");
        this.htmlEscaper.filter(emailPart, out);
        out.append("\">");
        this.htmlEscaper.filter(emailPart, out);
        out.append("</a>");
    }

    private void formatUrl(String in, int start, int end, boolean addScheme, Appendable out) throws IOException {
        String urlPart = in.substring(start, end);
        out.append(" <a target=\"_blank\" href=\"");
        if (addScheme) {
            out.append("http://");
        }
        this.htmlEscaper.filter(urlPart, out);
        out.append("\">");
        this.htmlEscaper.filter(urlPart, out);
        out.append("</a>");
    }

    private boolean hasAsciiArt(String in) {
        int spaces = 0;
        int returns = 0;
        int asciiArt = 0;
        int x = 0;
        char[] inChars = in.toCharArray();
        int length = in.length();
        block7: for (x = 0; x < length; ++x) {
            switch (inChars[x]) {
                case '\t': {
                    return false;
                }
                case '\r': {
                    continue block7;
                }
                case ' ': {
                    if (x != 0 && inChars[x - 1] == '.') continue block7;
                    ++spaces;
                    continue block7;
                }
                case '\n': {
                    spaces = 0;
                    ++returns;
                    continue block7;
                }
                case '!': 
                case '#': 
                case '$': 
                case '%': 
                case '&': 
                case '(': 
                case ')': 
                case '*': 
                case '/': 
                case ':': 
                case '<': 
                case '>': 
                case '@': 
                case '[': 
                case '\\': 
                case ']': 
                case '^': 
                case '|': {
                    if (++asciiArt <= 3) continue block7;
                    return true;
                }
                default: {
                    if (returns > 2) {
                        return false;
                    }
                    if (spaces > 2) {
                        return false;
                    }
                    returns = 0;
                    spaces = 0;
                    asciiArt = 0;
                }
            }
        }
        return false;
    }
}

