/*
 * Decompiled with CFR 0.152.
 */
package com.google.clearsilver.jsilver.functions.html;

import com.google.clearsilver.jsilver.functions.TextFilter;
import java.io.IOException;

public abstract class BaseUrlValidateFunction
implements TextFilter {
    public void filter(String in, Appendable out) throws IOException {
        if (!this.isValidUri(in)) {
            out.append('#');
            return;
        }
        this.applyEscaping(in, out);
    }

    protected abstract void applyEscaping(String var1, Appendable var2) throws IOException;

    protected boolean isValidUri(String in) {
        String maybeScheme = this.toLowerCaseAsciiOnly(in.substring(0, Math.min(in.length(), 8)));
        if (maybeScheme.startsWith("http://") || maybeScheme.startsWith("https://") || maybeScheme.startsWith("ftp://") || maybeScheme.startsWith("mailto:")) {
            return true;
        }
        int slashPos = in.indexOf(47);
        if (slashPos != -1) {
            return in.lastIndexOf(58, slashPos - 1) == -1;
        }
        return in.indexOf(58) == -1;
    }

    private String toLowerCaseAsciiOnly(String string) {
        char[] ca = string.toCharArray();
        for (int i = 0; i < ca.length; ++i) {
            char ch = ca[i];
            ca[i] = Character.UnicodeBlock.of(ch) == Character.UnicodeBlock.BASIC_LATIN ? (int)Character.toLowerCase(ch) : 63;
        }
        return new String(ca);
    }
}

