/*
 * Decompiled with CFR 0.152.
 */
package com.google.clearsilver.jsilver.data;

import com.google.clearsilver.jsilver.autoescape.EscapeMode;
import com.google.clearsilver.jsilver.data.Data;
import java.io.IOException;
import java.util.Iterator;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DelegatedData
implements Data {
    private final Data delegate;
    private final Iterable<DelegatedData> delegatedIterable = new Iterable<DelegatedData>(){

        @Override
        public Iterator<DelegatedData> iterator() {
            return DelegatedData.this.newChildIterator();
        }
    };

    public DelegatedData(Data delegate) {
        if (delegate == null) {
            throw new NullPointerException("Delegate Data must not be null.");
        }
        this.delegate = delegate;
    }

    protected DelegatedData newInstance(Data newDelegate) {
        return newDelegate == null ? null : new DelegatedData(newDelegate);
    }

    protected Data getDelegate() {
        return this.delegate;
    }

    protected static Data unwrap(Data data) {
        if (data instanceof DelegatedData) {
            data = ((DelegatedData)data).getDelegate();
        }
        return data;
    }

    @Override
    public String getName() {
        return this.getDelegate().getName();
    }

    @Override
    public String getValue() {
        return this.getDelegate().getValue();
    }

    @Override
    public int getIntValue() {
        return this.getDelegate().getIntValue();
    }

    @Override
    public boolean getBooleanValue() {
        return this.getDelegate().getBooleanValue();
    }

    @Override
    public void setValue(String value) {
        this.getDelegate().setValue(value);
    }

    @Override
    public String getFullPath() {
        return this.getDelegate().getFullPath();
    }

    @Override
    public void setAttribute(String key, String value) {
        this.getDelegate().setAttribute(key, value);
    }

    @Override
    public String getAttribute(String key) {
        return this.getDelegate().getAttribute(key);
    }

    @Override
    public boolean hasAttribute(String key) {
        return this.getDelegate().hasAttribute(key);
    }

    @Override
    public int getAttributeCount() {
        return this.getDelegate().getAttributeCount();
    }

    @Override
    public Iterable<Map.Entry<String, String>> getAttributes() {
        return this.getDelegate().getAttributes();
    }

    @Override
    public Data getRoot() {
        return this.newInstance(this.getDelegate().getRoot());
    }

    @Override
    public Data getParent() {
        return this.newInstance(this.getDelegate().getParent());
    }

    @Override
    public boolean isFirstSibling() {
        return this.getDelegate().isFirstSibling();
    }

    @Override
    public boolean isLastSibling() {
        return this.getDelegate().isLastSibling();
    }

    @Override
    public Data getNextSibling() {
        return this.newInstance(this.getDelegate().getNextSibling());
    }

    @Override
    public int getChildCount() {
        return this.getDelegate().getChildCount();
    }

    protected Iterator<DelegatedData> newChildIterator() {
        return new DelegatedIterator(this.getDelegate().getChildren().iterator());
    }

    @Override
    public Iterable<? extends Data> getChildren() {
        return this.delegatedIterable;
    }

    @Override
    public Data getChild(String path) {
        return this.newInstance(this.getDelegate().getChild(path));
    }

    @Override
    public Data createChild(String path) {
        return this.newInstance(this.getDelegate().createChild(path));
    }

    @Override
    public void removeTree(String path) {
        this.getDelegate().removeTree(path);
    }

    @Override
    public void setSymlink(String sourcePath, String destinationPath) {
        this.getDelegate().setSymlink(sourcePath, destinationPath);
    }

    @Override
    public void setSymlink(String sourcePath, Data destination) {
        destination = DelegatedData.unwrap(destination);
        this.getDelegate().setSymlink(sourcePath, destination);
    }

    @Override
    public void setSymlink(Data symLink) {
        symLink = DelegatedData.unwrap(symLink);
        this.getDelegate().setSymlink(symLink);
    }

    @Override
    public Data getSymlink() {
        return this.newInstance(this.getDelegate().getSymlink());
    }

    @Override
    public void copy(String toPath, Data from) {
        from = DelegatedData.unwrap(from);
        this.getDelegate().copy(toPath, from);
    }

    @Override
    public void copy(Data from) {
        from = DelegatedData.unwrap(from);
        this.getDelegate().copy(from);
    }

    @Override
    public String getValue(String path, String defaultValue) {
        return this.getDelegate().getValue(path, defaultValue);
    }

    @Override
    public int getIntValue(String path, int defaultValue) {
        return this.getDelegate().getIntValue(path, defaultValue);
    }

    @Override
    public String getValue(String path) {
        return this.getDelegate().getValue(path);
    }

    @Override
    public int getIntValue(String path) {
        return this.getDelegate().getIntValue(path);
    }

    @Override
    public boolean getBooleanValue(String path) {
        return this.getDelegate().getBooleanValue(path);
    }

    @Override
    public void setValue(String path, String value) {
        this.getDelegate().setValue(path, value);
    }

    @Override
    public String toString() {
        return ((Object)this.getDelegate()).toString();
    }

    @Override
    public void toString(StringBuilder out, int indent) {
        this.getDelegate().toString(out, indent);
    }

    @Override
    public void write(Appendable out, int indent) throws IOException {
        this.getDelegate().write(out, indent);
    }

    @Override
    public void optimize() {
        this.getDelegate().optimize();
    }

    @Override
    public void setEscapeMode(EscapeMode mode) {
        this.getDelegate().setEscapeMode(mode);
    }

    @Override
    public EscapeMode getEscapeMode() {
        return this.getDelegate().getEscapeMode();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class DelegatedIterator
    implements Iterator<DelegatedData> {
        private final Iterator<? extends Data> iterator;

        DelegatedIterator(Iterator<? extends Data> iterator) {
            this.iterator = iterator;
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        public DelegatedData next() {
            return DelegatedData.this.newInstance(this.iterator.next());
        }

        @Override
        public void remove() {
            this.iterator.remove();
        }
    }
}

