/*
 * Decompiled with CFR 0.152.
 */
package com.google.clearsilver.jsilver.data;

import com.google.clearsilver.jsilver.data.Data;
import com.google.clearsilver.jsilver.data.Parser;
import com.google.clearsilver.jsilver.data.ParserFactory;
import com.google.clearsilver.jsilver.resourceloader.ResourceLoader;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultHdfParser
implements Parser {
    private int initialContextSize = 10;

    @Override
    public void parse(Reader reader, Data output, Parser.ErrorHandler errorHandler, ResourceLoader resourceLoader, String dataFileName, boolean ignoreAttributes) throws IOException {
        String line;
        LineNumberReader lineReader = new LineNumberReader(reader);
        ArrayList<String> context = new ArrayList<String>(this.initialContextSize);
        while ((line = lineReader.readLine()) != null) {
            this.parseLine(line, output, context, lineReader, dataFileName, errorHandler);
        }
    }

    private void parseLine(String line, Data output, List<String> context, LineNumberReader lineReader, String dataFileName, Parser.ErrorHandler errorHandler) throws IOException {
        Split split = this.split(line = this.stripComment(line), "=");
        if (split != null) {
            output.setValue(this.createFullPath(context, split.left), split.right);
        } else {
            split = this.split(line, "<<");
            if (split != null) {
                output.setValue(this.createFullPath(context, split.left), this.readToToken(lineReader, split.right));
            } else {
                split = this.split(line, "{");
                if (split != null) {
                    context.add(split.left);
                } else if (this.split(line, "}") != null) {
                    context.remove(context.size() - 1);
                } else {
                    split = this.split(line, ":");
                    if (split != null) {
                        output.setSymlink(this.createFullPath(context, split.left), split.right);
                    } else if (line.trim().length() != 0 && errorHandler != null) {
                        errorHandler.error(lineReader.getLineNumber(), line, dataFileName, "Bad HDF syntax");
                    }
                }
            }
        }
    }

    private String stripComment(String line) {
        int commentPosition = line.indexOf(35);
        int equalsPosition = line.indexOf(61);
        if (commentPosition > -1 && (equalsPosition == -1 || commentPosition < equalsPosition)) {
            return line.substring(0, commentPosition);
        }
        return line;
    }

    private String readToToken(LineNumberReader reader, String token) throws IOException {
        String line;
        StringBuilder result = new StringBuilder();
        while ((line = reader.readLine()) != null && !line.trim().equals(token)) {
            result.append(line).append('\n');
        }
        return result.toString();
    }

    private String createFullPath(List<String> context, String subPath) {
        StringBuilder result = new StringBuilder();
        for (String contextItem : context) {
            result.append(contextItem).append('.');
        }
        result.append(subPath);
        return result.toString();
    }

    private Split split(String line, String delimiter) {
        int position = line.indexOf(delimiter);
        if (position > -1) {
            Split result = new Split();
            result.left = line.substring(0, position).trim();
            result.right = line.substring(position + delimiter.length()).trim();
            return result;
        }
        return null;
    }

    public static ParserFactory newFactory() {
        return new ParserFactory(){

            public Parser newInstance() {
                return new DefaultHdfParser();
            }
        };
    }

    private static class Split {
        String left;
        String right;

        private Split() {
        }
    }
}

