/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.impl;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.hibernate.Hibernate;
import org.hibernate.annotations.common.util.ReflectHelper;
import org.hibernate.annotations.common.util.StringHelper;
import org.hibernate.search.SearchException;
import org.hibernate.search.SearchFactory;
import org.hibernate.search.backend.BackendQueueProcessorFactory;
import org.hibernate.search.backend.LuceneWork;
import org.hibernate.search.backend.QueueingProcessor;
import org.hibernate.search.backend.Work;
import org.hibernate.search.backend.WorkType;
import org.hibernate.search.backend.impl.jms.JMSBackendQueueProcessorFactory;
import org.hibernate.search.backend.impl.lucene.LuceneBackendQueueProcessorFactory;
import org.hibernate.search.engine.DocumentBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BatchedQueueingProcessor
implements QueueingProcessor {
    private boolean sync;
    private ExecutorService executorService;
    private BackendQueueProcessorFactory backendQueueProcessorFactory;
    private SearchFactory searchFactory;

    public BatchedQueueingProcessor(SearchFactory searchFactory, Properties properties) {
        String backend;
        this.searchFactory = searchFactory;
        this.sync = !"async".equalsIgnoreCase(properties.getProperty("hibernate.search.worker.execution"));
        int min = Integer.parseInt(properties.getProperty("hibernate.search.worker.thread_pool.size", "1").trim());
        int queueSize = Integer.parseInt(properties.getProperty("hibernate.search.worker.buffer_queue.max", Integer.toString(Integer.MAX_VALUE)).trim());
        if (!this.sync) {
            this.executorService = new ThreadPoolExecutor(min, min, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(queueSize), new ThreadPoolExecutor.CallerRunsPolicy());
        }
        if (StringHelper.isEmpty((String)(backend = properties.getProperty("hibernate.search.worker.backend"))) || "lucene".equalsIgnoreCase(backend)) {
            this.backendQueueProcessorFactory = new LuceneBackendQueueProcessorFactory();
        } else if ("jms".equalsIgnoreCase(backend)) {
            this.backendQueueProcessorFactory = new JMSBackendQueueProcessorFactory();
        } else {
            try {
                Class processorFactoryClass = ReflectHelper.classForName((String)backend, BatchedQueueingProcessor.class);
                this.backendQueueProcessorFactory = (BackendQueueProcessorFactory)processorFactoryClass.newInstance();
            }
            catch (ClassNotFoundException e) {
                throw new SearchException("Unable to find processor class: " + backend, e);
            }
            catch (IllegalAccessException e) {
                throw new SearchException("Unable to instanciate processor class: " + backend, e);
            }
            catch (InstantiationException e) {
                throw new SearchException("Unable to instanciate processor class: " + backend, e);
            }
        }
        this.backendQueueProcessorFactory.initialize(properties, searchFactory);
        searchFactory.setBackendQueueProcessorFactory(this.backendQueueProcessorFactory);
    }

    @Override
    public void add(Object entity, Serializable id, WorkType workType, List<Work> queue) {
        Work work = new Work(entity, id, workType);
        queue.add(work);
    }

    @Override
    public void performWork(List<Work> queue) {
        int initialSize = queue.size();
        ArrayList<LuceneWork> luceneQueue = new ArrayList<LuceneWork>(initialSize);
        for (int i = 0; i < initialSize; ++i) {
            Work work = queue.get(i);
            queue.set(i, null);
            Class entityClass = Hibernate.getClass((Object)work.getEntity());
            DocumentBuilder<Object> builder = this.searchFactory.getDocumentBuilders().get(entityClass);
            if (builder == null) {
                return;
            }
            builder.addWorkToQueue(work.getEntity(), work.getId(), work.getType(), luceneQueue, this.searchFactory);
        }
        Runnable processor = this.backendQueueProcessorFactory.getProcessor(luceneQueue);
        if (this.sync) {
            processor.run();
        } else {
            this.executorService.execute(processor);
        }
    }

    @Override
    public void cancelWork(List<Work> queue) {
        queue.clear();
    }

    public void finalize() throws Throwable {
        super.finalize();
        if (this.executorService != null && !this.executorService.isShutdown()) {
            this.executorService.shutdown();
        }
    }
}

