/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.mortbay.io.Buffer;
import org.mortbay.io.ByteArrayBuffer;
import org.mortbay.io.Portable;
import org.mortbay.io.View;

public abstract class AbstractBuffer
implements Buffer {
    protected static final String __IMMUTABLE = "IMMUTABLE";
    protected static final String __READONLY = "READONLY";
    protected static final String __READWRITE = "READWRITE";
    protected static final String __VOLATILE = "VOLATILE";
    protected int _access;
    protected boolean _volatile;
    protected int _get;
    protected int _put;
    protected int _hash;
    private int _hashGet;
    private int _hashPut;
    private int _mark;
    protected String _string;
    private View _view;

    public AbstractBuffer(int access, boolean isVolatile) {
        if (access == 0 && isVolatile) {
            throw new IllegalArgumentException("IMMUTABLE && VOLATILE");
        }
        this.setMarkIndex(-1);
        this._access = access;
        this._volatile = isVolatile;
    }

    public byte[] asArray() {
        byte[] bytes = new byte[this.length()];
        byte[] array = this.array();
        if (array != null) {
            Portable.arraycopy(array, this.getIndex(), bytes, 0, bytes.length);
        } else {
            this.peek(this.getIndex(), bytes, 0, this.length());
        }
        return bytes;
    }

    public ByteArrayBuffer duplicate(int access) {
        Buffer b = this.buffer();
        if (b instanceof Buffer.CaseInsensitve) {
            return new ByteArrayBuffer.CaseInsensitive(this.asArray(), 0, this.length(), access);
        }
        return new ByteArrayBuffer(this.asArray(), 0, this.length(), access);
    }

    public Buffer asNonVolatileBuffer() {
        if (!this.isVolatile()) {
            return this;
        }
        return this.duplicate(this._access);
    }

    public Buffer asImmutableBuffer() {
        if (this.isImmutable()) {
            return this;
        }
        return this.duplicate(0);
    }

    public Buffer asReadOnlyBuffer() {
        if (this.isReadOnly()) {
            return this;
        }
        return new View(this, this.markIndex(), this.getIndex(), this.putIndex(), 1);
    }

    public Buffer asMutableBuffer() {
        if (!this.isImmutable()) {
            return this;
        }
        Buffer b = this.buffer();
        if (b.isReadOnly()) {
            return this.duplicate(2);
        }
        return new View(b, this.markIndex(), this.getIndex(), this.putIndex(), this._access);
    }

    public Buffer buffer() {
        return this;
    }

    public void clear() {
        this.setGetIndex(0);
        this.setPutIndex(0);
    }

    public void compact() {
        int s;
        if (this.isReadOnly()) {
            throw new IllegalStateException(__READONLY);
        }
        int n = s = this.markIndex() >= 0 ? this.markIndex() : this.getIndex();
        if (s > 0) {
            byte[] array = this.array();
            int length = this.putIndex() - s;
            if (length > 0) {
                if (array != null) {
                    Portable.arraycopy(this.array(), s, this.array(), 0, length);
                } else {
                    this.poke(0, this.peek(s, length));
                }
            }
            if (this.markIndex() > 0) {
                this.setMarkIndex(this.markIndex() - s);
            }
            this.setGetIndex(this.getIndex() - s);
            this.setPutIndex(this.putIndex() - s);
        }
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || !(obj instanceof Buffer)) {
            return false;
        }
        Buffer b = (Buffer)obj;
        if (this instanceof Buffer.CaseInsensitve || b instanceof Buffer.CaseInsensitve) {
            return this.equalsIgnoreCase(b);
        }
        if (b.length() != this.length()) {
            return false;
        }
        if (this._hash != 0 && obj instanceof AbstractBuffer) {
            AbstractBuffer ab = (AbstractBuffer)obj;
            if (ab._hash != 0 && this._hash != ab._hash) {
                return false;
            }
        }
        int i = this.length();
        while (i-- > 0) {
            byte b2;
            byte b1 = this.peek(this.getIndex() + i);
            if (b1 == (b2 = b.peek(b.getIndex() + i))) continue;
            return false;
        }
        return true;
    }

    public boolean equalsIgnoreCase(Buffer b) {
        if (b == this) {
            return true;
        }
        if (b.length() != this.length()) {
            return false;
        }
        if (this._hash != 0 && b instanceof AbstractBuffer) {
            AbstractBuffer ab = (AbstractBuffer)b;
            if (ab._hash != 0 && this._hash != ab._hash) {
                return false;
            }
        }
        int i = this.length();
        while (i-- > 0) {
            byte b2;
            byte b1 = this.peek(this.getIndex() + i);
            if (b1 == (b2 = b.peek(b.getIndex() + i))) continue;
            if (97 <= b1 && b1 <= 122) {
                b1 = (byte)(b1 - 97 + 65);
            }
            if (97 <= b2 && b2 <= 122) {
                b2 = (byte)(b2 - 97 + 65);
            }
            if (b1 == b2) continue;
            return false;
        }
        return true;
    }

    public byte get() {
        return this.peek(this._get++);
    }

    public int get(byte[] b, int offset, int length) {
        int gi = this.getIndex();
        int l = this.length();
        if (length > l) {
            length = l;
        }
        length = this.peek(gi, b, offset, length);
        this.setGetIndex(gi + length);
        return length;
    }

    public Buffer get(int length) {
        int gi = this.getIndex();
        Buffer view = this.peek(gi, length);
        this.setGetIndex(gi + length);
        return view;
    }

    public final int getIndex() {
        return this._get;
    }

    public boolean hasContent() {
        return this._put > this._get;
    }

    public int hashCode() {
        if (this._hash == 0 || this._hashGet != this._get || this._hashPut != this._put) {
            int i = this.putIndex();
            while (i-- > this.getIndex()) {
                byte b = this.peek(i);
                if (97 <= b && b <= 122) {
                    b = (byte)(b - 97 + 65);
                }
                this._hash = 31 * this._hash + b;
            }
            if (this._hash == 0) {
                this._hash = -1;
            }
            this._hashGet = this._get;
            this._hashPut = this._put;
        }
        return this._hash;
    }

    public boolean isImmutable() {
        return this._access <= 0;
    }

    public boolean isReadOnly() {
        return this._access <= 1;
    }

    public boolean isVolatile() {
        return this._volatile;
    }

    public int length() {
        return this._put - this._get;
    }

    public void mark() {
        this.setMarkIndex(this._get - 1);
    }

    public void mark(int offset) {
        this.setMarkIndex(this._get + offset);
    }

    public int markIndex() {
        return this._mark;
    }

    public byte peek() {
        return this.peek(this._get);
    }

    public Buffer peek(int index, int length) {
        if (this._view == null) {
            this._view = new View(this, -1, index, index + length, this.isReadOnly() ? 1 : 2);
        } else {
            this._view.update(this.buffer());
            this._view.setMarkIndex(-1);
            this._view.setGetIndex(0);
            this._view.setPutIndex(index + length);
            this._view.setGetIndex(index);
        }
        return this._view;
    }

    public int poke(int index, Buffer src) {
        this._hash = 0;
        if (this.isReadOnly()) {
            throw new IllegalStateException(__READONLY);
        }
        if (index < 0) {
            throw new IllegalArgumentException("index<0: " + index + "<0");
        }
        int length = src.length();
        if (index + length > this.capacity() && (length = this.capacity() - index) < 0) {
            throw new IllegalArgumentException("index>capacity(): " + index + ">" + this.capacity());
        }
        byte[] src_array = src.array();
        byte[] dst_array = this.array();
        if (src_array != null && dst_array != null) {
            Portable.arraycopy(src_array, src.getIndex(), dst_array, index, length);
        } else if (src_array != null) {
            int s = src.getIndex();
            for (int i = 0; i < length; ++i) {
                this.poke(index++, src_array[s++]);
            }
        } else if (dst_array != null) {
            int s = src.getIndex();
            for (int i = 0; i < length; ++i) {
                dst_array[index++] = src.peek(s++);
            }
        } else {
            int s = src.getIndex();
            for (int i = 0; i < length; ++i) {
                this.poke(index++, src.peek(s++));
            }
        }
        return length;
    }

    public int poke(int index, byte[] b, int offset, int length) {
        this._hash = 0;
        if (this.isReadOnly()) {
            throw new IllegalStateException(__READONLY);
        }
        if (index < 0) {
            throw new IllegalArgumentException("index<0: " + index + "<0");
        }
        if (index + length > this.capacity() && (length = this.capacity() - index) < 0) {
            throw new IllegalArgumentException("index>capacity(): " + index + ">" + this.capacity());
        }
        byte[] dst_array = this.array();
        if (dst_array != null) {
            Portable.arraycopy(b, offset, dst_array, index, length);
        } else {
            int s = offset;
            for (int i = 0; i < length; ++i) {
                this.poke(index++, b[s++]);
            }
        }
        return length;
    }

    public int put(Buffer src) {
        int pi = this.putIndex();
        int l = this.poke(pi, src);
        this.setPutIndex(pi + l);
        return l;
    }

    public void put(byte b) {
        int pi = this.putIndex();
        this.poke(pi, b);
        this.setPutIndex(pi + 1);
    }

    public int put(byte[] b, int offset, int length) {
        int pi = this.putIndex();
        int l = this.poke(pi, b, offset, length);
        this.setPutIndex(pi + l);
        return l;
    }

    public int put(byte[] b) {
        int pi = this.putIndex();
        int l = this.poke(pi, b, 0, b.length);
        this.setPutIndex(pi + l);
        return l;
    }

    public final int putIndex() {
        return this._put;
    }

    public void reset() {
        if (this.markIndex() >= 0) {
            this.setGetIndex(this.markIndex());
        }
    }

    public void rewind() {
        this.setGetIndex(0);
        this.setMarkIndex(-1);
    }

    public void setGetIndex(int getIndex) {
        this._get = getIndex;
        this._hash = 0;
    }

    public void setMarkIndex(int index) {
        if (index >= 0 && this.isImmutable()) {
            throw new IllegalStateException(__IMMUTABLE);
        }
        this._mark = index;
    }

    public void setPutIndex(int putIndex) {
        this._put = putIndex;
        this._hash = 0;
    }

    public int skip(int n) {
        if (this.length() < n) {
            n = this.length();
        }
        this.setGetIndex(this.getIndex() + n);
        return n;
    }

    public Buffer slice() {
        return this.peek(this.getIndex(), this.length());
    }

    public Buffer sliceFromMark() {
        return this.sliceFromMark(this.getIndex() - this.markIndex() - 1);
    }

    public Buffer sliceFromMark(int length) {
        if (this.markIndex() < 0) {
            return null;
        }
        Buffer view = this.peek(this.markIndex(), length);
        this.setMarkIndex(-1);
        return view;
    }

    public int space() {
        return this.capacity() - this.putIndex();
    }

    public String toDetailString() {
        StringBuffer buf = new StringBuffer();
        buf.append("[");
        buf.append(super.hashCode());
        buf.append(",");
        buf.append(this.array().hashCode());
        buf.append(",m=");
        buf.append(this.markIndex());
        buf.append(",g=");
        buf.append(this.getIndex());
        buf.append(",p=");
        buf.append(this.putIndex());
        buf.append(",c=");
        buf.append(this.capacity());
        buf.append("]={");
        if (this.markIndex() >= 0) {
            for (int i = this.markIndex(); i < this.getIndex(); ++i) {
                char c = (char)this.peek(i);
                if (Character.isISOControl(c)) {
                    buf.append(c < '\u0010' ? "\\0" : "\\");
                    buf.append(Integer.toString(c, 16));
                    continue;
                }
                buf.append(c);
            }
            buf.append("}{");
        }
        int count = 0;
        for (int i = this.getIndex(); i < this.putIndex(); ++i) {
            char c = (char)this.peek(i);
            if (Character.isISOControl(c)) {
                buf.append(c < '\u0010' ? "\\0" : "\\");
                buf.append(Integer.toString(c, 16));
            } else {
                buf.append(c);
            }
            if (count++ != 50 || this.putIndex() - i <= 20) continue;
            buf.append(" ... ");
            i = this.putIndex() - 20;
        }
        buf.append('}');
        return buf.toString();
    }

    public String toString() {
        if (this.isImmutable()) {
            if (this._string == null) {
                this._string = new String(this.asArray(), 0, this.length());
            }
            return this._string;
        }
        return new String(this.asArray(), 0, this.length());
    }

    public String toDebugString() {
        return this.getClass() + "@" + super.hashCode();
    }

    public void writeTo(OutputStream out) throws IOException {
        byte[] array = this.array();
        if (array != null) {
            out.write(array, this.getIndex(), this.length());
        } else {
            for (int i = this._get; i < this._put; ++i) {
                out.write(this.peek(i));
            }
        }
        this.clear();
    }

    public int readFrom(InputStream in, int max) throws IOException {
        int len = 0;
        while (this.space() > 0) {
            int b = in.read();
            if (b < 0) {
                return -1;
            }
            this.put((byte)b);
            ++len;
        }
        return len;
    }
}

