/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.util.file;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.JarURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.jar.JarInputStream;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;

public final class JarUtils {
    private JarUtils() {
    }

    public static void jar(OutputStream outputStream, File file) throws IOException {
        JarUtils.jar(outputStream, new File[]{file}, null, null, null);
    }

    public static void jar(OutputStream outputStream, File[] fileArray) throws IOException {
        JarUtils.jar(outputStream, fileArray, null, null, null);
    }

    public static void jar(OutputStream outputStream, File[] fileArray, FileFilter fileFilter) throws IOException {
        JarUtils.jar(outputStream, fileArray, fileFilter, null, null);
    }

    public static void jar(OutputStream outputStream, File[] fileArray, FileFilter fileFilter, String string, Manifest manifest) throws IOException {
        for (int i = 0; i < fileArray.length; ++i) {
            if (fileArray[i].exists()) continue;
            throw new FileNotFoundException(fileArray.toString());
        }
        JarOutputStream jarOutputStream = manifest == null ? new JarOutputStream(outputStream) : new JarOutputStream(outputStream, manifest);
        if (string != null && string.length() > 0 && !string.equals("/")) {
            if (string.charAt(0) == '/') {
                string = string.substring(1);
            }
            if (string.charAt(string.length() - 1) != '/') {
                string = string + "/";
            }
        } else {
            string = "";
        }
        JarInfo jarInfo = new JarInfo(jarOutputStream, fileFilter);
        for (int i = 0; i < fileArray.length; ++i) {
            JarUtils.jar(fileArray[i], string, jarInfo);
        }
        jarOutputStream.close();
    }

    private static void jar(File file, String string, JarInfo jarInfo) throws IOException {
        JarOutputStream jarOutputStream = jarInfo.out;
        if (file.isDirectory()) {
            string = string + file.getName() + "/";
            ZipEntry zipEntry = new ZipEntry(string);
            zipEntry.setTime(file.lastModified());
            zipEntry.setMethod(0);
            zipEntry.setSize(0L);
            zipEntry.setCrc(0L);
            jarOutputStream.putNextEntry(zipEntry);
            jarOutputStream.closeEntry();
            File[] fileArray = file.listFiles(jarInfo.filter);
            for (int i = 0; i < fileArray.length; ++i) {
                JarUtils.jar(fileArray[i], string, jarInfo);
            }
        } else if (file.isFile()) {
            int n;
            byte[] byArray = jarInfo.buffer;
            ZipEntry zipEntry = new ZipEntry(string + file.getName());
            zipEntry.setTime(file.lastModified());
            jarOutputStream.putNextEntry(zipEntry);
            FileInputStream fileInputStream = new FileInputStream(file);
            while ((n = fileInputStream.read(byArray, 0, byArray.length)) != -1) {
                jarOutputStream.write(byArray, 0, n);
            }
            fileInputStream.close();
            jarOutputStream.closeEntry();
        }
    }

    public static void unjar(InputStream inputStream, File file) throws IOException {
        FileOutputStream fileOutputStream;
        File file2;
        File file3;
        Object object;
        if (!file.exists()) {
            file.mkdirs();
        }
        if (!file.isDirectory()) {
            throw new IOException("Destination must be a directory.");
        }
        JarInputStream jarInputStream = new JarInputStream(inputStream);
        byte[] byArray = new byte[1024];
        ZipEntry zipEntry = jarInputStream.getNextEntry();
        while (zipEntry != null) {
            object = zipEntry.getName();
            if (((String)object).charAt(((String)object).length() - 1) == '/') {
                object = ((String)object).substring(0, ((String)object).length() - 1);
            }
            if (((String)object).charAt(0) == '/') {
                object = ((String)object).substring(1);
            }
            if (File.separatorChar != '/') {
                object = ((String)object).replace('/', File.separatorChar);
            }
            file3 = new File(file, (String)object);
            if (zipEntry.isDirectory()) {
                file3.mkdirs();
                jarInputStream.closeEntry();
            } else {
                file2 = file3.getParentFile();
                if (file2 != null && !file2.exists()) {
                    file2.mkdirs();
                }
                fileOutputStream = new FileOutputStream(file3);
                int n = 0;
                while ((n = jarInputStream.read(byArray, 0, byArray.length)) != -1) {
                    ((OutputStream)fileOutputStream).write(byArray, 0, n);
                }
                fileOutputStream.flush();
                ((OutputStream)fileOutputStream).close();
                jarInputStream.closeEntry();
                file3.setLastModified(zipEntry.getTime());
            }
            zipEntry = jarInputStream.getNextEntry();
        }
        object = jarInputStream.getManifest();
        if (object != null) {
            file3 = new File(file, "META-INF/MANIFEST.MF");
            file2 = file3.getParentFile();
            if (!file2.exists()) {
                file2.mkdirs();
            }
            fileOutputStream = new FileOutputStream(file3);
            ((Manifest)object).write(fileOutputStream);
            fileOutputStream.flush();
            ((OutputStream)fileOutputStream).close();
        }
        jarInputStream.close();
    }

    public static URL extractNestedJar(URL uRL, File file) throws IOException {
        int n;
        char c;
        char c2;
        int n2;
        if (!uRL.getProtocol().equals("jar")) {
            return uRL;
        }
        String string = file.getAbsolutePath();
        URLConnection uRLConnection = uRL.openConnection();
        JarURLConnection jarURLConnection = (JarURLConnection)uRLConnection;
        String string2 = jarURLConnection.getJarFile().getName();
        int n3 = Math.min(string.length(), string2.length());
        for (n2 = 0; n2 < n3 && (c2 = string.charAt(n2)) == (c = string2.charAt(n2)); ++n2) {
        }
        File file2 = new File(file, (string2 = string2.substring(n2)) + "-contents");
        if (!file2.exists() && !file2.mkdirs()) {
            throw new IOException("Failed to create contents directory for archive, path=" + file2.getAbsolutePath());
        }
        String string3 = jarURLConnection.getEntryName();
        File file3 = new File(file2, string3);
        File file4 = file3.getParentFile();
        if (!file4.exists() && !file4.mkdirs()) {
            throw new IOException("Failed to create parent directory for archive, path=" + file4.getAbsolutePath());
        }
        InputStream inputStream = jarURLConnection.getInputStream();
        FileOutputStream fileOutputStream = new FileOutputStream(file3);
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(fileOutputStream);
        byte[] byArray = new byte[4096];
        while ((n = inputStream.read(byArray)) > 0) {
            bufferedOutputStream.write(byArray, 0, n);
        }
        inputStream.close();
        bufferedOutputStream.close();
        return file3.toURL();
    }

    public static void main(String[] stringArray) throws Exception {
        if (stringArray.length == 0) {
            System.out.println("usage: <x or c> <jar-archive> <files...>");
            System.exit(0);
        }
        if (stringArray[0].equals("x")) {
            BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(stringArray[1]));
            File file = new File(stringArray[2]);
            JarUtils.unjar(bufferedInputStream, file);
        } else if (stringArray[0].equals("c")) {
            BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(stringArray[1]));
            File[] fileArray = new File[stringArray.length - 2];
            for (int i = 0; i < fileArray.length; ++i) {
                fileArray[i] = new File(stringArray[2 + i]);
            }
            JarUtils.jar((OutputStream)bufferedOutputStream, fileArray);
        } else {
            System.out.println("Need x or c as first argument");
        }
    }

    private static class JarInfo {
        public JarOutputStream out;
        public FileFilter filter;
        public byte[] buffer;

        public JarInfo(JarOutputStream jarOutputStream, FileFilter fileFilter) {
            this.out = jarOutputStream;
            this.filter = fileFilter;
            this.buffer = new byte[1024];
        }
    }
}

