/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.util.file;

import java.io.File;
import java.io.FileFilter;

public class FileSuffixFilter
implements FileFilter {
    protected final String[] suffixes;
    protected final boolean ignoreCase;

    public FileSuffixFilter(String[] stringArray, boolean bl) {
        this.ignoreCase = bl;
        if (bl) {
            this.suffixes = new String[stringArray.length];
            for (int i = 0; i < stringArray.length; ++i) {
                this.suffixes[i] = stringArray[i].toLowerCase();
            }
        } else {
            this.suffixes = stringArray;
        }
    }

    public FileSuffixFilter(String[] stringArray) {
        this(stringArray, false);
    }

    public FileSuffixFilter(String string, boolean bl) {
        this(new String[]{string}, bl);
    }

    public FileSuffixFilter(String string) {
        this(string, false);
    }

    public boolean accept(File file) {
        boolean bl = false;
        for (int i = 0; i < this.suffixes.length && !bl; ++i) {
            bl = this.ignoreCase ? file.getName().toLowerCase().endsWith(this.suffixes[i]) : file.getName().endsWith(this.suffixes[i]);
        }
        return bl;
    }
}

