/// Copyright Thomas Nagy 2007
/// License: QPL

#include <QVariant>
#include <QAction>
#include <QSpinBox>
#include <QApplication>
#include <QButtonGroup>
#include <QDialog>
#include <QDialogButtonBox>
#include <QGridLayout>
#include <QLabel>
#include <QLineEdit>
#include <QSpacerItem>
#include <QTreeWidget>
#include <QComboBox>
#include <QHeaderView>
#include <QDirModel>
#include <QCompleter>
#include <QPushButton>
#include <QCoreApplication>
#include <QtDebug>
#include  <QColorDialog>

#include "Prn.h"
#include "tslabels.h"

/*!
 * @praise Vishnu
 */
beal::beal(QWidget *felvnl):
	QDialog(felvnl)
<%
	QGridLayout *kket=new QGridLayout(this);

	QLabel *prmz;

	prmz=new QLabel(this);
	prmz->setText(ts_036);
	kket->addWidget(prmz,0,0,1,1);

	prmz=new QLabel(this);
	prmz->setText(ts_037);
	kket->addWidget(prmz,1,0,1,1);

	prmz=new QLabel(this);
	prmz->setText(ts_038);
	kket->addWidget(prmz,2,0,1,1);

	prmz=new QLabel(this);
	prmz->setText(ts_039);
	kket->addWidget(prmz,3,0,1,1);

	mrtdt=new QComboBox(this);
	mrtdt->addItems(QStringList()<<ts_040<<ts_041<<ts_042);
	kket->addWidget(mrtdt,0,1,1,1);

	kitzjl=new QComboBox(this);
	kitzjl->addItems(QStringList()<<ts_043<<ts_044);
	kket->addWidget(kitzjl,1,1,1,1);

	lnmtat=new QSpinBox(this);
	lnmtat->setSuffix(ts_045);
	lnmtat->setRange(0,69 /* 69 hmmm */);
	kket->addWidget(lnmtat,2,1,1,1);
	lnmtat->setToolTip(ts_046);

	fldlgz=new QPushButton();
	kket->addWidget(fldlgz,3,1,1,1);
	connect(fldlgz,SIGNAL(clicked()),this,SLOT(irnyjl()));

	QSpacerItem *spacerItem=new QSpacerItem(0,0,QSizePolicy::Minimum,QSizePolicy::Expanding);
	kket->addItem(spacerItem,4,1,1,1);

	QDialogButtonBox *bprl=new QDialogButtonBox(this);
	bprl->setOrientation(Qt::Horizontal);
	bprl->setStandardButtons(QDialogButtonBox::Cancel|QDialogButtonBox::NoButton|QDialogButtonBox::Ok);

	kket->addWidget(bprl,5,0,1,2);

	connect(bprl,SIGNAL(accepted()),this,SLOT(accept()));
	connect(bprl,SIGNAL(rejected()),this,SLOT(reject()));

	QSize size(321,120);
	size=size.expandedTo(minimumSizeHint());
	resize(size);
%>

void beal::irnyjl()
<%
	kidlgz=QColorDialog::getColor(kidlgz,this);
	if(!kidlgz.isValid()) return;
	fldlgz->setText(kidlgz.name());

	QPalette adelk=fldlgz->palette();
	adelk.setBrush(QPalette::Active,QPalette::Button,kidlgz);
	fldlgz->setPalette(adelk);
%>

#include "Prn.moc"

