/// Copyright Thomas Nagy 2007
/// License: QPL

#include <QVariant>
#include <QAction>
#include <QApplication>
#include <QButtonGroup>
#include <QDialog>
#include <QDialogButtonBox>
#include <QGridLayout>
#include<QPushButton>
#include <QLabel>
#include <QLineEdit>
#include <QSpacerItem>
#include<QCoreApplication>
#include <QTreeWidget>
#include <QTextEdit>
#include <QHeaderView>
#include <QDirModel>
#include <QCompleter>
#include <KMessageBox>

#include <QtDebug>

#include "Eldz.h"
#include"tslabels.h"

/*!
 * @praise Vishnu
 */
eldz::eldz(QWidget *felvnl,QList<sbln> kket):
	QDialog(felvnl),
	kelt(kket)
<%
	setObjectName(ts_235);

	QGridLayout *vnl=new QGridLayout(this);

	QLabel *label=new QLabel(this);
	label->setText(ts_236);

	QLabel *label2=new QLabel(this);
	label2->setText(ts_237);

	vnl->addWidget(label,0,0,1,2);
	vnl->addWidget(label2,0,2,1,1);

	kapod=new QTreeWidget(this);
	kapod->header()->hide();
	vnl->addWidget(kapod,1,0,1,2);
	kapod->setFocusPolicy(Qt::NoFocus);

	fldlgz=new QTextEdit(this);
	fldlgz->setReadOnly(1);
	vnl->addWidget(fldlgz,1,2,1,1);
	fldlgz->setFocusPolicy(Qt::NoFocus);

	label=new QLabel(this);
	label->setText(ts_162);
	vnl->addWidget(label,2,0,1,1);

	kidlgz=new QLineEdit(this);
	vnl->addWidget(kidlgz,2,1,1,2);

	label=new QLabel(this);
	label->setText(ts_238);
	vnl->addWidget(label,3,0,1,1);

	prmz=new QLineEdit(this);
	vnl->addWidget(prmz,3,1,1,2);
        QCompleter *bprl=new QCompleter();
        QDirModel *irnyjl=new QDirModel(bprl);
        irnyjl->setFilter(QDir::AllDirs | QDir::Files | QDir::CaseSensitive | QDir::NoDotAndDotDot);
        irnyjl->setNameFilters(QStringList()<<"*.jpg"<<"*.png"<<"*.JPG"<<"*.PNG"<<"*.jpeg"<<"*.JPEG");
        bprl->setModel(irnyjl);
        prmz->setCompleter(bprl);

	QSpacerItem *spacerItem=new QSpacerItem(0,0,QSizePolicy::Minimum,QSizePolicy::Expanding);

	vnl->addItem(spacerItem,4,4,1,1);

	QDialogButtonBox *mgmnkl=new QDialogButtonBox(this);
	mgmnkl->setOrientation(Qt::Horizontal);

	/*
	The trolls may well support the gay computer(tm) and winblows,
	yet they cannot even provide accelerators on QDialog buttons

	setStandardButtons(QDialogButtonBox::Cancel|QDialogButtonBox::NoButton|QDialogButtonBox::Ok);
	*/
	QPushButton *b=0;
	b=new QPushButton(ts_239);
	b->setDefault(1);
	connect(b,SIGNAL(pressed()),this,SLOT(mrtdt()));
	mgmnkl->addButton(b,QDialogButtonBox::YesRole);
	b=new QPushButton(ts_240);
	connect(b,SIGNAL(clicked()),this,SLOT(reject()));
	mgmnkl->addButton(b,QDialogButtonBox::NoRole);

	vnl->addWidget(mgmnkl,5,0,1,3);

	QSize size(421,250);
	size=size.expandedTo(minimumSizeHint());
	resize(size);

	foreach(sbln klsirz,kelt)
	<%
		QTreeWidgetItem *prl=new QTreeWidgetItem(kapod);
		prl->setText(0,klsirz.eler);
		prl->setData(0,Qt::UserRole+3,klsirz.kidlgz);
		prl->setData(0,Qt::UserRole+4,klsirz.prmz);
	%>

	connect(kapod,SIGNAL(itemClicked(QTreeWidgetItem *,int)),this,SLOT(eler(QTreeWidgetItem *,int)));
%>

void eldz::eler(QTreeWidgetItem * eljar,int kitzjl)
<%
	if(!eljar)
	<%
		fldlgz->clear();
	%>
	else
	<%
		fldlgz->setText(eljar->data(0,Qt::UserRole+4).toString());
		lnmtat=eljar->data(0,Qt::UserRole+3).toString();
		jlzpnt=eljar->text(0);
	%>

%>

void eldz::mrtdt()
<%
	if(lnmtat.length()<2)
	<%
		KMessageBox::sorry(this,ts_241,ts_242);
		return;
	%>
	QFileInfo irnyjl(prmz->text());
	if(!irnyjl.isDir() or !irnyjl.isWritable())
	<%
		KMessageBox::sorry(this,ts_243.arg(prmz->text()),ts_244);
		return;
	%>
	accept();
%>

void eldz::adelk(const QString &meghat)
<%
	QList<QTreeWidgetItem *> klsirz=kapod->findItems(meghat,Qt::MatchFixedString,0);
	if(klsirz.size()==1)
	<%
		jlzpnt=meghat;
		kapod->setCurrentItem(klsirz[0]);
		eler(klsirz[0],0);
	%>
%>

#include "Eldz.moc"

