// ============================================================================
// Scilab ( http://www.scilab.org/ ) - This file is part of Scilab
// Copyright (C) 2010 - DIGITEO - Clément DAVID
// Copyright (C) 2012 - Scilab Enterprises - Clément DAVID
//
//  This file is distributed under the same license as the Scilab package.
// ============================================================================

loadXcosLibs();

prot = funcprot();
funcprot(0);

// Stubbing the x_mdialog method
function [result]=x_mdialog(dialog_title,labels,default_inputs_vector)
	result = default_inputs_vector;
endfunction

funcprot(prot);

// variables
interfaceAlias = BIGSOM_f;
job = "set";

// initialize the test
execstr("blk = interfaceAlias(''define'', [], [])");
context = " ";

// run the test without modification
new_blk = xcosBlockInterface(interfaceAlias, job, blk, context);
assert_checkequal (new_blk, []);

// run the test with modification
blk.graphics.exprs = "[-1;1]";
new_blk = xcosBlockInterface(interfaceAlias, job, blk, context);
assert_checkequal (new_blk.model.rpar, [-1 ; 1]);

