/* The following code was generated by JFlex 1.4.3 on 23/05/12 15:23 */

//CHECKSTYLE:OFF

package org.scilab.modules.scinotes;

import java.io.IOException;
import javax.swing.text.Element;

@javax.annotation.Generated("JFlex")
@SuppressWarnings("fallthrough")

/**
 * This class is a scanner generated by
 * <a href="http://www.jflex.de/">JFlex</a> 1.4.3
 * on 23/05/12 15:23 from the specification file
 * <tt>./jflex/matchingblock.jflex</tt>
 */
public final class MatchingBlockScanner {

    /** This character denotes the end of file */
    public static final int YYEOF = -1;

    /** initial size of the lookahead buffer */
    private static final int ZZ_BUFFERSIZE = 256;

    /** lexical states */
    public static final int OPENCLOSE = 6;
    public static final int LR = 2;
    public static final int YYINITIAL = 0;
    public static final int PSNART = 10;
    public static final int CLOSEOPEN = 8;
    public static final int SPEC = 12;
    public static final int RL = 4;

    /**
     * ZZ_LEXSTATE[l] is the state in the DFA for the lexical state l
     * ZZ_LEXSTATE[l+1] is the state in the DFA for the lexical state l
     *                  at the beginning of a line
     * l is of the form l = 2*k, k a non negative integer
     */
    private static final int ZZ_LEXSTATE[] = {
        0,  0,  1,  1,  2,  2,  3,  3,  4,  4,  5,  5,  6, 6
    };

    /**
     * Translates characters to character classes
     */
    private static final String ZZ_CMAP_PACKED =
        "\12\0\1\1\2\0\1\3\23\0\1\6\1\10\1\6\1\4\1\5" +
        "\1\0\1\7\1\30\1\11\5\0\1\2\12\4\5\0\1\6\1\0" +
        "\32\6\1\30\1\0\1\11\1\0\1\6\1\0\2\6\1\23\1\31" +
        "\1\21\1\13\1\6\1\17\1\12\2\6\1\20\1\6\1\27\1\14" +
        "\2\6\1\15\1\22\1\24\1\26\1\6\1\16\1\6\1\25\1\6" +
        "\1\30\1\0\1\11\uff82\0";

    /**
     * Translates characters to character classes
     */
    private static final char [] ZZ_CMAP = zzUnpackCMap(ZZ_CMAP_PACKED);

    /**
     * Translates DFA states to action switch labels.
     */
    private static final int [] ZZ_ACTION = zzUnpackAction();

    private static final String ZZ_ACTION_PACKED_0 =
        "\7\0\6\1\1\2\6\1\1\3\2\1\1\4\6\1" +
        "\1\2\1\1\11\2\1\5\1\6\1\0\1\7\2\0" +
        "\1\1\1\3\6\1\11\0\1\2\6\0\1\3\13\0" +
        "\2\1\1\2\2\1\6\0\1\1\1\2\3\0\1\2" +
        "\7\0\5\1\11\0\1\3\4\0\3\1\13\0\2\1" +
        "\7\0\2\1\6\0\1\1\1\0\1\2\3\0\3\1" +
        "\3\0\1\1\2\0\1\2";

    private static int [] zzUnpackAction() {
        int [] result = new int[173];
        int offset = 0;
        offset = zzUnpackAction(ZZ_ACTION_PACKED_0, offset, result);
        return result;
    }

    private static int zzUnpackAction(String packed, int offset, int [] result) {
        int i = 0;       /* index in packed string  */
        int j = offset;  /* index in unpacked array */
        int l = packed.length();
        while (i < l) {
            int count = packed.charAt(i++);
            int value = packed.charAt(i++);
            do result[j++] = value;
            while (--count > 0);
        }
        return j;
    }


    /* error codes */
    private static final int ZZ_UNKNOWN_ERROR = 0;
    private static final int ZZ_NO_MATCH = 1;
    private static final int ZZ_PUSHBACK_2BIG = 2;

    /* error messages for the codes above */
    private static final String ZZ_ERROR_MSG[] = {
        "Unkown internal scanner error",
        "Error: could not match input",
        "Error: pushback value was too large"
    };

    /** the input device */
    private java.io.Reader zzReader;

    /** the current state of the DFA */
    private int zzState;

    /** the current lexical state */
    private int zzLexicalState = YYINITIAL;

    /** this buffer contains the current text to be matched and is
        the source of the yytext() string */
    private char zzBuffer[] = new char[ZZ_BUFFERSIZE];

    /** the textposition at the last accepting state */
    private int zzMarkedPos;

    /** the current text position in the buffer */
    private int zzCurrentPos;

    /** startRead marks the beginning of the yytext() string in the buffer */
    private int zzStartRead;

    /** endRead marks the last character in the buffer, that has been read
        from input */
    private int zzEndRead;

    /** number of newlines encountered up to the start of the matched text */
    private int yyline;

    /** the number of characters up to the start of the matched text */
    private int yychar;

    /**
     * the number of characters from the last newline up to the start of the
     * matched text
     */
    private int yycolumn;

    /**
     * zzAtBOL == true <=> the scanner is currently at the beginning of a line
     */
    private boolean zzAtBOL = true;

    /** zzAtEOF == true <=> the scanner is at the EOF */
    private boolean zzAtEOF;

    /** denotes if the user-EOF-code has already been executed */
    private boolean zzEOFDone;

    /* user code: */
    private ScilabDocument doc;
    private Element elem;
    private boolean transp = false;
    private ScilabLexer scilabLexer;
    private int start;
    private int end;
    private int savePos;

    public MatchingBlockScanner(ScilabDocument doc) {
        this.doc = doc;
        this.elem = doc.getDefaultRootElement();
        this.scilabLexer = doc.createLexer();
    }

    public MatchingPositions getMatchingBlock(int pos, boolean lr) {
        int p1, s = 1;
        transp = false;
        try {
            if (lr) {
                start =  pos;
                end = doc.getEndPosition().getOffset();
                yyreset(new ScilabDocumentReader(doc, start, end));
                yybegin(OPENCLOSE);
                if (yylex() != 1) {
                    return null;
                }

                p1 = pos + yylength();
                yybegin(LR);
            } else {
                start = pos - 1;
                end = 0;
                yyreset(new ScilabDocumentReader(doc, true, start, end));
                yybegin(CLOSEOPEN);
                if (yylex() != 1) {
                    return null;
                }
                p1 = pos - yylength();
                yybegin(RL);
            }

            do {
                if (yylex() == 0) {
                    s--;
                } else {
                    s++;
                }
            } while (zzMarkedPos != 0 && s != 0);
        } catch (IOException e) {
            return null;
        }
        if (s == 0) {
            if (lr) {
                return new MatchingPositions(pos, p1, pos + yychar, pos + yychar + (transp ? (yylength() - 1) : yylength()));
            } else {
                return new MatchingPositions(p1, pos, pos - yychar - yylength(), pos - yychar);
            }
        }

        return null;
    }

    public final class MatchingPositions {
        public int firstB;
        public int firstE;
        public int secondB;
        public int secondE;

        private MatchingPositions(int x1, int x2, int y1, int y2) {
            firstB = x1;
            firstE = x2;
            secondB = y1;
            secondE = y2;
        }
    }


    /**
     * Creates a new scanner
     * There is also a java.io.InputStream version of this constructor.
     *
     * @param   in  the java.io.Reader to read input from.
     */
    public MatchingBlockScanner(java.io.Reader in) {
        this.zzReader = in;
    }

    /**
     * Creates a new scanner.
     * There is also java.io.Reader version of this constructor.
     *
     * @param   in  the java.io.Inputstream to read input from.
     */
    public MatchingBlockScanner(java.io.InputStream in) {
        this(new java.io.InputStreamReader(in));
    }

    /**
     * Unpacks the compressed character translation table.
     *
     * @param packed   the packed character translation table
     * @return         the unpacked character translation table
     */
    private static char [] zzUnpackCMap(String packed) {
        char [] map = new char[0x10000];
        int i = 0;  /* index in packed string  */
        int j = 0;  /* index in unpacked array */
        while (i < 108) {
            int  count = packed.charAt(i++);
            char value = packed.charAt(i++);
            do map[j++] = value;
            while (--count > 0);
        }
        return map;
    }


    /**
     * Refills the input buffer.
     *
     * @return      <code>false</code>, iff there was new input.
     *
     * @exception   java.io.IOException  if any I/O-Error occurs
     */
    private boolean zzRefill() throws java.io.IOException {

        /* first: make room (if you can) */
        if (zzStartRead > 0) {
            System.arraycopy(zzBuffer, zzStartRead,
                             zzBuffer, 0,
                             zzEndRead - zzStartRead);

            /* translate stored positions */
            zzEndRead -= zzStartRead;
            zzCurrentPos -= zzStartRead;
            zzMarkedPos -= zzStartRead;
            zzStartRead = 0;
        }

        /* is the buffer big enough? */
        if (zzCurrentPos >= zzBuffer.length) {
            /* if not: blow it up */
            char newBuffer[] = new char[zzCurrentPos * 2];
            System.arraycopy(zzBuffer, 0, newBuffer, 0, zzBuffer.length);
            zzBuffer = newBuffer;
        }

        /* finally: fill the buffer with new input */
        int numRead = zzReader.read(zzBuffer, zzEndRead,
                                    zzBuffer.length - zzEndRead);

        if (numRead > 0) {
            zzEndRead += numRead;
            return false;
        }
        // unlikely but not impossible: read 0 characters, but not at end of stream
        if (numRead == 0) {
            int c = zzReader.read();
            if (c == -1) {
                return true;
            } else {
                zzBuffer[zzEndRead++] = (char) c;
                return false;
            }
        }

        // numRead < 0
        return true;
    }


    /**
     * Closes the input stream.
     */
    public final void yyclose() throws java.io.IOException {
        zzAtEOF = true;            /* indicate end of file */
        zzEndRead = zzStartRead;  /* invalidate buffer    */

        if (zzReader != null)
            zzReader.close();
    }


    /**
     * Resets the scanner to read from a new input stream.
     * Does not close the old reader.
     *
     * All internal variables are reset, the old input stream
     * <b>cannot</b> be reused (internal buffer is discarded and lost).
     * Lexical state is set to <tt>ZZ_INITIAL</tt>.
     *
     * @param reader   the new input stream
     */
    public final void yyreset(java.io.Reader reader) {
        zzReader = reader;
        zzAtBOL  = true;
        zzAtEOF  = false;
        zzEOFDone = false;
        zzEndRead = zzStartRead = 0;
        zzCurrentPos = zzMarkedPos = 0;
        yyline = yychar = yycolumn = 0;
        zzLexicalState = YYINITIAL;
    }


    /**
     * Returns the current lexical state.
     */
    public final int yystate() {
        return zzLexicalState;
    }


    /**
     * Enters a new lexical state
     *
     * @param newState the new lexical state
     */
    public final void yybegin(int newState) {
        zzLexicalState = newState;
    }


    /**
     * Returns the text matched by the current regular expression.
     */
    public final String yytext() {
        return new String( zzBuffer, zzStartRead, zzMarkedPos - zzStartRead );
    }


    /**
     * Returns the character at position <tt>pos</tt> from the
     * matched text.
     *
     * It is equivalent to yytext().charAt(pos), but faster
     *
     * @param pos the position of the character to fetch.
     *            A value from 0 to yylength()-1.
     *
     * @return the character at position pos
     */
    public final char yycharat(int pos) {
        return zzBuffer[zzStartRead + pos];
    }


    /**
     * Returns the length of the matched text region.
     */
    public final int yylength() {
        return zzMarkedPos - zzStartRead;
    }


    /**
     * Reports an error that occurred while scanning.
     *
     * In a wellformed scanner (no or only correct usage of
     * yypushback(int) and a match-all fallback rule) this method
     * will only be called with things that "Can't Possibly Happen".
     * If this method is called, something is seriously wrong
     * (e.g. a JFlex bug producing a faulty scanner etc.).
     *
     * Usual syntax/scanner level error handling should be done
     * in error fallback rules.
     *
     * @param   errorCode  the code of the errormessage to display
     */
    private void zzScanError(int errorCode) {
        String message;
        try {
            message = ZZ_ERROR_MSG[errorCode];
        } catch (ArrayIndexOutOfBoundsException e) {
            message = ZZ_ERROR_MSG[ZZ_UNKNOWN_ERROR];
        }

        throw new Error(message);
    }


    /**
     * Pushes the specified amount of characters back into the input stream.
     *
     * They will be read again by then next call of the scanning method
     *
     * @param number  the number of characters to be read again.
     *                This number must not be greater than yylength()!
     */
    public void yypushback(int number)  {
        if ( number > yylength() )
            zzScanError(ZZ_PUSHBACK_2BIG);

        zzMarkedPos -= number;
    }


    /**
     * Resumes scanning until the next regular expression is matched,
     * the end of input is encountered or an I/O-Error occurs.
     *
     * @return      the next token
     * @exception   java.io.IOException  if any I/O-Error occurs
     */
    public int yylex() throws java.io.IOException {
        int zzInput;
        int zzAction;

        // cached fields:
        int zzCurrentPosL;
        int zzMarkedPosL;
        int zzEndReadL = zzEndRead;
        char [] zzBufferL = zzBuffer;
        char [] zzCMapL = ZZ_CMAP;


        while (true) {
            zzMarkedPosL = zzMarkedPos;

            yychar += zzMarkedPosL - zzStartRead;

            zzAction = -1;

            zzCurrentPosL = zzCurrentPos = zzStartRead = zzMarkedPosL;

            zzState = ZZ_LEXSTATE[zzLexicalState];


            zzForAction: {
                while (true) {

                    if (zzCurrentPosL < zzEndReadL)
                        zzInput = zzBufferL[zzCurrentPosL++];
                    else if (zzAtEOF) {
                        zzInput = YYEOF;
                        break zzForAction;
                    } else {
                        // store back cached positions
                        zzCurrentPos  = zzCurrentPosL;
                        zzMarkedPos   = zzMarkedPosL;
                        boolean eof = zzRefill();
                        // get translated positions and possibly new buffer
                        zzCurrentPosL  = zzCurrentPos;
                        zzMarkedPosL   = zzMarkedPos;
                        zzBufferL      = zzBuffer;
                        zzEndReadL     = zzEndRead;
                        if (eof) {
                            zzInput = YYEOF;
                            break zzForAction;
                        } else {
                            zzInput = zzBufferL[zzCurrentPosL++];
                        }
                    }
                    zzInput = zzCMapL[zzInput];

                    boolean zzIsFinal = false;
                    boolean zzNoLookAhead = false;

                    zzForNext: {
                        switch (zzState) {
                            case 1:
                                switch (zzInput) {
                                    case 0:
                                    case 1:
                                    case 3:
                                        zzIsFinal = true;
                                        zzNoLookAhead = true;
                                        zzState = 7;
                                        break zzForNext;
                                    case 2:
                                        zzIsFinal = true;
                                        zzState = 8;
                                        break zzForNext;
                                    case 4:
                                        zzIsFinal = true;
                                        zzState = 9;
                                        break zzForNext;
                                    case 5:
                                        zzIsFinal = true;
                                        zzState = 10;
                                        break zzForNext;
                                    case 7:
                                    case 8:
                                        zzIsFinal = true;
                                        zzState = 12;
                                        break zzForNext;
                                    case 9:
                                        zzIsFinal = true;
                                        zzState = 13;
                                        break zzForNext;
                                    case 10:
                                        zzIsFinal = true;
                                        zzState = 14;
                                        break zzForNext;
                                    case 11:
                                        zzIsFinal = true;
                                        zzState = 15;
                                        break zzForNext;
                                    case 14:
                                        zzIsFinal = true;
                                        zzState = 16;
                                        break zzForNext;
                                    case 17:
                                        zzIsFinal = true;
                                        zzState = 17;
                                        break zzForNext;
                                    case 18:
                                        zzIsFinal = true;
                                        zzState = 18;
                                        break zzForNext;
                                    case 20:
                                        zzIsFinal = true;
                                        zzState = 19;
                                        break zzForNext;
                                    case 24:
                                        zzIsFinal = true;
                                        zzNoLookAhead = true;
                                        zzState = 20;
                                        break zzForNext;
                                    default:
                                        zzIsFinal = true;
                                        zzState = 11;
                                        break zzForNext;
                                }

                            case 2:
                                switch (zzInput) {
                                    case 0:
                                    case 2:
                                    case 3:
                                    case 5:
                                        zzIsFinal = true;
                                        zzNoLookAhead = true;
                                        zzState = 7;
                                        break zzForNext;
                                    case 8:
                                        zzIsFinal = true;
                                        zzState = 12;
                                        break zzForNext;
                                    case 9:
                                        zzIsFinal = true;
                                        zzNoLookAhead = true;
                                        zzState = 20;
                                        break zzForNext;
                                    case 1:
                                        zzIsFinal = true;
                                        zzState = 21;
                                        break zzForNext;
                                    case 7:
                                        zzIsFinal = true;
                                        zzNoLookAhead = true;
                                        zzState = 23;
                                        break zzForNext;
                                    case 11:
                                        zzIsFinal = true;
                                        zzState = 24;
                                        break zzForNext;
                                    case 13:
                                        zzIsFinal = true;
                                        zzState = 25;
                                        break zzForNext;
                                    case 17:
                                        zzIsFinal = true;
                                        zzState = 26;
                                        break zzForNext;
                                    case 20:
                                        zzIsFinal = true;
                                        zzState = 27;
                                        break zzForNext;
                                    case 21:
                                        zzIsFinal = true;
                                        zzState = 28;
                                        break zzForNext;
                                    case 23:
                                        zzIsFinal = true;
                                        zzState = 29;
                                        break zzForNext;
                                    case 24:
                                        zzIsFinal = true;
                                        zzNoLookAhead = true;
                                        zzState = 30;
                                        break zzForNext;
                                    case 25:
                                        zzIsFinal = true;
                                        zzState = 31;
                                        break zzForNext;
                                    default:
                                        zzIsFinal = true;
                                        zzState = 22;
                                        break zzForNext;
                                }

                            case 3:
                                switch (zzInput) {
                                    case 24:
                                        zzIsFinal = true;
                                        zzNoLookAhead = true;
                                        zzState = 20;
                                        break zzForNext;
                                    case 10:
                                        zzIsFinal = true;
                                        zzState = 32;
                                        break zzForNext;
                                    case 11:
                                        zzIsFinal = true;
                                        zzState = 33;
                                        break zzForNext;
                                    case 14:
                                        zzIsFinal = true;
                                        zzState = 34;
                                        break zzForNext;
                                    case 17:
                                        zzIsFinal = true;
                                        zzState = 35;
                                        break zzForNext;
                                    case 18:
                                        zzIsFinal = true;
                                        zzState = 36;
                                        break zzForNext;
                                    case 20:
                                        zzIsFinal = true;
                                        zzState = 37;
                                        break zzForNext;
                                    default:
                                        zzIsFinal = true;
                                        zzNoLookAhead = true;
                                        zzState = 30;
                                        break zzForNext;
                                }

                            case 4:
                                switch (zzInput) {
                                    case 9:
                                        zzIsFinal = true;
                                        zzNoLookAhead = true;
                                        zzState = 20;
                                        break zzForNext;
                                    case 0:
                                    case 1:
                                    case 2:
                                    case 3:
                                    case 5:
                                    case 7:
                                    case 8:
                                    case 24:
                                        zzIsFinal = true;
                                        zzNoLookAhead = true;
                                        zzState = 30;
                                        break zzForNext;
                                    case 23:
                                        zzIsFinal = true;
                                        zzState = 39;
                                        break zzForNext;
                                    case 25:
                                        zzIsFinal = true;
                                        zzState = 40;
                                        break zzForNext;
                                    default:
                                        zzIsFinal = true;
                                        zzState = 38;
                                        break zzForNext;
                                }

                            case 5:
                                switch (zzInput) {
                                    case 7:
                                        zzIsFinal = true;
                                        zzNoLookAhead = true;
                                        zzState = 41;
                                        break zzForNext;
                                    default:
                                        break zzForAction;
                                }

                            case 6:
                                switch (zzInput) {
                                    default:
                                        zzIsFinal = true;
                                        zzNoLookAhead = true;
                                        zzState = 42;
                                        break zzForNext;
                                }

                            case 8:
                                switch (zzInput) {
                                    case 2:
                                        zzState = 43;
                                        break zzForNext;
                                    default:
                                        break zzForAction;
                                }

                            case 9:
                                switch (zzInput) {
                                    case 7:
                                        zzIsFinal = true;
                                        zzNoLookAhead = true;
                                        zzState = 44;
                                        break zzForNext;
                                    case 17:
                                        zzState = 45;
                                        break zzForNext;
                                    default:
                                        break zzForAction;
                                }

                            case 10:
                                switch (zzInput) {
                                    case 0:
                                    case 1:
                                    case 2:
                                    case 3:
                                    case 5:
                                    case 7:
                                    case 8:
                                    case 9:
                                    case 24:
                                        break zzForAction;
                                    default:
                                        zzIsFinal = true;
                                        break zzForNext;
                                }

                            case 11:
                                switch (zzInput) {
                                    case 7:
                                        zzIsFinal = true;
                                        zzNoLookAhead = true;
                                        zzState = 44;
                                        break zzForNext;
                                    case 0:
                                    case 1:
                                    case 2:
                                    case 3:
                                    case 5:
                                    case 8:
                                    case 9:
                                    case 24:
                                        break zzForAction;
                                    default:
                                        zzIsFinal = true;
                                        zzState = 10;
                                        break zzForNext;
                                }

                            case 12:
                                switch (zzInput) {
                                    case 7:
                                    case 8:
                                        zzIsFinal = true;
                                        zzState = 47;
                                        break zzForNext;
                                    case 1:
                                    case 3:
                                        break zzForAction;
                                    default:
                                        zzState = 46;
                                        break zzForNext;
                                }

                            case 13:
                                switch (zzInput) {
                                    case 7:
                                        zzIsFinal = true;
                                        zzNoLookAhead = true;
                                        zzState = 44;
                                        break zzForNext;
                                    default:
                                        break zzForAction;
                                }

                            case 14:
                                switch (zzInput) {
                                    case 7:
                                        zzIsFinal = true;
                                        zzNoLookAhead = true;
                                        zzState = 44;
                                        break zzForNext;
                                    case 11:
                                        zzIsFinal = true;
                                        zzState = 48;
                                        break zzForNext;
                                    case 0:
                                    case 1:
                                    case 2:
                                    case 3:
                                    case 5:
                                    case 8:
                                    case 9:
                                    case 24:
                                        break zzForAction;
                                    default:
                                        zzIsFinal = true;
                                        zzState = 10;
                                        break zzForNext;
                                }

                            case 15:
                                switch (zzInput) {
                                    case 7:
                                        zzIsFinal = true;
                                        zzNoLookAhead = true;
                                        zzState = 44;
                                        break zzForNext;
                                    case 12:
                                        zzIsFinal = true;
                                        zzState = 49;
                                        break zzForNext;
                                    case 22:
                                        zzIsFinal = true;
                                        zzState = 50;
                                        break zzForNext;
                                    case 0:
                                    case 1:
                                    case 2:
                                    case 3:
                                    case 5:
                                    case 8:
                                    case 9:
                                    case 24:
                                        break zzForAction;
                                    default:
                                        zzIsFinal = true;
                                        zzState = 10;
                                        break zzForNext;
                                }

                            case 16:
                                switch (zzInput) {
                                    case 7:
                                        zzIsFinal = true;
                                        zzNoLookAhead = true;
                                        zzState = 44;
                                        break zzForNext;
                                    case 15:
                                        zzIsFinal = true;
                                        zzState = 51;
                                        break zzForNext;
                                    case 0:
                                    case 1:
                                    case 2:
                                    case 3:
                                    case 5:
                                    case 8:
                                    case 9:
                                    case 24:
                                        break zzForAction;
                                    default:
                                        zzIsFinal = true;
                                        zzState = 10;
                                        break zzForNext;
                                }

                            case 17:
                                switch (zzInput) {
                                    case 7:
                                        zzIsFinal = true;
                                        zzNoLookAhead = true;
                                        zzState = 44;
                                        break zzForNext;
                                    case 23:
                                        zzIsFinal = true;
                                        zzState = 52;
                                        break zzForNext;
                                    case 0:
                                    case 1:
                                    case 2:
                                    case 3:
                                    case 5:
                                    case 8:
                                    case 9:
                                    case 24:
                                        break zzForAction;
                                    default:
                                        zzIsFinal = true;
                                        zzState = 10;
                                        break zzForNext;
                                }

                            case 18:
                                switch (zzInput) {
                                    case 7:
                                        zzIsFinal = true;
                                        zzNoLookAhead = true;
                                        zzState = 44;
                                        break zzForNext;
                                    case 17:
                                        zzIsFinal = true;
                                        zzState = 53;
                                        break zzForNext;
                                    case 0:
                                    case 1:
                                    case 2:
                                    case 3:
                                    case 5:
                                    case 8:
                                    case 9:
                                    case 24:
                                        break zzForAction;
                                    default:
                                        zzIsFinal = true;
                                        zzState = 10;
                                        break zzForNext;
                                }

                            case 19:
                                switch (zzInput) {
                                    case 7:
                                        zzIsFinal = true;
                                        zzNoLookAhead = true;
                                        zzState = 44;
                                        break zzForNext;
                                    case 13:
                                        zzIsFinal = true;
                                        zzState = 54;
                                        break zzForNext;
                                    case 0:
                                    case 1:
                                    case 2:
                                    case 3:
                                    case 5:
                                    case 8:
                                    case 9:
                                    case 24:
                                        break zzForAction;
                                    default:
                                        zzIsFinal = true;
                                        zzState = 10;
                                        break zzForNext;
                                }

                            case 21:
                                switch (zzInput) {
                                    case 2:
                                        zzState = 56;
                                        break zzForNext;
                                    case 1:
                                    case 3:
                                        break zzForAction;
                                    default:
                                        zzState = 55;
                                        break zzForNext;
                                }

                            case 22:
                                switch (zzInput) {
                                    case 11:
                                        zzState = 57;
                                        break zzForNext;
                                    case 13:
                                        zzState = 58;
                                        break zzForNext;
                                    case 17:
                                        zzState = 59;
                                        break zzForNext;
                                    case 20:
                                        zzState = 60;
                                        break zzForNext;
                                    case 21:
                                        zzState = 61;
                                        break zzForNext;
                                    case 23:
                                        zzState = 62;
                                        break zzForNext;
                                    case 25:
                                        zzState = 63;
                                        break zzForNext;
                                    default:
                                        break zzForAction;
                                }

                            case 24:
                                switch (zzInput) {
                                    case 11:
                                        zzState = 57;
                                        break zzForNext;
                                    case 13:
                                        zzState = 58;
                                        break zzForNext;
                                    case 17:
                                        zzState = 59;
                                        break zzForNext;
                                    case 20:
                                        zzState = 60;
                                        break zzForNext;
                                    case 21:
                                        zzState = 61;
                                        break zzForNext;
                                    case 23:
                                        zzState = 62;
                                        break zzForNext;
                                    case 25:
                                        zzState = 63;
                                        break zzForNext;
                                    case 10:
                                        zzIsFinal = true;
                                        zzState = 64;
                                        break zzForNext;
                                    default:
                                        break zzForAction;
                                }

                            case 25:
                                switch (zzInput) {
                                    case 11:
                                        zzState = 57;
                                        break zzForNext;
                                    case 13:
                                        zzState = 58;
                                        break zzForNext;
                                    case 17:
                                        zzState = 59;
                                        break zzForNext;
                                    case 20:
                                        zzState = 60;
                                        break zzForNext;
                                    case 21:
                                        zzState = 61;
                                        break zzForNext;
                                    case 23:
                                        zzState = 62;
                                        break zzForNext;
                                    case 25:
                                        zzState = 63;
                                        break zzForNext;
                                    case 12:
                                        zzState = 65;
                                        break zzForNext;
                                    default:
                                        break zzForAction;
                                }

                            case 26:
                                switch (zzInput) {
                                    case 11:
                                        zzState = 57;
                                        break zzForNext;
                                    case 13:
                                        zzState = 58;
                                        break zzForNext;
                                    case 17:
                                        zzState = 59;
                                        break zzForNext;
                                    case 20:
                                        zzState = 60;
                                        break zzForNext;
                                    case 21:
                                        zzState = 61;
                                        break zzForNext;
                                    case 23:
                                        zzState = 62;
                                        break zzForNext;
                                    case 25:
                                        zzState = 63;
                                        break zzForNext;
                                    case 16:
                                        zzState = 66;
                                        break zzForNext;
                                    default:
                                        break zzForAction;
                                }

                            case 27:
                                switch (zzInput) {
                                    case 11:
                                        zzState = 57;
                                        break zzForNext;
                                    case 13:
                                        zzState = 58;
                                        break zzForNext;
                                    case 17:
                                        zzState = 59;
                                        break zzForNext;
                                    case 20:
                                        zzState = 60;
                                        break zzForNext;
                                    case 21:
                                        zzState = 61;
                                        break zzForNext;
                                    case 23:
                                        zzState = 62;
                                        break zzForNext;
                                    case 25:
                                        zzState = 63;
                                        break zzForNext;
                                    case 19:
                                        zzState = 67;
                                        break zzForNext;
                                    default:
                                        break zzForAction;
                                }

                            case 28:
                                switch (zzInput) {
                                    case 11:
                                        zzState = 57;
                                        break zzForNext;
                                    case 17:
                                        zzState = 59;
                                        break zzForNext;
                                    case 20:
                                        zzState = 60;
                                        break zzForNext;
                                    case 21:
                                        zzState = 61;
                                        break zzForNext;
                                    case 23:
                                        zzState = 62;
                                        break zzForNext;
                                    case 25:
                                        zzState = 63;
                                        break zzForNext;
                                    case 13:
                                        zzState = 68;
                                        break zzForNext;
                                    default:
                                        break zzForAction;
                                }

                            case 29:
                                switch (zzInput) {
                                    case 11:
                                        zzState = 57;
                                        break zzForNext;
                                    case 13:
                                        zzState = 58;
                                        break zzForNext;
                                    case 17:
                                        zzState = 59;
                                        break zzForNext;
                                    case 20:
                                        zzState = 60;
                                        break zzForNext;
                                    case 21:
                                        zzState = 61;
                                        break zzForNext;
                                    case 23:
                                        zzState = 62;
                                        break zzForNext;
                                    case 25:
                                        zzState = 63;
                                        break zzForNext;
                                    case 12:
                                        zzState = 69;
                                        break zzForNext;
                                    default:
                                        break zzForAction;
                                }

                            case 31:
                                switch (zzInput) {
                                    case 11:
                                        zzState = 57;
                                        break zzForNext;
                                    case 13:
                                        zzState = 58;
                                        break zzForNext;
                                    case 17:
                                        zzState = 59;
                                        break zzForNext;
                                    case 20:
                                        zzState = 60;
                                        break zzForNext;
                                    case 21:
                                        zzState = 61;
                                        break zzForNext;
                                    case 25:
                                        zzState = 63;
                                        break zzForNext;
                                    case 23:
                                        zzState = 70;
                                        break zzForNext;
                                    default:
                                        break zzForAction;
                                }

                            case 32:
                                switch (zzInput) {
                                    case 11:
                                        zzIsFinal = true;
                                        zzState = 71;
                                        break zzForNext;
                                    default:
                                        break zzForAction;
                                }

                            case 33:
                                switch (zzInput) {
                                    case 12:
                                        zzState = 72;
                                        break zzForNext;
                                    case 22:
                                        zzState = 73;
                                        break zzForNext;
                                    default:
                                        break zzForAction;
                                }

                            case 34:
                                switch (zzInput) {
                                    case 15:
                                        zzState = 74;
                                        break zzForNext;
                                    default:
                                        break zzForAction;
                                }

                            case 35:
                                switch (zzInput) {
                                    case 16:
                                        zzState = 75;
                                        break zzForNext;
                                    default:
                                        break zzForAction;
                                }

                            case 36:
                                switch (zzInput) {
                                    case 17:
                                        zzState = 76;
                                        break zzForNext;
                                    default:
                                        break zzForAction;
                                }

                            case 37:
                                switch (zzInput) {
                                    case 13:
                                        zzState = 77;
                                        break zzForNext;
                                    default:
                                        break zzForAction;
                                }

                            case 38:
                                switch (zzInput) {
                                    case 23:
                                        zzState = 78;
                                        break zzForNext;
                                    case 25:
                                        zzState = 79;
                                        break zzForNext;
                                    default:
                                        break zzForAction;
                                }

                            case 39:
                                switch (zzInput) {
                                    case 23:
                                        zzState = 78;
                                        break zzForNext;
                                    case 25:
                                        zzState = 79;
                                        break zzForNext;
                                    case 12:
                                        zzState = 80;
                                        break zzForNext;
                                    default:
                                        break zzForAction;
                                }

                            case 40:
                                switch (zzInput) {
                                    case 25:
                                        zzState = 79;
                                        break zzForNext;
                                    case 23:
                                        zzState = 81;
                                        break zzForNext;
                                    default:
                                        break zzForAction;
                                }

                            case 43:
                                switch (zzInput) {
                                    case 1:
                                        zzIsFinal = true;
                                        zzNoLookAhead = true;
                                        zzState = 7;
                                        break zzForNext;
                                    default:
                                        break zzForNext;
                                }

                            case 45:
                                switch (zzInput) {
                                    case 23:
                                        zzState = 82;
                                        break zzForNext;
                                    default:
                                        break zzForAction;
                                }

                            case 46:
                                switch (zzInput) {
                                    case 7:
                                    case 8:
                                        zzIsFinal = true;
                                        zzState = 47;
                                        break zzForNext;
                                    case 1:
                                    case 3:
                                        break zzForAction;
                                    default:
                                        break zzForNext;
                                }

                            case 47:
                                switch (zzInput) {
                                    case 7:
                                    case 8:
                                        zzState = 46;
                                        break zzForNext;
                                    default:
                                        break zzForAction;
                                }

                            case 48:
                                switch (zzInput) {
                                    case 0:
                                    case 1:
                                    case 2:
                                    case 3:
                                    case 5:
                                    case 7:
                                    case 8:
                                    case 9:
                                    case 24:
                                        break zzForAction;
                                    default:
                                        zzIsFinal = true;
                                        zzState = 10;
                                        break zzForNext;
                                }

                            case 49:
                                switch (zzInput) {
                                    case 13:
                                        zzIsFinal = true;
                                        zzState = 48;
                                        break zzForNext;
                                    case 0:
                                    case 1:
                                    case 2:
                                    case 3:
                                    case 5:
                                    case 7:
                                    case 8:
                                    case 9:
                                    case 24:
                                        break zzForAction;
                                    default:
                                        zzIsFinal = true;
                                        zzState = 10;
                                        break zzForNext;
                                }

                            case 50:
                                switch (zzInput) {
                                    case 23:
                                        zzIsFinal = true;
                                        zzState = 83;
                                        break zzForNext;
                                    case 0:
                                    case 1:
                                    case 2:
                                    case 3:
                                    case 5:
                                    case 7:
                                    case 8:
                                    case 9:
                                    case 24:
                                        break zzForAction;
                                    default:
                                        zzIsFinal = true;
                                        zzState = 10;
                                        break zzForNext;
                                }

                            case 51:
                                switch (zzInput) {
                                    case 10:
                                        zzIsFinal = true;
                                        zzState = 84;
                                        break zzForNext;
                                    case 0:
                                    case 1:
                                    case 2:
                                    case 3:
                                    case 5:
                                    case 7:
                                    case 8:
                                    case 9:
                                    case 24:
                                        break zzForAction;
                                    default:
                                        zzIsFinal = true;
                                        zzState = 10;
                                        break zzForNext;
                                }

                            case 52:
                                switch (zzInput) {
                                    case 25:
                                        zzIsFinal = true;
                                        zzState = 85;
                                        break zzForNext;
                                    case 0:
                                    case 1:
                                    case 2:
                                    case 3:
                                    case 5:
                                    case 7:
                                    case 8:
                                    case 9:
                                    case 24:
                                        break zzForAction;
                                    default:
                                        zzIsFinal = true;
                                        zzState = 10;
                                        break zzForNext;
                                }

                            case 53:
                                switch (zzInput) {
                                    case 16:
                                        zzIsFinal = true;
                                        zzState = 86;
                                        break zzForNext;
                                    case 0:
                                    case 1:
                                    case 2:
                                    case 3:
                                    case 5:
                                    case 7:
                                    case 8:
                                    case 9:
                                    case 24:
                                        break zzForAction;
                                    default:
                                        zzIsFinal = true;
                                        zzState = 10;
                                        break zzForNext;
                                }

                            case 54:
                                switch (zzInput) {
                                    case 21:
                                        zzIsFinal = true;
                                        zzState = 48;
                                        break zzForNext;
                                    case 0:
                                    case 1:
                                    case 2:
                                    case 3:
                                    case 5:
                                    case 7:
                                    case 8:
                                    case 9:
                                    case 24:
                                        break zzForAction;
                                    default:
                                        zzIsFinal = true;
                                        zzState = 10;
                                        break zzForNext;
                                }

                            case 55:
                                switch (zzInput) {
                                    case 2:
                                        zzState = 56;
                                        break zzForNext;
                                    case 1:
                                    case 3:
                                        break zzForAction;
                                    default:
                                        break zzForNext;
                                }

                            case 56:
                                switch (zzInput) {
                                    case 2:
                                        zzIsFinal = true;
                                        zzState = 87;
                                        break zzForNext;
                                    case 1:
                                    case 3:
                                        break zzForAction;
                                    default:
                                        zzState = 55;
                                        break zzForNext;
                                }

                            case 57:
                                switch (zzInput) {
                                    case 10:
                                        zzIsFinal = true;
                                        zzNoLookAhead = true;
                                        zzState = 7;
                                        break zzForNext;
                                    default:
                                        break zzForAction;
                                }

                            case 58:
                                switch (zzInput) {
                                    case 12:
                                        zzState = 88;
                                        break zzForNext;
                                    default:
                                        break zzForAction;
                                }

                            case 59:
                                switch (zzInput) {
                                    case 16:
                                        zzState = 89;
                                        break zzForNext;
                                    default:
                                        break zzForAction;
                                }

                            case 60:
                                switch (zzInput) {
                                    case 19:
                                        zzState = 90;
                                        break zzForNext;
                                    default:
                                        break zzForAction;
                                }

                            case 61:
                                switch (zzInput) {
                                    case 13:
                                        zzState = 91;
                                        break zzForNext;
                                    default:
                                        break zzForAction;
                                }

                            case 62:
                                switch (zzInput) {
                                    case 12:
                                        zzState = 92;
                                        break zzForNext;
                                    default:
                                        break zzForAction;
                                }

                            case 63:
                                switch (zzInput) {
                                    case 23:
                                        zzState = 93;
                                        break zzForNext;
                                    default:
                                        break zzForAction;
                                }

                            case 64:
                                switch (zzInput) {
                                    case 17:
                                        zzIsFinal = true;
                                        zzState = 94;
                                        break zzForNext;
                                    case 0:
                                    case 1:
                                    case 2:
                                    case 3:
                                    case 5:
                                    case 7:
                                    case 8:
                                    case 9:
                                    case 24:
                                        break zzForAction;
                                    default:
                                        zzIsFinal = true;
                                        zzNoLookAhead = true;
                                        zzState = 7;
                                        break zzForNext;
                                }

                            case 65:
                                switch (zzInput) {
                                    case 11:
                                        zzIsFinal = true;
                                        zzState = 95;
                                        break zzForNext;
                                    default:
                                        break zzForAction;
                                }

                            case 66:
                                switch (zzInput) {
                                    case 10:
                                        zzState = 96;
                                        break zzForNext;
                                    default:
                                        break zzForAction;
                                }

                            case 67:
                                switch (zzInput) {
                                    case 17:
                                        zzState = 97;
                                        break zzForNext;
                                    default:
                                        break zzForAction;
                                }

                            case 68:
                                switch (zzInput) {
                                    case 12:
                                        zzState = 88;
                                        break zzForNext;
                                    case 20:
                                        zzIsFinal = true;
                                        zzState = 95;
                                        break zzForNext;
                                    default:
                                        break zzForAction;
                                }

                            case 69:
                                switch (zzInput) {
                                    case 10:
                                        zzState = 98;
                                        break zzForNext;
                                    default:
                                        break zzForAction;
                                }

                            case 70:
                                switch (zzInput) {
                                    case 17:
                                        zzIsFinal = true;
                                        zzNoLookAhead = true;
                                        zzState = 20;
                                        break zzForNext;
                                    case 12:
                                        zzState = 92;
                                        break zzForNext;
                                    default:
                                        break zzForAction;
                                }

                            case 71:
                                switch (zzInput) {
                                    case 0:
                                    case 1:
                                    case 2:
                                    case 3:
                                    case 5:
                                    case 7:
                                    case 8:
                                    case 9:
                                    case 24:
                                        break zzForAction;
                                    default:
                                        zzIsFinal = true;
                                        zzState = 99;
                                        break zzForNext;
                                }

                            case 72:
                                switch (zzInput) {
                                    case 13:
                                        zzIsFinal = true;
                                        zzState = 71;
                                        break zzForNext;
                                    default:
                                        break zzForAction;
                                }

                            case 73:
                                switch (zzInput) {
                                    case 23:
                                        zzState = 100;
                                        break zzForNext;
                                    default:
                                        break zzForAction;
                                }

                            case 74:
                                switch (zzInput) {
                                    case 10:
                                        zzState = 101;
                                        break zzForNext;
                                    default:
                                        break zzForAction;
                                }

                            case 75:
                                switch (zzInput) {
                                    case 18:
                                        zzState = 102;
                                        break zzForNext;
                                    default:
                                        break zzForAction;
                                }

                            case 76:
                                switch (zzInput) {
                                    case 16:
                                        zzState = 103;
                                        break zzForNext;
                                    default:
                                        break zzForAction;
                                }

                            case 77:
                                switch (zzInput) {
                                    case 21:
                                        zzIsFinal = true;
                                        zzState = 71;
                                        break zzForNext;
                                    default:
                                        break zzForAction;
                                }

                            case 78:
                                switch (zzInput) {
                                    case 12:
                                        zzState = 104;
                                        break zzForNext;
                                    default:
                                        break zzForAction;
                                }

                            case 79:
                                switch (zzInput) {
                                    case 23:
                                        zzState = 105;
                                        break zzForNext;
                                    default:
                                        break zzForAction;
                                }

                            case 80:
                                switch (zzInput) {
                                    case 10:
                                        zzState = 106;
                                        break zzForNext;
                                    default:
                                        break zzForAction;
                                }

                            case 81:
                                switch (zzInput) {
                                    case 17:
                                        zzIsFinal = true;
                                        zzNoLookAhead = true;
                                        zzState = 20;
                                        break zzForNext;
                                    case 12:
                                        zzState = 104;
                                        break zzForNext;
                                    default:
                                        break zzForAction;
                                }

                            case 82:
                                switch (zzInput) {
                                    case 25:
                                        zzIsFinal = true;
                                        zzState = 107;
                                        break zzForNext;
                                    default:
                                        break zzForAction;
                                }

                            case 83:
                                switch (zzInput) {
                                    case 19:
                                        zzIsFinal = true;
                                        zzState = 108;
                                        break zzForNext;
                                    case 0:
                                    case 1:
                                    case 2:
                                    case 3:
                                    case 5:
                                    case 7:
                                    case 8:
                                    case 9:
                                    case 24:
                                        break zzForAction;
                                    default:
                                        zzIsFinal = true;
                                        zzState = 10;
                                        break zzForNext;
                                }

                            case 84:
                                switch (zzInput) {
                                    case 16:
                                        zzIsFinal = true;
                                        zzState = 109;
                                        break zzForNext;
                                    case 0:
                                    case 1:
                                    case 2:
                                    case 3:
                                    case 5:
                                    case 7:
                                    case 8:
                                    case 9:
                                    case 24:
                                        break zzForAction;
                                    default:
                                        zzIsFinal = true;
                                        zzState = 10;
                                        break zzForNext;
                                }

                            case 85:
                                switch (zzInput) {
                                    case 11:
                                        zzIsFinal = true;
                                        zzState = 110;
                                        break zzForNext;
                                    case 0:
                                    case 1:
                                    case 2:
                                    case 3:
                                    case 5:
                                    case 7:
                                    case 8:
                                    case 9:
                                    case 24:
                                        break zzForAction;
                                    default:
                                        zzIsFinal = true;
                                        zzState = 10;
                                        break zzForNext;
                                }

                            case 86:
                                switch (zzInput) {
                                    case 17:
                                        zzIsFinal = true;
                                        zzState = 111;
                                        break zzForNext;
                                    case 0:
                                    case 1:
                                    case 2:
                                    case 3:
                                    case 5:
                                    case 7:
                                    case 8:
                                    case 9:
                                    case 24:
                                        break zzForAction;
                                    default:
                                        zzIsFinal = true;
                                        zzState = 10;
                                        break zzForNext;
                                }

                            case 87:
                                switch (zzInput) {
                                    case 2:
                                        zzIsFinal = true;
                                        break zzForNext;
                                    case 1:
                                    case 3:
                                        break zzForAction;
                                    default:
                                        zzState = 55;
                                        break zzForNext;
                                }

                            case 88:
                                switch (zzInput) {
                                    case 11:
                                        zzIsFinal = true;
                                        zzNoLookAhead = true;
                                        zzState = 7;
                                        break zzForNext;
                                    default:
                                        break zzForAction;
                                }

                            case 89:
                                switch (zzInput) {
                                    case 10:
                                        zzState = 112;
                                        break zzForNext;
                                    default:
                                        break zzForAction;
                                }

                            case 90:
                                switch (zzInput) {
                                    case 17:
                                        zzState = 113;
                                        break zzForNext;
                                    default:
                                        break zzForAction;
                                }

                            case 91:
                                switch (zzInput) {
                                    case 20:
                                        zzIsFinal = true;
                                        zzNoLookAhead = true;
                                        zzState = 7;
                                        break zzForNext;
                                    default:
                                        break zzForAction;
                                }

                            case 92:
                                switch (zzInput) {
                                    case 10:
                                        zzState = 114;
                                        break zzForNext;
                                    default:
                                        break zzForAction;
                                }

                            case 93:
                                switch (zzInput) {
                                    case 17:
                                        zzIsFinal = true;
                                        zzNoLookAhead = true;
                                        zzState = 7;
                                        break zzForNext;
                                    default:
                                        break zzForAction;
                                }

                            case 94:
                                switch (zzInput) {
                                    case 18:
                                        zzState = 115;
                                        break zzForNext;
                                    default:
                                        break zzForAction;
                                }

                            case 95:
                                switch (zzInput) {
                                    case 0:
                                    case 1:
                                    case 2:
                                    case 3:
                                    case 5:
                                    case 7:
                                    case 8:
                                    case 9:
                                    case 24:
                                        break zzForAction;
                                    default:
                                        zzIsFinal = true;
                                        zzNoLookAhead = true;
                                        zzState = 7;
                                        break zzForNext;
                                }

                            case 96:
                                switch (zzInput) {
                                    case 15:
                                        zzState = 116;
                                        break zzForNext;
                                    default:
                                        break zzForAction;
                                }

                            case 97:
                                switch (zzInput) {
                                    case 16:
                                        zzState = 117;
                                        break zzForNext;
                                    default:
                                        break zzForAction;
                                }

                            case 98:
                                switch (zzInput) {
                                    case 20:
                                        zzState = 118;
                                        break zzForNext;
                                    default:
                                        break zzForAction;
                                }

                            case 99:
                                switch (zzInput) {
                                    case 0:
                                    case 1:
                                    case 2:
                                    case 3:
                                    case 5:
                                    case 7:
                                    case 8:
                                    case 9:
                                    case 24:
                                        break zzForAction;
                                    default:
                                        zzIsFinal = true;
                                        break zzForNext;
                                }

                            case 100:
                                switch (zzInput) {
                                    case 19:
                                        zzState = 119;
                                        break zzForNext;
                                    default:
                                        break zzForAction;
                                }

                            case 101:
                                switch (zzInput) {
                                    case 16:
                                        zzState = 120;
                                        break zzForNext;
                                    default:
                                        break zzForAction;
                                }

                            case 102:
                                switch (zzInput) {
                                    case 17:
                                        zzIsFinal = true;
                                        zzState = 121;
                                        break zzForNext;
                                    default:
                                        break zzForAction;
                                }

                            case 103:
                                switch (zzInput) {
                                    case 17:
                                        zzState = 122;
                                        break zzForNext;
                                    default:
                                        break zzForAction;
                                }

                            case 104:
                                switch (zzInput) {
                                    case 10:
                                        zzState = 123;
                                        break zzForNext;
                                    default:
                                        break zzForAction;
                                }

                            case 105:
                                switch (zzInput) {
                                    case 17:
                                        zzIsFinal = true;
                                        zzNoLookAhead = true;
                                        zzState = 30;
                                        break zzForNext;
                                    default:
                                        break zzForAction;
                                }

                            case 106:
                                switch (zzInput) {
                                    case 20:
                                        zzState = 124;
                                        break zzForNext;
                                    default:
                                        break zzForAction;
                                }

                            case 107:
                                switch (zzInput) {
                                    case 11:
                                        zzState = 125;
                                        break zzForNext;
                                    default:
                                        break zzForAction;
                                }

                            case 108:
                                switch (zzInput) {
                                    case 20:
                                        zzIsFinal = true;
                                        zzState = 126;
                                        break zzForNext;
                                    case 0:
                                    case 1:
                                    case 2:
                                    case 3:
                                    case 5:
                                    case 7:
                                    case 8:
                                    case 9:
                                    case 24:
                                        break zzForAction;
                                    default:
                                        zzIsFinal = true;
                                        zzState = 10;
                                        break zzForNext;
                                }

                            case 109:
                                switch (zzInput) {
                                    case 17:
                                        zzIsFinal = true;
                                        zzState = 48;
                                        break zzForNext;
                                    case 0:
                                    case 1:
                                    case 2:
                                    case 3:
                                    case 5:
                                    case 7:
                                    case 8:
                                    case 9:
                                    case 24:
                                        break zzForAction;
                                    default:
                                        zzIsFinal = true;
                                        zzState = 10;
                                        break zzForNext;
                                }

                            case 110:
                                switch (zzInput) {
                                    case 22:
                                        zzIsFinal = true;
                                        zzState = 127;
                                        break zzForNext;
                                    case 0:
                                    case 1:
                                    case 2:
                                    case 3:
                                    case 5:
                                    case 7:
                                    case 8:
                                    case 9:
                                    case 24:
                                        break zzForAction;
                                    default:
                                        zzIsFinal = true;
                                        zzState = 10;
                                        break zzForNext;
                                }

                            case 111:
                                switch (zzInput) {
                                    case 19:
                                        zzIsFinal = true;
                                        zzState = 128;
                                        break zzForNext;
                                    case 0:
                                    case 1:
                                    case 2:
                                    case 3:
                                    case 5:
                                    case 7:
                                    case 8:
                                    case 9:
                                    case 24:
                                        break zzForAction;
                                    default:
                                        zzIsFinal = true;
                                        zzState = 10;
                                        break zzForNext;
                                }

                            case 112:
                                switch (zzInput) {
                                    case 15:
                                        zzState = 129;
                                        break zzForNext;
                                    default:
                                        break zzForAction;
                                }

                            case 113:
                                switch (zzInput) {
                                    case 16:
                                        zzState = 130;
                                        break zzForNext;
                                    default:
                                        break zzForAction;
                                }

                            case 114:
                                switch (zzInput) {
                                    case 20:
                                        zzState = 131;
                                        break zzForNext;
                                    default:
                                        break zzForAction;
                                }

                            case 115:
                                switch (zzInput) {
                                    case 16:
                                        zzState = 93;
                                        break zzForNext;
                                    default:
                                        break zzForAction;
                                }

                            case 116:
                                switch (zzInput) {
                                    case 14:
                                        zzIsFinal = true;
                                        zzState = 95;
                                        break zzForNext;
                                    default:
                                        break zzForAction;
                                }

                            case 117:
                                switch (zzInput) {
                                    case 17:
                                        zzState = 132;
                                        break zzForNext;
                                    default:
                                        break zzForAction;
                                }

                            case 118:
                                switch (zzInput) {
                                    case 19:
                                        zzState = 133;
                                        break zzForNext;
                                    default:
                                        break zzForAction;
                                }

                            case 119:
                                switch (zzInput) {
                                    case 20:
                                        zzState = 134;
                                        break zzForNext;
                                    default:
                                        break zzForAction;
                                }

                            case 120:
                                switch (zzInput) {
                                    case 17:
                                        zzIsFinal = true;
                                        zzState = 71;
                                        break zzForNext;
                                    default:
                                        break zzForAction;
                                }

                            case 121:
                                switch (zzInput) {
                                    case 10:
                                        zzState = 135;
                                        break zzForNext;
                                    default:
                                        break zzForAction;
                                }

                            case 122:
                                switch (zzInput) {
                                    case 19:
                                        zzState = 136;
                                        break zzForNext;
                                    default:
                                        break zzForAction;
                                }

                            case 123:
                                switch (zzInput) {
                                    case 20:
                                        zzState = 137;
                                        break zzForNext;
                                    default:
                                        break zzForAction;
                                }

                            case 124:
                                switch (zzInput) {
                                    case 19:
                                        zzState = 138;
                                        break zzForNext;
                                    default:
                                        break zzForAction;
                                }

                            case 125:
                                switch (zzInput) {
                                    case 22:
                                        zzState = 139;
                                        break zzForNext;
                                    default:
                                        break zzForAction;
                                }

                            case 126:
                                switch (zzInput) {
                                    case 10:
                                        zzIsFinal = true;
                                        zzState = 140;
                                        break zzForNext;
                                    case 0:
                                    case 1:
                                    case 2:
                                    case 3:
                                    case 5:
                                    case 7:
                                    case 8:
                                    case 9:
                                    case 24:
                                        break zzForAction;
                                    default:
                                        zzIsFinal = true;
                                        zzState = 10;
                                        break zzForNext;
                                }

                            case 127:
                                switch (zzInput) {
                                    case 23:
                                        zzIsFinal = true;
                                        zzState = 141;
                                        break zzForNext;
                                    case 0:
                                    case 1:
                                    case 2:
                                    case 3:
                                    case 5:
                                    case 7:
                                    case 8:
                                    case 9:
                                    case 24:
                                        break zzForAction;
                                    default:
                                        zzIsFinal = true;
                                        zzState = 10;
                                        break zzForNext;
                                }

                            case 128:
                                switch (zzInput) {
                                    case 20:
                                        zzIsFinal = true;
                                        zzState = 48;
                                        break zzForNext;
                                    case 0:
                                    case 1:
                                    case 2:
                                    case 3:
                                    case 5:
                                    case 7:
                                    case 8:
                                    case 9:
                                    case 24:
                                        break zzForAction;
                                    default:
                                        zzIsFinal = true;
                                        zzState = 10;
                                        break zzForNext;
                                }

                            case 129:
                                switch (zzInput) {
                                    case 14:
                                        zzIsFinal = true;
                                        zzNoLookAhead = true;
                                        zzState = 7;
                                        break zzForNext;
                                    default:
                                        break zzForAction;
                                }

                            case 130:
                                switch (zzInput) {
                                    case 17:
                                        zzState = 142;
                                        break zzForNext;
                                    default:
                                        break zzForAction;
                                }

                            case 131:
                                switch (zzInput) {
                                    case 19:
                                        zzState = 143;
                                        break zzForNext;
                                    default:
                                        break zzForAction;
                                }

                            case 132:
                                switch (zzInput) {
                                    case 18:
                                        zzIsFinal = true;
                                        zzState = 95;
                                        break zzForNext;
                                    default:
                                        break zzForAction;
                                }

                            case 133:
                                switch (zzInput) {
                                    case 23:
                                        zzState = 144;
                                        break zzForNext;
                                    default:
                                        break zzForAction;
                                }

                            case 134:
                                switch (zzInput) {
                                    case 10:
                                        zzState = 145;
                                        break zzForNext;
                                    default:
                                        break zzForAction;
                                }

                            case 135:
                                switch (zzInput) {
                                    case 11:
                                        zzIsFinal = true;
                                        zzNoLookAhead = true;
                                        zzState = 20;
                                        break zzForNext;
                                    default:
                                        break zzForAction;
                                }

                            case 136:
                                switch (zzInput) {
                                    case 20:
                                        zzIsFinal = true;
                                        zzState = 71;
                                        break zzForNext;
                                    default:
                                        break zzForAction;
                                }

                            case 137:
                                switch (zzInput) {
                                    case 19:
                                        zzState = 146;
                                        break zzForNext;
                                    default:
                                        break zzForAction;
                                }

                            case 138:
                                switch (zzInput) {
                                    case 23:
                                        zzState = 147;
                                        break zzForNext;
                                    default:
                                        break zzForAction;
                                }

                            case 139:
                                switch (zzInput) {
                                    case 23:
                                        zzState = 148;
                                        break zzForNext;
                                    default:
                                        break zzForAction;
                                }

                            case 140:
                                switch (zzInput) {
                                    case 12:
                                        zzIsFinal = true;
                                        zzState = 149;
                                        break zzForNext;
                                    case 0:
                                    case 1:
                                    case 2:
                                    case 3:
                                    case 5:
                                    case 7:
                                    case 8:
                                    case 9:
                                    case 24:
                                        break zzForAction;
                                    default:
                                        zzIsFinal = true;
                                        zzState = 10;
                                        break zzForNext;
                                }

                            case 141:
                                switch (zzInput) {
                                    case 19:
                                        zzIsFinal = true;
                                        zzState = 150;
                                        break zzForNext;
                                    case 0:
                                    case 1:
                                    case 2:
                                    case 3:
                                    case 5:
                                    case 7:
                                    case 8:
                                    case 9:
                                    case 24:
                                        break zzForAction;
                                    default:
                                        zzIsFinal = true;
                                        zzState = 10;
                                        break zzForNext;
                                }

                            case 142:
                                switch (zzInput) {
                                    case 18:
                                        zzIsFinal = true;
                                        zzNoLookAhead = true;
                                        zzState = 7;
                                        break zzForNext;
                                    default:
                                        break zzForAction;
                                }

                            case 143:
                                switch (zzInput) {
                                    case 23:
                                        zzState = 151;
                                        break zzForNext;
                                    default:
                                        break zzForAction;
                                }

                            case 144:
                                switch (zzInput) {
                                    case 22:
                                        zzState = 152;
                                        break zzForNext;
                                    default:
                                        break zzForAction;
                                }

                            case 145:
                                switch (zzInput) {
                                    case 12:
                                        zzState = 153;
                                        break zzForNext;
                                    default:
                                        break zzForAction;
                                }

                            case 146:
                                switch (zzInput) {
                                    case 23:
                                        zzState = 154;
                                        break zzForNext;
                                    default:
                                        break zzForAction;
                                }

                            case 147:
                                switch (zzInput) {
                                    case 22:
                                        zzState = 155;
                                        break zzForNext;
                                    default:
                                        break zzForAction;
                                }

                            case 148:
                                switch (zzInput) {
                                    case 19:
                                        zzState = 156;
                                        break zzForNext;
                                    default:
                                        break zzForAction;
                                }

                            case 149:
                                switch (zzInput) {
                                    case 23:
                                        zzIsFinal = true;
                                        zzState = 48;
                                        break zzForNext;
                                    case 0:
                                    case 1:
                                    case 2:
                                    case 3:
                                    case 5:
                                    case 7:
                                    case 8:
                                    case 9:
                                    case 24:
                                        break zzForAction;
                                    default:
                                        zzIsFinal = true;
                                        zzState = 10;
                                        break zzForNext;
                                }

                            case 150:
                                switch (zzInput) {
                                    case 20:
                                        zzIsFinal = true;
                                        zzState = 157;
                                        break zzForNext;
                                    case 0:
                                    case 1:
                                    case 2:
                                    case 3:
                                    case 5:
                                    case 7:
                                    case 8:
                                    case 9:
                                    case 24:
                                        break zzForAction;
                                    default:
                                        zzIsFinal = true;
                                        zzState = 10;
                                        break zzForNext;
                                }

                            case 151:
                                switch (zzInput) {
                                    case 22:
                                        zzState = 158;
                                        break zzForNext;
                                    default:
                                        break zzForAction;
                                }

                            case 152:
                                switch (zzInput) {
                                    case 11:
                                        zzIsFinal = true;
                                        zzState = 159;
                                        break zzForNext;
                                    default:
                                        break zzForAction;
                                }

                            case 153:
                                switch (zzInput) {
                                    case 23:
                                        zzIsFinal = true;
                                        zzState = 71;
                                        break zzForNext;
                                    default:
                                        break zzForAction;
                                }

                            case 154:
                                switch (zzInput) {
                                    case 22:
                                        zzState = 160;
                                        break zzForNext;
                                    default:
                                        break zzForAction;
                                }

                            case 155:
                                switch (zzInput) {
                                    case 11:
                                        zzState = 161;
                                        break zzForNext;
                                    default:
                                        break zzForAction;
                                }

                            case 156:
                                switch (zzInput) {
                                    case 20:
                                        zzState = 162;
                                        break zzForNext;
                                    default:
                                        break zzForAction;
                                }

                            case 157:
                                switch (zzInput) {
                                    case 10:
                                        zzIsFinal = true;
                                        zzState = 163;
                                        break zzForNext;
                                    case 0:
                                    case 1:
                                    case 2:
                                    case 3:
                                    case 5:
                                    case 7:
                                    case 8:
                                    case 9:
                                    case 24:
                                        break zzForAction;
                                    default:
                                        zzIsFinal = true;
                                        zzState = 10;
                                        break zzForNext;
                                }

                            case 158:
                                switch (zzInput) {
                                    case 11:
                                        zzIsFinal = true;
                                        zzState = 164;
                                        break zzForNext;
                                    default:
                                        break zzForAction;
                                }

                            case 159:
                                switch (zzInput) {
                                    case 25:
                                        zzIsFinal = true;
                                        zzState = 165;
                                        break zzForNext;
                                    case 0:
                                    case 1:
                                    case 2:
                                    case 3:
                                    case 5:
                                    case 7:
                                    case 8:
                                    case 9:
                                    case 24:
                                        break zzForAction;
                                    default:
                                        zzIsFinal = true;
                                        zzNoLookAhead = true;
                                        zzState = 7;
                                        break zzForNext;
                                }

                            case 160:
                                switch (zzInput) {
                                    case 11:
                                        zzState = 166;
                                        break zzForNext;
                                    default:
                                        break zzForAction;
                                }

                            case 161:
                                switch (zzInput) {
                                    case 25:
                                        zzState = 167;
                                        break zzForNext;
                                    default:
                                        break zzForAction;
                                }

                            case 162:
                                switch (zzInput) {
                                    case 10:
                                        zzState = 168;
                                        break zzForNext;
                                    default:
                                        break zzForAction;
                                }

                            case 163:
                                switch (zzInput) {
                                    case 12:
                                        zzIsFinal = true;
                                        zzState = 169;
                                        break zzForNext;
                                    case 0:
                                    case 1:
                                    case 2:
                                    case 3:
                                    case 5:
                                    case 7:
                                    case 8:
                                    case 9:
                                    case 24:
                                        break zzForAction;
                                    default:
                                        zzIsFinal = true;
                                        zzState = 10;
                                        break zzForNext;
                                }

                            case 164:
                                switch (zzInput) {
                                    case 25:
                                        zzState = 63;
                                        break zzForNext;
                                    default:
                                        break zzForAction;
                                }

                            case 165:
                                switch (zzInput) {
                                    case 23:
                                        zzState = 170;
                                        break zzForNext;
                                    default:
                                        break zzForAction;
                                }

                            case 166:
                                switch (zzInput) {
                                    case 25:
                                        zzState = 79;
                                        break zzForNext;
                                    default:
                                        break zzForAction;
                                }

                            case 167:
                                switch (zzInput) {
                                    case 23:
                                        zzState = 170;
                                        break zzForNext;
                                    default:
                                        break zzForAction;
                                }

                            case 168:
                                switch (zzInput) {
                                    case 12:
                                        zzState = 171;
                                        break zzForNext;
                                    default:
                                        break zzForAction;
                                }

                            case 169:
                                switch (zzInput) {
                                    case 23:
                                        zzIsFinal = true;
                                        zzState = 172;
                                        break zzForNext;
                                    case 0:
                                    case 1:
                                    case 2:
                                    case 3:
                                    case 5:
                                    case 7:
                                    case 8:
                                    case 9:
                                    case 24:
                                        break zzForAction;
                                    default:
                                        zzIsFinal = true;
                                        zzState = 10;
                                        break zzForNext;
                                }

                            case 170:
                                switch (zzInput) {
                                    case 17:
                                        zzIsFinal = true;
                                        zzNoLookAhead = true;
                                        zzState = 20;
                                        break zzForNext;
                                    default:
                                        break zzForAction;
                                }

                            case 171:
                                switch (zzInput) {
                                    case 23:
                                        zzIsFinal = true;
                                        zzNoLookAhead = true;
                                        zzState = 7;
                                        break zzForNext;
                                    default:
                                        break zzForAction;
                                }

                            case 172:
                                switch (zzInput) {
                                    case 0:
                                    case 1:
                                    case 2:
                                    case 3:
                                    case 5:
                                    case 7:
                                    case 8:
                                    case 9:
                                    case 24:
                                        break zzForAction;
                                    default:
                                        zzIsFinal = true;
                                        zzState = 10;
                                        break zzForNext;
                                }

                            default:
                                // if this is ever reached, there is a serious bug in JFlex
                                zzScanError(ZZ_UNKNOWN_ERROR);
                                break;
                        }
                    }

                    if ( zzIsFinal ) {
                        zzAction = zzState;
                        zzMarkedPosL = zzCurrentPosL;
                        if ( zzNoLookAhead ) break zzForAction;
                    }

                }
            }

            // store back cached position
            zzMarkedPos = zzMarkedPosL;

            switch (zzAction < 0 ? zzAction : ZZ_ACTION[zzAction]) {
                case 7 : {
                    char c = yycharat(yylength() - 2);
                    if (c == ')' || c == ']' || c == '}') {
                        transp = true;
                        return 0;
                    }
                }
                case 8:
                    break;
                case 5: {
                    if (scilabLexer.getKeyword(start - yychar, false) == ScilabLexerConstants.STRING) {
                        savePos = start - yychar - scilabLexer.beginString - scilabLexer.start;
                        yybegin(SPEC);
                    } else {
                        yybegin(RL);
                    }
                }
                case 9:
                    break;
                case 4: {
                    yypushback(1);
                    yybegin(PSNART);
                }
                case 10:
                    break;
                case 2: {
                    return 0;
                }
                case 11:
                    break;
                case 6: {
                    if (--savePos == 0) {
                        yybegin(RL);
                    }
                }
                case 12:
                    break;
                case 3: {
                    return 1;
                }
                case 13:
                    break;
                case 1: {
                }
                case 14:
                    break;
                default:
                    if (zzInput == YYEOF && zzStartRead == zzCurrentPos) {
                        zzAtEOF = true;
                        {
                            return -1;
                        }
                    } else {
                        zzScanError(ZZ_NO_MATCH);
                    }
            }
        }
    }


}
