/*
* Scilab ( http://www.scilab.org/ ) - This file is part of Scilab
* Copyright (C) 2010 - DIGITEO - Allan CORNET
*
* This file must be used under the terms of the CeCILL.
* This source file is licensed as described in the file COPYING, which
* you should have received as part of this distribution.  The terms
* are also available at
* http://www.cecill.info/licences/Licence_CeCILL_V2-en.txt
*
*/
#include <string.h>
#include "api_scilab.h"
#include "gw_parallel.h"
#include "MALLOC.h"
#include "callFunctionFromGateway.h"

/*--------------------------------------------------------------------------*/
static gw_generic_table Tab[]=
{
    {sci_parallel_run,"parallel_run"}
    ,{sci_parallel_concurrency, "parallel_concurrency"}
};
/*--------------------------------------------------------------------------*/
int gw_parallel(void)
{
    Rhs = Max(0, Rhs);

    if(pvApiCtx == NULL)
    {
        pvApiCtx = (StrCtx*)MALLOC(sizeof(StrCtx));
    }

    pvApiCtx->pstName = (char*)Tab[Fin-1].name;
    callFunctionFromGateway(Tab, SIZE_CURRENT_GENERIC_TABLE(Tab));
    return 0;
}
/*--------------------------------------------------------------------------*/
