#include "EditVar.hxx"
/* Generated by GIWS (version 1.1.0) */
/*

Copyright 2007-2008 INRIA
Copyright 2008-2010 DIGITEO

Author : Sylvestre Ledru & others

This is generated code.

This software is a computer program whose purpose is to hide the complexity
of accessing Java objects/methods from C++ code.

This software is governed by the CeCILL-B license under French law and
abiding by the rules of distribution of free software.  You can  use, 
modify and/ or redistribute the software under the terms of the CeCILL-B
license as circulated by CEA, CNRS and INRIA at the following URL
"http://www.cecill.info". 

As a counterpart to the access to the source code and  rights to copy,
modify and redistribute granted by the license, users are provided only
with a limited warranty  and the software's author,  the holder of the
economic rights,  and the successive licensors  have only  limited
liability. 

In this respect, the user's attention is drawn to the risks associated
with loading,  using,  modifying and/or developing or reproducing the
software by the user in light of its specific status of free software,
that may mean  that it is complicated to manipulate,  and  that  also
therefore means  that it is reserved for developers  and  experienced
professionals having in-depth computer knowledge. Users are therefore
encouraged to load and test the software's suitability as regards their
requirements in conditions enabling the security of their systems and/or 
data to be ensured and,  more generally, to use and operate it in the 
same conditions as regards security. 

The fact that you are presently reading this means that you have had
knowledge of the CeCILL-B license and that you accept its terms.
*/

namespace org_scilab_modules_ui_data {

// Returns the current env

JNIEnv * EditVar::getCurrentEnv() {
JNIEnv * curEnv = NULL;
this->jvm->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
return curEnv;
}
// Destructor

EditVar::~EditVar() {
JNIEnv * curEnv = NULL;
this->jvm->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);

curEnv->DeleteGlobalRef(this->instance);
curEnv->DeleteGlobalRef(this->instanceClass);
curEnv->DeleteGlobalRef(this->stringArrayClass);}
// Constructors

EditVar::EditVar(JavaVM * jvm_) {
jmethodID constructObject = NULL ;
jobject localInstance ;
jclass localClass ;
const std::string construct="<init>";
const std::string param="()V";
jvm=jvm_;

JNIEnv * curEnv = getCurrentEnv();

localClass = curEnv->FindClass( this->className().c_str() ) ;
if (localClass == NULL) {
  throw GiwsException::JniClassNotFoundException(curEnv, this->className());
}

this->instanceClass = static_cast<jclass>(curEnv->NewGlobalRef(localClass));

/* localClass is not needed anymore */
curEnv->DeleteLocalRef(localClass);

if (this->instanceClass == NULL) {
throw GiwsException::JniObjectCreationException(curEnv, this->className());
}


constructObject = curEnv->GetMethodID( this->instanceClass, construct.c_str() , param.c_str() ) ;
if(constructObject == NULL){
throw GiwsException::JniObjectCreationException(curEnv, this->className());
}

localInstance = curEnv->NewObject( this->instanceClass, constructObject ) ;
if(localInstance == NULL){
throw GiwsException::JniObjectCreationException(curEnv, this->className());
}
 
this->instance = curEnv->NewGlobalRef(localInstance) ;
if(this->instance == NULL){
throw GiwsException::JniObjectCreationException(curEnv, this->className());
}
/* localInstance not needed anymore */
curEnv->DeleteLocalRef(localInstance);

                /* Methods ID set to NULL */
voidopenVariableEditorDoublejobjectArray__jstringID=NULL; 
voidopenVariableEditorComplexjobjectArray__jobjectArray__jstringID=NULL; 
voidopenVariableEditorStringjobjectArray__jstringID=NULL; 
voidopenVariableEditorBooleanjobjectArray__jstringID=NULL; 
voidopenVariableEditorInteger8jobjectArray__jstringID=NULL; 
voidopenVariableEditorUInteger8jobjectArray__jstringID=NULL; 
voidopenVariableEditorInteger16jobjectArray__jstringID=NULL; 
voidopenVariableEditorUInteger16jobjectArray__jstringID=NULL; 
voidopenVariableEditorInteger32jobjectArray__jstringID=NULL; 
voidopenVariableEditorUInteger32jobjectArray__jstringID=NULL; 
voidcloseVariableEditorID=NULL; 


}

EditVar::EditVar(JavaVM * jvm_, jobject JObj) {
        jvm=jvm_;

        JNIEnv * curEnv = getCurrentEnv();

jclass localClass = curEnv->GetObjectClass(JObj);
        this->instanceClass = static_cast<jclass>(curEnv->NewGlobalRef(localClass));
        curEnv->DeleteLocalRef(localClass);

        if (this->instanceClass == NULL) {
throw GiwsException::JniObjectCreationException(curEnv, this->className());
        }

        this->instance = curEnv->NewGlobalRef(JObj) ;
        if(this->instance == NULL){
throw GiwsException::JniObjectCreationException(curEnv, this->className());
        }
        /* Methods ID set to NULL */
        voidopenVariableEditorDoublejobjectArray__jstringID=NULL; 
voidopenVariableEditorComplexjobjectArray__jobjectArray__jstringID=NULL; 
voidopenVariableEditorStringjobjectArray__jstringID=NULL; 
voidopenVariableEditorBooleanjobjectArray__jstringID=NULL; 
voidopenVariableEditorInteger8jobjectArray__jstringID=NULL; 
voidopenVariableEditorUInteger8jobjectArray__jstringID=NULL; 
voidopenVariableEditorInteger16jobjectArray__jstringID=NULL; 
voidopenVariableEditorUInteger16jobjectArray__jstringID=NULL; 
voidopenVariableEditorInteger32jobjectArray__jstringID=NULL; 
voidopenVariableEditorUInteger32jobjectArray__jstringID=NULL; 
voidcloseVariableEditorID=NULL; 


}

// Generic methods

void EditVar::synchronize() {
if (getCurrentEnv()->MonitorEnter(instance) != JNI_OK) {
throw GiwsException::JniMonitorException(getCurrentEnv(), "EditVar");
}
}

void EditVar::endSynchronize() {
if ( getCurrentEnv()->MonitorExit(instance) != JNI_OK) {
throw GiwsException::JniMonitorException(getCurrentEnv(), "EditVar");
}
}
// Method(s)

void EditVar::openVariableEditorDouble (JavaVM * jvm_, double** data, int dataSize, int dataSizeCol, char * variableName){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID voidopenVariableEditorDoublejobjectArray__jstringID = curEnv->GetStaticMethodID(cls, "openVariableEditorDouble", "([[DLjava/lang/String;)V" ) ;
if (voidopenVariableEditorDoublejobjectArray__jstringID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "openVariableEditorDouble");
}

 jobjectArray data_ = curEnv->NewObjectArray(dataSize, curEnv->FindClass("[D"),NULL);

if (data_ == NULL)
{
// check that allocation succeed
throw GiwsException::JniBadAllocException(curEnv);
}

 for (int i=0; i<dataSize; i++){

jdoubleArray dataLocal = curEnv->NewDoubleArray( dataSizeCol ) ;

if (dataLocal == NULL)
{
// check that allocation succeed
curEnv->DeleteLocalRef(data_);
throw GiwsException::JniBadAllocException(curEnv);
}

curEnv->SetDoubleArrayRegion( dataLocal, 0, dataSizeCol, (jdouble*)(data[i]) ) ;
curEnv->SetObjectArrayElement(data_, i, dataLocal);
curEnv->DeleteLocalRef(dataLocal);
}

jstring variableName_ = curEnv->NewStringUTF( variableName );

                         curEnv->CallStaticVoidMethod(cls, voidopenVariableEditorDoublejobjectArray__jstringID ,data_, variableName_);curEnv->DeleteLocalRef(data_);
if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
}

void EditVar::openVariableEditorComplex (JavaVM * jvm_, double** realData, int realDataSize, int realDataSizeCol, double** imgData, int imgDataSize, int imgDataSizeCol, char * variableName){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID voidopenVariableEditorComplexjobjectArray__jobjectArray__jstringID = curEnv->GetStaticMethodID(cls, "openVariableEditorComplex", "([[D[[DLjava/lang/String;)V" ) ;
if (voidopenVariableEditorComplexjobjectArray__jobjectArray__jstringID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "openVariableEditorComplex");
}

 jobjectArray realData_ = curEnv->NewObjectArray(realDataSize, curEnv->FindClass("[D"),NULL);

if (realData_ == NULL)
{
// check that allocation succeed
throw GiwsException::JniBadAllocException(curEnv);
}

 for (int i=0; i<realDataSize; i++){

jdoubleArray realDataLocal = curEnv->NewDoubleArray( realDataSizeCol ) ;

if (realDataLocal == NULL)
{
// check that allocation succeed
curEnv->DeleteLocalRef(realData_);
throw GiwsException::JniBadAllocException(curEnv);
}

curEnv->SetDoubleArrayRegion( realDataLocal, 0, realDataSizeCol, (jdouble*)(realData[i]) ) ;
curEnv->SetObjectArrayElement(realData_, i, realDataLocal);
curEnv->DeleteLocalRef(realDataLocal);
}

 jobjectArray imgData_ = curEnv->NewObjectArray(imgDataSize, curEnv->FindClass("[D"),NULL);

if (imgData_ == NULL)
{
// check that allocation succeed
throw GiwsException::JniBadAllocException(curEnv);
}

 for (int i=0; i<imgDataSize; i++){

jdoubleArray imgDataLocal = curEnv->NewDoubleArray( imgDataSizeCol ) ;

if (imgDataLocal == NULL)
{
// check that allocation succeed
curEnv->DeleteLocalRef(imgData_);
throw GiwsException::JniBadAllocException(curEnv);
}

curEnv->SetDoubleArrayRegion( imgDataLocal, 0, imgDataSizeCol, (jdouble*)(imgData[i]) ) ;
curEnv->SetObjectArrayElement(imgData_, i, imgDataLocal);
curEnv->DeleteLocalRef(imgDataLocal);
}

jstring variableName_ = curEnv->NewStringUTF( variableName );

                         curEnv->CallStaticVoidMethod(cls, voidopenVariableEditorComplexjobjectArray__jobjectArray__jstringID ,realData_, imgData_, variableName_);curEnv->DeleteLocalRef(realData_);
curEnv->DeleteLocalRef(imgData_);
if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
}

void EditVar::openVariableEditorString (JavaVM * jvm_, char *** data, int dataSize, int dataSizeCol, char * variableName){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID voidopenVariableEditorStringjobjectArray__jstringID = curEnv->GetStaticMethodID(cls, "openVariableEditorString", "([[Ljava/lang/String;Ljava/lang/String;)V" ) ;
if (voidopenVariableEditorStringjobjectArray__jstringID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "openVariableEditorString");
}
jclass stringArrayClass = curEnv->FindClass("java/lang/String");
// create java array of array of strings.
jobjectArray data_ = curEnv->NewObjectArray( dataSize, curEnv->FindClass("[Ljava/lang/String;"), NULL);
if (data_ == NULL)
{
throw GiwsException::JniBadAllocException(curEnv);
}

for ( int i = 0; i < dataSize; i++)
{
jobjectArray dataLocal = curEnv->NewObjectArray( dataSizeCol, stringArrayClass, NULL);
// convert each char * to java strings and fill the java array.
for ( int j = 0; j < dataSizeCol; j++) {
jstring TempString = curEnv->NewStringUTF( data[i][j] );

if (TempString == NULL)
{
throw GiwsException::JniBadAllocException(curEnv);
}

curEnv->SetObjectArrayElement( dataLocal, j, TempString);

// avoid keeping reference on to many strings
curEnv->DeleteLocalRef(TempString);
}
curEnv->SetObjectArrayElement(data_, i, dataLocal);
curEnv->DeleteLocalRef(dataLocal);

}
jstring variableName_ = curEnv->NewStringUTF( variableName );

                         curEnv->CallStaticVoidMethod(cls, voidopenVariableEditorStringjobjectArray__jstringID ,data_, variableName_);curEnv->DeleteLocalRef(stringArrayClass);
curEnv->DeleteLocalRef(data_);
if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
}

void EditVar::openVariableEditorBoolean (JavaVM * jvm_, int** data, int dataSize, int dataSizeCol, char * variableName){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID voidopenVariableEditorBooleanjobjectArray__jstringID = curEnv->GetStaticMethodID(cls, "openVariableEditorBoolean", "([[ILjava/lang/String;)V" ) ;
if (voidopenVariableEditorBooleanjobjectArray__jstringID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "openVariableEditorBoolean");
}

 jobjectArray data_ = curEnv->NewObjectArray(dataSize, curEnv->FindClass("[I"),NULL);

if (data_ == NULL)
{
// check that allocation succeed
throw GiwsException::JniBadAllocException(curEnv);
}

 for (int i=0; i<dataSize; i++){

jintArray dataLocal = curEnv->NewIntArray( dataSizeCol ) ;

if (dataLocal == NULL)
{
// check that allocation succeed
curEnv->DeleteLocalRef(data_);
throw GiwsException::JniBadAllocException(curEnv);
}

curEnv->SetIntArrayRegion( dataLocal, 0, dataSizeCol, (jint*)(data[i]) ) ;
curEnv->SetObjectArrayElement(data_, i, dataLocal);
curEnv->DeleteLocalRef(dataLocal);
}

jstring variableName_ = curEnv->NewStringUTF( variableName );

                         curEnv->CallStaticVoidMethod(cls, voidopenVariableEditorBooleanjobjectArray__jstringID ,data_, variableName_);curEnv->DeleteLocalRef(data_);
if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
}

void EditVar::openVariableEditorInteger8 (JavaVM * jvm_, byte** data, int dataSize, int dataSizeCol, char * variableName){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID voidopenVariableEditorInteger8jobjectArray__jstringID = curEnv->GetStaticMethodID(cls, "openVariableEditorInteger8", "([[BLjava/lang/String;)V" ) ;
if (voidopenVariableEditorInteger8jobjectArray__jstringID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "openVariableEditorInteger8");
}

 jobjectArray data_ = curEnv->NewObjectArray(dataSize, curEnv->FindClass("[B"),NULL);

if (data_ == NULL)
{
// check that allocation succeed
throw GiwsException::JniBadAllocException(curEnv);
}

 for (int i=0; i<dataSize; i++){

jbyteArray dataLocal = curEnv->NewByteArray( dataSizeCol ) ;

if (dataLocal == NULL)
{
// check that allocation succeed
curEnv->DeleteLocalRef(data_);
throw GiwsException::JniBadAllocException(curEnv);
}

curEnv->SetByteArrayRegion( dataLocal, 0, dataSizeCol, (jbyte*)(data[i]) ) ;
curEnv->SetObjectArrayElement(data_, i, dataLocal);
curEnv->DeleteLocalRef(dataLocal);
}

jstring variableName_ = curEnv->NewStringUTF( variableName );

                         curEnv->CallStaticVoidMethod(cls, voidopenVariableEditorInteger8jobjectArray__jstringID ,data_, variableName_);curEnv->DeleteLocalRef(data_);
if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
}

void EditVar::openVariableEditorUInteger8 (JavaVM * jvm_, short** data, int dataSize, int dataSizeCol, char * variableName){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID voidopenVariableEditorUInteger8jobjectArray__jstringID = curEnv->GetStaticMethodID(cls, "openVariableEditorUInteger8", "([[SLjava/lang/String;)V" ) ;
if (voidopenVariableEditorUInteger8jobjectArray__jstringID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "openVariableEditorUInteger8");
}

 jobjectArray data_ = curEnv->NewObjectArray(dataSize, curEnv->FindClass("[S"),NULL);

if (data_ == NULL)
{
// check that allocation succeed
throw GiwsException::JniBadAllocException(curEnv);
}

 for (int i=0; i<dataSize; i++){

jshortArray dataLocal = curEnv->NewShortArray( dataSizeCol ) ;

if (dataLocal == NULL)
{
// check that allocation succeed
curEnv->DeleteLocalRef(data_);
throw GiwsException::JniBadAllocException(curEnv);
}

curEnv->SetShortArrayRegion( dataLocal, 0, dataSizeCol, (jshort*)(data[i]) ) ;
curEnv->SetObjectArrayElement(data_, i, dataLocal);
curEnv->DeleteLocalRef(dataLocal);
}

jstring variableName_ = curEnv->NewStringUTF( variableName );

                         curEnv->CallStaticVoidMethod(cls, voidopenVariableEditorUInteger8jobjectArray__jstringID ,data_, variableName_);curEnv->DeleteLocalRef(data_);
if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
}

void EditVar::openVariableEditorInteger16 (JavaVM * jvm_, short** data, int dataSize, int dataSizeCol, char * variableName){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID voidopenVariableEditorInteger16jobjectArray__jstringID = curEnv->GetStaticMethodID(cls, "openVariableEditorInteger16", "([[SLjava/lang/String;)V" ) ;
if (voidopenVariableEditorInteger16jobjectArray__jstringID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "openVariableEditorInteger16");
}

 jobjectArray data_ = curEnv->NewObjectArray(dataSize, curEnv->FindClass("[S"),NULL);

if (data_ == NULL)
{
// check that allocation succeed
throw GiwsException::JniBadAllocException(curEnv);
}

 for (int i=0; i<dataSize; i++){

jshortArray dataLocal = curEnv->NewShortArray( dataSizeCol ) ;

if (dataLocal == NULL)
{
// check that allocation succeed
curEnv->DeleteLocalRef(data_);
throw GiwsException::JniBadAllocException(curEnv);
}

curEnv->SetShortArrayRegion( dataLocal, 0, dataSizeCol, (jshort*)(data[i]) ) ;
curEnv->SetObjectArrayElement(data_, i, dataLocal);
curEnv->DeleteLocalRef(dataLocal);
}

jstring variableName_ = curEnv->NewStringUTF( variableName );

                         curEnv->CallStaticVoidMethod(cls, voidopenVariableEditorInteger16jobjectArray__jstringID ,data_, variableName_);curEnv->DeleteLocalRef(data_);
if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
}

void EditVar::openVariableEditorUInteger16 (JavaVM * jvm_, int** data, int dataSize, int dataSizeCol, char * variableName){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID voidopenVariableEditorUInteger16jobjectArray__jstringID = curEnv->GetStaticMethodID(cls, "openVariableEditorUInteger16", "([[ILjava/lang/String;)V" ) ;
if (voidopenVariableEditorUInteger16jobjectArray__jstringID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "openVariableEditorUInteger16");
}

 jobjectArray data_ = curEnv->NewObjectArray(dataSize, curEnv->FindClass("[I"),NULL);

if (data_ == NULL)
{
// check that allocation succeed
throw GiwsException::JniBadAllocException(curEnv);
}

 for (int i=0; i<dataSize; i++){

jintArray dataLocal = curEnv->NewIntArray( dataSizeCol ) ;

if (dataLocal == NULL)
{
// check that allocation succeed
curEnv->DeleteLocalRef(data_);
throw GiwsException::JniBadAllocException(curEnv);
}

curEnv->SetIntArrayRegion( dataLocal, 0, dataSizeCol, (jint*)(data[i]) ) ;
curEnv->SetObjectArrayElement(data_, i, dataLocal);
curEnv->DeleteLocalRef(dataLocal);
}

jstring variableName_ = curEnv->NewStringUTF( variableName );

                         curEnv->CallStaticVoidMethod(cls, voidopenVariableEditorUInteger16jobjectArray__jstringID ,data_, variableName_);curEnv->DeleteLocalRef(data_);
if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
}

void EditVar::openVariableEditorInteger32 (JavaVM * jvm_, int** data, int dataSize, int dataSizeCol, char * variableName){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID voidopenVariableEditorInteger32jobjectArray__jstringID = curEnv->GetStaticMethodID(cls, "openVariableEditorInteger32", "([[ILjava/lang/String;)V" ) ;
if (voidopenVariableEditorInteger32jobjectArray__jstringID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "openVariableEditorInteger32");
}

 jobjectArray data_ = curEnv->NewObjectArray(dataSize, curEnv->FindClass("[I"),NULL);

if (data_ == NULL)
{
// check that allocation succeed
throw GiwsException::JniBadAllocException(curEnv);
}

 for (int i=0; i<dataSize; i++){

jintArray dataLocal = curEnv->NewIntArray( dataSizeCol ) ;

if (dataLocal == NULL)
{
// check that allocation succeed
curEnv->DeleteLocalRef(data_);
throw GiwsException::JniBadAllocException(curEnv);
}

curEnv->SetIntArrayRegion( dataLocal, 0, dataSizeCol, (jint*)(data[i]) ) ;
curEnv->SetObjectArrayElement(data_, i, dataLocal);
curEnv->DeleteLocalRef(dataLocal);
}

jstring variableName_ = curEnv->NewStringUTF( variableName );

                         curEnv->CallStaticVoidMethod(cls, voidopenVariableEditorInteger32jobjectArray__jstringID ,data_, variableName_);curEnv->DeleteLocalRef(data_);
if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
}

void EditVar::openVariableEditorUInteger32 (JavaVM * jvm_, long long** data, int dataSize, int dataSizeCol, char * variableName){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID voidopenVariableEditorUInteger32jobjectArray__jstringID = curEnv->GetStaticMethodID(cls, "openVariableEditorUInteger32", "([[JLjava/lang/String;)V" ) ;
if (voidopenVariableEditorUInteger32jobjectArray__jstringID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "openVariableEditorUInteger32");
}

 jobjectArray data_ = curEnv->NewObjectArray(dataSize, curEnv->FindClass("[J"),NULL);

if (data_ == NULL)
{
// check that allocation succeed
throw GiwsException::JniBadAllocException(curEnv);
}

 for (int i=0; i<dataSize; i++){

jlongArray dataLocal = curEnv->NewLongArray( dataSizeCol ) ;

if (dataLocal == NULL)
{
// check that allocation succeed
curEnv->DeleteLocalRef(data_);
throw GiwsException::JniBadAllocException(curEnv);
}

curEnv->SetLongArrayRegion( dataLocal, 0, dataSizeCol, (jlong*)(data[i]) ) ;
curEnv->SetObjectArrayElement(data_, i, dataLocal);
curEnv->DeleteLocalRef(dataLocal);
}

jstring variableName_ = curEnv->NewStringUTF( variableName );

                         curEnv->CallStaticVoidMethod(cls, voidopenVariableEditorUInteger32jobjectArray__jstringID ,data_, variableName_);curEnv->DeleteLocalRef(data_);
if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
}

void EditVar::closeVariableEditor (JavaVM * jvm_){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = curEnv->FindClass( className().c_str() );

jmethodID voidcloseVariableEditorID = curEnv->GetStaticMethodID(cls, "closeVariableEditor", "()V" ) ;
if (voidcloseVariableEditorID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "closeVariableEditor");
}

                         curEnv->CallStaticVoidMethod(cls, voidcloseVariableEditorID );if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
}

}
