//The besselK_ref data have been computed using Maple V Release 4 with 
//the code:

// a:=array(1..100):for i from 1 to 100 do  a[i]:=-20+i*0.4: od:
// x:=array(1..200):for i from 1 to 100 do  x[i]:=-20+i*0.41: od:
// for j from 1 to 10 do for i from 1 to 10 do x[100+i+(j-1)*10]:=(-5.1+i)+(-4.9+j)*I: od: od:

// writeto(foo);interface(prettyprint=0);
// for i from 1 to 100 do for j from 1 to 200 do print(evalf(BesselK(a[i],x[j]),30)); od;od;
// writeto(terminal);


alpha=-20+(1:100)*0.4;
x=[-20+(1:100)*0.41, matrix((-5.1+(1:10))'*ones(1,10)+ones(10,1)*(-4.9+(1:10))*%i,1,-1)];

besselK_ref=[.217209072722603752310653412753e-5-8063.26603374127973021055433312*%i
.391202532018132019915838949383e-5-4524.05067429064620442872981128*%i
.709098585224175553874945899632e-5-2522.08992782656778646339183013*%i
.129403240376902307553672687373e-4-1396.54786501895920383280171130*%i
.237837798123113643762485268268e-4-767.798551680651131198076140693*%i
.440443096715255330126267645954e-4-418.944450415502059681302258115*%i
.822169893206298574401884660392e-4-226.772764400822652124924955903*%i
.154774975982204367652809016090e-3-121.714604595976799501578361694*%i
.293987189024214728363393087393e-3-64.7419216084627799221200187626*%i
.563746460659999450701849666527e-3-34.1089808898989904396832144249*%i
.109200956510557082765845981839e-2-17.7867758111752047896618738800*%i
.213814934268647256478627902362e-2-9.17192204357812361313792057503*%i
.423472551419646270837260752487e-2-4.66817851685672251251664814004*%i
.849028997628995961082890362465e-2-2.33217745166836322101122742765*%i
.172462716118423050235217731196e-1-1.11946557144200586865658271682*%i
.355257757439703250698872402038e-1-.465493793095742322798792089664*%i
.742859939297871018676041790873e-1-.489521226647090906092595877837e-1*%i
.157858842952078360937270996415+.353956304620785438025764064174*%i
.341321149569079302319313108468+.988903817214496935002512978711*%i
.751935345032740302521975658323+2.28600719809459117845630818244*%i
1.69035003013170328680323027153+5.18969712369900412013098990296*%i
3.88402656715297330606816736815+11.9482427305818200299160402767*%i
9.13931902365796313853067135105+28.1255470361861878564944226544*%i
22.0692770283230476913982590535+67.9212544746932161760775197612*%i
54.8198495358132748896753104686+168.717744010842575489950840468*%i
140.453389299445266279289064216+432.270924835481955085060979346*%i
372.307096976903700837654753669+1145.84336261592565983788167206*%i
1024.62822286760283401726536075+3153.48139108137964520850053089*%i
2939.52602337744697014290388916+9046.93084146316913090556252879*%i
8832.03541106473401633988205243+27182.2099817732599113130836356*%i
27943.4634859277594094874955735+86001.1375414671079607555582809*%i
93694.4883217686395713724514937+288361.984231717003573548272701*%i
335473.101342069369950761485795+1032480.04116554221319655959151*%i
1294372.26330380439216076673726+3983668.20574637287284238239954*%i
5441291.67129244751019844260464+16746573.7977055817213980303591*%i
25261382.6899538498955166010509+77746541.6311548814362106104701*%i
131715812.878179247036742208235+405379588.880828499336701719873*%i
787975725.214124620671695115400+2425139917.18524257186355603477*%i
5559917004.57761136943394121351+17111665033.0492625235471464386*%i
47993740074.7439322719059763017+147709543715.507616094060509454*%i
532752790096.245130517288732906+1639644491463.39702290265854336*%i
8160875917899.24793833864527192+25116593461448.5002770718262039*%i
191518397988512.335944237063178+589433020555422.582359289640671*%i
8116800778129516.48405420758708+24980944129380499.4910961376581*%i
823157843272750673.103405559122+2533419342737232160.20199151791*%i
344411936321525763762.193016355+1059990946423411545578.42226694*%i
2166494280861620166467446.09577+6667783781592148055854131.99220*%i
.228275012335879312103148067442e32+.702558247414613645912381557428e32*%i
.464315128501246963549853684253e43
11714992977759509441794934789.6
92890152907892225315181.4691122
62603715220302566466.0032269007
306802681894430672.684765873707
4647478624636478.76040169013020
145868785478716.665789209408043
7615900485847.74048445237980561
578705662681.699576123424723053
58643064884.4135490120088134273
7461269094.95454021599381878878
1141349484.43823083867436758491
203256729.751507147207454266602
41116286.3866059689161283824458
9268123.04313744979294740352717
2292718.46507250800781548979139
614799.917861179241101153120949
176909.304580820931788839344175
54170.0413982818159850116928816
17526.9053427188256421264737274
5956.67112085942959742122708319
2115.66668351510867985282714781
781.875426908437049530839772241
299.523005332369972391933282515
118.547387103642518788710316436
48.3355754168663591033301719088
20.2510854680698992849854274120
8.69874681103174674552726099644
3.82314875023828522849473112010
1.71618650916197172656133560073
.785579416356597942049883426636
.366160825674024624876267964086
.173558175179342529116960619313
.835600654287116338466704602351e-1
.408196676793678649622953981535e-1
.202132225014700987047954639036e-1
.101370739462429026631939741900e-1
.514457234668425562302753788185e-2
.264012027619516142299380101381e-2
.136911682407063996279421619206e-2
.717014570775657721196700566601e-3
.378997030902866776131186256082e-3
.202084464410362916029185633183e-3
.108643990355278955496073577561e-3
.588648865903572311118850614282e-4
.321292987263577968559306580832e-4
.176591615390040938719499921293e-4
.977021866865669792714270415769e-5
.543946531089623760441238200142e-5
.304640871152958053461841718443e-5
.171581945215480456277213781666e-5
.971597250756978138851997290023e-6
-16166868.0218806500152003946086+19624955.0880274540468451872325*%i
319168033.245250432494337553225-119236587.575790080153072277742*%i
-3038795152.99912447382368872700+2051538568.23342497119764324014*%i
-1514262587.19682893417494727632-21893436805.4537927773554735074*%i
46509511159.0359256935381755088-6387002939.06600394787888604467*%i
7381011490.00288595613484284290+27115017065.2805570696719633780*%i
-5540125823.56830274402878854987-623066313.881787033259288078049*%i
539749152.081147496883302103885-160098518.300267112000647765169*%i
-42761146.4921582622123794378809-4055424.60582947613175060760341*%i
1376363.39964926394688830363324+2841246.93433740711330777002704*%i
115084207.638485129930771110043-212246615.248539638532453292310*%i
-6188813736.18421737341939049702+3632784917.51637124734394942251*%i
103119120174.246581575411601133-190536368242.339780124775606284*%i
3753233306513.88236964199884407+407444982772.127810572043040570*%i
14151690376711.2369889896465433+558282705893.794334947997550448*%i
5669961418402.17981530531737584-988453381475.243968037188760497*%i
310000421482.294829125855323627+271154906686.890227804743893866*%i
-14275795150.8734487315716077498+1261110354.14750905755505856531*%i
452248489.844657747776594048636+124191346.156680570267962479056*%i
-2683069.12740883688714004761349-18504970.1200617615541353731456*%i
-1536021993.98513052788927717566+930509705.502043401807350070142*%i
130441788571.015479456047582988+51346122375.2285410815054499031*%i
-20100870963809.2644409353386226+1419121659336.85274631065464752*%i
-3043172050810469.77492061445585-543128453913716.294313435967423*%i
47919796344973496.7108688321948+20101505656226355.4387700407044*%i
-7157401351511085.97118305424467-1243291490502922.67049657744734*%i
-55707636449791.6590748610832777+12288859599377.6620512528865092*%i
179889786117.820672259440496800-314145859808.921402442971725001*%i
-3845561310.56496612312653052055+1368521513.62999503857270729398*%i
29576551.6532910058234709277208+79210280.5012718024331481185137*%i
5652235414.79279343436063574824+4696179020.21854796839626016120*%i
1159749586641.39012957776323644-769867788419.498236420184317223*%i
-1284177139497004.84577648925439-235797282756108.105096541218008*%i
-8283647708880232189.60249715256-12469443749699975894.8046356934*%i
3413265204600558777815.71502408+104490583007396876580739.638486*%i
-125292740720500936652.426077116+37714634773899025501.3616809358*%i
-5116875781320078.78411985999352+4383650502965284.28114892727379*%i
4460540772062.04842841088369375-1455391559235.51024135968119976*%i
-3299565928.28026445801707506470-18794117869.6693501396893463636*%i
-200037478.524226226485658861472-118618927.761155986711576097648*%i
-1992954759.67396274002143734536+11292990102.4876097506017029650*%i
-965508235675.507831394987678719+2854574433042.75211333311085640*%i
-3854045759369965.96722017897243+5352019251110125.55043897044154*%i
-2061976717759335061693.37404039+217447513942105101138.090298984*%i
-.388130074657305678742538784955e39-.534517322409734218704065438368e39*%i
-57817831864495505688506.0559274-84420923338984674833981.8316227*%i
24053212227194082.6813251851559-40578721706532032.4154596423764*%i
8762750258292.87290628967803453-7134646320390.75098994937111456*%i
27184937087.1955864420443188621-15306905407.0699767445258204597*%i
290691763.504108164576418421161-127341698.400617065537312287198*%i
5770876134.48185753605256482382+1356232148.99752613304377760686*%i
-170268998405.624722011981965330+952301854617.482362817009515707*%i
-138766747816609.733671380593017-621332385601480.973693241309258*%i
-1437803890387317334.66095379205-2120727955779611667.62871583707*%i
883212280956773668564.814636297-1950760632026503774266.23736730*%i
1437954670285321639.69210575898+15063525020695101299.1568091925*%i
-1761963501041848.23384476280818+2301001596084335.77600615144223*%i
1914330894831.56030350825415918-2452231533568.48727573755267416*%i
10699509408.5147709526613025121+10602387227.9053743344906711850*%i
-47834166.2157754250197535986873+194044383.731076889334717715199*%i
-286152682.825156729669617735711-1211845488.66339979241663952669*%i
68541649210.1109578454258491225+40584305434.1084440695430478409*%i
-3914260910939.87146056337179044-7001479495782.74472169328361997*%i
-548932186670925.981613845280635-424346787416661.908501380901874*%i
7094796287738911.64360661281225-2184156711517613.51027547123766*%i
-881023381553813.653484773124306+1136900177453785.42500895284272*%i
-14747334666518.7364686274679947+14367308086620.3194618009126969*%i
193191487935.692005412659565372+23100239279.1462229363384167451*%i
-2439401116.58913268100817578056+1253981218.15015086816301544999*%i
-22411185.9409113226041536271639-60557114.5515075566579267689563*%i
-22943337.9754285002432832824044+153805890.913437233291526666000*%i
-1401785815.06448178735191711055-3613862136.11178278969167419970*%i
-11833866209.6692117854148757015+90836118210.2785700213492061307*%i
1150700529089.85907467266664935+382067412126.007251840293055635*%i
3900655023702.90119854229856440+18235817621.7648140259248558805*%i
1731014560938.93644704136957480-337038938868.636028096635989897*%i
40880509658.1740823620710332378-159561732354.252741403108606337*%i
-6196171276.65633568997797862422+4066521486.29223839824214160177*%i
177429765.247572637463568122926-233330022.863554788764102420626*%i
5954510.01603404979276506788132+11890528.7101078683404811814196*%i
-2829342.98285696257404120435300-15850021.9418416231316866864810*%i
124633398.185445810686599185635+141667180.965242240378198479108*%i
-925668273.385561510412159622564-1470509244.78193658748874955479*%i
-2886510603.94442123240706870956+8541996276.62960223316746930223*%i
17780075910.1561438326726797748+2897283672.84746356593388560162*%i
573237426.551631748540164623084-11283532607.1778966853307435585*%i
-2244075848.70004294597703958628+1233287163.03114051995350096538*%i
296910236.471770130174730408123-58188142.7480254093376480348263*%i
-21817364.9933178656619421023885+15116494.8329379687525622604214*%i
-121372.885717709080209236068203-2174510.15686631038317959270030*%i
1498667.50736437181596200489107+796807.406668588791832976858259*%i
-11134343.8310872212053157611232+2507318.52797142259185311676468*%i
51906353.8636209753645743868662-25178086.1603554297080910679719*%i
-174321499.018325144826245287036+42656029.1772764261824059814674*%i
274597655.624870848355208220459+72475263.4863089227552566735527*%i
-147695776.192881959981201289106-147413582.845003005638003944753*%i
36389166.4939563938060153991920+66456414.7406339031438420533806*%i
-9652121.93842651126137701387676-13063030.7550288907037934741050*%i
2394096.49269816881061489282599+790583.448890531543293098122682*%i
-244836.881806133983003814615834+228042.054761963561634214631850*%i
-.402826137237494126933330221836e-5-11499.5228304305755546734102751*%i
-.721255839957092786674211769685e-5-6491.46705325624301741720251916*%i
-.129944825368653515531300315008e-4-3641.73082584385570280923689796*%i
-.235654029787074379450825678081e-4-2029.66473041201571555158726378*%i
-.430324750400030503678219799405e-4-1123.39006656372851761008309782*%i
-.791579984493165378964286580777e-4-617.238109818764113632057708593*%i
-.146742208649401453394225605627e-3-336.514166327192828055481471987*%i
-.274268816890075015688220737143e-3-181.961756363519363803239250741*%i
-.517099872746275978404779191113e-3-97.5357882566335712848760729263*%i
-.983971061650898979334556853210e-3-51.7983984085176540070793715934*%i
-.189083270214021567722757460829e-2-27.2378227552818077966166700136*%i
-.367165290434819861206975802849e-2-14.1716860541123503998426289352*%i
-.720953152343306130343259474030e-2-7.28843728656133134523250550208*%i
-.143256947576496214053315412571e-1-3.69805219379335293181700629524*%i
-.288299722208023268041608499459e-1-1.84064476658352562458985431860*%i
-.588143564406238894700563798102e-1-.879040558661457191282796913096*%i
-.121748076000205880708068235673-.361301437113248491889768332521*%i
-.256007574781629411934768197773-.300076372029878218007900949414e-1*%i
-.547490829939019562704515040244+.295781447512981078326078543006*%i
-1.19237097480999339311791997413+.819024828166598145094049700174*%i
-2.64848431247668553389125659147+1.90274696065333456002393563950*%i
-6.00964747334506512087000495488+4.35670553196153285336660201169*%i
-13.9561186770148385366662949921+10.1355598760037497029434571545*%i
-33.2384391556708981149305107303+24.1473798460310689790268740421*%i
-81.3742631803503697264177609677+59.1211377830958197999065825315*%i
-205.327781071593089914613388568+149.179075303472641123042243702*%i
-535.579376474472104811612153541+389.121082094349850953765592040*%i
-1449.11880099349784745546376069+1052.84639531159614763083561753*%i
-4083.20224797827951409841235754+2966.62006867315535383413089597*%i
-12036.4402337728525499831004819+8744.98571052765455519215634447*%i
-37317.2041093816639429346784819+27112.5358100642563836485502414*%i
-122448.685094001827824638697388+88964.1772186196483754283490794*%i
-428410.184428388018708901851698+311258.218417697533453279805704*%i
-1612471.11673885255649671487708+1171528.84149103418594313385425*%i
-6599863.36168074757286627885222+4795081.41128548016507310282832*%i
-29767235.0063207977278053218015+21627162.1732219849655478630659*%i
-150406054.421835921726181987083+109276395.006952558241160585695*%i
-869347379.932986006075646115942+631617843.131348595475977385745*%i
-5905587594.38327440528753255922+4290660540.18032196856350289957*%i
-48868566616.3614613061893420532+35505091929.4496410686769852806*%i
-517265612687.285158603264248781+375815465892.062034515761667786*%i
-7504707449621.43984864981537530+5452489122388.62543095425411909*%i
-165331484321839.487471023013240+120120354578067.950059798919441*%i
-6497679113150035.36095127222364+4720840209035658.05074588478010*%i
-600164088702356243.163373996483+436044734223843555.662590581930*%i
-222144319259619292780.289943266+161397295296913779642.040961386*%i
-1169445305214948892933159.61967+849651748414869814904705.761913*%i
-.886067439861712590573760584917e31+.643765677740366742405675980216e31*%i
.414471874785540862906804660375e42
2076271953758508848051743293.31
20915409286854579488430.0023557
16352828184655723579.1291658361
89265010140099290.0349395308993
1471583250186592.63412509787488
49515011690536.3166607844708261
2742279633442.91856454572889115
219309935565.067596949945617141
23248611633.9454152131908542901
3079484301.11997345705405921933
488494169.885632854152881635307
89916288.2866793137490710862204
18748066.8096924444741488985056
4345617.52135458367287134210405
1103143.88174444369153614934955
303006.811886960794942235365249
89168.8137339857064109503686197
27883.5240332477697110403277129
9201.66226574149469262633997973
3185.94277542751780364326648007
1151.60172677376558939704354869
432.714176696020248457858285507
168.393460167292498097650575281
67.6507085762846049429221902709
27.9778080146497870323674781124
11.8813780918879763431551856652
5.16980045879031765478660250643
2.30029251644463301596256163166
1.04480378577650559652336405709
.483668786348983313276245782024
.227882589359482696434708495515
.109137050048375119365070403191
.530679349967286358383505082668e-1
.261720909432553685208835178031e-1
.130791422384758589866669620178e-1
.661727894614252482158283164378e-2
.338685067176580375916418419425e-2
.175232660499818546041136789986e-2
.915900480182550186076335967772e-3
.483315559319441616239008078513e-3
.257346602582448907916816168371e-3
.138192994806145010580791855935e-3
.748040882292768889678252441338e-4
.407984422643300939496847163133e-4
.224110403948024315288893677249e-4
.123940900961458534011773422237e-4
.689837991468161814170630659137e-5
.386291949531302922911436581367e-5
.217563619545353048248092610766e-5
.123206565675672519951426219312e-5
.701360744150668285433819838855e-6
3201981.09966679222694900450048+11445498.9719633670720918236274*%i
46141773.1209183187670848700056-144505514.971899282249410912189*%i
-227123926.782058374170445131828+1543417956.73727601439510303382*%i
-6533111857.81918176786458733548-6219814331.25774580618597279461*%i
13579609303.8435940213466873623-13307685298.8651458851043340852*%i
8256055329.30472666669475447010+7998806021.94283927341963456055*%i
-2225718869.06350177618647165126+763579075.103520197843300865594*%i
197030203.661125405119750350794-151071104.557911021214112908010*%i
-19443046.6931413542292951442742+4157055.29188175344958383160198*%i
998306.746955527238545516785497+1163853.47201902743525904098103*%i
-53402614.9702771737827178531120-93179252.7261525951994348381368*%i
-235746819.874732184490799108548+2981801445.87802886301523681537*%i
-31855684118.4666559317719334067-78257010921.3510400377500583179*%i
1093205621861.69743428107591642-860981750679.166008036989396254*%i
4188552921717.84033510475974592-2883111822823.66332547985378653*%i
1637168008312.30035215302877056-1321146710946.13450748169145948*%i
150268730406.127248311457231101+50738217087.6240427651115226783*%i
-5434730744.59174628016352276633+2280516126.56822161034477353125*%i
205962800.285332327565814521652+3875927.75699895526598835228035*%i
-2989794.38496882326419905439904-8199128.89107636317115857468881*%i
46922200.9015093847860048403127+763406363.111060359771489663366*%i
43155202903.3201944655120991233-33848458718.9967025691097823227*%i
-3645894733391.96842564340638627+6144815405013.27740855713390297*%i
-781073464394911.993506614092054+609787157992878.861507107256316*%i
15238241199223940.4807697678796-3927945646248063.56902811462198*%i
-2200860584467961.81197076147293+628963006118081.135212293469649*%i
-17102096131941.0974405445384022+10000777716614.9766373817483856*%i
39919756878.9838315472797892122-133156721255.590932581644298276*%i
-1485758605.33715299484591958904+848661755.645423857152609238849*%i
18303596.0101075674889518131251+33498138.2040955234894571670246*%i
2694695603.14300823505758742300-1399568022.58051531089361445221*%i
-82907832983.8214156649570901430-512232994827.085303262511417895*%i
-259131200026945.796952738970017+336238464585230.833077278525729*%i
-4029310710606828901.72806830341-6017634481349973.80090952053248*%i
15237214034831976841367.5361695+17897289078707058429371.7054750*%i
-27699105646344508427.3987402986+19197665588991145702.9885530432*%i
-1343371977451063.35113150234291+1639398273847133.28832840846489*%i
1548869780432.65161061789853982-718315887336.041991374848396940*%i
-2008403852.43904522978344589997-7474300236.13124397269447086454*%i
-91794777.1137637124261508734312-46058914.1425945086262909705416*%i
-4641599684.75292332289544073013+696771358.557570461187131159518*%i
-1105262572473.70093055770757648+802596331.097306568755561819522*%i
-1986485980428618.32769646684972-595013473988458.009817309690989*%i
-221865277907135766201.119044745-453003766743558461511.634906966*%i
.218504811512464859716689458360e38-.671860562542299401065795064115e38*%i
-12141826970981192655105.1152451-19526971079607995751863.0446264*%i
7523377455479377.25885613460720-12107402537579952.7822134331253*%i
3164984037449.05397121177781619-2506035226965.30176582036485413*%i
10972517507.0471844130620722407-6034085716.72242123896104412819*%i
127945078.920249242429655982365-54849364.1721539230454464494787*%i
454139912.263472876745654540449+2418530726.68718122005966088055*%i
-350058660968.861292192643710056+97503002355.9336167018376234299*%i
157180276503932.016803666184264-139406384715837.527834607187443*%i
243454623813271365.770516078057-672367034927927644.682053210217*%i
462168331080408591852.353097503-241202224983409377869.831558670*%i
-1040493032688091490.51929697716+3938721228352315353.21135105831*%i
-704365758999246.179418533278607+603720224646159.130235384055459*%i
823839431139.769565354601923327-790583821197.934673016836887018*%i
3872661819.12754079473951170466+4765090958.54611108971971634829*%i
-28442431.2991366170905093259821+83856419.8717978832053610848920*%i
398142992.203242435116989392165-356624820.517089116640333055077*%i
439231300.963706954694476055152+31537177936.3267573923247208611*%i
1222671133599.77215050032494496-2629048311407.95477339869149048*%i
-20621037563894.5155622372611945-228471546347418.556269839098372*%i
2199192149690822.36426598236495+799855964539589.809519928023172*%i
-422734701759342.685691982614988+202274081435281.083021994130466*%i
-6606346084206.54500327745220538+3114700260422.10070956365497381*%i
70683217698.1116172399537564795+27102082126.0631228194065703365*%i
-1113835976.67293427288917702345+322659384.826513361811426178846*%i
-5777086.94010863855077387304971-28749987.6213400692882497012274*%i
-63837900.1540332626350838859857+28329636.6563674506028190165251*%i
894628385.828450709236537601993-1371091166.31581345796112954557*%i
-30613376146.1708195144261803842+19659949042.9246300876180134940*%i
212758651952.907100362618503031+405248616924.354008815567025235*%i
1148834026650.72760223244487336+866263353108.360155002218639769*%i
626990663620.389234360787163440+208691939972.980879542405056218*%i
39429626239.4492493930385969587-51262517203.8554177474207080364*%i
-2988505067.62412049349862339983+790603512.833439641254482641722*%i
102836026.025046084013566287380-79655883.6690418586722829028399*%i
1530856.47859850011983056119954+6063633.93000819936290917492891*%i
5323821.78798348799619124419123-5427689.23180983605967503237081*%i
-14681708.1318674024407051152286+83827139.6294941752303077815984*%i
193945630.117401429353457261124-725903957.131183446891004088593*%i
-3298638342.43338289353846319628+1840747372.84136260139004184258*%i
5189072779.37970993357549947368+5341335960.01141216838350473776*%i
2623477163.63954402825425131319-3915043550.06259491958606550835*%i
-1097557069.58970095141905109337+57707369.3456606977460720762553*%i
133032767.942887693777609766711+24398306.6337330357368461365641*%i
-11895369.6196607687427846566938+3565615.99388145826032467680193*%i
223731.475563799506108233272275-1042982.07189529513444551372446*%i
142990.525125430837054012318708+831111.366930953086250462141724*%i
-4411101.63304648440300197038561-3250048.53784862031883626750178*%i
25348346.0163953617351589397983+8955184.70862813141516498193060*%i
-72750332.3327304956899507243114-37582324.0094722185272433906383*%i
80409352.4219616562349031311275+100198034.446955422776233600581*%i
-21718214.1154415405383847659103-92426369.4288887198126760133939*%i
749844.031752754487459147091485+35121454.3529639673247032852780*%i
-1720542.88420531496607811356228-7553829.05769118811886004153063*%i
971783.544031315212999696671312+776420.992996952952624849570810*%i
-154602.489725164247871967001463+73254.9102988374008326887512679*%i
-.287020560291874440231047231791e-5-16304.8168075733398004966227088*%i
-.510929315707833297646806714798e-5-9259.75231276075065798908855326*%i
-.915005317347765082872546410098e-5-5227.20881218714793498724757840*%i
-.164909493840233162577709036859e-4-2932.11444312105529982868007323*%i
-.299214059029764923534781478808e-4-1633.71085985505490596831855586*%i
-.546763484692183358867519330361e-4-903.822890675232384091560948279*%i
-.100664892678759545314152170336e-3-496.275532727385057222428407750*%i
-.186814992726430631615475075036e-3-270.331662244757725281818098590*%i
-.349631422797127664445609882746e-3-146.013464653516664350551739679*%i
-.660239485109418447968416492357e-3-78.1594334086361022279662989272*%i
-.125872645033091013250766944299e-2-41.4396594033078321741026094443*%i
-.242419720782083051051991671155e-2-21.7490087103083460419443529218*%i
-.471957542689419677988372460731e-2-11.2929742995430469484858756341*%i
-.929510955781122801509749501092e-2-5.79971879017404894679305804172*%i
-.185340602916611530796058903421e-1-2.94926107109173555100196592316*%i
-.374483156549018862889822039244e-1-1.49534089524975550687745528825*%i
-.767464569592746613166264848062e-1-.779523156016367061784363983595*%i
-.159701767209777109630708052233-.467391432856515020342840888345*%i
-.337827855350511031483399526043-.413219701180031784208487756561*%i
-.727409818575025389404561927702-.607187054344563117097366071193*%i
-1.59656590989116095781954586200-1.19617729491816758944503403998*%i
-3.57780090577780374938133873401-2.61573596778930786182652422244*%i
-8.20063194498912548553711164487-5.96529156794341717462274056139*%i
-19.2644322200517344834034589050-13.9995156356084333375147766410*%i
-46.4868675752220401579240534161-33.7759768806524851042095210228*%i
-115.528120879893133849592143720-83.9366169101519587773198716547*%i
-296.552061114048195659422318708-215.457890025570668431285814588*%i
-788.906938958975213287832450391-573.174519822504672377760713830*%i
-2183.42115581711813807587270737-1586.34835466996450800580712296*%i
-6315.04737539832071300142101390-4588.15049449940768242253701551*%i
-19186.9847574097589389695842557-13940.1604137330698347057823708*%i
-61615.4477971563864516819439409-44766.2432077584551022980149142*%i
-210660.431075767094423374284359-153053.762144790286126187007190*%i
-773518.074489101799021167562663-561993.777297234236043020522110*%i
-3082742.34452560306775736708459-2239743.41618082584083909509209*%i
-13508638.9746226526030923749139-9814600.71053409296021112364998*%i
-66146297.2025944866209241926213-48058097.9877669302098344686684*%i
-369408097.140448289960989215354-268390692.762071226477281144878*%i
-2416065818.50745700938178400932-1755374567.60574925564387763754*%i
-19166473449.9647496395675717199-13925258073.2850199912057301716*%i
-193456915795.904766393405882018-140554676662.476881473985662548*%i
-2658441107979.00307810388103573-1931470523144.43746672506885630*%i
-54980501271729.9369223900397722-39945672384964.6274986671084407*%i
-2003778438514151.39769277205407-1455830252280706.14782311089305*%i
-168571102251330357.472537717997-122474074778331739.725683685690*%i
-55198181027450254689.2909881030-40103825984981256586.3268078661*%i
-243186364570713708463208.507336-176685236091639666862911.479816*%i
-.132499609133598052435113698256e31-962666009796465340378432264517.*%i
.373157811311998787192868084136e41
371142158256417849527464372.088
4749780928967139197389.24555973
4308151072030012528.09980658572
26193981917337080.4229699907313
469938958066476.983475162542908
16950784206023.8536155104051463
995790685181.238335786312430230
83812825198.7211249384227621123
9294223305.05727579347673148857
1281626735.71980788168552556771
210814007.012420363047887531835
40106134.6094727509510846282349
8618991.11730322440840743347330
2054213.73204360069478467929803
535086.441395491438579043097012
150541.486906170975777560558664
45303.7760927633884189827326092
14466.6587782515047693610861100
4868.90827177804670943055596008
1717.30730499384646459506281461
631.689791954193377420271425781
241.313376477841253823905136146
95.3908448777958749002728998114
38.8963144337988831442133389506
16.3149280145154465126800641125
7.02228842473223619783388158652
3.09494283636721495030655021998
1.39403908302741899318581870535
.640623900889447490979210529631
.299897081229476635787758574912
.142818566934585291509115634458
.691037593118551189414991756810e-1
.339340789757568516225590323323e-1
.168945282980866208280234425485e-1
.851981237223641522934793468921e-2
.434832368151957136226653766377e-2
.224433219535342190842778469742e-2
.117063003680278232304208541071e-2
.616649693153988336532164682583e-3
.327857765754591218622748168098e-3
.175842036200478532463113344177e-3
.950891116677476479003940814898e-4
.518211394823931942241912337625e-4
.284487712080962079561089784094e-4
.157262960897702208937692246316e-4
.875052714859558180832490527783e-5
.489932921704939004191935850027e-5
.275926773867464624264686725473e-5
.156269972339295185863594077124e-5
.889733720382287375400593620712e-6
.509135894102579738169536649371e-6
5289942.24723079271430670199776+1845855.59505475650999749356480*%i
-38207748.6665224012441600403690-56397682.8626411360450004959645*%i
423609798.694204874565981328938+518537049.080297875221035785472*%i
-3739503968.14912940975928605656-74086656.9581412653623694288002*%i
1212199735.70184887946710579530-7672962907.22489074912484015468*%i
4614138311.33686296705783924056+1100942162.66051569735282623866*%i
-717299590.037055421808846077286+699397460.308545489552802961140*%i
57838854.8414445289172804823943-94084681.3586186696122074681002*%i
-8076260.42625659147037887088237+4575232.88960071380478900961061*%i
617956.157701433846798315312214+426790.230556105924440728755760*%i
-48151107.7769779379255184243613-1580336.59606379143505559953403*%i
971069355.468837142858378456751+798782819.781028606738266748753*%i
-31737824860.7723195035482868410-9866446952.46697946883573438188*%i
66214774379.5254744471563000379-513113435061.139571508699963246*%i
589169651835.073239277392605169-1744767390388.92521783640770591*%i
291669487533.120741656925343438-718720737348.429929949395194735*%i
61466559160.1998883217561333945-4139562238.90080481640321114837*%i
-1859849004.04965306837250285195+1586585428.34102559938438075295*%i
88846241.5024137885610330534833-20810274.4374651771199338711352*%i
-2164330.65096124824985353191437-3490887.94350635929095074066122*%i
299703079.865934798123087191395+134450609.804889784601985880979*%i
-2904089027.33893254082326931778-21445012167.1066172219134017089*%i
1063832974814.73710533960784983+2323192224749.42328484859469816*%i
-21896278403049.6459168087088726+319632727036443.304495674032099*%i
2981206661261406.69089700163671-3770302715114909.27288915256233*%i
-542720456471413.634479300427146+484388370891494.778310435480200*%i
-4626193447660.78300777285357006+5172316972863.40082737035373791*%i
3369469829.56359948876121752830-53730715225.2658346654867247233*%i
-555137353.712089631674714894956+463673721.784988265733153015010*%i
10413417.3176341837296564569915+13911365.9511803163077800969711*%i
-101900111.628413690587517275482-1261094086.89743578584006580741*%i
-188257098850.302372394116129730-51096109080.8225193549350959407*%i
59193831675953.8957476063996743+125986097431846.828105210867764*%i
-607957460057023045.751561452470+909310848624594999.790233976690*%i
5231231427541728661887.23653654+1021649240778135948756.69743037*%i
-5305835761489549850.84071058398+6963987609271553671.13462780922*%i
-328599653733483.549493316450519+586665380791808.087681254620137*%i
533149018508.398544210347342034-329103906497.347905458268480334*%i
-1088808726.21947352253271489462-2972328267.89486398069737795912*%i
-42209605.5720158356603966099534-17596151.5835396910595189737173*%i
-881928382.579806988475956948028-1724765375.21306382993371710985*%i
-131545044464.971511412537301057-387076570478.028542974684235950*%i
-27634860854663.1804883607084507-656989114361660.705389399633494*%i
85714125265111504652.6921703938-89281607371947100538.3917537932*%i
.724878311451910204630882827875e37-.235302147326090935414718414068e37*%i
-2553675999862821244504.28986965-4543096094049774717665.72768368*%i
2369524185902099.22241959613252-3641129854596034.75259340742629*%i
1152489303551.24937197599513374-887288410139.135061127460600684*%i
4465353856.07394300262773684954-2397650562.48588598581773848456*%i
56776023.6320467714984722474853-23811957.8700995227687427245175*%i
-849018657.954387374064173653756+583267312.586905525276126125743*%i
-90781557588.2241125622904448493-103477103409.677429553932384972*%i
65933753457766.8875249126701206+23286476308698.7456846041031500*%i
193441155725146052.768315407618-55660572679534565.3364978066079*%i
125856916252636015796.144899959+23376080823233840308.2011482103*%i
-635225526035555133.363330379970+905614679050382666.193413888779*%i
-262835956580672.894989056139410+143578593044264.750614356488123*%i
343552867737.062959375862263395-246158038257.014984253962786670*%i
1372796006.04075613017228651611+2118172182.39577265227398208864*%i
-15847752.1019388066621159837992+36245593.1249445084884175520022*%i
217977589.109833728178162781634+77598064.2147978327762510643843*%i
-10655816779.1074510884428906281+6714608718.28119599339237230854*%i
1037976272651.51259614219967862-199933044942.814646350173083686*%i
51173014213815.4074481521589100-56866486528521.9260070384808411*%i
404333053391147.369475472525875+624635237261494.014442294938022*%i
-153984097962051.730037769870442-2909552213196.57958849076927716*%i
-2597770403888.78783961295281533+283995092921.943107829467953932*%i
24294112724.7878961481541756424+17092571839.0692268021178994828*%i
-492442213.168832680106493022535+44096994.1373088674773212823359*%i
-569168.017339623983434749729385-13416529.7665145545710120490686*%i
-26325437.5386050654343816772798-17539250.3900158326890961987431*%i
696710825.928812601860452686438-30859908.3525021831780248304372*%i
-13925682661.6633416907427377408-4302829237.07770033176217667950*%i
-48735233020.0214068819824729691+167332979964.313435842464188097*%i
149649411405.848993824937850608+514022408313.847626981287733149*%i
167667678748.332654736038845823+185127624049.158101435082578167*%i
22347640400.9677428181600925526-12513601931.7822052157585287115*%i
-1297870692.71313132783727044253-82267518.3111304007591186804016*%i
53669033.6939440349795348828225-22549528.6639672088679410598637*%i
91032.0900008832336860166661243+2964342.48727680117298567792960*%i
3575855.23967862570735661047523+568885.102106367964277318477708*%i
-33936681.8378093342973340721846+18634951.8324368975509073674974*%i
289708075.451893144155803547913-153254047.846970169172555157070*%i
-1555531952.33064027784225057631-359420851.599796620012109902423*%i
410603394.799255550328774402291+3078320933.39162443259458715503*%i
1793500914.12845506180308873602-846336082.425017362572595791713*%i
-438822312.180446925974175115881-184103269.221686610374683530463*%i
51801081.6306379957014481603853+32186445.4448199983959670670592*%i
-5858337.32462530842915261428892-135029.898662817505589163912537*%i
242302.687637957064734942520743-467853.486219862622727389003015*%i
-285583.908200079531370517406202+311547.830417884412587926068000*%i
-209050.980994222571303834245683-2645204.53333937751071630181014*%i
5379473.59113508293349166633724+11437016.5631318064447464007558*%i
-13876120.9186035731145031615839-35048490.0385521465219293625218*%i
2331326.78958182984129671393758+58591699.0090088167842143251478*%i
13901763.7970981563052668865056-41308130.5062101363097256792415*%i
-7265646.74441917384681793767391+14739194.8183723957809919828001*%i
696813.122518337292786179131352-3662200.96293265935722934823264*%i
319345.829457897357494458194394+530249.864450001199183985020655*%i
-87410.7999110806693372759865986+11938.8857974709698298642936266*%i
.785758358251348330423017529790e-6-22982.2392428611177724543528935*%i
.139072701974164117772690986951e-5-13130.1348876776827059866383528*%i
.247586624300068406042758848658e-5-7457.92307127631734589481334239*%i
.443491295688002213175542819658e-5-4210.13544419846109942064338922*%i
.799588267430821509822081127569e-5-2361.29697437992121194275102087*%i
.145155469428536413099825979509e-4-1315.27557469780511398959460245*%i
.265436737069593124279558454889e-4-727.305558293208080259742477380*%i
.489145633672642830254842736806e-4-399.079481720965065268792354995*%i
.908801670113222341924757448605e-4-217.188668419103719331002999983*%i
.170323696499238606355489798470e-3-117.172707615984113605485853272*%i
.322178158825161551007089635245e-3-62.6305799642714036893995480694*%i
.615450453395447539155413403893e-3-33.1483575398401146484884833025*%i
.118809240885921367611633009676e-2-17.3620487457537437166549395359*%i
.231941005612629473758985984552e-2-8.99553809963192336146143209315*%i
.458262277472142873905582717957e-2-4.61256521665556084385224001942*%i
.917131395659609922840535178006e-2-2.35055636164641416980769283018*%i
.186096479313371338613367539944e-1-1.21392895272705121651609488541*%i
.383251234546612056295889001664e-1-.685493278134415011489541563875*%i
.801981544726088118953761021395e-1-.520857255771718804831785376638*%i
.170738161661584967176923364517-.655514303582194238465578937084*%i
.370333743375157494482311986704-1.20032739400958707823929725764*%i
.819659582904095425068015209634-2.55028542893510172017519130406*%i
1.85444170103467879131176329055-5.71971752989404840944403203153*%i
4.29722195850278237798029468872-13.2308624091411016046641779853*%i
10.2216724209640538436666521689-31.4613529846215845810631828488*%i
25.0212081127856612586829627443-77.0083002627805232735446338225*%i
63.2106534501428122629732258141-194.542762894074310116965818243*%i
165.344947485757822828482427749-508.879567588619801528903382202*%i
449.518979174911073455667602006-1383.47721554718857644347696249*%i
1275.73037395401739068247534879-3926.29438886564373166827042722*%i
3798.71886483659175594817570885-11691.2545191200516342111679889*%i
11939.4980521296041749838782063-36745.9965992445884603316354053*%i
39892.7844396269789283855937663-122777.365922544835446148459948*%i
142910.241801337338981763983350-439832.498485885969994162734906*%i
554598.756805784155506841578334-1706879.46355906938777298730270*%i
2361281.92185545168594630650731-7267278.49752407758269580705999*%i
11205502.3943930099841503075692-34486990.2450012526351424487854*%i
60468060.9558905810815676336856-186101555.728854158421627202485*%i
380785541.776634667929889024903-1171937393.12030821066489451289*%i
2896001155.95690711255690820055-8912975081.32907655819248441491*%i
27875007589.9985329851612040520-85790451958.3737207494029536590*%i
362823002402.965399385108189068-1116654381404.10401537006586852*%i
7044479216013.07280647107860665-21680677711096.6699052004096938*%i
238088754296239.579173477169490-732761839484100.438134156626476*%i
18243271425453325.3108665005429-56147016130337417.4624832863487*%i
5284787459176162422.34392096154-16264903360576711654.1673495615*%i
19485718936191828166650.8193260-59970876379941681567530.0797546*%i
76345417281613601826302435792.7-234967033906397269285335587991.*%i
.338911594792721051414196300878e40
66925445172063706989289726.9429
1088108408788651588874.48776579
1144918971975423019.35223594136
7753538580885485.57256921124477
151379350560450.975815076551354
5853286217214.19268235664315866
364727113298.426185202783346791
32306590618.4342507318569896413
3747492147.53628079074148041188
537945266.609440721921456250764
91751327.6777046781081520075292
18039912.3892802696129330703316
3995623.21010349730344198380735
979137.273634046973733189010115
261694.157827053467238669762992
75407.0001223144207480881146629
23204.9058757102526562891848722
7566.31174857493906935690790920
2596.94589784945348143972051590
933.026369255072909781643934783
349.229127281779602460683422362
135.623622693641043355782805501
54.4540235266198518896292116766
22.5348192374683247812359631465
9.58591425158581671221050270215
4.18152326033587100783483806904
1.86656186078507268968966654806
.851029251289909388372937915752
.395654265755217010071120807890
.187286879576045601302993937576
.901437802164982954604491459196e-1
.440631353580050670342412911419e-1
.218499772787670136800728002229e-1
.109807420071249875881432981508e-1
.558760705787354602238419023022e-2
.287658120470045326036839580201e-2
.149712514147468922306252362628e-2
.787176140270759334792255277474e-3
.417873140558556478741894180774e-3
.223833058967395887682206029684e-3
.120914864516333019483422599788e-3
.658411300009484599332231312773e-4
.361226540433265292721555625383e-4
.199592498351881535952472592663e-4
.111025239223319846637351854108e-4
.621519942869001007831627409683e-5
.350024343530606037802127182054e-5
.198250986023178469772967139938e-5
.112896305572239534579820380721e-5
.646209276414380493196781735104e-6
.371693801860693803566118396938e-6
2157475.56153044405498432136153-1563165.29802520882739420728832*%i
-30785263.0181795031291373581551-2173345.58658983386028578177542*%i
289516637.188828829630693648718+15788880.1408152326840398954145*%i
-1175028410.16142413662834883354+1033387438.07422197319251719938*%i
-1484885035.06113624362098699727-2837309863.03938128581450377235*%i
1886305151.66849453087509641921-585612766.771069301520460208671*%i
-149984166.216737153161059046283+403373805.585285722660907497669*%i
9168316.56433763357861730505971-48706686.9208503804967717611046*%i
-2982870.85427479810334182637525+3195422.79644659061658913516126*%i
348819.111358996253005697001153+126358.218159343533121796984547*%i
-12049993.9256658857455818987048+18164954.8733765559108112361917*%i
513423038.455552664832030694336-143880716.116288936229533875098*%i
-11020865815.8932989277606546054+7245531790.34347326866038929824*%i
-116996122918.310930665945703452-154830879578.382908786947392998*%i
-209519079638.194006161197858843-639427370429.298106032180065670*%i
-34745779953.1158393573540923800-286423161393.090864630978927802*%i
21632009386.4559024777692004136-10716480531.1308387533508992938*%i
-539688428.678439285692528722619+868925861.681402904698543240106*%i
36189100.5661381814841526006843-18779211.4086919294597470377801*%i
-1343054.70449714072394079916398-1413215.67641404329474397671947*%i
111858975.702356994130919702726-87933915.7429006127082562812542*%i
-7947316023.55595074436780572477-3320381948.97561234362546377828*%i
907492944589.567270763910301760+161711580224.085343284727284877*%i
72834792480057.4718694272493406+74933369949480.3463443413242271*%i
28987998217161.7693017870513838-1480797891230270.11260444459452*%i
-89073364086226.5980560824592261+215545426811692.028213011037655*%i
-995092951795.984458178523215191+2240965796150.35913731044144351*%i
-3472256446.88822319984416090958-20742547139.2788337809018321028*%i
-198256314.604966251243186946145+236220909.454296568832034580101*%i
5637898.08601542766240403984949+5644275.59645330333413884998736*%i
-505079278.742484322341659559840-166077427.027996757437249108553*%i
-47107906761.8146589993266824661+57024724294.0484924793774338935*%i
46013718940554.3499497647046849+1642177084888.68085658084083466*%i
114893531291433762.410712682582+276633268665189593.343707378312*%i
1081629541185750452842.00568538-562790908860492109875.882305821*%i
-759575481891123502.388618908537+2164935473214031842.32595076309*%i
-70692966357126.0271963439332856+203252140741299.807736285813171*%i
181531070978.176329330451948859-144335496228.533926618645082218*%i
-555804906.514810261012522959839-1181614803.40020397976817338634*%i
-19459952.6309454407938983335854-6556884.02141318227780616644793*%i
563908382.811222280766792000501-576376696.634542382516708163727*%i
121007755122.513820073163151216-92845118507.7786890367576931399*%i
195710645712319.064948920634913-77058736160291.1512368367542000*%i
28037902451851914115.2241895224+12341884492326925305.6137633542*%i
.670795482191824858202029776074e36+.487656013895682249879771937005e36*%i
-537395646679283839127.822026876-1063511857528616032850.81689845*%i
751694692378965.351929559286498-1103892735832715.04399629103040*%i
423172400448.675509907502217798-316720765680.031638239695492755*%i
1832539190.40155640589734167036-960461938.325951738151080281137*%i
25405611.0990428276315546079612-10420983.0400380819810888251439*%i
-370131377.363756126989356101181-228279376.497655089321211040808*%i
20591814010.6334563796507012930-48398589051.1828478523438159414*%i
3883354317939.24559040839967533+23152781397859.8200436396839189*%i
45046416695839533.3218680102425+35184210937557259.4960001630839*%i
20967851582835271711.9682553996+23786544416297228777.8999268229*%i
-249098729285658737.675911137561+172519182017405742.858879096668*%i
-93423004481978.4746818774559715+28020652853730.8395847005249286*%i
140056421519.592688192289744881-72687682065.6712905314662655879*%i
471849323.792379792916043362813+934099551.412321246245730007765*%i
-8501166.29044859106717176521631+15664178.5085508869504228593025*%i
15707012.4401748689406239685155+99791376.2028886604261063523282*%i
-4545174382.39493049007215631513-2253797604.51795152621981205793*%i
283108991945.413205163095856485+266419697433.231582700385376839*%i
25734240801703.3012278665078313-391691639991.964270570161722249*%i
-17410002588505.8259014377679006+238047686626184.126362632995762*%i
-45195704906395.6778751346989279-23760943896199.9995492644203492*%i
-919935134169.958053932986440851-208296861226.200537952064001671*%i
7671695613.43223434698493624611+8909727797.49503167708831074555*%i
-211482469.730904135484132838444-21887154.0245248615070487248660*%i
700785.237123680857344607995759-6161880.06874581984879045450638*%i
327136.815672690941354266387646-14447803.0079746234750319452878*%i
185247048.516514204576079433292+235567848.728919565992502241143*%i
-2295976795.35107140345338450556-5424833172.70332551276459724610*%i
-58091123376.8350957620155162462+33293739723.7179535922943376582*%i
-70444969824.7035843306092492655+188225971228.555507947622664067*%i
21017721384.6310459999931459962+92899491898.7623428788853769074*%i
10176036904.1551885218052830505-1082071983.36964270175318665287*%i
-511505521.454687722120217673186-207256067.555572463514599532696*%i
26033023.6838366877392988693211-3583796.14248889641378894318091*%i
-261616.621222738751150425073310+1394113.85784587170359515881683*%i
771813.394873948191537394709830+1558872.79543296810274151476751*%i
-16411650.7043617749256300339914-6812689.87123591617228789528987*%i
136137226.300065735912452495568+47671763.2081928403360228507799*%i
-388640026.630711792646220379242-559007954.112886326192019569904*%i
-633103475.447880135313694973362+1143223165.96499871553717629357*%i
837970394.704035377061402703553+82798625.4262206238097529053129*%i
-137710169.253706456196035522999-155741191.097829472663047177462*%i
16581536.1186788251357321053845+22243031.6323269459487359482929*%i
-2632609.87111047450060641055910-921966.844185911891807371101908*%i
177739.274214696706747857616746-193145.715448866391697816195893*%i
-212923.895018940043311607288343-17946.2394168044282034161708485*%i
910521.081267073882026124454565-923063.769556579942313318980998*%i
-2068601.07076266119245805171357+5627905.77033391286895710973503*%i
5843133.20389427036671179795852-16508323.9016036963935764800371*%i
-15178070.1045590737677160608528+22341376.7578552457901461504220*%i
15560922.2782189720909295414865-12866289.4820441081692686881763*%i
-6250378.24187043528686590625668+4593531.13319408730712871370193*%i
1021303.00826815780369930942320-1494307.26697290783388418647862*%i
58096.9579444636561120142431229+305284.702351483869538500916354*%i
-45227.2017950654375991388329040-7777.58160131595457343633054264*%i
.183332296199735926939990541332e-5-32201.9229968176592465284199290*%i
.322646349894802636532356175922e-5-18506.4945647097898180147032022*%i
.571037694827283727697233217314e-5-10576.0364460954425870751856222*%i
.101669160724734333757172940934e-4-6008.13621976195784354988829420*%i
.182157304458638598481747403089e-4-3391.76602144056563585878674916*%i
.328544748494880741444003136389e-4-1902.04635641984607575010926732*%i
.596764663643708254694682708852e-4-1059.13835958219646120837992215*%i
.109208372739096169937091290296e-3-585.375040839490572538621825098*%i
.201442761174413761136268680955e-3-320.969631263826762242181577555*%i
.374718798040428769441770271164e-3-174.511276299963505975402499808*%i
.703316686886133296048519966195e-3-94.0320426344796421774019167989*%i
.133272917500581256305191326346e-2-50.1837946706523289905278805252*%i
.255126178697644144161946893229e-2-26.5097667544143529794845807752*%i
.493733030294549511066737607008e-2-13.8515091020777699406567504403*%i
.966681945279817660008173306741e-2-7.15323495872055290741909911328*%i
.191642277670743481578708111835e-1-3.64800570179680355166137500906*%i
.385046480476206029568728226294e-1-1.83549628515067204480017663449*%i
.784851309816776404173511461343e-1-.910234234882149174587179162339*%i
.162479343194016991087223819847-.444390778803131928990922252756*%i
.342043867266492436351411271098-.213327696696354561885023211696*%i
.733220093483560730492509317436-.100553686102931199232512451387*%i
1.60295120474722877376777507169-.464672299750345862913541579006e-1*%i
3.58000080772008721292933237520-.210157012361955650677575602449e-1*%i
8.18385392453348810175877428613-.928427080214395126257874542060e-2*%i
19.1905003215042414151736627919-.399769905584041003160152065273e-2*%i
46.2738144813721976046550496692-.167362067881080713272397537646e-2*%i
115.058692737688477935480484605-.679308456352375102784756637681e-3*%i
295.957089068609375485074872567-.266466631845901678545735187771e-3*%i
790.430073037732117682448283157-.100641462801520242849876606730e-3*%i
2201.29183232594388500034647732-.364424759865757887994241526347e-4*%i
6424.43245696959189643114479073-.125882293679003380238803913018e-4*%i
19764.2153308300534647166436075-.412377598985992232372512418935e-5*%i
64540.3989767120398653991662834-.127224877373678557254027380664e-5*%i
225584.849202549650148739539879-.366580345827656798076445440422e-6*%i
852512.620495707274864367704213-.976546062027071108207111476161e-7*%i
3526871.40558285267314086962847-.237547353477470283778092589454e-7*%i
16221332.7668351261705928562267-.519546446419482916403767685069e-8*%i
84585796.6549638218614575447735-.100184980910399911585304373897e-8*%i
512890515.889941321997784513314-.166064249982538042647058053616e-9*%i
3739786745.16962157442264712936-.228802216651122495030750077005e-10*%i
34328480856.8537400654272690034-.250298660738460606765380373548e-11*%i
423240121492.387366198721467687-.203763728890263690851524862275e-12*%i
7714837407024.07562118682699525-.112144337514798591308851658139e-13*%i
241811623468837.278935802330122-.358759166015562099672996094839e-15*%i
16876436721226340.7756979609486-.515178248193267817928353737765e-17*%i
4325097799636060960.10263141834-.201362928554768767997228314030e-19*%i
13346405892568816469044.9477448-.653318691262114400038938672946e-23*%i
37603205322824882977639075882.9-.232035094400995068052456917716e-29*%i
.310571457073971168485151997211e39
12176483255803486528542791.9445
251504973453104002428.080102722
306992957521449698.184609080415
2315581484511798.36914512171137
49197525109956.1711109373477365
2039148450289.74649395544340275
134769882513.016711477550470361
12562623993.6265433428679494963
1524259393.31010159094709121952
227764128.053339768588539749294
40278610.3758953403826450090924
8184350.69662174691844847050220
1868161.04327691649653688959557
470670.924603962437683906997667
129066.290008698906361707605565
38087.9483468029049667413653101
11984.4017627888307777118081122
3989.89166724257890871153920703
1396.44547687348988345645450512
511.019806463404115437879016162
194.617754933564750044365948995
76.8283671591461457800767728393
31.3293950297608722500126438144
13.1572309230168942195002804553
5.67560841783812941148482190350
2.50891727581844410296833862110
1.13420980591205297434230989468
.523408107069031629690786052279
.246161479105355359535624277648
.117814595441138593503553956783
.573071272027151828285704830082e-1
.282967225318209781920841104491e-1
.141683183521667338741030893324e-1
.718679486215229423462540402157e-2
.368982174611764019345997772778e-2
.191593651012807282756278348505e-2
.100541425040275889103853219850e-2
.532852135840555559589899644274e-3
.285036057798977864229574432824e-3
.153808241756816717607787406984e-3
.836798462683111483599099779885e-4
.458792055281661700201122668484e-4
.253380267799532577667770519561e-4
.140900999187700328139858037839e-4
.788633564504899823033512422480e-5
.444123458307512350369108449682e-5
.251569280000556680610818573613e-5
.143286395643607948412905798398e-5
.820394607547523762992061628536e-6
.472059134929769599458091560923e-6
.272909490586020639319416494429e-6
-24813.9426243290986738218283261-1277962.23902450364610479585478*%i
-9471467.31587004997190776368872+10456098.4378035200081847357401*%i
90331909.3697095354303244779257-88847991.0373713973856371258512*%i
-71312075.1191780063339529289609+656820111.151205325915862862630*%i
-1199814459.54843123638188803692-579282811.133333924059056578185*%i
556336140.628115722779611678864-615877271.311142947589965987776*%i
15992066.7695930132043118446131+185871155.830731178332031346063*%i
-3989849.26791444279323675356142-22085716.1339310107615723889940*%i
-898004.674495383729673308550785+1872833.19118167324718765247089*%i
184116.562722848304647545982839+16839.9688291915873051018163116*%i
4170677.53796857270095453735443+9033754.54850552473574496991543*%i
75154526.6496766273585531900443-215394940.366169342096910458042*%i
-558939687.169431444116819614119+5251604287.55430932985143583311*%i
-72649623242.1131327222366299022-10843228662.1762544622012324682*%i
-203091463611.935551888815183169-142503659014.036292737673949789*%i
-63529838762.3388772616128736924-87708676536.5889017706639795780*%i
6281902554.20922273780398815224-7187105980.75405282869638513426*%i
-105711429.685751966137658450323+418693096.014802198609475272366*%i
13732592.7992947932991362865656-12213721.3853404716840304750197*%i
-767096.004117396144403909367804-531907.842326762622803421439237*%i
-11348178.6449405237873295234171-61128059.5651435790889924087485*%i
-2763949825.41050788056946056260+2078822099.21697112503053835758*%i
236436563484.756650755758899602-238054283456.598897719163155955*%i
34363686917181.9670672536114143-1377354458767.89527284449878833*%i
-271267905274885.679085725993920-372122909212703.781017801885191*%i
4398436406783.29195199014915207+75319922837425.6106138079743624*%i
-92637988644.4863558203568837150+869237045882.039791075893932795*%i
-3183421939.64772068650692283368-7653270248.80383554032868772661*%i
-66110604.2640083231115894033577+114995411.776051333335330911417*%i
2954379.72304613270803656817370+2217901.36219951867303780639877*%i
-147915925.183042312862538191613+170056066.167419394939787641958*%i
12434509422.1415714508498542835+25415814469.2711318940300486135*%i
7508146926432.09473131010352366-13406272063678.2764979474809401*%i
81210984138741625.2552171269980+15966782471899208.8675861914599*%i
114339331192281284457.433224356-257152406669005944077.863522543*%i
-14451067944340841.0258864660608+606474230837890174.761899085471*%i
-10995922463505.2606826714114457+68608337740486.3325213390222017*%i
60933982265.6996452238821625968-61544886455.4867459420045234223*%i
-273811243.536081882762755580665-469356340.031257412340519666092*%i
-8999626.20665209206491267863821-2347321.34554451239161164826276*%i
304750215.170583008607601887196+147517906.892163149467551527145*%i
47717436774.9024183060009770459+31913731389.5494068238546744928*%i
44150164610161.5774252460284782+51558330308395.8868691007972295*%i
-491679279931376386.232289979165+7634511208573171864.21101681473*%i
-.267811705916891167933439856000e32+.910559774080180639134717782400e35*%i
-113008563768484992487.600815646-250577621938030305378.366968631*%i
240257138688070.833242272739294-337441938022908.591066064567098*%i
156710022859.245733298180473403-113997799115.890862913797664819*%i
758538606.459632070240352537705-387941831.738514173061831010259*%i
11465505.6777747511825872923835-4598143.55055283819874150435853*%i
25212274.7662908457113664710855-183470353.368049393842279371864*%i
20253371549.0708821521074411620-933013019.975015358118500326961*%i
-6224151189238.82187052270112101+4949339921365.97114466650776755*%i
-582688178465544.025415401195061+16366201014625676.8363307753764*%i
458157679720507442.683869181432+7911906427087434327.62416308660*%i
-81092445535014924.6303713594357+20910946842179804.6835796869389*%i
-31937414798779.8322117915908286+2653080029181.38221778043742508*%i
56116401302.3219921987893920556-19586913215.3131967209662137155*%i
154424116.582628485956621562079+409543435.389981438177007698605*%i
-4452824.78937138917963364843993+6764937.58997827316313260679423*%i
-35312210.5555365912711546063070+27067668.2345570497412601041305*%i
-180478514.083890115329928242227-2053792614.00112632305631961684*%i
-18657522564.9204550810179401137+143044033339.436121947868416520*%i
6038720768740.32765768925796830+6314008123753.85394353242578801*%i
-50971030247174.3191278741349536+58056428933931.9422983143125670*%i
-9948735339135.62852130627035824-13885528529656.9105454705301425*%i
-292105852176.672466710852419714-180747787399.889592369643096667*%i
2102290043.80201552666100825228+4198290256.39128209613233351372*%i
-88241441.1393479333983082614748-26845264.1487528317455876413515*%i
766660.034424826708265738528590-2785291.68962000650576583441841*%i
5705701.78738862331030556966221-3436202.74975532898587429109509*%i
-36229933.6295156905346201280983+124778249.303858566538466059622*%i
1089197540.86355544444316242278-2141202651.65754139376930502049*%i
-25171188749.3118620395976060276-6337317675.27897571372944414453*%i
-64047461048.0707280316512444360+41164928260.7637098136325859467*%i
-10511414721.8790927895754991422+35113209883.8155583383977080714*%i
3943453429.97772291261901520056+1212910445.70910293265095960145*%i
-179774915.552609391617519360086-153389292.248855581928797264410*%i
11876128.9889861607082621990475+1477838.19612657220462269164682*%i
-267297.214299072309403014850105+629974.933067117149547657807540*%i
-399825.841299553093487593259415+742291.000616727060624077360093*%i
-2284578.67597308873174972997542-7906016.68568544350050214689591*%i
25552870.5165442503048850896819+58746607.3639850952793021655479*%i
37646226.0259175253575876240436-290588456.215587658835115453971*%i
-505231724.298480776108530812238+229686408.410865979671990173133*%i
289905943.088771436292271077030+214841418.804255495826112305154*%i
-24866777.7667200231759860755594-88216043.3570194054826680837289*%i
3356943.15203664428004856735061+12285127.6607386457630208576865*%i
-1066338.00238469418449759252340-810960.086258973252254219281638*%i
111662.779842042770345449749156-70237.0929597623920264921596843*%i
-59110.9864831064316041549676984-91592.2097824638112940796042475*%i
637993.799294024401532085102749+41981.3447499014374180453167339*%i
-2614070.78151175833865247070590+1187213.90656738380417680128275*%i
7153674.24708084568178778893949-4031977.46880206199800304685510*%i
-11849413.6954914560887813846364+4158511.85118931859402457349622*%i
9354755.73605368103248817729500-1278023.50639086706687130795492*%i
-3651249.23441043904349267664804+570846.070449544505838682608547*%i
751306.016096585256880075885172-471273.523244121908566447108870*%i
-25910.7262809772049670795276885+155288.142092668632115471297867*%i
-21411.1166380992705668909588939-11027.2523322703453206671262395*%i
.410922604671091147600822150081e-6-44849.4123697722923360803223595*%i
.719139968128867576347073979305e-6-25926.0183663819222275135665608*%i
.126542192873799867661999659600e-5-14905.8090606270746750095801569*%i
.223953564090060197334427435509e-5-8520.82496398701765740895847686*%i
.398770879300509469854212038574e-5-4841.38525112150427910264948997*%i
.714635888751981661357744098101e-5-2733.15317556814407337279438712*%i
.128945818554945831857108180958e-4-1532.48712890533738480993771207*%i
.234352250704636353507262898123e-4-853.074566157101865627838369975*%i
.429203642275009881311053474490e-4-471.235897279639336005187998520*%i
.792499877661877692710239014421e-4-258.189401141013058258715394469*%i
.147605849256334326545981072076e-3-140.234900806270882202102356735*%i
.277474697168164069101140108032e-3-75.4638677200899047898850219489*%i
.526778058437160144108075496845e-3-40.2075594681110253696379042110*%i
.101067181793195494197178775357e-2-21.1953032368014413161603219446*%i
.196106586471938722017906470723e-2-11.0437182524732671562099164860*%i
.385146668390965271629150261317e-2-5.67819333510718953876722854226*%i
.766301015631752247631673339589e-2-2.86843244771879857954979584150*%i
.154610432974833723739001653950e-1-1.40177294158605565442061806079*%i
.316676601052396677951031048432e-1-.617959390168292783383015795805*%i
.659255215526844901435232761925e-1-.144505321913723430414315999046*%i
.139679451031428797402472876088+.264158689463590347960247217254*%i
.301648140449438608540302012928+.850821778753985898885331749932*%i
.665093954570515099068048067224+2.01140710569344063771583254360*%i
1.50000971830040606627303941365+4.60063494251039310485241028721*%i
3.46778917850810471477945563069+10.6658021644155603230850281564*%i
8.23758620995178857543377205548+25.3497266614873892707055816421*%i
20.1614337238712221063217838864+62.0492929956165147276335318026*%i
51.0004555553662873295938709025+156.962775802807036639170868190*%i
133.819817632592924131511447114+411.854862530181171314892800778*%i
365.738998051264304796866387600+1125.62882413162128807257253829*%i
1046.26059121019819668941083139+3220.05897281310246626530999223*%i
3150.73752438743316914863055403+9696.97300061613396258371251953*%i
10056.3115274700625536135441527+30950.1444302266038644562218491*%i
34296.9725830021885694168065191+105555.227892896628595859432149*%i
126226.427277904807815197546054+388484.997189448949868452939129*%i
507441.359921788814705689528630+1561743.91951305978236562896609*%i
2262151.17376348175015784323427+6962185.42609353204861126027990*%i
11399153.1326624238191891271515+35082985.9341348567933655581542*%i
66557160.8495932155160521050270+204841878.227918341040962455283*%i
465308736.013367030538611049347+1432073036.53216566100121708290*%i
4073417239.08554369598566500622+12536689176.7794509990607727529*%i
47572944820.9787226690623821081+146414469090.472947436026624249*%i
814142143820.708968878740150934+2505671872957.56345406679399528*%i
23665913024047.3373643860091898+72836190906331.9070974526414484*%i
1504445968434048.69158185711056+4630208589619152.60328909512084*%i
341106396901580342.094773732020+1049817542169161684.84340718649*%i
880933539101641376632.472803239+2711234650638654034705.62881663*%i
1784845880572081425178926015.92+5493190783031763457730501639.89*%i
.287214626814246430369634141143e38
2235736792558406552229910.54776
58665814083172659065.6308740168
83069149664560697.0949067404540
697861350298667.604834093568563
16134586860634.5584094587188863
716840802208.005723316747789676
50248966278.8097331567587163054
4929032969.01031214067296148302
625532460.382626506474842816726
97293588.1826760501338748535556
17838788.0156766424753498183768
3745745.10132738999299671939337
881093.878299355560412543731429
228213.709278903195925546760051
64202.7120241049444513385044028
19402.3898469009400859039174859
6241.85308583089383566011361328
2121.61483625388637138177847377
757.147867431896702358344007226
282.191222216834107303641649985
109.340754873615930029082177569
43.8733274092346333250451093473
18.1690148467089770259602668536
7.74277252808420700952659141742
3.38670089291871553038391162606
1.51700644792178110493532042493
.694476001125017077538047905209
.324349123044686634847283260131
.154299360701773240122833365575
.746610570617690312313002434989e-1
.366985067614627967729430782038e-1
.183032192599916357933346013563e-1
.925294816290174832793779159944e-2
.473693505853421872977174036556e-2
.245362339276548250034737442119e-2
.128491153411419724763812196429e-2
.679805338363542833422984951581e-3
.363127717471966624613128438507e-3
.195721576666079978856044768489e-3
.106386023737637757937052694893e-3
.582878551750550737967040210093e-4
.321749114792756794321814237916e-4
.178861161870005964845565444256e-4
.100092546540406078836382954103e-4
.563656775665728040740129065300e-5
.319305844265323778641558701868e-5
.181903266950156007090567668516e-5
.104180772823661290616240648436e-5
.599692771818374145612334803268e-6
.346859000655430418441299684172e-6
.201537633470891419254723457798e-6
-515006.121440577102975505171624-343084.801983000358516560291980*%i
1098800.41385525825995904514299+6415561.61052739687723634714387*%i
-2134428.91576878292918417608601-55845188.2305283900747610994135*%i
166639956.845309738700672192333+226972455.770929567211683991139*%i
-549579254.468143755215838449217+105159571.893359669494565270450*%i
69815837.4674901522559983731077-345041548.323974874790187780153*%i
41081998.7267830870826731691923+70538824.8992633877493195777449*%i
-5301078.68245846398085270442148-8781147.02821374347706225669223*%i
-142611.081517279728250096994620+985629.209066323748292994101865*%i
91707.8543242815261428461239753-15227.0521438160382828055293365*%i
4549986.65825400952882657448186+547117.179161454091148469843471*%i
-57745865.9967252288117491188694-79794987.6019302264889028068586*%i
1496960460.31532487211223612810+1521260905.25262053792470893317*%i
-22716038380.6868381462324107495+16475250330.2891449904641728213*%i
-92287911982.7541839562824076637+2812826165.35428654547664035480*%i
-37158933675.4743767656800382380-17397091702.5454102808019687679*%i
1219713373.98369207792729313438-3608750380.10257241675896546464*%i
11196160.9810404317896574834268+183637260.655565979604813894916*%i
4692080.39043515272013577658921-6918123.24176186393093401270652*%i
-414949.102981267212533921030011-176487.999823000096510805358731*%i
-26195319.0743359035527223217229-8070697.03339244326569782202519*%i
160597135.811812351698756212816+1392072281.53544657001741992224*%i
-22463319251.3845600249955237577-121178588436.261298019332649902*%i
7279930132257.44421394992515142-8802479535817.70915141624539811*%i
-138411799843173.496516625868999-41515035528269.5476522781884494*%i
11992403166294.5971116424660537+21516376909329.7224947522101806*%i
64155919403.3658491709370502979+307897990023.211594390550696514*%i
-1921719592.36754071453232281618-2678573205.68745292158822455520*%i
-19495554.0707835409295412526224+54163579.0983697391415971561123*%i
1512724.35593917146431391707528+830782.366279756654333507292312*%i
42519841.5753325665249270682302+86510874.1833779532645710982835*%i
10916644268.1339507550802933297-324889739.752888494708100593549*%i
-2859492926665.21534293215050226-4312756394400.41874850685903427*%i
16261495372781587.1979899684399-16376229519861928.7119177895093*%i
-16488831787405354096.3297755742-63446550834307820456.9960966155*%i
46252352812903155.4868180090932+155129432686283330.228422631585*%i
380978948477.875311594032217078+22637307072232.0114186233187868*%i
20056819515.4733106706542725289-25744327184.9359995801124495185*%i
-131897118.911975614927227994838-186152350.649537374559527877800*%i
-4176821.60193749507025786192673-783427.893483758326440940846508*%i
-18192514.7799879182754596207985+142273697.408608395580337931851*%i
-5660271609.06553744861389889496+21053752462.2958032568797993187*%i
-11167297031050.3065251058215737+19076922007357.5861028547473126*%i
-1849709129937180840.14358821848+543993333131299234.186374351407*%i
-.816425177602359177642933243870e34+.592791975777007624886495898050e34*%i
-23705530919063204068.7646313192-59440762651563536013.3675747379*%i
77390524715246.4143491335063388-104023593362691.452759530872211*%i
58541330444.3323301053901426621-41381078990.6248075444240859343*%i
316746370.570896248654617021641-158023089.755330977445033219377*%i
5219564.83962586023365660203569-2045924.47628460200570116520839*%i
76487203.1707437404153438035025-21943290.5087148046380606338517*%i
3740799935.71881489884914217162+6942466685.31265444022629378586*%i
-2510515015401.44991729737248458-1042119018927.67110285888413565*%i
-3929690054240001.81222504052768+2641818898824029.02521614369156*%i
-1139946449081573589.72925572924+1642117688423029321.79634071345*%i
-23239297811273767.9592286305447-2354163634563644.67864329690612*%i
-10542584647809.3323952707910352-1330796246881.63406434104967859*%i
22171316989.7219174757105321948-4333389869.24359703651664959935*%i
46327930.7975773884939939151734+178793903.448388803344262268347*%i
-2296507.85020142249264003670650+2917361.65047250711139439317015*%i
-18060211.3559329432647829804301-8047631.26306324217001620043525*%i
680443321.789383241598291890781-501803313.725584890630627143788*%i
-47523665694.4497810961147131905+25684930215.2591880092400278953*%i
-179068175415.725542496156048100+2987883194653.10143581419527094*%i
-24720614108391.9648747183638791+5083005050532.01610062123134746*%i
-900000627112.534539255018259551-5696591784155.13401472405194933*%i
-79910850393.1971059173418833367-97739080975.2937784905834941440*%i
408872259.127817392180851717779+1847377989.05218496920069154824*%i
-35673956.2935278019202522352044-18903594.2893411956882064438579*%i
558127.770437118847361388469456-1237615.57939293483584848248428*%i
2769411.78369934063374223070748+1387390.13896780480180617723941*%i
-53616124.0764206044376523602629+18901570.2711979682689142089148*%i
962943906.089713530498008941280-224513283.890060157520241879734*%i
-5368841775.04763230875006390823-8621428386.95197773263094608327*%i
-29040178653.1358921924722440419-2041948058.52582756259244243587*%i
-10253359426.0318132077384299193+9876147452.60956103157947717109*%i
1281286585.97545857649793228310+1084751914.39876041196979170966*%i
-52795279.0013695006192006212398-87414578.8141523325829996089667*%i
5099152.95379989200717782008929+2060513.08560722698910862015848*%i
-192622.543699219981830231834211+271764.022539224099071372626230*%i
-409308.488277840877179674003761+50338.9780544662517763701297526*%i
2219804.90870015724794495300895-3141474.47438994040174087052461*%i
-11545348.5662263316478681990554+26296873.0623624991444785220608*%i
96916397.9254350409029067807817-82538381.5516639515024414415056*%i
-232619497.096898999562618106644-49992780.8620258595269334536294*%i
59903859.2581791097770243342346+144134564.146620775163157069993*%i
7071061.00550254108652698747913-40169536.9853082482631084072277*%i
-628450.012191285961554296319190+5866966.68493659521697786352041*%i
-370792.853035270291558846451323-533025.550885793269598432509346*%i
63971.7706608103404374745413769-19555.0566057191511188132860908*%i
18780.4630413396309125594377949-52891.7420917167755351475323329*%i
191738.866333517806966577550128+254018.070030014985516317960696*%i
-1295735.00246415977235842357497-497116.474174173694181672317363*%i
3806777.10148148069342842663368+788863.135030419840382260586485*%i
-5633466.83976990110935414907513-1736674.66620151344526421753502*%i
4071645.49600529241099207988300+1814193.09173569368503138449515*%i
-1685477.52792336355678880347019-564627.362014658079926311983008*%i
433762.132282348453744879221284-65440.4288882120886255256774482*%i
-39861.0535078893198723395477948+69936.0350357322706285282506744*%i
-9066.53273356835968416589158488-8970.69030405073824344016402728*%i
-.785065379816369409344648616103e-6-62085.3792163308854289952768705*%i
-.136633273753881131837191051038e-5-36097.3545101713695639845508765*%i
-.239053132915345712153761271567e-5-20877.8598482901919232266485361*%i
-.420579244708079322784806014134e-5-12008.5595848697806892105974575*%i
-.744311098380950535550501361261e-5-6866.73165407128603527455516207*%i
-.132544862922643519303614021264e-4-3902.22671896583020493729080157*%i
-.237592786835770703970286989012e-4-2203.00420520095099975846512115*%i
-.428882812894806841347306630869e-4-1235.04449020792342165457817099*%i
-.779949341530917995938207198293e-4-687.264518549824704286200045644*%i
-.142961654557649344486791300648e-3-379.431080169493589446150211539*%i
-.264252218393107021723480684587e-3-207.723384049888355359553338415*%i
-.492837197544602801736336312164e-3-112.703466010548530019203786145*%i
-.927973339845482275754399989905e-3-60.5649469102697488222736404704*%i
-.176522553743260287907355057448e-2-32.2137514799989087647237468188*%i
-.339476757619690159871502133535e-2-16.9455515119984152911196304412*%i
-.660553143311650431954100108267e-2-8.80689872310585444207333050669*%i
-.130157797552138850230667769900e-1-4.51429484770510388007912916685*%i
-.259963698902146326186569246908e-1-2.27206218058167122973483775068*%i
-.526859010401127435811605969089e-1-1.10498219890655300047742189431*%i
-.108473631492414394098815586269-.482719526371570613486230339406*%i
-.227178796747388077710315351464-.106043415994676899069228750333*%i
-.484681432169415465896620578060+.223681228510518857767200698954*%i
-1.05510685957651629014468276340+.706933243422495997008576551033*%i
-2.34791240493717884246417841265+1.67877012161795855610388404392*%i
-5.35190638634704458847156703825+3.87638041793741077766271749644*%i
-12.5253994632986618479831904495+9.09505274476880448338342735899*%i
-30.1777906913588208215348864220+21.9232759075427205523479860945*%i
-75.0792688193490220826494599041+54.5474001266232603845175564081*%i
-193.559329003242346494978683324+140.628739023475812128636577588*%i
-519.202698550289293103912202168+377.222711294681455591727549087*%i
-1455.96691033585118310295905940+1057.82183301361915038108521074*%i
-4292.24993582869224854910162881+3118.50210322833700179165296824*%i
-13391.1682949586986959982035595+9729.25326080125194502799718999*%i
-44566.2100902805772979642859876+32379.2469410470652856134402575*%i
-159747.442619741505495059326738+116063.310802898977300776973178*%i
-624086.700610179387375454980859+453425.529155731297319188934253*%i
-2696787.21039657859532836301082+1959330.59733402888976052645382*%i
-13132976.5281492781232876765564+9541665.96699663862941196936981*%i
-73842098.1832386879573585464245+53649424.6872703016642274619284*%i
-494990057.984203638845541685472+359631328.065363480907794701180*%i
-4132795099.80489050992077584837+3002651399.54041290078287097149*%i
-45722666131.3765247180053690573+33219461438.2353943844393448328*%i
-734661739629.402428000738171292+533762997539.162260926912532079*%i
-19805973720505.0319280991185086+14389882216503.4688989260884764*%i
-1146858958205114.86254952439433+833241806759938.674780235478438*%i
-230053932558550168.541510119576+167143965738663840.349224627468*%i
-497248660199660811548.480492057+361272298628740244093.968715318*%i
-724488510149456067899686761.277+526371713674823369632266013.754*%i
.268110790227095620186328634409e37
414362419969640199330732.484678
13812749487956767077.5275493468
22688236041873186.7179607301847
212284590481990.908230865935825
5340733415211.57200932403608465
254337800037.073084874837117568
18908597892.6167767414352038715
1951742017.80995855411753420863
259059478.630871178066695276814
41939104.1724982340409309759119
7972008.63832915670669081421616
1729726.91191302864852306277543
419263.987389862873596383501451
111633.432626143350193960132833
32217.4703366938770176311066606
9969.84670866613907529018224156
3279.01430875544531227843422514
1137.81212731803381652913982842
414.000735439193523221279349954
157.136585237296563787006985050
61.9403168236077835139535029357
25.2600636871368302206770369890
10.6225394249137974809800144122
4.59312695069434589825817582183
2.03696364916684758746540780945
.924469128049054556218717057904
.428535452210008547548874049771
.202540744656978089067503209659
.974534667294565732849103069711e-1
.476694480450033944605033579904e-1
.236756030108493897148353503344e-1
.119259739839149431741371082796e-1
.608666408032798772740907134759e-2
.314455801338455832118477082242e-2
.164313533312840070266362993927e-2
.867743762986162474019966095708e-3
.462821864491692087886971661200e-3
.249152837645085344373323793128e-3
.135299361780150190161161895556e-3
.740751431075543418921569325486e-4
.408680089513316964353184390205e-4
.227108160306801963772098576605e-4
.127068930989945322899265909112e-4
.715543619103239537897521298136e-5
.405385332700617691549318116981e-5
.230989078215759488595393876856e-5
.132334445511445809824523786611e-5
.762058443769467575133500453742e-6
.440983142865443037613274294923e-6
.256369435911794866412314910494e-6
.149699530371171596229003879284e-6
-281191.416067466399012648605571+111205.785938191223664577094548*%i
2667451.68137294707981732743093+1440250.33068369409308985064651*%i
-19027414.6545219553815581265971-16039825.0038160310919677803540*%i
118847055.605235863082201720594+23581966.4149489129656089326172*%i
-160490142.055598440372748953448+174759982.390749467377181011685*%i
-49597994.6133181482391709458175-142370740.683605511208942206214*%i
29718522.6734122621948105482046+20425118.1645853637242791355463*%i
-3727808.14511356585238221115565-2915198.46708991966180675866026*%i
76404.0471819879017951554441813+475888.176698102656924828699172*%i
43079.3199641339541109428267112-19220.4384955789135806910160602*%i
1325273.94966658102173094991328-1667742.81522832674742048209337*%i
-42918716.8168868718386945713085+777125.047299414542633949504980*%i
867132088.844637386634263676304-78383463.2506148727498030740918*%i
-1804823890.18803321105682709192+10670865711.0074828949078123841*%i
-27129837743.8609164608524792979+21617508293.4071062834258288891*%i
-15656143727.0284363651434219635+1067738474.22517044359031706528*%i
-101556191.512468834549842367910-1531211941.80567159870330930057*%i
28522038.8259285808606212993563+73797895.0062353390038125099279*%i
1310173.19914280077716763312457-3606707.55322002121460244519329*%i
-215490.737982950771517597544554-43335.7971170650926412738954290*%i
-8585764.99087817046588724961587+8660901.91118027658194250447352*%i
524427660.443151276149602028253+231020869.500662213687172287019*%i
-41684335160.9185065333603024300-18719299629.3470054610095103027*%i
-567758556171.495408332413718972-3787514740487.40852100844381409*%i
-42870242997580.5600383271046995+16043270952016.0636959639974214*%i
6643679315294.17218214545526801+4665504907961.61626047826251572*%i
56446448026.2786709622630262197+99297677610.0041482572538108207*%i
-994445485.375712491267626233369-873070465.629407518929333547548*%i
-4252653.45867331823084930859041+24850694.8753469385141982811761*%i
761179.897573206524249894645170+287189.101033389512857572609639*%i
41531879.4518442507270364523031-2446839.56652470642515634801032*%i
1638801542.84271312205918660306-3926299336.96854667927613670977*%i
-1748126108928.43438653187666518+194411169222.791475929594029197*%i
-1298116380137018.23830137658171-6364644714195474.47833846815493*%i
-12327316603809591995.7998347122-9252924445149530747.59078048502*%i
24738559644504697.0974289003476+35903993145853129.8855173352727*%i
1424663420155.95601359033355938+7308552806209.21695184541104270*%i
6417137399.20648379837868861977-10623773510.1526842665085978079*%i
-62616285.6228212271787712385267-73642175.2014488209993541921284*%i
-1946118.25848194882745097285080-226407.848157921920631687981095*%i
-60137132.2439523642125585292732+11967893.2056205345350648981611*%i
-8338860750.32313409374348350878+536054869.630721061259150016046*%i
-7125894508814.28948435469504498-1419014668726.36162563049652289*%i
-291474623227552896.645454876462-394458882609122527.043445673493*%i
-.107311070560052338952428170139e34-.349041014686579652892098643883e33*%i
-4947952202864037720.56877066423-14200344121176963344.4897496987*%i
25130357830188.1898168397608965-32345048166969.0629568644878969*%i
22065094805.0282742477902556284-15152109462.5551563434364201038*%i
133456932.848531673016664880774-64926267.0752896357013608107472*%i
2397367.97808561350960703155021-918133.564936789784244859162136*%i
22099722.5923242431758294825340+26495370.1777400473021001893748*%i
-1820099171.47431056189943459631+2504235432.34480875625386635800*%i
-104823322946.152106879641493072-931952827467.455156960753097012*%i
-1297497410789865.34008136852562-475837353426266.805225588023134*%i
-486340987124767698.302180741669+150077307868837941.764473671040*%i
-5909470325299727.72814904066518-2885610990755677.52703274509347*%i
-3359938919466.07524340702003082-1165680371824.70089688037178610*%i
8655046028.37740499009477999843-435897806.872924473208396758749*%i
11492051.8973747005659740342747+77809636.5219386445811661426073*%i
-1172497.03253592427519069343771+1254911.43425792904938736809202*%i
-692223.566691700025536856691951-8840032.14432998937243465862904*%i
323946318.223764963545380173261+132329793.356517452683207915539*%i
-18384355353.4557459769672890090-8886610789.26198536105417705522*%i
-799774155859.108154118568532450+657234175090.759370275760808106*%i
-7513145496929.35533538971952188-3580446303426.28205845057626281*%i
596340997423.359810248774507247-1872958346923.99683323131881478*%i
-16245230561.0235125047010024169-43929176975.1338957041887993384*%i
-21860770.3690655111425164792525+769267492.741072745468878738371*%i
-13879389.8830973741678002247241-11199934.5986438026700660853494*%i
351960.300170077367232227327751-539086.397572601754693164459584*%i
144361.804511344033480953066948+1446630.94902559712410179936823*%i
-20569558.9756803302916939903563-14397398.5302663573296503306790*%i
328949318.717653942581719138881+246114606.903085092227975694575*%i
837697768.983372556818700303916-3923576556.10633193763636970939*%i
-8510376670.69323754542231364035-7339420645.68080609846688250185*%i
-5403887949.64568044405523280527+1399983772.12997731933403293560*%i
308837282.485730617600064743849+616583522.779196932410660974182*%i
-9831433.81215548854166885399078-43445730.1135028372469751955115*%i
2040130.79520026033473501798232+1531195.23355266590143261427986*%i
-120897.917589608161418680283700+110248.856445149253408104624146*%i
-137016.676850808942338109687863-150590.208483298114099552458799*%i
1811910.52413444716048717851859-106536.537888925853200604421814*%i
-12285617.2329047011638810376236+4246414.96065440832659511710726*%i
55813529.6916828934115369320344+1744145.24032177535997377289115*%i
-67967800.2961661483461370082249-77383463.5879443795378012047113*%i
-9857856.39478202813739597470399+67456912.6339901763629185213906*%i
10691756.6990995462235219428594-14883277.9567085761708999588226*%i
-1273750.86015671036478221570748+2448289.43688708806079761859520*%i
-92519.3275745220116913573955159-303883.070298969217030546552907*%i
34215.3541045101394170362310783-1112.68663347387861729739267501*%i
27740.8258051907423349412438330-9025.45231573098434764633862940*%i
-33738.4488641691945856288489597+156347.540293853548264162726692*%i
-270882.987228450711602526601931-620897.900233201708994033815068*%i
1122861.11867845020094977551480+1481178.34241530489929456521030*%i
-1658192.81453581968210952724667-2249638.62080851468556017551366*%i
1194532.44101465399303419928105+1757769.45802495274188886182000*%i
-600764.204244247889005502036271-620043.803367860048798574882001*%i
211700.919477411572706729498189+56358.7201668567983219299656901*%i
-31758.9355525532870411562786899+26792.3519317762567270913135122*%i
-3190.86656483078401503226310051-6024.50083091090607634574472911*%i
-.576413005359117663773731290156e-6-85418.3973343365475583075445751*%i
-.997732805285302392122500781158e-6-49947.4949765111019261907471606*%i
-.173580669836399713751503187040e-5-29059.2300330991328571458591885*%i
-.303612162094415288836367920382e-5-16816.5321686202066502372499329*%i
-.534073683736862746968343901254e-5-9676.87120491854385434208174909*%i
-.945129409751899905791125731328e-5-5535.20027858945320845146329094*%i
-.168323489096135692019326270169e-4-3146.10832486392871685656809955*%i
-.301807015324434960514522526747e-4-1776.17314378616397387527383015*%i
-.545037957227736636186126326389e-4-995.596820992744351670785448117*%i
-.991822471941899583097026734394e-4-553.819225990309469775377004956*%i
-.181955361195755892317781993728e-3-305.577561680422865018552989476*%i
-.336707105931619644047147042743e-3-167.150403063980710327905975912*%i
-.628854282156329144484142098565e-3-90.5876210857203586560518727433*%i
-.118613832418943003024794013585e-2-48.6101532262826920325583119446*%i
-.226105829418799120639135420139e-2-25.8097715702844209212953070207*%i
-.435925549621661924209788129819e-2-13.5500817329425057677544974444*%i
-.850752659261265352006887365760e-2-7.03042216560926961087598064760*%i
-.168224250363899599689039922782e-1-3.60660374784505972394411118208*%i
-.337376392060794553156811548288e-1-1.83778126680244124685448373548*%i
-.687031488014795613058057316060e-1-.950683209820189595683793922991*%i
-.142241080846658941189178801980-.543410522328273168568397704571*%i
-.299829416466153176727088071232-.428972523822950247781797280252*%i
-.644484002168423709646530888651-.567564856431223328832505822178*%i
-1.41518094167926174449872419828-1.07391612551586142015044678453*%i
-3.18087365105487024966125163682-2.33160301422118098325700135461*%i
-7.33507968028836503145121084937-5.33825852467111283254067044635*%i
-17.3985993126536435399558129548-12.6446604825260095464658818710*%i
-42.5760662412411542385878465126-30.9349069940997839459716789298*%i
-107.856277111200440289479386898-78.3628036923678692302920965405*%i
-283.973415568992770641009994321-206.319005336208768454702861910*%i
-780.683199497667248594144213364-567.199634203137294671930249765*%i
-2253.22805691866259655776196538-1637.06603970747955189913251442*%i
-6871.95330371987410989723653927-4992.76633588976530750832340071*%i
-22318.8089144714773652322295422-16215.5638539763284905832040151*%i
-77922.8821129059257201406517359-56614.2877606943591260957995745*%i
-295857.145437848242974526246131-214952.798375108031471532477491*%i
-1239306.68486219392200997364784-900409.011793780139099344722212*%i
-5832947.15696839887404468686601-4237884.17314551563838957044035*%i
-31584420.5305973998234474649260-22947424.7378846590218000846340*%i
-203018083.386114629548448100384-147501271.534150880193957994899*%i
-1616713327.48408644160963410604-1174610988.01024705877787465531*%i
-16944398402.8801134103457669299-12310826051.1585170644888884065*%i
-255631438955.301591580871902361-185727111896.232908325123829105*%i
-6391795610325.52054936996561230-4643911341219.47228978930405288*%i
-337138780511847.864576118365027-244945661881722.444013795513500*%i
-59833396436436698.1705928960720-43471507106075670.0118695024156*%i
-108239188720082429188.881067264-78640373801938030411.4168945499*%i
-113408661955624659478294357.361-82396215954944934812800809.2194*%i
.252686492256799690619268382725e36
77535049016930304647536.0763144
3283435401212952955.30911195055
6256156301050236.42064510310681
65193397217749.2576479386731531
1784707718469.71928914602774892
91097627853.3066990965752705740
7182603176.32442951260419717321
780105819.333009788911232497055
108292254.193011053014780315058
18246438.8045640579236327995467
3595572.22986647038223556734195
806095.846311534134510457922183
201322.837469003732050853434006
55100.5164266532333216086584554
16311.9417934871210597363727849
5168.49311608362947303622044293
1737.72156762275932136204981464
615.524829631684923848427179037
228.326088218908986269601315619
88.2485111256291423650032614242
35.3852810719909860019848113793
14.6651752472318407347474471458
6.26188256928792016670079492226
2.74701045092314495629587082664
1.23506470278032036302993058276
.567880978830572440644123927859
.266523832105441168501699409991
.127465222942200460997233576578
.620254626990078848185437945091e-1
.306680181960194139685654077146e-1
.153891110178258955295015136429e-1
.782853539329875271765621442845e-2
.403329101872021020845326111956e-2
.210263486731694016824416668443e-2
.110826147214655871369890180565e-2
.590167141443760108571095294791e-3
.317300390919154751495545236043e-3
.172132288329021654076511512595e-3
.941685610176076185878079810188e-4
.519250726531406018658537679261e-4
.288449379943900086835587438800e-4
.161359066783884642202582630824e-4
.908600556680071968938518337711e-5
.514809241130834516906983272946e-5
.293402121968798279837764941551e-5
.168145226140929133435569121669e-5
.968681370642879083756214346028e-6
.560831346897657954481237616232e-6
.326232060360948536217704943187e-6
.190616157714077894921258407318e-6
.111849523153677088784684887054e-6
-33910.0728082430346019461652113+145260.824323183929050010410503*%i
1306541.28921527615484365532812-570154.439665275454147719513611*%i
-11093128.2604156534373872852431+1474093.76177347295036325895506*%i
45000663.8328672138040041572574-27337734.6636298353666632628430*%i
-10545191.8089811472243641748040+101063582.636069537628080400703*%i
-49836344.5555403007037369386781-42048954.5669164775608292197108*%i
15878382.5658155433357563021793+2581467.36475807560227719883707*%i
-2106023.27432707062168129241044-651764.170598339890720014210797*%i
104867.257378274459874615476463+210859.905261683971269022081415*%i
18876.4647033598582868618825090-15081.6613464999799630577789117*%i
-340804.449744852420964536329543-939619.673931610719961493962866*%i
-10506079.3511621848781030802495+15694635.6641003435526246085899*%i
201552460.848672438516937416316-296631715.729296525252255634147*%i
2408657023.34999915960739698681+3458493448.89898308304273811756*%i
-3328099121.29358204587222556539+12732792636.2078203810456192831*%i
-5089368185.65258953957402080967+3290589421.42702487753555434591*%i
-276093412.432928112550654240898-559826530.715937578584494414489*%i
21503169.7568475079621519381194+26787735.6623519349094603719458*%i
179855.428955784614381597712704-1769083.98916315295508869512021*%i
-108140.829643501400582575534964+513.854465298097550266653150221*%i
1659523.44850816696186461438240+5219283.25932820132624848852354*%i
191679605.894511912443413836829-138663452.357020102806915491285*%i
-14640213110.2813764093941497036+8845327103.61186717392960816592*%i
-1082947617863.38050919511304545-712797684236.978355674157927727*%i
-7816299672430.26341981781539552+12378990413011.6570272788964887*%i
2665950724598.36259190232284726+436282126720.522198487462545530*%i
30854924540.1818468254065051882+28318161019.8024191167489384188*%i
-472470465.137299077320212993880-253671859.483598604324339745333*%i
69875.0632600538519429353810140+11145677.8270593710689449633854*%i
377752.840059699394538889987890+84331.9388615250589430400561409*%i
6026968.77858260407253292369770-17092191.0973419333563384871770*%i
-1140851989.63239580144646850439-1223816533.96916575292298006263*%i
-214828191357.857797913026027030+564057940058.392550264707724532*%i
-1709708283200734.06139883288221-695760427012349.053108415624431*%i
-3657593385974467222.16260194936+105239035264697417.115669959565*%i
9410765423608064.76304635415287+7212957887250576.39546003893552*%i
889756531967.660594901820366558+2306697493663.10692820173395301*%i
1964714310.48616587446010142975-4341060266.66002608360835920046*%i
-29445892.4657077763285937303826-29015951.7256857793352564333909*%i
-910620.916960283666908955937503-42254.0039330580118446593332441*%i
-13147058.5989285574049841404614-22959006.4965648272113544751983*%i
-1232191663.46559674044303260562-2988971071.01279450560974575599*%i
-328003172042.264014910038154110-2388594872236.06779386712434043*%i
69461401575625269.1416129676882-105081762201884546.570366584041*%i
-.393386123204922714589441358131e32-.121202293479054116993141713742e33*%i
-1023900922064522027.36560693493-3417548917753993516.99380445331*%i
8228731471259.51314536855476061-10146425695800.4556263757195493*%i
8393079421.12495561815320692312-5597503725.01681028651173528503*%i
56748693.2327986940895319037082-26912131.3391512207752186973321*%i
1111167.67393863235141072495332-415633.399286132745580435785997*%i
-6702881.04565973920000014309860+13530366.5550844274461137164060*%i
-1206855458.86665820369690117773-220279698.249387821461797259053*%i
266357950562.758858075331945291-189105502233.351120690200933867*%i
-110922714521058.191782474294521-391833595470840.651394523528336*%i
-122204152895951628.270949431781-46746623177049918.8805750685516*%i
-1292310605410796.22448917406557-1350731815652176.28216013352305*%i
-1029289304699.33927906165579256-620124007045.313667403211584731*%i
3341621945.84778598873970141262+309177147.940429324566767057109*%i
1347893.65892082276067366902294+33781462.9867161341420901803184*%i
-594796.624289304262509814654155+537601.058569424620427597514309*%i
3368030.73729362720875187875336-2183506.36440360895504773380871*%i
23224570.4439480313193350561270+144356763.002726121001003426212*%i
-1353795162.30844610275167634261-7674242496.66873279265836787995*%i
-358169932546.820269789734827674-48747131199.8643028760108146991*%i
-1276151268317.65191216969942888-2459900945405.60585153244172368*%i
472385542799.320387217986626046-484135772015.975631472862877428*%i
-406804901.637766269569874799675-17538618611.7506742405766580210*%i
-85630134.9644966805842660113451+304178172.641239547523620551460*%i
-5125864.87648892563527001406457-6080231.20318500496931554041866*%i
206120.941295593235894338560682-229032.325334778489393411825735*%i
-542924.904528754462271634752958+423889.403781743690567832640998*%i
-113482.007629500133446557015330-11194531.0135730583854345587889*%i
9785672.23572633117178309164275+172077115.281054010004378802569*%i
1327102361.05338547726923715933-894352355.037552662189769833040*%i
-946076273.492863589884968481184-4277410005.65108594904827969835*%i
-2136324158.76228018963477247146-567294780.069760995534737441704*%i
17341984.5404246782293793888106+285501221.490331250380270109892*%i
1917451.88586636909967978765613-19522961.5847903381864374679778*%i
739376.172561226519376044132994+937931.275551502669128138838759*%i
-70190.8583319409812567487892938+40659.7842164023702445627686572*%i
21878.6923818333082811931756905-99087.4479635144517297474654099*%i
578044.049629918729386047136947+643178.401474481695500855560488*%i
-5236972.59415950222360134012586-2805948.11941262989154335744851*%i
17792125.0904256016638522044538+17187512.7305491044816467475633*%i
-3701534.90439154778083419571374-44875392.7176831447883296032927*%i
-19001199.1455827912699012224620+23308028.8834789584359610598655*%i
7299151.26877416328419188025885-3982410.28926821690634048338049*%i
-981181.025429490074486660641607+858005.566010957573726792096777*%i
2527.46610487082474787765924906-156873.511278918697021641507290*%i
17214.5020050422715276725637215+4047.62848121249010115241700163*%i
12623.7037823365305117859481843+8661.02782283704766104787267903*%i
-71298.8386886713893143963107211+38811.5863879456771010972769069*%i
124545.664344331446939346112015-309880.575551843687530369917640*%i
-62245.2674616893286129752999614+895473.887452651011294637703892*%i
1882.62093388381579486889402370-1338380.16246045260587710636930*%i
43323.1155578122117666342735366+1022621.88572332857276415386841*%i
-121959.646752515971848142138604-405605.547777974391319522494709*%i
86640.9148153212877339851210668+68569.3732065629172409674828797*%i
-20346.0630447889612577396696793+7417.32807891758516315348538443*%i
-674.429541767108611011144835627-3616.24811992333302461638387434*%i
.162655818238307069990549363564e-6-116792.405047015381195193412004*%i
.280035737918626907739778482518e-6-68678.6003801458433663572020489*%i
.484488888013836697502800239124e-6-40190.1372956589972621808081134*%i
.842559757338726967457058735053e-6-23398.4293023708627994468885408*%i
.147330726041402974658237439296e-5-13548.5141831385950768683675226*%i
.259119997242248884605752703194e-5-7799.96612802969232940790712324*%i
.458536426690470798049222293244e-5-4463.10293478311886734460166545*%i
.816722616686315409346436557261e-5-2537.22440874326381965657408102*%i
.146480268222126925204540924141e-4-1432.45047030236626909913289010*%i
.264653925679702812783517888657e-4-802.795534256582364059924896040*%i
.481925156772735094489509833202e-4-446.399805178924575947827208805*%i
.884929387717674671259507640506e-4-246.154271922196788750266663773*%i
.163950053855213988157815587418e-3-134.525742235629091174070554756*%i
.306660211162132941111411078895e-3-72.8193333433639496957991207947*%i
.579483122821368065490666265582e-3-39.0156976390632414019517477939*%i
.110709517533244462693490765243e-2-20.6767546559721268856165317411*%i
.214015695358833863475146799708e-2-10.8322337736528399954994062729*%i
.419001044339479940111298722647e-2-5.60983636369814850075074149278*%i
.831624485965221140413737380652e-2-2.87964408400944266818896819457*%i
.167518706042549653939811205805e-1-1.48538994694915097308477434217*%i
.342892950909174587375038562874e-1-.814325478585701852538655964812*%i
.714184647782557610140878856345e-1-.564090788203757554920460165342*%i
.151596235671779090463697452906-.630633750749067944853458025599*%i
.328507084550287976143497022660-1.08761324095612423633915162237*%i
.728163620719750241725357526783-2.27598765901956160213887800665*%i
1.65464357481353373628545267860-5.10800925816365413200018110909*%i
3.86428264914432117720940288177-11.8997642554118549767927893942*%i
9.30207254041500221023083963879-28.6316584229940046889527961919*%i
23.1571873444428786194395661049-71.2716396956872814604165199098*%i
59.8504178393574557042961037370-184.201093225954485893707322228*%i
161.319103180064601280423791431-496.489315710816871741873751874*%i
455.880344155802802374634443727-1403.05548998809895137498103597*%i
1359.26565986726505799566124029-4183.38956427298371291582767521*%i
4308.58186544081161164061364092-13260.4514822816012999180566248*%i
14653.0608374081503955387964801-45097.4841104279501263622706097*%i
54073.4579220195215708399246777-166420.991245259590849916423440*%i
219587.116156064840387448003804-675819.652369440152559165213778*%i
998936.841329461027857036209969-3074411.47123755908426683334075*%i
5209476.52704816425954966264477-16033120.1445970543530883349883*%i
32110738.3797386636750435174231-98826690.8778632566153892972259*%i
243905862.850282408630516369991-750665058.714839397333310651489*%i
2421816211.95673609373158437031-7453583885.60338076348874496927*%i
34306730919.8283373524992218428-105585260966.256912060633185424*%i
795614984840.038635495905637814-2448651140772.12572013881957403*%i
38227265221757.4317744469441339-117651424844234.960280685980683*%i
6002512462329294.64893770775912-18473833787000163.5468515597300*%i
9088193627075374968.26466522270-27970583908710935854.2926475671*%i
6847733861799693930407708.16838-21075157773418439860430819.4202*%i
.240498180140955231809780832021e35
14651283576779259423285.7193959
788191312343877835.285504987703
1742052686321812.18596580107334
20217373861411.4006824925193410
602220662930.216468004820364043
32946496354.9924286908375579298
2754809010.01560373438977842034
314811276.066895481038506834761
45702208.2116413160074998187074
8014067.07693951335267906670341
1637027.97882371951677247943676
379187.193147622356993768180280
97571.8629084124111722943958752
27447.9393556643024871841498188
8334.46488769596159123100730784
2703.71596479628777265546310110
929.183294746115629943381719879
335.943739365182127817571061228
127.033032189129658559797266236
49.9924199872485893918303129571
20.3890944629445982659475565610
8.58667425510697703200140492745
3.72241557052750697829758924048
1.65658492625144627004583788776
.755015098289479180470940698421
.351673451089151042176209276153
.167093872703705048764307762881
.808544789061634225773298184698e-1
.397863224890241138301315756875e-1
.198829375991275584703265141261e-1
.100793768804864849056794588027e-1
.517766033980686682749838696712e-2
.269255882682688945321538974817e-2
.141629245287182749361267066664e-2
.752932051535297874046907596175e-3
.404262499707677601347345533570e-3
.219075078286073159051401761231e-3
.119752802386559583966850671764e-3
.659940337907755976441929146737e-4
.366465014654609554410245779195e-4
.204960092308423196496272125811e-4
.115406666691829666010721524342e-4
.653954280460290650888140413569e-5
.372787857669099063842205223409e-5
.213711885047908057260486050182e-5
.123172402629255161760593967057e-5
.713494955767057280762948990725e-6
.415283714765179019722255513350e-6
.242810343165605027456192914623e-6
.142579439761390773848884884883e-6
.840659182944801734301869198639e-7
49889.9176997015064871049481234+55062.3425392791361372670231147*%i
168977.471311668867204950579942-655584.557399296849361105837647*%i
-2894314.06723530458546585594962+4178278.62356310436556067656859*%i
6452034.26900011797008504520292-22195107.6939276494800510681470*%i
22410048.0116357099690836534260+37817840.9832740882133790815155*%i
-28095597.7669500650071717120562-4715358.98943259976121055300630*%i
6967581.89708894661095986582891-1999653.01377281948639346911229*%i
-1035188.12113403308445620286295+65245.4346307527550198383281205*%i
80317.8645605185857091040439962+83962.0285199442616674878793856*%i
7491.01456567924961509539900616-9999.40600132141305261092092942*%i
-463796.716677508105367472425075-95454.0883345300862729272727397*%i
3059883.81567714811790015301258+7813459.18995965836969477201605*%i
-42269964.1559187371145445768688-143072501.584711522634454974093*%i
1629000558.45877399083469589456+307272241.734305612035798877455*%i
1901858487.83905644983344336336+4670665089.08647135637039073256*%i
-1114857096.45492949694233765859+2084649860.81044768643017820384*%i
-192632357.446230836190182707532-169260636.938734666615169571231*%i
12538588.9020642612936276205486+8343463.91705725846470088577843*%i
-120520.696467713928649228296059-823230.300912115789051889039995*%i
-52559.4800835554477863124157848+11062.1937444538227908397492325*%i
2445729.73451081500376487702880+429305.821210958572372314028840*%i
-9541984.53275729734308318969166-98154513.3139413297464963696674*%i
-397901859.077947363768737399798+6453609091.14462518847799856973*%i
-428581512829.122426278874010918+113025582284.896388980940833173*%i
407650499463.566862779646919961+4711380987285.05247617339670309*%i
870515018701.359903652310525909-257629891452.471736435367749024*%i
14086716421.3280628257818920009+6483691823.52367327765625220886*%i
-211765168.498973118377145940152-57512072.2789507703507143377840*%i
899196.223601503430052794114910+4892931.16549772850959712213105*%i
185304.299486644346014553843284+14639.5376707758978895886298500*%i
-5903567.44824817075547527089890-5355055.55953535266913585364006*%i
-629458494.313686063198745433438+212356481.762906174963755002741*%i
139837731810.569525830109576365+155531544300.190210184510748435*%i
-438171518300248.372402616800580+297636709543483.551812704564150*%i
-670141584156344883.286098446865+566081608122871776.397244048856*%i
3069310325874234.77557354492959+1087309821125117.67158237568204*%i
428820092002.939358561692470140+709415395368.018731381743087890*%i
557718892.153195405503428027161-1760900256.29617563800185808297*%i
-13765056.6263010118714755320234-11362573.5335025154410581275313*%i
-428032.833406413757676856922387+9815.24758203426543054227709552*%i
7660769.84240444804006307557556-8609572.40609305329891954026225*%i
951300962.835296297962741347626-830709713.369114691609379700724*%i
720452403369.161498094859187748-365502635816.941946125545783642*%i
31780896064746067.3105185765657+7567166096160087.64717598346684*%i
.854501412982332743752886860139e31-.117531763758422349740420817816e32*%i
-208899327986295541.939165652203-828820706905519480.213930025415*%i
2717792439757.53901573027852602-3211720439214.67615534978295376*%i
3222614179.04795767811717875593-2086668747.74607307652071208381*%i
24358439.7458231634024885907140-11256125.7861860261441805733945*%i
519825.687630753439526832045886-189839.153618230529507210656207*%i
-6664792.55344496401011324076398-296594.920316844637857897972044*%i
-129645351.805766838725915026239-473431977.772754275442937761168*%i
103551152273.335100882690758355+49781759484.2274703142483766870*%i
75024296784022.9797275563208938-95164813887998.2693529022065879*%i
-17486193248420828.7429812488152-29120641969931433.6294530984144*%i
-213945628713639.870787600194623-492130463059900.536577688161923*%i
-299872561084.761639075528570652-279614482328.745990630215439752*%i
1276207914.78991854839521822784+305174354.719897507097804746900*%i
-978104.389712982200218868979256+14638737.0815884998795005722728*%i
-300601.190329746368342095190983+228858.950982760188984342495811*%i
1610824.75661862213693966119907+877698.709226704204514506593481*%i
-46918938.6716236288350844917909+40050313.8679475949273935111573*%i
2093893858.61812410344811560049-2152962737.29898548735217741299*%i
-73264496074.0216077437140229248-104317285257.095405352966212986*%i
156716728288.675676216647695088-918654039144.143039799470894925*%i
222177997165.217389470063272552-76820273441.1932661603355475267*%i
2009597029.92504220494265901318-6324376082.61102186948912895416*%i
-65122444.6369344502258721565609+113693301.259001976526271563566*%i
-1745777.37709608233731656188231-3125788.43556112265340887290497*%i
115379.894062727412655413026443-94063.5812384426478499997554990*%i
-310094.492887938267184053625349-111425.520382332249092951639142*%i
4071440.59870099094427035661713-2972099.89496344926370596471141*%i
-53150494.2062761845299631472469+50081543.0240825701784080644673*%i
634955237.034723859392804363717+111998087.412346956043310708753*%i
709333141.693349033758501264878-1572296521.57535095063705316384*%i
-633103911.438835782251329423972-616966950.238811162247218995452*%i
-40271028.8661540790203782198167+112848928.363704533676808632398*%i
3541341.65249144011693008284241-7973260.60364158297769986278025*%i
224367.118234643472555149695874+518126.799247221154369228671456*%i
-38647.3856888576990584381875582+12434.2750546912992656989515899*%i
47093.7170558811339650445191115-19758.7343396250203147595662002*%i
-68691.4346991956610037694242083+410406.320536857752589921631939*%i
-688955.092800881644310068806150-2655085.79190658770548535565644*%i
725745.693331798750427373703833+11047095.5601599713368323606212*%i
10498396.5017584224448650091699-16890024.1259315852883149954333*%i
-12596199.0936660623141538691840+4571798.41349664679995273151238*%i
3805888.30137385990001553518371-195857.888108973036188799215249*%i
-584786.814406234421714185251206+211138.327017678345018278581191*%i
25143.6317713795796237547472739-74103.7249817640484337412006072*%i
8121.89271177759461061764009424+4369.90214380652420348569765817*%i
427.443143471466090548639960969+8102.57057332640105618577839341*%i
-38921.0744699873635289870260918-14738.1016479235687201673091257*%i
153563.804422561974566523556724-63950.1195848884820105295686905*%i
-310444.050772831455329163565416+309001.684224610438101200450943*%i
385743.146265687414769011968042-520232.321279017724293208084845*%i
-244014.222053525862648235915976+434216.419065382418181279827654*%i
38611.1115857360571023479098289-206347.928742492902055126376372*%i
26626.2542729394452490280680146+49599.0624593429723823919109363*%i
-11399.4546108350431630291940729-8.61933603892221261877196573750*%i
234.614434454940257494495149993-1990.49565380934797403330858856*%i
.391297760575788740443284265147e-6-158690.247768273920637869271760*%i
.670114667542017885089069981406e-6-93835.8653409887370302009588313*%i
.115302275941561556810221544549e-5-55228.2627350937780404280627667*%i
.199383682123210114435854576570e-5-32345.1996532152611903711125499*%i
.346600510317117904252495077160e-5-18844.6112854872616609395210391*%i
.605886505813221852603149530989e-5-10918.3350385028009240113573966*%i
.106542097589789212494643845753e-4-6288.82594805490595977537272033*%i
.188528193780341074901709903356e-4-3599.70270979957397873417784491*%i
.335835624156029831492406849249e-4-2046.79460145979406486783786045*%i
.602500434971974582042000125982e-4-1155.59168513726719951655175485*%i
.108910288655023332200305795183e-3-647.519292070304380331203527348*%i
.198463215652573799738206031254e-3-359.912309985060302495568556065*%i
.364778481474146660654801825966e-3-198.332429144986769004810896524*%i
.676670399798640269443433777661e-3-108.287578645981581397452887169*%i
.126767964778430277169879923230e-2-58.5411259398903823441149693280*%i
.240015770324783476074975460052e-2-31.3128323630082410228972474300*%i
.459634934813495643145212026419e-2-16.5581554937216652584626195452*%i
.891066246184065218363971578022e-2-8.64855080534259676760883066766*%i
.175045861286174220538940174098e-1-4.45747722469504906765611901906*%i
.348823608640132672604467622865e-1-2.26451646557920787559837968987*%i
.705979471210331222200967948912e-1-1.13259705051944159201179733694*%i
.145308507293662901831151128222-.556930536174295074310149787108*%i
.304616404182155114392416624165-.268840102839114988755328708180*%i
.651494014609264633495855923035-.127178809184497574587914905017*%i
1.42425807397469347842461276610-.588475541757307434935325268497e-1*%i
3.18951956703195584380890438540-.265759607645494270937403418963e-1*%i
7.33480235012300833163823177780-.116847376238581530125935197331e-1*%i
17.3700940361323033768199139665-.498752172362807061461102224529e-2*%i
42.4988562106352102339964649799-.205999386022489099220302613172e-2*%i
107.832546482438804484491839296-.820192891834345942790869416862e-3*%i
284.991072348135787963041244210-.313410441746975184853745659641e-3*%i
788.626636042026939330072661982-.114339891851854591906015949307e-3*%i
2299.01925246406414866596027681-.395809418997751123729164802108e-4*%i
7112.95069883943825086201905129-.129051414947133512415453123759e-4*%i
23565.7019431412013740147844433-.392762185356017918587417826763e-5*%i
84529.8071166482546671191164212-.110357207704856470982733769331e-5*%i
332806.484563543170580796262951-.282365720683180653121543514269e-6*%i
1463444.14844068820583846405516-.646551691129803577197811994798e-7*%i
7350765.35596459040002028405863-.129537400621085515014176932614e-7*%i
43452029.3706887183482093320960-.220409005448572736508150782596e-8*%i
314832922.142989064263055254505-.305791522890853379332108654141e-9*%i
2961739042.52048423326703179950-.326566273615536261890610633431e-10*%i
39396185701.5871935524821557023-.246499140805054125532754634543e-11*%i
847440366121.999412798525236880-.114985803130201140728974170259e-12*%i
37091745180637.1402555980614940-.263442903750049444561670828444e-14*%i
5153145048368559.94404329911512-.190030671558853695844156048339e-16*%i
6530219023467081052.81288413777-.150182328445733925611631355158e-19*%i
3538414794666432299453203.18911-.277398411921933026353268715918e-25*%i
.231212210389143320005755636365e34
2796534526229836987328.06243806
191115641108372418.920380942566
489968067228377.993472541848470
6332671505535.77597261771595667
205244053723.685781758881296909
12034281776.1431072040689785074
1067061599.88010020084318091300
128295778.905856472590320367647
19476761.2839005103472894070130
3554182.14690849997264639371827
752533.649005842626256981879122
180081.970122137491895891655109
47738.8269196889179642754558537
13802.0539233485999711162850842
4298.25781911185269704702895630
1427.45458416409141695278850208
501.403014703720678882244061324
185.016759711429333683571284059
71.3115123284519982701189391591
28.5719811045893569505513243125
11.8513986151637151223346087224
5.07125647449065824050856363109
2.23179225165753176408560258614
1.00746956396234930022389297169
.465416861650094738257481554445
.219582666293244789832569789935
.105612883494441735882813022981
.517016202483855590125426136047e-1
.257241634723364205349824431748e-1
.129919782451110713040719012335e-1
.665288866181319339810867389542e-2
.345064185883294899940191833995e-2
.181109571102592458174365103042e-2
.961103776579800429132383458661e-3
.515294813636083515551024905206e-3
.278931137315711034234016615303e-3
.152341999009776317461304516007e-3
.839021475823455013802390104458e-4
.465723091090980010562173396806e-4
.260419300710401995621341346954e-4
.146627598824563790593763913214e-4
.830954438894772741332777718124e-5
.473798024788456341909802333269e-5
.271713954457716057753943226000e-5
.156672496191217132907410366640e-5
.908041010120023935594665910530e-6
.528845938476179080173932131989e-6
.309422268764363299145187987951e-6
.181831078991285406038556273869e-6
.107295481454780037225203537251e-6
.635624554295028899433340264607e-7
37058.6537947089427362587412941-4902.66934417133262500401945880*%i
-197946.332206952727307215450633-257514.924321054714661620267121*%i
525957.070257447181969262132927+2272420.64643320495920473051144*%i
-4545010.28448790855269024888778-9189865.14810742170870628235096*%i
17722472.7405337624607569145685+7428716.19766065847341016216693*%i
-11734179.2423001723310360531664+4525789.00260111574429022691706*%i
2481603.22967941961477319855733-2175566.65985747289318705786551*%i
-449047.087300928268078552025415+203501.687152151876809285284823*%i
50632.8597959961851887714263887+28091.4621929409531622178788556*%i
2480.43642904468925665715526628-6034.39102214086845406004345539*%i
-154987.354163695015381642563757+165233.544070960191923630156770*%i
3663107.21879498261408056509786+873136.059008561155855805732490*%i
-57764017.0548484538404271219472-24365307.4998029205697044725035*%i
547463938.733328247654835533730-366347315.558426882882125098291*%i
1672811082.46612924928444404751+1006693524.74911283408644347016*%i
13540267.8752100893240769908525+931530219.178237397698857783167*%i
-100696707.404105898264297055301-34428027.1886138285955669450646*%i
6409749.43005876748219269598158+1844905.85450028671566788449016*%i
-150047.362732976297198210522980-363393.743378948681504640565028*%i
-24708.3713001015115677783269365+10726.6434505887455764718496553*%i
692599.969483005789562639680498-901554.829853167248532419272969*%i
-37700763.7188786749921566192340-17390897.5875044720429573511462*%i
1940534093.30247522738630706714+1526275374.40075265990428183923*%i
-69717326980.2246166064791703374+136272933931.438662498102541770*%i
1035730903178.29365400733162553+1143862113725.22686835042998711*%i
228085749135.926690735783620712-207265930235.963819205973696244*%i
5758055199.53618692793281290138+696212543.658271281792783267975*%i
-90624733.6420051427292294291904-3434025.01600556448872996255450*%i
783468.333243358091582704740847+2101036.01601475172210193431819*%i
89961.8087846197711370087524928-5549.78766159550401557841158685*%i
-3207653.57158853299021126984004+1496445.01294162979761515858660*%i
-26452533.3295511624365301821246+265069525.432222091687803271603*%i
70782625935.9740842328177087214-18664183115.9414896695844404242*%i
1394457912021.61738242095942273+153535644151835.018806160480289*%i
-41520996614817518.4733173514405+208340721016559117.416697993949*%i
902941894882763.464615950548374+24385291944448.0078056362402171*%i
184936402046.295062391910014480+211205239494.197131798079717996*%i
135549523.516148841118955746393-710325467.840504969488868094976*%i
-6412894.93142956555670244905019-4408500.49150551178155930891827*%i
-202161.297718954375781410304257+18663.0505577791716397152811722*%i
4661744.30665984929423649826817+1990606.52910763301446686765580*%i
430859280.531718206396698212397+250234980.080092270313624930172*%i
196604316813.463595992865823126+189991046577.413315066311031255*%i
995447987157579.363991665692865+8500279945256133.86790263146060*%i
.167382309140766853055998992000e31+557941050906624120959999200.000*%i
-41644819758753025.0335223067531-202612167198911170.995598880990*%i
905685139475.981626024228086657-1026067609579.35125900268765351*%i
1249310401.27296957272747403459-785131332.845779594089760129990*%i
10556495.9701669614699973886402-4751515.99699867786735294742487*%i
245505.735714678285854268368205-87501.9934339356495262417520304*%i
-1078629.39981159377271937138277-2774083.19545191348868418607460*%i
149778187.419305222562127020758-130039398.842997844997497417737*%i
2327863027.64124346185701163315+40751410137.3010210329595804130*%i
36395529727956.1574561599380250+1468740800609.36821444339184646*%i
1100924231345658.25584507513674-8839347691058430.55614498922340*%i
-8851779007107.18270209086078386-155350907838422.416789487566922*%i
-81204697826.4348692973525183109-115638985207.982971157956011975*%i
481786661.548968809273256516279+190781903.234357322889699726627*%i
-1107617.11064808602669010508712+6333088.42030566167119214714466*%i
-151649.482854130392443323773591+96499.1293547000114904486689719*%i
-2142.93206346475167146148597417+846603.302366866210196490174953*%i
-24973244.3762158336416017462053-8204390.90819345585210554850549*%i
1156530866.45644782401313536152+171231554.869442813874995892875*%i
9513821852.04671431491628464137-44404419941.6312035395691329376*%i
230719955463.327377127908177047-216795237243.472885986539926626*%i
81818760917.1015867182427331588+10847565947.7777271530674764758*%i
1510849667.30298146319105806605-2036260703.03269088468437489372*%i
-38026176.3953103597338896162211+39556619.5062214031277033968641*%i
-509863.241883392293192161252381-1545821.01531201179136098445491*%i
62641.5529371986095531768623578-36730.9711984537532835439685044*%i
-34344.7264161080917503940890387-155440.469329094124937050703475*%i
2176089.15683725398901935806135+721648.059306667182508279968918*%i
-31046742.6319761074612119016670-3634722.13181914734898900558103*%i
154287237.446385366481573602981+212298747.175263198150314449837*%i
600362644.795809750095665667293-332276653.941278049861109777171*%i
-100599969.637837755874997418926-342733577.039360825470459950378*%i
-34412953.1633182961177124670179+37241709.2129649137858365167378*%i
2635939.89414468570122507109810-2900414.99151110569848641915599*%i
40352.5487347696197663548429481+266545.589231915479574214151072*%i
-20418.5835626876550828075756710+2009.72976900742727902564588524*%i
21999.8156327565053850998000611+13783.4253415846150205217626749*%i
-176887.755752269977583337214361+98115.8447062485389718893161968*%i
692166.906338445412316088990400-1076168.56577380279186697069976*%i
-3115564.30174322462764236418196+3918825.11834860484556724790668*%i
8254779.21875745397841615041710-3260880.57513477207919325183251*%i
-5924869.49266030344770851007230-1141499.99969574585289610656284*%i
1628056.81779744164790808753355+681147.045778961813516953745571*%i
-299518.486273977266271535539354-7490.58479425714594886129570315*%i
23461.4817745266556363669636802-31681.5816737692264246881977750*%i
3535.94184541881938064557649708+3330.41679213290901396391237976*%i
-3306.26841481683135115573996092+2817.70772595254345999769379237*%i
-7343.12778386034872961889003040-20269.4119587094378191637774962*%i
77122.8438273484382284405919955+32606.2838551886003155583877472*%i
-215575.503734991614829208952600+13912.2366043543832650350164379*%i
302974.243395803891112720455271-92434.6090919573704107624579787*%i
-214430.527722215887319881981362+118465.782401157680253080196024*%i
64600.3716554973777111881347045-82972.3914892590207606524415311*%i
2453.74062214079400203364565679+28876.5537073277103920088897820*%i
-5694.00978514415185565465799369-2079.62520374436955387950859100*%i
447.667807864556263495541351832-1007.96407774606683297700192465*%i
.904575448317609852329328062431e-7-214254.248751838372189674581854*%i
.154106160942285770783356332372e-6-127387.273429858627813805777897*%i
.263732315028718690149796821931e-6-75401.2803805335333867135158486*%i
.453509902859422379522442979006e-6-44419.4960498720570344334648118*%i
.783810083846907888617754641863e-6-26036.8294674599779254385474579*%i
.136196387702592052955412378809e-5-15180.6302188006618668092293828*%i
.238007938873802179362415412621e-5-8801.07594913470037102064291398*%i
.418446875797334166995709543842e-5-5071.90744605287783840902154606*%i
.740417794941789984407008594380e-5-2904.21553827976397337768782703*%i
.131910581125530177351884337826e-4-1651.68198277391514328770398679*%i
.236724328639685783795544743092e-4-932.537508385646677759923704127*%i
.428132453591619862166165531211e-4-522.435969090805698206518316005*%i
.780757612008687055425509848089e-4-290.262950926706992889999535035*%i
.143651288198779784119607099603e-3-159.839683591229197995211063868*%i
.266829979761644481956221646027e-3-87.1824792199915004949001639840*%i
.500720397363043229423197503501e-3-47.0664314484961422283059316461*%i
.950005050787267916561629241452e-3-25.1288064926843537974261764890*%i
.182387722000601221678754180011e-2-13.2545528056112104774083627297*%i
.354660469352717350140959285904e-2-6.89609983857731098133185959119*%i
.699247263648574140695880442436e-2-3.52650420656952697789418484036*%i
.139943974054134524382234316370e-1-1.75218351583752553866874901158*%i
.284673259726881837937155772481e-1-.805973552709137304852440767104*%i
.589440384008229309615400037344e-1-.255486643592306291802473054050*%i
.124435568109009172938581615677+.173496658002572824393254960162*%i
.268326437692640246043259040439+.727515038079206504168845153862*%i
.592253526832997612834437142229+1.77770488452298740269399358964*%i
1.34126865485311899329120149694+4.10787247512350754630243215123*%i
3.12520372190639372618186328962+9.60965225623032834898746834074*%i
7.51567123021572133470784298099+23.1271851911608519882532022486*%i
18.7230404556208214796441097017+57.6221035020216194111574364207*%i
48.5248833390380161887526125698+149.343653803825636036406869376*%i
131.499105997524907385343554857+404.712417228477600034494741817*%i
374.846564997550414688939799601+1153.65902539999668806058846834*%i
1132.08360184323318787174030354+3484.19503848394804602719249713*%i
3654.13657931636375329700862145+11246.2759847470769276222000489*%i
12741.6432040727612569415739790+39214.7455234211308163562122080*%i
48640.9608538185358045008537356+149701.484451572275061104396412*%i
206763.224571430071431234402086+636351.772356615399252248786636*%i
1000371.74287869092970219634967+3078827.64411303249288639226028*%i
5671385.55355811646860017987592+17454729.9511593710982710745116*%i
39199790.6787732282178772840617+120644550.432776315761385726088*%i
349399054.123382872050636328115+1075339716.78014080506031673487*%i
4364344783.89757577886338926960+13432072091.9582579421787071011*%i
87080925661.3004457795590516066+268007531309.766448507623103854*%i
3472190048103.80939087797178084+10686302148992.8453495920252245*%i
426820285725616.944683565140308+1313617766710169.07718028610151*%i
452709030080457753.634696199173+1393295129009201411.68140265278*%i
176407184596840541879339.825437+542925487873132077294644.879513*%i
.224590631921042258030679236787e33
539316996931546827819.190350399
46820311517699944.5930828409498
139231793671514.662891631776494
2004013634276.31975652678368077
70667725700.4482504134077075772
4440661803.83782709397458052160
417524597.276489709125101322033
52813407.1791232292645532153349
8383753.52872518352693015378075
1591983.49294906323842645049035
349361.914770694095428567867361
86363.8754227218133319783182659
23584.5588958087153447859686760
7007.26196478684308278795764809
2237.88660963362530402103919147
760.769744427249192031090487282
273.098802670107537156388474306
102.839383014799759141571349954
40.3982160157853156271355284935
16.4774903334398516814481104428
6.95040592553593568303500344818
3.02154449303151155075125986472
1.34976798640473507347978171638
.617987982685814541597821014426
.289342200358728728434969290948
.138258883009055421909972045774
.673074625230214283160642115696e-1
.333309556607679559244015568746e-1
.167666427695773733175616981011e-1
.855700069838658721971373029605e-2
.442581140544698271246762790147e-2
.231754002455771404888642132033e-2
.122753546129931039457761359863e-2
.657143157099836515512950905220e-3
.355291304338622616986262353237e-3
.193872576528633359110120893813e-3
.106706231247788088611730012965e-3
.592055130135114710771457011175e-4
.330987349621010419771369387752e-4
.186351902420900823296138810897e-4
.105619057081610382378072659876e-4
.602371568579899434161382473811e-5
.345574344420071614166755316552e-5
.199354768044663450145955290835e-5
.115606998003762475790844492429e-5
.673733622904761154472969234181e-6
.394477503682841547150175369649e-6
.231994549219390455715332955300e-6
.137010545477815274244245970024e-6
.812375744469589619796730385602e-7
.483502842539032639132489969946e-7
8644.41152950157682304322330409-16918.9063000308744764567359454*%i
-157452.038817141570013287546548-1140.90285295478765422715174066*%i
944256.177179267717048279255971+527766.758833604833874130300254*%i
-4286741.57047194474871691278735-1658160.30731094219585323023284*%i
8243272.66399689218145266827232-2035003.48060851694650286890097*%i
-3478126.51900917241490489878883+4403942.67177291026977692652970*%i
606821.608182973748187582991844-1391975.61002468487998071613867*%i
-167082.607043008803305284234660+167784.939382320621706695054996*%i
28535.3278084371567937752810632+5968.40469063273935819119376914*%i
472.930613399390870350416267801-3408.51922606438072966140056991*%i
28936.6439531887648412422379289+105592.298767376123716068189266*%i
1272325.50451720484074089949686-1138561.30447621151450490690176*%i
-23544597.1478338900227645409201+12422459.4736794881351987722302*%i
53778199.0682258247086405701422-258996711.717476808917734897275*%i
759973567.409637679151472594508-76742678.9490147763956162370297*%i
184360583.253956366428751793760+321969152.066484930688274598561*%i
-44542266.6977733673121743746966+2754308.42014658856112279472053*%i
2983459.52678083664738247617914-78298.7746020641879978380299767*%i
-111666.886671896088911702620105-150831.559291188124079555554340*%i
-11173.9122920558807321108364849+7828.27081659928740767454619785*%i
-221441.408288981937277445759899-476835.329065996108053621507175*%i
-14476084.9537662568339805897386+10112259.0724814246492337619293*%i
909994723.488886871519915253836-281118989.415876127328868191659*%i
19179905739.6352182453168542748+49852298348.0283076737541746603*%i
500068651537.624992070159503898+93810831446.3158166445107969588*%i
39545601658.6447249778097175767-98042009019.9936704995137140861*%i
2152134392.03658577196178167087-415095533.109921549048139362630*%i
-37189390.4743252138812324395804+7120894.95106377554037544854794*%i
517673.792317815175364431027299+879930.455029473203706162578496*%i
43242.6653586886350711481690684-8841.52698426766765880389146945*%i
62051.8206898794168322166648436+1586363.96396508564352271235061*%i
93417386.9545254440779543304344+54007003.1937569883616197524128*%i
5562653217.35741167222438908087-25279012802.7674786649644784570*%i
37651681485388.9186852039724951+24585741724719.2593228748352541*%i
23816393550487836.3330080731741+46203186464108032.3398499485502*%i
242852543759746.649649750116619-71524377628490.5327819611636544*%i
74915032415.9371349512415210178+60112550529.8484699968016410546*%i
20148766.8481548949124609784442-285285609.287456825939929200167*%i
-2983213.87602405437393005460859-1686634.51922365240950132732996*%i
-95961.3213600386511943742296371+15585.5299522357938076202019305*%i
-179977.817024305536893275498864+2244639.69073264194566668658602*%i
-39328630.2346199982338239809769+194630448.146902685787080879631*%i
-39417164457.1204743620176394298+84761027914.8336617460915408840*%i
-2022771733872830.40777262612594+1019622597846300.04548174799112*%i
114449777566947099525592931817.+157640105597715995515302908387.*%i
-7984470575843741.64212620070269-49941305537125917.0229828239796*%i
304612210998.601181920830680987-330922631589.476379097168919345*%i
489120540.157895247093305563190-298233854.143347225801519986782*%i
4620289.07437193548792732871650-2024748.92601353507140082208977*%i
117081.386546920499773402828173-40709.5914065448782762008436505*%i
947850.440961923658984339435749-948898.489086138281345459785248*%i
74312351.0014523304456880323650+32147575.7621008569560830116461*%i
-12395781318.7919370072986658324+7808563346.73295120920171557171*%i
6125960078748.89130468402044441+9211319139821.57348034418951031*%i
1674275804679076.41382679312722-1663610263848545.24786605426430*%i
13306760241765.3058305121376197-43602789965495.2772026080937756*%i
-19349218080.2530764931253947614-45235644142.1509820325069539461*%i
179475171.044525092589023164838+102575971.946821210898635866584*%i
-784738.459868694681553936741064+2735350.49737543289346155768354*%i
-76486.6969698702352528936640341+40103.1804097481003334544082956*%i
-347567.648091862286640111224149+186938.737737680870486890126355*%i
-2569585.93171588688877322358834-11020172.8976778416440588726953*%i
211248851.715007488969844648372+408455341.502171187286145375468*%i
14052087372.6278009308394840280-8352232767.11841109137528661859*%i
108062154989.110318808203333228-11579192271.7592374994734668874*%i
24224709004.0152358756876010414+16446147382.3648074077764187304*%i
806814757.036235657357240343123-554300415.930983861982291852679*%i
-19669745.1527532710136829874312+12329199.4411067819352227082836*%i
-95569.2852700432320212967458505-741378.484017650531165674986834*%i
33259.5185912882486526331582886-13173.3929693110227010239992301*%i
55267.0856529738860615767951135-54598.0154074909846069645509585*%i
310671.848783134019100340588584+1006644.99307906945860752515802*%i
-7428749.23597957180783071896187-11296410.0861744511373388427691*%i
-15007942.8148567668812948540554+106905199.846262560022711229685*%i
273317777.687512481604142990549+37406383.9634432652725169618608*%i
32848085.5139099617155359927297-142108871.595671903796670422020*%i
-19782304.8294803038324983487369+8881190.69181126059163634664635*%i
1549167.49327127204132722426626-874442.828120225864344921181442*%i
-13965.4000894245885895194195558+129274.585772471944440581747250*%i
-10403.8088082616458802288857015-1195.57331388203425711348099562*%i
711.190094963318339527781520901+13313.4813962933289781374369462*%i
-91795.1914975154529575646893296-38026.4485191071004613486010783*%i
594193.085522157339767263510021-104038.983864903413172824790972*%i
-2258512.73791025602068736745839+368077.990476304795874290163295*%i
3867021.92413865437875482773370+1038069.28064327955306717474118*%i
-2048896.18959412937009392090221-1828535.62869909575945303466522*%i
549157.261231857233149948854102+617000.785638949526479410416107*%i
-134616.287658336459038439019575-56265.0725793172167245194183968*%i
16286.2889190732165070422378502-11721.2656054038786059446146552*%i
1360.20563602686922092867304543+2197.07905827247104398885124264*%i
-2296.94007154778055764642949546-496.678709882887428202131501124*%i
5554.37058158431389643741542669-9825.54554018227287730851220927*%i
15629.8403825803435489358598621+39635.5948842942901685122009605*%i
-85454.9089416788360179995866862-65572.3756239534951000246468187*%i
147645.827010472694340065994098+52320.4161230180391154869061458*%i
-121673.602456438089975080341964-5976.11332784391205216290574317*%i
48328.4886381952022731290229070-22354.1546091514469695446983633*%i
-4777.03660602759643717797058556+14302.8211636821971389162251803*%i
-2494.27520514846139140484663542-2094.95330918880680885860103236*%i
403.085290052880914763170371444-461.959971932068610763921884466*%i
-.178293740069530551375971422026e-6-287424.054825819982680915074236*%i
-.302190853214862128064287240564e-6-171815.669811032114485037484162*%i
-.514418434917366343943872814172e-6-102268.093404784493233881947259*%i
-.879730461926290709552935091692e-6-60596.2214644981009455434005503*%i
-.151180885497349069195913388951e-5-35732.2733925290636773020664667*%i
-.261146194134983822556321801010e-5-20963.2117805214740482076271478*%i
-.453571311402514698899361410460e-5-12232.0459812291061043685333283*%i
-.792372022880983224779523612523e-5-7096.35242777658697137997916560*%i
-.139281448138314886074706522479e-4-4091.70361413565290161540910538*%i
-.246439608310311615897659899651e-4-2343.85280022521275460726363869*%i
-.439105069280163268810217638986e-4-1333.28358771797648775537419775*%i
-.788263650773285340763974596181e-4-752.787700284641380250530880417*%i
-.142640479584218323172032640125e-3-421.650815201462083321303368013*%i
-.260331302730576808575700392893e-3-234.161299319574961995313322869*%i
-.479501367950177312163185979719e-3-128.850529095604078234891762909*%i
-.891922478250645539091549529520e-3-70.2046001278506536066198663192*%i
-.167672516427582520683381658101e-2-37.8458888157000791501444378286*%i
-.318824418166904941457610743282e-2-20.1680238219273224253323533704*%i
-.613750496004600774541901047728e-2-10.6127165652759793047794137125*%i
-.119735243492537622227583708376e-1-5.50539002425907914990043384404*%i
-.236990645275591569371165283278e-1-2.80513235603636612297718633339*%i
-.476503418822015029247975510519e-1-1.38727039549198205606374421145*%i
-.974628840914093837942093236016e-1-.633262639782319580176699830294*%i
-.203114345563792615746124065917-.194540724514046376161048203230*%i
-.432065327225248168700113393385+.151086252014771537274986990229*%i
-.940048713231528232987344391621+.607231840013036944182463077375*%i
-2.09677777241101437103145743179+1.48902868660604385200380773326*%i
-4.80742363191298573864894059670+3.47763165432676832055658531945*%i
-11.3648673882149676829899064174+8.25057081716090224589752128601*%i
-27.8007501877319480302174417619+20.1957453048742062608505803341*%i
-70.6639900883152028337414492363+51.3393274748391324712277470960*%i
-187.551445284123078902485042251+136.263695176449188911973133405*%i
-522.823907232470105513619286744+379.853656159479799738488065752*%i
-1541.49308778908380896543814823+1119.96023453551932291660838332*%i
-4848.03162706612810455372639772+3522.30113801712366059402065416*%i
-16434.5361261454033502432045729+11940.3894188765587146759137282*%i
-60836.9188772201458761909337603+44200.6088358030757804138525364*%i
-250012.230870766213866173250748+181644.518248785354143627342111*%i
-1165238.58106906551573498356481+846595.384419229145976352721618*%i
-6336130.02617953500335927583602+4603467.92699113997479354181319*%i
-41780306.2517063957707597018089+30355169.3249529465933058004640*%i
-352863260.056938581960263829424+256370165.001981240718960135906*%i
-4139197120.37330483740363928349+3007302739.74853096372307858193*%i
-76610486558.5033415864157930384+55660776575.9357377694773046015*%i
-2782894165946.79965631738548439+2021890962498.35811389316531456*%i
-302689156092213.257152603584469+219916544667045.902994372171839*%i
-268718889407259370.563392914951+195235701232743215.944885140908*%i
-75303683780022935205901.2763296+54711328781654153698728.7276168*%i
.220481965523831789119015016348e32
105115290056572966542.264416200
11592144829978066.7754906894968
39984381284287.7317093215832640
640887780798.851193360225621255
24587934377.6225629804312422903
1655789208.53851611880635588705
165074761.036389826909368422576
21966213.8469147384004937658833
3645942.11516781511318827290533
720368.283993206665930328707624
163835.312522918799263543460756
41834.9497987777620274046523477
11767.6540474116151331384057429
3592.67682067995043601329944729
1176.53886073094871799766586306
409.376343020596677758487295733
150.170972029974670905358008181
57.7025379097658822861179624729
23.0996097067966990882428940840
9.59033650368773793806200745170
4.11333815155528308650370357840
1.81650796375369017173474960860
.823588598022991138072981080436
.382406072069356951870540320680
.181438264943792697073110865549
.877983451047383848943308125381e-1
.432572452407897632611793470903e-1
.216666604808742573914726416339e-1
.110180100206255724510379711974e-1
.568161815861826580474023284767e-2
.296778328315420861077520519347e-2
.156878768172342170938872662593e-2
.838474274135564410405119657251e-3
.452758701914089838763217742509e-3
.246822738585182152025787557070e-3
.135757195344326684267935211752e-3
.752909840026682376057600548332e-4
.420814725114402695157806850002e-4
.236914732159167458456590291243e-4
.134291827420943744633505341595e-4
.766095113995381001503039465494e-5
.439668173261438718511389395144e-5
.253760040261556224002894727034e-5
.147243356136129676927966957558e-5
.858680297552487414442054910458e-6
.503140552006857156906416678064e-6
.296139737426672153358150410705e-6
.175044758352116696205061534070e-6
.103884180797689741119804505060e-6
.618880961673775324920904982557e-7
.370030778157272530922178137593e-7
-4638.37739301552122169897026786-8585.07777456820266508431817925*%i
-47860.6331819309794895192670972+60510.4092466915816982336764877*%i
480687.150155716314486105866593-161682.981657755119777093867924*%i
-1939594.42662636863064500647502+760298.392750917286935766669963*%i
2413878.33747384851292205672934-2925950.90942367459802772231886*%i
-339405.099927205913891165521196+2508790.66434426665413705776652*%i
-20053.0200358158999587582295858-706048.032499522051458463210364*%i
-47073.9028871017389792642696053+104872.025750602610498728287502*%i
14767.9514574889180997289577522-1383.12611871954870552843021677*%i
-207.424194069038411589074573321-1821.93437467594961088294164826*%i
51352.0842675948081385230371923+14870.3934004027743233740998577*%i
-96444.8351164004292773386237434-776349.194038752598928845426151*%i
-2273448.30835477549098935388406+11196751.5867806843501299612414*%i
-58101886.0048102637081000466010-90294253.4434709144184078941631*%i
222466461.495084053137222345658-204373458.241091302650922696826*%i
127688579.387311606747006704538+77482599.3869222272981525764573*%i
-17010954.2999124183668927084484+8273097.00759896636668041205304*%i
1275764.82734602941636386840646-440260.777975019645016887513283*%i
-69906.1619151295313276958646074-57501.6780387433681774029840847*%i
-4803.04550389978546236358956215+5065.79979000715237856404517859*%i
-245375.587950726368120503739828-11257.0083055696580867166200998*%i
615522.863110778487866983516785+7563987.21904870348523257907679*%i
111463864.206410159661752011281-354205163.084399977960101887749*%i
17609539097.0076352597062430279+6693625707.01544913918137311856*%i
151626405350.589491807103135012-75898420133.4541045063016261345*%i
-2428503545.18056784811925968850-36571684067.2752612555208054996*%i
734128658.458149068515711131258-402214636.038376915644995029453*%i
-14613354.3445066240797276232630+6455508.74865699732122244820932*%i
304786.723710819237023256558084+357270.500116050149314610547340*%i
20573.0160756093217192130453734-7308.58052929360213041069572050*%i
673724.193565043208539207498527+252169.489242655415538523382167*%i
35892678.5727085309977383342630-25734549.5627877516788431885589*%i
-7127838982.85584398303261808761-5893857671.01936960756955158566*%i
12233994498244.4838897498017021-5242281683461.61142292982750544*%i
11725862136943527.4520270569357+5267142436248479.64705115534505*%i
59194914145435.6877627285410902-40479824681183.8014859546318544*%i
29131352336.8557239510016920311+15948219412.3909179486860711601*%i
-5417058.62603467000627429527175-114162949.476675834456448557397*%i
-1387753.70642377041852341935862-631512.301291476679271370021992*%i
-45788.1588930812836994932666287+10709.8908263280660419692487998*%i
-980785.446390439244200884413259+243689.826361802179535029387051*%i
-79307643.8764400201766689496576+10157723.5482703514926586258183*%i
-32128472065.7029513658239914430-3298131511.88063731591249905176*%i
-441867010033545.538500252962484-414605415366252.818755183069851*%i
-7088362221521245335978172959.41+21789626580817670865464265069.1*%i
-1426086094955240.96700862464356-12415839136427216.5490472270808*%i
103433647540.960985160701651769-107768702654.586382618545229719*%i
193445476.768820913736679468840-114392665.433531716382329192831*%i
2042700.34546775095718543117734-871171.290025944564906979654629*%i
56394.5552701348875178996219777-19121.2401581560002811027886467*%i
569260.157407756948986589893768+220752.805842179276765119387555*%i
1304690.44113710806733361052964+33370568.4182756911073199538506*%i
-4653840905.34180651660576096928-2564748669.62521983528006943310*%i
-1185834073440.18780752989268158+3181623451853.11247739556527023*%i
627715947781354.669985144460673-74106703394771.5149858714983837*%i
8161385311219.45961227247372936-10751976667790.0512640112758963*%i
-3376111432.47506372822600381154-16979908955.4033460562366663497*%i
65765972.7852629981815785904169+51173274.1764759189716819092850*%i
-478413.645462812965121344519978+1179171.79169566027815222875729*%i
-38614.9014984213932996174005534+16296.5078599724063865915574360*%i
-155293.990761368018294651584199-102129.052775799572936308747202*%i
3515774.14775427057231123600147-3445161.33696955370614497281343*%i
-82691529.3544016743105549822338+163021422.708317080674960530738*%i
5703711340.85646418383343516378+1685342151.02774085620002731958*%i
32328178851.6867941170273779713+19414177422.6708823706035917141*%i
5124037156.62593433814903107419+9163559920.69680022563093681147*%i
367926509.289846587971823385947-102492710.524858336183869107489*%i
-9436706.36004686083580422512100+3074745.12365863039162737136597*%i
21424.4783095816772037336292452-346176.919560985520750891879921*%i
17355.7998120505265522023968866-3960.66462333019252850507233878*%i
37296.9181503733567224719065848+8742.60478111868660565637212688*%i
-297003.140780331122359108251381+388764.714223107961340148096038*%i
1696855.08302892237669439306865-5661976.50592973069687893369131*%i
-35373237.3755409288935369011303+27635680.4198060085102865332360*%i
79898523.2767568856065806522884+78653162.6549749150672482334925*%i
40581863.1181981472269599096257-44474480.5535447266107778231832*%i
-9371514.03705431541414256624470+181984.069014487684326131199919*%i
800558.838243951649061150933623-158189.435491107552041294847773*%i
-22613.2634103538350418962181082+59198.7616155841879565221442719*%i
-5114.97603570040114284146653031-1730.60205745440884087290784656*%i
-5442.27791110214115336320619778+4272.68493345137432144787422650*%i
-13548.6251678531215570091771354-47434.8108819661825469150684830*%i
228346.356778569199365783088143+174690.880370402778182421746349*%i
-886737.906405118395556821090346-576226.109793379382919817702847*%i
1134188.52707923423484262409230+1431477.36355256357154256424733*%i
-378390.311631584222448031668026-1205750.73340844213836826255315*%i
108188.298594972790346275150768+375568.135156238998424774156585*%i
-51750.9924237563618183276232448-49795.6541707163705643156129254*%i
9813.11447808785479560006174773-3198.60855000045705239286644041*%i
402.886643676301226807119403172+1329.13172357892790121032640350*%i
-544.939348511528212219335443480-1163.62776346363843585100498461*%i
5862.76026250661365527495725943-1147.53259000616732348243032694*%i
-8943.57958989856138014499333455+20014.9633952475578895416175963*%i
-10630.9539578037715209948528668-53267.2705563361428826595105818*%i
43817.3642530974817384888592903+64945.6890026892858699715365679*%i
-50475.0551938770395759647786231-34724.4893266529677242134642961*%i
27242.1901507691910975735143517+1149.78656303759698566240069365*%i
-5281.84155790517794565533586882+5918.78028948459735790645645118*%i
-886.488982722431156472568928098-1531.02229567636427337004048543*%i
292.663466629008780267276368402-181.501705964759788167061782067*%i
-.135094949455815174261152850794e-6-383090.993539667251276878859770*%i
-.227820064256550799620114048837e-6-230222.948013010989110778292801*%i
-.385795731985057532390792286598e-6-137788.853306846244933369996969*%i
-.656204708021528937287617931460e-6-82109.3754222351640413519001589*%i
-.112137194153106173211779650695e-5-48704.6826070367787999716415418*%i
-.192579144998509839781575952613e-5-28749.1518108144901974660278497*%i
-.332467049294750767045485948847e-5-16881.9559525174060521337267648*%i
-.577177069057175692647936177569e-5-9858.70674322445440686528236101*%i
-.100796126650324828107619417383e-4-5723.48416676876452728964413274*%i
-.177141091747337845267554156619e-4-3301.98283975043985742617719501*%i
-.313412630045020889685737645220e-4-1892.24967057926184491538721992*%i
-.558512182111913021452436415565e-4-1076.63944001255442666256143105*%i
-.100295907452748273989896261289e-3-607.898105177230508062317407303*%i
-.181595007520206851251313510013e-3-340.423681672240636396897044390*%i
-.331705916703794042784523959760e-3-188.961793361420119064174963035*%i
-.611667280437275969868668664414e-3-103.897415113215556672374849079*%i
-.113947023755510849875367890357e-2-56.5451731661115673293516297637*%i
-.214616010804708043888375917922e-2-30.4370601759422710110057981126*%i
-.409049142085116812389294930403e-2-16.1907488464920757533680476420*%i
-.789711184948917406878711067360e-2-8.50491928775922567875986588085*%i
-.154601682994693393114577562445e-1-4.41139615202470882968235791068*%i
-.307285955723388838364420239237e-1-2.26581890704679509120732051742*%i
-.620937094849043833669817968846e-1-1.17008756227988463631166810727*%i
-.127760757328349522073174740926-.646739743167283592025232305312*%i
-.268131684234402776726094303740-.462149085388597778279438847429*%i
-.575119090368605270373403175175-.544070125315119814903705594384*%i
-1.26358825789471262229410695461-.976215870373276522255101697175*%i
-2.85111393431768209525296877498-2.09754823623652743958141864968*%i
-6.62643970266473034438290334931-4.82575063972095343746177431395*%i
-15.9186607851967968168127787707-11.5703678084978848686602677041*%i
-39.6872987183803582898793364860-28.8364506771749405524533780498*%i
-103.177899993095268131879851110-74.9638867481060266662718801796*%i
-281.302634362624643550821216309-204.378606718648479185392347568*%i
-809.781020685561325615380362672-588.340448004532772641834094047*%i
-2481.72677445332847132136873611-1803.08007684658298838693640750*%i
-8179.75814074237192650727250651-5942.94216794080902986269243534*%i
-29364.6223431834753600679303848-21334.6469539185474958474934251*%i
-116675.657902646177527310065027-84769.8274499822611481655879014*%i
-523884.758776398687433135322439-380624.557025041550951636398439*%i
-2732500.00924672009072439923163-1985277.46449281454102935857606*%i
-17190616.4623294500138654557506-12489713.9425114171975420742867*%i
-137578555.546931650777371239951-99956671.5463936877502987768911*%i
-1515643361.45570206835111669607-1101179359.38656873192957155102*%i
-26023037636.1696858559443581763-18906843550.5613743341678713649*%i
-861214841384.355362251869483899-625709208015.125439036973158120*%i
-82886437357281.9943995591563109-60220521734917.6441528916934967*%i
-61591569916591181.2562152818293-44748894911019091.3508423748886*%i
-12412676261213345874404.3635413-9018337190134075600021.85045250*%i
.218816559454535639096418941696e31
20711446087550396344.1335192442
2901409666586988.78172477978076
11607725086597.8120680766555446
207182559562.548705728026456809
8647572029.92245014010462526580
624038383.623784613217882138496
65963308.2536677751300511041374
9233371.99777917362050092689398
1602297.09974873168718118655371
329380.348616439278664279310231
77629.8963246544932178916246472
20473.6844667799269187988615812
5931.43258407615523621749164238
1860.59378805969307335869201603
624.730142938886242134135753028
222.465748181929152123027756860
83.3824724316275327386506684618
32.6891472135760721451812534083
13.3342968633398352250694599635
5.63441439371061689532491449238
2.45696775577482130373144091871
1.10208405167759110227829746829
.507082623385984594137484466890
.238745263215053001808453945127
.114778172649006894562194129822
.562394640129769715052712219458e-1
.280391307979617019558101843115e-1
.142034897898264116497160554395e-1
.730076425913453988605902138870e-2
.380347304905839760639684348807e-2
.200622453750941363583543268761e-2
.107043426613774322510528080506e-2
.577239180133313444876945781346e-3
.314366389118438996423338246539e-3
.172783016689373535721058906513e-3
.957807336637443027876911698004e-4
.535203886117598216875706597323e-4
.301299089488335964470529964888e-4
.170807380566025861011043666766e-4
.974665923402966736901370031224e-5
.559591196752459077886966630950e-5
.323140561019620870359602031340e-5
.187615944258313861243608336258e-5
.109488679077098075345242905641e-5
.642042433656083807571225652403e-6
.378213023643238365014773926883e-6
.223758295608872735378953950379e-6
.132920252415375645967914884760e-6
.792645513302886032847184964306e-7
.474411965897367748189481597173e-7
.284931127008214525446674277067e-7
-5036.77719466003562236105291908-540.346207913522641336101548682*%i
9097.61533539552792781236173025+37120.2582953364819810004411928*%i
96211.7561271877085668154728051-220346.323103883095453105068718*%i
-419058.917248768233193313719394+858124.602661312218556050261275*%i
87018.9246950526262550365009313-1711658.30385051843039250598214*%i
449080.023798851049505665671336+1064212.48586670633771681276269*%i
-149711.302082911631764925782641-296609.116362973138883905581205*%i
-3450.38038911024685656946550637+56317.9731473216523534091583349*%i
7049.39243511209607176939217396-2915.18365886809728159874488052*%i
-351.194684684440926925724228452-922.877242151894168522567807992*%i
19479.8314692860548298853754398-17794.0141489670123390558472581*%i
-321021.466299121329174820985435-168061.228902722337162522993463*%i
3136609.89809379498588953958108+3839271.64480988635213348959680*%i
-42985032.1682799621133250005623-9717488.30528831062383837611354*%i
22264244.1990920641248114795857-118742646.236834488722493050243*%i
60748388.6468593164415332525695+2444194.97592388142044729084297*%i
-5391250.65250419394750670063980+6054024.39388400447996586007283*%i
495626.710293438688850511193286-367394.470222646637640712970648*%i
-39851.3603010895988946722383430-18945.3132455865583505341749470*%i
-1912.78005786049665591686209091+3060.62576657071423776111515927*%i
-58234.6368168099519493096729522+100294.069362536410061655731339*%i
2972647.51714720437716494367086+1425137.55783699659055476849773*%i
-89920718.4895768510360137924816-115469710.299546884191477882091*%i
5967125600.34403154103483028862-3084930896.14045277274271616356*%i
25217993116.4178507927652230963-51266000816.6304660044506077236*%i
-6337958509.43877156807967897418-11175242174.9766246686934316816*%i
222447939.111572869188100588443-234464020.849555896649752966417*%i
-5454711.87682341882105885082941+4082243.50314832230293650847697*%i
168319.300533669643211693561340+139025.726169073116304841728703*%i
9675.74030190716920386343265713-5044.25749644133421405667733249*%i
225779.180640989010031441092231-239837.779083515112254018923740*%i
-3586672.59044522464592465334612-17914361.5846027345917974436190*%i
-3069600405.19169501633153625456+1318347767.30938896566206806074*%i
723224195905.239744076516344508-3916366202406.14436174055772005*%i
3113420784793027.88201896267161-796623002967942.849206577165252*%i
12552825936006.2575939978341128-16252301571126.0212555911413195*%i
10997882044.9324702244476974307+3713860646.00823231766970113686*%i
-7591708.58065253494467378051459-45535318.6624512097041217881148*%i
-646321.944869389535210257954474-228419.171538402090194351233778*%i
-21965.2275268137617402787158821+6754.37500153502065919341138627*%i
-246182.090072434544495566230873-386579.599076345509152247276429*%i
-14274701.0320515471058711483115-29241143.4149607374763943190007*%i
-2579044290.41827212035437951893-10980870774.5951666259887731960*%i
64297520409221.0753137022038636-150703235521150.816880668886536*%i
-2591603175944525696782928381.94+841024920719851238248106878.760*%i
-218939628758589.514865360035643-3114219243944474.15597231935154*%i
35469954420.9098759338587560687-35447297213.8751457798645483232*%i
77306783.5828485722796547800034-44317142.9622644418768533312142*%i
912511.927539445680759970337674-378557.341185464241282892855425*%i
27441.9468212986791348041467618-9069.30659573661134819296728071*%i
12565.6103064466883373228524289+280593.500555751035674906054080*%i
-12308251.0412397061988316685469+6506177.98560491381923729939854*%i
-2237684.41291132157798153394080-1948263300.48639160030972657000*%i
-1015318207095.61938821872453270+281346362637.468108744837208584*%i
146141723599585.324320517283868+89034508283848.5446593045292746*%i
3405137567164.53557434288691556-2175424984610.00470866430168751*%i
71041724.8718815285560928529213-6157575638.96990762348909525571*%i
23578329.5600105479767290471493+24428692.8910902682201222349673*%i
-271272.919049689230111270621244+507048.307933658587993825643543*%i
-19533.3966622544497542488158015+6387.41936429816806138577648209*%i
7648.77946458489462700236618272-88131.7325042917739282033998015*%i
2097188.76668095756255428440949+534859.683737799732579812966700*%i
-72583119.8459424101796013455186+11296347.6620136180488283996084*%i
970807565.647414916951342318660+1960552826.23099714331299023922*%i
4936624451.67001934395739501026+12273612567.1098189942364088975*%i
172957484.159799020783134581409+3802221171.10382685581565426313*%i
150398609.032314392162727267107+8789911.32154335295257249501951*%i
-4278555.44423119918662715524574+301665.908972943134010452365953*%i
40458.7542092528444221117567029-157526.961295068791105993982273*%i
8927.64349321171514192849847534-644.727737650655527675824502159*%i
6192.33944565998924549156702699+18059.1175982279968477152100549*%i
-229539.442000618045561738904796-7771.42183161570966262228307146*%i
2399934.44845057510697389059452-1032697.35559364286697749407468*%i
-18769943.6206338933762672362669-1980193.29197035452260857815436*%i
6963413.84612760752481702905042+45548218.1542522291536204505960*%i
23864401.8472373994205780124830-7876444.36029016007170592203874*%i
-3800136.58491768901407625956801-1530168.80096837558886944493853*%i
375563.170216423090769027832623+46505.4335002585210761172196056*%i
-18176.1324102596415782988360490+25378.4838642964872914846191503*%i
-2416.95901385247357595454462600-1440.07247713043487056967735755*%i
-3473.97068067509568949151221943-1051.50622797769478648760467939*%i
14436.5978418639854266108745420-20120.7995663573651287214537522*%i
12569.1477641132229865543000253+137999.550215197356865808265728*%i
-125374.556165677405610272865329-478126.378067998823317102302845*%i
26551.7707593787064362376386430+842181.772350280036088642325626*%i
136241.054346509572158509642100-572183.381006027986414775037277*%i
-30877.3935684920448201588739824+184459.940262412422788359859729*%i
-15066.3866997456584807574397299-32413.3455319364659506964759027*%i
5366.52503560944689272056147489-38.8909239192475281130457037954*%i
26.6370070465605482824776008104+753.892331519594113599338087371*%i
329.935668361933729146817038989-628.973362530550847958661493075*%i
2505.01989518574912376590985227+1987.47819050705918773614454633*%i
-10702.4038368502101572705639226+3955.35168913682019669862003770*%i
13834.5414590002845377591478174-24011.4895489617182339817594083*%i
-1712.92457224602548298421631018+39608.4155345429791009702584684*%i
-12568.8933807413778695832297785-28527.0653796081868504451833314*%i
12278.3417134797648923698248046+6980.35181806451103105729508714*%i
-3824.10612014657595394621750936+1785.85394659322634335237563643*%i
-172.665507620873497110008533548-956.023920502362826764453134637*%i
189.025693131354486694046523319-49.9282800428799125198792503863*%i
.393531882488932634625193056310e-7-507266.814628188477742887751477*%i
.660357498718820899863808187499e-7-306445.269024971363143080786078*%i
.111253659354363107294043670909e-6-184403.280000605218116926447403*%i
.188228491950268419744908379386e-6-110505.047866879512982622730531*%i
.319889465630858995899972690280e-6-65930.1198613276047798879329812*%i
.546228350796897642400153047324e-6-39152.1513214901782372328007851*%i
.937419292961555184030664069194e-6-23134.9997517130534249213742222*%i
.161739058957509363742432804964e-5-13598.3716717921930939154647350*%i
.280649859470129749746466161834e-5-7947.99384839881065630508836182*%i
.489941123019965303270716260167e-5-4617.61778683702246261224056429*%i
.860848055352084325675586501497e-5-2665.57230066739730535996746651*%i
.152301015495759408545433680210e-4-1528.20310274231037535882147180*%i
.271444153619585649663572918140e-4-869.717072833154279302734534395*%i
.487626104692227708063654452283e-4-491.076775261053282827653840918*%i
.883428854113923477655664630818e-4-274.942002487860541879652599354*%i
.161513421374787576332054079531e-3-152.536577079652953842227061754*%i
.298194952549096424250383054814e-3-83.7995618751347278533463792787*%i
.556391557539112710643967490415e-3-45.5522677244941704348722741544*%i
.105007258020260118466496724197e-2-24.4806654921157589410518599304*%i
.200644710730421017193564726320e-2-12.9969555802029188466613776011*%i
.388565155836292101421917543308e-2-6.81394539463403536121924651213*%i
.763554397693439945112428053841e-2-3.53301245725268799953794558531*%i
.152451214030987525356950204637e-1-1.82882489216735474234372508662*%i
.309730484223411223814490812692e-1-.984305632826078501240558816006*%i
.641403479674714857550087460426e-1-.632441751437399062343190907855*%i
.135645256484326599805598582445-.625897024042187396556257746782*%i
.293597982668075399075693287473-1.00114378165945685734887475986*%i
.652027300687009149875004408543-2.05121323527170683064378153649*%i
1.49004552208700153475498008549-4.60559386422761430191415100620*%i
3.51571624983643307786674428551-10.8287145628154053822793387838*%i
8.59835489466148483850850435403-26.4665119642748500140688382681*%i
21.8985654450613695727356776070-67.3982428886521718953971787462*%i
58.3990830510115264240207724939-179.734422859087715579565508641*%i
164.156199471436096701351930805-505.221021858522397568158936659*%i
490.291547182834468767347177485-1508.96228716776579702418023956*%i
1571.38208751003388311720035397-4836.21680149578711574413869736*%i
5471.22116320447389268304814703-16838.6873080793651618361091510*%i
21020.5401961365410378693672829-64694.5705057128533095593726901*%i
90937.0032378831258992865966355-279875.317785642650907250964606*%i
455005.564708670340484822256646-1400363.13582707604437691245516*%i
2731272.75752174662912628843632-8405993.20135994941239636442550*%i
20714707.4483948562606275956767-63753314.0913264507500389433015*%i
214332506.958074388761439952470-659647628.146365996793419614998*%i
3413975502.07821332328215318786-10507136199.0657372544801477468*%i
102938416669.361747615257170016-316811870326.181330709530292131*%i
8766689028990.51018751683212210-26981094500059.0010149575608088*%i
5452804559269507.70143101211641-16782006823497927.1513517122446*%i
790307120480216468980.291343220-2432315214014341772716.60035736*%i
219606447082750498163218592884.
4126763138692110429.42465420366
734346935507217.428860656974780
3407523550094.09093969177662223
67724095528.6031989714115204855
3075139658.28640807156111223409
237789042.211452260719226351831
26648360.3221508395033048211330
3923559.94134276292294802605426
711797.412869215535428129624573
152223.987378156005183270676539
37175.1107237204674935779998664
10125.3839076451067857527432025
3020.94471401848686058075602633
973.534202220675043253886894238
335.116583059197700739125095842
122.115392064130477150994220498
46.7604535059777788434640827568
18.7014270213999791600249282197
7.77221093281677001301717106292
3.34209346630354963042829733781
1.48151078889774955654742299161
.674897201429045310242244201866
.315092226404058283063399053757
.150411270866586666839482025052
.732606175242384691296122014850e-1
.363431298214626062141198981983e-1
.183333720761763907057196437286e-1
.939110092946084787844880821218e-2
.487863801607296293396587828131e-2
.256744455506099912884987169325e-2
.136737386096888070304328626321e-2
.736317034296757070101923624228e-3
.400571660895220378662940101789e-3
.219995536536259917355403724587e-3
.121892302641972781482038101943e-3
.680933166392668338787682873538e-4
.383317874731325094178617489888e-4
.217330946671629629155369612407e-4
.124048704186950327842828993550e-4
.712505191363443841554123222462e-5
.411662181419393243980344132281e-5
.239164406376918927764502996063e-5
.139672990190528251349140854125e-5
.819704450014279146107640244509e-6
.483292164677130391211514071660e-6
.286191984602381126197805071094e-6
.170175206199554280801051748213e-6
.101584989334391215465785987820e-6
.608649639338478360625178933889e-7
.365953698615375510053495284005e-7
.220763828773781155889671681064e-7
-1729.41483671513365579006218732+2019.56661645602609985778268491*%i
17482.3882549103225364808518421+7810.09743333216849313500542726*%i
-47385.0629903390546672007945749-105118.890149185576780327081018*%i
126200.893268314440736947999642+424523.321633619638736883422559*%i
-434746.161869777252149594116793-651797.064119900295947663253899*%i
428323.731114177720821792465658+317540.060581521526581128494204*%i
-124427.382101695739052691225350-97533.5715321207193426816746423*%i
8245.82381651820748001769096612+26769.2127767603045895742656660*%i
3059.59167354804474837012336209-2524.93906811753549355743103003*%i
-309.155989618196566129364238148-439.673775621480714496455257408*%i
-2513.52645473387277986091858840-12920.4528506001859687587772641*%i
-150281.631850863524098100556439+78844.0383027462420567429919164*%i
2175654.62834046004507813884172+156.628846149854507707059199487*%i
-15553369.7222097889111082824761+9633960.92031337952571216548679*%i
-21568497.5517573929387862365018-43854224.2532604361689591430278*%i
22376584.2275057435952159873221-11220955.0751352189062343453038*%i
-1162889.62405666726388648517138+3315655.80252524916047333196254*%i
167515.625043136328575574165136-230807.325342237630826212816347*%i
-21313.8225929462752063326928560-4317.13068366141359388350523857*%i
-662.819905109978830283119674435+1765.67836670308496768486159151*%i
29632.6706328074446560234458758+46750.1624984476818850276816254*%i
1198350.14408837161435395996064-812550.514826263859780121810699*%i
-58232090.5923841975897710486774+3358122.88081823852293125082848*%i
606641462.915039828006614329553-2345160288.62805147591183250643*%i
-3723006351.84886902809934473499-19109954375.8334032639247935357*%i
-3744937169.83279953894528840930-2591797750.05783103319163381962*%i
54756556.3813594180082064426722-113688535.133150712424658470117*%i
-1897412.91866673173314055935648+2242861.06208552969850545654147*%i
89201.0024984596615069600178846+50676.7483128954866291169511460*%i
4487.90765066932788272686165692-3199.29642373713309219092781846*%i
-61984.2190624213265693737539128-139280.527479643836048010400418*%i
-7445302.93267199509691792896996-1717205.58335461740340444857998*%i
-83440543.6993936688742763491827+1217254948.44142345584512580570*%i
-865132882316.016119059147846983-838878872403.199144790074883070*%i
490181845346935.889884400793353-647992756021536.472709134564466*%i
2007713550660.73651703478767524-5597568245686.08621912896275806*%i
4056141518.90418197111098464778+615274348.127800167003009959458*%i
-5261197.45736961879996231113417-18102608.9617671912620925176280*%i
-301652.754345850773532295948813-77847.8199200402846289173946419*%i
-10594.8502355333084915895125532+4068.70192290188046243165028516*%i
132137.910688673865163080609094-163322.825134657995198810139089*%i
9509246.95753406703564776933542-9423644.52703073597181350941359*%i
3366992048.26496849139347200027-2128120396.12200826205843623215*%i
44739191866670.4575125182906390+2371713398910.66638171699859205*%i
-264988326483790250371720564.361-192676399041957674848463636.917*%i
-20518882990045.1401581793810268-788347600780392.502598668136295*%i
12288208679.5257032067360648870-11779097668.9409348734939406509*%i
31226133.1486944347778395386867-17345576.0213403883388674218514*%i
411991.735972027450075846482765-166173.929315739272335597397076*%i
13493.7047838586813550568283861-4344.83855367529491936475659685*%i
-117073.941667601841054313325237+57887.5213085587824013076765793*%i
-4714997.90536564059734496278449-3492467.27955099014846533635109*%i
631826983.351862945910240458396-349983804.969329565977281562812*%i
-258414280926.508497230858761936-206192226364.867238362894862255*%i
16457649831070.8749395947120751+43868118874551.1461855977000293*%i
1194875031985.71862582266653015-261624520219.261624996801579120*%i
481662037.206478460541635199398-2161862804.94461586704181566274*%i
8194346.19765872703686177348782+11333462.5044300396581017402149*%i
-147638.726205366404865648326345+217266.013404463764143228230747*%i
-9908.54394675312907852458869467+2351.41123328886802927678128773*%i
39065.1042877167799980180367016-16891.8085316721678133761325665*%i
280418.581359287194574951961088+920393.523588018884766111307471*%i
-20949791.1972820531935608403720-21264360.6623168368897593534309*%i
-289815145.667504475361065281598+760529326.832881323635557327651*%i
-1230137706.14506766578119928636+4529815893.85557908560888092781*%i
-567541020.463364494485702559680+1274896474.73382872446972837834*%i
55624270.7526548311738687195764+22747130.2817236521584475125720*%i
-1845948.29891944876117824714172-324179.005932315841439769384835*%i
32876.2413975257255748261819260-69735.0074158209926004895868141*%i
4534.04594352476476220927327539+361.904473765075512909986037183*%i
-6052.67303997114808652383027917+7475.52371837593754689998021732*%i
-60123.7234510799109153486467320-90950.2776302586422987686506569*%i
1042774.80422743240079468333329+526194.756003530624203300483853*%i
-5153734.01372163640146053915001-6154308.83981708040185337729470*%i
-9012838.54102276541962523368081+16902936.1467300795307686193774*%i
10412796.5444202428804993961665+2038913.25267016217684971832386*%i
-1281474.74394993693480537535722-1279522.89706930830201124126683*%i
160492.939725408409496272539903+75741.1296121541406799333991581*%i
-11956.7425118210730786689178796+9935.60377165501131859977549305*%i
-1086.47595313539517412679786678-1007.35078431413983283014127397*%i
-598.977481060139749202805950857-1829.59797139205888479778741435*%i
12558.9398751727549314589843961-590.961283896198163673527054267*%i
-45390.5420194344497003624219553+50044.4905430388748913222484302*%i
108348.637285251076347371030496-207122.597507583324920053834975*%i
-224371.184972650274294062868002+323061.115859593489643009405008*%i
193080.749712579014376047561067-198588.811200618704467993186009*%i
-51988.8493785060425591658506031+74123.8655592940478701942523795*%i
-1192.78586626926003456454496925-17953.5468816622530038948312950*%i
2695.88302521438499884647503901+832.856039940051473563882998557*%i
-91.4244769821854733300168393228+403.963053542340187952486684962*%i
391.625200591995513523759766270-65.3267656907725421705335273978*%i
60.6073800295973737096479526055+1730.43961417745503992097418194*%i
-5428.21716933548469729416988601-2577.73907004517189077476301868*%i
13546.2517646623114218451507467-4609.01127105115336095007598003*%i
-12768.3982051804296418874910141+15789.3199256327282290031029436*%i
2205.69802071762197264226514396-15901.3129375684711178751445741*%i
4056.12611043484648011509996638+6193.43308416370798530340072973*%i
-2270.50443833077781512649585835+74.1236868846431043969422601731*%i
89.2580695766260616955448966576-532.094939598524966050816847918*%i
112.134974241006654125131107866+4.17136380634618681001307216006*%i
.977581091824190788489726453081e-7-667262.942430999074006592549992*%i
.163244330817825758559263050949e-6-405177.078575336263515756604933*%i
.273642589220200219066367224064e-6-245116.048124449974578645600677*%i
.460559142323007450416960805734e-6-147699.921715911748011109570280*%i
.778478504365178735770758809149e-6-88626.8567078695493703676186795*%i
.132184021448810923629322112574e-5-52943.5966187594741824472569254*%i
.225529375737158899467455942725e-5-31477.6042191554348602235911260*%i
.386767375477711845573704074813e-5-18620.7370451029764471146619456*%i
.666900339156280354323461911636e-5-10956.0621483656903183880674183*%i
.115661963702334515177072848770e-4-6409.40014250296659654621918393*%i
.201839654569554330376145730524e-4-3726.61416426909812726850804469*%i
.354561634851789246038492521011e-4-2152.57813765049822423827212505*%i
.627258116032557953494995872093e-4-1234.65840226128036054357285391*%i
.111812184516800788281415792316e-3-702.837040613396990736324469331*%i
.200937315720488889670798035549e-3-396.859863039841941103711257531*%i
.364271350916039392824884061376e-3-222.138961858476196488855297097*%i
.666613089625572346982287056891e-3-123.174282035740938729621964179*%i
.123233621548130671204859789739e-2-67.6074541898505902425682947473*%i
.230328775440340837409958875982e-2-36.7015513144767179940165555738*%i
.435639935383132542793695586285e-2-19.6872573872807980038522928990*%i
.834661112282175646061242553352e-2-10.4242885933352879765039453456*%i
.162177528333481177936669896739e-1-5.44207341699687103420380067971*%i
.319981469587770924131324377899e-1-2.79752641213361308777840565548*%i
.642005477669594346769343953656e-1-1.41396869282121893165537545858*%i
.131202089091889011908980989295-.701523533250144236898226393786*%i
.273612443119123615489185544846-.341008599543697706210975379167*%i
.583503082448617291594838703614-.162060808693763585872009920935*%i
1.27560933891447023132128275159-.751125809541369806969523164817e-1*%i
2.86666777552824813033275437635-.338562048105221305974695366482e-1*%i
6.64411348459177724066686631586-.147919731018397433144330278296e-1*%i
15.9423332701983841941728503277-.624031738007907811247029676088e-2*%i
39.7807742676579049179827195396-.253054340500649221799802128504e-2*%i
103.781906497591723843183452285-.981096234052267408414674080094e-3*%i
284.894348309993792441511545002-.361324823784015650498670073952e-3*%i
829.360895935974024661186149244-.125421719400300046139765272765e-3*%i
2585.00759047977834493337870631-.406405398490804839511617410556e-4*%i
8730.32928666633073048897188788-.121464679322145852370633093115e-4*%i
32436.9002073852252158201458356-.329791299893942556157537716646e-5*%i
135213.473316533638055850467840-.797589789666021876368845790884e-6*%i
649063.586045182681477269723732-.167394616927703765566782011909e-6*%i
3717824.58412090795941194593298-.294213724410967779271870855731e-7*%i
26723272.1992133225442281534300-.411780543839340339926775928501e-8*%i
259711104.533135461181093905714-.425928625605362008395879344859e-9*%i
3837945564.46746591304573657962-.289506053958592546980671131425e-10*%i
105438606629.285915295950634325-.105762945801676965701300865041e-11*%i
7946201774252.10702216874956099-.140731061051174815324809147491e-13*%i
4137151579898708.82815236076861-.270830649963529325344932618661e-16*%i
431236395817314742501.381770742-.260113225301099625472958259527e-21*%i
22295000097885309457343757136.4
831768871493425207.928664305550
188009246218702.179684564138698
1011819983213.41170359553526542
22391758118.1453552805335457585
1106033625.82995954935351828898
91638677.4246888142510020343247
10887159.2405264279272327901074
1685939.83500968454381174719726
319723.001957099514355407015051
71126.5427335463010278659023848
17996.7832786800348981039456566
5061.74044667842817471605769985
1555.07033151977856960191903921
514.782886773885179407796188237
181.643566815664624503806785068
67.7242529626441121626773803814
26.4907290316638657919614218696
10.8068930517864425117878716990
4.57527209882781022135784937525
2.00183682330202815118695831214
.901970804648079206309127208544
.417238787979172543188667646580
.197634426378845600762532730393
.956387453674125941149610239746e-1
.471880338522718759626508222077e-1
.236971455765036760750561900641e-1
.120936025428991568629916182301e-1
.626349882882078546919695981131e-2
.328815320721379608852036510818e-2
.174779219046829484957237250639e-2
.939741805005471026508912254784e-3
.510657317308835304921158123066e-3
.280228083682654342728851704329e-3
.155183894879982294335801511912e-3
.866673266521870288640183062309e-4
.487847939993209566999798139977e-4
.276632511649625741979533860902e-4
.157943315991322490182926983088e-4
.907582833751307728809892878515e-5
.524665082756417293966011572456e-5
.305019289821591877522538759652e-5
.178267892790276291530309544470e-5
.104708712091870369624141010113e-5
.617917020224840504692003956222e-6
.366267636218813684208335728157e-6
.218011841760696902410184391307e-6
.130279110767479008175597997261e-6
.781429611006001708807659186744e-7
.470369439298886979232462935696e-7
.284081045697469082516545414728e-7
.172117331471395781856210460989e-7
366.089838235873130878249298391+1363.13206173030596051855426316*%i
8558.33459749585946665573726091-4575.95306916467242215073609533*%i
-53262.2026092828269669743986914-17150.0276444143764397636072846*%i
178476.907468307345052340158834+106566.750428558759038400987637*%i
-341327.604481999863822042545216-122089.586824561973703973544508*%i
247733.832273795540912574140320+26027.2241863185726941636881567*%i
-74177.7690219852153048507612126-17120.4357115683213807454481162*%i
8603.43441052801833028945974181+11130.8540259065273102957051873*%i
1150.40612457316539562316994261-1740.65109727214867298366363626*%i
-224.354880667471000236874657173-192.792646804128027502803054356*%i
-6226.00445997396756080656315209-2309.43614956477682294680070084*%i
-9751.36696234805710641599204427+79802.4063971115228797270104575*%i
610924.030062020679790091603323-748203.607976755820177401356372*%i
-1819994.85606528376989946861116+7466383.00480979984504156409679*%i
-17823651.9855278696116038638226-9082051.87237396803351221246621*%i
5898282.80701845004949371533899-8600423.31917823391419023350487*%i
80896.4696954288698133159582736+1538665.46442693757501726228591*%i
42364.4733348704848805652309074-126443.655484629915173570156833*%i
-10828.2442573517690769161599764+470.048405408967128218341827667*%i
-159.191725217971509849586359991+983.557233790403097062516982698*%i
26612.7616843684109438419835738-2283.66928214226376116858130755*%i
-43899.1420308409179197612626680-641611.702450100512326477388432*%i
-12214235.5017785297796959858632+20094221.5183606112005698908113*%i
-489844742.836174979145918299774-735512812.304206537040920460494*%i
-5007053158.86363630692378284916-4470202964.94872541921732538743*%i
-1613487324.21007213947927283699-253785706.007585043710311492612*%i
6896944.72645954306684589958543-49358534.3615097988463559140211*%i
-587459.423800152254931191438141+1138580.99878229498928820192190*%i
45904.0250781142468438781407373+16411.8220298766627361455437312*%i
2044.62434335022464785772902798-1933.78017756569629413766098099*%i
-71321.2841737992851381942315309+1573.51566815775418175527298887*%i
-1957716.44402582311911267155829+2571052.60090221211596104308594*%i
386020148.408938752929855213071+232665707.259075667733059870261*%i
-360472262695.081241700361316373+78147167276.1740791026483618709*%i
-5207335370762.17192219366391213-207741098159668.459675757175772*%i
54260886470.8622639274278387803-1741152492059.53003597112470609*%i
1466137180.24105671022475658694-35884423.4433099695706689125449*%i
-3034090.87458499788749344565549-7169963.14573395783728765860162*%i
-141197.521545148924202922670127-23600.2462351869252986294961568*%i
-5138.82537740416427070660116383+2386.42022712873455420821899726*%i
91231.9878190715149011083937918+34003.2848786241462329912567824*%i
4983219.62432541164714239224740+2488833.99680885535104648774007*%i
1111385839.60938797412190079694+888094495.940659918731273372827*%i
3630502752712.74835058786754300+11848168529922.6122488608298102*%i
15328050716160006719999.9285714-39852929926656060479999300.0000*%i
3654805748187.92753123748443239-201476526860238.822542453733234*%i
4302257267.00700925822017746760-3955482506.70870231688893039012*%i
12752405.4156654164638660265029-6860660.04922849249572126599955*%i
188052.053459729804399888903612-73707.2057606506676100528635780*%i
6706.58232348526006859317408155-2102.91875700103757319508312283*%i
-47064.9073576482094979328268532-39434.2378382998300245080533375*%i
474142.195669134601280007733233-2455526.02340871230566588377868*%i
229417062.380951077249264078734+143958549.048450453420394247015*%i
4881732797.36743480636964321486-104822145561.254247702025573829*%i
-3906844590926.34455679214056404+12375209455587.4258992359675010*%i
371037397333.503800803161985225+51278880073.8647005390897324809*%i
333537951.149408017096907011210-733515033.383987608944082429647*%i
2713867.38566201962026256883842+5155659.12341992358747540258220*%i
-78364.7001474068503606253422477+92623.1801214664137255341798308*%i
-5043.70169980416094397535299120+763.600832876199226798271068706*%i
16248.1871134052782890079232248+12832.7441344694654954416316413*%i
-288496.143969864646978748472683+322359.989409481920584896806188*%i
2071039.20459729643996151631304-12094679.1504528879588072884250*%i
-284154128.788911990227465273242+114384547.613565219191984275893*%i
-1333146820.55414174384004398965+1030457179.31032474517788056643*%i
-399951139.756106288013703161413+328627796.751372676615261782554*%i
18267210.1524357466118256366084+15948634.8271530509303284294720*%i
-757091.168318719760655485690617-335999.445582581480591747716329*%i
21747.7607721105519859836794321-29878.1649145889981574348901631*%i
2274.61057027247668863648330081+534.558448704825389253561302765*%i
-4864.47726980901880125235147231-594.085219265603721890814556893*%i
18900.0811830503030003055029740-48821.1186951920435635334386632*%i
120094.212388047876502455165999+514457.285442682140956910012693*%i
247283.402990976404021358136370-3445643.25822024504850036092333*%i
-7293130.84708487888432984663631+3427615.80795253929277990339532*%i
3451571.21851181234289230388292+2938714.75582377190738253741021*%i
-303971.915683325415241269460228-750704.067098359410794560716134*%i
61132.8828313021163512881794634+57880.4509311537145558486481349*%i
-7090.10945891713624904662368287+3321.86532043220097496068184514*%i
-454.321361384410410619722572501-644.865460179964820670799057213*%i
621.044621633598111040142013883-825.139386462708759168811529324*%i
4236.54013812863983565972003930+4874.19707918903467583126991851*%i
-33335.0252820771130511543966294+199.382232548642463847272442646*%i
105095.308806621272301116883723-38370.4899559133357173840357515*%i
-176109.991077669466753174345308+59374.1537672683340796992987124*%i
127505.711181093553902940018113-34215.3382078430097330436435566*%i
-38624.9641179142299087192133356+21805.3946273898032911379809160*%i
2722.06918254185351471059695051-8750.54110110602345306074924088*%i
1233.77236139965587709710434929+854.005651223794510426361935289*%i
-106.025448434608106242777812899+204.028066544956015326577855950*%i
162.959843772776560308351505473+154.440684343324016458299997927*%i
-700.966807130893357791076214842+639.430549711872836147860755515*%i
-1035.74988808921076500239056981-3031.62501854432529622390618671*%i
6911.30066448866324127999318520+2862.43322356945367905110084673*%i
-10193.5844575185060502826567496+2645.85803699816586310309392345*%i
5330.05384216285145993958626180-6454.46209611131014304809961389*%i
417.932913702785969858215989919+3906.28272825639425355244711774*%i
-1153.50586366616382203901102652-448.050330932359210192086372726*%i
147.896874919451604296943884945-264.602938165750092450314155329*%i
61.5942859883092505271320302916+21.1673550505819033723287031543*%i
.233429412329750737219744523323e-7-871874.231084951426542075728000*%i
.387942998753673187992810379763e-7-532100.249153717871857297550509*%i
.647091527501681501666169148920e-7-323587.042912184989480755509470*%i
.108352975403366604813555453333e-6-196044.008572943318626636107676*%i
.182176520476799790043760290991e-6-118298.745580802358414859709501*%i
.307629117354367354172918434989e-6-71082.3830454413827157161632136*%i
.521869295830198908849667503967e-6-42518.8253282540978598249719727*%i
.889653274916985018500188492921e-6-25311.0528933271480041725582735*%i
.152454658742708171091085962704e-5-14990.2921311457990720135208778*%i
.262705709644256638514083171852e-5-8829.37579329487285018840111351*%i
.455374183383710136451482847106e-5-5170.17807600011721276102477249*%i
.794352468026967645585423998531e-5-3008.54928236651419919438909045*%i
.139507097966376299362368456679e-4-1738.95616264281684259103004431*%i
.246790357717918484466715439138e-4-997.895309075726234111697577321*%i
.439987279886088619237736088414e-4-568.211552616172215357528129874*%i
.791018303592047284415769286941e-4-320.851443972636709892817055953*%i
.143498730481709695476143704147e-3-179.547745578388688485663138717*%i
.262866374565083718275077169769e-3-99.4992930563270226131415322925*%i
.486621812397708088359486602514e-3-54.5593056051817802262373296881*%i
.911171918134224926621731708916e-3-29.5747649774642863500720387550*%i
.172738097306784681047193520327e-2-15.8302520672634307817095570445*%i
.331919414422819302572966661222e-2-8.35366352611384373467746217007*%i
.647247436294215540236365623855e-2-4.33257917029311151286338424681*%i
.128264331679390752762936177737e-1-2.18901895474692813609313247985*%i
.258716317348008211071187008676e-1-1.04118243988910020377311503689*%i
.532111026108467337124362275113e-1-.388954965905229620193709997649*%i
.111822742368668000834869899235+.774460966553722697403197905057e-1*%i
.240673471429352090591440016774+.615087903578815151942836074272*%i
.531955588488906310229319937719+1.57958469784484590407939704611*%i
1.21127193341601246017081198199+3.70227904404256656330428280267*%i
2.85187457086553697829831087974+8.76614080674655935929880337002*%i
6.97320844299863660907017142121+21.4567631133608272043977623037*%i
17.7990934859154480051080923470+54.7781667956611005947047558189*%i
47.7230782112128861967598244842+146.875849220255260527159600533*%i
135.427419431288773847798820518+416.802495953948871846780632057*%i
410.553401719409231671911770079+1263.55336450204696122361605866*%i
1345.10582669588553761418737256+4139.81003358203046855815672722*%i
4833.51856068543882771120531382+14876.0404938314771136243884860*%i
19416.6394904484728604401533968+59758.2717052573416867496462130*%i
89428.4085072240689880927927486+275232.340618081136793550901355*%i
488843.468409936023845690851381+1504505.49498084007522571191132*%i
3330374.33899155978928161276802+10249838.2757452296813962441752*%i
30403029.8273518266776579665896+93570904.3798889025419689412945*%i
416857766.775969513185882150347+1282956286.15004267987669517130*%i
10435051225.8876415676214892123+32115785367.4948408977542224042*%i
695942667814.431265035864680103+2141891291550.30119594728891822*%i
303308685088640.630708263756201+933488146779582.533931025039135*%i
22737547781411927146.1929569876+69978976482587195408.0784577637*%i
2290421118564914155465682992.76
169643579459057825.571263040721
48706808403791.5359330302035432
304008618796.190027071484808995
7490867312.68132597584667008009
402482095.726451544785231493579
35728248.8602406121958554389755
4499574.38758115193682559791803
732789.768099158976098993261734
145253.268668379714742956624458
33610.1494319984243927822982603
8810.08565809872256112518349915
2558.47163135559941813854838610
809.276563566388343055033101545
275.157824541659232674820981162
99.5113059965696509103293697878
37.9566851287177512544424235432
15.1642199663836149489382424809
6.30924972448730399252360091396
2.72069038818834369229157526035
1.21106434043645702026717668272
.554557964204876328370959633524
.260457451148545133869964831597
.125150015778787258902273334772
.613859993347065505778316734665e-1
.306770849160523368725938361385e-1
.155930133306215460692953549900e-1
.804950755338180973202787193344e-2
.421461993569631044757463228768e-2
.223556754891914026747460080367e-2
.120006010202041959452646181928e-2
.651324378246314311076497212543e-3
.357113041348971162834303187252e-3
.197651169764894843420229238537e-3
.110352337505591560703209932203e-3
.621131312497230113091961509532e-4
.352258233423557970586536035737e-4
.201183725833551268357487466593e-4
.115658140830983582699635308179e-4
.669000426241146758282087801149e-5
.389201211803492072939484130410e-5
.227648265252575150279898578244e-5
.133830230668546209393133244711e-5
.790519348962482321023329544835e-6
.469048856630522952618508627081e-6
.279485391402319731423392759099e-6
.167198407062979359966661232078e-6
.100401755129804423520589496167e-6
.605058968235300533683969949542e-7
.365863197263496684872052936640e-7
.221935888116162149172184259581e-7
.135036933430929688063069725644e-7
715.421455162686278826387515840+250.480270062448628503879571075*%i
831.054842258063650896960282311-4908.08433529182541200541248641*%i
-23786.2113220542846117159469629+13775.6057585462889523460207388*%i
96699.9684295084230771520227917-20171.3914635029169467866067930*%i
-162462.456661636435534850697847+49469.8621600236937230982058654*%i
107183.640187822263919440533215-48935.3382542345395590722038309*%i
-36289.5136696373513135124712054+7755.83739320469033261758463691*%i
6079.80005049970969080591098284+3764.79032008420909830008548422*%i
315.619134237492715745401581056-1064.49336202730828519250470408*%i
-147.318519115395187338914367648-73.5455708075816124055826323507*%i
-2658.20012050644244032940675152+2101.82571591069490293595956852*%i
28826.1025965459750717459831579+25574.9934088222314943646235594*%i
-87017.1870683928442778183101982-425203.893493058020213063174977*%i
1675092.98616717826793472330468+2805387.09105519992575297896318*%i
-8167233.15700541479388289364611+1412199.71702974382884780626760*%i
423743.963311756857445633395338-4377210.37362766269055488215493*%i
292473.929342949731187651721680+618112.178309111888769827246650*%i
1222.07874162043088095717831369-63082.0345033724807942316383847*%i
-5242.72091459039973482670397858+1540.83751158589355498068285129*%i
19.8584652108010977199695216947+531.932457173669754156640606055*%i
4995.57232403856869599760945788-12041.9592949244132888284779406*%i
-259106.989638682851573913723165-127992.716510334680319713495058*%i
3921518.43601531576938869851591+8754557.35772350165435521172758*%i
-322949694.201864061223805143413-46315199.7321324397517886255280*%i
-2334624029.48097180742212414255-185347041.046049391955265815962*%i
-567496615.795755998530749723870+171351897.461597846365755863521*%i
-3387861.84449846416961977982185-19627793.0152994334653403149474*%i
-140344.321134286336330439750624+547598.036456633164642962762492*%i
23091.0078437937500092523446634+3976.98414119951918043364157373*%i
908.673033650430332381240903014-1133.89919075857072504790447778*%i
-12346.2089894529588433868005149+31423.6899151853930830613085131*%i
658104.271896273747203427619122+1215929.55065904240843584245536*%i
143216019.074016578108527548493-88700068.2067033179691118546743*%i
-41710973700.3945985091187861425+106353436399.450167724675331926*%i
-34555606761333.0131410922239559-41213456824645.1969516760340388*%i
-143702500243.572514854435732972-495972357080.034318941679628172*%i
519958852.451085041256957660768-105055547.769055207661917719992*%i
-1609501.08027285406457425343296-2826650.50030489674000605449141*%i
-66326.8818038326297005796282817-5243.23002305816683550948479075*%i
-2506.42965270642252640328324115+1377.72040701076441649444458019*%i
-1519.88947913635234855200075984+45609.3822726490509187688342367*%i
-319028.378297585588400113093961+2322586.94420439846794671742638*%i
-172043657.292266879849057472545+484445059.734418255236773738277*%i
-2765968796755.93422678561642762+2092354591485.86827257962815864*%i
3969740290682913007794640.89375-2881779005203463279809412.37937*%i
3243458199548.34598305385768301-52001616757909.9570948688106475*%i
1522794325.89403214957995131917-1342678591.92709941026546904179*%i
5267178.72477090110454417646334-2743002.98097372583741137737398*%i
86803.4749742365362594858624789-33043.9066668686114018036549530*%i
3370.12290683872657253608139311-1028.56962390161521172262118727*%i
8166.64727630091919296036066305-28030.1208666123765113839360989*%i
1043216.46291802791599792365042-272847.781550583635579347390779*%i
-5751861.81795785498873734686487+102598719.415902349273978864507*%i
28187454421.7783520861638285211-18479750503.6474867072454269822*%i
-3001468995029.28479135342108932+2054657597587.60716442967324662*%i
102402539258.898213941415906721+54639982116.7952019356149389886*%i
175747584.647848281807148239108-238946447.904863425266740169655*%i
826449.831497211556607771977820+2312251.01622809267089979475408*%i
-40944.4997881876931338542656004+39191.0415438642419044217942677*%i
-2577.80070948481769039213858475+175.113295400108954852896356919*%i
-1772.27009560141998677899307185+10032.1894183793243999329131873*%i
-193408.382588163747263610953940-36279.7675230036441997769320742*%i
4588565.61305353134812393179627-2235505.28994662087573140733167*%i
-105484593.319708965742238567515-49852640.5740756660237380165359*%i
-612133009.523862196418189533167+6375332.83271237774661612748983*%i
-189480483.231702541552124018038+43129036.5330047399737461798219*%i
4952770.58314354923110746428382+8574389.98601916478931838726458*%i
-292335.899808401169499777657375-227403.209742434602622117954116*%i
13067.4260489619859675989784413-12258.9178964693522077004030505*%i
1126.56102469851588136281861774+451.762391813838520573499404687*%i
-1068.26036240712426199793467158-2288.64647294448851303580149629*%i
24662.2752663754937427610717919-6225.59111437209550367280117160*%i
-145445.812199453488766923062230+193201.972559094942457336418510*%i
1121264.22880049259318914954114-1003625.50942102039131344170989*%i
-3361730.76624803412968279472741-689412.424628322121316240408044*%i
679131.609121232815950161819677+1839033.22811906973108929303891*%i
5950.48814103912524983998714244-366567.548379816093777567113898*%i
19240.7837618810114818865668789+35537.0662107542742865193598654*%i
-3922.05370296033122167452119765+729.022358528327931055032013055*%i
-167.460965235507081918503558178-390.323037593297683729840732077*%i
560.113307292198530909395104531+20.8279890734406145023401262282*%i
-626.606205726549005814416967762+3298.16457575826911963257708118*%i
-11324.4872936813529249243154245-12206.6995391653242719246046448*%i
50167.9163303909450335297130568+20568.3208639793714771174241758*%i
-84587.4085033853976221690128940-27417.4753404189368646194646773*%i
61321.9753174322341106806631182+17289.0687456950711140341533145*%i
-21945.7685650346441858002484073+1525.04770154056652426269913115*%i
2928.28940015408170448850070695-3706.92996627175273587998521053*%i
495.422494682935857469050355026+637.491178886060525505650597577*%i
-86.5397329164499226108491836268+95.8053041463938054015041931739*%i
-14.5126901219746118492457267335+127.650228239030566012738537133*%i
-522.011816058136882957818499530-67.2311386878942941160842912447*%i
783.317122210262992932529938761-1542.10126717408375758319687315*%i
1747.93752621882091960576238443+3554.91576426174385093838171324*%i
-5132.34859678043047145323938943-2067.35603822105782931446050233*%i
4184.85705108113177360460370498-1426.54199492668412586775620378*%i
-755.095543933746410031223334224+1971.59013801607175514284026390*%i
-488.820167811286634278872980822-476.227094493657022916820236475*%i
129.671826382472188843459213149-113.541786464984087619710138282*%i
31.0526552824907878121405602374+22.3152646293937133217305645671*%i
-.475381686406504010837946561827e-7-1131558.71930978614788566589915*%i
-.786364408011606543158667349277e-7-694012.956530720703923562176658*%i
-.130531961596416631504761223097e-6-424223.116810339900964022054636*%i
-.217475034977298310232088586467e-6-258385.548500234673300299899793*%i
-.363744415765636486698326508979e-6-156780.835257610716658987734563*%i
-.610914068050945920933193575297e-6-94746.7806498277965291405860330*%i
-.103055621124092911933147995761e-5-57012.4750252175596573735379901*%i
-.174659096818815585094237733048e-5-34149.7020567387796037040357715*%i
-.297487820150711586081781112513e-5-20355.5386889781180392938093162*%i
-.509386612498557410125462503718e-5-12070.1390392030498216032145829*%i
-.877164035414600469688108536431e-5-7117.34860120668812674480852642*%i
-.151962978435208276911225901867e-4-4171.84610136108585560808616672*%i
-.264973843285477891237826911341e-4-2429.70740532481663379270112948*%i
-.465241745317563440850533964772e-4-1405.36384940281736853453439386*%i
-.822975534850463496309528778096e-4-806.874093430376319139651881000*%i
-.146748022269510871949704916474e-3-459.573661994813114816065149986*%i
-.263939555792941799905706930841e-3-259.514193183962698289111440241*%i
-.479161694124448979123035112546e-3-145.183905473491691593255861460*%i
-.878691071071313954118835170006e-3-80.4058931560269581356887745427*%i
-.162905306903577526817221856077e-2-44.0442426925204370553229387353*%i
-.305625966905978628953222471822e-2-23.8390021975797451611083573910*%i
-.580846725164082071536273451855e-2-12.7338928092422310225034596497*%i
-.111960870801015704309666326175e-1-6.70157236453336530001485057417*%i
-.219173311124347250011372032207e-1-3.46368159257564999321899318163*%i
-.436401495714357678620852844149e-1-1.74212593844630041894408377964*%i
-.885346333711996783833060748548e-1-.823011132028316628290698335065*%i
-.183369508964711807624977216267-.301468528287063960741495315885*%i
-.388610353002042478951656469700+.742761139171589711639893521547e-1*%i
-.844918004325681481750222567601+.516821457707907198384166434386*%i
-1.89039585924044726958623703732+1.32947930925090947023532473168*%i
-4.36797639093054858350533189627+3.15423383158560024587265627875*%i
-10.4671269577045389700075147071+7.59665950980175448647999939687*%i
-26.1440372887968552121168124482+18.9914495030265417159181030387*%i
-68.4752137778333489746248157547+49.7488776016920332905256012495*%i
-189.448063933402153107063476207+137.641608259005959102923288528*%i
-558.671142786509822114953965850+405.898184282342907324592979119*%i
-1775.89366610005533727710696658+1290.26222274021836291211050272*%i
-6172.70264310069624845257131090+4484.73096815767618280866922219*%i
-23898.2595618446385455977108063+17363.1019131371500723969023957*%i
-105620.597106195563009909502752+76737.8556300917987795826641172*%i
-551034.171673315014179690022412+400349.760104700511373253908912*%i
-3558467.54129716984248144975304+2585378.00327904024417315539476*%i
-30517149.3657265248196185370701+22172006.8476921417499049180696*%i
-388246084.328373599928533036128+282077291.596119080132718396404*%i
-8856126440.39457604551808145396+6434352492.33939328091093530642*%i
-522709544489.042872951660448954+379770713865.599863439159184397*%i
-190701693285491.092570552503326+138552890334543.654135467050971*%i
-10281715689309983987.2060749165+7470103709143657446.32424248994*%i
238191177341902260642855170.977
35024380542346488.2153464025164
12772867760371.7728088466266182
92457286298.6573560398434668121
2536456524.62126575017457759032
148234645.028248203511916163720
14097368.2645607380794691425177
1881851.92949889950431595427648
322279.916801265338734384988120
66765.1474184279982785682348194
16066.9242487139226536798364334
4362.51925148980121432934399275
1307.91299407305524726840302908
425.896846726169371587096333062
148.710294550538097009451524816
55.1144267534509433567041386173
21.5035609410006558353846244154
8.77325427219302646884050803953
3.72224195750009011505159751690
1.63465558480120688091007753951
.740159391954750639882074139578
.344393778853259216977401848766
.164201532714041310171760649472
.800243513271638349986319839744e-1
.397798121580791853281738956311e-1
.201321298658794034216176841391e-1
.103560370666905992635040439813e-1
.540691176888407583422797739258e-2
.286156621502652018921856501679e-2
.153343722918148866595688220752e-2
.831185720029556740881594839268e-3
.455311263304170461826454142385e-3
.251852088012123192376095810776e-3
.140570207767632545244456662889e-3
.791163306482225326026827441073e-4
.448751375011699121167007708810e-4
.256376320967221657266133721505e-4
.147458358441429260449497024314e-4
.853465615057222701297430366663e-5
.496878757320878755095749306120e-5
.290870891428076834759349136026e-5
.171153848514177575979400483279e-5
.101198227743906625519650857605e-5
.601081186505750947534602649654e-6
.358551341658023063661719607577e-6
.214743710639467150084029085964e-6
.129104504639445889547032020462e-6
.778973089120644626070567567717e-7
.471605173582258949603919406775e-7
.286438050691206179871260460662e-7
.174504017890849708114868789289e-7
.106618928639725696188985452343e-7
331.401128224875625203510529943-244.730503989310750403100351271*%i
-1753.16522075545204837038988081-1899.58609621988503625143513231*%i
-2832.68210434063418288015185017+13377.3353382728924841685509577*%i
27657.5286291510969261850798652-38673.9471004761401009842430733*%i
-47875.9205622201673439922734892+64830.1570350671010117727932267*%i
32333.5426495139473924265333589-46275.4681689010639033007581278*%i
-14613.9214609409914844000339182+11046.6648732706589662361977249*%i
3608.98510700286717229636496627+720.530267904449966286443435627*%i
-3.79359052729920461474378087997-597.970581216085822685151767366*%i
-90.5383046874953242928109361266-20.0102275804265502221600365144*%i
215.285717680022754525161204198+1736.54227550518937318665786064*%i
18152.7913796973772121879164204-4474.53908960980829471833597900*%i
-174955.395187320753154706691905-91491.8568707206142967875794481*%i
1361253.23847497353452595129611+354636.654711474708927290761809*%i
-2388414.92191168921299363627152+2527681.55270639005170292893027*%i
-744901.884687258883292410403930-1723758.06862483373854640770736*%i
226930.084937711474315187433014+207154.972809730352132392597576*%i
-8463.36037413379857493820828675-29007.5464346649788642909519061*%i
-2408.93223423967780013659264646+1403.32790862548333474193890511*%i
66.7427957994309207527815164498+279.823690461987201596057035988*%i
-4143.75954267318378046121745792-4927.07786475050556780011209734*%i
-109551.781527291688729675328045+72605.9098472774411977742356244*%i
3895682.78302454686809271503511+717071.531132754522747940290222*%i
-93379351.9184451377272461752157+78421150.3724823790418919239426*%i
-696339566.720854683422371071621+446704759.823715806450733540543*%i
-160507694.940853092581220804784+147250614.363447329958978089543*%i
-3723796.23665502159826079465980-7145998.31341075655281711140708*%i
-6528.87278400395165817916297633+252348.644897376691209186361839*%i
11394.7604793245186676197889743-19.6523478813786529288167697233*%i
389.190145612537667175296490213-651.478973690473869801486919758*%i
11598.9393810666086937580825861+11259.3028231637269963194057125*%i
597032.001535961081556151033900-43283.9776821950266967759856550*%i
-5144697.24607050763791765183036-63519500.1881000891459846608568*%i
20514684380.7405905825430033048+29359958732.9000028082757503162*%i
-13809477065395.4261669207567410-2804270158810.62978446512636097*%i
-86863856604.0349608350437435933-128307122770.251310249958274777*%i
180773049.412832782222717012935-70973529.2089779315405330312844*%i
-815479.625532015092262634759145-1107422.41227694898366825555170*%i
-31284.4450595518549474009129663+237.636005519739587017412201620*%i
-1229.29925868962411127345808659+788.202895093796768540588545930*%i
-20734.5083251320042170328149034+6189.98029933479941915531714931*%i
-980474.791612883222420515025143+188737.346197416517648973066799*%i
-188015471.506784261124282971642-1563741.35051873486208203441523*%i
-825676253276.434744614804012431-532605704771.610489125797547635*%i
581231789350415545203532.507027+189117049747735640601179.370358*%i
1448733931764.18107226478067093-13559637720155.4585400030043523*%i
545114500.652791481447746005612-460854077.840766710844987774777*%i
2201011.79435454033001623218748-1108918.36430227138275202323758*%i
40532.3865982468424446914856979-14977.2471592200062885291949902*%i
1712.73855320276449791669598779-508.541014282378544230302309437*%i
13925.6380440201227460955859012-1821.91438430060929978781008599*%i
303861.727040495528324155215734+359206.362248226563180923897959*%i
-35563737.6827787953739356442992+17100718.8921983270826014304610*%i
10241922233.7811572078899112217+3898984592.62922822191140220211*%i
-1029940820789.74389066440494062-66466259133.6661699415038301526*%i
24223330799.6804609370714389958+27181731902.4141401324067067751*%i
82400204.9982737014420081471188-73652184.6997428748757032983430*%i
210370.535083316522082982480766+1025946.69766086161280524739467*%i
-21183.1151038365034723191465821+16397.7080196651511688186481518*%i
-1323.50433320410081973118712711-18.8725122415715121033047238766*%i
-4817.07690716155495747731253224+1586.59168540171884209301104945*%i
-31800.0845616278025032571289010-84824.9118587645597888050255784*%i
1891354.19180421678355233973950+1020670.10246646465917126490867*%i
-13507027.0160133385354243124618-42915363.4997728956006821784227*%i
-180988531.296055715311138592951-133972653.746406396247521876152*%i
-71740361.0732518407330764878979-17559826.3380124033775540735845*%i
792586.846243102996273104415314+4015619.73179367773184149043921*%i
-103653.710073206637471190676826-131715.944620203252027491224223*%i
7419.46304448739385292827460289-4713.36051066739415385909846285*%i
549.854841063535173275692386215+323.102157807238183338674871471*%i
718.281492151015945969126806734-1104.07124396065809565152359247*%i
9505.60526389699440758008909347+8131.70921454770620126977550732*%i
-111937.400321700271998578466807+5636.57569841675570503803383660*%i
663287.191575620037615794141944+26058.7810172121655179025054376*%i
-983485.455150142704686564293171-1105889.57623225035027613472653*%i
-134856.604819627952159190742612+847882.394702776019998456892183*%i
68008.1721295309412608377003366-153649.645026688698228626765381*%i
3524.72836004255387934584702890+19317.3982616330842296851910932*%i
-2051.80890569576068353213510765-143.228341548019492618250432690*%i
-45.4675970146827977897976830527-226.824668989025848803972410363*%i
166.022322205512028028445816139+259.264864558171558217559012213*%i
-1568.27958047161916981220891615+813.875671960635035322473501596*%i
687.488964883348895880740693845-8394.71387836217965798707288805*%i
11388.4153233132430691309267267+24057.8174873085788632967206781*%i
-24995.6670552147161085085769680-35109.6837186989808339743440143*%i
21443.9885259749592453967855623+22590.2644084610087983761025662*%i
-10284.5185662702324409330998040-4041.84789933740353618309759269*%i
2119.51799856977868712706945375-1259.69069828652950996592422068*%i
153.744669197540761581271837200+411.924700883890780841093667313*%i
-61.2562641970935213609211110756+40.3271980504462059716806339978*%i
-64.1904781110550832473661189013+37.6454306782311120348849144158*%i
-160.462055666643913160897125346-248.350263236463026046269543377*%i
903.677630690744647257373294145-280.048714954567676585897853739*%i
-556.337526804489351390776692003+2051.81754611766218320277745318*%i
-1542.34792748511468063863520863-2510.38040214068723663605887420*%i
2308.08513317640148235999050915+523.328756573282452946746993413*%i
-853.781056111536199875439499608+769.768536754234695743390653248*%i
-147.731460135660518917764325225-351.392898395692024876292750914*%i
92.1718863020807122380247465783-36.6994524542864155938988094381*%i
13.8826004638356395715053093279+17.9818467484098643789804592818*%i
-.372281198709038957344138899835e-7-1458602.09980240140130178072058*%i
-.613006026667720109902895275529e-7-898950.946124744039643190207847*%i
-.101273821649016827624380434076e-6-552266.615191043176961914739851*%i
-.167900673905127935750427934682e-6-338135.061884406063355368520135*%i
-.279396584032812322629320937708e-6-206285.339733133205065643158094*%i
-.466768035823477212232201019643e-6-125367.176540582784079220347574*%i
-.783066268532462888093298080344e-6-75880.2761178356487583724445048*%i
-.131955736383355392711725272646e-5-45728.4623293576775652436848699*%i
-.223416489789840914618446728548e-5-27430.2529914069495070933502781*%i
-.380185174638734236754416057322e-5-16372.6937674383282048440461658*%i
-.650453341074917711071762350278e-5-9720.90310934758178539207486209*%i
-.111928260740030056981518972070e-4-5738.84234460354485934708330876*%i
-.193795111641603587705965168639e-4-3367.38376741776059015530491226*%i
-.337768539047151390020491578964e-4-1962.96937344484043532858207084*%i
-.592900600383600730933533381394e-4-1136.23809029146343288832882697*%i
-.104873431916610908435493615913e-3-652.710057990257240180607200403*%i
-.187037605367956664030007556676e-3-371.879051174744408813088082160*%i
-.336557195368448379878697138467e-3-210.000690629391255851813218389*%i
-.611467573754902348921722370602e-3-117.449922470780414419457031196*%i
-.112260420124959968204193116490e-2-65.0036616848096103475560695281*%i
-.208455758440838002082318142691e-2-35.5695819149076827108076860820*%i
-.391902430398950055092408221561e-2-19.2241450665062134204511911131*%i
-.746821187229114847120313249069e-2-10.2523101590311313242959663850*%i
-.144441372767457512640913947215e-1-5.39213890696367022302582176084*%i
-.283948298569595762188811616891e-1-2.80100949581954544073482819388*%i
-.568308054257428053755336548841e-1-1.45194904650756319505494000027*%i
-.116025457397372305807547821289-.785796743453128241176351689352*%i
-.242158365889373751034451744366-.517094536006803333404127584864*%i
-.517991452617152722565636621669-.538182221641967462168273604851*%i
-1.13894420712814652145633533551-.902157592965056078700293805000*%i
-2.58308155157073273543279483536-1.91010395143547093395354537527*%i
-6.06735017911276283327970539626-4.42259556338023427949501238634*%i
-14.8317354909551369102683082389-10.7818584320802111185748268274*%i
-37.9532930416201868794613955987-27.5770449392675475378458328179*%i
-102.388181600562048257921388610-74.3902550846841205989340574345*%i
-293.752730618753011006165834882-213.424164197420881581376269018*%i
-906.102192241416570710945627585-658.321879867558961898843278012*%i
-3046.80659872254195051573051710-2213.63459937225839331679753779*%i
-11370.2675333930963618118695692-8260.98292613919995559966874708*%i
-48226.4097111245158917769336259-35038.5376301240798570406905746*%i
-240158.166765147448637725793980-174485.121603084337816927372443*%i
-1470230.71825055457503055340831-1068185.14278896137854318448248*%i
-11845709.9044571468913388154730-8606412.02000244570960434227412*%i
-139845508.200949401542797393091-101603709.058512206711159451765*%i
-2906978871.73797646972039977686-2112043778.33068115998099830661*%i
-151850742059.728447860616234233-110326022015.565088003493120627*%i
-46377603579823.8392330889599993-33695301347715.6869919706604686*%i
-1798373206967993087.40816777389-1306594616087633786.37207521630*%i
25084494611562149500881789.8628
7322649123112997.36174421941970
3391883144209.58916239850603256
28472975693.7870974142291164469
869632782.504193492512821007743
55276040.9059028445993958414577
5631367.04568501765790860256211
796726.437895416568276734759617
143467.131363899103814639950890
31059.2008128311316206534576394
7772.46845688368973861076598347
2185.75963577182527649475557124
676.434581707230208550649411018
226.724715248762964798720926514
81.2874065291609252273674991704
30.8684989759094621493305865641
12.3175030168298637536124390988
5.13125119689944241303802002603
2.21964917353145208788183539986
.992559799127185147652827872067
.457084756857472942792008750547
.216076350703559453960065799664
.104566250096838281621506390472
.516794638813720654493847456413e-1
.260310628672937439447600912265e-1
.133392980596841387301539019922e-1
.694316319617568367916100200224e-2
.366575102639070576409202379877e-2
.196072788986143477730100613342e-2
.106132356376617291307407779060e-2
.580808920282660695307860075279e-3
.321068156972438646498644823662e-3
.179143886217567185770689229601e-3
.100819320414270600306827595733e-3
.571937415676185420872802329306e-4
.326864935516241691206673599860e-4
.188095522835924827618096736676e-4
.108936787132993568461642199112e-4
.634702940439029270138327940602e-5
.371874472181495590442582920638e-5
.219026503932321551266982874709e-5
.129636986883832684182905151925e-5
.770836524425013615463802611185e-6
.460337509124562686781867528552e-6
.276032512592983636544871793533e-6
.166154277354050398770066547205e-6
.100377315744487713773421643960e-6
.608477841288904271046152631500e-7
.370047820647314439957376930118e-7
.225735258205298756132155371014e-7
.138101781986217236600544528799e-7
.847212246410513636604397028569e-8
-8.94584707632303704952122857875-226.494438107903308936532825689*%i
-1354.11403293108969835985257604+120.448288547881032876369774888*%i
4056.31240472134997389741900695+5571.19410136397039209258327994*%i
-2867.25011168314619464119787602-23012.1118458247696894935540443*%i
119.369071185978924425067021012+38758.1144470272738781889929607*%i
2124.70563251198149018268158697-27326.1411596036087125507190456*%i
-4292.38219394452126307777933259+8094.84113939907970894242735324*%i
1894.01830895551142073151817114-304.227880137823301915715992427*%i
-96.2459458819862342084934654638-311.540270988420482423075214893*%i
-52.8234417273863478162325166288+1.40225807536247237247719494337*%i
834.556837045244328345569852987+374.108830773910769263517184194*%i
3243.71549193105424551786585510-8592.48129261460463302080415745*%i
-83575.1103390237287383528724560+35910.5048021356898117390375530*%i
531437.927754220414559764426339-306476.068725939314284067567159*%i
-168950.299071929771596087794717+1468488.08814344080055266724560*%i
-642320.668731881438909688972276-497212.397742897853009898935767*%i
131293.324498358444357674919137+48137.1420436505264359733640703*%i
-8109.03521397664501858485751922-12205.7611801579064081543826912*%i
-1035.41473625086263225905444337+1000.44636402742299523886203294*%i
65.5712052355020490999169288051+142.998304276706434834968693588*%i
-3138.91571576325929578358235186+707.018206636258307365462581245*%i
3572.95886914529503120316145629+60404.3145384533798160214216999*%i
1170552.30558876419679149999811-1171828.54805429806337884178760*%i
-1433710.82291748970330953389641+46136802.5051920204825082242820*%i
-101718497.716534733503220152807+277972520.087904432223404782766*%i
-30028806.9353360466316062622108+75292982.4901170258243194681745*%i
-2343957.05271661970928766402475-2324647.38159731891914914485476*%i
22527.7958474275932506726708020+111880.353032562969314251619949*%i
5524.56744626879511165406755212-967.884123510698024542772404988*%i
156.927052982984083113191444855-369.023827220669739409643449329*%i
7200.96830858917276804229651029-3081.54677173640180533692220186*%i
90235.8852609740760920138810847-246343.355703547059105025656156*%i
-22551199.8995557929320274847146-9341754.52545133835789882653118*%i
11368629935.7635429236262783469-259183037.190333287007944605130*%i
-3329458618583.48012531819259048+1701159755211.07091286847031507*%i
-37118864436.5308652381647471331-28965493581.0300465581361734733*%i
61422729.2088163784848417144478-37551616.1633296819025011139460*%i
-401944.135486951831224253782262-430057.310523795265995864308961*%i
-14823.0052265970851114574978700+1394.71281744470646650819131249*%i
-606.215564823986807245776411096+448.912199822141274366851782980*%i
-5978.19443812249856740680506310-8489.93406333138416955410021760*%i
-212700.927453484791411028009553-374245.030992337259836623591001*%i
-22205009.6810339476874340782337-65989601.5763439784699360128092*%i
62233040872.8930495700891322517-274916310005.782285342107438221*%i
23801680428446665630338.0634207+73359794217684852442148.7418710*%i
542168321468.715459470158526011-3573368072959.53364969763920162*%i
197427903.728819944787369096905-159998101.721487738052292403440*%i
930849.808723140560308504951699-453443.070406457496978753216571*%i
19152.1306038116748576260778942-6865.36003178834791499719572323*%i
880.582068125225415372825355002-254.228490764561980209677019124*%i
3534.86050258443162014586564864+5852.42101821833040177658856071*%i
-85237.5225808002729651023150247+189526.739919017584078610757279*%i
-12500672.1983417308789775092119-8897441.05448345444523186308124*%i
937715601.841616585129471443902+3484412203.51255963606711677343*%i
-221162259568.386606249233075995-197596057967.909590249380956577*%i
4239119186.19070540896045019880+10761100048.9766149073535921506*%i
36136194.1794673219997851673347-20802780.8941916874472670781091*%i
27783.9684017652578439936139670+451342.958723614605595912086390*%i
-10895.5213184800414530925357934+6744.58405021715711639632001238*%i
-682.906683555822510055271976417-65.7417032715571759178196918171*%i
-1851.77927711033881906880090362-1760.88230466997661809658206269*%i
26170.9780908100518422484625470-33131.6155067795841630121806044*%i
116375.132526418622913513611465+908977.652624497268012946035042*%i
8725969.92559084874728089218310-15251800.6500018535233555695778*%i
-23662712.7747739029639496166334-80489970.7764725186538281415956*%i
-21677268.0536065773548530099313-18397140.3900331277391965693537*%i
-228410.581340868130155936213782+1698098.29922524192745111016151*%i
-31615.3015304877794846500219001-69988.0252841178386991908526513*%i
4054.84232369947712870237674062-1615.09147288533741385685254479*%i
263.554296544177367497713892308+213.309404695384277475172970862*%i
695.154408163134917677145347357+14.2398204585011301520855168829*%i
-576.156610468221128340011439769+6202.66566064438734068895525139*%i
-35682.4361789253765934230552933-38663.6986631275906617945098942*%i
204751.616221480929529970968866+214634.537093083014283830297397*%i
-55029.5793378611563938805946509-644270.411856470603584598254085*%i
-236218.364567423651583265634550+298810.555094925731919360221992*%i
56852.2647368382235584547969870-53409.5957805285529428214796961*%i
-1295.52553716093320816883567813+9574.86034062452033844675966921*%i
-1018.26953888184292845201081249-339.916086765234009572810657662*%i
1.08456116762977477937186351005-127.497394018952550401944027555*%i
-66.0222045803209827432525671094+157.955072108032605045268205666*%i
-857.342324838086009695075687703-389.913341954431029781515880104*%i
3414.02568340047176249414236233-2641.84722485222762407883048610*%i
-3887.19023130117627868478248293+12658.3561982338112672893097750*%i
423.776003991962517413882144906-21167.2134668221745568886194444*%i
3415.15572747275896165852652675+15049.2667596293322601837362450*%i
-3847.15863679381377711930326842-4102.44901542075641727162580524*%i
1284.36833635554212983480989490-222.315889057891438052131590370*%i
13.3695853383233054814941182241+242.065436618071762798697444624*%i
-39.8899301756522202660192815650+13.6546227649411788737436278605*%i
-40.2239257083338924310885974670-16.9454334069307538917647978545*%i
49.2591657244286818102237701275-160.917523423970557995681861690*%i
460.055312719776704848917646926+251.923926124061868479342069362*%i
-965.308093658536546498126138921+637.384299143104509276328994959*%i
136.765282976853830355472350764-1585.05809308678852001273574759*%i
918.686744823678354657111225950+897.798118576517400251873562877*%i
-612.588109321183293601338998425+165.242539267918057814917395387*%i
.200446630083710492146602934452-215.728809965255337039378351999*%i
57.7843987423449582637910300803-2.34317484725481652772236666542*%i
4.93056671083841261660588500103+12.7392649529007045649061161880*%i
.112115930042407270703917098865e-7-1867252.67802222173437738989085*%i
.183788166230978727143033241045e-7-1156291.73094503441863070677555*%i
.302228127658306151426229522014e-7-713874.432073332353206496546553*%i
.498654094573507054257992949804e-7-439324.474867492656254260442050*%i
.825652877412529302246284103907e-7-269445.322067746557737977022593*%i
.137221654488583574586063683599e-6-164658.007917367406822889358543*%i
.228968653472032121795142472931e-6-100234.983535134983933549121924*%i
.383678421593475437818005183734e-6-60767.1015304492044319765798979*%i
.645826563583588603621645480010e-6-36678.2961863186960448190455252*%i
.109232370990244383841601421297e-5-22034.7978766956772739041443560*%i
.185701408017007909229960529669e-5-13171.1611773006622563497719663*%i
.317440201309731160362496021623e-5-7830.62581816005912577160268935*%i
.545834102412494608969783589066e-5-4628.64213484068078663021487869*%i
.944489005438151449604979249394e-5-2718.97952293322026859303935478*%i
.164541156276389265246582399689e-4-1586.51811916717333061120786346*%i
.288747497563580401669775048148e-4-919.054315119137215735602832028*%i
.510712019458472053707947434934e-4-528.251333196080393226583308005*%i
.911009374445875036324986570697e-4-301.066449707499996716685467289*%i
.164007461103725896739800453394e-3-170.017955989356841158249806656*%i
.298220909176351897177347525098e-3-95.0586878909202142904596293239*%i
.548183292809773480075107862078e-3-52.5739027223191754791535157609*%i
.101965214522202538378005667085e-2-28.7350666480272555617412738413*%i
.192129993252129980674683545222e-2-15.5056557825393120992733418560*%i
.367193705492537512989177902592e-2-8.25427939467720345315497662369*%i
.712794593784453854486400081489e-2-4.33732131492602342724948179864*%i
.140766622584057417034294395536e-1-2.26366643628790646444627823739*%i
.283333885989221289408012573459e-1-1.20786254667547455105583383275*%i
.582475822045746999181980477840e-1-.732936465293954263210295561994*%i
.122602251629514004280711729548-.644428618173175531302725292016*%i
.264968657837157475289197569762-.940943149964963936401706485235*%i
.589946502848343052390492527813-1.87284581654811421742654752430*%i
1.35850459756529666415671604295-4.20623341866617933704716387924*%i
3.25068394707683304714603943833-10.0152484829986547180055097904*%i
8.12831984027319588348759110761-25.0207213583092644284804104647*%i
21.3852817740317969974439507862-65.8187947689494545694952589035*%i
59.7009626168687416859239670521-183.741273572582093173430823803*%i
178.721580844348639017619752236-550.048671132931686108710515841*%i
581.456162012393613443948475336-1789.53812081171668130643033111*%i
2091.88234333855395878826413093-6438.15186760139942833717219368*%i
8516.06859489878456951344124196-26209.7641203886262000911459463*%i
40484.1928124334008235798336676-124597.533735591274186474315458*%i
234976.168836806594073958189947-723182.286457715002408206428402*%i
1778833.47370526967957716666129-5474686.49739899911451036334631*%i
19488683.4103369352376783802968-59980000.0932144612671549795678*%i
369200091.172234346868855628308-1136281042.52438825317662372471*%i
17069393205.2952264422624264682-52534190457.5082488850786215232*%i
4364382257940.83733699466265487-13432187425204.2754328849336487*%i
121720536282136565.670585158952-374617290651674833.496204248578*%i
2676283496137962172000059.53371
1550986256945540.36989155621000
912479579776.629698900465103156
8882502333.38791503066326220607
302015638.943648947293631459948
20877434.3593549316719597711436
2278266.68858552209832063990607
341589.352010021178403832314885
64668.7058874694134701471911536
14628.5055695658393785066378746
3806.24649982801982370749769070
1108.45490042767134858843243628
354.045470550811841043638405589
122.127266675407481793375391856
44.9526867054612960874902287459
17.4881919670567166169193159389
7.13578562518504823017926385564
3.03472455216734934334073340708
1.33820747813618699677985443197
.609217024309075834941919368634
.285284776883524255158754338553
.136991975312946846981423039852
.672771734295248752703807738288e-1
.337133700173583113816855937124e-1
.172042819198661791549043957643e-1
.892523545769878427290059026800e-2
.469995308399775964521881395101e-2
.250887475819654822393929309199e-2
.135601431145877349487705354098e-2
.741302222220001628088734859810e-3
.409512990870693490436486021418e-3
.228412603183077768911286343211e-3
.128537102292213714810087943073e-3
.729292485344049741273180319306e-4
.416943421223108534730687209130e-4
.240058568593204430641438001987e-4
.139125510660592705116077270371e-4
.811241682459893713885008618631e-5
.475739925962242025101824430011e-5
.280480258978126058459702831443e-5
.166188035077647224136457931252e-5
.989294978879673523806692413426e-6
.591500982326659304224547373775e-6
.355118921368591889842215890239e-6
.214030150500922753267583173687e-6
.129467634208779626568766776300e-6
.785854781354981586602458694167e-7
.478558092149095544987876665718e-7
.292321567876221694192010158514e-7
.179080790048674659963513495351e-7
.110010029482589706701271328272e-7
.677561189515650889968331677167e-8
-107.300649114301970547566984964-66.6269379870121942342795163427*%i
-388.865763338295745276680620039+611.151044416378489325435126289*%i
3501.74264971071649639061960572+360.412234443283841821011985094*%i
-8758.92329084501553387328335345-7400.87994771513603287058961654*%i
11321.2384934384381404484570809+15132.9630678727895862839896705*%i
-5920.05572110150146061598233585-12123.4407464901138614314042656*%i
-243.418437693620196405460182643+4638.68673980449579705106855589*%i
882.040050161251434418848393880-498.504200771685254307273317469*%i
-100.413102014241901716085472866-149.483261940981771637981144068*%i
-29.3890364370485785457318192342+8.10232844042475940625192791649*%i
397.923492528819635144270362562-275.544235417539564085169891083*%i
-2610.72005069485766268490131538-3751.00982078159913371045032928*%i
-11600.0405251793169093194004873+40849.3462014091914496684321391*%i
72162.5175791704267626008326656-261363.944185310948817267270712*%i
320835.334122412438311276809792+550078.745166533916275286031976*%i
-351834.208561427821486230704452-54926.6080449740791638621892421*%i
64445.9776128985563572408556516-2351.17759171135938872033604775*%i
-5585.52032371915337551794719199-4541.60221271005358740380091478*%i
-401.769273083235754708883007891+636.813479268940177999865856048*%i
50.9220516433413483999217650619+70.6378750711627743624917915906*%i
-411.491499211353490851813724467+1575.20326389356511930394381007*%i
25198.6766630289688136582830781+12692.3019367905944482171463465*%i
-128024.976550725264391660944944-689818.438762856199070637982244*%i
12826456.1090396754373402103914+12202414.3409547332813201979864*%i
31593865.7081060883400430815181+102553600.180606822598167785219*%i
2116068.56379252521108335318878+30491659.0580759646910323423135*%i
-1220033.47932298275827257780880-623524.408506220054577268939885*%i
21440.5816578094101609412112715+47657.5523630632345010726595254*%i
2630.96329185394533915357521002-944.079678234784388131636435410*%i
56.4551005609621975457007254723-206.903394204540079516001313289*%i
-33.6212264902184681156329561614-3841.97898998446736332033458570*%i
-83236.6205281556708012194350468-81421.1463270403203427391336054*%i
-7214510.79649262642912119640536+6134901.42304424805566285056286*%i
1955805433.49184816841460728704-3090715419.79249560208504413573*%i
-415067824212.988616939873367544+915358984822.647910121223262976*%i
-13617103691.2722332555557144261-4965774741.39026794461261783531*%i
20266713.4628406908707736462457-17889800.9659962865610310975360*%i
-194744.270614110218451695274937-164868.401130902452232466937439*%i
-7057.77999867353408812080717422+1282.44394823619620684863241005*%i
-300.525595189481466453421405446+255.359998347954069332515197979*%i
2987.69035484652193636606465170-4064.05762970619519223606156104*%i
124953.702877949590917554068318-140371.755695089528803349956364*%i
20670589.2061274988690832119238-15959236.6020935056055641111963*%i
81249936753.5856991123804691126-10427599769.4035977885242180677*%i
-5798439595501178649457.97418104+7973510831104447001035.61232569*%i
187754043874.118865407644823743-952078336370.052109855576115990*%i
72374477.7608928609203181487929-56205110.9136105934877179013820*%i
398577.956797396310752154516200-187603.414770848791533781701528*%i
9160.80153151512261966474810217-3183.64178263814543985687645916*%i
458.164194973083545057200841472-128.546373360325734771682817364*%i
-1942.88437276455402752851707236+2753.11328520189578923813968239*%i
-92928.2338207112088333666336761+2146.96425791449469931173864347*%i
692084.115703575839859908878045-6003456.41518320793694839199960*%i
-758148408.300210763658924161458+934878727.347498924429054358275*%i
-15191854220.6686674504204763321-84996232600.8955617548014810461*%i
84531072.6319929821911662564927+3721324723.75857612350025085523*%i
15148575.4304152918209212422229-4944285.45290689732939947313209*%i
-15604.9419299771482017572402314+197118.739874045132146764738662*%i
-5587.52187488230760371463598816+2700.39582022027469082468520671*%i
-354.252327392050933967390070290-63.4681703618480489384919325842*%i
345.916466864671894229129000722-1256.80648746514039628509910757*%i
19772.7652615447215304242930072+2496.31440461776559986762967749*%i
-289880.331354270352701968634427+269567.814858881167747791782950*%i
6776333.10924986166827338039134-1560179.05309717876015123631739*%i
11209551.8153083085353820652224-29623825.0152706048841706271438*%i
-4355162.90769399513206906514261-10198976.8596685218307482380410*%i
-323821.380718211951116097712517+650492.557331600677789755900624*%i
-6464.91223085875859734672648015-35048.9466112964468558801863161*%i
2153.72817703113114180674783558-420.562673497484758192763136461*%i
123.292412298955809832411690871+134.484162205356933348511042492*%i
189.391128726243752913007845345+319.776895147046756217157383994*%i
-2724.66955390690168656724790064+1565.44305542183857301993149092*%i
3272.57459190767228196651672483-24811.3357974787510097964853358*%i
-1104.96403105972542872754802073+134343.183112522229563178687557*%i
151260.402359877021478741899235-243150.201410486393535288167499*%i
-158356.450052837429969037611681+65269.6456745358424542876487157*%i
34409.4704627384465456355667817-12751.4392786059211911483872761*%i
-2088.75661619644269906416934085+4339.79204896115106748178971088*%i
-476.580948640691402066416191574-307.902785810413118133466114362*%i
15.0808635887003667248292009029-69.5157725862472758382899188811*%i
-94.3385400385224797326016346952+19.8959342636611216704893584682*%i
-119.492585937695424544489939521-494.462163051953119944934073239*%i
2209.15269380929306127141576763+385.835906199328292544735543913*%i
-5755.31299318681604353962331424+3389.50557315030807088504553282*%i
6455.68791742920906641323731075-8339.14350452148240947886684186*%i
-2384.25078589914387362984189679+7376.54711094772061760752959302*%i
-888.347894892663133490345419665-2762.32604300143639432682619686*%i
685.415515604565054397205665226+133.379550169832199195748991915*%i
-32.8873976387907435604277007277+131.339373881658016133752326955*%i
-24.4616570436975010675859997625+1.93861548361392854204168063648*%i
-6.18573620490635849937136522144-25.1874413764604605410924903914*%i
89.3710741513528545415805297249-37.9165153857670284883423081461*%i
77.7832835953815689794466770592+284.451863739559414743950101657*%i
-632.311292497926810414654721908-88.8766150746712488941874636325*%i
576.810525348194797341820010368-653.498207315243793916568956609*%i
172.668019427831286071179304009+685.922552057983725702285520653*%i
-347.688706786192825049077056774-72.4688110536960130148310167742*%i
47.9788328558791834609800569562-114.081901118723423059682664191*%i
32.6698789642455870087300627453+9.95634872755974688272107423057*%i
.692378845218029506642931439491+8.28772758081815953517533166309*%i
.288021514053779580733073501765e-7-2373809.68754438640978720182258*%i
.470085922223562860008512764312e-7-1476830.11358625806296252602772*%i
.769531049108569930119925485454e-7-916179.783042154466231444749833*%i
.126371112597598849471381377364e-6-566656.097892747862387588007452*%i
.208220982319152342376564832952e-6-349352.633478503370616007753309*%i
.344306450360325766074529473932e-6-214646.614281044101614815403115*%i
.571486769034651615257091296194e-6-131401.996643726812427131446443*%i
.952384035349308303238859542580e-6-80129.3593959526922881235750240*%i
.159395685954992713085745550736e-5-48660.6247787356804369201191255*%i
.267992875549465523538844369696e-5-29419.4204912545949007020744070*%i
.452779838299428436098861858561e-5-17702.0480284993252657712031932*%i
.768980787811327753564511593108e-5-10597.3070847938415829044606138*%i
.131331804381707511173778753008e-4-6309.36029981242378258395533852*%i
.225645918860786950115731064901e-4-3734.32373752680790578610976418*%i
.390196174204794108369814164893e-4-2196.22215603143397689883139869*%i
.679440153003187578367140180704e-4-1282.79892145897257955535886520*%i
.119198107606834660570383518877e-3-743.731374451092729106555253815*%i
.210814426915507057945900489905e-3-427.739874070108282832901987886*%i
.376128407305650247981324734472e-3-243.865590185688877888401958327*%i
.677488837230510108205512416932e-3-137.719481109533405743497036668*%i
.123299691431943675196651025876e-2-76.9736519724033625419669482077*%i
.226946468216751893682753639688e-2-42.5376447934490719345119262004*%i
.422907426081714255389363446660e-2-23.2177504600608070180877360214*%i
.798814518064702946381642126276e-2-12.5012207421629910031738341467*%i
.153148665210871466590827349359e-1-6.63086054239779179665931021378*%i
.298481094268362223938639912431e-1-3.45930760114583294370172780527*%i
.592411386076299478496426687197e-1-1.77185775929006995824119358137*%i
.119981703489801394379903667471-.889182268142836102559213931688*%i
.248549268464602090866920653906-.436151101777548425002855693931*%i
.528085767710520456902550518369-.208526020782230879678911906043*%i
1.15447545588194275180136228128-.968606089342270511815632577515e-1*%i
2.60675386301815681679641548777-.435441797866102369938463892913e-1*%i
6.10679001852072521062368106340-.188592525139590086103606559612e-1*%i
14.9239950388762709004834839794-.782610678288788598341168063062e-2*%i
38.2991507479322328707136188204-.309098793993950582698002826100e-2*%i
104.055215260709199875502850298-.115243319070913222889992501730e-2*%i
302.365017720414313654727962839-.401470507279281972571826872855e-3*%i
951.946335434592204228540466299-.128992755398714904037483516856e-3*%i
3302.11642343844409997273583854-.375871696346878207311247471167e-4*%i
12904.5542378369644030285440958-.971359069109501289656206015475e-5*%i
58570.6008066567700492159247041-.215946508188800102073907982677e-5*%i
322343.881559395033401689801330-.395547398628715559267885064632e-6*%i
2293043.17462846133146520581367-.559970536131791785954832454011e-7*%i
23316233.0280711719845263349249-.554020780437093256479089628236e-8*%i
402583572.799875706502126668906-.322452393628276073956754681389e-9*%i
16474750116.3030403359756758535-.790961839839447071378571231075e-11*%i
3526587225571.77939440263380601-.370489869954070091077135740873e-13*%i
70741672992130654.1751074516408-.184972798177103816924683319779e-17*%i
289398055113728958040306.055628
332949783210192.083184813782430
248784324759.847987238686835903
2808240436.54564522732164231070
106289654.923126968114767852573
7990057.85213724843386476959910
933868.865797609162232264935732
148368.594591351923133417211392
29527.3799539133696014176380830
6978.14660200348901186704292072
1887.56691089340818100805275228
569.160023979642510879448596180
187.595744273696929015615920406
66.5862166497631726052731574168
25.1577025036870706966695527826
10.0249106313303984029060515021
4.18204846168594252412692263015
1.81536716395622542878563980131
.815891228235306420058361675064
.378074477263221730665008799880
.179999289003877274601140176373
.877837293355805588471780933609e-1
.437417511954110637170855616046e-1
.222208420268748568717414599083e-1
.114862488985157883624181464628e-1
.603152714348915719791010974915e-2
.321274008374781281363427291619e-2
.173367296349961932249484561843e-2
.946696924059753225941184873656e-3
.522602499563448988857961066635e-3
.291380931424316789054756596020e-3
.163958421789259916385034287914e-3
.930420182562500566087598574875e-4
.532130999762499685494792797012e-4
.306549645433473588053319516061e-4
.177786537574157126304815824076e-4
.103754524130830129723282507476e-4
.609029799622090162288362786751e-5
.359437474423248111112040556013e-5
.213209418142000295131522260304e-5
.127070830832653338129305530120e-5
.760697459382521443812726110315e-6
.457283498148554372866530746281e-6
.275966925557760426920661653727e-6
.167157407688811274612311098038e-6
.101601069379950514458018439735e-6
.619568100129353964660635123980e-7
.378981858237035539545502083634e-7
.232494516811896627808450376329e-7
.143022235857129245727280875038e-7
.882119535837849830681836642544e-8
.545412696754401166710453921861e-8
-65.0562945179502303856200850025+29.1755598799009646383245968101*%i
134.188996300001371608959362424+367.499901689035046269317159978*%i
1349.79524036024025203998806596-1225.95929622903251182743969822*%i
-5745.85444185920320506354427002+254.655214520856349150243730473*%i
8960.45151229586047967091492934+2666.42573478137034514295577359*%i
-5615.85729019532341643971210941-3720.84774488651219089938799252*%i
889.741030992876258941985714690+2216.19576509141763456545199726*%i
350.501417894716648250606962779-413.999232799867611665761592910*%i
-77.7796012411758237868729814245-64.0625402015966930226428615148*%i
-15.5461612550816314896155800079+8.69068668187056954803243823550*%i
-16.3442920910602925497906041609-258.946687693330735321538398330*%i
-2304.38082754993538315931322384+16.5664107610262233292272045119*%i
11549.4499545063117032016076533+16444.6305360227253553005675717*%i
-59242.8080680104437256704320832-106087.403582998774483683658452*%i
256205.902049525820626119658743+108377.815283096658478277184889*%i
-148762.360338386500594951201932+54082.7909814643339407080717537*%i
27482.6564808863324082312323560-12395.8648407360844040895436968*%i
-3325.88237297193976027661343273-1335.58983467421007654340931678*%i
-127.066338889427700296809995521+378.121636735054079474667199210*%i
35.6195468797182719072188082028+33.3660704710458716738261059783*%i
620.677632011262946539796948446+557.560861767927836326096925018*%i
11155.9302839491904014661143253-7294.83245457514818929268118981*%i
-275197.377470433510917922082109-122403.740969962805204072310831*%i
6860012.16783078498328462163090-557942.409175593374600614825470*%i
32045070.6148470558137530546782+22988152.7077219651109093913571*%i
5783351.89959565352696330184843+10150765.2097760421844633449911*%i
-568600.691398341894493728093630-94129.6523541380784185192769261*%i
14601.1554226664531028855472139+19356.4331004715385321718625356*%i
1228.03382947480811109123250594-694.874120253624485508516998442*%i
15.2204873680725074214921388876-115.130456568334182755684101657*%i
-1767.84293946085345768582984606-719.511942972337867001870255610*%i
-48744.9263395189074546521721863+19099.6523781707132756608883341*%i
854343.847571495579771780529146+3623872.30668722405775257872451*%i
-485881906.786252280969292049897-1088811141.36467930057719413983*%i
66956304232.4498675045707968263+265533850438.396869981472050796*%i
-4519305786.51274549335931888852-166466176.107190569441817290232*%i
6414753.91370272351413961191281-8041545.55971746873035208779934*%i
-93353.9416271150523821489151017-61979.9278887217937633437658267*%i
-3377.86845961662308987780633339+917.998534342140702583172824143*%i
-149.722462293858342957962214116+145.439794682055615669942659563*%i
2362.69391558907304024790031811+758.409238901912640977727056118*%i
76529.1145386114496413773359275+32424.5741109312534250778632178*%i
8299527.42891523384878108149181+5442919.61153015543679219321660*%i
11096052682.5414204533020040559+21423702914.2237613873965225018*%i
-1277337454848004199999.91666667-580607973120000599.999988095238*%i
62468141833.3824791699497365629-256571194259.819484291031920293*%i
26866455.2205672573611706819123-19985039.0144344456097146602665*%i
172860.815274444409759193173920-78560.9931366642462296445576853*%i
4437.22349568326896970745982376-1494.03717513794943990737847643*%i
241.318755531729212162287457644-65.7614431194087255831801837199*%i
-1647.64292489260466137564623982-337.507486125117633076165573403*%i
-19019.9560858441589522427252373-37582.3910354095793683472866490*%i
2231927.18517164997242657564335-914277.154931597597699251801979*%i
-406322265.970007773905703387431-22369783.7169081300786905244037*%i
11943767195.3226376856568451348-22506419770.5606928734367708685*%i
-393139065.452004982463199611978+1148771444.84400803134337345365*%i
6134931.57466769725772487537820-670411.839280820586011263078129*%i
-19046.1152162155787067257636679+85505.9113014696547461707279336*%i
-2863.08243429903745748815339234+1033.69859984013196870607835468*%i
-184.802499133469948886216214449-48.7950403450143693891079436521*%i
656.922224670044079558339357265-148.480050209179337020288332493*%i
3858.18787670225048723156672812+8715.89004003280861264721790455*%i
-169833.582641138793330422391870-34496.8263316789481052070156472*%i
2304148.24651906866425275467917+1572272.71579643835582811173443*%i
10262302.3543140208669197430871-6453321.14214385854327659042107*%i
261600.185703342880871699205363-4377261.84743061481915743524401*%i
-221791.820619840379982138159097+219915.648313021448382289246401*%i
985.884667340276011729173915023-16730.3454874791977657561839519*%i
1117.47880084996419858304158225-8.27285108404409454676171308813*%i
55.6735035191076564651182998039+82.3452705145074645252190713975*%i
-93.3016555664245336990955648882+178.295217070197112701301395065*%i
-1455.95867633997544206467404239-678.705572178645932479694447057*%i
10208.8880438701804250320255098-6435.28257904182344899598200748*%i
-43334.6101968605560898301348024+43918.9774182710551262778061361*%i
119782.141101174545834532638091-46810.5851697701324312459918302*%i
-77541.9223353322449474048686747-9319.30353209907079952343491382*%i
17484.9119158445502340169257723+764.933380566989899026941758704*%i
-1679.24032685621109310212803696+1760.78107202383179129829144656*%i
-206.406766403200637931531806016-222.919736885029590369647384294*%i
16.2911221219580752216071199105-36.7332704588736676722964465966*%i
-39.8388960118474631757855012863-37.9334213654887682769050650812*%i
173.209122461544131044265962924-218.093535829831599510406567598*%i
632.899577872560970573235735452+997.671669631987519719799245066*%i
-3343.37196435185305649143231103-709.035272986271796156226342814*%i
5132.04575070171947231602285624-1438.07788430294928372271865066*%i
-2962.66813152963394758357829484+2613.72917831716707153215249437*%i
196.819464827624820386142656710-1505.50303060745908648210295647*%i
322.420398919377530278270404860+199.630013365570273904805743699*%i
-39.6680974399820609162869822006+65.5484972264337874404454823931*%i
-14.2546354568341230413749104126-2.44381583667737803428181125225*%i
9.97626184868345514663153016337-12.0214547853068759868635386523*%i
50.5465446802428903629964690144+25.8839166718730947733335120989*%i
-86.1286109448629168471405905380+144.501735815489582326009488393*%i
-232.411924831202068823855732401-272.016488400354876613523421385*%i
474.153670474533930993104132622-101.305206915548143599904815115*%i
-117.955900435843434335638854780+377.377181088125135756169576696*%i
-157.745584359971018353195620687-125.751745548517680431649862794*%i
51.3178575979660615509224201416-50.5084422787204172687806256053*%i
16.5189268899030514175780924228+12.0413771595935319916643079065*%i
-1.01949773554962597324895116129+5.02590659905579713938899181584*%i
.711444730762461895063783462890e-8-2996645.21132701219378203433212*%i
.115622480244317110376562310749e-7-1872811.41271065218864763240221*%i
.188438955554130921333660051295e-7-1167327.35715911743033198254549*%i
.308034042561221435777940992044e-7-725535.094397781604573548612326*%i
.505131546669837802513493368421e-7-449585.801619272030940203479470*%i
.831136860488722441596200335428e-7-277696.116893574112394368180342*%i
.137244344325089663261612229883e-6-170937.537005740742174282519755*%i
.227493835360721074998784352811e-6-104837.046580965404295346297133*%i
.378622252851801434015538250618e-6-64046.0198814347233325905919532*%i
.632880413749278684404470289278e-6-38962.7793913823616522807006141*%i
.106278301544979622448164359193e-5-23597.0347954456019171967969565*%i
.179355775534335154939654766092e-5-14222.3576296132756341392196720*%i
.304290025018637923656262991999e-5-8527.77082765379267780311453783*%i
.519194956235745064509018937605e-5-5084.83423051226899521089582820*%i
.891311150488351209724928820230e-5-3013.73853061603704592166263679*%i
.154024269975660587954919772380e-4-1774.64830033533115336950977294*%i
.268062680262108248947640973592e-4-1037.68414597566427907763458470*%i
.470134272357630584586472741624e-4-602.153415379712770036064217486*%i
.831428280848110976276784982457e-4-346.539172864381771561016288599*%i
.148373374852956751918778870831e-3-197.643157132013554628041427148*%i
.267401108919598157108499094361e-3-111.619009742260135590203438099*%i
.487120754703361425326725886047e-3-62.3617509176722251192084781305*%i
.897874335036424287227341896824e-3-34.4318391724078616306588001532*%i
.167647268378888643526166001768e-2-18.7634550261933404172926472460*%i
.317499376286943650714504325342e-2-10.0749492427075069034627515356*%i
.610797207029228475913061770222e-2-5.31496453750039976080896707258*%i
.119562406300509296885736405266e-1-2.73518623334215837420571439755*%i
.238606733203183063385394888488e-1-1.33933319533463870638071534709*%i
.486566203935630426196736771200e-1-.554742398665175362903391001891*%i
.101651811524559121899467480007-.299500280392205418594362757112e-1*%i
.218244310260664963826517082210+.509426824317339389107062741473*%i
.483292857676385012557970745213+1.41298811013532446227317368656*%i
1.10868308112353411478174332479+3.37922871958133629516067441379*%i
2.64855754827101062272420463661+8.13742490837517424940960598483*%i
6.63110237427069675944169116469+20.4027638327437106960322081378*%i
17.5367579482258581464943562175+53.9704175645101533682521737741*%i
49.4728690679915894832690082634+152.261054129578449742551018462*%i
150.752318100795374612387737925+463.967668316236349232353025863*%i
504.283706806602174309519703935+1552.02558410302179024858173676*%i
1892.08821067301665657831218194+5823.24871575531205161914073623*%i
8200.31472895732269291747330202+25237.9736360485885017160210087*%i
42798.4664809507237988560462551+131720.135703818313049330082918*%i
286122.883481251932593942286288+880595.688099219060983095346134*%i
2700480.76382803266306878368007+8311225.18929197439130047097399*%i
42500406.6039984722341274799247+130802801.728380516260252078190*%i
1539538103.97994294270815421406+4738211077.47307386405427021965*%i
275916140580.660992102284705306+849182563506.033198432111975275*%i
3980967428207342.43788493097842+12252157915824645.3309147329041*%i
31732088995625033409150.5353852
72474090790847.4264243692887862
68776668038.0389515175932027479
900177284.607033915400894421259
37924142.8332412548621276739105
3099892.54412618880858493965966
388011.567928608189417519178501
65313.6565808603117653682208683
13662.2097859350715785444328714
3372.72648398389484191059761331
948.286682720771383456044218205
296.012148469616840586074276756
100.662859543475484683847266572
36.7586176312864483955760506465
14.2530567804669605087644272515
5.81640626254050263936020485457
2.48022267387405451999046802994
1.09869964289362451382788302512
.503181870967929275120951317521
.237290953147970087790598268895
.114835545508260172247117861418
.568671803671939336937269213124e-1
.287454789970786702078573599629e-1
.148006559173382136613130213883e-1
.774819029058943299845926351753e-2
.411751140473919479484137980658e-2
.221808653378084512783758225750e-2
.120975814367744863786486060897e-2
.667305529149474805186949229832e-3
.371911990616049338453725446677e-3
.209254183310887657734486585597e-3
.118766966524311518121532840609e-3
.679529542871045248363358858012e-4
.391693137737563980985370340226e-4
.227336260449931062547117631674e-4
.132788351976430828600205023175e-4
.780231755716609572741812613965e-5
.460979471062158942737422210350e-5
.273761187231159584238142016686e-5
.163360398950610813022642195048e-5
.979199881610157700461113301139e-6
.589416128263079569159865292991e-6
.356193046150472085962394144547e-6
.216051590089322281926190811831e-6
.131504990593759623664495002464e-6
.803066186058681070766148650852e-7
.491929812518563915803057700275e-7
.302219255044620418788009624963e-7
.186182283947672178619317255916e-7
.114997109341112938476662167412e-7
.712045204606926262555014921647e-8
.441920568976776215769604715510e-8
-6.90814931952200556949854830413+40.2010704641154132831323422050*%i
204.553546324502251116635821078+63.8159473275281188483700146134*%i
-7.30409212593403768053472250737-958.242597837231493597144490019*%i
-2059.08610177431211167781325261+2081.37111066283038407725297752*%i
4409.38645489868689010228626979-1610.03120082223496821586412227*%i
-3409.02651128454235554951481010-185.289972094572252224211751156*%i
906.516887676269328418194063615+854.500337322817943725743408371*%i
101.034917235572231124758246601-276.670825212081728227422786001*%i
-52.6321022385190446364496945385-22.2785735695269903344779987369*%i
-7.72280284187593982452837778991+7.17414100757911216293862928108*%i
-125.123389307082177974609391575-64.8763291808088103069389985530*%i
-657.968787471139157179971597751+977.149108894226480716697247471*%i
9621.57429812873086367883874505+662.736094318971502670315770794*%i
-53050.6327577857459920189549986-15392.3086504821270547283022477*%i
119686.237925683847247900066251-29600.5031693006285918625077401*%i
-47007.1429994544482881240317597+53715.8008060927773202283587661*%i
9853.97503711092208578561720203-10356.7338582176164454353573452*%i
-1803.02501601205961416101656372-148.254221507977595549707987043*%i
-18.5554565049412467884818235895+213.359788470027392590576497026*%i
23.4665142369394442040504741834+14.7332446579886267477238978353*%i
404.931890191324024151860171594-153.959120255530565761518378498*%i
-348.736361386880612128785920649-6373.16723664246081273410941916*%i
-111715.077082690442587144205762+68607.9591390324870503892387114*%i
1637409.03732864851538708836872-2163960.98575848629773388719394*%i
14694656.1865162199638265373733-402707.144372728214178772506196*%i
3726033.92011623461404062003551+2574056.88641102140980196700532*%i
-243282.401266929637460412767300+35255.9788356252054499129380742*%i
8709.46309227338412673049859095+7360.30789582687524083370331416*%i
559.104769986922843143269562017-456.371930206873732359895036336*%i
-.168576325851371906756507195459-63.6907873464348379665038784642*%i
-676.553872232406226561005462092+681.923622087523423589225455077*%i
-1174.28998673534180301474238908+23827.9088238139274143813957394*%i
1440912.48145470164118376713599+354801.828794929974535623874541*%i
-388620959.670592573569602487629-65520653.5772664661729853435900*%i
60184897155.4188668487179895609+45852767509.7315031513096337146*%i
-1376653787.24960868535114548603+389836497.577034538662302177340*%i
1900004.04489559957075126783450-3484043.76741186557665558860273*%i
-44469.4140195451724894001006132-22587.5169641895506817693395210*%i
-1625.32768517943413713102153880+594.445082749085840992480340148*%i
-74.9274886776123365274040344573+83.0987478119695351776303150531*%i
15.6832301288765592918642798125+1236.61504641778496654556314140*%i
-2761.63361794468123235859543131+37150.8234183162866993836050278*%i
-937192.894017394337299577441179+3707350.33136729339288930712735*%i
-4872425436.62296450710342838086+5307678636.70386359879421245523*%i
-98572857076334759116.2623033760-135808566882754359186.222827924*%i
20340677830.5537690353284453416-69962866088.6553003135353356815*%i
10103840.0837630608212401537001-7195665.41020485697163187257022*%i
75964.9450753662425059537469822-33310.7427904822774275966328020*%i
2177.30665237615880150145853571-709.790735625936061913435077041*%i
128.716170472306813678022947758-34.0490436404107580536361086969*%i
-177.296442191445610232336794481-831.780255551542413061862399411*%i
11818.5195189096143201503425089-15314.7756058974278077221871983*%i
759637.384787699963702592575360+612678.606785493685338922839646*%i
-75427859.6770463301438829087280-117356197.801069289787842746594*%i
6967726586.84454687684395422629-3095997702.64830523009090387572*%i
-253172156.979010305112961199613+311762475.941846330924101379240*%i
2411721.98368371385779278189424+236013.904303505250455281935393*%i
-13819.9281118802446420256993817+36828.6198922742351644326293607*%i
-1468.27157409729663042129946929+364.285197661359107767365036807*%i
-96.9723906416589186702357192040-34.1428079831149754497968882583*%i
230.429615231149388520631016937+266.844929441762067432179013959*%i
-2656.41770263784782932198573733+3780.88689132613929320747740923*%i
-31395.4370472261746416025571829-70232.9019664183369644439683059*%i
165805.924247150854244557985530+1122711.20474343191362543630747*%i
4688536.09024139400507449939402+405958.518050141470101429781986*%i
877950.697801317682634453815562-1523728.19112680528528428206336*%i
-122353.988857841704035464144682+59690.7091615937339104473650412*%i
2356.58968723517426145759555005-7633.43658080975176063665642614*%i
567.636629990832923397054932447+101.651625907528330821891546447*%i
23.7558436890126103168628503135+49.4380857225604718927507586744*%i
-110.139007332112844800279783908+7.78093946177869023874953161890*%i
-145.575094786509767952896779503-819.727216754099655526806192251*%i
5610.67035133754693425794421221+1831.97058234039349294172345876*%i
-28740.2964596005486928244889919+608.057207722539084374540051164*%i
56490.0830819386007518827240214+15587.9881400183707246412123437*%i
-29198.8107770194125508752047530-21279.8830631765399099440374670*%i
7654.53266248463591338831810127+3618.21924736396323085881495420*%i
-1095.51147656800311417561359884+594.298555034080475397033986394*%i
-78.7507136481748898521959681163-144.833048204396207469120103434*%i
13.3563257547570839895101334627-18.7170334175993739896536410488*%i
5.09375373180604495860231568461-31.3998535836306788992722529708*%i
154.628649859645343004672608955+1.59717114736620453327438970166*%i
-167.540482908156710780208753148+608.948447451232616706000833668*%i
-1031.26538635548900298425786561-1444.81646692510123661910518978*%i
2553.63591718083322095821841608+977.762860114203218283073583607*%i
-2007.72779813756223105255916646+382.398931732636293924519435545*%i
435.048293037951726662813551575-678.721916825211418871917329085*%i
127.369937631973036624586268559+165.555060769434101761884904073*%i
-32.7619500304389402277546624602+29.2940325509668454274973174675*%i
-7.89658043632648364627080623737-3.49468281805629327316237538834*%i
9.52829949529069059434814034169+.547210514271626369613430090578*%i
7.37857584477580069724133823137+32.8807965153829890283544156120*%i
-94.9208865618638532220775862856+21.9357702949304400097601015506*%i
3.68319618006172991614885652936-203.598163847743144674958273814*%i
249.437492165113063368886315251+113.422681682548790691576324361*%i
-168.914588182641367025066246369+147.895075855216409754217164688*%i
-48.6993029706509538770616603125-105.662216592106844145718433798*%i
39.4044925151529165859525487075-15.9396236649361250641805716107*%i
7.09995591703358856911319823219+10.1726012870883605851583711813*%i
-1.48213068460856044392550045177+2.84044359194881167350922440123*%i
-.149923405451264093736530774235e-7-3756137.95051863485997866847593*%i
-.242642709952777000080512283414e-7-2357907.12158955749123093614763*%i
-.393753444203102835659732673185e-7-1476471.18481967023952751340571*%i
-.640780537796115164203862398738e-7-922078.036757929994611878442819*%i
-.104591436764703014144811932383e-6-574222.759623559438883104181357*%i
-.171263549501942043776172230108e-6-356518.823535323961733632731829*%i
-.281386072058005621721414461517e-6-220641.008221009900792706217779*%i
-.463984410623935511504873008767e-6-136080.651706252291484086156125*%i
-.768015282538987245460891338071e-6-83619.7838024258529038947955091*%i
-.127647918892223549069381750138e-5-51181.2458090614360957856754945*%i
-.213087005593629280041582345695e-5-31194.4891877798632988361493966*%i
-.357382196732070693877552524500e-5-18926.6765930467611418005475414*%i
-.602403849271034608811450524896e-5-11427.5023039052443088269359724*%i
-.102089706400754058008454596169e-4-6863.48860731027038633429720931*%i
-.174017227438815359434751956291e-4-4098.96890328212736982783564722*%i
-.298478837194410492502577498381e-4-2432.99405598292621766855827163*%i
-.515420235765209605265390824235e-4-1434.57567798810628276121881026*%i
-.896551248468753435502131302949e-4-839.802018349575479710348529372*%i
-.157188372420517299501834551434e-3-487.785436933996551102389513137*%i
-.277967450015958643113229466153e-3-280.915066201938049774100864352*%i
-.496166610412773303112872121461e-3-160.278373989550943063188677494*%i
-.894733534482391162897294277545e-3-90.5201994637381750416886660435*%i
-.163159426518146679900235298485e-2-50.5537112159445154910282004355*%i
-.301201780474764701240126802016e-2-27.8868355559146999313962169496*%i
-.563597153583095448531617732587e-2-15.1736362643627097718243929684*%i
-.107043600687293833715820493290e-1-8.12904195260283529375130010708*%i
-.206698760798359992174810355863e-1-4.27497283810336155535659236768*%i
-.406548177236066462508355725020e-1-2.19061471785294751210326108386*%i
-.816250885718836600808362719013e-1-1.06601195160802709653241192905*%i
-.167714022899914474130225913249-.435353071709978958573283105293*%i
-.353701155327674013688510535977-.117370331529614863023629855217e-1*%i
-.768330101251123646045513564016+.432458100489941283094970800208*%i
-1.72631662288394849168120707831+1.19735902066387824093821976736*%i
-4.03220914350112404180740010739+2.90483475344288216021500440316*%i
-9.85101776714448101090837493592+7.14690466621423082643092898239*%i
-25.3642016060313044298078258631+18.4241211207092022097719782471*%i
-69.4823213225105291482508144538+50.4803625169563541321419636082*%i
-204.960117755459471246120602315+148.911727349639089782667931410*%i
-661.286575500831987664339370724+480.452658816490612945355523942*%i
-2382.57091356936397745821968517+1731.03904937214589549538393620*%i
-9861.79656483720779264826310237+7165.01459582882019889201144894*%i
-48817.3511261840162097506589202+35467.8816954877325974098990746*%i
-306750.960345305097759282866796+222867.618196988354237379987194*%i
-2687602.26801153393628120044941+1952657.34607399974722663333420*%i
-38557723.5476704606841745077119+28013825.9404563256580107453743*%i
-1236444462.88236777432704213574+898329485.800786086975605472589*%i
-185538578992.580244129308873949+134801668223.791594963750886196*%i
-1925524630277635.58608896211970+1398975532618501.21841166539091*%i
3529869999724152417869.85102414
16004302624090.4901029877897250
19288233096.4746265282742369207
292704115.556685342561666074842
13725000.2085357582685740287933
1219751.73052921912305120309419
163485.755656819817172187399867
29153.0270534652518949425132764
6408.69099521368163325421693176
1652.35552840889220224475107089
482.816768422499138682283657814
155.994737250139178456512393963
54.7214019410014464230211757640
20.5536661233083078060105466455
8.17733576533531164400052743256
3.41669061967260708946659372833
1.48894231740875700058959552487
.672957144340026089612930344970
.313992888873890881014392561469
.150659152129923548753229400952
.740971249160573209541644722043e-1
.372510569381477400353891105840e-1
.190977839699655667788606264159e-1
.996445372262966279436002640056e-2
.528187166214572950580084895666e-2
.284002912223652961006411895806e-2
.154695757485752132566293160497e-2
.852599787284261148059734994627e-3
.474978318413853165217192298890e-3
.267218175680729922457090280997e-3
.151693830410348629741011013173e-3
.868288018513085408222428903109e-4
.500807780127346076541099598167e-4
.290894821815422469218886675352e-4
.170070958604803452025405444684e-4
.100033937043953349909801977573e-4
.591699159669852824492666670177e-5
.351820861227551555870828000324e-5
.210210914801182966917371305809e-5
.126171601298464010458499941271e-5
.760523168279713051892021304098e-6
.460246445668121105709436333034e-6
.279568364650329408680851808720e-6
.170414436224643768168228701604e-6
.104220843091037581424435169791e-6
.639364930978792983077382338856e-7
.393379469771214139878613618412e-7
.242701057094650881390253142755e-7
.150128271313170728707322960832e-7
.930942142356216598217609811301e-8
.578622375743767525765186793987e-8
.360435053150358943716133234338e-8
17.1519138738414030256723807890+16.2969208561925463391920251697*%i
97.0749448899085249586934957398-68.9478399963263968991841109688*%i
-384.056796098854761945063233244-337.404412726761825934158875732*%i
-49.6268681295489519880750791434+1512.71457022316912164118250891*%i
1314.56656301047460196281582706-2000.76333226959730396800004289*%i
-1561.87078683544623822901092487+805.105542770182425010626048261*%i
625.440852455551288231118153002+209.978572707838618067545952989*%i
-.102937134597756888686038320216-162.281304296446291665213892351*%i
-32.6597667238944129583449623265-3.73166776794808718280609505364*%i
-3.49341253526322576011433983919+5.26919000658118606173799513608*%i
-66.0690876102357304233673500639+40.7297246535337073379939831177*%i
226.289370378887470947598277044+567.331430887377385380167032555*%i
3197.91433329940174216982035180-3439.86679317019387448202750345*%i
-22402.4946543879857618267622352+12157.3002553451109140138380269*%i
35122.7526378197586966404928755-42933.7037867813608085566581811*%i
-7005.12615431844126347954726713+31912.9873286527242548851209884*%i
2517.99932140627454985424153531-6401.18862704683831431938283553*%i
-904.641091692183161343169427184+199.138350626448656267395931306*%i
17.3471593999200157324887651171+115.277659018636370172809806099*%i
14.8608328970627537800400757608+5.76401997820222254799387400970*%i
25.3470986887567920706062584332-226.584057179300709226278248891*%i
-2764.56503038213743528515939537-1401.04896176673032366207619061*%i
-2908.55070106101510142287730591+57814.4172654931394904133883784*%i
-209735.048987711259606798330542-1065152.38841244523712907495292*%i
4333609.88046152455592949214635-3483769.90794406089107700698173*%i
1759574.10343344375480381279315+277483.066327537376136308436549*%i
-95714.3698761962550161129261584+46401.4696000256701632268818493*%i
4825.56877343106887307647027651+2508.75368510472485447338204104*%i
246.017031873618650131776056212-281.973035616893352277806963226*%i
-4.79167295465694640824855746110-35.0656171212067885575181723215*%i
188.472946086858722999787121083+452.291639223241760799271748037*%i
9819.60215746648916355255650405+5007.78455781828032873916046972*%i
392913.999192493536651368556395-453309.023705031151487514086791*%i
-90434359.6310432565401777627766+96366406.4943632726753058148812*%i
21204373471.1026726985408286184-460151904.873608463502319717738*%i
-381955194.927282075017412302413+254973808.697063828546456154665*%i
496449.461643730380026128806490-1471398.03289602682277249692953*%i
-21114.7181145630060232139245846-7807.16737768554786095214994800*%i
-786.323710610140261491499414180+365.882997345627285499949967353*%i
-37.6398557342729120581831265096+47.7061070277394813883422263277*%i
-589.766300181605110072203830304+205.921024380226072514278190012*%i
-16393.5772611940291632938922829+4226.59812987517658968795171129*%i
-1488844.98542434106175152004956+127174.324847632250331188354979*%i
-2016753848.66589507194977152285-834771826.172435602892607176976*%i
6921975844512079865.06713177629-21268171355137594218.4550483538*%i
6551171693.37520003655260479224-19312845710.9101312710954284664*%i
3851495.38563303564016395577226-2624539.71239009815979182757585*%i
33842.2007535842609257163573905-14306.9133205406823509998809775*%i
1082.77222233055566690687942735-341.503950129993199880214490190*%i
69.5518368139992512325064854984-17.8490471172460220106851987243*%i
354.348545926822551515043279017-253.821208730555942147506908569*%i
8805.49579522327654811577947322+1900.87524196468348471404196442*%i
-70017.2558943524551497210324748+394355.410029085807894813736598*%i
17702137.4023847909046855836665-45174428.4809517546620694941425*%i
2244873924.50813616219569022978+565220537.534352940488380409400*%i
-115832880.085674368608049708117+68891659.4560560498334972459579*%i
920980.184512841755201110258957+288606.761259129998707907266772*%i
-8562.34113171585477344273908284+15732.0266476523750037849176919*%i
-754.567569906836329027666097068+106.625914569331836852864023759*%i
-51.1924575209828264934290516141-22.7626028362331096042635076419*%i
-67.5533374617144786257341544783+174.458599710985891966957078076*%i
-2265.81977856244666464018669603-162.655474771863333887324097969*%i
17521.3981998036571375320279879-29887.3171701555621672486701264*%i
-294270.842515053570218237096452+364582.113563774292972343149183*%i
1376439.45310473382030045278680+1242061.22505441157133509993575*%i
596524.990888313118910643759767-395365.576641576989371191905238*%i
-59714.3395687782440795653746470+7634.18738047760106683198458358*%i
1983.20489487276592774434098155-3314.11030247270235735249913301*%i
282.230110716123064130962362649+106.515522108918283519282977350*%i
9.13298938453875461350969256852+29.2747829706672071705828528309*%i
-35.7715475070021146901723513101-49.9248246848954503652751120815*%i
309.151814964213391835855675244-309.812212598438645839029167287*%i
1076.21412173592139056281783168+2724.43909921256778506430894311*%i
-9945.00016371827246763133646827-9270.55567442893198974897864923*%i
16615.1910537846702954448717131+21421.0193485545466194300073038*%i
-7092.71491874540914005600439879-15413.9746195237566245233895865*%i
2778.92674864375680493498255511+3091.16366286981820696028415225*%i
-636.416559445916883158070547134+119.899772085488309072154773123*%i
-22.4862546303320304256379410305-87.8709669844654999615653266689*%i
9.75322407582261413881683544359-9.09031192539093571792585382351*%i
16.9001399668982504399078224766-7.89312807803237165187459376596*%i
52.6332645310227093067928701863+69.4191694390118514345486381123*%i
-306.036209361551886612577959732+154.347518512073495497230218727*%i
114.699528480933772465798972286-929.344471256297666057758965816*%i
764.446179613960604146845879747+1202.75016301622231379028628089*%i
-1010.33710200259049092999183661-364.035005563181912757052661482*%i
367.759841870145985635492557864-231.622026195426222853140346893*%i
34.1554032596968659407906906902+111.646912329453061306636116502*%i
-23.1884523443099907198933081060+10.7643676603046558262016273813*%i
-4.12368723973736177299087137072-3.20896043076141260032482352364*%i
3.22781271065059821731540746889+4.95626659963824018748564408314*%i
-12.4219072278465584976086670883+16.0485079141744711660535090746*%i
-47.9072206663428819830591975244-31.4615065628745461516844125548*%i
79.8192884944784264477231139159-86.6444649651984552512175386466*%i
76.4078353169060117989022501435+137.676893943165732015759138177*%i
-127.698191913355393605613264879+22.1098326595582995097789490551*%i
2.19100812737780517253827005077-68.1351943448740052724882141894*%i
25.4732090631917556536630168955+.158141142401958032898845291561*%i
2.11456862762512988455004353784+7.33755910478868213202543221497*%i
-1.39581108089488529153310285217+1.47214558861299577856817771512*%i
-.121525242241261054958528909236e-7-4674496.05709135759004896023117*%i
-.195889022877695706881791782746e-7-2947116.69765372069033839878165*%i
-.316552982473257565851796361795e-7-1853723.62134412293588755403412*%i
-.512908840583305008985065886893e-7-1163089.34008353865843061535194*%i
-.833415210870370878704386422570e-7-727832.639589288892022691415467*%i
-.135826934182920539695267580162e-6-454176.118875643403209607716632*%i
-.222073005647254266564020753718e-6-282558.731015331019217176716609*%i
-.364317698352492646527939534437e-6-175224.519899647218275265439683*%i
-.599841447259423645143711868553e-6-108289.078140563599890781985826*%i
-.991448539222164088821150799756e-6-66676.2166249574947177029281061*%i
-.164549633512213316777096283720e-5-40891.8315374046154541369654610*%i
-.274310921794258700971355579445e-5-24971.9837767653214548879920573*%i
-.459459567609172601649487005539e-5-15180.2638708793299783301658228*%i
-.773502608582482652640071863614e-5-9182.48337675280348877486885178*%i
-.130934539273294120131884078696e-4-5524.89889821362566474851742315*%i
-.222951148064163891477280361256e-4-3305.08517077661821762258673868*%i
-.382061320263778667887917900383e-4-1964.83229040560058312924751746*%i
-.659252166740688518595257724781e-4-1160.16569819992914145481402698*%i
-.114608826473313530560374320427e-3-679.997052567056207614804203550*%i
-.200869857685603205335643330708e-3-395.363966839466782101746685357*%i
-.355187448359260729599447595322e-3-227.858976358227982671154873130*%i
-.634163805522250665344830794913e-3-130.062010120162854695768287981*%i
-.114431698011652845415430909688e-2-73.4583334999964043291046022864*%i
-.208903151431442043626672432674e-2-41.0089727745385988492145793896*%i
-.386288532834962991349439027355e-2-22.6024341178112784672217006895*%i
-.724492600173696956491190754780e-2-12.2838884140280433867711171701*%i
-.138033586635700992104509612067e-1-6.57629524925454557012610689693*%i
-.267633561354391401544169756383e-1-3.46939940334680148205642134167*%i
-.529177580375334284164163938958e-1-1.81555822515033222421404801905*%i
-.106959039996216480004904280552-.972973070605166378253560984691*%i
-.221626874719069871263475705712-.600830362537658630620516573489*%i
-.472363793287738042621878378063-.553168444729746224563658074112*%i
-1.03973724279547022209827254713-.852441275051386412380802546536*%i
-2.37500817861664814692307439204-1.76872764245559250982695557582*%i
-5.66320311198538713482923710328-4.13295850656820942447517817558*%i
-14.1995415867335108022928168134-10.3240225661233070566707954721*%i
-37.7794828808012325042883966050-27.4512428517848895872845065004*%i
-107.904446089809459163781713169-78.3981778329573377199651767881*%i
-335.857739179675907141119534093-244.015259184980239296055230645*%i
-1162.20495081222682074945688444-844.391419039905287404353187098*%i
-4595.04669701143478657273950484-3338.49686810078817064630778888*%i
-21577.3460221662665250247752039-15676.8595318709775223570029469*%i
-127455.662427703097412303071448-92601.9591897228812597204969588*%i
-1036770.38574468709766704009015-753257.777020149789481088104574*%i
-13560263.6374876741597187989072-9852108.22359947396751280325874*%i
-384974779.647197493785891683501-279700549.623181621420732296591*%i
-48371503712.7973884917145655295-35143954590.9165146985672878847*%i
-361095282353756.462279568953531-262351079292107.801007024509592*%i
398574408881831456715.900216584
3587347693645.13229860213006201
5490447149.44772074402610975615
96597132.3099075878963702189837
5040854.67062152974302421707034
487015.344837133061869138434784
69888.2287454769424586568303069
13200.3904667019213246798504701
3049.07967574101200316657028219
820.915431983354351293951302485
249.237771358216798422673082460
83.3318659414324170459925642369
30.1477093782935353045852928213
11.6448589411325525515019842389
4.75263069437731566900923388202
2.03271840417838233831281914961
.905080304509543494422531906834
.417271730523587526123860574349
.198307432976116887103530208831
.967912173596350524793924910905e-1
.483676579616251909887306359825e-1
.246801557536256745794292616804e-1
.128302127001710251694218699330e-1
.678219200562516556895569443565e-2
.363938294842881169189613895132e-2
.197958074609048691463627220279e-2
.109006593061410217980231776764e-2
.606988265821248272975658246945e-3
.341450091653283483122754758284e-3
.193871606272979351515439615294e-3
.111020748271699578308847003035e-3
.640761676679942080584775533348e-4
.372496777351683271679774523696e-4
.217992180739399728817806498007e-4
.128361465318311628655176216168e-4
.760165088200128752233838285969e-5
.452567642418965265348037189498e-5
.270770112323241704877972644579e-5
.162747204869534605561219238264e-5
.982401185192548069092263840812e-6
.595395111184456055328232817224e-6
.362202605559823412249611552228e-6
.221118937927122236704730765374e-6
.135436226082529212988137967323e-6
.832132044344638963724958331968e-7
.512765587415480163822561367892e-7
.316841127556811334825097591127e-7
.196287501864460248412913277350e-7
.121901640095240180690541422839e-7
.758812018583420693115583970085e-8
.473383054801266762376560626970e-8
.295934067952225665409569372130e-8
13.5745242355635696096599730721-3.09092912578133937004983015421*%i
2.10552175498207293783918032901-67.1290095850309327044682251803*%i
-274.918466474142488312376284549+33.9836597146290653478861198700*%i
521.442327501131557057736664997+600.236785838292546509525787257*%i
-72.1495074553886829421701919366-1238.84715542981513357129495001*%i
-492.328305906014323536638403087+776.120580981821721889430234336*%i
352.911460651688458238775150835-37.8013767845727662501949169029*%i
-31.0891182624710929589827539313-85.2817144903674272047261054856*%i
-18.9022432909347966211682797457+3.25952885649986018413065078737*%i
-1.32160649956395389796272436618+3.60965165039503863749728823634*%i
.601848614834105587283204120674+43.3433911167928241944389932608*%i
313.775786645397934401133862078+69.4502421025433721322336482778*%i
-330.054186177648155081330082340-2298.61946121451007160051104104*%i
-3455.16557528199970237579763521+11434.2030493747446497160458584*%i
1087.89819785322480979536884006-25326.0148899821325018075415608*%i
4289.31259360407352016172556542+14571.3718267401962535882383816*%i
-33.8969133014810340653964460289-3360.44248537119151508877597302*%i
-419.108262761716510447082850839+236.720814303489742924209666141*%i
24.1122833450963222912195180623+59.6754777643645795482891064372*%i
9.14305475112536781222980901450+1.67296848040927981819491850417*%i
-101.431165862702239941791045615-67.2100210438346899574596342285*%i
-1278.16159818071476241846534223+835.223845792969043123798979447*%i
20641.6818246512518482932189158+15714.3183564874240120689230317*%i
-379561.054286757607999039460411-224370.088740449945501297581692*%i
515766.251492390593435056964398-2072207.35234962104572187487753*%i
681363.555053435066896054964840-204405.876763008640104018470894*%i
-33915.5928453659559902218554471+32129.0747059458763452431223725*%i
2544.91076554672152075877660002+671.510744215330843233482117660*%i
102.767219641513817864381041095-167.805181959902482010554226969*%i
-5.27757886696676632031072859796-19.2221860812871408415756797763*%i
253.425949273548821789447627215-.186197904865543484483595204751*%i
4026.31247492158200586420172577-3237.36166114843144410468915338*%i
-92239.5436550560296565207248393-228152.617899733484394854680037*%i
10283833.1627127585410084518724+43789659.0241348704355218033337*%i
4637493907.44638490587354690922-3862393209.33823056191166494581*%i
-92871362.4472086170498965662177+117309885.695837691204419914381*%i
93250.5759379337104779324586638-609589.337143384519670823043802*%i
-10015.6841810527202475677362034-2437.13532234430644814026361598*%i
-382.483616383427308022756588816+218.982336729256874678829389611*%i
-18.9617991192024865669339222482+27.5551280089137946432005374120*%i
-195.932350824205317984013233584-252.916306643171435491896226062*%i
-4269.14480992782819851611168389-6533.05071426798782297981779755*%i
-240517.585984875502657922930934-541493.464296431520803356977456*%i
28341087.8357817983766699133064-670525174.329079243680472703949*%i
2878289851099939759.27606075973-933589782544917502.042315687067*%i
2101191976.66452495848415387877-5399455441.37756287511788831849*%i
1488910.84452175982498442709082-970159.241875034669760706245827*%i
15291.1649931101041905474842772-6226.96305740527263353670196503*%i
545.950237999205875280822100182-166.468716604747385889578970861*%i
38.0879226001214279820257608385-9.47687416407013772527388390119*%i
194.495283537255853974679349683+116.103109032154988441382527198*%i
976.698338276607946409643933833+4141.88683737722212711674374978*%i
-157973.663199753900295651397833+53572.4166917879967418719606780*%i
16585756.5144409639708601931408-4277941.20314914818556287653674*%i
437082642.138927197627139087145+563947870.132665958159377896559*%i
-45129107.3582791057710101156202+8422629.68095741837721707403168*%i
340567.319360063300040273519097+190275.722630040783808495480446*%i
-4924.16809552270727088159706969+6649.17252348310312084673944715*%i
-389.005935755184858673145087427+14.8202817429970483385246744634*%i
-27.1907585451570652461512570770-14.7725099928014648193746171627*%i
-99.9587061807201184238165601399+11.9072843067443481130361941721*%i
-511.376425715449254372266589870-1011.10356518090930226637641148*%i
15772.8005932077725836975042538-1411.77990992134873454364395414*%i
-195960.162247910644270616318826+12881.0758454857308935280837203*%i
139253.873257862276329976334962+728460.033664932140638703008074*%i
293472.284182106522222935313696-36235.0069151812516781379972732*%i
-26488.9787876980387650377790650-5341.03209808982798965847716607*%i
1329.98785735362849784666353708-1349.23102485168225750825163012*%i
136.975217342832894731121986834+82.7666234314120951406129931568*%i
2.73446782180674469155588812395+17.1624260842600808492496891057*%i
13.4749414743249536700471233873-31.9197817877419153899375793976*%i
229.929188452813017998775124018+40.6605539620002543655960869181*%i
-712.669434653986605061044275017+1292.71488653871644809169200275*%i
-316.101099249161394891771707160-6523.54654104572473036082776852*%i
227.018222043500570278279736716+12737.9943724804869811163320408*%i
630.605541527810268171421253293-8069.27691216236203720025518594*%i
683.727719547599218155864663465+1956.13798260954466679321896025*%i
-338.944852681303005331658445195-41.9975776601227066866736403971*%i
-.234033231133436357950446248367-50.6182560958114041033747990709*%i
6.67600594039420019589716270313-4.10408421254246930038664611658*%i
9.52764456125006493601675189540+5.69622100836932613067134826803*%i
-13.0499682312382762924432513993+48.0819476121942415478764034480*%i
-176.195251988045326683489774248-68.2703798184287838775565188864*%i
382.562523506451682052376682903-325.101687274487269486196633703*%i
-54.9704813413680581143728705710+753.054673203275426995591132294*%i
-365.834280998907680510452123706-441.737628025362630904228025881*%i
236.197416507214873871031725002-29.6291815019668776164319016886*%i
-3.97580217042848190049726762459+66.1390637985865508757565517094*%i
-14.9361164334214474093003949358+2.13410108088555494351911618992*%i
-1.98362765174900268616126259863-2.51778555431171398800075674925*%i
-1.29693599112324248066559579593+3.47422313855439160734029111647*%i
-12.4044540699603932066068991082+.363754061788750951584256687953*%i
-6.11110305130173179742161913420-33.7268141130387641372742320250*%i
68.9955187334551798118080662272-6.82686069461481077902279966725*%i
-12.0143307577829480138627332291+91.2947657485345503675422673163*%i
-70.8213589442153307611416753608-27.8841925692213940028781899413*%i
19.2550182706236447579204559808-35.7541752477857577738399625313*%i
14.3182402899120972534828604531+5.95299875451691496305108279318*%i
-.214939470419250675426599034683+4.76513429147279457628980302425*%i
-1.11879017968399776794257787741+.666657553517662907353902532671*%i
.378928251006800879376457723533e-8-5775446.60657616757726257376548*%i
.608410488608636046320820242653e-8-3656579.07251063531968696969660*%i
.979183208268585167755060070996e-8-2310043.51064377857146720587399*%i
.157986446466841941623980977841e-7-1455996.94545011287862206645327*%i
.255582033079846290423856193232e-7-915440.430617479368766849156839*%i
.414635902071643130558225203348e-7-574060.412886174708133676457719*%i
.674694398605913166458884144687e-7-358975.911667154495632656695440*%i
.110137483084403219015463830096e-6-223804.388012433197326718915511*%i
.180402559537729333092388675984e-6-139083.353071954493931718119342*%i
.296571686169423909715872129646e-6-86135.8769998409774475175258899*%i
.489446573813736169657576794141e-6-53147.7542655784081449088966222*%i
.811127277161686606499213423392e-6-32663.0324483411940334435263888*%i
.135024285910406679678368141259e-5-19987.8308786384827192900918421*%i
.225848913661208610995229823793e-5-12174.9098868459260391312388884*%i
.379722278168848939392228044924e-5-7378.95590455017692848897548868*%i
.641994627749171745929836222210e-5-4448.09558518371748653498418591*%i
.109196327396669980760934964283e-4-2665.66051952938402239297696953*%i
.186943963951278992937670327067e-4-1587.32720958279914381900865668*%i
.322315731704840855946663814847e-4-938.670324828332862332532852424*%i
.559997434360977359383589434016e-4-550.896419995868696272125209039*%i
.981126652526493840569980911177e-4-320.648441418626169516272032365*%i
.173474573599197468789211556545e-3-184.945877158881704435485065429*%i
.309812324662823349335573496871e-3-105.615331557254618437950500315*%i
.559428262299357406811104710512e-3-59.6537391151409359334427331999*%i
.102249868114063376419290352483e-2-33.2879973750395724740363744825*%i
.189414476630130675044880730226e-2-18.3295294350749136862615229165*%i
.356153871254766890283825975169e-2-9.94821023806345034596299409841*%i
.680890019216548427518054661273e-2-5.32059652762243381487438344852*%i
.132614345626681712724592027981e-1-2.81460801348960076079295947800*%i
.263743487793071801965724248102e-1-1.50259478967018833802612444193*%i
.537069378471814578318893359145e-1-.876489571215100088407648284528*%i
.112339886622876982737600417643-.692043807990340888420438980441*%i
.242304930227408568028866597533-.909194509827937301643933413956*%i
.541413798610927311387699525991-1.74074011879051587388244651375*%i
1.26034999988169008411279157134-3.91147973035949039759101423156*%i
3.07807937420996518310115268558-9.48688812514475597855302835470*%i
7.95595318208957578717311442466-24.4912240070572868856070550072*%i
22.0071069093551500107812954154-67.7328615583872957311758680193*%i
66.0951849547918829709998903844-203.420721207365089058241302488*%i
219.714477644526072972588039600-676.211831389607346727845822548*%i
829.940990723725091748334619309-2554.29577772446779399468446794*%i
3697.62260500967758833672676193-11380.1122303165128099524641592*%i
20535.3633376490613241471480373-63201.3496764103431336932515972*%i
155106.672076921264013578024240-477369.251157476806026370644331*%i
1849717.67429997197924704547031-5692845.63461514603093115178865*%i
46495392.3559355105972990601893-143098103.608366841911011299299*%i
4892071465.99564320845460534317-15056247813.5795985864288810978*%i
26269887717252.8078872192032882-80850400950831.3649091063327471*%i
45709086259702133644.6266236069
816664532738.179974880413165117
1587213432.70493689735329332627
32372703.8805710789247134345456
1879884.06232950888759617197322
197421.370551131887105463961684
30328.0235492388182670916765759
6066.42583797477952423107963565
1472.07747051589902115021748220
413.779274180115511100018799855
130.505322879297281550467128342
45.1437984923098990615017269719
16.8397911020238692197747252476
6.68746028384914654119026002479
2.79919563627272742701809065793
1.22523517638604035388426126558
.557263006464549814204270038556
.262003783756179500298953026677
.126796970696777957346986853512
.629392584018581727990786655955e-1
.319484457283220181457449896615e-1
.165422808385307174761355559324e-1
.871810037843291517484730946967e-2
.466793304109739430144351847554e-2
.253517807559150359698980824801e-2
.139466351551465080210841141319e-2
.776211585122131437550256295362e-3
.436594062986948781218939175210e-3
.247944736054161086049180842081e-3
.142053092829796062269805822983e-3
.820436579411660321628642338778e-4
.477367149782188939675478060441e-4
.279652147064928480930877577197e-4
.164859188643868306035420938690e-4
.977533850161953901891352075062e-5
.582758431091368685030294596603e-5
.349152919330517638552466528717e-5
.210165330050364390052365729485e-5
.127053486929834114357160203656e-5
.771198903228430416377043117139e-6
.469878637668059176273625199819e-6
.287302555630738468661970465064e-6
.176250993050145535893522434138e-6
.108461011764913723129685526363e-6
.669398181552098722486388621765e-7
.414275651867354310791968013496e-7
.257050993000311035462473946302e-7
.159885981045484795786845451202e-7
.996790035637584563041279092703e-8
.622794094558117500064555043925e-8
.389925828239210967392277813293e-8
.244607093159724166210746980139e-8
2.93235109161763205228066059944-7.78854252593453183995559584853*%i
-29.9606642055771771222315910603-24.1390633155779178074059933867*%i
-86.4344319258257880693215353057+125.714453816307223663061674530*%i
422.361712181951505152222810868+45.1508443664976815894874997260*%i
-420.392281471757567825344454367-501.400025729051278977077557376*%i
-17.8636985292721019327434849505+488.603968883625716949245264390*%i
166.899717840348908612261854065-99.0869282583221179662185433586*%i
-33.0850720362309748549089373540-39.5641438357982869484852492446*%i
-10.2147021008827635149889115172+4.97113548278034473283006624206*%i
-.281410199935247451989116169969+2.35361436193464667746136111836*%i
21.2767445621749047792117796360+12.2708184922103963070703864018*%i
124.783169197426992845549844270-117.906191527385658948282723915*%i
-1003.09728054254662771971122662-595.175113838160262841005642006*%i
2663.80132332695037251999204678+5026.63675766284528322399805204*%i
-6647.26932582714679805416389072-9719.16388997372353760652417405*%i
5088.66342930517797758696503362+5060.99834483055384995079779743*%i
-640.242440009899196368171394247-1540.30931987595608686696742847*%i
-175.076035335791204384172628571+183.996665377047527290499952821*%i
20.8644444894987805038635170474+29.4117091731428284696541379217*%i
5.49638297295271379394196864600-.345492956070468931097358221898e-1*%i
-57.4020490847325822060553908697+32.3253607526606105119136503758*%i
43.3146834491594264609879824777+762.299175227784722181853909690*%i
11206.1799760784797945103934713-3717.97693740850943256744356538*%i
-173299.649054910353964090230080+55322.5407862144414970944519789*%i
-328941.666288917964540710814561-765527.846577533587220590334376*%i
213309.709933589302049712371626-194383.590080071530760581178726*%i
-10102.1271493185547858338576044+18226.4636115302738241636200498*%i
1292.14560711662095460028541380+48.3332083033896739065911539055*%i
39.1953407706096668670017216741-97.3919610294759732286512423984*%i
-4.42267771682120390804747693630-10.4902385959422340546262639051*%i
50.9043548752269927155935028083-122.833483656657778070312421285*%i
-621.403085409698420189539936978-2377.77784582466857549285799508*%i
-102106.408712439664736034286210-9003.51422859752192714298599452*%i
14575985.7173505738657553204395+5414070.97249866668005882120952*%i
352632349.404416016744975264416-1708351031.87530611020031095887*%i
-17313274.4646955689192713811982+46384067.3818787932493674812923*%i
-5355.26875660272315920267378979-248608.812798242683415889870693*%i
-4754.21300745442286834739425711-590.696590237186159850358259765*%i
-187.025981838849725170847934653+129.044383720307728933287492679*%i
-9.56572875122584656140583732872+16.0319251168384592669325580300*%i
92.2703545639925718778758206658-138.246777824839551632149100875*%i
2254.55096976637936137786978233-2871.92651498747447507547192571*%i
174407.761444192213208192285814-162723.290253224783866644639566*%i
199703585.061127841209010086100-63518394.2602966193038560024736*%i
336241971775311308.324573889325+244567459577607075.151050860977*%i
674295016.107025694637158612227-1529669538.87285841120583343367*%i
584049.256627437951479923743932-363617.952426965535332434891420*%i
7011.01443971547131817881607269-2747.71835387420895361097857693*%i
279.233819305940125648147858912-82.2483610213720820838839328565*%i
21.1469515874014658823446251468-5.09833422186855583371979866386*%i
-15.2091364056973424257376652198+118.439568563972053252833772249*%i
-1592.53854471362086930529815717+1275.41647614218952467666535129*%i
-52018.4954460329204220058615925-47645.1885446029832613461185804*%i
4726088.67693850691912177198598+3921931.60882981003545525444140*%i
-1225973.49000100077008626864964+223370892.349033939436086231858*%i
-15661430.8484310446208077777399-2645817.18161278324335748420742*%i
120907.993386458722838047927427+104976.059362864716761315504478*%i
-2717.31735002497277653516769745+2769.03420221812885504595631995*%i
-201.343742329446508196210034289-12.8320693538165526854329799218*%i
-14.5309896718815820567641153971-9.44421686856265204417428575813*%i
-31.2728895881441805311442025633-45.1883216400668427895792843491*%i
306.502356851116831027131063796-484.952788287697621164986838606*%i
4780.88310328392268220967812047+5584.30897180702265770732979381*%i
-60564.6431502957790526970616517-57662.2096971796559141820435882*%i
-133539.000379732362561937722190+270248.094752072329581789531698*%i
117054.981234188416560669473684+41310.1519171869606253161680623*%i
-10663.9481071894257510565136193-6168.22446476301601954273449837*%i
802.078822260590633313605950558-496.812536384782523364560280674*%i
64.4788657224263409342912415542+57.1319730672308140735647363652*%i
.148141776329605059567394618663+9.98580157800691526657576301891*%i
19.6099979403680386912025636847-2.93164397360453166798689371914*%i
53.0366462898643902006085816643+114.826796235555012329179894507*%i
-742.742671632784342100569214932+139.543487874791342281111135005*%i
2113.06717684804576138034169683-2388.29447706379646099717928654*%i
-3556.81904271631289164975441329+4938.81703670297735870473293710*%i
2172.55670641267931692079745057-3268.21650986821567006939055759*%i
-61.5122291770592135361501879149+1047.82061448965057670075509547*%i
-166.162139788448592170269247610-76.4591667521061559089718549655*%i
6.80066884302196320679967366880-27.8494043432352685080588100958*%i
4.38140939713561323107475400317-1.61955609036140141223282858965*%i
.360184310160139654095448655641+6.70754153619717617574366393567*%i
-26.7673053926243467425480166413+10.9961735650178691976801222371*%i
-37.5553269405311143055433859307-99.0082299481859512887875594185*%i
273.549657810447853029824555778+11.0307480711068588147997274264*%i
-265.916142137981320472585777115+308.120099789506544781378762461*%i
-49.4223807068094608467803396952-307.649111707969104610978931971*%i
126.201883647297468052477697728+40.5366348467773463812280813237*%i
-15.3922920378362194052822009914+34.9601863890408574575733334871*%i
-8.93909544362707308590687192534-1.33488724792816291159977701111*%i
-.827198365006321355470626410997-1.81449956795109465796221220993*%i
-2.23824343267848558212257561135+.645946634005160984072716043877*%i
-5.04363105102001820571251577996-5.83474899613917534884383631261*%i
12.3478981905400066071265037566-16.8032033672582292286329369248*%i
33.5493938608376612493636015008+24.5046836812508658873038490521*%i
-38.1301251106915641465889918217+39.4402379698349584544612174881*%i
-27.5706969738683126352708115304-36.2224930292805718008559178528*%i
20.0678301469807721626139568340-14.2499197213492819610335964930*%i
6.82891155288690620142844377728+6.73761054914858545760530385903*%i
-1.08617142509403581050845109011+2.82324573769238607086173830818*%i
-.818082404659114504684653275448+.223151756703535722961489584849*%i
.100816916255077035455495894103e-7-7083771.43398839911981900009656*%i
.161257801934876061887699646549e-7-4503278.58472009214792860870542*%i
.258506819764320499706531284778e-7-2857052.08645197377850538664763*%i
.415379075469196637751261544155e-7-1808738.76083381130507151881418*%i
.669114811684256240214024697254e-7-1142458.24591544758035442697222*%i
.108070542051153707262625935748e-6-719854.571698814995608786905191*%i
.175040129291516962539179609030e-6-452393.520095744982650288863443*%i
.284361510742667548042837462535e-6-283514.878912696274329910354115*%i
.463439669783594585044615864300e-6-177148.150451558936140701400669*%i
.757877383747568662694139646801e-6-110332.632279985697329625315052*%i
.124391559920474315350724719994e-5-68481.6431331538193131281811942*%i
.204965967053316139748509390210e-5-42348.0389927947958195609053138*%i
.339152545693861846629145323124e-5-26082.9135036319948023452844166*%i
.563724386285256902073563448302e-5-15995.7455670693003429864097370*%i
.941557420764600222523107849746e-5-9763.95907103636706852219012743*%i
.158088615985940297245469590906e-4-5929.95839556218152514852928941*%i
.266938719833553121698518228459e-4-3581.74124590695056671793152074*%i
.453506418640174880140285702360e-4-2150.52842670902613997856310751*%i
.775609455331739680176646949010e-4-1282.83874911299384626221915949*%i
.133611566720128811059007870447e-3-759.827072582909911799290649816*%i
.231990646219685962623214593189e-3-446.561691449793989609792616920*%i
.406295420670199755712976249700e-3-260.221841657774937382693563171*%i
.718321959855312247498017145794e-3-150.221021988136429725664599437*%i
.128324884858857040267444554281e-2-85.8266136908983110910264386015*%i
.231890131498735336474472795264e-2-48.4773869019964555097364749490*%i
.424389783916035762809782181834e-2-27.0355865360432591193322050250*%i
.787715580681547968491524219497e-2-14.8656642164271133068931779787*%i
.148525418695289562268764888078e-1-8.04564582145265604914504971309*%i
.285021475941787553173311616936e-1-4.27785338157510443892232677522*%i
.557900022970061197797481754044e-1-2.22945835494924186005126786522*%i
.111676711171004720373125181844-1.13587382876012744067648688082*%i
.229314020765606992505142223500-.563969339151352441053048581146*%i
.484792420101056208847307445191-.271862490325575143571811719253*%i
1.05989848136472708965706700190-.126663683650308427978777440875*%i
2.40938542780943870415235977686-.567254328616466662173931567662e-1*%i
5.73304758159585200796305551521-.242540661358830287201676981730e-1*%i
14.3992811348176584084435186658-.981732901279671467103515010630e-2*%i
38.5840805167547134242395801458-.372156923577706904356067300803e-2*%i
111.843595715979642393559350044-.130291470885312210526651669247e-2*%i
357.241287087428768437519077657-.413530021222965027804661939988e-3*%i
1289.51217172108597653024234041-.116008425185146299849677648932e-3*%i
5451.98346490201611694123901982-.277503358645031979086677839933e-4*%i
28472.8375712142757802169117649-.536685546541481105264680251573e-5*%i
199724.450858898491121441297592-.771664876840779844369032935257e-6*%i
2171962.23594512715199521251737-.714601099616934805693876537805e-7*%i
48343888.8407124864856970528648-.322810117105720657014628142672e-8*%i
4259724962.87558295058680949103-.367766978509940479347799070566e-10*%i
16455008221604.6288052673111379-.954107456833899452971483319875e-14*%i
5327337172353039320.69055134470
188937569319.900259644624178168
466276353.067938585994210628287
11023939.8824759129905355553127
712280.598446528539742233432217
81297.4976301055164396786793432
13367.2911215806238036941363427
2831.10861554858632707360164562
721.572874988153767522407497521
211.704390347417511964920554417
69.3475084394409701518745944855
24.8122554475895176635158798187
9.54090600470069339205399121608
3.89444526245303817748026560423
1.67137948749276063809630636186
.748494629983467481195379662941
.347651799757773797553560021365
.166644850889465477378807034631
.821031743528046323558930807289e-1
.414357515333057168629065965776e-1
.213599738326777364130927240205e-1
.112199124763182917421710494669e-1
.599306326582204673566103839486e-2
.324947226122624040251269377874e-2
.178574716006046137453331152275e-2
.993335708448339161178591568077e-3
.558650290527289935176479342823e-3
.317331121819323764305702322883e-3
.181897705673874274802320312224e-3
.105133664470289477047351531379e-3
.612284167927589215832222377617e-4
.359079610179143986929226242027e-4
.211940314046630706790840159960e-4
.125836081519839999209541349481e-4
.751226896731088637660040453837e-5
.450750404354291891531073225804e-5
.271732613918599204722455130195e-5
.164529786064380092819629446221e-5
.100026272103831569022505302880e-5
.610424248515588754029916629407e-6
.373843119639592319723056107772e-6
.229714286003102618318595949873e-6
.141591445347109334570904526682e-6
.875292661907572512923038460795e-7
.542575776752655196434543856266e-7
.337200323413149933190763088821e-7
.210073428335052194749804226651e-7
.131174632525284804061366761212e-7
.820859251916276018145024878308e-8
.514726150742935555905324980716e-8
.323388635750288652257526498769e-8
.203549447635336155401924047801e-8
-2.98161097884504246745656141596-4.09881183233362673346793249279*%i
-21.7101453927032298581771144627+5.49837170883441656388583764709*%i
20.7364449288299257697987312712+82.9037852000675837877773599539*%i
184.740069244497377174347064589-138.604535935019514780039946433*%i
-341.716594469434769667311602069-81.2283575808580576200031731533*%i
124.886446036500131542240326539+233.431237475899518844870846610*%i
61.6554560165920532633280022772-88.6391119264109032863242345850*%i
-25.7007943182445335597122205700-15.0518857028292982120854712534*%i
-5.08004029502490569545529519560+4.56862362664699549569180481332*%i
.163117542352397937886807619147+1.47399536841416242252288251815*%i
12.3067172220789455358394818796-6.92383379546928460405168675159*%i
-15.1009456622392988930216836532-91.9339872005203948330968126033*%i
-557.676222688986632254496381816+208.907059290815018785008887345*%i
2630.69716437956678624573623811+819.558431100828407194335086877*%i
-5266.77105749052087247239289400-1792.68143515766686512970151775*%i
3313.18877038392350797501055325+957.823779327387473205093301194*%i
-589.948966565849256560656591654-600.398494350390601574049040202*%i
-61.1836985972367586055098448092+121.639189726274888759866193784*%i
15.3861227458934429995566947710+13.5659065233488705990079216478*%i
3.23717227575638314272933025415-.627952786855389190560862532737*%i
1.49736468663626715743576658945+36.1726247153541321478408796116*%i
346.728238650863479142505563439+173.640920660042617098446345042*%i
1501.90124904162041897269311764-5249.59890529028819582637751673*%i
-31004.7143657020836839941888206+69710.4545214481051955126688015*%i
-287623.444195478207942994407753-162830.935012707457339403421882*%i
44651.7842364391040610813762916-110323.912022283707308598847624*%i
-1880.93140973602793584308884289+9257.05383512054489959553140439*%i
634.554257616374569637098187147-116.947711368137007166401275779*%i
12.2337645626272465419274592540-55.5262245658431934572315662134*%i
-3.32752892020311017186138405719-5.69490428218549207467797870759*%i
-50.0363746654947332722883694110-50.0928975103001356492633615246*%i
-1170.94649644134564623664939500-195.594436470245446558441274097*%i
-23031.1078435027547578247906228+36754.7988659851777065808721810*%i
4416770.83281780503259283848413-3213786.97607364584320365893663*%i
-231720598.281729560682043912531-457035600.933998389609890897385*%i
-748959.668804336179512122274470+16632713.6891075615944708227719*%i
-19696.0974917906077701961588346-99953.5857808604078705471039095*%i
-2261.16042628525302928698218397-20.2778328309168500273329072826*%i
-91.8997242707385452710691428002+75.4547669314514328955205024327*%i
-4.82237581735397685001127850490+9.40538960457348818745922864799*%i
84.5635478707350990071505504108+22.9887210062795960983931659712*%i
1635.70964956635469568074679182+577.058837466611458797232766905*%i
86195.4132923572143082186242337+45679.9031663360019375848197455*%i
40669683.3266958622618307133051+52607107.5902220948122124835539*%i
-32255997600000.0999999950396834+58060789920000499.9999791666682*%i
217264601.073798858313076745432-439362206.368537461783674394919*%i
232613.072766912016897718475931-138254.558071642618569897270662*%i
3263.74545775589142856416995176-1229.82785511686659817090083950*%i
144.942164888901451451436315703-41.2076763850287153717583478415*%i
11.9090767584006072989541774667-2.78027857401876673629716110598*%i
-61.3640759666344019457093145777+17.7865201738043278334122760946*%i
-893.457482739967226054794748835-434.226611860647531132564891131*%i
7193.99289992734415401878253087-29440.1041590801287022177908870*%i
-150312.797258779207609523671614+2232809.41438936885576536341979*%i
-44157514.4342008415490730199872+55698288.8952068861746079454827*%i
-4849436.41696048483366343634781-2770392.91419942925250705881852*%i
40449.0079907918350349007058107+53129.3973656487965255204888783*%i
-1463.09009480568600653926681362+1128.08200982303018786036954147*%i
-104.695087956220851532688774090-17.4047511254940740587042836672*%i
-7.81232744309043527015568240177-5.99199505897607064118778677475*%i
14.0606184250117142472625966866-27.0138428627711844127353926630*%i
294.921949708274245350761840331+7.62011376650149163273517161350*%i
-840.576163105360048047873706074+3364.48395493382704128383151785*%i
616.259371855835546780523126443-36194.2923657237707984492450890*%i
-111400.276949193044192558824850+55746.3749842428876212395174513*%i
36870.2990752485255214109244321+38038.2987612819474087745727533*%i
-3771.17378244589063282927598270-4284.70713320457769229235469569*%i
453.393476350309170532670914798-149.053326306850794569979835678*%i
29.0662671358660190610273317659+37.0311848907225473030107081210*%i
-.737235014338690414888648569018+5.77514260774626386194030777572*%i
7.36180054293161008600485708863+8.85099676049657705398545202952*%i
-35.3187165147412619049051326104+59.9826054804475311617846821155*%i
-301.627520565870033570170173176-252.465366559846255134102379777*%i
1579.43622936986273915015093771-115.391917944623377276946175742*%i
-2821.80758907509248167377856465+887.202470122577379048904082107*%i
1720.29445859583740377461545378-887.063233943571015771246172760*%i
-236.228896143550240027177510888+486.216497862143052528650919338*%i
-73.6662853258823454180136451354-66.9321218378877297489702272934*%i
7.63659305357043048736373965448-14.6090358736193558093646198969*%i
2.78913426120054416846324234393-.447344999483797774303905472507*%i
-3.30601321068464068884537165322+2.49656030049052471044945781522*%i
-14.7447732638130776702813701018-8.61448660933873306162510253719*%i
27.7746725328094679966892550898-53.5942910055437778810416025470*%i
107.371928708909842353633544665+107.550537525538964191703501712*%i
-218.040250653027972928609492932+48.6495772878035799795840559110*%i
62.6529438946263801739139316920-160.544299711148966163978543018*%i
55.2277318088425488167544248075+50.8792662018267388382858109886*%i
-15.5333534101670332040492573562+16.1181549471889730065853522964*%i
-4.98492039441257056559632480665-2.31987955540140308950568199524*%i
-.239106716482432695922337478686-1.23582812190862185028694141361*%i
-1.13030360537628735951888950573-.884454914389151632514930601222*%i
.877639376953806128950393561640-4.80436848400615039519088323132*%i
12.8185270642744023163703289082-1.56397832589793852228258580391*%i
5.24790033898353254807395130532+24.8235397680416826320986845969*%i
-32.8843536289800493340696283566+5.45691883798663664193356620812*%i
-2.96985225400350809317729598729-27.5943224270472858681190683303*%i
14.9924460848376307950172037078-2.43633103348099168689495778780*%i
2.41177647991492220286456816470+5.53251308152192449462626042117*%i
-1.23362548713525562992556786679+1.50818200082632868204944018330*%i
-.560172281621331091674428793552-.502082254297597419751530842457e-3*%i
.257983243233047614826776726278e-8-8624673.34692614066192569227705*%i
.411130001045283266524046460516e-8-5504632.65436412872038007019536*%i
.656551470744395337590107227417e-8-3506766.70940771580207573919782*%i
.105078565499921665157203296610e-7-2229592.22885566501721779646269*%i
.168567346360982535250710436692e-7-1414577.38392632160853275143857*%i
.271087687842199143968060821000e-7-895464.443545241029886770695819*%i
.437110877361578325945037680849e-7-565486.797281719096007434716212*%i
.706794764207691068181719432920e-7-356184.522919473181218455923273*%i
.114629384906620234424356533454e-6-223730.492341166940290629262130*%i
.186503913608478798966614567327e-6-140114.904468785050283096124539*%i
.304485031458934869389083320955e-6-87469.2560083691691714286567088*%i
.498925660072553206524861525039e-6-54416.6515854244754588895798996*%i
.820755615441615227284546516580e-6-33728.4259188079253526274735130*%i
.135590072588698560025510210964e-5-20821.8202563492954192062718241*%i
.225018876236643242750501651730e-5-12798.4239214932402316041990406*%i
.375269206786803747877277951143e-5-7829.80258173577106275008722199*%i
.629176661623335962617854833852e-5-4765.68607798270890328974267065*%i
.106096240031266905161360848949e-4-2884.59013628429612355193272116*%i
.180027604630219211316081215942e-4-1735.43261770419708989902646296*%i
.307559525536823808655162012567e-4-1037.17256739894694914571989862*%i
.529344687972061851679618639133e-4-615.372902046064337933432169067*%i
.918478958909330517265855421698e-4-362.209052091358255954227439685*%i
.160791183307787603703978721506e-3-211.330712844504479967980774856*%i
.284252569382506270518330085744e-3-122.109441197285540538504824344*%i
.507967756138657614081116608420e-3-69.8011546745258229261753919251*%i
.918673649926395244743176772042e-3-39.4251843918179779574296153121*%i
.168367711919297224632149866233e-2-21.9710872638921572878515571931*%i
.313182807821167071594344106795e-2-12.0582498816216243954128785541*%i
.592319715230870611425982903252e-2-6.49861932851953788326952610559*%i
.114141358885330139777971738172e-1-3.41821214618829408087173246973*%i
.224661863630669411769147655463e-1-1.72203525176091500961074121910*%i
.452987137457384570118985287925e-1-.767226616269077356301536754772*%i
.938930202267573123070606928215e-1-.157274848538109543544115279369*%i
.200913463418963402303384036745+.405687359886923818303400757564*%i
.446125526608096807975017844812+1.27542498874971085174448798490*%i
1.03455122607706447530148413419+3.14115090956984177314640832952*%i
2.52565163775268129764680997474+7.75528434429010118360039673813*%i
6.55779715233231126602805116403+20.1758249492506410922028432227*%i
18.3515908472716575485632045293+56.4778481036950510954109131690*%i
56.3374801741109319217236468649+173.388095320367298249159337626*%i
194.375460933717202253033120962+598.225909394099576036284014322*%i
780.047765847006535404479057331+2400.74010491743553445932122602*%i
3831.61009055324201285835153404+11792.4832837622195597932988076*%i
24964.9505981373056655135913175+76834.2174602966622474254544383*%i
247606.462174355989370034522775+762054.332332020957998130481278*%i
4880751.21644432200117366701111+15021407.6678987714713266544529*%i
360180017.277103695214179804743+1108520109.59324038322821182295*%i
1000939183916.40364532243626063+3080574048053.14868120292869181*%i
631433034593845358.519635504180
44451958950.7262516985781510070
139290703.155953668628636230995
3817006.97799601033444702576892
274373.873980674140999704398606
34030.0064690728321559103955099
5987.74136056622237768582758917
1342.48262554688623315751914177
359.300302065280066430186764483
110.004598351306553982954843723
37.4144533367043741558618337609
13.8427302267659761088114289756
5.48539598515589627980466267870
2.30075961435072883671729901402
1.01212145747016512090284507715
.463604564007278975218638222784
.219832969449476552903060357865
.107402768667048950921697052996
.538550963920306219346304123911e-1
.276263143641663700574461011273e-1
.144586018923505913206888709196e-1
.770266507480670884042606261071e-2
.416887411992269269700804540906e-2
.228840121343524303899842811922e-2
.127219482824746423572643491891e-2
.715383247503270324285763649243e-3
.406455441135063748430474122911e-3
.233109707221603602979765453976e-3
.134838895481354153119348466909e-3
.786057368030147349330993975960e-4
.461520439179187168492831489203e-4
.272753436022920743467384858271e-4
.162167710043854289537275974965e-4
.969548226294596631446526494306e-5
.582642379540042154389176822120e-5
.351801146935101679143783502233e-5
.213356473772955805243365709441e-5
.129925004455695520604998942043e-5
.794210093436986039007441031444e-6
.487216815305987425195741965884e-6
.299882853315030052744126234700e-6
.185152921489965757195641985974e-6
.114649982284036760385720617501e-6
.711875195090493906003229215946e-7
.443147656929815361679038758565e-7
.276529687696743361866597558496e-7
.172950929758298981048095472744e-7
.108401588442636707085318076604e-7
.680813233902601639844957744520e-8
.428402255725279944381830276369e-8
.270061220610758403829008978195e-8
.170536715705058409195130907328e-8
-3.15142965790085997145251926393+.134840279350667957600178120868*%i
-5.08358654889918177955303356846+12.2343318676442669711419060624*%i
43.3073497526873942845428483478+22.3293109295634975590915258925*%i
22.3488215378286168379881169056-125.950436135320620373585703198*%i
-176.486008902264268349621070210+75.9589071304447431905796448569*%i
124.284211922301543956842142990+76.6892260301347192894084485606*%i
11.1003706099273497540107970707-60.1307072068875876516915789988*%i
-17.1851046937898532312365751885-3.26812592081854555898794944929*%i
-2.22387048901055525933513277792+3.53313418558944041092906270147*%i
.310850437047032968824479417380+.888943817332350692543850740461*%i
.161726121482793538650921805799-8.23462810993465680799001397177*%i
-46.7243003441976546086826480975-21.4070583157136837566586881310*%i
-96.4164695017073519719580047242+293.882223945712385502685942338*%i
1204.62949510182461442130517722-627.606391505405725436131700639*%i
-2544.49133046267091398505170819+828.733572724267558983856817137*%i
1646.59863045550907458339752471-366.726336934617385112256348464*%i
-395.824723485352826599261851614-173.364127473123658338959977701*%i
-12.7956485456900609859021831979+73.0987274780479049625953085049*%i
10.4387526126068208080483791833+5.61434473275686489312103179397*%i
1.86850397470139357502436363277-.735011320175895770812243126340*%i
18.3798373898493388533132185928+8.40356463123751035022298219125*%i
166.680332283250630805944066571-110.778258027694235076500672159*%i
-1642.25096551073085838363102214-1973.70527512717796761802326779*%i
13429.1687565063523431276327206+29649.1079704937895513571679486*%i
-132180.870513582580928778770077+17916.5721758243590629801588696*%i
-3105.04429118696143089997744216-49835.0091020019087849506479047*%i
453.759364040854606458557860702+4330.65023065039778873241686590*%i
301.304536525792204234447611252-127.681140836562126146232426658*%i
1.63684172449459573256609848210-31.2328359069443062187187621247*%i
-2.36944941772536395853454074119-3.07037079834986734189070199040*%i
-35.3750310864896037474511084507+14.6341337090559693866797165266*%i
-322.301906480093434201468000578+485.414323503408303777963547624*%i
9586.66634543268483027624564417+16007.1221050590839235630159262*%i
-84128.2447440756283065211319333-1949516.97239754242220240219544*%i
-139239805.294864488169737512173-63646436.3944236476135166417249*%i
1502686.76272397632434342930553+5492201.67576130944803803184741*%i
-15234.5586507846659093875117678-39603.3314311829867472536644078*%i
-1078.57311481081744567658371167+113.876504705761586516456575634*%i
-45.3508152830836814709170763549+44.0061104198323092636062044609*%i
-2.42192986777229769597018130639+5.56918901502986495443652214383*%i
2.69840251650901657299911303808+46.8344102899794026114591371944*%i
-10.7343642794660543434702879950+837.114775445161766913109599845*%i
-6246.69653845324389534042221412+40069.9771436953425377036855961*%i
-11442388.6099828962489749638763+18148224.9368709920151883381179*%i
-6673515025006272.56165998894492+4842666942292770.36011307632795*%i
70481773.9576852581414337866740-128019153.512148205214375299772*%i
94124.8668561107355788717339958-53355.7535799364624301653677489*%i
1543.47731546190357687122424474-558.622539489106602052719763108*%i
76.3939879723014632361323947088-20.9458178462868767211859361749*%i
6.80575417367893140288234316577-1.53758928235454637757494995110*%i
-22.1271646771905025453180527112-26.7397703784053861394027002219*%i
4.85626296536545080840602267741-491.410959674130756854936010049*%i
12785.8351226429097368445650661-3425.22500638282854010641943711*%i
-703504.773205801826388152427532+439079.279332624361215726717297*%i
-22369101.2429488409674689857339+5369681.80787068566434721863223*%i
-1287119.24716230504059801521029-1527180.13908895349697731705864*%i
12213.7329531283489080727919021+25541.6019918450413552976348791*%i
-776.108010163650075657771344080+443.773518304843839630161113751*%i
-54.7186688336676015617912791560-14.8566235395635224540027485113*%i
-4.22442593105257898636496674454-3.79178677325743880572623448363*%i
17.1430645788562485599519995165-.761246683011510907028424441737e-1*%i
75.3637332971140417857920811633+134.504876685553333559620550946*%i
-1549.68745362367649286599607419+604.894122627139444293722317859*%i
11918.8945833584845687094731468-10586.3838817896832749962726317*%i
-51495.1609949783812812484932073-9580.52062883668561174540484144*%i
6984.47643949870018450820232640+21914.5480429163126027851570983*%i
-1042.31866271159479295998939907-2479.38224720648374390145525513*%i
244.563391191542485192837583586-20.0690441463753062150112922446*%i
12.2184085526289046081552075453+23.0952415666261088736058929044*%i
-.909735079002785978589728908371+3.32233122495634516267478527210*%i
-2.23773089624148605954031564846+6.40807699348015066087180655145*%i
-38.8434236900121530698522461448+2.79485590528202498570216357486*%i
2.14372599552989877467742630255-208.261569199576732691719739308*%i
611.517668991329784569744023356+516.665881566682653062195605843*%i
-1381.17906263260312210321437089-484.688517846272642211754129745*%i
971.326885046319665926422595665+30.3040291309137204313425619476*%i
-211.764073137342038903066969924+188.127576119248228619080673098*%i
-27.7861589845071390782275913459-47.5419811866339505095265296688*%i
6.36112430005142548176592792250-7.22897800254617054389670103808*%i
1.73280991099462964653911893268+.583932809310619236370860601547e-1*%i
-2.46683971362393771315464585582-.819066487649210129238527949490*%i
-1.22771629415818430084254164484-10.1659049557898394369076389713*%i
33.9463286874275196206723143990-8.65258448811303975420253524657*%i
3.19317697987020111521570001425+85.8950500908362819460816389321*%i
-114.138918835631295872178353224-50.9546665002760960250023597035*%i
76.2169079102298379815336943216-60.2095809055023314845788764421*%i
16.6664127909974372892424832935+39.9788153314695542951812781349*%i
-11.9874682672018556398688038136+5.85815367048743322649391650537*%i
-2.55553633307474837631104297381-2.24023784343323037036838842862*%i
.340791903612146110705351073027e-1-.805737179164287997832716151486*%i
.100272392870455505244020771113-.842911860168648120953953658168*%i
2.79752158029022714874087067574-1.49252825302687470676667293850*%i
6.24506015735025800486989469825+5.22625875692414650255487831834*%i
-7.93857921159191649860216337699+13.6716763202338850078465918957*%i
-18.4115384410830045553827764149-9.43551740084684989469490026081*%i
7.26215183276532233378963980508-15.6679928771181905159546452041*%i
9.14878567715824519362063288116+2.74779287904392665607866341468*%i
.132026386229701591707415514609+3.86134674522127060901494218416*%i
-1.07285174796263559224763114353+.689478199519984059964523767724*%i
-.362585433087196488475459181828-.979379925286095536893062788122e-1*%i
-.563356008596583326039140275316e-8-10422963.4262866887825088094427*%i
-.894591725291118000429567454256e-8-6677952.86176036652142700487731*%i
-.142333931697157160194543442483e-7-4271245.31119831196389863412140*%i
-.226925827723352351332001001235e-7-2726941.12502349659877100458260*%i
-.362581582219455472299795103677e-7-1737616.42420263851281884591293*%i
-.580674636394608343986839820280e-7-1104920.71055400838224303377100*%i
-.932243367255313652062923853603e-7-701042.452713738751677253727764*%i
-.150059915914486711810243788304e-6-443736.044074045324379652178845*%i
-.242222729910581670680371912863e-6-280154.133604194735451011428716*%i
-.392159440192993753300446348000e-6-176391.997044280159576383300732*%i
-.636940069236721455822967859117e-6-110733.692490508459476865238702*%i
-.103805841906451447746435144987e-5-69294.7436750310349974154460511*%i
-.169801412626774255673773673499e-5-43214.6331510784733241675996494*%i
-.278854079046679299656054122688e-5-26850.3783794888495703697671787*%i
-.459897666163969611047387690517e-5-16615.9491736331558338437737999*%i
-.761974147993197049577578660766e-5-10237.7985873107477690246798815*%i
-.126875087430897787571177001013e-4-6278.11985171723163425453837518*%i
-.212397783443120270962069535351e-4-3830.10079138481116283203359854*%i
-.357653364850480879536021191926e-4-2323.50019910931576385829400762*%i
-.606091822189431755921673337541e-4-1400.86604534490985136379097906*%i
-.103426275645059036785114289473e-3-838.904865316247209393220394583*%i
-.177837826346764018788781800466e-3-498.653301436019549678679357622*%i
-.308346977009356256373397251024e-3-293.983988083130639188150878731*%i
-.539563272156390323671432944237e-3-171.755884325863093915045428229*%i
-.953779420431168667983771504058e-3-99.3420612543728329076944965918*%i
-.170503119691134674177851455739e-2-56.8191414647590100421777468491*%i
-.308633469820934846440160523235e-2-32.0938418899300359636166178858*%i
-.566517316280139804372090814725e-2-17.8742351895559795130344665236*%i
-.105628061480109100364648119757e-1-9.79561760286050879629227700657*%i
-.200448790852387187957897728932e-1-5.26622268558062750783674627378*%i
-.388062471971414129767307409083e-1-2.75961726102909592625866974551*%i
-.768565176621687866386981687424e-1-1.38239109560384540858636209423*%i
-.156237814793422693170958754488-.609112871430184861149883176033*%i
-.327315184487669924090534082094-.114345776248777904657752997991*%i
-.710162438973656021319644759228+.350345368623862135852605223095*%i
-1.60548201799016780053269738592+1.09174645760141255950311015619*%i
-3.81091211310381675517622575697+2.73672083644145892242332253826*%i
-9.59100374325617786727285553798+6.95529938963006200946916909428*%i
-25.9192385484702961544310770933+18.8265468197084535405291246283*%i
-76.4968550106686716102031541337+55.5765378289123932608673203724*%i
-252.339643739392072251033319662+183.334965740750320429888951846*%i
-961.446424458256656523438814559+698.531578295623605530067347870*%i
-4442.91469137616127317590975626+3227.96644148707567998183197394*%i
-26893.8583758239622903921029462+19539.5318471670613898809939340*%i
-243314.305207128587668698054431+176778.190404495419749974856270*%i
-4248008.84639262679120973349710+3086359.08624720357322875589905*%i
-262574380.379500310951199626311+190771454.110363386063163154548*%i
-524971029324.858585967606801099+381413778775.259200078046408343*%i
76168378669435852.9881665518814
10643404893.1660561540972773042
42343499.2605808717685394370825
1344765.19948011767476063184873
107524.437652135724254653353715
14489.0656054563360105962960872
2727.61970615582142095559241451
647.229580435806367514356182391
181.852548837441256990188370997
58.0838485004527375310668827830
20.5061711597293370258993198046
7.84300367950316215932094715477
3.20181967508227496176942007605
1.37952903320773916627734149326
.621851573949463357896464383161
.291249975545026084517487623732
.140949589494312247407552934092
.701659845167458663452215440721e-1
.357971239368825712655328637056e-1
.186592608651140594205751289180e-1
.991168839100976071563871080410e-2
.535381386433312873347984187074e-2
.293519859659964349381093236976e-2
.163072837290212004272074492168e-2
.916857970161639155457803084717e-3
.521055861623125405021418157665e-3
.299006097362021745340876908153e-3
.173099963495965943680389456288e-3
.101015988855180961470548551050e-3
.593820170093793360968015745996e-4
.351416044555251176438710024411e-4
.209242564557736372836276711460e-4
.125292800064236847931372887582e-4
.754150632833385750446323421074e-5
.456114457617037737144174912414e-5
.277088384886726692465167578065e-5
.169025253889667464057418603115e-5
.103501581912530232325715426213e-5
.636047501560137722799879433963e-6
.392170347469096008526614042271e-6
.242553371159324540828668543042e-6
.150452778588295185516547575604e-6
.935780089196405015397779634925e-7
.583519058660876319734501863192e-7
.364734509194077521562882015962e-7
.228495414206853258730101264283e-7
.143449825897403900658882939214e-7
.902385093559173193325334405045e-8
.568727918529022303708394523230e-8
.359081406553026553388803068431e-8
.227099025058851966140625497515e-8
.143857604549447679131426840363e-8
-1.06572916289638493598316330198+1.68386910968762636980117297120*%i
4.08764611799301137817400708274+6.83499200690130014464103619347*%i
26.3237575691749875015897092304-10.3972427491042650688774350095*%i
-39.4392752221903719675234913907-60.5261005083483600891699727384*%i
-53.6879073148744288234207547879+92.8183727019974408951252195526*%i
82.1277950766657181752475498083+2.26126265079785874122098292341*%i
-8.39449616015010029688326505531-34.2685775253909183235039441344*%i
-10.3373222167796639408627724107+1.57202259967971827727828494084*%i
-.737803163028882874637241985822+2.48593495810121059415522777697*%i
.322157119196965716253259014590+.514730851820504808427589415512*%i
-4.17481439433909823041751361574-2.53143605661416958733715831483*%i
-24.5754389654789072190041526559+15.0934404273687565227411446910*%i
89.6158275810555511558145798641+136.784281637185060725920328794*%i
206.268140034028136854683826292-650.153323795582231438770178793*%i
-754.464984274623207654824173925+1072.82621428312202803253144770*%i
632.577669803981766635923767173-553.581651581067567325606916136*%i
-225.744157347420821519792335509-7.44880661097112896454683465541*%i
4.82136715470664396783065425571+40.8626383395841641868372225416*%i
6.71511217057871552827662963556+1.83371232713093637569710205916*%i
1.05472432433926412403034480649-.654795056683456673371848738636*%i
8.97188952124210848851635717580-7.14421521323007022163168868849*%i
-7.12714632563367305492371808421-104.788117460580441468500089309*%i
-1222.77835100243936559704988684+118.749684156501743585062499356*%i
13499.7320522149942482888262610+4193.11876726268058311776431746*%i
-38788.3550247680808662776754569+38729.6950448732349825938233426*%i
-10384.5370663147286223382046753-18627.5441766156779745031337853*%i
811.120635605033264344810183474+1874.65911005052808039557939261*%i
137.548808042184056995662189307-97.8182866670118742367038935690*%i
-1.93200002067441680613504745555-17.3755651679120421578944922474*%i
-1.63540800856521038349537756786-1.63925004357191565876170790024*%i
.432324010360818076100569104313e-2+21.0239719759506002621210425959*%i
155.574670670517987949801441620+245.621886657173545908760906125*%i
8145.54507661599624938352202042-559.825219330224888329463610280*%i
-607539.899706082620854262289387-366271.252965804319453577130000*%i
-45176236.1774380069909011698498+11251756.7631364139073506137946*%i
1084326.07705820534557718014733+1658903.21735151695670308048297*%i
-9236.65797787984615573313584218-15426.6903131424098277881163882*%i
-516.323569263781551766529437884+114.809675929912435570936010941*%i
-22.4540714839915576710656129662+25.6951612868239375625171572057*%i
-1.20597913990968730846120016056+3.33136474347583096332897818115*%i
-23.6929916634050247498021272355+9.47082724483448984086860958152*%i
-390.778070095450018052032704011+126.664353973704167737667924764*%i
-16877.9533716711318328055618499+3036.02846420719698674213244794*%i
-6885482.91675508347626042413137-1485061.19334703171610470494094*%i
-1133170467828464.79848402298650-368953459590693.957661932364167*%i
23072963.7819125122035795847528-37863652.8895832752282926024214*%i
38722.5286644247087480238022256-20912.4459219139629139960152437*%i
742.000916365180808336553663945-257.654296560432646147026043160*%i
40.9073620855642616630360620469-10.8071665583994771570819472242*%i
3.94866946342004759736370274842-.862764155000072787543685889638*%i
8.69553486639178860281262519892-17.0622620950591475565141580843*%i
224.475642821368006979452609008-103.471559157777414441217032233*%i
4062.91780115071213673409368369+4252.36422318510789824039519266*%i
-289510.999386983049932419304103-118306.237349367103373475343898*%i
-6890824.51349845224583923671428-3154506.59574300106355039130792*%i
-248643.494336963043756098132024-683073.554622832122745178273717*%i
2925.25328870626200434192758334+11857.1609581060467489115020398*%i
-408.089226342639937453075997173+164.272768221982320250761579884*%i
-28.7550501126259228031569527335-10.9784139244042879791008832706*%i
-2.29649056761318623331470331133-2.40189158684764148859312494681*%i
4.59957651551212970744984242392+8.65745783790796456750775213640*%i
-41.0628813533143953656060168235+70.9022926570513399675344406413*%i
-678.021005069183201499447485491-446.911788618591167890675890873*%i
7110.39647406745369024947561736+726.957129634883511412103565012*%i
-15103.9443110673964430031144761-16579.1868982102161262492859001*%i
-1541.73697310474636951567110005+10050.4628060342071436064001256*%i
-96.9024951046945570146019282935-1286.13597981025331352483673404*%i
126.825731587061118937776268806+19.4928062695872850334742154731*%i
4.48611284569410702273418111001+14.0377297408143572612042608387*%i
-.817131481210361477757739918324+1.90124011637482074570729425955*%i
-4.00350177325408347651832504925+.802982096918904770590631194477*%i
-13.8284232652237275360789692611-17.3208852484531956598470885229*%i
87.6892168864522223431221243772-70.1171769399466480320743635712*%i
38.5998338464583074813314508392+410.502755990962626995698370139*%i
-411.361994777839152065256541474-612.954057896491276393844918754*%i
427.034670353893109348164907488+254.569336676787553099507808328*%i
-142.696594847484782022050138263+49.8150461590327647319485622351*%i
-6.96835294881848478812566390076-30.2016807718391459389092648287*%i
4.68045848455172563483549780357-3.28293115448178328155380075416*%i
1.05361737750446370582245407946+.239878838389601848443218913139*%i
-.493099767049111969460887741152-1.54955419938124012911357982559*%i
4.50741771619491417730787577223-4.31603160267522970370222246543*%i
17.1422096455300814534428148620+11.6326961278832701125235410562*%i
-32.3963961803123836485029837620+37.5350476550945586142260133449*%i
-34.9262420984197287909721739414-62.2436798187652717919030968661*%i
55.2976109985378205912576944273-7.79136029213015987192585699676*%i
-.859323268924878749293364840359+25.4451181166788982969764459849*%i
-8.04647358337503864959265356266+.876665793437442054557481846957*%i
-1.15301125152288096431172661714-1.79726198059080473603463047363*%i
.141001973729794612248585054122-.505343350007575179673710387786*%i
.536754755442421288687763760996-.962722422049615611063517289314e-1*%i
1.95762207000688508535804227702+.849603377338972073063589400896*%i
.279079448215878139589979115046+5.21716250690014709356198688580*%i
-9.59545795600984481262890433118+3.03591534861608847004236065802*%i
-5.82145217239176461515253435408-11.7776364330483452325417262299*%i
9.07366878874146809239279177094-6.18438694508202079809863763186*%i
4.52311890539530772918065875284+4.13401404017303749012909308233*%i
-.835076267977029207113798906374+2.37577767479981510603335448625*%i
-.819608259272140413381419711099+.219806293821734082383839082443*%i
-.221610455159498069478541107266-.127487311475537716876723066202*%i
-.473328361215495447337866571907e-8-12502069.3360975922529525809334*%i
-.749055291729860620159825522223e-8-8039777.28387263234944386165155*%i
-.118754015672827763595452641472e-7-5162138.54045197360308097966342*%i
-.188630821567872804426387645013e-7-3308976.40621174619841158137956*%i
-.300232452820435265224320496227e-7-2117322.36341456544830402834907*%i
-.478892683868409046664101811193e-7-1352247.42401790077215136596617*%i
-.765621365368536825510544140221e-7-861872.315973922901149776900792*%i
-.122701559717571390933314995156e-6-548130.074669417265216354232738*%i
-.197159209847151303570164850570e-6-347783.203553160124593190344413*%i
-.317681736054019499657705941113e-6-220110.864619937304481529908116*%i
-.513405035989890546691897340719e-6-138930.750325940883370132927170*%i
-.832364097554025186700135141519e-6-87435.3389579880702208959140037*%i
-.135410913929752587886570231971e-5-54853.6501923926376680546840638*%i
-.221102260484778544188005486793e-5-34295.8431658366933786121381712*%i
-.362456236199863124476140713871e-5-21363.3937601762153200930313342*%i
-.596729795769155638050352910700e-5-13254.1985487085830616951345325*%i
-.986987101874372684510357575003e-5-8187.23384257284613240991142222*%i
-.164068715980277009799152101822e-4-5033.26281102780142895932698485*%i
-.274226319371851168352735866393e-4-3078.21166689068911879508289039*%i
-.461076015812971183246036534769e-4-1871.83735587452288819374668196*%i
-.780284359889654376631856295220e-4-1131.13834561020080331184305927*%i
-.132989465863170692684220251337e-3-678.839658279893222392980429948*%i
-.228437579536278411946247425747e-3-404.307684607293795394611738286*%i
-.395773559510980783411055053868e-3-238.779491560222723649616472903*%i
-.692223023344705299367903636491e-3-139.707424805410606328113536889*%i
-.122352664508088809759860088119e-2-80.8944095547491742899440445602*%i
-.218808836876312653652298540179e-2-46.2984368845824918670498355098*%i
-.396458264828162235288169293498e-2-26.1554620893962719377957079637*%i
-.728964724327033426101351887050e-2-14.5627638474086154441621322035*%i
-.136271961696186468300150636539e-1-7.97929611502275641381944498301*%i
-.259572360150746533440939589807e-1-4.29984162274489345929726906256*%i
-.505131925610881251521487145772e-1-2.28712816415224345045518529995*%i
-.100743152007283773747566554912-1.22713669361693899334570332310*%i
-.206704034334176123891952559305-.725091644522063496192766831682*%i
-.438363470236523202601154135079-.595466639412164302449700384912*%i
-.966463781407959895061799409045-.830453577489451260275337785959*%i
-2.23131570734661422144535257629-1.67783505213354018643319015291*%i
-5.44495958093249460390801118410-3.97967647315633292440332971720*%i
-14.2147666653996977366881138906-10.3368704074670901849637707427*%i
-40.3457747127295559603078721376-29.3162318046437621807855703387*%i
-127.282947182057587485035872514-92.4775402476584583442099438733*%i
-460.567251877661601389813318976-334.621994336403919777816123737*%i
-2002.76959142497804644115979439-1455.09735156407336696738900938*%i
-11265.5099061502363598782660214-8184.87205899249433232261427717*%i
-92989.1411496785538860695073550-67560.5656894639325171645457958*%i
-1438166.97795730153127538413584-1044889.47185902754921201402124*%i
-74465903.2139250943365094428771-54102645.5712476679846615708863*%i
-107117965168.905329714733896787-77825757208.6066724322427154356*%i
9358423215437790.53950287015867
2595587036.62894449076748900264
13109336.7579189595259445002298
482440.303666305464226986575872
42901.3679393075068092646749094
6279.53751808823372406044054832
1264.46977168764783291327955834
317.463988163663903525711569299
93.6138357943666294856895187486
31.1833734477084339756051590227
11.4238137788686422181195094870
4.51521336860578890530328124826
1.89833122282335254102913430707
.839897519786685714435263863959
.387816298765451465330339516764
.185660443942077387686038896661
.916688322563772247348319027487e-1
.464813186750433875498328285722e-1
.241194054712467050007283394538e-1
.127709324821454817573649271953e-1
.688317163179981308966227145174e-2
.376852733601214156949009474768e-2
.209224538082915879986706818210e-2
.117614697692260198679425332819e-2
.668588605948380449578119953381e-3
.383901750977824518733691023871e-3
.222445224360547080688834361676e-3
.129956786138950525437429977041e-3
.764933281234236567838077279032e-4
.453326289027609410379302315201e-4
.270338416714776198258778669495e-4
.162139587164158787031301586938e-4
.977583966396098289559245638031e-5
.592274728391097808973164425737e-5
.360441926186815270944374044927e-5
.220264918403316031261773471821e-5
.135120863493474784205551751314e-5
.831855946437836914512295048023e-6
.513824816655638580946765342272e-6
.318365230258441799129355802677e-6
.197829401469982764613175848340e-6
.123262075603714524119165130879e-6
.769958368216598996442837281725e-7
.482098770051344731953825567710e-7
.302533353782638625438713246866e-7
.190248572460832337359776271147e-7
.119874668313425431551516170290e-7
.756732411764876619061277520315e-8
.478542913941912023956024737575e-8
.303124585987234871386544999894e-8
.192311069323896871441501079814e-8
.122189574127784158634170288602e-8
.429819549176077848935906906421+1.15090908358389027505934815604*%i
4.84590668152564655336034118524+.445860058691942849763328771430*%i
5.58444302024669683223229670471-15.8086041250978320504161556054*%i
-40.4690479984624561462442395854-9.82639087341478613135787990910*%i
7.05972091093358289436137063302+60.7175400410556142478095605367*%i
41.5005685240959888416723083371-22.4656171052594706841254921902*%i
-12.7313128048081096440351857569-16.3987908607477656470251043404*%i
-5.62720365018737453731285980758+2.97467225559099478034369706492*%i
-.310266829993481577044632307589e-1+1.63789065765776807742038400862*%i
.279273551668379495052756091123+.283224203330471500520546542412*%i
-2.59199761936684881016091570292+1.45188443978610525247477946060*%i
-.620187145730676255095901361863+16.4622096609811089616243671720*%i
87.7125609076045197883352400058+8.08114013672440817454978833301*%i
-160.401371416805622316362422813-310.218126226575277869211224038*%i
19.8211823380283463255737153042+655.337400397728910404420955229*%i
147.702221147425460420064205085-400.779475400631767729351848757*%i
-113.209608831721284318894155390+40.6928786257286142867033852859*%i
9.16989881380913652059109965294+21.3376313997388308604956663734*%i
4.15367001530645921222020489912+.175533229646009846779719926258*%i
.579094833133009024407212417092-.522209025402545811347320458464*%i
-1.32627672307545555008876576681-6.47660400644642843881925635379*%i
-50.5166732737384546480544285320-24.3595484475839004246950129257*%i
-286.582178205435208521162253239+525.523052096888616746635469664*%i
5352.73630858520486041685467653-3236.53111704019175613386851619*%i
-3116.26644623331019949204149837+22742.3423572263828036191803343*%i
-7573.31514966387868596127119233-5365.83009253131354558317386096*%i
637.035658804724510654997191544+739.236866458770839833056051400*%i
59.5193728803702276225025984525-65.6243680727844595476325948072*%i
-2.67208039297188651344798605868-9.57076415247534312932219312862*%i
-1.10841172253531685779171407968-.862457875350957366472583386622*%i
10.8456315877836273147367442293+4.46406467957901789334241126250*%i
146.041929878846102958620549306-21.3574820371282971186716692713*%i
1422.66906391503243007145034660-3347.43709175912834135263320220*%i
-237328.266860317639418991778366+112568.883471571117077704073681*%i
-8771919.50596155629704006943636+11447551.0075319103115815298164*%i
546203.336007648216970517055406+441909.710657998509796530370264*%i
-5064.09741037083381799368887592-5876.19880236792983046266943224*%i
-248.153128810936365894014219129+85.4944490059126300008877199199*%i
-11.1377655975816290160147577094+15.0644181658853557151472635314*%i
-.590770991639040971558559544674+2.01484787655090822200674727264*%i
-9.12725004760139974011259513642-10.7702713657976253408303732200*%i
-122.400609098481305778537574514-164.517529589953990545397219610*%i
-3607.11969840455790632397218697-6440.33113686951583414066455105*%i
-323176.379334207791779782133937-2332812.89866495360746526484975*%i
-54105590086133.7410793732538449-166883807730822.463156174726352*%i
7637105.72865268531410763001724-11375075.1387447648151192941755*%i
16208.3943050839651315020247692-8329.61353586067798467877242054*%i
362.844551569877238774024834823-120.743249961246326037380982740*%i
22.2677872428411846219689395040-5.66324324855239423511792040029*%i
2.32713320144874286865251027751-.491433643483350292038012403157*%i
10.7190980671692607192644379367+.699503535004395727694366419246*%i
96.9112738896623606791723669558+81.2752206317027917703027452942*%i
-806.291673604797137449816819995+2535.24260768630576751365904847*%i
-28159.8656424229351074276062554-116788.108310121299331206664326*%i
-1166716.07173170692262375001068-2260020.92154131010783458508647*%i
489.489122642748221315049904212-269492.201956264216539846594293*%i
205.252048198351408090617509012+5359.92967883001037008728481356*%i
-213.583655727644905710730391624+53.7946867372711866327578500665*%i
-15.1963447151823534997748454683-7.59386462523669589808583451482*%i
-1.25419447001130853676427934025-1.52721178101725659453337363356*%i
-3.20159020265544201968281335283+4.69308635260286039129775008717*%i
-44.3049317626791069075335453929+.377665107632241988800827083069*%i
-12.8529632341265677158783769139-403.490320465420998876901987036*%i
1950.21306462280679324826016198+2619.14416375147814925313571047*%i
-887.681852290571625810133141640-9747.54442827619943420498836765*%i
-2633.00370036983192632304169499+3748.43019542517064206333784439*%i
153.655425976160557712948432718-610.951249399623315988527376020*%i
63.2806299791634977862152610983+25.6676226577668155595015276351*%i
1.12734316018335800761653561996+8.37662703135726415637805993261*%i
-.652294672961893669802423610283+1.08147012868228428523072447579*%i
-1.69165264976002843723275673130-1.89464603325374833173372905258*%i
3.75801110582127628731249499562-12.2739926717554304435614292296*%i
60.2703947259440852165970591126+13.0745811128121010737541341254*%i
-136.681333629687202175580168480+167.977329154090644359115101571*%i
19.4646472502870715738790030138-379.305275705542151534294262540*%i
130.668647604193240255620253370+224.092012311771091955493145309*%i
-82.0759641782590001353094832063-4.32590303193577903648244166417*%i
1.29346793687433243906990097394-17.7146785643957551919381696529*%i
3.20957640598121295410618337953-1.27055325797110164861985773517*%i
.627133987167174670277836778917+.273475277031340614570547745670*%i
.542746063962471693341585065572-.779138512781557842204713234836*%i
3.81704534193004340462581675952+.669459287998669468220012071425*%i
1.57015445464077790375222927940+12.3973409834350540983631501161*%i
-29.0345827602663127808249380145+3.12716110387309691606537389671*%i
5.33448113055667049176075949486-41.3049064871169416076797808342*%i
30.3689200432933263822886165555+12.3698450554343401833184672388*%i
-6.76772342464810478295006764964+13.6817853690190435770564351603*%i
-4.86505447187809996305913191940-1.15841806466719253033607502944*%i
-.395065993681669199527378108578-1.30615429692092399245724087715*%i
.165619210353099513616418452193-.304599490961431705807589390788*%i
.239915809868132848603043104886+.529516422127488465007891050751*%i
.425764083641130869582126881310+1.44221697125077427267694328315*%i
-2.36509340708778392945961744151+2.43972319922493783303668650712*%i
-5.94068987390535238420842455869-2.77869582540440218447005321581*%i
1.52332602526641622381179994325-8.41822560357438876596972295831*%i
7.13119227190137365328208072116-.451631078760406370067206907404*%i
1.51296687308423825144315887316+3.71683659854399803295785488349*%i
-1.08336898340093951756676917295+1.27383004063706687659772503941*%i
-.573753008841001814933902228490-.239794691755601192004873260445e-1*%i
-.126260806493159338152426610300-.123693433234580846230749313520*%i
.153021617414880665143768343594e-8-14882876.1899069199480162247728*%i
.241362533161122094695051363369e-8-9605079.95744770501250864777680*%i
.381340831037260107929933812721e-8-6190152.09803528076278123109786*%i
.603568591573298579955585630125e-8-3983331.66693790239275454553467*%i
.957099079245014544481699543370e-8-2559124.31921433671664031784118*%i
.152074063521844919490455116985e-7-1641296.26586636897495945008724*%i
.242145737721731255430684999322e-7-1050702.31866790855238261743496*%i
.386440162120813825744751406736e-7-671291.184246622138775275273372*%i
.618211652278417029328408875842e-7-427973.222272419650337113584916*%i
.991547302601607197702779484472e-7-272223.909945445823097172581437*%i
.159473894293008286268761841602e-6-172727.935752681804600144199752*%i
.257247912853735188093477351943e-6-109305.071520404735572226333540*%i
.416289005619047326403842836010e-6-68970.8180106549754658898602678*%i
.675963409891991936719657182937e-6-43384.4103962933220819651048291*%i
.110167075706633068059843351825e-5-27197.5564270309914395617285893*%i
.180263747436212951792099049767e-5-16987.3520549889102973183607653*%i
.296233719907067270817632634445e-5-10567.6448556221664962197708779*%i
.489088792448139754320100580956e-5-6545.27393431737845488574164751*%i
.811603662700238057365583453232e-5-4034.55584732428637065713216754*%i
.135425485945158706474636363660e-4-2473.89373244204120998155149300*%i
.227341300887886486245060200935e-4-1508.19460917627995245149229493*%i
.384173577645300697384322117386e-4-913.626828551116980585583303542*%i
.653928803389313131929948879569e-4-549.572646884663100881202159465*%i
.112204025521444208604680368322e-3-328.016496239308949754690267639*%i
.194235216628561195418423195290e-3-194.089926918318924146794212628*%i
.339554422152371492564077885366e-3-113.740285240873981262183242943*%i
.600118525731608233992552633826e-3-65.9375701401455693306668653479*%i
.107367302322843831668206312570e-2-37.7651287231854053859587884429*%i
.194745901373340814269227182827e-2-21.3379628996153919748955432972*%i
.358750720955001798700358215952e-2-11.8758926453636442307974822377*%i
.672591088914539231634869721854e-2-6.50423714175659110251640609525*%i
.128653381267180288288478291933e-1-3.51150641732329150491733569479*%i
.251823888586178733980233482933e-1-1.89385624648226458773185856344*%i
.506228132346852231948528885294e-1-1.08070378846395216299360718873*%i
.104976017678925507510910757165-.779421965073189808950278741914*%i
.225793006673846040239736926607-.911859461194750853473956328236*%i
.507228403698969671465210484941-1.65976152395671104532392575464*%i
1.20060468529847065037203459881-3.73763818670521851680355173714*%i
3.02895859413622147988853106733-9.33937860176146242158806247473*%i
8.27075386646154564624333074738-25.4611801017917702081712018545*%i
24.9630099169932981319292418691-76.8304073100107861067107902227*%i
85.8110151129464519825507860736-264.099787476383750973372425471*%i
351.240100450175036472809711458-1081.00603301997364263122473627*%i
1836.42054975749332008626302622-5651.92132395249895536982491024*%i
13833.0071431336054347410934087-42573.6183581571355141836192543*%i
189552.496961904561191000802475-583382.599330417952445095691516*%i
8222683.68049696349778557768650-25306818.1948651328297698003750*%i
8510823646.18077040845827014871-26193621823.6524208147644351493*%i
1172182256009233.00414436475530
645263968.665517445672124738354
4136945.19502524044898806938954
176392.962542319279840014452882
17441.7555234675691350092702838
2772.46408192565278442799008365
596.985618757294649470623514299
158.535935328248004609877931828
49.0471037864487072130441123352
17.0329821872295442476886356053
6.47259885632643237806758588480
2.64272709138587671714634271425
1.14382658751191058206246346591
.519480184886376015293441280580
.245610706553123375334901512449
.120140941351852909135218322676
.604973522938641155197297894029e-1
.312340790176958774063679481737e-1
.164789183963639368965340209969e-1
.886019984618084161149211237742e-2
.484368117588377313631926606144e-2
.268709888316888350434477270872e-2
.151026561337619072283025638308e-2
.858763615123717320176540483801e-3
.493422427984572879540893168626e-3
.286176693121057348603069520981e-3
.167387946775254802505634359143e-3
.986604158911022233407068739405e-4
.585581113279186080730780757609e-4
.349775203849589528691914199628e-4
.210141616143790080354355355000e-4
.126924637217473641487926910431e-4
.770376793790281861977489625975e-5
.469695362954993162638797833769e-5
.287564234811206803952878938718e-5
.176735498106504126930833082531e-5
.109008679832624257948204427993e-5
.674584668863766182562115755716e-6
.418745325322022557449260254226e-6
.260681819828928278242679512339e-6
.162718165771777197363422454763e-6
.101824043033513465058316075042e-6
.638681832700399728014693228804e-7
.401490634469725770073324323116e-7
.252909294622548126544003469239e-7
.159624380035416731754532456990e-7
.100932136944000959391876977011e-7
.639307900226579116058608533637e-8
.405600999342478843141643087358e-8
.257725508485019826306600377888e-8
.164002010499328670456043522076e-8
.104505905040771365960694087358e-8
.617937071710838427206226170307+.208258088624833001029942199208*%i
1.97523603519878400691329184354-2.30739123200593256321877404719*%i
-5.02278262343922243400597722082-8.80868791309323384211033281093*%i
-21.2981288866400628663115760827+12.1773815529205129218543687786*%i
24.4590470509882905375932813348+25.9347453780609473200399478433*%i
14.5544712100969738366739559280-23.5809466932552053325246589717*%i
-10.9786373801302061116709093418-5.91382737147387529291273934948*%i
-2.70075582119995184660707932889+2.88086501707056826868625780529*%i
.256957586591896510768184307847+1.02133037388700649773056690917*%i
.221866799716431779601060580407+.144517755802627073459935990631*%i
-.149209701323830737203017842737e-1+1.89924187492909642285615719803*%i
7.77146766136983586939890790256+5.60099328005043162113549345135*%i
33.3829323376042523458153730788-35.0199521121308945307849562816*%i
-173.927737785438202806662961535-55.2956317715567387701550769144*%i
208.746898317332159152267523464+261.593170121364053408456901695*%i
-31.9194153571541180409109061362-219.243001474358485947572749626*%i
-49.0870409955176961442323848677+43.1425547969913100385706089262*%i
8.51850967460287710037934063652+10.2855071836194228559100966675*%i
2.48606643915144720251051992759-.450450629694306831194406062803*%i
.305882651931266304061887160758-.392755424210780559804403278908*%i
-3.70755030931243324006060008231-1.02236655240884125494860184692*%i
-25.0622559650851126596736300284+17.3683207990609871347933503491*%i
136.408380490626967296149736387+264.089907069451898719329083026*%i
508.732642318307311562810584458-2776.55055822069234225870389304*%i
4820.34085623888503800242471355+8539.80812789369522671982355043*%i
-4059.61388288201283555212441385-702.061144608106769828298474683*%i
403.180231256137996734056313142+251.540925216232960459579773533*%i
23.6255389603880213079948354917-41.0478430748139641853723504461*%i
-2.40601273921602181919659236097-5.21837426457518049890729679095*%i
-.743595886514259361198684581533-.443451652738214418530628414544*%i
4.67171326673757171059688921858-4.74765434603354462201800552176*%i
20.5993363414277976953174181716-73.4463930329614455884475064941*%i
-1062.21777288258983023121316510-1263.66461148559242905795365342*%i
-14046.0131662088534798803443237+98143.0553210991476964855906211*%i
86833.1425037067388877719358596+4554233.75753964748405376784563*%i
236832.987790576448252552327797+91555.3552554687948986757241161*%i
-2633.91045877654624000022695166-2165.96858285983314376573525868*%i
-119.753395501211218444366600298+56.9736470835664209502570068929*%i
-5.52207673511965290427490962718+8.88839953268361454498069867745*%i
-.280863486158741968665367838158+1.23315541559982016126213037701*%i
4.10550561794630371528034631612-6.80591485383999905186917975024*%i
59.2666827030690251855437144595-85.7045961613172335309358946929*%i
2153.16077811460168807626119124-2416.98845388451771396376966850*%i
709003.808726046287386377479309-376089.383441302599577834461973*%i
15489855043849.9964116769731052-21289691157758.2483337668846530*%i
2560548.00072349611054286853480-3473623.33985790306544268336577*%i
6908.57704445897669174622950405-3373.95440287999664068158166460*%i
180.618664790734731394719487623-57.5278141313744387860130519911*%i
12.3298512026104983768310170014-3.01591625121976209290104305696*%i
1.39385885987299992984301443702-.284311800242417522373955255815*%i
2.04205233092158935989297411738+5.79991970850295564677021493976*%i
-16.7965462413122682582239613937+63.7165384244252080726463059185*%i
-1203.66629303389233562898995892+233.531067099936425914509127282*%i
30666.8712465380085436275340131-35674.0327846713976709756460529*%i
163020.971743369198987768115251-854960.183171787888423807891036*%i
35155.8565811545181956167279700-95599.2202723194857480307584988*%i
-393.532809019035192745711665967+2368.13518298469482844962012154*%i
-111.590511914479798129089577421+12.5106838639248071927244479060*%i
-8.07614826181443369095094802463-5.07617207040505725787274945191*%i
-.687384629297570971404712545951-.976883986042403702911147942042*%i
-3.29257833710674662617702666239-.403174874066228548158517374208*%i
-12.5450571208788350978385964180-20.9282025194130348275206528170*%i
163.453740423826675873293223144-122.975895248401504923602445667*%i
-286.933405339611944562775380176+1494.37235383723604564231057792*%i
2305.10000558697724334057541623-3698.69435353994640362906935251*%i
-1848.35622873065250505263937862+1007.40434819728179149099893735*%i
168.379764611198990877362758354-264.654660226905854026430337908*%i
30.2024258056736690093909118539+21.3983424059227588958333942832*%i
-.196203463948520118852529750736+4.92826536197957750309984886760*%i
-.491106321691325990671314339549+.610387019174253437999581161579*%i
.461688483012408691143641633199-1.58965161599275574178188962805*%i
7.22043336155053819970732356207-2.23970262125426574716848162437*%i
15.5402654306227283597124375967+30.8581935407583846739376621059*%i
-115.425992346250573045811296609+12.6853210467337022287642863458*%i
127.629526206577077807367103286-153.458037435180041760289989242*%i
3.29648209107287818581106856055+138.164809863123893508544005183*%i
-41.2710317603446283965588486296-19.3733757312894050252845755892*%i
3.74679809783628716959682688867-9.66978682585743006123548872546*%i
2.09853719582682377320562288358-.307074355208112041121571873790*%i
.364498197955730396265270734509+.246942369493824620949995885469*%i
.428528591654216491825598627913+.222675537051960235624956944221e-1*%i
1.06467355962334436003279640356+2.23897007391148791676320815636*%i
-5.10220286297116162872635266079+5.76014604499453091849936134220*%i
-14.0274332648655285309905741992-10.6002193661281124246450230266*%i
17.2894933169140426317639203448-17.8860486327750832082588942167*%i
12.0664063271713638905582513948+15.5624296317504044144138290372*%i
-7.20874499383664868759051098587+5.94431330868234344285061764174*%i
-2.64853355209465438489159164552-1.70405532250374494331358521403*%i
-.190516945803586903693994752501e-1-.887222209770820612604605841263*%i
.153469311156094902446143143792-.175116475936399746705773094492*%i
-.352832235218620504933647363930+.717068756466211104362527466185*%i
-.539998119547751574980123886475+.958609872737591206041764974515*%i
-2.21946676057723798634492598413-.661831561900635922938825645156e-1*%i
-1.63215756709264712627773205816-4.07449735177055255454432681364*%i
4.17418151991827025825078338457-3.92248430305260924088707204152*%i
4.25518913864062918466337504705+2.14628152671759529831200350035*%i
-.137452163495362408979537079808+2.68195140437886051215523501453*%i
-.990391193239487975296279410022+.548104960334109574694218266064*%i
-.372826705700955276755170725975-.131692607858403016784838170278*%i
-.647003291805428337103499373777e-1-.105953084870777922811683844759*%i
.422224902542648347367200502333e-8-17582425.2050698898670190617652*%i
.663871643490071221580343644090e-8-11386372.9695375583276894025550*%i
.104543255601965399625491210501e-7-7364428.49946070863693029909558*%i
.164899660097516204681111595539e-7-4756658.46825164320369155578595*%i
.260554679825655859418184046715e-7-3067842.59374472859260539505355*%i
.412458818314996847021040226056e-7-1975547.82749917462860890121728*%i
.654208535970358020301372382252e-7-1270037.21970342205109506259818*%i
.103982809988525372439233473361e-6-815016.149965283539036507618759*%i
.165644682631804387696291470903e-6-522009.174102992150269053854993*%i
.264502975376907007438547031090e-6-333647.390930760210518049610630*%i
.423441618435116530178375431930e-6-212776.693497664079993165990579*%i
.679745439743581329295245543528e-6-135365.774152299399688216035583*%i
.109440143856414092971467533987e-5-85892.5974395456246484241202618*%i
.176758929684485188305133753997e-5-54346.1674600697603588462513567*%i
.286462198952510215121272486560e-5-34280.1075703999205397398610435*%i
.465964594535483727686607912858e-5-21550.4961011509149764003564781*%i
.760973667741345205747422431315e-5-13498.4013035852786245417763796*%i
.124814163667935197873989922674e-4-8421.12027742102371749084330613*%i
.205683379821721781324922467562e-4-5230.63542067620345316331414279*%i
.340689613421814248987858401374e-4-3233.32969510458586244961925022*%i
.567477989607180220360419648413e-4-1988.13795837899746212473376447*%i
.951047288899034651458275570454e-4-1215.36385692644419185406764544*%i
.160465453121900697343022435897e-3-738.175003251159287223783642111*%i
.272763887035636167222677931298e-3-445.141030901426483309590294783*%i
.467476989561415810745145470116e-3-266.298457576017227051498256124*%i
.808526582965853832965739748632e-3-157.894527183928825552528371421*%i
.141267394769091487788684139651e-2-92.6882629325662690494288288434*%i
.249648121364038281659253276329e-2-53.8019747578035538629183171865*%i
.446854357713109452239200462408e-2-30.8356613685359601585697285611*%i
.811473238155026933080571442270e-2-17.4198856666741326051401432078*%i
.149797021607607647084107424558e-1-9.68042476581249391577669484488*%i
.281751335172245758233048326264e-1-5.27901935276871345895671326824*%i
.541477030218492682572538877399e-1-2.81685826709329026527780090461*%i
.106689693034015064050051520362-1.46557351521726962890121570490*%i
.216423761389481841024695732518-.740318578887859496065088409179*%i
.454335748625513634563055704703-.361153472257902084727684050124*%i
.993507195401877211032610811613-.169017359424078549720000259763*%i
2.28198723799442243290798135534-.752388315304892543759411276948e-1*%i
5.56589935237367974195204718330-.315077335805632180007817758490e-1*%i
14.6270495088098472385739976782-.122308703165384730850811914878e-1*%i
42.2530011134798730243333729418-.431318888956505473393580231831e-2*%i
138.034134106335840137495305974-.134278212826243153380821119441e-2*%i
532.007156133702477341063402478-.353686175707766043989960455941e-3*%i
2586.21416940349307444819423698-.737119457504971304175595361718e-4*%i
17782.1176635859507020199343792-.108375261188188185563040414646e-4*%i
215934.108562386076182328103933-.900073654058872796515239645306e-6*%i
7848833.45422028977768352748998-.249112935814302181396920682182e-7*%i
5845920246.32534864357881559657-.335601861742090452754605989591e-10*%i
149821726836882.421314130619380
163683808.124481855947625692704
1331976.36176299602607119708084
65790.2316003976567282332740498
7231.90141592668937505571286846
1248.03598021230939833431449858
287.279063021190333249137006859
80.6664323235964264049916809023
26.1730517431490571545093439835
9.47225355071426895451941861594
3.73218259510816920785694901776
1.57347959783147469857627498213
.700809258595929986761887004860
.326572791150886808540683395867
.158035722550224747402609985414
.789533254069023392500628740039e-1
.405306193667105578701058621802e-1
.212980427465290697404439985736e-1
.114204859407694046423558465068e-1
.623298526601732785024029110062e-2
.345491305618227194567810374091e-2
.194141492472913780613471407700e-2
.110425685145917163528288902833e-2
.634921776036992908871337307746e-3
.368618358889418698323642598068e-3
.215881396759469465043995564247e-3
.127428212687984613988888424238e-3
.757539894348983303518772408898e-4
.453264831304453152253733786421e-4
.272807241479683141627729574146e-4
.165080852577349776050233593378e-4
.100387306134986562035168941118e-4
.613236383630720080493309828292e-5
.376173593046176801961719809025e-5
.231643632001865976574466438712e-5
.143152381780254578602440296175e-5
.887584647154124070200396111286e-6
.552016023085316736119992245825e-6
.344295691239442406596264455130e-6
.215310538763983595056124564578e-6
.134982081089310502880976108966e-6
.848191923223440733851785833382e-7
.534140328283851445974100530906e-7
.337055357185181992454587649970e-7
.213097299137332466506079464292e-7
.134969626378450682280091069418e-7
.856307952313580555719137324237e-8
.544148834019841754669068918203e-8
.346306283689761120448313217949e-8
.220710005706444817755693389138e-8
.140854042491529878783106017444e-8
.900059672977484715239739672293e-9
.106440983371705874639394541742-.145704544872974771167655306879*%i
-.522008202015466667653209828271-1.90482849962166631676136159322*%i
-6.14878260945101209699489658964-1.20253258367022422473788846326*%i
-4.23486564280838604949265925579+14.1699526568327110658463041353*%i
20.9866454562358536907772621335+3.69048268887692608816987994751*%i
.564831842567435129290241108169-16.6498230494252441874829824442*%i
-7.62848349470720062493471187318-.623940322013609575009561144239*%i
-1.03334945922295051160710044679+2.27491955661425815488176769722*%i
.334866866277754612143733777609+.602573972107310146778697326446*%i
.167293223699671008464266927224+.642590678459687315121604668889e-1*%i
1.06863297401798873049384506544+.717865505675774469824704495596*%i
5.29416151666828696754593739846-1.99970105073471231402441508592*%i
-3.85153764319592353632449015284-26.8519658771987043158209341525*%i
-86.4653711252109381214792327123+44.9702261616121262474849676924*%i
169.074564515798290937808486414+43.8659675626730573515213429347*%i
-70.2246345211493482820914028788-94.1502388895709539195112681736*%i
-16.6163683671904647805201465041+32.2113154878661834307972222537*%i
6.47868390624384297216572406741+4.39717950407107279289430612086*%i
1.44147552118003832671792988196-.605218057756729856728045610593*%i
.151969090615075865276555831575-.285215868989315722478774414241*%i
-1.47786145488078923906514059302+1.67612666322360453978788801718*%i
1.56547125494107862176631293029+16.8257484343467323968827752851*%i
149.541744831826958011857661132+17.5002797484015321100596113656*%i
-802.882563470545748775805883459-1022.98163688337347922771726715*%i
3929.04752667968715518675071152+1692.69435704572974361387432902*%i
-1797.85809450998152338867341982+503.741635487498280877418326846*%i
228.320881654697404537964414375+60.1234098291160060229857918969*%i
7.86389811013390192629574195582-24.5782022578384558536048112117*%i
-1.88168407058409863911469708501-2.81162228632994093614996965556*%i
-.496426697198103270921151130636-.219461460494473790129447626456*%i
-1.54583476564739080328897130826-3.56608836039663929922623168348*%i
-30.9460966209874185070161540577-25.6096530338232685689338788556*%i
-743.940249965016897823449333138+173.986849207943455416596218406*%i
28533.3738530657141353578337342+25371.5637953934444029278081409*%i
936903.355534963505505736748197+1130568.89308588163771407441475*%i
93482.8967802966811570402011603+5414.29319597234873998554969263*%i
-1328.65299159486269503781194301-756.421571125889647182055252744*%i
-58.0121797300971338541423614462+36.0111302638000480696258604937*%i
-2.72686466408196840369237489263+5.28827900086671226538557223125*%i
-.126179879053999506674538441457+.764383019000181855944300447103*%i
4.42077360754716315578778292141+.962028197593789761050602002140*%i
51.8568330144290500914584815927+14.8523962963823664152565082592*%i
1335.68268994400311070337211160+557.323644737710515442151388510*%i
207352.304761615363531620085260+186716.909111860661950823618051*%i
4031998800000.12499998263894205+2879999600.00004166665422931534*%i
871064.118262462569689459702920-1079064.06508649974307388223801*%i
3001.20752370633930766254386458-1390.82388756519353934100587511*%i
91.5943704493304572661904346591-27.8862045098107032180995219650*%i
6.94917618831657924493707961371-1.63326343311244462005826077234*%i
.848958904394596897778160350558-.167160799869746537736354900423*%i
-2.64880956680036964469599429891+2.45732523799458748610228454991*%i
-34.4012673792884927384189130340+6.31192136400456874249287767988*%i
-366.977080652510202057934766138-444.302098388306783773952623416*%i
18727.7407041222083801536504231+1622.38414496106683732048978964*%i
229079.089012226225776827303536-199852.357843701365348683111025*%i
25387.4336843540549832001238450-29984.1953938326572406567562380*%i
-393.054191895973134220677495172+1022.88752882214205108924018140*%i
-58.3234303825700478158254102453-1.30941994161585494203333625514*%i
-4.31517756064357009562450748690-3.33346370450511413000768245925*%i
-.377452873060035468804344895360-.629780186423300439610706308360*%i
-.620709507763869859997238509488-1.86306865372408477282137865088*%i
6.58727702391159634085246723343-12.0157696359032105604993734217*%i
100.553425519035442272848218838+32.6884968230900886850227352259*%i
-617.094966590521572680325536406+378.633063100023696739654427984*%i
1851.34063854044091035407383707-707.957221527682662528713149884*%i
-987.022001947204909168054754043+39.9395349919220479468788847261*%i
123.366509559444308128926752076-100.891309584537943350977672119*%i
13.5666946816560593260677503613+15.3024345731792775455481639509*%i
-.614116723352438039507105958182+2.86519421420935608212887044070*%i
-.357968375310948201063128595192+.340721415791238095709030872410*%i
1.02080459341524650802037293315-.402703752185414549486505939975*%i
3.51953222235449574985546163977+2.82700796410371410227628474011*%i
-8.18732746175727696393042258748+17.9888086877111096146815937864*%i
-49.8564507254682560844029062775-39.5544748106610598172735646240*%i
104.353435062624754157689320031-24.9128847532607533088949162694*%i
-34.6698391987984493543873823611+66.8169524278521349107404532966*%i
-17.5728166122483040973706024904-18.9234949788221082050632720333*%i
3.80046404642265208733214909374-4.86528284201474225082065898014*%i
1.32225534081890096373324844491+.109806679344906345986731318028*%i
.205569147474141556100591628855+.201846985351133014743564668045*%i
-.148420630420271604646324884215+.175137819772438463859386405508*%i
-.833840823449710251192098272634+1.45801553015234853530120989540*%i
-4.83372851217186451312727862029-.273066126512285308423226246084e-1*%i
-1.78071534862183878474599925067-10.6893588801430982529588065375*%i
15.0405225759148305464974416174-2.46058035128432024019702341961*%i
1.66655091179040306146610735924+11.9974321527510394580158484580*%i
-5.63025484467515339217546501297+1.57123419716459395773200533902*%i
-1.24995118682889461737186627340-1.59045609337424870331000070127*%i
.142979475736546812627716410398-.569935646516443465240219373301*%i
.128055497981410151321227485427-.942196787757698972007274091611e-1*%i
-.913580981783020700148619738295+.544390968897880266603483173510*%i
-.740920663189928812981668068775+.317021702298535160572278460747*%i
-.906970560817921005070989196408-1.11275628340699532080657998608*%i
1.13448231762248606826997764392-2.81559511603906816120436180547*%i
3.92886825705585539789375346383-.468656626808900826467920590613*%i
1.78653660787824172782371778848+2.73083147033854098662607697823*%i
-.851749847143202629729583892624+1.62870752111691771703288586990*%i
-.772485786335266395495160554788+.118345650171996228662067762459*%i
-.223811621513535732200032655546-.163401663806894050411402526657*%i
-.267705729095362264783827670327e-1-.844700280278540575429690354858e-1*%i
.112080183095872282339881530961e-8-20612510.4714992119261714573138*%i
.175691584197763615336258002283e-8-13392727.5021473844618586858584*%i
.275798544381116414530423358304e-8-8691865.24027530536304971857191*%i
.433599626384212378904171298260e-8-5634152.31438611046241505020786*%i
.682781671663501224998010586481e-8-3647359.79601957509421226685008*%i
.107699662193639204808751826580e-7-2357883.95478062864694701093569*%i
.170189841164578960455390297113e-7-1522003.42251868019835513623515*%i
.269458067853417398295245810165e-7-980865.745306520551997384621551*%i
.427506911956458177741357760801e-7-631031.255479420914416556862109*%i
.679752497351532741399708727936e-7-405210.661861283924815575914774*%i
.108338136459017287301263520078e-6-259677.857770005095039785427010*%i
.173104549475007054501970336237e-6-166051.079844794948070368957754*%i
.277340455135056976686819229139e-6-105930.814506269208629872633799*%i
.445640789225413269808843934214e-6-67404.5578696006122777468692233*%i
.718327270962843273588521764502e-6-42770.6010609856006182513224720*%i
.116180940210936286643645931331e-5-27057.1650174091210489188954525*%i
.188601038886815038724815231516e-5-17060.0041511191883427408640544*%i
.307386910237120438719890666358e-5-10717.6714553062614279854892815*%i
.503164642966494904739961229539e-5-6706.47183891176793357679023281*%i
.827538161054310917605739784200e-5-4178.19584030690448647984114575*%i
.136807542921467438653968469870e-4-2590.54352897572627663185808319*%i
.227453037012773736699812402890e-4-1597.64728739765402449284254013*%i
.380519994776850931816437341971e-4-979.510458670704476061894100238*%i
.640981341639516273480963150843e-4-596.609490279553830729698391546*%i
.108796115799731564672429004556e-3-360.742244436423768741072886268*%i
.186228719190112219398651541689e-3-216.347904199012526389970754186*%i
.321785694802480032756661115290e-3-128.564355333152758105379073293*%i
.561905045503468073503027546607e-3-75.6120720384937245354826170625*%i
.992902492677161879243794109135e-3-43.9504083318578155250130328706*%i
.177815336424881862410214573079e-2-25.2063156214920606935433682447*%i
.323329650140332990180390718742e-2-14.2332768381537202953402041163*%i
.598251209127421185371471117095e-2-7.88882390797599658742881802151*%i
.112933829802435015773029760785e-1-4.26725246769280909646426615000*%i
.218198976188186106749200467097e-1-2.21905476002971948606438871738*%i
.433182974461767947357751230847e-1-1.04864106955410848796742004705*%i
.887965159939992495101577000625e-1-.318214399712071503658327458923*%i
.189101210155014560027272000991+.297260039753639959142547714824*%i
.421683060316148344856977505554+1.16702280159308860230170553231*%i
.994809164040865167508521233124+3.00498545120071300240377689252*%i
2.51726980342712707716164131854+7.72445271862187874866855035256*%i
6.96260959371138650892877710772+21.4202582287042758528489531532*%i
21.6255161782835355591224390258+66.5537235898522442495813070905*%i
78.5120890529671110906786312207+241.634587826321366409653397246*%i
354.988379954062455533978789651+1092.54171873727957206968770803*%i
2228.62836797641865093964604513+6859.01281053142104125485491459*%i
23988.5851604270311438835974849+73829.2736257403329261997591409*%i
730740.961875896364531258807948+2248989.42830496872270664582426*%i
391691538.547125213955794102762+1205502599.83733344439481397502*%i
19561821735878.0529364632470845
42413529.2812157383997257333048
438012.136938616543480146261498
25056.8274164284094746970396840
3061.14024461984033087920806427
573.345904772591831541429119359
141.030383760022832602542049900
41.8553548244066603325121869635
14.2364270367716053283354207969
5.36692928878591488932693646709
2.19157377094872515482543727644
.953620232665538106033006018090
.436858882973544902079072766859
.208780663845624576981464245601
.103362472669833235811634546532
.527173736361007291681509626462e-1
.275767487193387905362845013563e-1
.147427308444160268346101111754e-1
.803133452436847913986779365682e-2
.444756061777380532346374965883e-2
.249864122349151447737820555520e-2
.142166214364682626133841084021e-2
.818039682091657965676806496092e-3
.475449574317434871737604335667e-3
.278823055395742433711971227389e-3
.164835780897481342284491130971e-3
.981588522152795448563188139914e-4
.588386904987654661234185901223e-4
.354804769872286239654795663737e-4
.215118447740552920798536002943e-4
.131076041681587941350054729831e-4
.802315549128777099780480753726e-5
.493153362805016738456186033193e-5
.304291339730672877618213390593e-5
.188425156091603592262820192992e-5
.117061437808310954608807357546e-5
.729474223756295451618810876753e-6
.455861275894854974970152451176e-6
.285625204411741676644860866203e-6
.179400528687766279191837494909e-6
.112938897250767988132725274265e-6
.712510853737342234227724439829e-7
.450410565593908155995564835382e-7
.285259938172612419587013714494e-7
.180983323516170708797499897856e-7
.115015487549130173677089702684e-7
.732069156761893545491094492972e-8
.466645619987862704638768276363e-8
.297869335882047766911345196882e-8
.190385910363833766929963001092e-8
.121838213740977719940466715650e-8
.780626804983521735264557184246e-9
-.338686723173495689908320156337+.159604231940431386700039554875*%i
-1.32028749388837591192411412591-.447633309059715313550902101895*%i
-3.10553051331005400425728835080+2.43653767886246637071257199709*%i
4.18303505286158292929051748315+8.12279301421700033733096749150*%i
11.6850191966404017408794362168-5.88716500810259450226078751185*%i
-4.75936870162386350560780647395-9.10139402907048332381662359533*%i
-4.55261051555853149425495185202+1.53914887939323546749522741780*%i
-.168974780482120135610096033538+1.60478793021667771996661389938*%i
.317613669538353815784357459554+.332335282647466195955637577980*%i
.121774056672044573053739590512+.197839443922964735538839495374e-1*%i
.842889373772496449623682600087-.190744571259343147093366640601*%i
.727390516804316541085650731046-3.29852786604048466332825341254*%i
-13.4832436174084591336428281941-7.74015872968211350962235195024*%i
-15.8276087239591964288057716318+50.8442074564946002522056891076*%i
86.3504843335889461118528810327-35.4733044948892452286989406556*%i
-57.7832456073126337798957476261-26.8761439553644245467729576285*%i
-2.16672518858490021554938877746+20.4302459179656634881159191243*%i
4.45103993068332187201299951613+1.46015723374357193739913777051*%i
.806640060050204031497647793373-.566359492803615167326552269018*%i
.673387672604906226101720996859e-1-.202551388283199182206363649252*%i
.602159649696826530089754492746+1.19280998217596377353514448131*%i
8.74035537682223501993327056150+3.88507948662375013950347946152*%i
50.6429790140403495975176181766-59.1548027053215077930565594894*%i
-611.285228682005557017546680058-35.2786899787864877118006397508*%i
1852.07302594397715329042397447-460.020260106191565458176281465*%i
-652.121130188598563466378976635+568.180467437856905573418698962*%i
119.703085573726038743678548049-4.93337494028858804010907007218*%i
1.41967207586786558419526819609-14.2728673079262374863724497238*%i
-1.37630217097546733925292324620-1.49128335002878959009255241849*%i
-.331071942430972869234163473542-.101324126786049938804296597854*%i
-2.34710894179238924931058889183+.574777668663049178112653483532e-2*%i
-19.3038475099058794644263142167+9.61767549456435314207965256580*%i
-85.3505144106237640468144756985+350.672864535749447504953802082*%i
14515.8112917966722913665384006-3858.15927638864483287892964750*%i
473394.233241053579650477190966+98833.9380572743415256261986505*%i
34155.0287163722007740962748884-8823.21147952744287057985152234*%i
-657.906414629644574935354353861-238.369121642400261602432968741*%i
-28.1907516572198773296679001539+22.1550478835581480204042532668*%i
-1.33350726388415675255908128845+3.17812165652596200068674001286*%i
-.502718008643790607074037056833e-1+.480269973921655324221339907441*%i
.251611596980949685482187023881+2.56615514639330654112786730678*%i
1.33394384050225790857432545174+28.4358941645975195788330518681*%i
-41.5386181778336178825856935991+659.110172126942455754164391699*%i
-37035.2399072621542378282400587+91890.1253317893287274981175913*%i
370371097320.102689073531506533+510585060498.892006995308966975*%i
301158.851146401235451230220397-341285.614966827479804675536153*%i
1330.09911142970678763870616150-583.953134284016733779752498640*%i
47.3591868515050836768891908462-13.7635870330714872823741207661*%i
3.98943978142951090683980215883-.900079782332388265261846466244*%i
.526114801249628796932408065601-.999432606240090393162216735410e-1*%i
-1.99379003258832063732216867250-.804297758017951953155772150805*%i
-10.9898608177247699559659064089-15.4046150114451180881975916520*%i
103.219669252210971151883112324-256.462280770099850117422021926*%i
3923.00890034441702974879854408+6594.24036467990145104151800556*%i
108353.565573477197861428522202-5671.44198481525414665316583807*%i
13446.7231186915142604693918181-7672.59783091996499047241698666*%i
-274.785068198749317648114738751+430.436207820470797634393848219*%i
-30.5396162129264562685984766586-4.78437766458571149695674766423*%i
-2.31670951551471822442286456118-2.17165916452070221248570588491*%i
-.207148835644159572718732432059-.409860698795583508345400966307*%i
.961702746663091402674153240384-.825694357324370400720910432127*%i
7.85827806777639144843656820812-.211351071962886929548602860689*%i
16.2359042704692168443720404498+53.3965751218820052878816860728*%i
-338.253641644922553952578721611-97.8655916200156706672487821286*%i
885.205555149687524287339112714+257.526309220907957207221264265*%i
-433.293653786510816324478732338-191.996708540717431777099025424*%i
77.1458803291162613417305119804-29.8085575877970792134109087550*%i
5.51230998862407414345589303457+10.1231191286010859209983171881*%i
-.657876192139388301480512954989+1.64714466872545136880679875530*%i
-.256185982433215653293675195640+.187046156153231630938131643821*%i
.615393555560259397199700433263+.210672284571730641579650299115*%i
-.271302919673065996155416393862+2.71241768489747263025809991542*%i
-11.2131143784858924724121368187+2.82452724813737394356290822829*%i
-4.19093855903569668485221799731-35.4494845301137513849112146439*%i
54.2161238310737963069936539641+23.4709870875394639914379463413*%i
-34.8421805987082891777314470493+23.4099229323757815893415637890*%i
-5.38125450467350159170005445060-13.9508604466254822455423118191*%i
3.05691246956884562835632855288-2.17314846845777810668499620906*%i
.806115286576045784645986567426+.255627385926356382999389040412*%i
.111052824380648246045986527101+.156372481465330104171905561050*%i
-.555441582240285594596735081940-.239326283179384749410218317608*%i
-1.23476787578425038529930173712+.154536218345059756914527659660*%i
-2.02090021529159525177031454938-2.32624701679732800098396187826*%i
3.86763155509257268203710812008-5.65436559683849712867346975483*%i
8.52508826470564295390666160262+4.41707738437281742710208206743*%i
-2.83262765979624993669388516537+7.09977151342226028982464920787*%i
-3.70497042866162909431711704500-.521733887288876002618027008748*%i
-.440793798639464766911802116769-1.25076081244860879525880088707*%i
.192612938834175617179731037078-.346389977668354142843476244669*%i
.100683364070788352546160812215-.452892215371492936074803234282e-1*%i
-1.36607436843895562030840807552+.181232494335194543369855085258*%i
-.577072713507771550167297214937+.144975524146390187394092668538e-1*%i
.233140038440300936545671488274-.878334767795084572402779527448*%i
2.01219899472303701003510380042-.874380079779648051724776390985*%i
2.46689515834141890477338689695+1.38828952523530289341004242177*%i
.144816885636872416580535599725+2.29298085227594700607127905385*%i
-1.01173549795124400513946538152+.796367532973700733936640818696*%i
-.540314815344916555118397077113-.105776030771566271418364789193*%i
-.120693313064728429420813168903-.156640067869733968815779673397*%i
-.464468895409209632925405948958e-2-.641217922021171072205510365246e-1*%i
-.253954905191755400170636021697e-8-23978229.7242268504416107969609*%i
-.396935887084850744485137639530e-8-15628751.5311779501311334679847*%i
-.621229917775932270491964437443e-8-10176394.6275907880311132863939*%i
-.973613440199825319476965413005e-8-6619046.07184859587132641687750*%i
-.152812803396847039537833316976e-7-4300265.07979996444349725868879*%i
-.240221468780122707818028262159e-7-2790338.35039386091871961090718*%i
-.378256288313127645778270484937e-7-1808174.48961856936360990374874*%i
-.596664199377416370039039148653e-7-1170042.93720314096273809429274*%i
-.942963321223254492648557148570e-7-755950.061247029765725920928234*%i
-.149326510834954878561991488536e-6-487597.283448080463257173259039*%i
-.236983439004481534965397316522e-6-313940.894221942695015858887786*%i
-.376969077037568153399604721190e-6-201738.317066555438668528431880*%i
-.601138533605564980776458287543e-6-129363.363177812134576438227456*%i
-.961184229598013231333907779194e-6-82763.1966760220467543282239216*%i
-.154131964093523883286145364950e-5-52817.5179052141453857699336226*%i
-.247932475798926220637724186143e-5-33615.1476517676718420356055755*%i
-.400166372075692555137597832192e-5-21330.3627451086740363414728444*%i
-.648244592022301496892821728803e-5-13491.0003175763571913446269467*%i
-.105430862255049064807756237552e-4-8502.25008176800161586662326842*%i
-.172219983771759834395817011595e-4-5337.16635033077752713755758496*%i
-.282658664395549549506274557089e-4-3335.78033033790949042341973501*%i
-.466340284461432597704995296879e-4-2074.87842868909678257184539417*%i
-.773804119001234014146961885234e-4-1283.71002671674058275096822352*%i
-.129212214067288179540653191577e-3-789.510296529696515740629830781*%i
-.217277370251984098518026290291e-3-482.351624629391472249566108740*%i
-.368215230258682603584630373161e-3-292.507427744042526490162877983*%i
-.629442088528527633324608864506e-3-175.903260821769822917653049730*%i
-.108650129455043359104847941088e-2-104.786252014844229698953711696*%i
-.189607460078956328086453575047e-2-61.7554727693660937731939025516*%i
-.335007995672327231629422130166e-2-35.9526181936361931545664147746*%i
-.600300605389004759645885132425e-2-20.6382092938577431473891085322*%i
-.109314855917169712526932224154e-1-11.6542241979444915527551132779*%i
-.202791673953151133949744289356e-1-6.45224769651056745752015912863*%i
-.384393118045682747790941592975e-1-3.48111615118423256226987447607*%i
-.747217494755626921804275853434e-1-1.80177770581819301405270060507*%i
-.149639343909170455560106095948-.843790993655892319985619429367*%i
-.310508827439319142245032227907-.245858860919371254826876987440*%i
-.672578819509866450207371057496+.265292086458634529430005855015*%i
-1.53552243373013599791766471634+1.01532381343586195293168225590*%i
-3.74317492902977952057296385092+2.67744966059697260459871620452*%i
-9.91844202053131450929338333247+7.18991715432227486162683424433*%i
-29.3030883472593695131314489184+21.2843260344170117592985596689*%i
-100.257862588460494015777409730+72.8399299881902228448124228772*%i
-421.797067638958792963065730213+306.453104302244101770575279950*%i
-2418.71277861158964098227124232+1757.29762538071494567782970935*%i
-23083.6143167952389316388197341+16771.2274936748173837955125746*%i
-589422.664072476255324320002925+428240.632418573612035487162604*%i
-227400806.919253910368815550604+165216357.129573696916293100064*%i
2612274409359.07850418916198751
11239550.3168701176083970827295
147283.187076382975398410258822
9755.81185347298323165898322183
1324.18843192851016603046249986
269.077990082252657382705527754
70.6980371799866186480635478387
22.1662628760022115450865631711
7.89980175362931107013976619886
3.10059042215134508643012368053
1.31150045799205167640033421963
.588682105435927063727826664507
.277234047425203910543530419723
.135812775940195193731271684367
.687529047519360657087632966887e-1
.357802692778213879699756387545e-1
.190634542525940623658038580257e-1
.103636767301309853700470902130e-1
.573316637412913240553559367573e-2
.322006446547684246756077841220e-2
.183277028750076609802456464170e-2
.105545419763829406219597157509e-2
.614155327407668131648456121713e-3
.360686390880137424876265690540e-3
.213584411014285116326529439268e-3
.127418178590376026818685119831e-3
.765239891058794397448554910102e-4
.462371684616956976500566199989e-4
.280911631962624061124022808047e-4
.171521956375705049040565562305e-4
.105208976046190650550341526040e-4
.648040109365862666777652637396e-5
.400699104516905331389833435747e-5
.248639181988447728155007828259e-5
.154787773687050038362713949273e-5
.966524567169252465949722015264e-6
.605204509621462431462481280801e-6
.379942247177893805236086821887e-6
.239100537324665950944074671088e-6
.150806361773405278140147455758e-6
.953169117631557838174479129971e-7
.603631949153426532713025471609e-7
.382976650109838338494028144372e-7
.243400029633989695253313368503e-7
.154942917737862616214043802126e-7
.987833612678164687840924424600e-8
.630693476651573074350362613963e-8
.403217931527247324628297663480e-8
.258116331909660910733847998993e-8
.165430247047008134008029819253e-8
.106147555565532788893494936696e-8
.681827639482219150228319011097e-9
-.364005324240196166488501005506+.760076605449862547317585072126*%i
-.923156778500495568474832349326+.593318268860212204369381688998*%i
-.128545454145063826902444408043+2.50898147850121555090262626425*%i
5.50135029187245860807300313096+1.83152279551891690847993162626*%i
3.70041373680584675469159012959-7.40437699298938524576936293029*%i
-5.44977185096084095621977133198-3.55213620248996597858863068421*%i
-2.30730454139027204403302740512+2.05559980907940044473682657075*%i
.222348483612179426130336912664+1.04098536983487350703671363150*%i
.265000082768528321232080783223+.165547742342631140883038322835*%i
.863536929505755696840060865640e-1-.338702555186498756414375946430e-2*%i
.386349285573262123978375879518-.298351796349522754059767975166*%i
-1.46511503100721320214794282210-1.40833037396606035303305764126*%i
-8.44370615600345020654503845650+3.46563810074582356448630870288*%i
14.0333724163587242530184419362+26.3003782785444474285916428628*%i
26.1874733843154639758144239026-43.9737213103802259862298391386*%i
-35.3842734785556070431591771855+2.02223122274809224670487652509*%i
3.07994367659480856420913037303+11.5113358033499358117175922631*%i
2.85977131524540606541739993796+.119343330783518412393391551615*%i
.430929739149931374225127731317-.464341332368143456463403820336*%i
.223329417527830015137153762940e-1-.141758046247694299313343761095*%i
.961647349907760936540401458490-.136331873135535708057878766698*%i
4.44460444752231462962038658920-3.31275163939106589270072107924*%i
-11.1108443240476640503175582301-39.6376148455690943637744336884*%i
-207.372766600652737451889400954+209.859346650482559688647458239*%i
545.995397540921565578357405093-679.378988682604074696896463005*%i
-164.079112733981349362023716643+375.840518737523479283851734846*%i
58.6409110170215491539655764186-20.6060255573281715096299497169*%i
-.885382983568753069458844458842-8.09166387076230958952104414808*%i
-.970826181514682168697310048824-.773056179180559501312738215461*%i
-.221211297113155418993263468142-.403050520722710189032399413417e-1*%i
-.635611207944991415855575917860+1.24004534478378390408513661767*%i
.539296275391446459092416274800+11.7924594342650081695268405207*%i
132.518891801609748244536455061+113.062025112864473393507525114*%i
1922.85584955552202670642418236-5727.93753786838638375616534863*%i
145477.626145186757972733966768-73387.5730624731101044598002010*%i
11493.9158454217837151798826184-7254.30256140287676987089756277*%i
-322.103682420830803737162147394-58.1128027450365247912748775878*%i
-13.7232803829098009167417612691+13.4558484444436248919389379685*%i
-.639548015287833377249605838786+1.93228426527063167735711414148*%i
-.141355125127870468390503853126e-1+.306132880887142984642032628172*%i
-1.45770475217821133860989623095+.527500422766253025133884833782*%i
-14.2877717047611584494850945581+5.57273185957346322664894674303*%i
-296.774616609341392226862532659+81.9166403833094349749041868352*%i
-35945.9949870920790068856952406-1194.66962583815253456926908176*%i
-31264932963.4479984687139208278+95960182318.7583961743812013464*%i
105995.358074467095590312452623-110002.036317593574634985121100*%i
602.024807784538931411107548658-249.945744135718123939606105392*%i
24.9898577494937050027409163398-6.92260699531505205507886794886*%i
2.33465148785167723269950833635-.505154039094198652149787848337*%i
.331947032099917280722060719836-.608052695693525555921781036572e-1*%i
-.104129493292444357120415280086-1.18961438310232627065144214059*%i
5.14092710688134366122002699746-9.08231166889590254285888875530*%i
134.639115287307593031032494652-15.4195249415528708402625679758*%i
-1281.82351596975358030737927058+2935.46646211102858139157950308*%i
32410.3531577666561440825728663+22789.5533102787581395778109669*%i
6150.75505995807828756985326157-1051.81754078621828079754452119*%i
-169.042221852848608711214800728+174.877957697611440019399472049*%i
-16.0369401786789744425564789740-4.73384180095169016075564098577*%i
-1.24846196951284231818727415888-1.41265014163223711040434421571*%i
-.113188548656771790582027642639-.269657756103203417663031727236*%i
.919938590422204011461125196724+.387321630563963828169183943626*%i
2.44122838343828616204143336821+3.90250207200822476561315608569*%i
-18.6657181883573410293793746377+23.6294303087277278447314746139*%i
-77.1486843281529128318049917306-157.409291862409462240778341696*%i
261.977655633245263678119459785+352.460563108235635780072112502*%i
-149.490979552080593742114711470-178.428178311999040658674648629*%i
43.8244624146162601192554426285-2.37505250879267025858449137937*%i
1.79889823520778078917576492390+6.38526621599957051085238323296*%i
-.568391666195677989091638971583+.935411448727490604611670125597*%i
-.181568146361678411529810827908+.999821197551024986936348331977e-1*%i
.249822882274322680939090930834+.877120619612379337411859926629e-1*%i
-1.53589747338718713635605960450+.708639295145202010627278182630*%i
-5.50925120680604827301569330139-4.21065739191129977627606889217*%i
12.7058430811396733685365840211-16.1118364829452763010702321949*%i
16.5650912968608335177859746404+28.9942188964745452949362852267*%i
-23.8975252093607221023709542694+2.24105988237842236149698461713*%i
.728844173514105418562306725727e-1-8.86036003430432909900549564804*%i
2.19959105847511784750015387747-.760183632692181025443738881351*%i
.474993489024160978277789994591+.276318963112168192575112281532*%i
.559101665942226063241982363838e-1+.117321466357706233918817147064*%i
-.567706547909179624623554268848-.875689416007343119587361122653*%i
-.781609216364809020713146448194-.625564830778801486482113762383*%i
.262540578996944224784616945292-1.94435464090927062367344863342*%i
4.37228951645991690742825389394-.866888439919034440826746578985*%i
2.73193873667447081710431780051+5.61085921298976327131744326051*%i
-3.85974807413760404009707245085+3.11255882498750956479457248457*%i
-2.09696905003043476664354642003-1.27261920186554055772583658983*%i
-.161354302052103171842694409680e-1-.887875939419788481045320509502*%i
.188285291277221312936533282784-.196945591988977231420352562807*%i
.761748610265814769445312719708e-1-.167784608010202015716840407591e-1*%i
-1.77674507549316090228978201896-.318083901817157600576970868947*%i
-.507303699834781521493018330021+.389415938392366499315127683752e-1*%i
.609780642834145503983904536869-.945129164987569695503624714658e-1*%i
1.56681386923735847897393010398+.620636459915997665448619274502*%i
.887827035227705368764150351883+1.90910804933709770944433574640*%i
-.713352930037034155846551965843+1.50497064679330247234265661312*%i
-.893954879555472680556290992091+.232912058701573122364656667715*%i
-.341742532920868319994685707697-.199986604147384947120564014119*%i
-.534468171251927215248920771202e-1-.133407619597910905422741769904*%i
.732177366525129816756377978979e-2-.468553190071020060234161071526e-1*%i
-.221451655360296091080792759482e-8-27676559.8235971675063461855412*%i
-.345179672726461782006181589002e-8-18093572.9399937680572800934637*%i
-.538680512653762784659164613875e-8-11818258.7719147129847987159615*%i
-.841720857063416579065247144047e-8-7712093.73158974688319020424142*%i
-.131701058246498498939165220926e-7-5027487.06834947911412773683404*%i
-.206362712297547812031340578692e-7-3273835.95162128438381709301552*%i
-.323842302633464162544771035839e-7-2129386.40246333828316440441861*%i
-.509025386915422350360834737711e-7-1383262.16821992968835844445916*%i
-.801485864556420476140325508384e-7-897354.274658258686122457278787*%i
-.126431207525293109798495557465e-6-581279.979405443909195832944507*%i
-.199834764381875945630512463730e-6-375938.182751319745239418412796*%i
-.316524985953732085544905827518e-6-242716.466612482342377589274477*%i
-.502496711208563733940862197813e-6-156411.818149953293266494310166*%i
-.799690260452622610946116353569e-6-100590.286817165636996890610983*%i
-.127601794863082884340353613670e-5-64547.4644605924470083787301125*%i
-.204188004014666995195584178500e-5-41319.0370075188818004978196615*%i
-.327751360031261700964856366901e-5-26379.6857156740925716046416469*%i
-.527853963367778988295243353624e-5-16792.9033011951387212311954228*%i
-.853229364861585831630859038603e-5-10655.9681138458686763047333612*%i
-.138466230856892266343912400527e-4-6737.96683864937477822344616759*%i
-.225688521157588693516246366435e-4-4243.97244259139427010722841560*%i
-.369611196210512990083764951506e-4-2661.58734739548270483612987605*%i
-.608496345770303307723662047796e-4-1661.20863058002491385535458858*%i
-.100759071575155032270599884830e-3-1031.29564184728564882961345029*%i
-.167916744022540099489748974080e-3-636.417138572982381220606061129*%i
-.281837342476905322313499136153e-3-390.104907970243684196768562188*%i
-.476823262638330127509496253283e-3-237.318555606479634652876381702*%i
-.813933670847181507763638971485e-3-143.139999573460672443630818307*%i
-.140340406746687613311782539276e-2-85.4995097422027856669396593894*%i
-.244745709310226845467206705030e-2-50.5062639984215433046378103130*%i
-.432384421956604834987904931293e-2-29.4583567824059645544228782114*%i
-.775292337715400490980345861454e-2-16.9335514684577526253729585535*%i
-.141412615543201628028752042919e-1-9.57398780747262390824966045541*%i
-.263111639244671909044724045916e-1-5.31551137776158617921017906086*%i
-.501073780320001108767660993170e-1-2.90141930493400213817904033307*%i
-.980887391850393859303516836814e-1-1.57839950354916140435308730432*%i
-.198439204343831999653268342842-.910903616473843546087075744296*%i
-.417761838749850837031661184748-.678067485350940630053116107644*%i
-.923544514924706274615560301485-.845056274881321422191814012704*%i
-2.17015960737307420107516640838-1.65271922854775336947889233702*%i
-5.51197852394439441672826405027-4.03534418757271617681870353338*%i
-15.4987059087728729912244942134-11.2716181119093809998660487940*%i
-49.9992709123722156232881200228-36.3301229807749466184407905926*%i
-195.823178926836691875018780378-142.274783832326234559081584330*%i
-1026.08385903403576498636763125-745.493738379671052434597699628*%i
-8685.64236646216173043129292853-6310.48858349402318509371263230*%i
-185950.011936093701620702632994-135100.591755675699995966868076*%i
-51642563.3671366446973977921115-37520518.5414365034641263733530*%i
357260759980.632836317995583408
3050108.66153773853746131713749
50706.0495276677486990744609310
3887.89930149519512855702933364
586.094888937891291261441860649
129.150988542640261076083910790
36.2278517288822635540272467538
11.9933169333869194103534167517
4.47599640382363469039273551873
1.82796285674289565297930723899
.800439589711961543921585370710
.370405850123108919327578326936
.179221686318567308142506417033
.899459477876333573078925000863e-1
.465337792403819085100555918110e-1
.246972438374583239320050755035e-1
.133951998222116087217757961261e-1
.740152688511060900495875004650e-2
.415588973657815792019863643919e-2
.236629905568005087568521607626e-2
.136390085165027743389204445403e-2
.794638504058394046503286046724e-3
.467405665026286575481800612288e-3
.277267786997669503137157435026e-3
.165727561194049754697130137417e-3
.997338811337942275036812997670e-4
.603880607408124698499458967431e-4
.367675958199910186063361317375e-4
.224989552089934939568677760811e-4
.138307769186864697919702489817e-4
.853778150094588795505179459646e-5
.529059551530141329613961961591e-5
.328994729792232029038007335793e-5
.205246919582722960291809047634e-5
.128427754540608912697798312273e-5
.805819892979493179983822714317e-6
.506904298216263972544615271967e-6
.319626982615598701359785340233e-6
.201984697091044947873702576416e-6
.127904498345789726389053039162e-6
.811495526924681097098103908139e-7
.515780932887574937564545732898e-7
.328377831337801510804974687109e-7
.209395092566313723473558655966e-7
.133721659922313312663912643333e-7
.855148304627534513972965203139e-8
.547583551458955975205969719982e-8
.351072012058461165678754562212e-8
.225345522511756966989397758196e-8
.144804099313455354844916885580e-8
.931464473026531830123521146966e-9
.599765404319688518687115949973e-9
.817392482123615667176084202721e-2+1.33924521924153908565554644214*%i
-.262770816682217422752395162022+.893742403170012169142177775549*%i
1.13318387410191273656946469106+1.09250564886056283100117230529*%i
3.39410170869510102156417975423-1.70394857458308701774420707816*%i
-.949329523018102712352664087619-5.33170948807464943307363064847*%i
-4.23022484352825873375374254172-.305794986568759891521573270883*%i
-.883129149792341897723641134886+1.83582310929377906139186808074*%i
.355832630008395232737198909196+.623331124712015525463945902996*%i
.205908114168958128837494664821+.671633270394639861629807775391e-1*%i
.599497782148807640932255702950e-1-.142596486927098533168386678378e-1*%i
.371002404745179910919081712529-.189638410931185356390194939745e-1*%i
-1.21487251408814293049630580117+.419607357914230701267930619767*%i
-1.46439834301679332810674935156+5.30566477645103686001435732029*%i
16.4299457828717831589436030263+4.81945645492083927966168246044*%i
-3.08235570737278561891542111801-28.6820411442438542136299465739*%i
-17.2886391854367533134687801103+10.5236991711972031320693088349*%i
4.13915195162589562540996854674+5.74536582352884664005949821804*%i
1.74113889705665192502695132277-.405648980214739553702671189975*%i
.214335886743170709762127832264-.355826829482160234561826985762*%i
-.405798175601121840360007218286e-3-.982593661808219984753004736319e-1*%i
.379899292662383693015265994358-.823908379596885595647967417948*%i
-.384847183799394443173107041178-3.25308237215569340270822153374*%i
-21.1793890025609501839192078058-6.86687386702848955439417331361*%i
10.3554753906012483251474311315+145.319220346256084102216859277*%i
10.7952434051626565776517973325-408.090868685487287645138242211*%i
5.87714161393135425519723013486+199.224605857361371347056779444*%i
26.6289244310862269568643458236-19.5101663100296790967903449321*%i
-1.45972111672085494211408718024-4.48988619294316760996596202768*%i
-.671091794653577142700684913703-.386327363486964038421590657385*%i
-.148431640113205168566148370905-.984151606894456863477333341986e-2*%i
.368118691530683268055988142082+.545954160133865009696194536001*%i
6.14363476872294134766491231535+2.36131891422979683943114369070*%i
79.2835974692363717728468243806-33.3295361498521738469440978767*%i
-1533.61330077233111122762335472-1960.16869953952039613941966399*%i
23470.1363133862452941728621750-51108.7407328134439597417817784*%i
3447.33233997585521225019560679-4108.35390383263566167607824879*%i
-156.629486237013947675020316689-1.62666655586449309904355218284*%i
-6.67644931000773678441260534194+8.13901863447146416495249399113*%i
-.295443831454999995555429448541+1.19029355905803541239604512557*%i
.212599876337827906223272821307e-2+.198135630365083637395900554868*%i
-.685573242042026729345210787577-.903845027762520812441085591915*%i
-5.43216168032721667620717313468-6.48747492733671660638244532161*%i
-83.0624847772865568770947705027-121.032528988828828590743448258*%i
-4161.54968650895305970360284474-12702.0422422862434183899669733*%i
-15733008621.3222650806308358510+5096973761.70506944917005055425*%i
38041.8929626699959407622860700-36169.4979866305145993035213018*%i
278.608762550612659068095862384-109.170307281405880518661818977*%i
13.4702233417029187656220940702-3.55143708311701044467471773168*%i
1.39384156721166480808217193461-.288963700403072656567819981681*%i
.213369736202775643959578890893-.376710231870661035265097962034e-1*%i
.500726603479272025701342189935-.174847644157721456510944232547*%i
5.86034905293161808197049286455+.500934755231897664922759035482*%i
38.8983999250080746064413770691+55.7280000300195950620009457772*%i
-1339.32329592068271069173173520+285.312692652738709560306976685*%i
4277.66348010060872410512043698+14192.6745604962869899255197965*%i
2534.86417239823588072271511984+458.912533229133505584991924180*%i
-97.6073302226042728300001731857+67.2558934000999624323374297763*%i
-8.44980661897224374026722248203-3.74451342741635281754660334350*%i
-.674171976508910424288079860953-.921812919387496296068666919663*%i
-.612018669669130291725306845827e-1-.179597367839324411298390394594*%i
.326255382914900711633716832714+.818746537893299908760244402561*%i
-1.23047166042852739191252298598+2.41993051122852957316620245460*%i
-16.5928248255259544822884117629-1.07724422745928999833492994261*%i
33.1434975531020723974394443516-83.0898914500777651619852593828*%i
-2.03826068521130102778369931704+214.600722623890522195491300442*%i
-28.1627078539514091319201267380-113.791855273301642100597246230*%i
23.0578144293385737461175190971+6.07939231670435426669046637594*%i
.209480435289831921448994559642+3.89653441152579235585554649998*%i
-.448629488459942631795558403539+.523170619667706316087574872354*%i
-.128175864370948089335768154781+.510615000538348234551606168675e-1*%i
.390252525166579342916200512736-.277330498210032248465908452565*%i
-.920329001057922257412475813269-.721932248121880107460512115318*%i
-.878057207762275318209272501951e-1-4.26621630941868231913516878493*%i
12.0269781380192883413291567869-1.36905963214388166306254833535*%i
-2.40930948962812875403919213752+19.2696934151602661111799306664*%i
-12.9785724843845057953878332587-5.50906212494639213932803044746*%i
1.99512987855236901655232394808-4.99674339021433704466913988111*%i
1.47413206829711904262118246704-.776310771127497284536749928079e-1*%i
.268585743649183207873752417648+.246077913317806407855696430253*%i
.244855312987440973469972209908e-1+.862739124077429135217475440628e-1*%i
-.245612407232774680476385300626-1.50062371363827631000583995530*%i
-.262110955709522257616735805574-.797155416041686063642069803454*%i
1.01608117130624619916380202615-.645393852990220561825096250625*%i
2.49069089783316716134540470555+1.68575160386146109372307581336*%i
-.771070366367829378397861409858+4.13065993160517479072582565444*%i
-3.26294205024094675396297852450+.570018072787124248835138338947*%i
-.968170226878136574948488317781-1.33463327994798977455356590385*%i
.176642062445435834765204670453-.581525755023986744595991477706*%i
.161881807941956970867749187008-.101359099972966158037746582293*%i
.560822992183821193575165820309e-1-.963010972525850024655941449195e-3*%i
-2.18333584407469422236655622238-1.04130169977432065283722584699*%i
-.741712116364359619923894882413+.955744682775634713748148274775e-1*%i
.268437846730772450106540717091+.558828601408197720011258259829*%i
.563795604048677749431525619884+1.27971467356738793409704788378*%i
-.281290017814767280300736854418+1.60833839154041639821927940947*%i
-1.00086151388529722912642919824+.738991072800006093543587664663*%i
-.671984671270164737256889449493-.982496055592127579510546449219e-1*%i
-.190759614453818232182919349760-.219452734985320314447206983451*%i
-.121695555279346827028972870447e-1-.105703141803431622114633794195*%i
.130114591459901461411788925838e-1-.331091002416409172085422086409e-1*%i
.743215943814612748821958947157e-9-31695040.2882787240093648726713*%i
.115543572446866717356760380336e-8-20779886.5211606763393035328329*%i
.179825024041710389368906077610e-8-13613320.6612184967121042680967*%i
.280192292007926783171290395564e-8-8911073.07006138067886337258499*%i
.437113745454402924559047002858e-8-5827935.32528096201778581018713*%i
.682807154256742664786427665467e-8-3807934.83982085528677518436194*%i
.106807797197011103457482733810e-7-2485552.05074745946896246181616*%i
.167320182129533062559074427720e-7-1620616.22575326442440754361212*%i
.262528781804957293618969583570e-7-1055415.28852484369485580034691*%i
.412605945693331437029479398447e-7-686452.429645083586756274948314*%i
.649643675425238731434656170879e-7-445856.339997931780541974689025*%i
.102483123902087945002110097690e-6-289151.499182515843536471008181*%i
.162005140608003572140594916474e-6-187216.813964490902560004208293*%i
.256668647727431008758436436765e-6-121001.180117291233701461174743*%i
.407624211458713728404418576555e-6-78052.8600655699046557517727380*%i
.649043823047524218313850532178e-6-50241.5694896355411617824441475*%i
.103635406467778596956031282010e-5-32264.4148782325696247718099777*%i
.165984039904751844972634066521e-5-20666.6728639254929238644592769*%i
.266725716354217879033895142332e-5-13200.5079378528750423537840887*%i
.430164406704321445015150076884e-5-8405.35929669990856789877513793*%i
.696501877170174419171114131558e-5-5333.62435467429653301466755938*%i
.113264774169073056350220009787e-4-3371.50468904316688600103897062*%i
.185072246642985516723259321065e-4-2122.12636487567560522158181150*%i
.304002584812581814123146211181e-4-1329.37570908234085464481687857*%i
.502284670527395030822474072315e-4-828.329114455817863584477923710*%i
.835302489407682846658000054355e-4-513.034866158856159021141105762*%i
.139922699941960196778628859387e-3-315.603841922324936485015927909*%i
.236301518849540910406945968917e-3-192.661436902535506553867210646*%i
.402742849478771320321586175578e-3-116.584640969007727762093660084*%i
.693588136890531346712393237609e-3-69.8451408879008955229629839247*%i
.120869553855856785219780914356e-2-41.3653171852259524649823024806*%i
.213514183720528095189516467391e-2-24.1764625312682782300862536021*%i
.383125348462833040698298205957e-2-13.9178996983401468606165002051*%i
.700114977817562111650359635442e-2-7.87809006636950450562771947629*%i
.130701756667590495433150277055e-1-4.38457088401116328031624977854*%i
.250257636212603357776582629447e-1-2.41857205580687592107311410863*%i
.493917044304073292811588851185e-1-1.37583687343954676728883933511*%i
.101128234924001305861760065745-.927386370223120803604912656883*%i
.216624367875307633286055037344-.962924651047723527075071631804*%i
.491000973306563380224234003204-1.64556948058978166993726511525*%i
1.19618833179764768071401990763-3.73815357908949485640505832586*%i
3.20321957920102824798952289999-9.88018514733776764960930945719*%i
9.74956849911316817628379408920-30.0133735699666882730803183170*%i
35.5669727916175249682740673839-109.465923839629343981195921654*%i
170.380358016229073317310898921-524.377255303749668217017951811*%i
1279.72088442103885462562575026-3938.57595648902467576969629061*%i
22977.9131589589428206259252756-70718.7450512495283045772697649*%i
4594561.94469882922599268342654-14140607.6577315202324140814406*%i
50114622679.0459648289402251450
848889.918400871097557834435701
17899.2971642490500578382385929
1588.12492941545873950930786267
265.771838755957486873367751654
63.4760817369727142250825627964
18.9982860877645548692699572284
6.63664362378416167488701934657
2.59203177583264792571316223604
1.10072006003875361888863443869
.498636618082865529001486395491
.237729089225267189803318162794
.118102682279718435789057932917
.606838545042901333226422807852e-1
.320649459501142192169499930862e-1
.173453239715598213111535888738e-1
.957150485962169084660170962368e-2
.537250763445223756421009026435e-2
.306025063629779492931354796563e-2
.176556499097683034509435766711e-2
.103005891177408142958939208790e-2
.606889236084541507294688607103e-3
.360689665728535915456552002765e-3
.216031084980638968489410726440e-3
.130286282280416244842780513676e-3
.790628341998585974330905043520e-4
.482469668619841794676837317136e-4
.295909526105754206409520504973e-4
.182320581070763673496510075191e-4
.112803226320525270724558016844e-4
.700581633903462110538584109184e-5
.436624143334540813413442083132e-5
.272988537593985336679284148296e-5
.171181984094352699349554906751e-5
.107634037916544101102945066449e-5
.678469368563578157784301013316e-6
.428666815076102422918802100919e-6
.271422753202364901331264394150e-6
.172204313146840112565572142189e-6
.109459601039826266334854904903e-6
.696982388529393454736785663924e-7
.444527539185414791868529279200e-7
.283948467692403362016457525260e-7
.181636550293810657116656856698e-7
.116346169078470869603293930405e-7
.746193365170294301842444181013e-8
.479147477668156056055232865177e-8
.308018011807077224784323015306e-8
.198218827320930097416608366637e-8
.127688093744972769816220350212e-8
.823321182016392614389173025132e-9
.531349049077036090564549263058e-9
.650854760745414818694557973853+1.79204114478945825989036114183*%i
.132960814670349174831299104662+.817367041936458462262154743868*%i
.909206025608335832622000854590-.120664237909020767349001073566*%i
.766498101711155098115912755979-2.47926606171281485346312072908*%i
-2.67362132235403575395213044322-2.53043793764976704512800653148*%i
-2.59790576180276722679144355177+1.17711651591435561223156376325*%i
-.858234706659047536645917217703e-1+1.37571182106630831449288093025*%i
.361549372350107665875920443910+.338110443325360714800864305737*%i
.152689250367659902987341839332+.121701568237796588815263822826e-1*%i
.408312806736823271266055144361e-1-.182996518165692816248570538025e-1*%i
.829772433183054731582896258672+.109580306324650154976485438033*%i
-.923767712081075174778122047520e-1+.983801221519278588530978012957*%i
2.02816120811499378308959772177+2.74281861460705175155498314030*%i
8.79408264461185116597085029868-4.97744256359476647779218166577*%i
-11.4435624048325773967221559498-12.2465445284422867840947402253*%i
-6.09232549555536467371826896676+10.2127634858946145757031728459*%i
3.59004393789563672491906281448+2.39716119594104651882293495580*%i
1.00588457456668364160712171385-.541796497301032135136081960871*%i
.931020099127143287085889104810e-1-.262021277050495034564950496437*%i
-.109057888525580482820258778380e-1-.676820056577066422192432172400e-1*%i
-.117810903998910790196376763575-.877909991199964291321103663271*%i
-1.74553159669137371233995492290-.785486954781392194972257850198*%i
-9.63672288975241293923927798938+7.70360290199882903510247496812*%i
58.9143406173514252898502471824+44.5223068526581522302064962938*%i
-114.827676128635145244377414584-159.395719045011089082650389824*%i
44.9503307926322650998057722585+88.7231339144802144948021790090*%i
10.8316672666518040297082375542-14.3411091569731321200645935304*%i
-1.38337251601254284209319809828-2.43612208436816936190990006533*%i
-.458997826787944205255393779840-.180912297573775087425080082122*%i
-.100215332630159878243434828934+.448818503177485413314904606687e-2*%i
.779222096915454374939947258336e-1-.233745170200134464594847488589*%i
2.61053202279660538879358888461-2.71268860914257016908578646363*%i
2.92448916887024991834111807883-43.3951283877961272517878156020*%i
-1047.78807526189689250412702250+85.7865944663095471091801274141*%i
-4786.10202625627842558754807466-19333.4520634574489193107726471*%i
823.462681445618726260883972780-2008.19762215725455855436430431*%i
-75.8587460663234456387113825479+11.9727334102365226778006760688*%i
-3.23319258121001259005160485888+4.93278923549616350775783399076*%i
-.126511434238197333661564344977+.743937563811251359647768680961*%i
.863697737322989741962405924808e-2+.130326654723117379151537187795*%i
.220984308133881989351538304304-.860642521831819205655317913215*%i
2.45863509088060692229312266577-4.10066554070968836364711872469*%i
42.6473430094943870846736605455-57.6051806558821832106494728927*%i
4003.24419042437413498618461677-3147.89330139375428690338881723*%i
-2247235307.95526228231949848562-1635893301.49192374853563922519*%i
13947.5733056632409477173666547-12146.1494814825910637709250185*%i
132.003376590982581613787921495-48.7113817703004214705145593332*%i
7.42506705398951739239002851977-1.86027175011913741705492919325*%i
.849684786236694394870375140787-.168627988283594714334093100100*%i
.139819198511890225416773994275-.237839701633299353531732159976e-1*%i
-.429797115878089170641250643521e-1+.509930857854865339513021711393*%i
1.13363061191277921057063147774+3.24244445850877007996682163433*%i
-15.7325502348041788770091587954+31.1651903618440083250664187569*%i
-443.269753692071976259721160324-404.984195061556283669415624168*%i
-2071.67867995734075100253976926+5300.77169007526605506980843166*%i
943.045375853617744414401732513+548.420569550136783332546145013*%i
-54.3811734140597254269841969219+23.3635542337467420849459936311*%i
-4.46733548999775158063171009037-2.71121648863949985464384290825*%i
-.363801761419426580825859418852-.605577165770998114095962578717*%i
-.324077135998244241311500730563e-1-.121240731785865039194739228132*%i
.237089362355050891657925782495e-1+.785088570055317551677330330711*%i
-1.54704475213986659245960412010+.935090172113226207626873318286e-1*%i
-4.79479610177729973871956001814-8.10605548093559293345422814506*%i
43.9678607256462255678854317623-16.2377458998008813137137475874*%i
-65.9592908641044296647829644027+85.2653907648177689753651123055*%i
12.6518208787141303705806566918-59.2996347415772072765033370478*%i
11.2075711813385762282395816930+7.12905527982061136647307887782*%i
-.382382296819024747220218257832+2.31703232087118648376442811202*%i
-.338110253167686677411265598817+.286377284670330479402108823441*%i
-.905056060590077553513071996888e-1+.239063353323938687901813660387e-1*%i
.965628953736668021674383927132-.429664551981172051970347252350*%i
.126318572374742985003811101711-.991123015881799750288707087143*%i
2.04070176311828736351258813716-1.73683064514707877646737636013*%i
5.69293885086342586473837375682+4.63419681807953188738250663207*%i
-8.09710330236091649966933415551+8.38398368985724286375013359176*%i
-5.35184668632506044453795789881-6.63670931591920512617669524079*%i
2.27470630549225310858258224018-2.46217761660911045120269757375*%i
.934596196864018438715471472793+.210559663077596078559047036347*%i
.143201030390689554702981988652+.200629032712702954089958949496*%i
.713904383828397210401253578687e-2+.626461282900072580334521003841e-1*%i
.317649664165845078212142270778-2.07138257439900204098301977151*%i
-.291436964231939925938616298530e-1-.756850549995769963041538187950*%i
.610390542082511888141125724449+.283063925076764077407910196781*%i
.351821813721443036482468783152+2.10804216123023175916190197218*%i
-2.14789540787796867639072887556+2.01510294823428083988393903941*%i
-2.16457884376430096208265514753-.725938588703538922986896021771*%i
-.269536554908952498578619927743-1.10503380862067355970536580742*%i
.239936320472569031997638154103-.351257967474842191940984898804*%i
.129698441895749907443759901756-.427952808842445220151903541507e-1*%i
.404346384825993772215439790064e-1+.717481839716847414383004181973e-2*%i
-2.49490499667830687892782536899-2.12245720385270475466652039104*%i
-1.19911299545591045511886856876-.120352512366291818747437643998*%i
-.425324883638017732404024662475+.720060341669476097061473504226*%i
-.403589640331222726480470184007+1.19103389942111480331141205526*%i
-.909780805000422424528553812728+.957889038841836710399044862696*%i
-.945585706553790057848923107789+.153307008468999920595885659661*%i
-.441072203351377456244636252043-.259271519855051514965968187764*%i
-.851998004557246473094490402064e-1-.200733271097430244659260703113*%i
.113519578164686269535358746373e-1-.794528338120707308051162824231e-1*%i
.149954084844262076128103358831e-1-.226211658285440252734903200797e-1*%i
.212937168605124415430714616356e-8-36010657.1635021214720645348065*%i
.330224854125944081795359167243e-8-23673130.5705043281783507484655*%i
.512622579442754669515654143250e-8-15552458.0238231351854680321209*%i
.796600987350895874312487334188e-8-10210340.3502051095196877439963*%i
.123927201189403946838519638889e-7-6698173.83688447947395796895437*%i
.193021211764358195121644450947e-7-4390587.25486573887890257057578*%i
.301015274285920487642073665174e-7-2875486.62241391001902362152606*%i
.470059167878042394538046781097e-7-1881448.88930784225376892884876*%i
.735081760293979466232814073414e-7-1229794.48269812619423299150427*%i
.115127778851864360364963545219e-6-802961.882295785643389704141783*%i
.180606029150938660641706394042e-6-523647.335234706035259122886081*%i
.283819888637557065210993978133e-6-341050.984376261709756994555179*%i
.446856228119596852492238358024e-6-221812.477282646639889633731263*%i
.704967264779913360837648649727e-6-144039.949249371723699386438506*%i
.111458844164685907389220074231e-5-93378.6892340388439415793055641*%i
.176636455602350763113273490289e-5-60424.1287277582669072355530192*%i
.280640712209534556780498818077e-5-39020.4406660385416529797430195*%i
.447115380584678741780464483077e-5-25142.2685486260379951805548762*%i
.714483939483416594203069967962e-5-16160.2136508490485065933848613*%i
.114548015031026115415984460416e-4-10358.7296451909852163057068118*%i
.184305492940000950921635450942e-4-6619.93054310146416967912422185*%i
.297711455213464369940985779354e-4-4216.38580617059401245592632519*%i
.482981927745591280501042965116e-4-2675.45776443294383142813341763*%i
.787299578260995746801398509323e-4-1690.56576881498180788377659766*%i
.129017130001409327726799176937e-3-1063.20575445952302224313135085*%i
.212672599246914088646984972980e-3-665.108801863684077292102695611*%i
.352884074247202959924938188106e-3-413.574301536169224541892976005*%i
.589872241551809217753339259324e-3-255.412767265231790587624210978*%i
.994256529902293866028857726241e-3-156.508726962310713974353690495*%i
.169175156821037944695745575984e-2-95.0476897767924451140825630281*%i
.290969071035111543505773164358e-2-57.1287431932466261849413654537*%i
.506661520856654607582777110651e-2-33.9281189475518207570498748522*%i
.894917708842401162344638331402e-2-19.8694644048334479365908143545*%i
.160716506930384959086786365760e-1-11.4463891527296375956468435177*%i
.294312061111876415778987452577e-1-6.46681337258466755548994407444*%i
.551569058289875435429028431692e-1-3.56948819766354673051947823440*%i
.106275708769544361161554827842-1.91571460202005095517816654330*%i
.211781911177402706091121465835-.993535010669186721580122587473*%i
.439903019503974533765482467161-.493911342554722071909528781588*%i
.962510556720885491290747194126-.232819893548127847489057604382*%i
2.25090385328742566511496623574-.102521139089086865066504863009*%i
5.74474693296238866040599061775-.412847912908264668899192358563e-1*%i
16.5087743905442114158169879620-.147294817164655423414288296344e-1*%i
56.1345455457875641937470395359-.442851591383184872513312380867e-2*%i
245.989583551609738852929831682-.102966101880665292240507800993e-2*%i
1640.22945893853147935141326747-.156734969001893983921269149249e-3*%i
24709.2965911865883648806685107-.105155093358437131874790911092e-4*%i
3558026.56726243155723796214195-.734725623884451050235640226208e-7*%i
7222711822.33107515436333429783
242711.834619838271816652124405
6489.21736443253953836745682330
665.961411334712942977626905609
123.654012181820383807305309592
31.9893120185620132204631295131
10.2085717612595175676461026205
3.76023478182190318975673182082
1.53573919316858769199521592509
.677609833494269905581809617357
.317323672050919188817868081875
.155749028424268588320635912469
.793875598380483212517353738298e-1
.417334299193622200062760581806e-1
.225071215967290925050434047221e-1
.124012110060600680579132265492e-1
.695812634061631436113935386300e-2
.396515215928271581735149490277e-2
.229000051433594805761965365382e-2
.133799339045429254902092973247e-2
.789731894752077548809907258013e-3
.470306353944006036544502541068e-3
.282298612584727026704549658725e-3
.170640483177089967242015061511e-3
.103794586253975264688505460125e-3
.634900987215496513886543106187e-4
.390331087272552669961954221943e-4
.241070963443097870571659934171e-4
.149505333236713979552570369325e-4
.930692927177300268907397012435e-5
.581368095354257591963861993246e-5
.364304508737355051778041326508e-5
.228946545511629084159787962012e-5
.144264559112503310115207013660e-5
.911279498421413204434200382756e-6
.576938496804761276423478825068e-6
.366033669829578393344964992071e-6
.232680953662539360998617491124e-6
.148180074945160040959752335802e-6
.945266659691205202938882760472e-7
.603956505145344594610676273890e-7
.386455358516772027945467137794e-7
.247625149133069691013332211382e-7
.158874701403823949997691573357e-7
.102057572804765031511540567142e-7
.656349088103732030415664453015e-8
.422566297331391371832701731006e-8
.272331916498007506496775669907e-8
.175679613733982641076110057169e-8
.113433305945512587978504640957e-8
.733052583331385576172119950263e-9
.474116882022906076945709990280e-9
1.52744556380586621237365746764+2.13431025213559597596395241355*%i
.272840059861105987753349787191+.805480724972972360044871875332*%i
.120769949706717235179620502801-.453708591500280343244523834768*%i
-.949830083335039939045721891504-1.63337781093801472762012652957*%i
-2.59189829116432082982908161672-.333856223235585285153854379429*%i
-1.21254145713464278960794357934+1.56779030145346529930750173312*%i
.295423828208755307469113953063+.911394733769746286538623678688*%i
.312921336489512626796031358788+.155434501083262353359742269086*%i
.109361727697329562813188885505-.163134960120824316265543814758e-1*%i
.272759476534168851804149366132e-1-.187432015930173703466507467824e-1*%i
1.50111519417589531315369594312-.164443625815379391658892336028*%i
.737100285143327473099383952403+.630162227015047860917195111697*%i
2.14432709735324391333643292237+.105938277887061361741931228979*%i
1.49909135025602613404623998595-5.95297136557708388922529937054*%i
-9.92137242347050127115518521993-1.75169569872290928270261365514*%i
-.407009162697435983459375261591+7.19341575460187899396117939155*%i
2.62779728642679880696237595464+.635340083837969888872295320009*%i
.545634862463444499980497088137-.511312559442534421170764123687*%i
.277615458352586993467655552906e-1-.188119757720189227638235047588*%i
-.148818145836972912366376769765e-1-.464346961347274176293078085444e-1*%i
-.243027025987843100256432134372-.899897861787279946389386545757*%i
-.814136210088002938982011388081+.615300177650573781704697362096*%i
.685734375675985162031889889054+6.99419291449199754428776698781*%i
37.6617673934110994455766139280-7.93850305377398695743720103654*%i
-93.1191494662673149268405425372-28.3489052928509317714696953028*%i
40.1940419071881746914077474681+31.4873651572404676131952033612*%i
3.52581534797826881188062179503-9.40515708930271870185563432091*%i
-1.11597513544342471757235060153-1.28583517175627590186580637519*%i
-.312614377581844180467039841828-.739371070454502636478179640606e-1*%i
-.681995052975201645051257198063e-1+.104698012312635063695251521385e-1*%i
-.664320021211174919848248485108-.314424665047840570514762486338*%i
-.919817876307288873322926972487-2.09326361562562975456069323950*%i
-19.4526604946537873255399503830-11.4325362348190832557854059483*%i
-218.503604747794676575037717775+400.396626905581849835044849996*%i
-5750.35216345518376820975204297-4415.62064886855644183245824588*%i
72.9935326616729387572308794267-899.509311525102151279783661719*%i
-36.6446433390598183911203326085+12.2263156054795553110363077359*%i
-1.54783906774445520657550030781+3.00921862128204091861219415222*%i
-.451530393675859556757973594046e-1+.472420217862874173583918276529*%i
.105177356914755347870253780114e-1+.872020622718144275884286367952e-1*%i
.266467201547755911579055052671-.503113898688932068770231415352*%i
2.64938481361783876488337322665+.517925807288459328954867417862*%i
34.2213142559582922223984426768+10.7858290051613951446709494068*%i
1693.55850754052427600083303307+1049.54840637915012831880042401*%i
479999.833333437909541160874692-479999700.000104166094573074796*%i
5233.96636740971483040521671138-4171.01410927302382110898289470*%i
64.1216934485914672036808326251-22.2307980628685182493219032764*%i
4.19027612619628112404712945893-.996036231786473171429252080822*%i
.529358906110726287719052748980-.100486708367601495382674027691*%i
.934711280874322616681106663224e-1-.153153960356061024578959926497e-1*%i
-.775908135835957723385256037014+.497067477929308898794444561545*%i
-1.51162577645210265474074698238+1.49607088392585118073919566707*%i
-18.3846118917012775985400213191+.461090212292516205080681224527*%i
32.6202656483444144523840961357-268.480539607154009846084193197*%i
-1935.10877562540515027490618815+1141.07036417713556001122616435*%i
304.900612469844715111145748959+363.864979462853951070816912782*%i
-29.6575817991430687780632120793+6.32145981577935363648104929804*%i
-2.36843177105543774241148868807-1.88311515106854497608958978488*%i
-.195306195259880576271466997336-.401683621187249008242467013778*%i
-.164828944984634667121181030529e-1-.830600813331508719523134739230e-1*%i
.911382023243111115649975062366e-1+.889173483944092126806335760722*%i
-.352484794514340510754940580487-.753311585876353708120955491878*%i
2.35905925953126972807040866736-4.97017963674170561314361726725*%i
22.3265059987039363635883051193+11.8084193635666882562599515236*%i
-53.8673527546252717278728469193+14.5116819346021679929506948697*%i
19.8029266857321083945992457669-25.4880968454836070890605831081*%i
4.89038722819923246236155716366+5.81326228389056405801972512482*%i
-.532304714689276223144283261027+1.34605437674252678136815951636*%i
-.248537501535008392948904094684+.151574240169755625649931466022*%i
-.641295407147277694951586236395e-1+.911206076477018647524434714202e-2*%i
1.73259861587093613462314308792-.203262618398588943607521218052*%i
.779619685967489186567800143358-.608863983995683027320484349473*%i
1.65100355598820355018021287402+.261826538884449873374973479305*%i
.361163280696046940525275670702+4.57612279674918126850108479042*%i
-7.15678050446742426649315630177+1.15181041501960936938711319423*%i
-1.02292146862515119825135005540-5.21970077672436056176428607948*%i
1.91695124103444731757998540819-.964031133660755263716160106728*%i
.562101549598300930543211045953+.299046957302848714410568911151*%i
.690042686270713035519400347889e-1+.155770780646341930867340422153*%i
-.198692903375737219074427890492e-2+.451425092167049799240208700464e-1*%i
1.14059382254483077203052313322-2.61929524764596979920987915117*%i
.186169522682366546338997160106e-1-.878700094034046977727799257071*%i
-.145091687766708170363808468592+.397449475158709202496855968135*%i
-1.00299456912937152693068183874+1.29723297310658849875841602928*%i
-2.14058279350433767213849010483+.281851168509976663186516693339*%i
-1.12361983692300445877462753954-1.17559097798182767783077413218*%i
.110747727576569042398509288099-.798251439205999334094913391363*%i
.237442742089371225570627690808-.190851997771224154376816890636*%i
.992888142949421169189961706357e-1-.862147644995083274454495085920e-2*%i
.286474273932587300870604375804e-1+.108140256707020447946938655999e-1*%i
-2.49952167822898347607596353146-3.62366190858300634815267385684*%i
-1.62430784194847987975345847216-.753695874939776569627103808199*%i
-1.07054853788728805298550790404+.353678329176455293850246204490*%i
-1.02006881792993263276670161645+.645805691885348170235890545481*%i
-1.07716507237265829032334249282+.279885318850955422909467445225*%i
-.727175694556840391772845802367-.220348227171805133654878863014*%i
-.244908789833323913846650223707-.309821644866440492178232839345*%i
-.166879310195224764486072791448e-1-.166177130112941663033502332064*%i
.233214611502666585427745089844e-1-.571069475240012904480787510444e-1*%i
.149189566274784937119482136679e-1-.148651597081096429081607368727e-1*%i
.587053501096342198179527116896e-9-40589023.2414170540616949561060*%i
.908296204569028395149621767514e-9-26750862.3881126099663400513936*%i
.140658361711133725929254956573e-8-17621089.9670397678711043617137*%i
.218029222574761386912766046992e-8-11600473.0685960073682895349842*%i
.338298218821856505959454649080e-8-7632152.40652589788897836354456*%i
.525469400344862912146527953608e-8-5017938.31649495877590545588036*%i
.817122297964825200738825207711e-8-3296757.22993660236196233601563*%i
.127218537743159995134828195768e-7-2164242.89541562517830709888004*%i
.198322567832922426805481830590e-7-1419559.96474427825014198574150*%i
.309592340895328863656331593666e-7-930247.426992611194449378728048*%i
.484000910915218275561774538983e-7-608982.832333950154922645067395*%i
.757854266655478483365092653391e-7-398230.394071391502714282017137*%i
.118866376727840012568445199628e-6-260101.613788546979641804772244*%i
.186776233517081065408152791385e-6-169661.158018279619482970382091*%i
.294059240462275160444266056689e-6-110509.140643988359401102236691*%i
.463945285711000881556791535376e-6-71866.9779223136047971332270210*%i
.733657199921586421154874779979e-6-46655.9812201966398026906604955*%i
.116305071734101439518456467551e-5-30231.1415696390078282833125102*%i
.184874867458794246735247376564e-5-19547.1430073727939494402654222*%i
.294738766910409856818787960073e-5-12609.3835558983305072440327177*%i
.471407861126314398037229455608e-5-8112.83357016766355404443301825*%i
.756645432706547451725067807947e-5-5204.62374284588629948030670002*%i
.121920995016546069745694831266e-4-3328.08742467605009699332288252*%i
.197301973602350119445867064773e-4-2120.39287625877861988957368655*%i
.320814161104250482054861741862e-4-1345.40932359091362833330639692*%i
.524418596105209015157010452275e-4-849.721322626191092491952431741*%i
.862334052908520292508980006975e-4-533.839362208460877467428095787*%i
.142745118159795664436706850306e-3-333.377842663208357420060888475*%i
.238070386899949164598646657296e-3-206.764675649127848739215555477*%i
.400447168680814118316497432201e-3-127.226712710851917493628963607*%i
.680145029286221933243753034867e-3-77.5711777565233041574222395804*%i
.116815209542611640970509061783e-2-46.7932067828781013158998690551*%i
.203233887047672271115096533470e-2-27.8744344152760603698632287456*%i
.358937219705030736038788939057e-2-16.3572343615670131952586198237*%i
.645228515728184863412533464940e-2-9.42316859280659553736804873624*%i
.118445662805085953295845283202e-1-5.29835356399181358454421075916*%i
.222979036204062411940284680516e-1-2.86975764114260504992135944817*%i
.432825719719644809687626096324e-1-1.43573350108079611661325587341*%i
.872538471146900862841948259741e-1-.537518577573800511541425203305*%i
.184453271575199401363703435400+.173210346834178364199327765328*%i
.414435215997729453683406290191+1.09413317031461827507685457962*%i
1.00897520904271448264534460474+3.02850273124589956338083868171*%i
2.73994921736013727647887943300+8.40361103024324571684861392203*%i
8.69086782232145104946933272450+26.7383397593763824849855384041*%i
34.8642030283086281259634270433+107.298589913861310001983880204*%i
206.502443406282967437529453451+635.548759387990185576984708645*%i
2611.19831066970611816836820665+8036.44202014001696660071519361*%i
270845.151634016035087564721593+833575.664307426841167950697876*%i
1071628944.78175282800375628393
71428.5698539418350513234046663
2420.67081198225762953277185797
287.190956412477036804367540272
59.1255300088004659896441367340
16.5551754854900790143811896128
5.62843036734157352418924150266
2.18411052134957911090609932158
.931972541667870461342559588786
.426882047178801716904685724780
.206476262498504535377878878758
.104244384252702866201119284038
.544725699771445964892490805379e-1
.292746091261773991653354499213e-1
.161021774165331160986557320089e-1
.903058765129647377878609025085e-2
.514855582594885547001347272596e-2
.297680134003423134120919286477e-2
.174205660567816287584958662491e-2
.103021375230577051019173551427e-2
.614849446918350744993652454119e-3
.369917384943992055921149590775e-3
.224145036349713671812287156024e-3
.136677560988258261195253627834e-3
.838135909543610095775128651620e-4
.516568040413155916803566122764e-4
.319828727985165492953791309577e-4
.198835484538762611060788746957e-4
.124076777960906319185643528163e-4
.776893333992778102710256368919e-5
.487952962575394680092426128553e-5
.307345186106797105631825174271e-5
.194091137565260036887435468412e-5
.122864312707003273482153263813e-5
.779481859153950659409559816907e-6
.495534856296319444868534577301e-6
.315620582054791457267128647345e-6
.201382003070969159867718682009e-6
.128702544720507372656804029485e-6
.823790132409764515824201396299e-7
.528038044127567557128766888071e-7
.338916801227473248267646996121e-7
.217802958550774254554212782209e-7
.140134110164057199288824838536e-7
.902615392163956438924195656774e-8
.581985626670496582336654350630e-8
.375618107967443751464489415683e-8
.242650740415687846360058847938e-8
.156890077273207036638029907821e-8
.101523750328088535099449307352e-8
.657474939942245284997169156329e-9
.426100993081368856741505565678e-9
2.71272839831876768845417923324+2.34817077865199628789547007547*%i
.450631258786350874163376651154+1.03387158244641894851818275665*%i
-.441133146900814150671550003708-.320282161642534434256353375308e-1*%i
-1.47475710621483729238661500248-.318489996990910754966523791828*%i
-1.71911554377059021478649500772+.912937690108483611407679791366*%i
-.262379639755452693799106980729+1.40096281201108260590901075697*%i
.428844135601808244129652789606+.533644528264544698731123012434*%i
.248409814405926155550797346884+.453793785518216400481130131994e-1*%i
.760842210835736904218122804419e-1-.292197687200489965335164937105e-1*%i
.178179481792838540304874759529e-1-.174541151481917423954609498546e-1*%i
2.16825658312050156884265069872-.845764012442895012707462024832*%i
1.03787863940648849952215770009+.719787103882512978351915867163e-1*%i
.913824096734063447512012168130-.935744991165474753029485156738*%i
-2.10817686561144325165454127246-3.22790761524031590205346909069*%i
-5.61451604338244896376597299349+2.84501827918194677668184662984*%i
1.83316878297966883607184579818+4.12316924033828306570218529435*%i
1.73193244394210051687017516138-.185436069268798420529879513009*%i
.269156746805419219805760375830-.423354611283928507441988439123*%i
-.555485623466776626253829475422e-2-.132811787130047786214985042146*%i
-.155385984124460137932714348770e-1-.317793139636555143273509644268e-1*%i
-.274317189893465146077128427474-1.27907353987359823084498709012*%i
.277115201907741044862666217459+.440602183783870591504674146016*%i
3.69892506498682812816599131476+1.89063505494218090975719502725*%i
10.0013629088613334451914413937-18.0843629848283500485202158125*%i
-46.6737546717020826604010105763+17.3452353841004442231327770215*%i
26.3131405846143963608354854027+6.15998468986417449375278985934*%i
.430206804353322593625913880980-5.75597694700140884781532094452*%i
-.836801308881509068605760768454-.652229235163162651739434239738*%i
-.213006048204759911352595324609-.199127977787353348191182331023e-1*%i
-.468551075376474128021453608231e-1+.122713092876832109224167315969e-1*%i
-1.24208010747724437350495380486+.330030017831696021503579025782e-1*%i
-1.51157940659358220568723865883-.801921820816603866958143562252e-1*%i
-10.0790289377011652843219190783+6.54477745353875192050410365223*%i
96.0723847448078024979666981875+179.585194597439839582382585811*%i
-2717.89755813093674678456649004+50.4037627454597135875061638242*%i
-86.6163624953348450748880789045-376.428832666268099452775719007*%i
-17.6577604192964227089359460758+9.32314384785868984356291011470*%i
-.723442946105603353753874682410+1.85463044722082747995787982759*%i
-.734536284262484112351964664196e-2+.305243022010985236081861443936*%i
.103283888627992095575313768363e-1+.594107302747279813328537296166e-1*%i
-.120659898729812164547296392755-.686449966631726106347201694383*%i
.136188529992605636914638424293+1.45654894306869100091551603274*%i
.478854522965697105775037693486+18.4318145099558445079808526658*%i
-163.458745629519571428888489387+785.031312537084451680842741341*%i
69089146.1378962982009066515445-50081555.5462654918181020958620*%i
2014.51710931957393786914308147-1466.80509499155925795380512479*%i
31.9847582032286314315479465933-10.3914491490616320905818858331*%i
2.42407452021928886571551084225-.545813109518728647926345812523*%i
.337371875707358867818657277400-.612132334705126079601089501750e-1*%i
.637945301964610655166154294168e-1-.100674774558385480905776973105e-1*%i
-1.27814863464717094688600927098+.234990685055362203653925474405*%i
-1.30892569636912059280383591858-.314099260435935709117140925758*%i
-4.90007380489355176642714143760-8.63981635677252401035763172076*%i
110.228272953446747833312200581-59.7810083796771027678765779554*%i
-905.575395871201883855235724261-120.979930599540486478941477118*%i
73.3648374631558549287907097055+199.644064461526156377908054032*%i
-15.9639942582911676987776899212+.261652671288149494095597778202*%i
-1.25728242383791671953037913081-1.28313690365605424799799394748*%i
-.103527084391031346367034677893-.269699195439026879148876169945*%i
-.772162639629908654924511471897e-2-.578171780917226675857797536960e-1*%i
.192529358967556036702429248385+1.41597865403645838363809854334*%i
.571826301051798521959533299537-.281741393305666134512162849441*%i
3.30976587762687124239645436439-.506518706419562206405367311466*%i
3.33576684523969158221816682459+13.6163137634103205627508805891*%i
-27.6312423002409495113217015118-11.2435373799614448593423777141*%i
15.8550719307713353067063739532-7.91917811048778016493611344685*%i
1.73684213870926017713222306952+4.11650162171679821728897538824*%i
-.504890598573090587872467495574+.762859556060048050545461350257*%i
-.180378856953284166308309050483+.756640677529669216835274057202e-1*%i
-.457208693102990223399515353757e-1+.128963843911117003335667405608e-2*%i
2.53927222799194432602352115057+.387089706410949901000463626006*%i
1.01528747186267233402219541492-.183014194683966907184401673288*%i
.516050277812668905287505676132+.803591054052610137226668432480*%i
-2.03826936081863554905969391620+2.18087623085147141622180372358*%i
-4.16125452295276471720897057609-2.17570121791504972624946391922*%i
.961420207088171454302525534245-3.29446134978032359158883124136*%i
1.40357616148964723072608700368-.162766296230133245709683822456*%i
.317824291785344009332595435833+.295087963628365122054367429277*%i
.264027599513123797398659275718e-1+.117420868639550039322022967525*%i
-.640802360410022218516372903266e-2+.323961925894651501571135013014e-1*%i
2.33971500056667606491304344601-3.10921601683641081860415565416*%i
.186118306784408390655804155500-1.26715832946908062672876917734*%i
-.608692144481731662859049480006-.124336155487056594369732045584*%i
-1.38128729982103572563646621592+.144854578994206743522917701798*%i
-1.47805328986686155757555074846-.757797840191784063922736941237*%i
-.347312956294965620532270543928-1.14684039000126241698788640045*%i
.282183260714445506071548296242-.514462888720392809148297560782*%i
.206215812499247840072360006535-.856757757352115628593983567319e-1*%i
.735518310498920450379324747417e-1+.100647181284574936774134946061e-1*%i
.199705224277899527073107597771e-1+.119223845506031115904309476746e-1*%i
-1.94550764012037952859515059664-5.46672397628725124666996078605*%i
-1.74277473156923911908419038169-1.75205280696199729198082676905*%i
-1.39329185565808227962716916488-.366973854193507557287462871584*%i
-1.20788375729439225549997104112-.518225672722049601818077525115e-1*%i
-.937353467723022882744239875084-.256246147827112863557389425946*%i
-.463839010320975550785162423635-.411456014419255872501932887430*%i
-.970564908835710688384163188186e-1-.296730595989210676765478191106*%i
.242978753193034540667895532486e-1-.128328199146091199857502101774*%i
.281417662764494864232044408718e-1-.392613843250063021087078482078e-1*%i
.137995899416123914477319396286e-1-.926987942795628079036431216389e-2*%i
-.138177874255614090110225552175e-8-45383947.8813872093305268186772*%i
-.213326522446540761636728438582e-8-29982400.9746840621402410035763*%i
-.329610072687757840693728610091e-8-19798886.3631028528204933659435*%i
-.509713088452492493361788171568e-8-13068037.2860208783226153097041*%i
-.788938032407071632790065740069e-8-8621022.65107589603899459427478*%i
-.122229427647446605270777003500e-7-5684181.92890398887074454157389*%i
-.189561660896991535400716494422e-7-3745570.96834456640342911611354*%i
-.294303517561838846394378082376e-7-2466533.55249471762705175998250*%i
-.457447841912739260380140753483e-7-1623120.28226431068679353098598*%i
-.711906152535909913041072048855e-7-1067289.37558708647917648323275*%i
-.110936901449754067298847361662e-6-701215.699362795807397987134103*%i
-.173117977325800531408020185135e-6-460283.945314822204950797740535*%i
-.270561498607053490496507104712e-6-301833.696963105140299330175514*%i
-.423542496033602420012933022659e-6-197713.297503279064691125619508*%i
-.664186291223884445678219511358e-6-129355.180084875420811757472639*%i
-.104353133386697575609397371292e-5-84519.9637386728129399431125824*%i
-.164290086434074191340798643649e-5-55144.6487227289116364187545156*%i
-.259228633321386535978429445053e-5-35921.0787076145600708442596369*%i
-.410019825333395093484562593740e-5-23357.2452653573426067547353579*%i
-.650237502416779067655687001414e-5-15157.7227948222692689782626504*%i
-.103416921084326227681004781697e-4-9814.94593959005340713091279610*%i
-.165000395086518712677053392583e-4-6339.72627786714842097749672410*%i
-.264174056643536109248842940380e-4-4083.67936793943144169130053762*%i
-.424585148194222171751933703701e-4-2622.29054321129011768331576556*%i
-.685314363561311849872157424873e-4-1677.96611317582498913498366740*%i
-.111140931367707743978286252324e-3-1069.43567086785632014398674930*%i
-.181200573296829782598048910909e-3-678.509249335585873426157288479*%i
-.297186488767579684329786456166e-3-428.256519265590193400270491608*%i
-.490698199805192239786478701386e-3-268.697736714525055431389416023*%i
-.816410193695205321016489076349e-3-167.430787823168534700209040856*%i
-.137018406539676114610074078538e-2-103.498930625045643870062355150*%i
-.232267501309218063256272025531e-2-63.3840711369654451088863400285*%i
-.398308348670666889244833651021e-2-38.3926495330584473473498705251*%i
-.692322034371227531314013786431e-2-22.9528440962792115348319989968*%i
-.122262020006576028061057563421e-1-13.5073207625328582947669876119*%i
-.220024900158082771543159388520e-1-7.79451814555551409350539697653*%i
-.405049839819518784006840284722e-1-4.38279013394926789670903416644*%i
-.766570821629843797795532104707e-1-2.36827305813926865401624744976*%i
-.150122600858913570439155358212-1.17712801991894362585410386834*%i
-.306927222824219058746744688844-.430115446408430217404176421675*%i
-.663238782429086470493658422759+.168532982218241286189390666165*%i
-1.54188937364409247352261147917+.980789030212014893497569746363*%i
-3.96074837203873967313296365842+2.82162143747203912302715194153*%i
-11.7308092639103656275336464286+8.50347086878544623170103140890*%i
-43.1184394773400273822735952136+31.3219552269976455842523207536*%i
-227.037225664030894110698446547+164.951149263515784282147713583*%i
-2411.13511401517887394016419645+1751.79210076189409710790808315*%i
-180212.462911487347576990187460+130932.018380430921079690289032*%i
164051896.703654650063057375654
21685.0205056711285809912699375
931.085562062073749998370731054
127.618609796393239772236887820
29.1074719121012721470665792520
8.81289337653705934776223390537
3.18882231973022868765961712791
1.30228828066648867891553289082
.579979834279498427710553736194
.275498347541720144155773770747
.137496849811977827848878673674
.713384829626238491531650629972e-1
.381816801696542524026687903996e-1
.209593446370425751955343787498e-1
.117483471597199575565484576320e-1
.670136397675185377074929038200e-2
.387936600568171708261654356971e-2
.227419293899783146565834656745e-2
.134771788428158855949586429414e-2
.806212764593213550679885126003e-3
.486251600504633050503176503895e-3
.295393044605851774565894991663e-3
.180593836675157503615192401145e-3
.111035017213845132795808614597e-3
.686131712769297412781746955453e-4
.425910922210083302825765282961e-4
.265459264671352995590412008634e-4
.166063658146466622050509260498e-4
.104231814107865657901378819593e-4
.656212666450857155106697863542e-5
.414278779777246793067251011662e-5
.262206191269600340227547838245e-5
.166343241709054441679282289367e-5
.105754523822221723336456059827e-5
.673678114577203273418785207960e-6
.429933348054660255973666874237e-6
.274844478514322939456732597161e-6
.175977740401326939818327370666e-6
.112840739478949875738188706408e-6
.724550406359537543707297350113e-7
.465829192069471660413395431593e-7
.299850372254376742082255460207e-7
.193227856628145340611322841691e-7
.124650016608086637229216438036e-7
.804905830907305267210031337116e-8
.520238887913345552463076228458e-8
.336544442340902377470009727406e-8
.217892640488404395582042095476e-8
.141183357377661328924344247384e-8
.915476069599996941169937316496e-9
.594040573316528756743491985748e-9
.385722635165542688681363654768e-9
4.29841913445714810384808014484+2.30074115783128313781547355688*%i
.945028250759684628313544306262+1.38105796808829745885487872053*%i
-.421820264808160527983579193227+.674843624820974116927809223552*%i
-1.11950360308533559603264247478+.737989400741118589764563388609*%i
-.716194602713421013507820576949+1.34609700667416110303098096847*%i
.283420812616129811156316610161+1.02304702524113302417069540217*%i
.430289728634975015894723326617+.260752740819305462672107428162*%i
.186216860936756117317413761749-.163798495596721772539354047950e-1*%i
.514813106763279305789486314985e-1-.333879275949664741468088318749e-1*%i
.113034992627702755286016912955e-1-.154695492735408697519437836093e-1*%i
2.75435891640092883362504486913-1.89268923518997788963965770917*%i
1.11761009191702915264789781097-.329004356114120473211463267772*%i
-.312758502233800030643766002200e-1-.662358935933570935913614769888*%i
-2.51209796868737788563467305558-.350444428248865907108280039593*%i
-1.82899583034131490295014075741+3.68245961081889356083131274825*%i
2.26538038635116691414901350703+1.85605764746423605192896021479*%i
1.04534150503868672637394681873-.493727340273362579423688838070*%i
.109672632572650600854535055745-.327420793560068970560023524775*%i
-.209972357264499257268115863826e-1-.926976541387713917115704941142e-1*%i
-.146369064256839996687035629153e-1-.217155800484402248363291736157e-1*%i
-.568662693397211007957110268994-2.02419152138454009877523217931*%i
.569313218832631365658164353301-.388540640210363027892990434131*%i
2.24835382749801181029897126587-1.28250643675961125386914906840*%i
-3.99844476276562329386582605815-10.7244912474412521471530950982*%i
-14.0868175735337424626760355259+22.3080706309611390754845083623*%i
14.4872445389666751850360499011-2.95072584596041296572029313302*%i
-.693333605340222344157399296843-3.34529564913381236905880135192*%i
-.604096563483165807460459763893-.309381811175712952510971204181*%i
-.145724208670521066012983635327+.599100830248540755542805873444e-2*%i
-.325477806587435587514461586049e-1+.120957305109833658797939252896e-1*%i
-1.70509570653107289068076342234+.390495306441051608054612382735*%i
-.662858644961664788659052144321+.707276544233690979155163752697*%i
.741799374025404400585891570942+6.51179000447883185343679035486*%i
93.4309633629615099511943094942+8.16992186605647150559629250896*%i
-810.223545887064464848619270437+671.573126441407857566143315548*%i
-86.5155935722807165516300671760-146.993051131457461353958025708*%i
-8.47485139747744013430649042164+6.40820596331893853601958576913*%i
-.321965536860036789717894698597+1.15847080935521696148509654045*%i
.904446408724350339143038174980e-2+.200964486152606752720865319070*%i
.932355198934789623453791463249e-2+.412560961816714530554333402424e-1*%i
-.375158449644290729341125768828-1.39570065224899838714742989487*%i
-.939515880211650183119630043432+.146028154006014801493129525006*%i
-9.15043462710342151903720380147+3.38856850883274612833383147100*%i
-329.226743953005884938777233194+47.7608934247030674559317761238*%i
14880296.7583969530533844542047+4854493.91094069915718259227775*%i
797.134793238621995841028822024-529.095947525791600982177512287*%i
16.4121881372939581737441886842-4.98277641818398995087220049743*%i
1.43946159246261431988587595595-.306542416223637342857047436450*%i
.220178792622452188410235193991-.381635391097265846395892955445e-1*%i
.444850465441198785689828211763e-1-.676191634767069808938626609653e-2*%i
-1.75030404245455929665859537533+.903527774187558318677801744715e-1*%i
-.359577141862329561139671064158-.599692014692466217455973376572*%i
2.96730023657747188416105947031-4.61979131219429155686213551852*%i
53.7965544501384687849279466334+26.5159729270161642075969270708*%i
-267.766212968576224008609674770-274.939175837565339493322133736*%i
.840315792444667564161826967723+98.3395505099519651481635509913*%i
-8.52303909444106130010947805356-1.50326022787207392258317510145*%i
-.666380341762061182709856621104-.868908578887610314639076944327*%i
-.534572220485696528175667960296e-1-.183713129295368137587289212954*%i
-.295423778216968992023396669517e-2-.409417383204063723261178206910e-1*%i
.164331428205042072439259508314e-1+2.32063635803499998578325414280*%i
.708954260665322791482213138352+.552802178075778165484606917254*%i
1.49580060477373669740754666178+1.51893821999085789707884291156*%i
-4.59590221516311083807945017031+6.57557679027657215655567021048*%i
-8.42573190726104324641958265067-14.2374414878955513232653135779*%i
10.0618022795908484642092935000-.207127866558992931444516518425*%i
.283585664433500176453044898204+2.69191717398494768745357930839*%i
-.420298543470615087984467258522+.419012193944528079830766446041*%i
-.130281233364053426798073156341+.335395651612512262481319609965e-1*%i
-.328739935537146294253420197809e-1-.264072145117733644992052870203e-2*%i
3.35551843132907483330178773991+1.33297407219004007958445754932*%i
1.17496365083025580829131679164+.717358495450088204097444249941e-1*%i
-.149526562187743679297782248708+.349808787447052966016112953418*%i
-2.06257231476137309555767320308-.877153349324512175408230646138e-1*%i
-1.39582252917457316529840424962-2.86651427154909501767900521383*%i
1.56636597613489406980685219340-1.67796298919200725260995906837*%i
.934288142186763979849286039368+.213616298492499807874084540321*%i
.164084104674159313818437351559+.254735354749238606851099823183*%i
.288934461309765945776210531188e-2+.868941022178165583100684706352e-1*%i
-.820788522954318058850381478488e-2+.232151272158941643454205779526e-1*%i
4.02677881059195861568829043451-3.38134195620064031740489148603*%i
.726830680592818015482510075912-1.76559852243609760981795129734*%i
-.514028408681054980014512415138-.856446434829445900494436497733*%i
-1.03387156082565450492099067736-.779574991366342946680476665881*%i
-.666255354607063706480736525205-1.16427681200230309502787928302*%i
.141069313287669729716243919145-.902665015799641347451896296327*%i
.329928197315065935778728425416-.289788927736043502852484712103*%i
.166316647232026694268777131304-.205704315083624123337681174401e-1*%i
.530723379882381717568375390268e-1+.192648852619234651899998412316e-1*%i
.136891051435959119767825690377e-1+.116892640320108253886236621104e-1*%i
-.638682766603033618255748535356-7.43683525485204018465593247477*%i
-1.37344866116517447818940192888-2.92136802678957631593728033057*%i
-1.29105500444294971637472288136-1.19639694194484310000700131596*%i
-1.03593460140528146510069892853-.678285028574111110570148839909*%i
-.640827277230989402802761845413-.594561631882697393233398244759*%i
-.221312491522547145015497490629-.469979928697235988857896590742*%i
.434930692285582159858166748264e-2-.252520162760723814785167089667*%i
.461966617174054208074492009646e-1-.934668327964229590793844899958e-1*%i
.287909148189356880729501889194e-1-.256186462959997060363633827567e-1*%i
.122427556339116564735509798971e-1-.531799089337305626690054506903e-2*%i
-.125193418404244053253870267891e-8-50337479.4790011540521006484505*%i
-.192890256888324148687416349111e-8-33328798.7878276077342008718582*%i
-.297407529240955946466952598055e-8-22059706.0234329455901661190690*%i
-.458906933867480360990459530825e-8-14595513.7753168261837155357873*%i
-.708676267994951756415078884327e-8-9653064.03116663509273660407294*%i
-.109532510490199981250571577601e-7-6381492.74428904666409909493572*%i
-.169446729475389657510289229167e-7-4216715.40139867272267524065414*%i
-.262387715343218044248024527009e-7-2784858.37345335422335031162259*%i
-.406725506807375415656556982372e-7-1838182.77817222259385351129550*%i
-.631156302310392066525953091852e-7-1212575.41926124970141148442453*%i
-.980579712715285946106047272129e-7-799352.869059175990251501946534*%i
-.152537082097516537536194499945e-6-526563.064456045273054358580721*%i
-.237604263757591840074896123992e-6-346587.924508773456938725853487*%i
-.370649238570785845483162305825e-6-227925.550023656713988235646057*%i
-.579096002587611107345955725051e-6-149744.272994497716489865939703*%i
-.906296678428857321218026920852e-6-98274.5778877668897655535837130*%i
-.142096191649360536343720852659e-5-64419.3462483140701280842744989*%i
-.223230505191313130408255777147e-5-42171.5301095248412001542800981*%i
-.351445950603529849258961755378e-5-27566.7987488595795415146391723*%i
-.554602171410614945910466647158e-5-17990.5395035211752064368664866*%i
-.877440168875232289103080614174e-5-11719.5030790933656841544408978*%i
-.139211104448658684733976976748e-4-7618.77351822259722150014637211*%i
-.221550604254409361940307203211e-4-4941.51990414628047852598838807*%i
-.353797212047984323719518977835e-4-3196.73480452974352163550991111*%i
-.567124880584151661997107408304e-4-2061.92494315648197674014191923*%i
-.912916332375659513135738213634e-4-1325.51042469168884999676122934*%i
-.147647513904866692829266431541e-3-848.848432290872218344242630339*%i
-.240057420553312326554753305810e-3-541.213250376763439115703700576*%i
-.392638546065951888833112252498e-3-343.325223784389134286591088251*%i
-.646559827489835365079860480362e-3-216.516943351814052252741128110*%i
-.107294902571013436096154114817e-2-135.614066757545162860553133483*%i
-.179640950610824481072140129734e-2-84.2620213281273013636908205436*%i
-.303875991979256174307576371397e-2-51.8618400708915664989016798442*%i
-.520235046996828506161563150518e-2-31.5636735521191771690574155961*%i
-.903323040783613900839469358942e-2-18.9548258261744615813954169304*%i
-.159512431245202717756208560212e-1-11.2033943891262602704349327605*%i
-.287438626002061341472723954410e-1-6.50054113172277968325098537394*%i
-.530923466209558788570575547005e-1-3.69854375609936952403227402253*%i
-.101116389561616807576858273476-2.07778994444396007597141269504*%i
-.200168363131801543812369102201-1.20070092317446542145164931771*%i
-.416495807575281693449913612143-.830544186724271021450174316769*%i
-.925726173820932405165979934417-.919384390098815187199331152106*%i
-2.25216248805829161812795982924-1.74143032102618266387937578930*%i
-6.23588213190850439756938340624-4.56985401355369207481014308281*%i
-21.0248698906714307678440881147-15.2874254298175040454291722228*%i
-98.5086785417020616335839468937-71.5733564626105062812324840489*%i
-879.289071330390467206150575457-638.841202261669208205665051306*%i
-47377.5131170859577053445025553-34421.7781562699458951202202824*%i
25981326.8403943402912134723617
6808.92408673150754311743752741
370.185438531494700960644786044
58.5685045878993021271616674675
14.7839557442220692794454944571
4.83458747126229411527713795574
1.85953267907242593753888603009
.798248764562368995104089712021
.370592498149152265425027365127
.182345682187099585029253246372
.937980217509221092381389763319e-1
.499586639224074443839269973781e-1
.273596895194749027230968808286e-1
.153261262996611626849393287588e-1
.874684721473030810510357979419e-2
.507027857119452388280653905479e-2
.297796334458332900917027868810e-2
.176877048598996867203331873039e-2
.106073297674964482036809481145e-2
.641452815235465481360083024198e-3
.390738091950071699845889604408e-3
.239543301488885557371402925568e-3
.147684731967662376404839763294e-3
.915094456211686380127011127936e-4
.569561669030564931944461677823e-4
.355925362788954942403058824610e-4
.223227003676079571427181447504e-4
.140460190032346328188939646601e-4
.886434820638950308061559160922e-5
.560934186952226823606461759722e-5
.355833502272604931844054535337e-5
.226235949579784213637804820799e-5
.144137297409338646439547346744e-5
.920068003032781472470473505571e-6
.588340340137335148478034000935e-6
.376829918779809794037258525200e-6
.241723458381182367548158019019e-6
.155275354799738183712273208927e-6
.998744991021319522253582352433e-7
.643186595937889940712238617193e-7
.414681843371157019247612458698e-7
.267643780119517958818015416382e-7
.172915747532745002913500603702e-7
.111820333455924937057550698771e-7
.723755087082251066812754358832e-8
.468840157611856625387310839887e-8
.303948343081945914762595183898e-8
.197195781534682979499944501841e-8
.128026777744588977406549111953e-8
.831750659576974617876512564976e-9
.540704025523755356909814062752e-9
.351711199881969394632263037208e-9
6.28676708641615623572294895180+1.76877974592734744375759267524*%i
1.84960145140747120655971104816+1.57220835944543036355551014308*%i
.141596889046716135289400933666+1.21744664507863174985416960547*%i
-.347961521227356796037899076814+1.25446831757251397046233301015*%i
.901548961604254909059756481050e-1+1.25122861771885396392338602615*%i
.529760643860253990665079244365+.624269903761518511017722746907*%i
.371786956997025217203806184814+.802117127580962421023365599559e-1*%i
.133522284817599564939526736856-.476590817519088172117369616950e-1*%i
.337772344254094682361547612533e-1-.329612004849016988744716473423e-1*%i
.686574902930162939406559448783e-2-.133396958141604844053130413938e-1*%i
3.23537672719037494171993118394-3.34042381050499054642264075123*%i
1.30004413597552326836930012081-.652620071058189543755625170089*%i
-.121953325771436601328388539019-.860889905581523960711054241475e-2*%i
-1.32187022476594970953424453232+1.23373542140054875861905415973*%i
.483887363357644686314602857582+2.78634589568139334681439172444*%i
1.92149039673960966068933342301+.454780781953611398266943016664*%i
.571147331250873493364647125099-.547835916085800098174209194789*%i
.218968918657745075278242118877e-1-.243047193799168464096041887435*%i
-.267964257918155814285673642621e-1-.641838793402360269267980675258e-1*%i
-.131172456525130583022860598066e-1-.148207809562890424547814441256e-1*%i
-1.31073536564061321295366338311-2.97466962314047472544096732287*%i
.216406858727093239730946206642-1.08519063056609793049127080946*%i
.210337165278499821444685753743-1.68245759212065636196531410996*%i
-6.15675461177173675317669042633-2.20731303226162722196733876412*%i
1.29110563695317783990253782764+14.4867836103562492509232323057*%i
6.79078074110391325414033098503-4.91831731960328690047424738825*%i
-.958022075808364429735936135507-1.85361438678615764515809042541*%i
-.427555120148026230127042757292-.127868815157400709430646752401*%i
-.100402155007296929124647476421+.172395336588589971832947559282e-1*%i
-.228945916125925620610028558882e-1+.110848058248345327725698340157e-1*%i
-2.38257125996907018458918425227+.690765689890397428149828974519*%i
-.184305831015151535050487530893+.380338511631535083944995443937*%i
3.43816417664271881371620301161+1.19617932584544295130323992669*%i
27.5079284319993118405137521187-35.1768181154791805834767729121*%i
-85.8432649494679906089978643515+413.038539000656606420452419791*%i
-57.8036117560231978269015246379-52.2257760355701429596403405719*%i
-4.03564222611820021987212166971+4.20906520463560424884306966532*%i
-.128509899808109455246957634369+.735525110877471542392571926515*%i
.151189648616005411789431149294e-1+.135021736798850583794764406570*%i
.809688404735556757394819958462e-2+.292318709601953991551949386796e-1*%i
-.417699301794891212565382370945-2.34811643427838104076173487596*%i
-.496670409319604186808111944915-.887269330386325176193894410797*%i
-3.39544320142030581222096578495-4.16275925234641528189828967183*%i
-67.5212497417680885544444942631-125.615473826084890040431237516*%i
914122.426986904114681008447909+2826026.57243505090597827593826*%i
325.128948930077694758544685072-196.125095575364180686130840474*%i
8.68025260657973936534662477417-2.45536774821532080535028022840*%i
.878704058446897363272567203043-.176724850416713504382889131018*%i
.147303928374670724804378095687-.243823458704450858143717047095e-1*%i
.317181470850731797612992630002e-1-.464526925722464662635411319381e-2*%i
-2.53632226114875792229469342145+.441159900790860895676401136972e-1*%i
-.112525805076889047655427929047-.337360860465620738547631118519e-1*%i
3.11278121845178003987442901832+.350978268207007661793583225901*%i
4.59889685937428458053523662889+29.3114483345856749200198690457*%i
-17.6858124676988906877587742778-166.084755047399259393761878217*%i
-15.3724415537165169879025811072+44.4646450815067857234311666017*%i
-4.52507499492961772974715453507-1.71503177227718958399052437740*%i
-.350828812802567399347334605668-.589780464774722425616740146054*%i
-.261710858978701710806446428711e-1-.127228825880262516051464991488*%i
-.412165048045063375690934243824e-3-.295289447474257754154986524594e-1*%i
-.572663057070315415317120408087+3.46309915800679370820534564027*%i
.375821169879019250891111532051+1.17990887135285196735873880307*%i
-.105487986794078012019603551853+1.36341774597473904711221266588*%i
-4.71418920479968048639752202167+.460483652019763071432570271140*%i
1.10345031331467686523822436180-9.49945843790942422761517975904*%i
5.42188347370065772945386783203+2.39553211799290340735735171006*%i
-.306532071431262552873452316398+1.66419650154021295716042814605*%i
-.329155980922382576075014591521+.219604114783242756940482180375*%i
-.941789120664788529693120412073e-1+.106570595559633723809298997483e-1*%i
-.238887274273618509800949516234e-1-.443247081429368411285638602708e-2*%i
4.16671344312059502685052612799+2.71608023967818160606983722759*%i
1.52660930881197387042850317728+.313893699549954104350947626669*%i
-.215790595457536827896976034302e-1-.273006427776208207954907872058*%i
-.950692151777693702733898592720-1.26563657999433186166786062481*%i
.387617789752055171130262818380-2.25044155932476263614015426040*%i
1.48884358807648665907517515013-.571783463517253925367606008631*%i
.570502911933104973125740272600+.351836769340138872418807452787*%i
.709235583606793943584803430578e-1+.205393711355999810520644289279*%i
-.934419653471825115226504794970e-2+.635766988706632798269044541429e-1*%i
-.860430529897831641525977770112e-2+.166464056023115146662185468719e-1*%i
6.20976652108634477409833853206-3.18963541482952555253773472639*%i
1.71103448826636215084682003277-2.09640121729401580794628357449*%i
.835496114317071100292320200418e-1-1.40989960726613787252093470198*%i
-.331714978524195257562060263586-1.24763002519309037688148459043*%i
.236467812025990142160115632569e-1-1.13316887084600717205850910758*%i
.394974331601146185624577790247-.602294582695702682992799676667*%i
.312377764494154779804779972605-.128406610531082088561237581766*%i
.127620491749375527506106936709+.171654504849562548652842832113e-1*%i
.374040485847910102736191224823e-1+.228855921556850244360645043803e-1*%i
.919874221980175298041746536704e-2+.108144430417266441835406157755e-1*%i
1.48986210934933299740571843719-9.24119948062222528272391243966*%i
-.473122121157703072054121093553-4.01679358532985767369728096911*%i
-.802481545365250848087029731203-1.91736085279924866192766062408*%i
-.633859607487044678043855819308-1.11308454690062126862313117080*%i
-.301286443370595112047210833296-.746773002696659569676315841175*%i
-.282765453706718565424851749222e-1-.444890832483008115619979069035*%i
.675883369240375863841091934125e-1-.197625758290677248256583521462*%i
.556451079389199756916120631889e-1-.641476742643036659749267627842e-1*%i
.272001149722365003156977353856e-1-.155262307997012031947701597255e-1*%i
.105914925296312869101877537848e-1-.258075109183287077029975869634e-2*%i
.436637895638161957854570168279e-9-55380485.6194397438496555050450*%i
.671489855740771421896198179707e-9-36743192.2278098634361541063584*%i
.103332418170892424788534450581e-8-24371801.5121677592053333702902*%i
.159121481422276896638282226573e-8-16161411.7757107151384894938822*%i
.245207307779903598080345619117e-8-10713741.7750599638204145673033*%i
.378154371180207388975140819452e-8-7100050.75827052889584873282340*%i
.583655146877980655261070990622e-8-4703564.02314535809874081808860*%i
.901606735522656738347705633918e-8-3114752.21310468461223829253321*%i
.139404169909576619512187899269e-7-2061743.75326723496613492000801*%i
.215753856113015788607075299153e-7-1364088.96569397101723292739435*%i
.334267734434897943624605586140e-7-902043.620756940958359125871187*%i
.518459893251934156551989979610e-7-596165.534842687478543599869938*%i
.805110704680246239029800770791e-7-393763.642928485849022272748346*%i
.125185570429601143781900027902e-6-259899.606354381525667708370688*%i
.194918821494932304517796033506e-6-171413.548302010367076035759295*%i
.303949451171747627872715087640e-6-112958.341322457827976817812911*%i
.474733196316951469206220768215e-6-74367.7140848162280451749581161*%i
.742774803403633669818455877294e-6-48909.9549929938758734808316161*%i
.116436663934023933299542037448e-5-32129.5032351695318078734118777*%i
.182903163288230526867209533192e-5-21078.7193747724947908924649999*%i
.287961783307236612389442062905e-5-13808.5604407288061715011936220*%i
.454490721271791361654028587793e-5-9031.01079333317942925376288237*%i
.719281760840873246364137042134e-5-5895.42534302187549276451536933*%i
.114177252504655800461483108257e-4-3840.40080704275272661188753402*%i
.181847568355848969951332896451e-4-2495.70948387435203796020776080*%i
.290700241904299645032621804354e-4-1617.40508158017181655117704620*%i
.466640127093936236669013281880e-4-1044.90077252363618101151440616*%i
.752554809487508596376318436681e-4-672.595245644620228845101494076*%i
.122003687471370864678213856277e-3-431.126926903790227171814333986*%i
.198972856310494138986256457479e-3-274.997290828325396477287448322*%i
.326713948071150886742254181345e-3-174.405166520258440675404950451*%i
.540675138073101715895369767142e-3-109.863595354326433297863450310*%i
.902895304079988873824735420733e-3-68.6541961464677689042464781648*%i
.152381105408617654878712765766e-2-42.4941295025203974140350814385*%i
.260398799542765019345855751413e-2-26.0026863918483874774282125333*%i
.451643996274269286424392529595e-2-15.6947811669422209258268189147*%i
.797494374476896347044351491619e-2-9.32144147635269761553183742822*%i
.143932167576203534521417145383e-1-5.43886861025485793561003539132*%i
.266918153216043522856517682826e-1-3.12860328906116251272909909372*%i
.512277124905046292147405213581e-1-1.81935150492257829704332836363*%i
.102777990479069964305443053379-1.18252769801764406781570721561*%i
.218718092171811262905734710839-1.09815163367188038022818298258*%i
.504699679071227298883541226361-1.74514129123606616878407171263*%i
1.30831689684477992358174749580-4.10339592232111139338308354608*%i
4.05184465962813853192359084023-12.4959196308987146115087284912*%i
16.9136790740382137212474044914-52.0612566253577120775509162314*%i
127.014014882751666711203053840-390.909798861535427465087553075*%i
4936.62936334811958851027011130-15193.3829429974410302741031677*%i
4270190.80415763940413411177928
2217.94945067445953508816854728
152.568670485493905992449608616
27.8324226060240149964296053028
7.76500841776523288840327262810
2.73869833441458215086001868802
1.11810493551517687871903896250
.503780118290014914845891747377
.243465710630769419716069491126
.123920505156759009060284220887
.656163356544039502957409449992e-1
.358340109313613100449510470911e-1
.200576195847873058715770097868e-1
.114537239116165596697413643928e-1
.664913028772788539254661746305e-2
.391333773492951159844005819383e-2
.233002481081480197204762076590e-2
.140106806638348517041921105149e-2
.849651714757900282154225335355e-3
.519054668122765754184907227081e-3
.319130944277054559229298274480e-3
.197319181413863396151438397363e-3
.122610952900484129445252393481e-3
.765257217808173897801236117201e-4
.479510311663873985720672862729e-4
.301525550917354176798521399361e-4
.190210009431997514216551914877e-4
.120335349232249969544496980982e-4
.763287376243450527978049433301e-5
.485307012320390874694376333948e-5
.309235536757798888264810799159e-5
.197436570254538510147862771267e-5
.126287699018460457415050533991e-5
.809146687174370866504344661917e-6
.519242629117618163021945214610e-6
.333687659270778062005816840638e-6
.214729417155000528700684136930e-6
.138351477726856686966061227337e-6
.892442085224370474619864067635e-7
.576297586529769788951136133396e-7
.372523462404779985456269224029e-7
.241030923682925971046938685356e-7
.156091344894067233483526497343e-7
.101169255299488971965627232836e-7
.656236851631008024438119183295e-8
.425986051244695661423796629873e-8
.276716308624554532272761581723e-8
.179871372210398507627474980379e-8
.116993521470114626333730340499e-8
.761412054369232065264636030492e-9
.495818333578952266109853795166e-9
.323041249744975818720401737666e-9
8.54240215855912453682774241594+.527946086069209027576571472571*%i
3.05661288738775054345498385401+1.34898615106619367714237653080*%i
1.00184677101461023193674619123+1.33898378789919299278179952920*%i
.458824583562932116808048278523+1.25001979197341394446384683750*%i
.601020350464556929289774898893+.895407226607873895230665823645*%i
.585322641002781913163536493944+.289826677713371765852247328351*%i
.294165961159935101021085708162-.297636019215506005108538561834e-1*%i
.919483201797630857974889835762e-1-.606650160682385710071379160224e-1*%i
.212957441313390285140589570718e-1-.303662788090494251389223971370e-1*%i
.387299584640480514669255351491e-2-.113350772420186247196992788953e-1*%i
3.52741687336170320791114867579-5.28492007060114611264960386104*%i
1.65240481585019578612892216851-1.17581922031803996330789887312*%i
.423673011293796140532510682105+.293106086706902946435948893786*%i
.113766869365970955389954358830+1.46452918010809311578662566531*%i
1.46160223602980916862938108079+1.45321687170189745210028828324*%i
1.35656709157231639342305546965-.282776336554965777539965681480*%i
.266436849631774930600531337975-.491844791303008100848193004388*%i
-.233912148978110879650937977965e-1-.175650662055951640310547446821*%i
-.276459892908517387166719024830e-1-.441814334686232764549043463627e-1*%i
-.114611325508161604974448647693e-1-.101004692151258606165349350208e-1*%i
-2.54844167418685660308054370383-4.00587630027510763182183113441*%i
-.333865654140150239765606208384-1.49611639849209676618413932655*%i
-.655467125034902727103310834312-.864752167874447345523547627376*%i
-3.30004310305884163838968845085+1.99620016347134823569641392509*%i
5.66336606631823660048903927792+6.19207901696989485066320691696*%i
2.47868033495420224876034075072-4.27946840750504451076575209800*%i
-.890188910976796657233537164494-.971211394978733273024849629588*%i
-.299974046146710499323291328255-.346393914625880559796116419046e-1*%i
-.698557534680618846593698766606e-1+.210728209629042018121734350581e-1*%i
-.163332959159617266627153604721e-1+.981190153047935569762788553639e-2*%i
-3.48726846925185436697377641305+1.13886028346889082792102679934*%i
-.539753616884397130188827500748-.361954503840325758576943915426e-1*%i
1.40749508958672907200951167514-1.57902083647665139918792234350*%i
-7.20872974815222191569434149335-20.8414754059817435420350423073*%i
79.4563122847922426938921262536+156.740837234225775941528908740*%i
-33.5071993298949043937850303462-15.4882927411233053340415284307*%i
-1.89133888339228603050251514142+2.71403387967656131526053231555*%i
-.372444326963718695252016950527e-1+.475993361703683390456531334428*%i
.164134225791059588517155187774e-1+.927221134921331470371863522515e-1*%i
.691172100451506875983401054508e-2+.211568077381940569080878663144e-1*%i
-.454762381232340876026266818342-3.49868393918115837087919750895*%i
.591791732696263497669208245685e-1-1.07912878881119985772667969089*%i
1.54507084011908791091204922143-2.65653525672331074708528071150*%i
42.1779712390986561110034347854-47.2611973940542250794768257045*%i
-344511.040344752654155077027201+472715.314182764372540945057070*%i
137.103720279080037847109399708-74.8689925299683694742696857896*%i
4.74242009584522604409937187300-1.24597277192005821555071729058*%i
.552281883868881005419725174705-.104769587916152975865452363112*%i
.101137105805568188020672474187-.159858123849102367731019055186e-1*%i
.231424923400045743489558057404e-1-.326742905025184123287039149165e-2*%i
-3.80805996312270335308394644446-.128803267548459023542225255508*%i
-.649706335086700937058397633162+.403061541870355371229511686230*%i
.597514267978666657959267253506+1.86116398654788809274624726778*%i
-10.9607668546859694964049360985+10.5623436987958083036302513657*%i
40.1782269157350108388461127552-64.0261329949392915407965251399*%i
-14.5293720502058525842200043390+18.2907935731310003533161559918*%i
-2.39055152464428387878604151108-1.45222561979335689292635033801*%i
-.181757529202249952418423965373-.403782496503670584552893378214*%i
-.113756473102827735650877760073e-1-.897637750580056882290864703863e-1*%i
.894829007055481799668797818496e-3-.217187758088074046791985695006e-1*%i
-1.61648751506210875588339992398+4.76624605577660803812513391603*%i
-.354734452931525387058878863704e-1+1.60951106996469409737401499688*%i
-.520742752140372511834598713120+.566791724940663099370412950578*%i
-2.02938802699617619780538670169-2.07556041457674596900521949812*%i
4.01492140265521666272519563489-4.18814714750310047868238187172*%i
2.41304797448998463015462571756+2.71547249434308881726802955378*%i
-.485876626119284669629601016484+.979710079285473458909459569792*%i
-.249929256217914981266850418066+.105880350121193954371649165411*%i
-.684448337165661470042634539232e-1-.136605427213994220113655730066e-2*%i
-.175799161104106175001138803526e-1-.507841872739951010990964869206e-2*%i
4.87337909433090102653029610349+4.66545435253837121224881211727*%i
2.07819213141883098179552771124+.828549959734974588880912855857*%i
.630538378081859550008727058743-.484052932144476017559675979655*%i
.290293419326594856469362297387-1.36069397048811997087104712760*%i
1.20839724710227161842400349895-1.24200330493909093274743002273*%i
1.14999683488420396737248892731+.784584232080118415764734036927e-1*%i
.313488429870751302463305375583+.368377652451016922258953272412*%i
.167150557056841711537149757713e-1+.159157492765982111999883216424*%i
-.150808553077819435492253924215e-1+.462172662432880787343528344702e-1*%i
-.829708727540043756495072878372e-2+.119643863065606118588508478716e-1*%i
8.75392799310749282037796159910-2.29305729587809836191877547603*%i
3.02447509883925330101251971603-2.01048773218920229690965466042*%i
.958935926946949674962357619721-1.56441674539398637859144429345*%i
.413388991499668632108958422638-1.26736771815747996090835463613*%i
.492761165968049260209254855012-.865059081263940145680669051111*%i
.486253535478275073170598797006-.327262757641930755126115518229*%i
.265999069769851137885003098121-.210955229656080749369239631053e-1*%i
.942548209949865818617928307375e-1+.371155920084873225441722418681e-1*%i
.257366286967091465982255666611e-1+.233925854932387099557899611932e-1*%i
.602013050260771462683808431138e-2+.969599023921350710119892132539e-2*%i
4.36461781095420220276283078050-10.5887862424478078058684290543*%i
.877186562949441877512422286224-4.82377130799992757331248275092*%i
-.477697526151825800207093798467e-1-2.39066108335366639857345863007*%i
-.132915850535659956697536810222-1.32245879351235865234941727695*%i
.106058286747979001907159326863e-1-.755430207483107475694157535591*%i
.109220672627577235542739978270-.375250719771702182077880660830*%i
.102404938452566332730473851704-.143599429777191638251856325625*%i
.574805970320888814955442520831e-1-.408799293155072365942465837803e-1*%i
.245703719043514626388514110966e-1-.825776788999428764551871691136e-2*%i
.902671358834982423613843759673e-2-.721254632644576208132458966683e-3*%i
.130029005202634778978324202177e-8-60433810.4176886488290340421920*%i
.199625087035667827862478823477e-8-40171562.6796708588231639201941*%i
.306646514557663096629073532884e-8-26698316.0198910660736702703624*%i
.471327718413735106932377776357e-8-17740590.5163105849489847314117*%i
.724911690900762308079443196217e-8-11785912.5969240910646588956711*%i
.111568297449542610827462605811e-7-7828171.01777401241615166223091*%i
.171833522897618885142950354107e-7-5198156.45219370271038059072611*%i
.264853511901295635686675899833e-7-3450795.51323313776276207189603*%i
.408559617432874522466234426113e-7-2290116.34324679018751239346212*%i
.630783103453551833281183552513e-7-1519324.23456396012725888110088*%i
.974775951344997022558168431008e-7-1007586.82437291962146620977677*%i
.150784736737298292331244781305e-6-667938.060822050991185685847223*%i
.233489965598634427339416166475e-6-442580.245625241663941687413274*%i
.361968592820797724013330691483e-6-293108.155385327768219367254709*%i
.561826859450513276957808218205e-6-194007.646705853014282965111197*%i
.873180833536303918893313128510e-6-128332.463740437962182047917722*%i
.135900714791648222636802190539e-5-84829.8542130916478395225183492*%i
.211839134996755910934919206385e-5-56029.7413965339296122382747010*%i
.330761316091452372597934350682e-5-36974.6505413958300036418037581*%i
.517382229212005709877498696322e-5-24375.6750500526616761195963780*%i
.810903186310321058614551715909e-5-16051.6776920421300477089245760*%i
.127370607877642816015961753461e-4-10556.7597245332344940514226538*%i
.200542039396442831135245622268e-4-6932.85138540663727527805261582*%i
.316580531253608048615820796044e-4-4545.44150414535417562450034138*%i
.501219478153561729689948544437e-4-2974.53902512121655012704748129*%i
.796118901799868490239764711577e-4-1942.31853450029591780320188953*%i
.126910706982593604169536010466e-3-1265.12457280221245425214067243*%i
.203133072708600863691019364174e-3-821.646170944251915777948060935*%i
.326625877180329579418247147427e-3-531.822527703359973822684347477*%i
.527928844990632391027635162929e-3-342.867900221700590643575210064*%i
.858369650081180231145822785195e-3-220.017770194561857089431819138*%i
.140518121084934821580098486540e-2-140.404772638374191580009798937*%i
.231855684390521974907947213118e-2-89.0084369182792754887648638558*%i
.386106319845307973530102089262e-2-55.9783767341745066859058410117*%i
.650006217572289332032431561196e-2-34.8665913313913870569454906433*%i
.110855060109827579413293116562e-1-21.4611567225313397525286100120*%i
.192035868455550129951276904917e-1-13.0174742968365275485765753436*%i
.339088760435584253903162551565e-1-7.75213080644924776600958193246*%i
.613150063026340550033690115307e-1-4.51008225397667839714288634039*%i
.114260375395699109679999968599-2.54612323664594953346994450073*%i
.221393910721942970170923620719-1.38163349121051053883557952984*%i
.451855492392719143953625591421-.710849805715435361019973882804*%i
.990712470049410519254495677708-.339679992590421622213285924533*%i
2.40874838548034405407649458465-.145872573532594102940010874070*%i
6.86436410399028390525131138417-.531868706518377848975945488373e-1*%i
25.5699037088231268082800759292-.147403419152668083582292690034e-1*%i
161.758482720453887821743807578-.238592232395995623240959027801e-2*%i
4538.82214854696577653693607023-.862265880414920317659257162900e-4*%i
731102.215995554053639982600819
752.245097910403946071424805520
65.4011829984643299700364525078
13.7365354691175281195824014279
4.22860822049431108279373424351
1.60566925786124961204006518418
.694559180812307417226004353830
.327895529049095326591525207002
.164684060760066919624585010221
.865741850917250703560262296586e-1
.471193460604021223912141364608e-1
.263491474703339928864443981870e-1
.150555245018035703150625503689e-1
.875411939339808452026430480882e-2
.516382009246108307716277392024e-2
.308270871601972906420417021912e-2
.185900343739297344864555279093e-2
.113074180204275337073272320917e-2
.692878068750311140612631366543e-3
.427298270010486816222856873330e-3
.264991682617139289994220407422e-3
.165144884603523150516845705336e-3
.103367008231871635191122854669e-3
.649490618291991848966431162142e-4
.409504829714175030590093841395e-4
.258992294532223900752239094928e-4
.164256950810656645455595317820e-4
.104437066055935471982485581899e-4
.665547568980741108977221461930e-5
.425019611003811975821814179112e-5
.271935966462760424608109345080e-5
.174294419660214972360859235360e-5
.111891855375556223184682933831e-5
.719378177539418312440956395541e-6
.463138829378023948349314243262e-6
.298549686245492015734012278265e-6
.192678929980606215441519148938e-6
.124488293980112399954639498850e-6
.805132469205756323429613762050e-7
.521220532279958411707664819142e-7
.337725979180065770455910252028e-7
.219014042398754080396948919900e-7
.142141803031424946134555062430e-7
.923195601982483083952747350666e-8
.600024550022224988845049756835e-8
.390238870441365671820725680261e-8
.253958299999615146105895025778e-8
.165367458204809297645630884982e-8
.107740729926929240826426617301e-8
.702327149230789544542438371676e-9
.458054378509130514002971340515e-9
.298883427809882172571256133136e-9
10.8171594140812036343018640683-1.55461652833276219210451175065*%i
4.33688925863763170675635392268+.577640465671702198633585760652*%i
1.87570001413649947288238312011+.992000919477408241357956627849*%i
1.07761045181763162880159310654+.883400571550194169165508818920*%i
.839999309464057559469266282800+.467684676309832024926668083262*%i
.536001107795864319313567346601+.441308131809273761416691489475e-1*%i
.218209223372900098395772290248-.904570814692720230950858353914e-1*%i
.606163231437735541386930899584e-1-.633526835753579902531825605537e-1*%i
.126396701790924658052514493764e-1-.269687633888213177557932325624e-1*%i
.187457743969731022457638027505e-2-.957064198245489789722303015656e-2*%i
3.45120772004503448369460398430-7.78995204566145022202902690015*%i
1.99603368703604927349238454477-2.10956542979126882100121611983*%i
1.10658351582126715156624680217-.174992501228267348595405068052e-1*%i
1.08758752355827826753548400025+.848947726451116955180433081655*%i
1.56609370917249322890891896335+.309696470852316123913784376627*%i
.823256168206383963273328391213-.590874296575590443534210685310*%i
.822508312479510118281135731017e-1-.400139054666919666841464430796*%i
-.443674702204572982812298106172e-1-.124620679641285794699342801548*%i
-.261612597900550867546227600968e-1-.302697727398148339970380169857e-1*%i
-.989820859241184333474301112139e-2-.686748977814454660579536845821e-2*%i
-4.31908603664391417295253723729-5.06876393147474656601437797581*%i
-.891078141247444165977651068563-1.84364140618771579385274091953*%i
-.487195496477540008597108520638-.280316675559449194654291794870*%i
-.219347070558209943427660256002+2.36401163985118155098246598775*%i
5.02599330016570567834275188379+.916352180813983273131993682659*%i
.351342419308906208548544881697-3.02389801787028014874649468089*%i
-.723688780598642350622189494413-.467610066215464261551977388485*%i
-.210237966294970389455792400170+.110352702116713071372281628462e-1*%i
-.492076751840311321981601437853e-1+.213377394521397336745944306568e-1*%i
-.118379423722453401070725134742e-1+.854988719780820523511787187299e-2*%i
-5.03990692426444823505011359469+1.95867435699810839936745243315*%i
-1.32784222381676212557573306289+.179426386838305703495906484146e-1*%i
-.682469133532689393427872503646-1.30250439526182507466669489734*%i
-11.0080237895722846744019966179-2.69027335215773395998766986256*%i
69.5353292944815867825043292750+31.6445797078780598603145735639*%i
-18.0465577049725191857835324940-2.43990014274621328818414247919*%i
-.857973551725280640767125787872+1.74497082877317466097557193763*%i
.409137128041456933634388010916e-2+.314843553909746347297297118519*%i
.156541196949048399030270921234e-1+.651894281544806911447697614159e-1*%i
.586997287568587953761544894648e-2+.156591043981148884347672541182e-1*%i
-.627092570020336582781049856773-5.04209338687477265285454785994*%i
.645784630640302362888197785975e-1-1.14385805421586325619554412101*%i
1.66221517527749628753007429299+.188736663186844941442363143667*%i
27.1516736591341691945697306991+10.8402493436762318262983254547*%i
-119999.750003240887296413042628-199.999580875096752391027745968*%i
59.9829617157117379615678915907-29.5079476312842134523134606256*%i
2.68314147613305406656290443540-.652674690276711412305765613475*%i
.358006848089354991462865124875-.639992809632553611289780100859e-1*%i
.713455753921700625753902008966e-1-.107718452384350310026693089593e-1*%i
.172930007249062410920581337564e-1-.235582674995403130911675438963e-2*%i
-5.56809003828517537443968642409-.623899955052475304148496076242*%i
-1.49256061501712445066409528026+.370343239106018048706263791251*%i
-1.00178008283977863556258449429+1.05044504529238823110643142274*%i
-7.95258178520846124269266124139-1.56433763939510256821550596815*%i
33.6575499861722509168047298025-12.0313464897082703353953153689*%i
-10.2019573003035457706170133018+6.46990533182903758102792356725*%i
-1.25450296982333861192955455161-1.11017818087792325039159817469*%i
-.910032401210511893836239933039e-1-.280243264602042262946750220701*%i
-.344134096411693076255381608879e-2-.646484940350234222131516980029e-1*%i
.152243848250617039292714635235e-2-.163105632995977368023274174336e-1*%i
-3.17969801954344072887175614099+6.21161649115530371432345012634*%i
-.440605454117322382727538204664+2.09804431049380795584321907450*%i
-.158282126621974427810105165750+.226810096456941018375772684738*%i
.339864327453418969892943973013-1.87830191857524386722902992781*%i
3.67715309732803916268690731342-.605674488123044961345175902253*%i
.708681180230134660455084003900+2.21345434081942097539831661909*%i
-.486796748863219275917977281758+.546432473820954396426326374257*%i
-.187065933324497800874694331407+.422669052566531326515847060878e-1*%i
-.501984900558766802010465979975e-1-.733752761984031660500082397869e-2*%i
-.131280394180823871838929046024e-1-.513608753720175108395869432053e-2*%i
5.27389935903174150511024210734+7.25922379718527147830890615635*%i
2.62397936940425455164333592270+1.80449443729418506070317115009*%i
1.35593131637880777442475695065-.108162344610053819976543806407*%i
1.13165424339255157470604239739-.777969902349637405378417720592*%i
1.35524979241411852444123388134-.321988101133160132923282623185*%i
.769049118256706424546789435022+.400125163192318192815126280654*%i
.143389848467227823352995113064+.330608595873245496460997047609*%i
-.132700109493987526157183625397e-1+.120363447241933542916778092555*%i
-.171991679683338341421925115465e-1+.335052099706655531992714816647e-1*%i
-.767956811493452074813120972280e-2+.863272812351698224475854566205e-2*%i
11.4103793990131249033115490477-.544192790330496783642207306920*%i
4.44447685620769108410807768787-1.37877571894171060129612936632*%i
1.85947812022895779358824015696-1.27837881704881619857658990452*%i
1.01063889886463790229359551533-.962722547681783793886970062716*%i
.742705725429046386937958401145-.512224868896108977867588641716*%i
.478810761770869067873710080618-.109578152962576585030267855019*%i
.211632466341354067422136924326+.450769824807816242916108996945e-1*%i
.673231252328380939852643194415e-1+.460493725150854871564788413080e-1*%i
.172178152954368372465188893247e-1+.222960688155830513382011424447e-1*%i
.378794911793379802612187444301e-2+.854994634572143774892865430897e-2*%i
7.79054780129638761040383370067-11.2601458871156678409017516912*%i
2.51813757587916359800797687402-5.20706423842258819344172322863*%i
.828835050783404292435311645056-2.56317110851284762648912032970*%i
.364611634000403039828225298867-1.32934524359946802073945526743*%i
.260388660563324145654750789443-.669972475282393902517362141282*%i
.196917867799465802902521974376-.288344168573170176319169049583*%i
.117646062383787255946143497401-.960703189983285806788424483886e-1*%i
.550319572940072278269834370186e-1-.231689977850407099551713674791e-1*%i
.216140246879774571380820831641e-1-.314494090603903552068937483567e-2*%i
.763251709895681242230688176123e-2+.515959810531085495087370358867e-3*%i
.372668300602855700136141055106e-9-65410016.5480368676397234023722*%i
.571245184622616916203141099248e-9-43553917.1409985503455078486016*%i
.876077197739997369529826683190e-9-28998081.4937953668270166058502*%i
.134429354467595372353768357823e-8-19304797.1400720456829581993967*%i
.206391084004044008018844223225e-8-12850185.9287298573250195736853*%i
.317064116433816770863634527883e-8-8552545.12961666149419863319582*%i
.487391629875002885448410389675e-8-5691359.02645644118688694185905*%i
.749722702541257724915872739324e-8-3786720.38066466212760601609253*%i
.115407275333278678517081410158e-7-2519000.00146006716305073050693*%i
.177785207985390256992197006826e-7-1675331.28522451911650138212846*%i
.274100497963479880674551915880e-7-1113959.71546225534369759513287*%i
.422960438484768124601512555646e-7-740494.314741388025508883823565*%i
.653268510640016350134384911461e-7-492088.198759207298519290513563*%i
.100998463856064293183181707119e-6-326901.364770057378397937533450*%i
.156315100906600585225576268284e-6-217082.300620285744848759158442*%i
.242206472633397991648479294521e-6-144093.607565868384806879620894*%i
.375758379750798757323352756644e-6-95598.9876399514391943463064113*%i
.583732322302123791858898541096e-6-63390.2155685324516829899748496*%i
.908134538694038029671881864068e-6-42006.7783316500935734997905623*%i
.141505502385038102609058981242e-5-27816.8270752040126193177506766*%i
.220874447505177491511178547886e-5-18405.3379331633572287997107472*%i
.345411814894365207412122877600e-5-12166.8405598157905175528789951*%i
.541288332907627378504795220184e-5-8034.35399531334661511042224421*%i
.850181228540935475222506196207e-5-5299.00412327449501837301675676*%i
.133872347310812778204165216475e-4-3490.00646122253567956005194759*%i
.211391796709140643726013149319e-4-2294.82801937261516206706975172*%i
.334845265178487136543420293604e-4-1506.08841026476904193273135953*%i
.532259697953277724917341542573e-4-986.253101847474479137094563776*%i
.849415203231882889814923445329e-4-644.163316652458948331360931639*%i
.136164218875044408257178079113e-3-419.438946703916999762348795434*%i
.219394998508116127623306150776e-3-272.116932898969685720595898648*%i
.355583705166712590633053776487e-3-175.770284998076252897788334475*%i
.580244503718677100282942760592e-3-112.940442084913830562991123051*%i
.954399154664006404251373102373e-3-72.1066564571337401411033621067*%i
.158458985192525865242344240043e-2-45.6762277690746460933467847123*%i
.266043462817669603961284654697e-2-28.6524649171730212707976739529*%i
.452730838755823103913178340422e-2-17.7523310368083169088933557983*%i
.783231876396990959677087524979e-2-10.8222036483690104459218130897*%i
.138309953267140050846049249717e-1-6.45091276809119254265368943879*%i
.250682093514793930471554117649e-1-3.71264758347653140770566587899*%i
.469972414721690215939097878640e-1-1.99371040752035648564591692506*%i
.921773952275745448534064339918e-1-.868704739718995381042938378959*%i
.192441782782255299987780545955+.989426714797514091963756932824e-2*%i
.439820702389279854186561230568+1.08564024440080688713184490554*%i
1.15592562280558273320831683692+3.45086450316011839274232439990*%i
3.85058514985721976379349843265+11.8175947174197869864024898519*%i
20.5574289590846222108679450944+63.2628419010213183031210580827*%i
416.919838483094184402947411045+1283.14700118868357414166305619*%i
130997.237250794658209501059043
266.818996386721698370971819795
29.2759106124063912595101876504
7.06563025217258303093451589302
2.39465982065450688099919024349
.976743059393372137140796682548
.446678370570969589387528988327
.220488559348407390776380393205
.114863119225954459831407872664
.622549020873910735815258295292e-1
.347708506569290055451049976152e-1
.198799842363655165413943716381e-1
.115796721260102670674242041029e-1
.684728918427295991717968455140e-2
.409940198127591870666791031517e-2
.247973336239258007610067807312e-2
.151310346356502504777077686573e-2
.930146436294907397414973278044e-3
.575441582861653512077097406750e-3
.357972412516107020458553961869e-3
.223764946412703895696475110875e-3
.140467349228034255325040175256e-3
.885088631427268099476270276744e-4
.559559185253026074675871599084e-4
.354813037510806177855578210546e-4
.225587754588765376354747335640e-4
.143773883579729102141548027356e-4
.918320135943189690456934317107e-5
.587721357103130290746015240259e-5
.376822070805876270747832407354e-5
.242003642815686775992002960544e-5
.155657150632364673893496942627e-5
.100259450449790400848137450533e-5
.646612023033255512705484955094e-6
.417525012264362407134929068686e-6
.269900576174737098031920236619e-6
.174652085323205345124092251367e-6
.113125813834223663601536128535e-6
.733398201424388705083182667194e-7
.475864046623697149842667763847e-7
.309006682370817103047468371612e-7
.200804651982942633910934452507e-7
.130581413696706038607799613843e-7
.849714500248250566780579921420e-8
.553264183217710918482628687964e-8
.360449994748171946817351705003e-8
.234961476980262829018537717945e-8
.153240919642435605126800164708e-8
.999925164098635526452754430658e-9
.652775699848125674977421621155e-9
.426337996314408653724120314673e-9
.278566080600842745568274179568e-9
12.8226236988671760076537571757-4.46750568031384129245705141281*%i
5.44424503914002729992340429666-.724521082138684805348644746698*%i
2.55071032411362170597868403453+.274201923185138258120245950731*%i
1.42815604609902931126092391388+.338034486943018343108167723518*%i
.878541899444141562919538885013+.763537521025711445805955401577e-1*%i
.440230319837202046484590130688-.118448072840075975864739268928*%i
.152845526602208007016523625313-.119104194613651309386306375651*%i
.377543566634200186975793314833e-1-.606880173251282513638017362044e-1*%i
.672003690279702971383352232408e-2-.234967681073125477875407643924e-1*%i
.553911353522095634589336077739e-3-.807857254112630899364162726806e-2*%i
2.78437299744001908565733805097-10.8061279962769038376916461571*%i
2.06015317613997206125384428217-3.47298304182718252143188130486*%i
1.51093984106499477960053440044-.824770558288155498766558185915*%i
1.42453083719240074741894128100-.622366757242348108291639783270e-1*%i
1.23152233620904754963127148552-.448727447741658254602676663066*%i
.408415958618460571256124341161-.655300661875759181257839715492*%i
-.222730004302687977482453577182e-1-.307539610265354726244139500168*%i
-.520016444928866166943484493383e-1-.872401787359800705186197300047e-1*%i
-.237568340283393783228459685604e-1-.206470636193296937573721910182e-1*%i
-.852361672749821991680028940723e-2-.465057857559792055525724016856e-2*%i
-6.70443099637322020293432932949-6.11796512534771304981127267602*%i
-1.58112204708005304141680062714-2.32610789221486906720245282956*%i
-.109672064864706264137587391817-.425859218706750924266089042817*%i
1.29297769344976226201050427845+.981551440401567349228750993227*%i
2.96980818942647786513249237951-1.47556102843032537274309690685*%i
-.542653676666224565174118728024-1.88604940386547267518484493094*%i
-.553133731255687355481566668755-.189622914667156945564135399687*%i
-.148069902365283700324269889941+.316100180900270623328362754537e-1*%i
-.351865731601556856973000714410e-1+.200429359073042428707486724403e-1*%i
-.873269935927333294048932138291e-2+.741591745874492624580212672958e-2*%i
-6.98681424374731657476909525459+3.26953867553835848342857690818*%i
-2.15918710067464285163218885625+.495505720253470994906148831356*%i
-1.27550431998863175230947100969-.134655655785552460270738088149*%i
-4.39982763665774040640501263499+4.15508524150529910572493357847*%i
33.7933866726871454387485976422-8.56168563391812137123373160832*%i
-9.27269146726962320910430239824+1.49431925872987224852267178052*%i
-.362745100447204014041495637374+1.13061868576858042539932612812*%i
.213287013035687693335130264182e-1+.213455465356731477386697079617*%i
.141545490628377743010295039121e-1+.470046337594842693007263356600e-1*%i
.499769612497801118836552769070e-2+.118664461073259403416818729170e-1*%i
-.913399615676753680460407236150-7.18967266241372970996902032656*%i
-.248403190963709729635672142614-1.68453590131619705709236481696*%i
.464729314651420266298592808819e-1+.701347075424804997506761408571*%i
-.462472358670632282930445969240+14.0519686184554772633008431741*%i
-15103.7807817892584226577279702-20872.8645452578355966303741142*%i
27.3383408486885798907154582950-12.0437309278796210116002384968*%i
1.57639004115867550519488201847-.353935275408671217839180984815*%i
.239782905789520302345138860233-.403743199353850707970169659448e-1*%i
.517726314895759175863550329598e-1-.747242452878887539888508502820e-2*%i
.132445758587322325479880769256e-1-.174314162258484972530527089573e-2*%i
-7.77902711564685126568399998974-1.53575180423966777047090003013*%i
-2.35331957587453978638197718937+.244536839800683399479658423804e-1*%i
-1.19038678854531302692122804319+.341969606566563126101329312803e-1*%i
-1.77787915020664319786591519469-4.07638197637252866898803096845*%i
16.8476361866328670876227047186+5.66617533329842771050065764851*%i
-6.35260869858996780018394270928+1.53181920577374935536614313351*%i
-.650606457342730189693169378079-.814146541180823024277827428604*%i
-.423136432883124525664958152267e-1-.198037884615080043710504578962*%i
.726307343043551188429513159368e-3-.476241793536805985241231653051e-1*%i
.178268874436406556114489922813e-2-.125226107857242318359401820516e-1*%i
-5.37688212623852288211933755164+7.75486115912161447109800177205*%i
-1.02489143400249650216137000652+2.80407170169549432167074043945*%i
.218064006674378742113114789197+.591129527631653491575942572374*%i
1.36209759953720896485762456769-.555652339002440337199815159451*%i
2.28655758543345811604271560011+1.14938533381789638289246342797*%i
-.141159395501251929264269545445+1.55051147517780072136391329027*%i
-.422343631857882097284358758748+.282152521153986767225958878036*%i
-.139507281568832970979801200956+.757154131930614737057644152880e-2*%i
-.372827784340298670823458892014e-1-.999964337099912922925240133089e-2*%i
-.996877655133368160930319162756e-2-.491471288891816437639309290040e-2*%i
5.12648983797482492036906677228+10.4499771443157738977031258455*%i
2.89315612974756944258269075422+3.24199712502137605768886679855*%i
1.79947247236966947869626782126+.726724889327069756939528072981*%i
1.44052890907945416179620108668+.497001325061247300990155174376e-1*%i
1.13201253935451695338852803559+.332284666028509342909761840749*%i
.440629714584609353940981888993+.515190680078872495378138470234*%i
.368191612913114404919511918534e-1+.274705159347948789566568892688*%i
-.286648952994932086829481020638e-1+.896953327305622403127454531732e-1*%i
-.174004874431807215421790897546e-1+.242962327887747258713814914684e-1*%i
-.696603102616967447313268095601e-2+.626257842739029876292897614846e-2*%i
13.8868083483128729602933310620+2.06141543925866965187717391653*%i
5.73357437847873403684890169920-.212833796887546041158866573961*%i
2.59268477957094751258428169586-.635400741180563952824194687581*%i
1.38338877028748950845334260567-.483867075290345988075598082816*%i
.820226930246795374335224566754-.169174729236422988089925422285*%i
.420180065788984581928724676724+.462070859367176930638467274117e-1*%i
.159972803614461804656410901712+.823139420296287284818584168985e-1*%i
.464885525415070308757400353051e-1+.485221901577824156714847647711e-1*%i
.110904803581960244072791342348e-1+.204911544815549096548927862065e-1*%i
.223101950593671159342587952186e-2+.748516077737127657114600305173e-2*%i
11.5041451505962281895430974600-11.1490633543850754166771437660*%i
4.26503065735242735489287934360-5.12506769197203718045466463568*%i
1.69947265906427195091315777168-2.45108836605464912346935415725*%i
.794554446248606924758695080670-1.18451710191074254953303121715*%i
.438862335141334829577631721038-.533985690721894093612144151006*%i
.245263145244326394811569021418-.201117486409350712336701887871*%i
.120395208646216731944878282795-.570459863852106157379109437599e-1*%i
.504777354634369588478124210682e-1-.101215271815110070627421970497e-1*%i
.187282969952676939246727618773e-1+.372538749965283159165787100829e-3*%i
.643761633458304939733950346228e-2+.131967350073745885099055397050e-2*%i
-.912027345930196528926439094859e-9-70215682.8163854765274418958826*%i
-.139605412132155200055756058345e-8-46825870.9881791695737370101986*%i
-.213791720520638050433222332045e-8-31226708.0919301282379372566613*%i
-.327555042658846117477188732779e-8-20823415.8407832429601752245526*%i
-.502104214043867049436927370396e-8-13885438.4045706701844692705724*%i
-.770073062294680068875747706254e-8-9258594.05311142630277066736225*%i
-.118171251924879698745765778225e-7-6173106.26844747074794163433116*%i
-.181446283307173630496279510546e-7-4115575.47788762731439536924900*%i
-.278776668267951132378002009347e-7-2743592.78294901612710696673430*%i
-.428601880431458511847456962731e-7-1828792.21393908465809988237800*%i
-.659416503761265149515703176976e-7-1218869.38275574667722446220144*%i
-.101529962088402554739013831828e-6-812249.542534232403596622671860*%i
-.156451561802000148724311236084e-6-541192.144156998689323272075429*%i
-.241291333139249180021742777912e-6-360522.172449442367938566328118*%i
-.372483586390617986685064702524e-6-240114.342814074549330520072954*%i
-.575581131653845684869381981262e-6-159880.341968585156524025178546*%i
-.890376517192286032576430465537e-6-106425.531986686269105489659774*%i
-.137894257663209386402853836750e-5-70819.1437358568747848740676250*%i
-.213828713639333119586065254957e-5-47107.1379540445583697567037272*%i
-.332032325843495714518127480957e-5-31320.4027880520554483965024541*%i
-.516347772534286192222880102571e-5-20813.3219654646803253192419336*%i
-.804288550330318806151781792172e-5-13822.6841260135236067732905676*%i
-.125503923476785119835404264028e-4-9173.54578341502457296434186731*%i
-.196225928021643405611212304079e-4-6083.10028069703169040266175721*%i
-.307466945764888819156378598418e-4-4029.90634187921427470792761642*%i
-.482932465950983920608671578662e-4-2666.70261115532291749354359155*%i
-.760571009249239822417752104253e-4-1762.28657931381355981107288786*%i
-.120142876490898716953503916930e-3-1162.77323713377994604490256939*%i
-.190425540777233112755637240642e-3-765.774880321392855539755094097*%i
-.302981146153592639235665154884e-3-503.195137234877261118079809138*%i
-.484173912436793273023443191568e-3-329.765295295973550177787876784*%i
-.777611020176516780754096598800e-3-215.408018731950993183474750490*%i
-.125614418078597756426472815022e-2-140.151763624727218258354472820*%i
-.204292480572660844504503634659e-2-90.7447827454117539518758139790*%i
-.334907247120758053826029875270e-2-58.4013912902458299528924411800*%i
-.554265809724825394967167888608e-2-37.3023696221707213978208193703*%i
-.927863367255261413235749293924e-2-23.5975120435164814529479948091*%i
-.157520281908318411089234813321e-1-14.7423961822196681017226425559*%i
-.272123112993918053932836525790e-1-9.05744082823639142444376446199*%i
-.480633539540770606507677110189e-1-5.43453690914251228033130126055*%i
-.873714003401281182821625440639e-1-3.14106301873577353158105290332*%i
-.165067534405703292119724510405-1.68661340750945814585124717084*%i
-.328988651137857266298379142584-.725279770029233348285503315594*%i
-.708747845500940878149475163263+.400124328894811210829727640142e-1*%i
-1.72284563735399032979705293969+1.04541223234183386229000695146*%i
-5.14695952719049949366069970049+3.66710425580690185336574528391*%i
-23.2484409787052149736651868977+16.8743643792261479764941549990*%i
-341.381590553863841590033708600+248.027086896405916867949398331*%i
24706.8168175659082761531674005
99.5142766362329503896481848884
13.7503177536387799168434072387
3.80296513083031178355696279260
1.41491375651873141598041296522
.618168328421886838389805932551
.298068099618636038203259016186
.153460087794790189402509332842
.827348492901962891320809727271e-1
.461371226516206185036793777203e-1
.263950365277646758051921505631e-1
.154039960088803082272532204453e-1
.913295150873438037861600200037e-2
.548463578170141720138467736113e-2
.332855611180729898411618369230e-2
.203786219458763114377747139446e-2
.125692242362419196455195256242e-2
.780157965051037761475987633790e-3
.486871692655367752163686802154e-3
.305275703518276167965143389052e-3
.192202126845238809480353285164e-3
.121450104832943967271815044178e-3
.769894377312941890858504931584e-4
.489446608780270860280343539998e-4
.311953747539580976510572233790e-4
.199284700565605496837246164530e-4
.127573339470284921546207682734e-4
.818208708105080742858589238752e-5
.525669857724664193237124062830e-5
.338253581031986213892519477739e-5
.217969247769221644443808680640e-5
.140643987977237383087868563710e-5
.908605667881963173683194081001e-6
.587649041699411550879302436002e-6
.380463591956776976127791904724e-6
.246563301073008683946914428137e-6
.159931854029299104287627689714e-6
.103826073420876004825156392504e-6
.674557492882851273786324831935e-7
.438582111214703791700209816479e-7
.285353031756834845750831212417e-7
.185778578480046880257857229937e-7
.121024639133530819292601566733e-7
.788863349978935971260461197434e-8
.514476576813551571249549518656e-8
.335700813579449184554592273432e-8
.219154423317709303169242080827e-8
.143135756698898994686511195686e-8
.935267585845839612241243627115e-9
.611369828738157758560653907738e-9
.399800827527459528846590804897e-9
.261545191428667213397402586838e-9
14.3120958833232805233972030988-8.05462848665582207736368822226*%i
6.19571284944977979778595890340-2.42255142649922318306334287708*%i
2.92198085352189344805402176105-.653624042360391505934922484083*%i
1.52537150003639996034319746544-.238192301687281969632941486553*%i
.793295519135343879391591356313-.231685788645158500309209012799*%i
.333271540132032744776929317421-.215082178765668584681511373663*%i
.100565495727712637399886468552-.128315369875515303463174840255*%i
.214767697792628035783431997404e-1-.556431162951628739185021609106e-1*%i
.272284108675926084595031223247e-2-.203070367849432084225203051125e-1*%i
-.308827689985511985179436257532e-3-.685003206993372833990933089043e-2*%i
1.35448203023890945429586764133-14.1524761437917795793692719255*%i
1.63654970419589661891052021102-5.11015033951216713403133294896*%i
1.44574279240498234814657755240-1.84797586877243361579934232752*%i
1.24295119735363170900770392809-.893047762534854433982630417647*%i
.755215301674195800088522703388-.843019628611258698828261648353*%i
.120181589210759263986501085727-.600356848069327733846708353424*%i
-.770279146520999169026157326812e-1-.227877370039962427344810145964*%i
-.527337968048844033283919989180e-1-.604478875969154363583964615931e-1*%i
-.211661141132077037968575556781e-1-.140137408460031059722553624807e-1*%i
-.736360058396071049340930989451e-2-.312807102147685969814518243603e-2*%i
-9.78520801058124211968135639184-7.04479022060828766834048789605*%i
-2.63628799906579816983580212766-2.92524884287936047262522038042*%i
-.159263670398061053800150106196-1.06218255133036251148637896708*%i
1.28917267926839566949121446539-.520401411094765658036508545432*%i
1.08800557353896208752112423164-2.04737186502737723010111290179*%i
-.812244212082446205799250887855-1.05210715682845345193659694793*%i
-.410348637438633965795868194858-.416876961258050893693409133289e-1*%i
-.105343309325117966041996179327+.393236270096086264689543340202e-1*%i
-.256129616942507299195141019382e-1+.182095205733611599365155519411e-1*%i
-.657056339326017839717510499358e-2+.644903529477381780644060202447e-2*%i
-9.29528604076459712845309526336+5.11390255096386418779668787998*%i
-2.99513223723498985888560885584+1.18177955148657712271980859282*%i
-1.04907082255573408171186337850+.500679046317284943014620236455*%i
.605700880282174272379700656895+3.24138201516979360863144437300*%i
10.1402786611382749878387470068-13.4317185812204360605187567470*%i
-4.58760078873299506957301147665+2.20248153930995280939920900664*%i
-.128107317953050234750176124591+.744398784598374855669159500749*%i
.272137238174772752596931103036e-1+.148771705119965022203954608603*%i
.125229681945457671338299241566e-1+.348228427119930679763680237838e-1*%i
.428783296391950128346279016391e-2+.921797841725483210715497008568e-2*%i
-1.23460784416396038825588096503-10.0339008607711801959247971852*%i
-.496696731085120651929791733094-2.75665722327520582262780042247*%i
-.709595524142435673227379944721-.322235804099388479035136953218*%i
-6.78035900238613984895265323399+2.14275591202912042929475696479*%i
1811.97375541696735076958756447-5533.85621884687579221060936764*%i
13.0436550991742823658175317612-5.10959617637785463357680115801*%i
.964708945453061063945776635802-.199378793889212301109741785624*%i
.166251995232058154413471176852-.263720429629362516811373022516e-1*%i
.386930969216771536302921460162e-1-.534592685625381170405033065093e-2*%i
.104053910092643599634136675208e-1-.132526188526427529021741734354e-2*%i
-10.4305449597847077668510386037-2.91077121497265031571605794413*%i
-3.28769518210159111321270630782-.442273877481939881424559173501*%i
-.932016870457762398327382577088-.275563892707860055408303798296*%i
1.36673222554261000627370459702-2.05223502612320418349246986325*%i
5.13059182947399098463211653703+7.85652536163149176494515678081*%i
-3.70184590791727241113862422938-.310478917858827235219214330818*%i
-.329691167079471535517720122684-.589318884497142562472310416261*%i
-.162987572617167469411141264258e-1-.143062175019025910123976416759*%i
.283540363223179723670284499479e-2-.359569629035976728852149056399e-1*%i
.185049511981319167614569034813e-2-.984149932886804719234045829608e-2*%i
-8.30894845920504325460520787810+9.26798325600058873203247472022*%i
-2.02492845059518079278755504813+3.66370893297587379823953036427*%i
.108882241132805141568304264408+1.35641178135505847767646241144*%i
1.20445246173687603293369110530+.732968492713611771150344722594*%i
.915610401202478926005283066215+1.65545997994340686959691034862*%i
-.495681835964666695938281993990+.975856061010859726219349352030*%i
-.343796992496451611263950747120+.125823661722185195862840463178*%i
-.104493923160564262256408604144-.106727680461129505706200533875e-1*%i
-.281355346182163777687669850534e-1-.109059265635632598781216912394e-1*%i
-.771414450224550754322709253212e-2-.458262267408003337840393514902e-2*%i
4.24231426672723579739906087746+14.0530508441561011697843929587*%i
2.68529497346600693151262624588+4.98080669630966189406724418533*%i
1.80260371399218332724049861680+1.76545290179640695266301195279*%i
1.30786428910242174845466673572+.820471962188509049437958547317*%i
.764008548351453802624241852495+.710409221864211577472541613619*%i
.192100833691811609204706688400+.515503538256050890536921674800*%i
-.264169545402233236784078174234e-1+.218398891688312741108391184169*%i
-.355780880830199871548598764763e-1+.663176876254502620930771106545e-1*%i
-.166701723387782645232074535294e-1+.176726073374234789935205303829e-1*%i
-.626776274124981312936142792734e-2+.457560818578875649251353984707e-2*%i
15.9254312879127735131266427251+5.38467721179215099062917793881*%i
6.71085046987492112461632053281+1.36548710384435266598197880825*%i
3.05775893917603905360092107069+.223602666246793845433700971330*%i
1.53470245852932394498407569677+.425052315721703636480368675672e-1*%i
.782838086783561388352564944329+.117265131244506469828638779392*%i
.341691152372598470469358585640+.148338339696639042597183876776*%i
.115624704629901517043867140654+.100481825545380068791686722866*%i
.308439537642043905850286163137e-1+.474788495517207078564284238239e-1*%i
.673576651999963358230974870820e-2+.184875730105643501729550342184e-1*%i
.115176015193436239052895370603e-2+.654926560662086609656433898658e-2*%i
15.2302850794714434203594636871-10.2719727433535272385949571413*%i
5.95092988862626585594640308102-4.61813930376297789954986622231*%i
2.47322534845913806329060413553-2.11391722634930199865583483904*%i
1.12736844630540148642029117940-.945290217088591434672405634490*%i
.551755526651637049333370575512-.380279821185670400710557965680*%i
.265354303559832479471597376328-.122723041909173457487446960422*%i
.115881638191640573864041704573-.265232687904938368583611908044e-1*%i
.451738948979587796867984484249e-1-.770865505775436436126860017471e-3*%i
.161146692220364943940497127983e-1+.273883052950174393220446522546e-2*%i
.544093523984758807145382100225e-2+.182667461876027886057836145453e-2*%i
-.859288000941088736956145518919e-9-74754189.3320917280051532366891*%i
-.131370287581696447256177435013e-8-49920587.0868500577794216611685*%i
-.200921847649456538432844917815e-8-33337934.3019994389374989374833*%i
-.307424073678352837180514380849e-8-22264407.8596557739921297594581*%i
-.470586085650517149893931205868e-8-14869468.2324850298460225209929*%i
-.720678189278623085446640701847e-8-9930923.52605238767742751124930*%i
-.110422156857687966718053747320e-7-6632717.73017537073156959601952*%i
-.169276259313258056766240302328e-7-4429946.33581914415599381737169*%i
-.259641654657618707373033387284e-7-2958744.42133212959458367649582*%i
-.398479403410708290338358844848e-7-1976127.40909397150182384444514*%i
-.611936891703458450037047614909e-7-1319826.42802451839392475070236*%i
-.940360114114483776013977947363e-7-881471.542555450749719703670809*%i
-.144606503166076962159828068062e-6-588686.106009787266254478100453*%i
-.222540304023183393968792048519e-6-393130.535012806744119988292466*%i
-.342752075836424290158850334341e-6-262518.349579771885813078621475*%i
-.528357495668322022677462339285e-6-175284.515602763675963410333878*%i
-.815230883481909522522549658076e-6-117024.828552094726232645724682*%i
-.125912884531274578009016949956e-5-78117.9432968551864900240660977*%i
-.194684802583784077555563420553e-5-52137.1746153446029901215100607*%i
-.301374195377395934818253497544e-5-34789.7299963463848889626160844*%i
-.467129165543194670950269423989e-5-23208.1926405277575916695552264*%i
-.725062385867678114937270077802e-5-15477.2675595994878284749015908*%i
-.112714192075664227395087743443e-4-10317.6628647582017577334848618*%i
-.175514113708523197725148655987e-4-6874.92748642150649694008948170*%i
-.273810821917899395313011346133e-4-4578.39555895620375736479577259*%i
-.428036278993089914470195876394e-4-3046.96064620646732804326037508*%i
-.670659299316206884965182096950e-4-2026.13217486781367284627968282*%i
-.105349225110450881494631766073e-3-1345.98874518632715692724810995*%i
-.165960885632342178419687918141e-3-893.091019446143374568342368130*%i
-.262293344632943326004861135041e-3-591.720007088731040971875980783*%i
-.416072903408153190927795718240e-3-391.344994991503247604763077594*%i
-.662804330452024963371893858364e-3-258.253042335004688477599384865*%i
-.106100805827909871440504074803e-2-169.958465040119733846411307610*%i
-.170812126304526526072920811129e-2-111.469347483694484715720791841*%i
-.276834876074461391084236799136e-2-72.7944980926437884882361760045*%i
-.452247034556238119755318667936e-2-47.2789485176272315199982680900*%i
-.745918808145478999076602407897e-2-30.4928436289578258451229396503*%i
-.124478951672439412540269884759e-1-19.4899369408219855080077226120*%i
-.210780689380360705034016455056e-1-12.3129686349415916905876775350*%i
-.363581924922208694178709980326e-1-7.66405249239100036451792584846*%i
-.642431078561398725889361193818e-1-4.68563422885692941018919977951*%i
-.117234576009870318289761504575-2.81633950383740570590497871898*%i
-.223749133724338984743638455971-1.69995820104912153291680817274*%i
-.455928933499468375394550735668-1.14044606745103059954774285383*%i
-1.02889590605076450203163645164-1.13052781665058609912739463614*%i
-2.76735044254507330247169319085-2.16155298725361078483715384772*%i
-10.6142604826778455196336926813-7.75293862663218636119564906295*%i
-113.152959050958826871381146266-82.2144184534014650423603884257*%i
4941.83104628321335407996632988
39.2946767604079456209469293239
6.81545866136579347602866273437
2.15189169499468189025331049033
.875540019000002218361082371014
.408249518334950426831801152696
.206872433714384774374484388274
.110762893300280103901394897383
.616381683134129402713090889406e-1
.352835268655778388614955352879e-1
.206337001390327190777466655731e-1
.122687361690936873585416209315e-1
.739198594473257343377903313006e-2
.450164828170846088089831819320e-2
.276572658945543506290934101405e-2
.171175433984649607197818085233e-2
.106603709429084290035891144940e-2
.667432441848607524411238632044e-3
.419786163183348887255461409884e-3
.265078694501397553419138031404e-3
.167970444164262303034813291758e-3
.106763650031720334617637216377e-3
.680449714757354132029539326692e-4
.434733609640321252919403402155e-4
.278353085315737942646989649168e-4
.178575078145929504154144611072e-4
.114766889590506043282604135436e-4
.738776053338647450155475110161e-5
.476263993831665361958329747440e-5
.307444826252879035054551645688e-5
.198711599245960038263947846158e-5
.128579975633694450461424756783e-5
.832874756397344275332300471771e-6
.540018278176943923247846130352e-6
.350452579625312315164790069141e-6
.227622282798882761972923227826e-6
.147958637117441904601308982387e-6
.962461917005760648498860549952e-7
.626504466412587823079206104978e-7
.408078476428511044311303622627e-7
.265965454804076676488219149206e-7
.173441633701925432439432587409e-7
.113165461005819754447376860299e-7
.738743777198317589509822274038e-8
.482482070508867362956371717735e-8
.315257088048230497991469217933e-8
.206079429592747109495375418469e-8
.134766221213919738348231219803e-8
.881648120993225308966989500311e-9
.576991179068338446071645049301e-9
.377741850409029639632455458347e-9
.247380794547276891972408073456e-9
15.1413887030495733954511353867-12.0553930044108209690800075986*%i
6.50928106055172661917939588232-4.32285376729684090603257146348*%i
2.98173436131537480505211465988-1.63236374295868604038128842533*%i
1.43122311981309850604408807072-.751904789850128725869076052933*%i
.646977382633036846088109111444-.448083696276861800806631795739*%i
.233799113443959503964117591663-.264740552441494172486642395008*%i
.607277682757391263094488280776e-1-.126701505553944536421364430349*%i
.101151163418152688777547578033e-1-.499149079209526957102108790094e-1*%i
.567018354597478754570043877964e-4-.175479636532738104221842031504e-1*%i
-.864897972670649543207521885284e-3-.585842653595532505887591856983e-2*%i
-.882401097492140190049418043104-17.5605542559576583078213588859*%i
.661784224912042552382617811089-6.78305477527833851100260352906*%i
.927583439701934735891041948565-2.81568645035478828253231580031*%i
.756502102116722577169142949940-1.46979813720115058962053239122*%i
.300546951957882380474259453311-.971828622814678624551436001699*%i
-.636232081651129065830485166394e-1-.499974370608889533037482837538*%i
-.102269695108906501451276641119-.164682525941691952128029707748*%i
-.502388773147331024836600125312e-1-.415329894694121337336691518029e-1*%i
-.187445129768211784261491531339e-1-.945168388000251210371189743894e-2*%i
-.641151429975528139895532261836e-2-.208105381903048234015936972392e-2*%i
-13.5549687865722228090400167280-7.68106466653600109229124679674*%i
-4.18431758391579714818708282299-3.44727063827768456215664880889*%i
-.814243337270219945442132862848-1.71647668118653369427352276415*%i
.453217358082714642483253219817-1.40597117745914477876367895199*%i
-.164327838564549860207028748655-1.74716101909012444784558718498*%i
-.802553939200109130022201671836-.503979775623920391319768956953*%i
-.300967236177913835039845933183+.334061689124595948955420145095e-1*%i
-.760877180184513799938217656825e-1+.407595397389921007475754582810e-1*%i
-.190393806400349328545505775879e-1+.163344904473901977357345450726e-1*%i
-.505450924705611846573967029726e-2+.565125034755650439221182852988e-2*%i
-11.9453125507601766602680523747+7.51509441488932313586820028740*%i
-3.99394616979262503326480509990+2.02259262751231870679942079879*%i
-1.00524176545682759428432220152+.548192195897311962853253522258*%i
1.66922618005974025302767726089+.552352862152242593974878071482*%i
-.254766097849839354022862363071-8.69401727785026166054573680015*%i
-2.17778432321106888794093523524+1.93407657680860919064993028763*%i
-.193287914678237254382288486860e-1+.501669082165416365371549722096*%i
.280002518700512896086694132053e-1+.106926480430365320105106053977*%i
.110206353322143740052504579602e-1+.265562610327261455958969584285e-1*%i
.372104792721922667332086669599e-2+.734919020521280499299054739138e-2*%i
-1.55533889990216649739217663686-13.5559913416993040780972670307*%i
-.588396479210918359138516532136-4.17617651799396299183800173588*%i
-.464679998927826185890135202580-1.32158435018155508660993078917*%i
-2.36016431574864279091090329014-3.11619106633398234528044458504*%i
1328.64032767187023453494952826-427.624857827255543364297389684*%i
6.55317862938606761543389206821-2.26396127196641377253168932439*%i
.617042116745406626954692497431-.117156009820813352080146798228*%i
.119562160135180483046134708600-.178874568970500699469264291599e-1*%i
.298187123287493196776590701462e-1-.395180984073818487538551060372e-2*%i
.839202658964203763500372634328e-2-.103654362229642650505633004319e-2*%i
-13.5055728371574301969736147554-4.79806777122876858044664724500*%i
-4.47146474101651577749291661613-1.03890622241026114374017449688*%i
-1.06899097051331141127133021303-.115845998292147924138902036419*%i
1.39581307164653051732628312216+.237534358948880307869311331629*%i
-.458600785630022402868446578325+5.31139643610870904663107666856*%i
-2.06175879010674518770938582824-.852404747662031291390395268369*%i
-.159214495569245922777246126194-.428306376672449694821894552480*%i
-.252948799546569865109949276157e-2-.106053839829777262864952777443*%i
.383166226481555399036984698450e-2-.278806699393712266722770870796e-1*%i
.182345268640752094681918980537e-2-.792705975060922028400192445393e-2*%i
-11.9747431668278230806553132940+10.5557314432111662699896964083*%i
-3.54866323597498388527246047023+4.46116023753100824397101915210*%i
-.581779707055646573104352816756+2.08986403391630041424206714699*%i
.415426521733256031770363170762+1.48569288982725786329218658735*%i
-.701148168368962401504310276368e-1+1.50307981877775524570416953723*%i
-.591817854370823859206266683475+.550583193618142043260715898492*%i
-.271928983231075924985539506644+.359879200173956250765918745241e-1*%i
-.791382512082616981182332881013e-1-.197237667590837103137899017077e-1*%i
-.216481481100899225799952975792e-1-.109285239479644140091265369329e-1*%i
-.609736794040138968912960131553e-2-.422880557912981429849008089269e-2*%i
2.56004638930632852880489065572+17.7923823966684112642662561240*%i
1.93822093237671206665918903137+6.78761711899006177143041411486*%i
1.38285012669188154394313811011+2.76589168739539078917694578514*%i
.902762755550452581313200464207+1.38694138722661054048892268980*%i
.386432105418439196925458163731+.871939085398849125333621123001*%i
.195205970209322958362366680284e-1+.461578672941892735065330068142*%i
-.616211409382959062772342462209e-1+.169202383566383312117142155575*%i
-.377833408885011338395856792235e-1+.489245935280587767011954634570e-1*%i
-.155648461393903406580442601373e-1+.129330050149263307148577122780e-1*%i
-.563803128225713811944199543071e-2+.337433364943732953802829127138e-2*%i
17.3610979821876909250703407612+9.17981370360201718237344792124*%i
7.28627647042191035204331799718+3.17632688670070318968753837847*%i
3.23854396947904187135373214059+1.15505498408299812720508714423*%i
1.51034228586735336683402166819+.531286728438901724382529985166*%i
.681503094082141618569548202256+.332610562625401456087864648151*%i
.261847229120961918738319814638+.209280902324531947868898669753*%i
.798238666197401145379885213592e-1+.106883809981460892142473691379*%i
.193575410094666639441367912837e-1+.447532978896174944221652356956e-1*%i
.367233410046755331967861886449e-2+.165600927500021445305245050033e-1*%i
.408178385499821713300712726758e-3+.575640942920613215503793559721e-2*%i
18.7291693995441605415032203033-8.75124479015484892496358348246*%i
7.45265821083851039782102744313-3.78327781037901468645111001207*%i
3.10062108078049361448148107092-1.62963963428779721469240790411*%i
1.35919309200435280493475849356-.662853471158145811752950211984*%i
.611853456023865876727416472874-.230554233039863075861578554507*%i
.266959448339916773533501681153-.570492632593455053044365599890e-1*%i
.107731720286854514327018441977-.352815197981448331113721022109e-2*%i
.399171988024460418978475591188e-1+.576637417980965375255822148883e-2*%i
.138581347811529550761204101613e-1+.429293512535656411551984272704e-2*%i
.462697118534207750263516758802e-2+.213452182581197506975524611486e-2*%i
.311691127714755509724835794428e-9-78928884.4027739063654418061188*%i
.476011160847487601296231442697e-9-52770997.4523716540459348010767*%i
.727213167934441111755609276839e-9-35285186.3729769418806637792660*%i
.111138888355963906078059371398e-8-23595406.6782157849434712990161*%i
.169917649567137226836431954951e-8-15779764.7478364587526230931759*%i
.259889145400678962472086918024e-8-10553865.0625467062120440365226*%i
.397671809438787322190537516074e-8-7059278.48165693388674795268424*%i
.608778220688153590889411096728e-8-4722223.05624415721892155340652*%i
.932400655623860461836314896352e-8-3159144.73582607389456959074175*%i
.142878777215979098048410067251e-7-2113628.17983477094826040648720*%i
.219062592455850605052684440172e-7-1414238.33984529227080163997362*%i
.336061664818947710963354869965e-7-946346.401037535220966460597800*%i
.515865283794129542562129852263e-7-633299.759494468668699007617343*%i
.792388421156239706890892978185e-7-423835.980712808317820581193070*%i
.121799118757663208549726516776e-6-283669.528053271601564490446769*%i
.187359680668229574351265793767e-6-189867.331473232155138487612039*%i
.288441790269061827213216762489e-6-127088.415761490868171333828895*%i
.444443982756277392447255731279e-6-85069.5728133456098807088076360*%i
.685460589981440613505750424475e-6-56944.0340093801642412607601383*%i
.105824907464597419926671479105e-5-38117.0657665704247653764471596*%i
.163557580414198795903206839067e-5-25513.9435830432702786824432107*%i
.253088854590318760134834295457e-5-17076.9341565597898683763125642*%i
.392141403774605847801004277287e-5-11428.8035701152065722209718410*%i
.608462844836152532129545078280e-5-7647.70140987455589285129989270*%i
.945603917178959303913556680660e-5-5116.54228380015250446367823581*%i
.147210827992214545253964501236e-4-3422.22203042113230767409619161*%i
.229619198677634039667042340931e-4-2288.17376101096825886856973031*%i
.358930870415002514438165385632e-4-1529.23064403777285231496191288*%i
.562419557502749159100752204529e-4-1021.41491003901503612474957240*%i
.883670360352008646809959291419e-4-681.715449118063122424025104354*%i
.139270533940874171920695815797e-3-454.550372990152947897730768388*%i
.220271474387362519918865372863e-3-302.703965681172055751579125085*%i
.349799688002989619955124868630e-3-201.258706847098844517295959853*%i
.558120513792221440885491437418e-3-133.532317594574312806920397835*%i
.895445528289637978561527751420e-3-88.3571656354603494337639297113*%i
.144611150094755803803971363861e-2-58.2584568567244939016996600448*%i
.235392360402493333198548659125e-2-38.2342749516476651918527231992*%i
.386870733201521601148349797559e-2-24.9386879484346457269909201092*%i
.643477050266907689473014065915e-2-16.1348688116668063244402649368*%i
.108663318711186418669477733807e-1-10.3292323207499475695941189027*%i
.187147991824702047015047430658e-1-6.52721943268412196145134731548*%i
.330933794244542897009466502125e-1-4.07156896106522306239623280125*%i
.607063533855136234053627624092e-1-2.53859797820161165236425925696*%i
.117498947177505984384224864545-1.68198046825240785167177732758*%i
.247352007699471391770603881522-1.44098421689355256409533958584*%i
.602131850667677645087070827189-2.15372204007167783379950985968*%i
1.97165058917802363293161144305-6.16566110009144695107724201746*%i
15.3261364544371289792308716831-47.1820569460262994911144642361*%i
1058.79921014270674949484064821
16.5717362115069505815793721995
3.58996480705909516004522304454
1.28700781841680785728394860636
.569731170117977902940099934936
.282236565401222755899537123035
.149701655811553559416218044815
.830663910208264752281174598248e-1
.475703462260035715955653346091e-1
.278792068336495492402650359842e-1
.166273395837927033054087655515e-1
.100526576052008716684662205551e-1
.614399622489138075851426642637e-2
.378831714732576294205493413778e-2
.235287075161612997709914807626e-2
.147024862871744065376220030223e-2
.923464560184126967798016481434e-3
.582591786773168532780584665480e-3
.368946155557640937596662978971e-3
.234424698591482138728809950816e-3
.149385888871934287631897320136e-3
.954409444435454647952739485492e-4
.611160210325852060693786237635e-4
.392161988682063392324654730202e-4
.252101868289453149535249318495e-4
.162333927498380951411022485315e-4
.104688271182571931471168554824e-4
.676057604363561951578950508212e-5
.437134407980792752749181778469e-5
.282974100198356711383283597693e-5
.183374431789296698859269753089e-5
.118947609543226653240524576942e-5
.772263975122479266163822808692e-6
.501811421246556943482029118205e-6
.326328104858413176229202407204e-6
.212365791360837355829404192305e-6
.138296107468710179099164132164e-6
.901180466877216287526687657183e-7
.587587851755343614820280238884e-7
.383334043395389830172802236636e-7
.250213752050633785541662059712e-7
.163403374170798022283420390338e-7
.106761544928894619728802402209e-7
.697849140196434592400923001008e-8
.456342438997954026705780554082e-8
.298533660135977110278341222754e-8
.195371004555883505600849557557e-8
.127903706125391748699479800304e-8
.837634963881962444258118475558e-9
.548741836386690797359448803701e-9
.359597273380777232729005247862e-9
.235718474469550159257447566309e-9
15.2942813641763955635987774511-16.1630357158701093256514595439*%i
6.40320708991124886370480399152-6.22944463806873291714963456220*%i
2.78764259358211396940303582999-2.54094978676372557552761612054*%i
1.21982833429161967319342326402-1.15974358386620358071850420945*%i
.483340930433283584448158914797-.584498315811883491903236025392*%i
.149900714657227996444942010889-.283885692474876218995350176177*%i
.314362608128669442611581928477e-1-.119827769576457875638354411263*%i
.232098936427968783790040542071e-2-.444154655459311493737684945100e-1*%i
-.169917693526676423517932564404e-2-.152570480946551315707777871427e-1*%i
-.121759262336765288119797296727e-2-.507187490133498212788459231510e-2*%i
-3.81007458103093891272578137192-20.7497119969675624498899516985*%i
-.779559551926982057618923734109-8.27064925166317461048553589097*%i
.962429410802521518550473210864e-1-3.55503669963057819703005477238*%i
.160445727967700665153612042471-1.76697912813219363121233365249*%i
-.642747859554335291137934194522e-1-.939850433650502012898688657816*%i
-.171782367175443378378608333974-.393533513541997912273855147926*%i
-.111014451022910836248157539040-.116974328843342931606143363671*%i
-.465467562923539090267355922231e-1-.283326058532764782746761478309e-1*%i
-.166438779131861518117519753330e-1-.632145194349312368321551225573e-2*%i
-.564711067703497346420822588921e-2-.136082614275750070685686176716e-2*%i
-17.8630501485280875547888998791-7.86576273563017267123014403809*%i
-6.16539751970605534872668396912-3.67051330686865835802427927439*%i
-1.90848455883821414759913019224-2.03697986291262938041265849698*%i
-.580095547684494600422749227701-1.58957830511363858220967904264*%i
-.827604670680092764559100579672-1.16815222876760722345170293826*%i
-.691480434540155316193384044494-.168905789026758930381858067147*%i
-.221130742324363466274495302559+.689077782037931008675113043293e-1*%i
-.560920239433354678065338738395e-1+.394007573379392593117022195919e-1*%i
-.145054731155728549191240814327e-1+.146418119488940649372643018469e-1*%i
-.398624835685242947174890524521e-2+.500887454222578221275173954005e-2*%i
-14.8664237622509141444201202663+10.4756753929497846339515691479*%i
-5.25236684230383505458465035450+3.13337241171763447180209328644*%i
-1.52790181275218741516105470937+.582069342331029224624115446396*%i
.506674736434945555211087748758-.914680296865867931979534336087*%i
-3.15594382226107898218917887832-3.74603933073168730222517791423*%i
-.970063997922874812746340158290+1.48251473019941032067020952111*%i
.290950870887494564917165218983e-1+.348478063271450498210397523366*%i
.267206563515208840593465868051e-1+.795105580717549123287216916296e-1*%i
.974249622086424043688295051143e-2+.208873971709691406613851886918e-1*%i
.327547409475657377457029077897e-2+.602078056135310701329413887537e-2*%i
-1.88938537522441777074716271762-17.6709082334677647596706346245*%i
-.651618262107727435905139491999-5.85158437250426787124269170845*%i
-.933797353721020349267795659580e-1-1.87422897694524261123763069797*%i
1.07574026626002109747428868284-2.07095283409682743097369713435*%i
289.204587133751886865775298561+211.702823960897552809086779209*%i
3.49140808872204855036071824062-1.05419137691369845456237190191*%i
.414018951344832351783070763723-.721727786169173121990563874915e-1*%i
.893655854836589643338353139542e-1-.126391275389958306121848959684e-1*%i
.237233898719065631613859464473e-1-.302438082249679142976770745163e-2*%i
.695317194063433588112994273649e-2-.835076428077938268320484721098e-3*%i
-16.9119515702704033038643064983-7.23108605388285130614603217272*%i
-5.96714692673887079633299564969-1.91897916993996510403638453522*%i
-1.78893816242910003829229173335-.756756806748736312907920065767e-1*%i
.558271339832799409000063283378e-1+1.17288567647958344626233223142*%i
-2.22955101213324902132035259584+2.45886698123868063926398789166*%i
-1.10360366145357446969407518472-.898488313400010028947455408707*%i
-.687759320778977085798460185478e-1-.316387800770949019700233792444*%i
.463315700662642995476225982848e-2-.809803220802442801438326625420e-1*%i
.423947615735334121085595150107e-2-.222465147262048935825068057839e-1*%i
.175553572962924189141398898639e-2-.655206837313800166634196545609e-2*%i
-16.2200909543597846942615138865+11.4278594114307303075140038940*%i
-5.51960386929038748800228797090+4.97138446508232468885682040184*%i
-1.67511620854236162744582613361+2.49445217791340505637386569714*%i
-.519419422954197422349562095279+1.66155695022440244334177729830*%i
-.649261729281105140898970978917+1.09879443277493075251546737160*%i
-.569222043497410567646707566708+.262417267673648817755378545303*%i
-.213294642809490012024049714529-.140599181020203976218112831981e-1*%i
-.609795042829586531894656565401e-1-.237664902644800614871216917389e-1*%i
-.170439110116783298220354076300e-1-.105509752987287431331205192008e-1*%i
-.493485613939362309006027198590e-2-.389813104842578148020639969210e-2*%i
.174827836325659611872543106897+21.3734020173875402065489653524*%i
.727522627694819667016578703744+8.44456223657584576521667389312*%i
.663140213485516536467580999000+3.57031870870205237757969635075*%i
.385553222340913112651425618828+1.71889940769242781742812226229*%i
.642759978231545838377365061580e-1+.891296801841399748412459042008*%i
-.924122153785972482743933454514e-1+.389397668284639084482252912091*%i
-.795519880350088488597755300654e-1+.129360914086386361156299168646*%i
-.375566373664231760018033550317e-1+.362140144071029712292136167185e-1*%i
-.143886869480693917996750954210e-1+.955768678251927125354405459341e-2*%i
-.509840907578036527934093364586e-2+.251952307415911925066847414275e-2*%i
18.1470552409181382826715473616+13.1484241961678082729773877216*%i
7.46157747853841184560789710746+5.03215427884458241176834791927*%i
3.17821831562171047696528404486+2.04474676726340294777882930996*%i
1.37038983616963239231177759006+.937937837845953595006530708762*%i
.554437259012821866470696407868+.480905699889572036042582181403*%i
.190226712425760018318748749162+.241329796187824719150832947143*%i
.521330443153533990393523931659e-1+.106605144896214033142652463375*%i
.110784013046602074975517206851e-1+.414444083682015498277895930584e-1*%i
.153802110682281230127825256884e-2+.148446014649718311937762775842e-1*%i
-.100672948660506894056610282469e-3+.510365461415449956243880818320e-2*%i
21.8251080161253855977087213138-6.78311986099424103233591220345*%i
8.69970247241426510196985530122-2.74595514095977344840030393618*%i
3.56806618243483825078391364866-1.07621190190959927314250303262*%i
1.50209870048640538261204422574-.376672182490440511161763316013*%i
.633840138789998084573043289577-.972507173434529693849213118903e-1*%i
.257812610706050017707521750306-.478060457547483825835008587733e-2*%i
.983250290987345947691526922546e-1+.132620551713016012026945021109e-1*%i
.351413509860068897001728998582e-1+.102296606039884312750175867961e-1*%i
.119782001578932928726923569952e-1+.528644277779274029557015563046e-2*%i
.397470269534818631523395088739e-2+.231186298331912281514337518740e-2*%i
.965475544089098173682914659492e-9-82646493.4736014345280615533102*%i
.147312313156321321897421659479e-8-55312208.4534932314727577728195*%i
.224839171847858719192584485861e-8-37023276.8745872749506924764246*%i
.343278644262017926116480833769e-8-24784918.6552337823413522116580*%i
.524288953238375331695847810024e-8-16594357.8863037642305571000502*%i
.801035062032383315449698635999e-8-11112077.5397254769954312283857*%i
.122432760760046396425398535391e-7-7442065.55309329563851926672811*%i
.187205298353701765665797952214e-7-4984902.88891265593079195280739*%i
.286366913428288295465223418076e-7-3339538.52531992637145826184255*%i
.438250498600053070247236381379e-7-2237609.52005591218955311894376*%i
.671009207228749947428813312948e-7-1499518.19066210292533209254851*%i
.102790662617729599746070884927e-6-1005055.90304678824117462303953*%i
.157547600557903873153270791202e-6-673753.607592569310856989732207*%i
.241611718226527681142020020120e-6-451736.969450145322445275890162*%i
.370756594456101840940168413186e-6-302931.813363378533446611777036*%i
.569302071540661091765782812738e-6-203179.416209684268447181913320*%i
.874782013842818106399048922902e-6-136298.370863214955738026773252*%i
.134518656767825764488668601776e-5-91448.7834763498432098839110994*%i
.207021614792465786896169571620e-5-61367.8901993297015339074477333*%i
.318879889955639875612888174184e-5-41188.8328301897749956573169759*%i
.491640837617005743346453829961e-5-27649.7382167594009324253386104*%i
.758775202919970040152773183048e-5-18564.0596026525475074859807071*%i
.117236320813901164417822084083e-4-12465.8256144090608245514843040*%i
.181359344502586079132129693548e-4-8372.00147204022068122049714947*%i
.280929620554623082801163689113e-4-5623.27585227371873556060062150*%i
.435806397903760251199363583898e-4-3777.37422354755246878706303799*%i
.677166994668372991502851973488e-4-2537.55772189082241242445252176*%i
.105410190796050752854513074226e-3-1704.69519347584035522325925310*%i
.164416674073225434330083914781e-3-1145.13101914568123705878418253*%i
.257035861413824716911916659067e-3-769.139031559342532285635954013*%i
.402860501717425327268827377477e-3-516.472266803881183184323368538*%i
.633261196395626527706409401232e-3-346.669860957222189094076923214*%i
.998768925135784096515938210432e-3-232.553767782409475484655899795*%i
.158135736830716903111240317702e-2-155.864744702672845564373680787*%i
.251513991295446426947038221561e-2-104.333316401194537834751500889*%i
.402179206444203553673268704851e-2-69.7134762732040225918898084631*%i
.647234248748873302060132692051e-2-46.4624233212138356433223584681*%i
.104975408916114533507006502741e-1-30.8539027425465043496941372490*%i
.171909297035525580373125943909e-1-20.3826331780713222741143909994*%i
.284968421402136128616996651323e-1-13.3641913041563074838360488634*%i
.479885824261221249544153868794e-1-8.66617596838331716731728724327*%i
.825312220743270544142324009152e-1-5.52757647990781486459064504044*%i
.146146492666041869407547144347-3.43743290951203180029319919473*%i
.270084568434005149072517276383-2.05338674070602683581059775834*%i
.533655740947696244474770044468-1.14711170269105861812413938396*%i
1.18427985347740644694590169218-.567916800275705659410487900991*%i
3.33727007422528536139886322010-.218718788011679627638970692127*%i
19.0572116064186513705954616847-.405566316017783440740401465186e-1*%i
246.416897741364016583506104025
7.55018355124086943656770578023
2.02656159881843034125663719713
.818565021868491865427914565349
.391600527024850071662332382857
.204928176805448049729507406265
.113232090674047613302005214494
.648517055579562255196028840866e-1
.380890653416881724434413485122e-1
.227873810564132371840271961450e-1
.138253975402884224716699866479e-1
.848044189305979793922491083567e-2
.524762987192581091695869803427e-2
.327045496352064409726901701906e-2
.205031892411150484185177429433e-2
.129179067042221337040005079375e-2
.817329797100954893234444491296e-3
.519013853996799356026688106720e-3
.330619133422873671397547302020e-3
.211189840077543696745144498510e-3
.135229655583726843474258599890e-3
.867772203458989126881838783868e-4
.557922467083323167061226657970e-4
.359327658821972122569380177889e-4
.231783567461312571322072867278e-4
.149722254271290289548769069869e-4
.968381791674748467117027466205e-5
.627068783369904327143186133834e-5
.406489815021258229670848235970e-5
.263762252218967934891542462439e-5
.171305337620147099653851191511e-5
.111351184473759529894395459781e-5
.724365935578805091443439711072e-6
.471559688942065834497450744275e-6
.307191646843720464621691605991e-6
.200242780058676712587421831909e-6
.130605519186071045924419250215e-6
.852329364822349710708441844160e-7
.556519127400197661047498471059e-7
.363551698240568770864319964187e-7
.237603878072146305681720542670e-7
.155357046695732240333415343441e-7
.101622104240125020824739550841e-7
.664990916204499033005156320566e-8
.435316143268414849195511406203e-8
.285067193601428591004727380704e-8
.186739236871068348892415861247e-8
.122366570547653942657022964190e-8
.802088609840166678205688628828e-9
.525906071198131248231059242025e-9
.344917016425787628114220253561e-9
.226274884839606025600598091844e-9
14.8737045374708792791303282657-20.0797707509208007746158532542*%i
5.97126496085660129090398120609-7.98205719855849849125212747890*%i
2.42881421976693973468886948555-3.30756282948272711981892754586*%i
.957603652331196705620591787823-1.45440023102608656362849513146*%i
.329064509075647472068711913534-.660175105296402993685816282648*%i
.835926539847265709607806971993e-1-.285169768910583649881868793959*%i
.105236778299485105854213423182e-1-.111115806020340326044848864412*%i
-.293686698689206976755886843592e-2-.395928868345788360081746317349e-1*%i
-.283930257434080974737178932282e-2-.134176710667897526992119682616e-1*%i
-.143695183987972624181513898186e-2-.445952013455515760085043876823e-2*%i
-7.17066314971744442565761688749-23.4968867106282575425987032272*%i
-2.50133387426345940245260389621-9.43265063903927102342542218603*%i
-.871046172306915642805457841609-4.00749564234623383961364806532*%i
-.411562303303413498798494579830-1.83918277894754982774118263412*%i
-.326457075268385459454799299989-.829747783360482640822914295575*%i
-.229870981561713727475808737398-.299279778096733249647308343686*%i
-.111283926411961936508173642900-.822026853153027590971296704886e-1*%i
-.427331609852741117466812605545e-1-.192190220686192774073955320226e-1*%i
-.149112840894099829412434498265e-1-.418247634214329761101723988289e-2*%i
-.504651191363511455482404624758e-2-.866572316983481861943580460467e-3*%i
-22.4183587504047327332669726319-7.52591686586353217313440540147*%i
-8.37050412623691223434296302226-3.47416885036891534785276565264*%i
-3.15115277286803378788741383413-1.91103441600094161507079473660*%i
-1.44425040622673743940195918587-1.28232103577210544092749099988*%i
-1.08626313046217207146354086529-.603564077613878631563626020582*%i
-.562186741976413998030875099978+.243995200064795224835855341925e-1*%i
-.164626274594888140299095846019+.836907973966068472472395227951e-1*%i
-.424593808914487209742255764698e-1+.370489559960753641530354245046e-1*%i
-.113741604618698446157412520052e-1+.132174563303302728564127616866e-1*%i
-.323290381281654030211192298021e-2+.450328301646971894069770095677e-2*%i
-17.8976970319697501177479547928+13.9182688529790800828114017678*%i
-6.69416389090168743951408643997+4.63003639623496519484280281950*%i
-2.42137689986506097472599808428+1.05986315047014402937557402562*%i
-.969462624907181390149002018375-.804218084901316747691796715490*%i
-2.99897492488412475374257398266-.676095589506938762506312087395*%i
-.377274362109029857247217300002+1.08892579859270696504127294702*%i
.490288016605738420827666522372e-1+.251271614921322911813882157024*%i
.248140939190036267737516036566e-1+.613786535936547902896265310931e-1*%i
.870759840278235769458037263166e-2+.169765250220253043804225959102e-1*%i
.293093893388814414945330184492e-2+.507430780165453883589436437636e-2*%i
-2.24918526184889148295200682877-22.2244672208384794347297395350*%i
-.796917642843468255353374976052-7.81569568628700561869903111448*%i
-.984795319933908316067055412328e-1-2.41389123648735218622596766002*%i
1.14751534649678444533618589720-.237348427589441805940435446214*%i
-.505905015959660490802696030758+99.9929549699905487169262658274*%i
1.98950120983209174020123100726-.520339678160753077204529761643*%i
.292558499759783186032991943842-.468988478274114910233803288432e-1*%i
.695600973175665308965775247887e-1-.933616756097114175855424196820e-2*%i
.195066711589684957850442801161e-1-.240111584246597996669878590061e-2*%i
.592248213155698765991550870756e-2-.693806622957644227050183404549e-3*%i
-20.4514593328230675853964891609-10.1592945445335609806867986058*%i
-7.65709469995347530323805543197-3.20314830287742674572009116992*%i
-2.81926992522864579291926935271-.521145389897065521794565530970*%i
-1.26810566229682993480306010106+.848224165224646902122342903729*%i
-2.24461398052973491088432432322+.507845909685123071942272453002*%i
-.563032810353532959232431851584-.788470523677522001007215940016*%i
-.209618452913276955302497457131e-1-.239924678351555379466267239313*%i
.825222023481942077783270425480e-2-.639270940487588835726351311551e-1*%i
.434946801404008763504011435121e-2-.183026023721966589529019635557e-1*%i
.167616379950827404505482685318e-2-.556373421530192725120507123556e-2*%i
-20.7473763198632107976366917959+11.7789896413115266118971020336*%i
-7.72366711299565932944305809328+5.07213913637846826539256598096*%i
-2.90302761930407612338343487916+2.48360460782116612485146017566*%i
-1.31702509753062311165698498607+1.43039985036820493006213346027*%i
-.923328362892927187784885281386+.666137366853463256119950331100*%i
-.503262856291771807772049146511+.784939384605331363017669702833e-1*%i
-.168376537518492568212655150535-.409261305956526231456934167298e-1*%i
-.481038149424597216838008397716e-1-.251911114748892384090754146371e-1*%i
-.137835166169417060409356599984e-1-.100366980959296968558040163095e-1*%i
-.410021015221442396370819265077e-2-.361142499115376843182284576328e-2*%i
-2.67952880147731385708819993650+24.5498655757111766399412437624*%i
-.775946599416146318476390226980+9.80563174456364277506159568238*%i
-.199025979946201696599722795617+4.11835051829432220851470107805*%i
-.128120289238412960197135746181+1.85327288827200836044524065057*%i
-.182091164906566695949351981643+.832801072338766200605825958868*%i
-.160594844008488344918513216402+.318277696738743696713839460338*%i
-.873981202756375097373840423179e-1+.986652750867076077779317852679e-1*%i
-.362377944192400779145999541402e-1+.270718251954070175532461007147e-1*%i
-.133002097479610429056391381957e-1+.716976233261592727676861202374e-2*%i
-.465399113128766373229764380704e-2+.191356057829352861659958744180e-2*%i
18.3492065431053995859714778246+16.9917137510614638656434985447*%i
7.30960933439851560901194143549+6.77295420729090072421539417169*%i
2.95094780227717226826091882567+2.81921215518184154605074218002*%i
1.17193047735094616577425658790+1.24884366417613517673995143440*%i
.426968835579401470374154666973+.574679265089118490255435450664*%i
.130799726282065724456315568615+.254771242628963785089638821296*%i
.314303566190630617357950593935e-1+.103019901665272756254479975508*%i
.521358388914837199227877550825e-2+.381820898573438612378591334666e-1*%i
.669531999706937981841756346577e-4+.133981308758493659404082313307e-1*%i
-.445880705913735484658684520192e-3+.458044384174549661683499779209e-2*%i
24.4158100480248253895813424387-4.60106249123315606915644427182*%i
9.67011547943071060010975563608-1.63615741498725265926498135007*%i
3.88769917869744606627130695704-.520585332686908577801113903556*%i
1.57588647288478381326481034750-.113639966064279813330936279978*%i
.631390970954077644853130480592+.139143613727180407830642831717e-1*%i
.243600432381312322901224039862+.351105956699387741392518236678e-1*%i
.891393342975907804379099591771e-1+.251772220595347936709822398826e-1*%i
.310555099056214604874559689418e-1+.132042908244826964635214784775e-1*%i
.104607276294122515277131138004e-1+.590190195196688085609714073209e-2*%i
.346252648400503485919372932704e-2+.240640489197863860962379736371e-2*%i
.287851172443787787487659256364e-9-85820603.9730956523013167536077*%i
.438876233511175589756698134659e-9-57483970.5530723543920198051445*%i
.669325741307073607482401204190e-9-38510157.0615529742480740180483*%i
.102108107408017326775246622450e-8-25803567.8793746213991838879035*%i
.155817565848305649904866244607e-8-17292703.6006288529083675747806*%i
.237855292072464013423850463976e-8-11591177.7625346322306588136374*%i
.363209060898767689808466369684e-8-7770997.59057436353164107458816*%i
.554824704209897579853406823096e-8-5210911.31299674927328534090206*%i
.847849178242054991161588683910e-8-3494955.15752837112152544987023*%i
.129614697011842280447041501288e-7-2344574.50945846869621036462846*%i
.198231486570627994704104951604e-7-1573202.53047430599613891518325*%i
.303308476332665824734710190614e-7-1055862.20139964802035632118091*%i
.464303249986317299734683831475e-7-708819.881259191389283816977012*%i
.711110349615029008236846516417e-7-475964.764604284957355180597907*%i
.108969367892271299894632444192e-6-319689.523090863090971979888400*%i
.167078073597262030015863556083e-6-214783.695609598609189923533353*%i
.256329794106661427936532853029e-6-144343.867469084598557380924423*%i
.393515742240505252742056640959e-6-97034.1224399489001597948013267*%i
.604546003707801730715097596231e-6-65250.6607528955780149760895175*%i
.929445633217810710178739927850e-6-43891.9565963827345793535286935*%i
.143011805932259616894929508721e-5-29534.5238778317889547546179132*%i
.220242969021384114692033122340e-5-19880.4156710379097630235780206*%i
.339505742302142860994951628999e-5-13386.8006388705446209282998638*%i
.523894724800066168461815770907e-5-9017.56311970031637716477531549*%i
.809346920875028812494989392241e-5-6076.69568240417423568818477505*%i
.125189282749458639564602597823e-4-4096.52766994065556255023281958*%i
.193908312567595607141658123941e-4-2762.72463528147000019339196354*%i
.300805849423562816054866596646e-4-1863.94998609750669847660296668*%i
.467423905288583141100374865135e-4-1258.07108252815962304483010189*%i
.727708487311570465171673798276e-4-849.466511569692282855483483079*%i
.113534768350076934382111726615e-3-573.783861866596651609261755341*%i
.177561283784531979924205206194e-3-387.699059439760545851046456238*%i
.278460806465177902515263519976e-3-262.034111017761733893358989424*%i
.438084035198548214733706938190e-3-177.130504660019991711585510167*%i
.691754921242843785975083706619e-3-119.738015885965047390312314465*%i
.109705769456083145338467399632e-2-80.9218811175509642159808926913*%i
.174882909146495587414937002692e-2-54.6545166759088272231467534194*%i
.280525242266792453521399756503e-2-36.8675163126549440180643816361*%i
.453443381461579369988003173800e-2-24.8132082974475993817937586284*%i
.740027172833657212523665558183e-2-16.6344284180915981957292042946*%i
.122275878255382170451891362785e-1-11.0742908278198122160299195045*%i
.205379291735903388090682953490e-1-7.27988801129265777178468839613*%i
.352859275782716339758963047724e-1-4.66842921315427556308499109310*%i
.626511946020817303042315427923e-1-2.83312784904609702032425865652*%i
.117096472789196504933816815818-1.46820789295776273791625596296*%i
.239215409816383158537806295788-.274624889008471888477286158654*%i
.587158741185623351291576067718+1.34609634317846210792680869190*%i
2.49607334578658537828742818599+7.56387684041759927341568585002*%i
63.6085241814863333643260511587
3.77271490492526430416255210885
1.23837129183137700510218872207
.557384125604692073073898952372
.285636389006598601761483001659
.156794141352669798789160639252
.897402551241498424324327832610e-1
.528052488581530421821470314187e-1
.316849526157158213852763360277e-1
.192882778585570647648914490379e-1
.118720067938649626102888705186e-1
.737092873608811755176749648839e-2
.460841795217036206813808500025e-2
.289779627917764064166241133261e-2
.183086379000701145729470392780e-2
.116143559270398053136860545769e-2
.739318091966727051833446463673e-3
.472020610487427590176419311741e-3
.302146995114209690016030682430e-3
.193850428697368363424806954514e-3
.124621431274261516737935445727e-3
.802602643358905920376866187754e-4
.517737014849170771830395382193e-4
.334463914765697762473544610569e-4
.216352045525845233052078621665e-4
.140117579259634133304875383311e-4
.908445627030471510287064354808e-5
.589576684846046747150153199206e-5
.382984989530190711587273255631e-5
.248995970895036036423511873702e-5
.162010974200086887394218206135e-5
.105490525991898562463222448978e-5
.687348976371051192519381718124e-6
.448142394728308195930482214964e-6
.292355790743939607352902589479e-6
.190830595742080336074423328133e-6
.124626424833495482608326612207e-6
.814300292028333574993377287173e-7
.532303139895489763583785445514e-7
.348114522751882366977921329379e-7
.227752706442937066234451647491e-7
.149064312788427843591802886839e-7
.975986318132789201049563524480e-8
.639242344616611018545309676846e-8
.418823990068438089190244546156e-8
.274495207027273916508781122576e-8
.179956969096844553891208188462e-8
.118012279454627718509418112475e-8
.774113599817063593650734061472e-9
.507920664939734244123159435267e-9
.333346434191540288437547982313e-9
.218826473983090750074595457784e-9
14.0689078019440971977735020008-23.5552366233993786019296909352*%i
5.34906652331895785628996731370-9.47247548614206603015754856470*%i
1.99928356762675563456095637221-3.90435569954114015168844976515*%i
.695213578971890722290780807202-1.64963818632516510374253434383*%i
.198104813647111517279357292433-.694830506918969092006928261394*%i
.338503337751132929433179026347e-1-.277570704778723742852473910410*%i
-.398706157996165894292278893880e-2-.102565361579217920438220789269*%i
-.641670403490029020110809251078e-2-.356343100448287710686769482792e-1*%i
-.356670712081580665350229314584e-2-.119912139809521237983747628205e-1*%i
-.157008513069602836798902694056e-2-.399442888764408779086066672293e-2*%i
-10.6167690778125718441964259017-25.6765100471426050182247369524*%i
-4.27676857918237595839227414074-10.2280369331567452994162194223*%i
-1.81679125599410126786901035198-4.20282276290530516769573307364*%i
-.888806319051366433441113371113-1.76852788973029125384096602604*%i
-.499446209519213431621611157045-.697066492063065078690366587026*%i
-.257392266888525363277839374603-.223762398094732232660280845504*%i
-.107843535764878959377429851743-.576258044805557050386887621699e-1*%i
-.393361611866786755376508683263e-1-.130140356474729055239796399420e-1*%i
-.135439953175026230860888606104e-1-.273422990975617708963585820769e-2*%i
-.458708771201847508764712625679e-2-.530183546007963064006627444843e-3*%i
-26.8435793500565364343030900481-6.72517446036849966132403120072*%i
-10.5338730904645133474286128303-2.88968396965961439756860673503*%i
-4.29156380162154465992192860580-1.42405963963905014563413358012*%i
-2.01803190664063848954490993656-.748228571168189953644069491086*%i
-1.11844161483117902652247806415-.160931356059615739164053883889*%i
-.448664933804709477176206508663+.130060134563929342106164164331*%i
-.125627157692393876371846381024+.882493653279977454692837586877e-1*%i
-.332316174884713694004543886135e-1+.346067442498599356127778277834e-1*%i
-.922332230640666798227813401587e-2+.120812838543358695577210123315e-1*%i
-.270531680144102942804800256407e-2+.411609149881319206735496656127e-2*%i
-20.8050471062539812266408880523+17.6255756795296657540136912537*%i
-8.12380028490388084479989477609+6.47905670734412434458571484295*%i
-3.30824818050152527059089182139+2.04867529978150648458285910442*%i
-1.84878792339450444329717108590+.183491684250159467113636922951*%i
-2.03692851912218512310216730609+.791779268227131634053038934406*%i
-.920819188642023329485533489199e-1+.800854504173762377493343514843*%i
.559520687806497541225113224955e-1+.189450751675206315577692266479*%i
.229386291432079354998327788193e-1+.493580172048812644028180936453e-1*%i
.790370731394209166077105287729e-2+.142844075306705549168872200522e-1*%i
.267052264845194943062834099044e-2+.440431114653613505855903370165e-2*%i
-2.61200662406784801885750871259-26.9491444083042632439805719444*%i
-1.00799948823585543826820979069-10.0646399676605382499975514334*%i
-.370557357707111060633790739568-3.36887478988328111550637911348*%i
-.576143233481757279985156279678e-1-.113513566404224031246837040822*%i
-25.2191380400202819461055161684+17.9842219043872998877066320610*%i
1.22481128228394089746799240677-.275670937139814139194949712772*%i
.218593298999253324802864666904-.323808100355869506999883530859e-1*%i
.564923670210098266801564630600e-1-.723602565943371864715298682531e-2*%i
.165941834418247402471672916416e-1-.198142150172288519087766324859e-2*%i
.518915468799478403312478031735e-2-.595131765953246732524784659365e-3*%i
-23.8481393171550796992972344532-13.3890912054068064157205245462*%i
-9.31877493780897053647363406445-4.85120795596268658087417332473*%i
-3.79634030463464753092457734025-1.45256638249299202624617651797*%i
-2.01969549384702757447192120912-.968589289054551762690802720417e-1*%i
-1.69262748748128234227083897214-.552449470369326814832406625654*%i
-.265245228947797361835177319592-.654945271939472666796985431747*%i
.414202156390379073320638607112e-2-.188436951130242623442909700810*%i
.999712407261305990037020655868e-2-.523596621589240866820271392584e-1*%i
.432218896907274374923848485733e-2-.155548264455138305551835996776e-1*%i
.160101869422605696435465946004e-2-.485896252916657007788169984368e-2*%i
-25.1717838507773238756330581788+11.6345721662041078789761371531*%i
-9.89659623290359533109793584200+4.78386195037834915097201433611*%i
-4.03870418497297531856106140924+2.13719885595539111525228289848*%i
-1.87720707776807279629803436631+1.00140598185324857140456034795*%i
-1.00936658593029774800463271255+.302609597079433271346830111359*%i
-.431190997957739546891191453581-.334922571952749839855906999372e-1*%i
-.135469384727696359860679191833-.546723975995292262281027623746e-1*%i
-.390987655211174651926997870609e-1-.253482236458084186485218076400e-1*%i
-.114955875222481538030088889196e-1-.952567109102423347131737180985e-2*%i
-.350656897994023828211952108379e-2-.337685289867164556719904123163e-2*%i
-5.67959898981432608969486948296+27.1632063547683282100828054030*%i
-2.36075578591837400231644423219+10.8136569331691478343708591133*%i
-1.05972005303272421115076315965+4.42615921102394176875877452550*%i
-.571339394632062363703291228685+1.85347709258048875829187939454*%i
-.355998446845504516969371857846+.743255843071512979218352193237*%i
-.199514197704434853635275592627+.257311561548268791271855003601*%i
-.897792055086285956067481940561e-1+.759607551956453592466982659850e-1*%i
-.345950082974860491166839092136e-1+.206182927694177030919256486583e-1*%i
-.123761509191955311547594116757e-1+.550082276314711627588242285930e-2*%i
-.430206190300658870396154167560e-2+.148847736417422947784732487708e-2*%i
18.1177870042779134440509759712+20.4486132628886221051223477860*%i
6.94502795518361868239808002278+8.28284313983506434740547209437*%i
2.63880895452526359347419112347+3.44301781603416317933077635243*%i
.960996611966341660538483063968+1.46980699809690720245190404342*%i
.314023375225202789784723892976+.628655748162226705245152018048*%i
.843678631868794042230045141565e-1+.257429872199918801084890137257*%i
.164449948983819952904673267145e-1+.982739993480097073470315164834e-1*%i
.114156414701154156698297895142e-2+.353078671644903841241503430956e-1*%i
-.931999148534357189004275878326e-3+.122355645134326593279311969351e-1*%i
-.676992722463180389703096508476e-3+.417390454541540783323754222661e-2*%i
26.4655872005042737086558761828-2.44254524387460915436435760583*%i
10.3787252096131634319979275574-.571794891018120282342004256006*%i
4.08655774360588213557420124385-.141887527984333688815825376193e-1*%i
1.60222646297713477703792467223+.110150577895940599696282332709*%i
.615852534772067823017601433272+.101543111884536965538472575013*%i
.228262750552409697045810548642+.643750551580243568898927127923e-1*%i
.810380186040602144395354033265e-1+.333882974730809187211004640294e-1*%i
.277381397139066928555264819185e-1+.151345895180398511873153066356e-1*%i
.927720271038915906143738269603e-2+.626907470173457229970809972626e-2*%i
.307082199782270773318144338968e-2+.245087134297133302742459273708e-2*%i
-.732889510790761953074918063583e-9-88375043.6242082350853717045843*%i
-.111676146818612452676557489480e-8-59233080.9451522016407465931492*%i
-.170213112261260915858410379257e-8-39708627.9247010031714178050583*%i
-.259502419671021869471547325839e-8-26625316.4115193374945082474679*%i
-.395741059704608581903944548466e-8-17856555.3470578610117356334717*%i
-.603681695452120204794477475986e-8-11978363.8123112048672087214248*%i
-.921167120342156633636492895588e-8-8037081.41901314546643362387284*%i
-.140607726751936580940858711808e-7-5393922.47405440499416629534488*%i
-.214697817365144699507662157224e-7-3620938.89288247138227968325088*%i
-.327945510350022869321407100388e-7-2431380.15817661149627947073064*%i
-.501117945283707528297484542314e-7-1633071.02255228260948764024359*%i
-.766040516540640905690254907073e-7-1097194.28353237505995808662289*%i
-.117151315527332963798034429462e-6-737385.157806272186209793316599*%i
-.179240965637093771803757247718e-6-495728.874496467135208287309853*%i
-.274368409369024746399984942152e-6-333380.404676913005176118919167*%i
-.420194977662845331993847562210e-6-224279.482289333412485362340139*%i
-.643875680208317777183683355937e-6-150938.773476297035221491083976*%i
-.987196393457925104447089746392e-6-101620.820548084504962154455606*%i
-.151451335665858921576423113700e-5-68445.4686083174665938498110323*%i
-.232503885591004609997610731263e-5-46120.8297923245459799240836446*%i
-.357187813547960637041946056251e-5-31092.1719516641747017064232643*%i
-.549157164853769688828705411466e-5-20970.9741471985917514531991150*%i
-.845001577287695901419434351737e-5-14151.8370674982073672427690255*%i
-.130139733870915490405402499490e-4-9555.37845680510237138102251189*%i
-.200626624598001142084131681350e-4-6455.63874211012378263759188539*%i
-.309622835911530504734304570320e-4-4364.18849720925060220799664023*%i
-.478396908809729683816591651732e-4-2952.28873103117685322594783150*%i
-.740127824701734670589092859711e-4-1998.59480939176812322826715938*%i
-.114669617686557625204747305898e-3-1354.01135777563897498102882046*%i
-.177944112744942797222451164451e-3-918.066052106926134225452619374*%i
-.276627467949073814540764376222e-3-623.021833332151893887517419536*%i
-.430905156367658725009267601983e-3-423.189324015179482323738996716*%i
-.672760770316479944180815677455e-3-287.734825881139011970811567588*%i
-.105311337488858547952614946869e-2-195.838794101616090437656248978*%i
-.165348629356867550084803534918e-2-133.435327473531786217900450493*%i
-.260528765220387180809027175939e-2-91.0154744846535601897590776025*%i
-.412208733188732535040307458305e-2-62.1466043456886589088460443950*%i
-.655454220446097426510079741596e-2-42.4739454351686210259992439200*%i
-.104858256236678412332552798514e-1-29.0469120085718363549455060902*%i
-.169019483403041599227970894337e-1-19.8642770264186983509794833243*%i
-.275066966741068670871645854228e-1-13.5668253688829048710455748798*%i
-.453323352274532655191683571557e-1-9.22934379254169622224068581670*%i
-.760037034779757581776358273092e-1-6.21932815734540506838693044716*%i
-.130606586413188384308826882846-4.09992540163375547050122456032*%i
-.233126394490400363481437370034-2.56032310829737314387104626079*%i
-.444102142997496345580944796429-1.35544557997530291449426933286*%i
-.966512670402128120143520164178-.201130853720834271033014862803*%i
-3.13353904411927459208017979982+1.95673441376320836137984542589*%i
18.8351514361022498753919690072
2.10865792323381863115119361562
.828565311839359882161419171157
.409213978882475010031956288101
.222118883456359396795824570031
.126815700013253899840940713355
.746897573066656555144733621350e-1
.449174726006514696980062403843e-1
.274183758812278688736476621207e-1
.169239302929363520548870707745e-1
.105365106616234511965772518335e-1
.660481493150636027368679675762e-2
.416328105461108909026438588622e-2
.263636724360777764478256954289e-2
.167591733974597217948146319110e-2
.106887463557522297400802415523e-2
.683644459704160102176053128862e-3
.438331891484371913766082444564e-3
.281652720142812136951331628656e-3
.181323563777157181005045110218e-3
.116931872632295203587930201507e-3
.755219025595634698864162817131e-4
.488437070982403299804726407595e-4
.316288598293487568339278373160e-4
.205044822490280218673057676169e-4
.133064392849408182211444589052e-4
.864341519506949115357509163927e-5
.561935529460468445715780074529e-5
.365625183121909941166710588812e-5
.238071994543939448117224774234e-5
.155124355463864415137865818956e-5
.101141733591015890280549686437e-5
.659843347893470268366082525502e-6
.430719432050996412740564595246e-6
.281304039618564903147178409994e-6
.183810979701322451997196538074e-6
.120162300147426768122742928277e-6
.785877274772835773128277685406e-7
.514186087282323099315837572724e-7
.336554380951812983704978214635e-7
.220369012326759488252035536722e-7
.144343708911189356081025400899e-7
.945778822531628786015718182089e-8
.619895658884155652813000151510e-8
.406423015712593039557666429892e-8
.266540095497797355495872290003e-8
.174850003987125877481611104667e-8
.114731390254247258230935567161e-8
.753021535501970615465862189860e-9
.494352126337876733334230500527e-9
.324612259070196388302217473729e-9
.213200799336633276750409049771e-9
13.1115041606317694542671984644-26.4038847893482902053882396903*%i
4.68237408761395494542971391401-10.6429814705179077639438779271*%i
1.58175743321689352554035885529-4.33436029803996872725380023076*%i
.466892471117249510345787798741-1.76817409186233146104914733891*%i
.961881160041040263461428460356e-1-.705262292131817079599896118205*%i
-.152898918841543059695594028736e-2-.267075900553410337515933031784*%i
-.137052754108824985479521110778e-1-.952809234463803881734413663879e-1*%i
-.865735651113643676778545885442e-2-.325905666512498918834997611533e-1*%i
-.401894818238925130663459425365e-2-.109345891660271731222438524858e-1*%i
-.164830141810621919074969651664e-2-.365468361621885893079021582282e-2*%i
-13.7750771906784776591387993578-27.2635482236560057739540291403*%i
-5.88926447653160305614265513766-10.6981200569393749721103776335*%i
-2.62799093705222442462115804598-4.21962713481476636615229449962*%i
-1.24696836793865942253609749834-1.63372390706830676470168304985*%i
-.605117708988037235979117891573-.574778796637999522627322879659*%i
-.267933815296344094475801314683-.167783730538386762173464710067*%i
-.103424636970386202813226963544-.408778819532921450844881080159e-1*%i
-.366021359536291347394780985898e-1-.889172151694763684051200785405e-2*%i
-.125193776998189383140511865385e-1-.177435724034713437155956249173e-2*%i
-.424962840081202060138677447811e-2-.306030496832097347737252005868e-3*%i
-30.7482713206703005586036051386-5.65891200506090763418257306146*%i
-12.4164467735460038826603994758-2.07813793244807198385329010453*%i
-5.18713559483260248951220489767-.762379588920993944439439750759*%i
-2.32803398324450777430354575592-.193228805451094891812564043049*%i
-1.05196301015118092236184054639+.145096299110629474299857162096*%i
-.361584603839205118816572493896+.184600394342312955741019305311*%i
-.995248534279477327202433259374e-1+.883002565993324659656566616720e-1*%i
-.271065895259122656002028832984e-1+.325055658139812512538209235944e-1*%i
-.777482293781949930946569826406e-2+.112247681666761802336685149440e-1*%i
-.234392944263909225043292356048e-2+.383145329770466153028177675792e-2*%i
-23.3376608267417730643901456079+21.2317379098081230242824640579*%i
-9.34241965327612601904677868956+8.46213254384125931117123424292*%i
-3.93426635352484247725115077672+3.31290133945850786090318993507*%i
-2.05300716818533859311698788860+1.33101974486396259868093745234*%i
-1.13714672245925517384123528305+1.32955662330027798391032337795*%i
.419508960549738735175380352519e-1+.607560603623043816110844979131*%i
.573518743938710461883447443327e-1+.150479925383237639162646885910*%i
.213763365579615598188139383029e-1+.414848810985645401800502540843e-1*%i
.730882578657812567255662760163e-2+.124641158079670841951762940504e-1*%i
.248089591435173924172479565617e-2+.394068088620971273455464225129e-2*%i
-2.93035200020438256418611724501-31.4381964741186659342191654267*%i
-1.19560489719049049617359099437-12.4234240998459273501630941920*%i
-.593529902511956071058314581271-4.73926255443519595171248424867*%i
-.737096072746559581814713872014-1.32627805127724329955680564840*%i
-10.5001585103432343367460441686-3.63900866191080019473565122090*%i
.824105111089409914022667214972-.159682935253616720328267920217*%i
.173378374737584077742033562406-.239521100246201717805755157201e-1*%i
.479526780084452641094135601731e-1-.590617212291666155253060938916e-2*%i
.146180452984952999599279206399e-1-.170263255944471862690883298018e-2*%i
.467942299951370711400213321038e-2-.527580050779474241744286291526e-3*%i
-26.8113694237624530570337051176-16.5796015230610476517390772388*%i
-10.7387100349255661006536286889-6.64672158809513506790241881022*%i
-4.49853646427867340722452734855-2.62528255399910876615559574007*%i
-2.21595495608910456943800230340-1.11274126019821664435004160456*%i
-1.10762365873506712433306049756-1.02842538670951731290307441785*%i
-.104629641235135734168174595682-.543191110102293542025697414482*%i
.171465061877225258189129034577e-1-.154533910894770244315550048089*%i
.107785070204206432349419057010e-1-.446448397091441138730264891055e-1*%i
.424570956471822279259249104458e-2-.136789726638025421839205892392e-1*%i
.153818897048812644604224430371e-2-.436840828968729965186755328689e-2*%i
-29.0938651442159920546139829211+11.1461895024408128208474041984*%i
-11.7993765423639974499081232976+4.24550257436962537763257730817*%i
-4.94827406305988766107868908956+1.61891198133265478934590120681*%i
-2.21280262850508574225721939985+.542612147624248700617229611127*%i
-1.00050515088348447181813515101+.353383126119367368599857011421e-1*%i
-.369495494494259403830350479070-.987367352443861897478669396344e-1*%i
-.112420946188606014849948553187-.612630072280418504818900568896e-1*%i
-.329611689581050793322051834783e-1-.249909975711362834802668768442e-1*%i
-.992737929833857015132085347050e-2-.908971146851643044017509342745e-2*%i
-.309469684279659939476155585103e-2-.319632507784786454547058221405e-2*%i
-8.47254639880024267132194218563+29.1484837513912314684220128967*%i
-3.82116060281373925352319030588+11.4865591216895757037198264560*%i
-1.81083228918020717472840451791+4.55415606549919073869006282289*%i
-.915141652415940569467049952930+1.78391454529679565694227975343*%i
-.470458388086736311793899315805+.652960466526799658845546478582*%i
-.220149662092218849547352923492+.209898932309392264475760419952*%i
-.895653801675429961241715002918e-1+.599051731511675445456259295580e-1*%i
-.330554726185675653896525212650e-1+.161961269255532150469556415824e-1*%i
-.116492054733286002555699851261e-1+.436344166249614965193643821650e-2*%i
-.403693829412579539704920724286e-2+.119750168691653142686534003163e-2*%i
17.6478710816826063160956532038+23.3154897314476732509896932169*%i
6.49571491893555567346463343213+9.49103473052113180485791243494*%i
2.31670509988392652427020312062+3.90884411582820543380902424462*%i
.770684695748752998511327596389+1.61609262882499981507025442297*%i
.223248834022929730975452997291+.656352412630959352717105208915*%i
.501968451600123142862838087260e-1+.254865010457412157950685887323*%i
.602192112282322341830144665731e-2+.936776224085992141612746562860e-1*%i
-.160197677968205485105887517423e-2+.329933589698219980112935754798e-1*%i
-.159318302092544877828478127884e-2+.113516000120891003136881887059e-1*%i
-.828048546582827633409448538672e-3+.387170659908577027116461182667e-2*%i
27.9881034340144311410717671560-.523581227320247584471275293661*%i
10.8623943967031945917598830263+.350327609252380761479016297010*%i
4.19723655582213746285595666262+.407088697050586291331839595073*%i
1.60101853736332496053630641954+.286586194286492588557784900628*%i
.595899631508665600470704005916+.166610444838566385467708704805*%i
.214387200336033958674203515600+.848809942853790296547239464252e-1*%i
.744894959481477751771245839637e-1+.388427993984408341198980498879e-1*%i
.251983797972538135544382090637e-1+.163454648254484805020237500440e-1*%i
.839599317395276702690904388447e-2+.647814876665512120984435115295e-2*%i
.278315097709640172683651702387e-2+.246734005845095096377984291571e-2*%i
-.718437583987801425604772095572e-9-90246965.7220263146995584509835*%i
-.109428552828086198197431515731e-8-60515583.8008746980308224752230*%i
-.166715225894200118171241477967e-8-40587911.6225770736594935032440*%i
-.254054856468459677836039647533e-8-27228588.3562471827202509019309*%i
-.387250789639971292181320861569e-8-18270769.4546812176147771195449*%i
-.590438943665439751699377920566e-8-12262993.0487318339514162513744*%i
-.900494839715364681620733703328e-8-8232827.59744469355051395880067*%i
-.137377975851818547089906417103e-7-5528658.49870783405750036031199*%i
-.209647269652817199473478067424e-7-3713764.88937581688905110331608*%i
-.320040244688425944830151861377e-7-2495393.60436977638739816674825*%i
-.488732139429070144788380673831e-7-1677259.63192569664664903997579*%i
-.746614451082786878226979197257e-7-1127730.17529564433902001556300*%i
-.114101152352461061687035484600e-6-758510.200802161875188302138223*%i
-.174446216192589705028934254137e-6-510360.719081735399774458655818*%i
-.266821959281390383660472740960e-6-343527.582039068374205063623238*%i
-.408302142754133535580191760037e-6-231325.911125495411644213697816*%i
-.625107209265691893286500809864e-6-155838.891885554417269232492327*%i
-.957533640028231865981812453327e-6-105033.514066467725543782356742*%i
-.146755908325364069420283627896e-5-70826.0590204030674083032109000*%i
-.225058860004759896676032564784e-5-47784.3064700568125615998682469*%i
-.345361867895242163405523204546e-5-32256.6907282284140486774079297*%i
-.530336238711617822672378270922e-5-21787.8066539862098012554811164*%i
-.814986131376235508472521328749e-5-14726.0091433395627118685267306*%i
-.125342199984634539745182386571e-4-9959.90530655724555179731765366*%i
-.192939920037439437233234982290e-4-6741.35290758846577509921802119*%i
-.297274715716393344013164791344e-4-4566.53190068628781292554834128*%i
-.458503845183651177581388155301e-4-3096.01154030763806854801729641*%i
-.707979484098256144405233586067e-4-2101.00978368089693409820163874*%i
-.109456416639661436820112046312e-3-1427.25035391379035302223344840*%i
-.169458309711758827529118894413e-3-970.646548669297402818894581961*%i
-.262756633849885189664764527068e-3-660.935843359153932624728514624*%i
-.408125729395786001620415351169e-3-450.661334911730493331108627840*%i
-.635154401533676628016129911725e-3-307.750118025347040382287682210*%i
-.990660194365830833980572000645e-3-210.512261698756426962375197041*%i
-.154906711218309612816892550158e-2-144.269372670867497283281086649*%i
-.242934264103763818111217271828e-2-99.0806578239576985042293212400*%i
-.382293707112213204251192605915e-2-68.2084420479635849710120672554*%i
-.604049104613354483840734751384e-2-47.0821243991011803043644280271*%i
-.959125156387130834949044301432e-2-32.5982698774308076070192754181*%i
-.153210894578624871909665479681e-1-22.6474995104175818110099531858*%i
-.246593967699890157416771580652e-1-15.7944985545089010658886268511*%i
-.400783716488778927300538241793e-1-11.0614895495950609179371933833*%i
-.659950762056795799782801686366e-1-7.78174977341450307386720493660*%i
-.110686337549357010969190402043-5.50083783931021895774902812224*%i
-.190850895288389312276847916679-3.91118078229249017089139169098*%i
-.344622944751625904192708386412-2.81329352557547024523732028217*%i
-.682020305119840459909445330323-2.11577853193599603459361224088*%i
-1.76064471821524052938154462316-2.06891250108332311491769942505*%i
6.78742606672323608514743164970
1.35084810181539746945386880208
.614399971242543580320889604975
.326153394205385171134066599318
.184929645706131797961806875170
.108731057747549586183970886200
.654094967953210944547272503414e-1
.399715259634444186140196252744e-1
.247072838854724077824945709424e-1
.154052598787642938880122471337e-1
.967098237142119407529980802236e-2
.610454071806536708668158558959e-2
.387072525737287843889949641397e-2
.246358835929013781657890876343e-2
.157301292402095135205431438036e-2
.100713778242340339661031814322e-2
.646369112899052298446073857389e-3
.415699173968796834121420123231e-3
.267842009956209137451491290788e-3
.172858509817593327797843508959e-3
.111722531747962421140932409789e-3
.723044794112633706717965092007e-4
.468499973526861788836534164788e-4
.303897239187369717716135332980e-4
.197322109707800538115688316097e-4
.128239156066909467671059891332e-4
.834122510012808539981997051172e-5
.542969378174880254776243350297e-5
.353697715118067757606161361507e-5
.230557027965216102566437877960e-5
.150381265802545552386045445348e-5
.981432469011647042119969297764e-6
.640858589989241334768845380555e-6
.418682111163334576818023714676e-6
.273661464566383294244143504487e-6
.178952491948039967523029123487e-6
.117069988372867229019623318968e-6
.766173114181175379775822252526e-7
.501617134749312658873124427456e-7
.328528684914179891565714924816e-7
.215239375719382590665820530333e-7
.141062074536451000892313103946e-7
.924766484102422594312276269378e-8
.606430191747542975038415089675e-8
.397786973449418039373621557566e-8
.260997171130778444183768231204e-8
.171289761513798931615487368319e-8
.112443036685276751500609013115e-8
.738303259399178633923020187703e-9
.484879527368741257269366695385e-9
.318511995793245235389150000929e-9
.209269965184583777954523700301e-9
12.2313692828568814567827891282-28.5041637352488764445615990871*%i
4.10289600901420635307391105765-11.4738511458848949933352104801*%i
1.24025966010293350533096534704-4.61684612252746689174031936498*%i
.293375325970218539152415337099-1.83338594084437655748681359880*%i
.244758824139700135403978307697e-1-.704199733745729787668923530806*%i
-.248698125045345010077746363102e-1-.257456641861859198946795871832*%i
-.198353820391337765751507451963e-1-.898326218442229795079288059663e-1*%i
-.100270073931318419303622289670e-1-.304505089348719101715920675956e-1*%i
-.428676232372644212460942472720e-2-.102093791852687148709846678178e-1*%i
-.169194848249518089744521315464e-2-.342358656576652577832048673537e-2*%i
-16.3036685495724741707098521343-28.3067091038139146383283462865*%i
-7.16299058562985979923475633533-10.9310216155923806251316472794*%i
-3.23713290936722326665053312532-4.14967502450795192382566341582*%i
-1.48831411147881702371963865020-1.49651053884965752704687081351*%i
-.664470327960211618361095522949-.480263531289360186692748967071*%i
-.270330366842335327344998569583-.129853114916804792634654579994*%i
-.995325788995444096015315892203e-1-.301471846626136344199977450759e-1*%i
-.346281271181676675321419262492e-1-.629386097325109200729436764876e-2*%i
-.118107361602220500843361375389e-1-.116973683564073434458521914759e-2*%i
-.401914703921610642496465478575e-2-.164153201057387162562071730698e-3*%i
-33.7914339713828062454413982446-4.60196868288663817160840741874*%i
-13.8492429650610174721087406823-1.26618355321966700799293957532*%i
-5.79695268090964910344969032779-.126420524173572363211332770653*%i
-2.45937083432893243491149120608+.257785053471271108065727965554*%i
-.965034095817970717876269611196+.335430122242034774444862559142*%i
-.301888485195175739319285596058+.210863019531495435924947508417*%i
-.830089001306900676206629027901e-1+.868841217022834240617648582171e-1*%i
-.232388223340014009510194250607e-1+.309376523305119104605096597392e-1*%i
-.684849506198602401809882267866e-2+.106304043568847774364288958541e-1*%i
-.210963998132476327018921635122e-2+.363692886539355045812184903708e-2*%i
-25.2843456967190563118494922454+24.2799860342020219796332002385*%i
-10.2288574922869768771599259522+10.2433197005836290165599370387*%i
-4.25435724598345455335000433633+4.51268867787659134334228996720*%i
-1.86787533970974548126518324777+2.23897666247237605056156207303*%i
-.521861460308211852804801577963+1.44513657894485263506995801170*%i
.102783317777598283712609148027+.487427581542669603721285603581*%i
.568138232140857503989347278323e-1+.126830031975270485101996548286*%i
.202348161241643803519306145387e-1+.365521722471798017892919576261e-1*%i
.690120549884509104465790762149e-2+.112948117460942694965885424214e-1*%i
.235215947707666472096636159181e-2+.363749696407369286087405939491e-2*%i
-3.16408490439372337160571730800-35.1843938856920727554711230683*%i
-1.29830453176235172564019592494-14.5470927452459906433789292767*%i
-.613495857430899191223761411514-6.17774438396254183555421014897*%i
-.570014870274201229808751053943-2.77275671127670740295511318043*%i
-1.50718945928942363546511362363-4.89959805066195817528452436386*%i
.613474161325334425281746503330-.103863721696936016883237835731*%i
.146497222647330587978093926225-.191475802539656014765864642809e-1*%i
.426061115119678686970190989978e-1-.509403329503792867980013071471e-2*%i
.133447206685266860908086501877e-1-.152592886002599346419021615595e-2*%i
.434488552145302703009439231839e-2-.483761929357722466431264983945e-3*%i
-29.0949448222429410669267495493-19.3018372996453041754480747516*%i
-11.7840485331512528576827524229-8.26914705974088157203057179150*%i
-4.89165556634838559612490488531-3.72593811451310731796828900151*%i
-2.10023577020839763889276907104-1.90638924752963942453563994934*%i
-.671518693718089825250385042871-1.19733070770222836721472783708*%i
-.208017951184411002568448223618e-1-.464487581426427226740232948200*%i
.236858930283984963861453819990e-1-.133295035708425174871997280599*%i
.110904091655258657332566839328e-1-.397456104101650845182387857872e-1*%i
.416766829371052397269272733900e-2-.124652851827258075719232394413e-1*%i
.149165438067712824579779951209e-2-.404620934421566040544198715240e-2*%i
-32.1617439692295022234062428818+10.5434928520263201834058714884*%i
-13.2575986992660240369432223970+3.65589717164082288254842986208*%i
-5.58422365207094089850230481957+1.10418798275390799247859027494*%i
-2.38443353898439056102487552780+.161800777466361751303774066760*%i
-.959105791111322366219453178260-.140234858699303223475461898409*%i
-.324308981083587428110139017621-.134696414170663107613172301423*%i
-.973410819481047933752527614014e-1-.641496373800271157457498659698e-1*%i
-.290062868906162353081442502136e-1-.245315431544884416511098697624e-1*%i
-.891078459328060837843457984536e-2-.876389227574515780535444424120e-2*%i
-.282502502027962749718124692532e-2-.306906085839450883560734112110e-2*%i
-10.7313947297860749617526611340+30.5132273518234842472272854380*%i
-4.98638688462784691177534129207+11.8871319419056804095391327733*%i
-2.38293420054608903983353038365+4.57686353724919244973017836122*%i
-1.15396202345638587132618748418+1.69744467315474393511297470704*%i
-.540031749795252561690984045259+.579687268122426970750193696578*%i
-.230142084960100580873806776328+.176646552075162213533782176874*%i
-.884779540125645802227475585289e-1+.493178427777240358204624328008e-1*%i
-.318479546667071781310946619394e-1+.133392558114906727218001743653e-1*%i
-.111299949521069345087213192216e-1+.363055173633382047427805672543e-2*%i
-.385261050897032469129834937083e-2+.100921047284109575251046310052e-2*%i
17.1386959540595852499158007673+25.4494885296018752440979367447*%i
6.08002031691896242179715057524+10.3628326480561165675295391665*%i
2.04458792049173034620308381511+4.22558230585403590748372723813*%i
.622589055823447046819015398161+1.70516392491975650495820160013*%i
.157824035498558085243906422587+.668564822508316452031406742017*%i
.270299318452163611545015496409e-1+.250794500151024929627332462662*%i
-.764791644845762636111906609481e-3+.899961717121588147261262635888e-1*%i
-.334711180327348275577350469877e-2+.313156946543815705162342126378e-1*%i
-.200806332439394675034554564911e-2+.107335750256922036201031405956e-1*%i
-.921839310345295752962133072016e-3+.366352130986112391306702057911e-2*%i
29.0245540550581970274621477503+.977981703533927818027145558168*%i
11.1657212178654517006711724385+1.05753808945461446549538444400*%i
4.25086632066410023159419820134+.720417595090298308991161654963*%i
1.58846642424778330189998408648+.412640888615036484926608617859*%i
.577703127102346052728535484965+.211047271361391454901006398560*%i
.203583468061363055981831760865+.982727530694602807004425533031e-1*%i
.697245049476030654451384205332e-1+.422535092237954227542102538733e-1*%i
.234148421203153367539195825352e-1+.170644087956417465188240863925e-1*%i
.778866540912741936878662574616e-2+.658984772158671583144538230002e-2*%i
.258671459441376208336833950684e-2+.247031655132285879773102651838e-2*%i
.271158240148558918909345839950e-9-91389464.1616259816042610221484*%i
.412910719043979506127940118887e-9-61298639.0573799746317487947697*%i
.628909117207986171772227366365e-9-41124989.1142320671744049167935*%i
.958125358661540920320172784253e-9-27597228.9017871079587272332906*%i
.146003783172557551462855386401e-8-18523993.9237315602264521196295*%i
.222545159425312280644062248600e-8-12437077.7170721195248353198202*%i
.339304603624621866932905565189e-8-8352607.70055217250190813904291*%i
.517469287046478127342696924865e-8-5611147.57235783099718726872501*%i
.789421085835028768426537331817e-8-3770626.01256897289896285680751*%i
.120467178211515849466272733523e-7-2534627.63481193303003768554132*%i
.183895748759431234500145070407e-7-1704359.16600898132025995827084*%i
.280818172711107906547936581335e-7-1146468.76725083549666204533797*%i
.428980504572560426189620881587e-7-771482.448949815319630224169548*%i
.655567911474014419054549600257e-7-519352.091700819180291468493711*%i
.100224833524765540978709625530e-6-349767.819749245331136509300686*%i
.153292580538629277995670419670e-6-235662.772774132870022609566287*%i
.234566860934754119509078376703e-6-158857.366730328365902182275539*%i
.359107607268794496788155890990e-6-107137.676083980364889246465111*%i
.550058568030101802308858488758e-6-72295.3127614527300548557467517*%i
.843014441559354827855703202889e-6-48812.0666315617292577988656576*%i
.129276576144656835157017205749e-5-32977.0034916835539257784042462*%i
.198372865632155814579911197547e-5-22293.6876478390446238740945719*%i
.304609387598144902348216115524e-5-15082.0867911914605918790259605*%i
.468086762061811963030474400152e-5-10211.1461378363956125112466444*%i
.719876246966247768398219842673e-5-6919.08891012387679863470462713*%i
.110807067685627314668305428711e-4-4692.62844266216407262892923985*%i
.170721773979782874038533054468e-4-3185.75260812820611763100170720*%i
.263305919007133523875297965999e-4-2165.09754939616936422450009527*%i
.406561872497307899887443255314e-4-1473.19259517288897628399664530*%i
.628547155411861274744455464910e-4-1003.72053186139342374566032230*%i
.973090952250774424286188583883e-4-684.858848703728579506874658157*%i
.150883833685637838111592032032e-3-468.057759682534429339887134821*%i
.234362287398578149505548052332e-3-320.477355042798911317276093277*%i
.364742610806408064601353890252e-3-219.888412943309502105579946997*%i
.568928210987392412934084140180e-3-151.232643009374932320597890972*%i
.889704103892152404077061571278e-3-104.301140193862850829121921331*%i
.139550355728611917951297773249e-2-72.1666868502070131318431778082*%i
.219654986794540456038233581034e-2-50.1245109614265543426899411823*%i
.347191659774787848329587787607e-2-34.9761665417438032131960370799*%i
.551572845845746957922296022480e-2-24.5450973727507053814435742612*%i
.881796034115685441337487023596e-2-17.3487459906318680678493450182*%i
.142103987064501117481332096886e-1-12.3765402779755730655196565977*%i
.231424558223147128602286938583e-1-8.93961920421409328415442237766*%i
.382371782304981561257675500350e-1-6.56940681830045500832679554952*%i
.645260676949384655840265826813e-1-4.95006660780515388899289778273*%i
.112645395111422668779797783259-3.87658645474736269358698830073*%i
.209615453028109056456455629109-3.24260866307968212054017986154*%i
.462570319558706519913681423892-3.15607803198380678924548792955*%i
3.30794567339217341213100972708
1.01862781031660846222029072712
.510647582702772338485881630575
.283875940492669251895330877844
.165420592479749883722165062807
.990472326731693229231031710111e-1
.603653194333649244482315035171e-1
.372523795492874535629544949357e-1
.232033211402324400498115589333e-1
.145566175865631779451182553410e-1
.918439131643381332753614853913e-2
.582185908125283159976342272874e-2
.370469704608125815106422917727e-2
.236516658093955054038768504466e-2
.151420241664346930342747690399e-2
.971753029748621319997358469286e-3
.624949907244299493727382923711e-3
.402664198464279619850439781027e-3
.259871589453937507770084162868e-3
.167964092191945567595104316457e-3
.108705455211484805475862237332e-3
.704381860501589099049609705739e-4
.456918979144231359388280359726e-4
.296690051332863672421245992530e-4
.192824971084870399015664278204e-4
.125426180929033707826425170832e-4
.816487573288000751725977735853e-5
.531890687489145200270325515772e-5
.346724304065736923828728542168e-5
.226159721134427860560493887614e-5
.147603721111449796468578515321e-5
.963860468162645823831985727454e-6
.629725269405929176688776362171e-6
.411618401183407141147696725677e-6
.269173903718506020489374817047e-6
.176098025825820379659307011208e-6
.115252185149828794147933639920e-6
.754584031887771712869921895979e-7
.494220974178669670098749253005e-7
.323803753093913343619535158953e-7
.212218066028772198616757009495e-7
.139128390393543536632867841120e-7
.912380002923765307436739476211e-8
.598489372995541464706816040714e-8
.392692239419954235965462646825e-8
.257726011930309534936217389175e-8
.169187959610202127864037577904e-8
.111091652878928487410229287832e-8
.729608647982420274093825071865e-9
.479282020470442633785063773399e-9
.314906199092511686579979804987e-9
.206945838718124763715897892169e-9
11.6194858720744071022515287948-29.7863592577110506981511035332*%i
3.71264651340722892969981429954-11.9668116687936781413457894922*%i
1.01867387608311334727929128763-4.77468153542986019449332835989*%i
.185865065095797596550042277547-1.86435856077460654744546107139*%i
-.178193335788143390939733302975e-1-.700282487577335162817822867314*%i
-.380678286357185365052881138942e-1-.250930101798225723006181426215*%i
-.231983944510703074832853474041e-1-.864904759028162665728453042382e-1*%i
-.107617519913746346044689970870e-1-.291838913904306805352348901434e-1*%i
-.442688731012895444814194914085e-2-.978632132404490884589295725325e-2*%i
-.171361072538925962183261876541e-2-.328949171734768049554107804138e-2*%i
-17.9340347888703531716660065627-28.8860609900665228718972105013*%i
-7.97454673896384365627923214641-11.0226965566656134932120754654*%i
-3.61097007362159883655472917856-4.07256687497783511975224571526*%i
-1.62529988333567279617770643944-1.39863986642291246816816135998*%i
-.693563822798732969666108850638-.421538526565552683527932364234*%i
-.269912989932829059404005548951-.108049940792672550810631788362*%i
-.969545120605630679761421236086e-1-.241880556195310230630394940648e-1*%i
-.334422576508097459002044969562e-1-.486535727096567026014534195562e-2*%i
-.113954002079365905470518627792e-1-.837151928060739332055752049896e-3*%i
-.388504504404729756810797619546e-2-.858248427687091356503477363820e-4*%i
-35.7191218613312383689213599314-3.83133770364355049888692379361*%i
-14.7365252044641462836314095805-.674215640104696526255488368810*%i
-6.14002797630649578093283653434+.322137195249336075255789942486*%i
-2.49853226677619228741414359547+.543656845651727416661006750538*%i
-.899945456007893356320391171062+.436753890896376607182275391525*%i
-.267478508394504953450416337824+.222134151964947909834590254770*%i
-.739077450969614312014873761379e-1+.855581856208887352338404135961e-1*%i
-.211059323165419082008452734052e-1+.299800373485426329226446368756e-1*%i
-.633287177627464413369687868217e-2+.102814182359187714415794982629e-1*%i
-.197797019530103828025908132477e-2+.352370035505250654439194972267e-2*%i
-26.5022651752542297744507255830+26.3256426991339443776333223888*%i
-10.7499816085763755282240483693+11.4795446916537157435649118029*%i
-4.36439724498474092484476540776+5.35418160182650744756403885232*%i
-1.61412386818051672466292985369+2.78097547744965384695871551747*%i
-.185411870684039619305231286842+1.42674213901294846319196095884*%i
.128198496942831265040489011893+.422555924076721806078608540993*%i
.560151371901956573338058148343e-1+.114135969874453237186156970489*%i
.195466331076127560835638527587e-1+.338432204443675968481992850374e-1*%i
.666375135727954625325769192325e-2+.106415026026419268323964822791e-1*%i
.227753800656138733031788799668e-2+.346603531866418929631117817388e-2*%i
-3.29966142916195788588445711888-37.6832583819173256540709691668*%i
-1.32589274447159977312331763405-16.0335758236594565522124776458*%i
-.509157878294311287697081819487-7.25230938448274272962640132513*%i
-.781270543577025198129452530070e-1-3.76660368271152250887876631035*%i
1.47832795205771054767246366020-3.12518166514770379884153084376*%i
.511040032933338231352678311203-.784815570073218461644682873840e-1*%i
.132246804996305091471878124571-.166756479978597606750303279797e-1*%i
.396697749955164526269983625443e-1-.465562802893871267632480112660e-2*%i
.126316647402799744605703413938e-1-.142808370885786041932442820502e-2*%i
.415521232222357935542092345595e-2-.459115037046046772419634649080e-3*%i
-30.5277019499366267932964781353-21.1382778676143084655194801787*%i
-12.4085105282132873829325769863-9.39756065951839186093032002043*%i
-5.05879181307981305347266010955-4.49317608856282979215918450732*%i
-1.92180575843281486547024023278-2.38331352929428743820483121620*%i
-.417308987708251301801614971926-1.23788259002530944907836894045*%i
.189880635137405897336510071037e-1-.418795937276375826508575203106*%i
.266903510646702271769009649490e-1-.121654702785370537483366622544*%i
.111943907171919054073105907253e-1-.370307939765926430183679715232e-1*%i
.411302390543210984693061171407e-2-.117839245211433824488136020822e-1*%i
.146324468269210259958452639221e-2-.386346127462050377348886644000e-2*%i
-34.1101781201264439428637067958+10.0637208880003750077988493805*%i
-14.1660949281852792456765372153+3.20943231611856846798844956579*%i
-5.95151644068797717551930896290+.735636685308218340264560758938*%i
-2.45689095938213948336205597963-.832905477527590042316401911936e-1*%i
-.921998158608363111490892127035-.237838075652194656661925158033*%i
-.297205440797222861557644298009-.152344782402897439456405949730*%i
-.888442434993387863374505039266e-1-.652503824174880038825261073597e-1*%i
-.267952165672054458430607166770e-1-.241874018950206419855324301064e-1*%i
-.833965184763807346180554224065e-2-.856418377007879351149036819325e-2*%i
-.267244519739597041472680403241e-2-.299353700620404539041683401308e-2*%i
-12.1968650854294613021376725358+31.3017703742772298245952178617*%i
-5.73367788293711313192773619669+12.0893031978964162664842297240*%i
-2.73771085738843795535031020738+4.56068541083439503955363434105*%i
-1.29281837042578537146712166591+1.63125276503643956830242100736*%i
-.576698722522413310120719557094+.532869480894689435476696979450*%i
-.234365739071493001318496788317+.157091949653641921981547306119*%i
-.874975991507430665949251589669e-1+.433201309167785991088234861513e-1*%i
-.310886352335826261402821113279e-1+.117405630360246150891042382862e-1*%i
-.108195971194074223741049049537e-1+.322082872372749814236802727357e-2*%i
-.374413602378404553905587900738e-2+.903597680592903526314345938892e-3*%i
16.7585725558205711288175720085+26.7611852203884400787674604867*%i
5.79120715058216708415998943562+10.8865201178345533473397488324*%i
1.86480388632720635227864062329+4.40761626762795651777234721581*%i
.529458864700454716239434675160+1.75201294350989282421826678767*%i
.118604086006373119577202262629+.672914310389118618911213662617*%i
.136747919188484305737196204111e-1+.247527869452656414822123885882*%i
-.457565627478640425054964033917e-2+.876513146925976142177988103588e-1*%i
-.431199321869606445693921595329e-2+.303039455504440444774562818673e-1*%i
-.223531487999651604956369158358e-2+.103687370768985117528695575818e-1*%i
-.972816149119707655720567942170e-3+.354171218393397478603235645853e-2*%i
29.6222280310300525616666236398+1.93165980697930236257350097088*%i
11.3291506324858672448846331974+1.50057008866272901798928747171*%i
4.27239544124789924418962180136+.912681331695684726108178311056*%i
1.57627189502285973503109891634+.487931384018597785492364798177*%i
.565292071903958336566128681213+.236792331430473983421136449855*%i
.196786558434849070342436688371+.105795859466665016240550403400*%i
.668426198773974517140892041142e-1+.441104071546624954374464496813e-1*%i
.223592382481631397387992334849e-1+.174401542478126913664298792527e-1*%i
.743335564500083999648508949222e-2+.664273621376608332735214413372e-2*%i
.247244463305393732401653221749e-2+.246883763071206548137146602284e-2*%i
.873996936300197491015298383437e-9-91773563.5415550398104325451227*%i
.133078274250529714213668837187e-8-61561946.7696863199418815198381*%i
.202675500457042554180628736380e-8-41305621.2963542086123003409265*%i
.308742501424540636628697927773e-8-27721237.6659102472099476336160*%i
.470432333303247338381565596221e-8-18609196.0523873550207885917339*%i
.716982091922538438419680834444e-8-12495665.2914574303349111626751*%i
.109303736835827900500773495137e-7-8392929.04222730577314491453359*%i
.166679732339904262440633484756e-7-5638922.79162000766143138452917*%i
.254248029589458626722920123424e-7-3789777.08949738760449034874994*%i
.387941101732033940470357155635e-7-2547845.57546849119278068262625*%i
.592126183248408275913084372750e-7-1713491.73071988365346087763558*%i
.904087423873421003329857827911e-7-1152785.68923459768241297458354*%i
.138090024794038492729703670351e-6-775856.961621317010251699335756*%i
.210998127909898876372306069896e-6-522385.251665311835070939204609*%i
.322528992306642412731052051998e-6-351873.707526618462204512605852*%i
.493222713425965040429736302857e-6-237126.921846474751188868351182*%i
.754592972685617412185775559226e-6-159876.861296552037556805767452*%i
.115502162162176701111571170607e-5-107848.688893272959375241826532*%i
.176884031939545707656974153781e-5-72792.0316632669287620716294236*%i
.271033609291268953109069700274e-5-49159.7130303976804311361253247*%i
.415537352449988703432206161553e-5-33220.7944292693838909512198272*%i
.637481457224795249293843823786e-5-22465.0107902997814936719899044*%i
.978623902083722223055154480413e-5-15202.7589425620817136265095111*%i
.150340992895283796513720462941e-4-10296.3528730844501110949406328*%i
.231141345491066120688037476461e-4-6979.41581312668034382264422548*%i
.355668151915543308159105972708e-4-4735.46612422645004741282755964*%i
.547786958129395168113401804652e-4-3216.26962930281586551316436713*%i
.844528809769398718144213981536e-4-2186.91491035574543899957650551*%i
.130345288435427877223898733936e-3-1488.85189719523846090243978697*%i
.201420050302692239302230088671e-3-1015.00934209193943729948339543*%i
.311668367561799277010017998275e-3-693.037127353145514153288169493*%i
.482982174383001409342949653693e-3-474.015659217353025524436978793*%i
.749713474937973007950281316188e-3-324.845358642839258413671892136*%i
.116594395400343056693093725963e-2-223.114332575249734278826783603*%i
.181714400596808544671114222636e-2-153.635544450057252103564494686*%i
.283900329785976946571327541429e-2-106.109183592263794731909322741*%i
.444810492799295958931657943243e-2-73.5437406429896564528654788490*%i
.699242178635456630672238923923e-2-51.1889205055169347243478475959*%i
.110355523274659875460763971063e-1-35.8140339444066480823045323553*%i
.174996410181466033430684930706e-1-25.2197147983611845066963854186*%i
.279133085640278876696094804494e-1-17.9073212644907915287362853434*%i
.448547577373874498882991024516e-1-12.8549847380473151710607663223*%i
.727770294164653827604527356447e-1-9.36586070107830236568774336921*%i
.119638462892122256551791138466-6.96533212817983143511383883625*%i
.200421046606370266310197099426-5.33148010693103570959914724819*%i
.345857703341584282462406199721-4.24825724654177782435334850988*%i
.629956358225802295442083608111-3.57427936623479645770580813644*%i
1.31355604436008130958570295403-3.22253361049529042553918466688*%i
2.53101710159496533304640871126
.924419071227665861781924167530
.479628615924077287103244962842
.270908306525111853381536324415
.159343331975639368518314268858
.959988953927776825031664849781e-1
.587653867167546923348039198300e-1
.363849175090072156172530314576e-1
.227213407200493609362243530479e-1
.142836478316940732776850285364e-1
.902740047854452741833753868628e-2
.573042291729283488721220616810e-2
.365087635204374820723061260616e-2
.233320146940795292898855647057e-2
.149507073345474274719028723904e-2
.960225341946869005831561197686e-3
.617962978344357586968470767591e-3
.398407325741081276656008509801e-3
.257265983072468108271129095340e-3
.166362571006757418024286174610e-3
.107717391385105127208299007551e-3
.698265213572257957782662292015e-4
.453120707042799154426608817006e-4
.294324741220283120242014800657e-4
.191348181142628017112469583411e-4
.124501931530702054053308905857e-4
.810690340497656697259152021017e-5
.528246981355732519185999655610e-5
.344429770983075997241089168949e-5
.224712224992898562513046792631e-5
.146689056438692759116486070672e-5
.958071756326571719511989795639e-6
.626056369435493227500558921481e-6
.409289849697373825428331751461e-6
.267694123313689718201342318424e-6
.175156486418890322487705270289e-6
.114652421019259379967961896413e-6
.750759339450291616285690699483e-7
.491779444797839977821251986725e-7
.322243647320845265761552082044e-7
.211220247155387963412572546423e-7
.138489633764296023146174167794e-7
.908287518845657017592345795416e-8
.595865217668156416364500067103e-8
.391008296875101840857963887972e-8
.256644614173719849160704365880e-8
.168493014755086295604069292592e-8
.110644754271443620476223621263e-8
.726732909906842115622104816838e-9
.477430365999599593718591955967e-9
.313713227329884650802994698199e-9
.206176796998531772993156034395e-9
11.4010352768533821062546383957-30.2169671818782121153430727013*%i
3.57536443253646861633931820950-12.1298407079800621121401760583*%i
.942106417053999011944120756963-4.82517433240632371331038702623*%i
.149541130900467379198266486485-1.87329253229930594346777689556*%i
-.317674527772287506070662134631e-1-.698444486869514198232725492898*%i
-.423299795270383808087082600641e-1-.248638070120309767630600742146*%i
-.242679249295595460053923930949e-1-.853665814962897175523977369007e-1*%i
-.109926804386339704873833304118e-1-.287649337979739691870906234797e-1*%i
-.447031556531698964579072075993e-2-.964733393494643936276358872745e-2*%i
-.172011194446399218780637993669e-2-.324554663054014500366117922659e-2*%i
-18.4967262009945846722445813346-29.0703106568838101532350495477*%i
-8.25274628197299950718629704523-11.0445398246927932315572731458*%i
-3.73659377851630782728270267234-4.04080148251906219408365141699*%i
-1.66946525705187774778481274657-1.36352720410945803272426579639*%i
-.702176106626375059189421197111-.401710346627273057819962361486*%i
-.269484385890113549637997594364-.100952795432076059540938179935*%i
-.960594961218972124557661942543e-1-.222800238116050571759183115566e-1*%i
-.330473581516902065685480980377e-1-.441006414698487116621037902808e-2*%i
-.112586438781037505192256248820e-1-.731108808644474637486988435754e-3*%i
-.384103761476459045663534963168e-2-.608010371250353234026989760458e-4*%i
-36.3785384835296193091103456512-3.54976261507547906161899479991*%i
-15.0359671501959507105007748581-.458246178724730890652367241358*%i
-6.24944529070018710641601495941+.482858765219815630264954640772*%i
-2.50471003969240090252194607860+.640795433182014962867484155515*%i
-.876380014496716889233956940494+.468265878703898845592939764716*%i
-.256276315760928173648287971302+.225201177307996055242063094201*%i
-.710042914079748870858461879249e-1+.850463673412900438470569648535e-1*%i
-.204248152571756820857706445605e-1+.296589118567146761206867228249e-1*%i
-.616739314207303037455869185803e-2+.101664176685679993579796458357e-1*%i
-.193550383956635779969148766817e-2+.348653484041022672480575092089e-2*%i
-26.9157980575638722423010595484+27.0466486471245426841837455810*%i
-10.9197869772836560600378931301+11.9217089015300190140685621726*%i
-4.38404423100891768640103226303+5.65475342402139551202871454689*%i
-1.50551624851598001729982711170+2.95719666471879432598491865831*%i
-.803156674958065994407028250624e-1+1.40807302246558260488628565759*%i
.135075401103703795270947285519+.402117842698125532179535866862*%i
.556817178501103842131337319577e-1+.110137309070321432860474356506*%i
.193172979308558806934035102839e-1+.329796187909175337216976198065e-1*%i
.658580083346218422002833841505e-2+.104313934961472189047923470396e-1*%i
.225309427836221544608154214956e-2+.341055228417276834738843160219e-2*%i
-3.34305049968581983484926516333-38.5620046452133446945818038160*%i
-1.32653338520688281037456098605-16.5683795555197974081549848338*%i
-.447657664331599182766832905102-7.64763556254457110770992162403*%i
.161457038750247067455787463153-4.10383821703330339644783736295*%i
2.06013972946339804610428361619-2.37153946551121390150080921052*%i
.480356343169506968781998503207-.711524183356889505800226537561e-1*%i
.127783852350602136113399799078-.159134541251682137676000111880e-1*%i
.387335200647284503536030895021e-1-.451706993842427693622937870232e-2*%i
.124020613664933111128295272392e-1-.139675732904403333111778168129e-2*%i
.409375605849006573597337501094e-2-.451161198926195468532358370479e-3*%i
-31.0150867097688886638505938277-21.7870507506902389877512942809*%i
-12.6143569795370089483619478406-9.80141623949379038600358324125*%i
-5.10035020118471173775738497790-4.76651500479814179896343652205*%i
-1.84399378184853487775669576634-2.53967340060787716358782901852*%i
-.335029776444883189196392361319-1.24217425713191044367302212708*%i
.306723152085118726747415019295e-1-.403903705514667729051994935050*%i
.275548067487683123948447225236e-1-.117949788131144896938657522873*%i
.112165776718574542435475871086e-1-.361614363386212142186214103395e-1*%i
.409364683255546401037058420108e-2-.115642689295572232213734210281e-1*%i
.145370916493785129294570696139e-2-.380423971597461215018441163379e-2*%i
-34.7776154475853758250380688238+9.88233494902102117867185437701*%i
-14.4737843050160111898475341785+3.04409539573516540372047755268*%i
-6.07064537565948519184117532844+.602737817455884132331170174532*%i
-2.47568851230649016828977931238-.167256916595403318061785563990*%i
-.907768272256144662190991190906-.268948433910296883234497544920*%i
-.288212370196133970835309975685-.157607080166082786960159003492*%i
-.861031460260421343683943492589e-1-.655211486953519570697937733426e-1*%i
-.260842080401442910339135697552e-1-.240624928616303415309294606759e-1*%i
-.815549532444371790436735645617e-2-.849705293629001449581389718120e-2*%i
-.262306630186675107081538235885e-2-.296851595907983346103519953975e-2*%i
-12.7041394264723270928434283928+31.5586031775850300876603806023*%i
-5.99068366133525022630121563409+12.1497028624916945549182650210*%i
-2.85759260172062188094575339096+4.55011479370433832592616750648*%i
-1.33819623095164228973433738708+1.60685945881181461983113054492*%i
-.588060523227532256365752210563+.516853223107456308004157922952*%i
-.235491459057570217396218976185+.150653512912866877831874434174*%i
-.871205493956134500990521012169e-1+.413800028584183840365186090695e-1*%i
-.308305018149402070401140003961e-1+.112263692837630764781123658735e-1*%i
-.107164209316944037749216612852e-1+.308908127585023912403321982788e-2*%i
-.370834058174628015154996358977e-2+.869576293705953874576005445274e-3*%i
16.6189094834078697630048194903+27.2032756681358968132173722163*%i
5.68823628460662993451991620652+11.0608769325979907761751890689*%i
1.80216557835635565197004156476+4.46679908915806731431986453221*%i
.497765070990747695864142432993+1.76649218765497626290201111038*%i
.105562629137092582256664825646+.673874544989601600007877115023*%i
.931821909017167873188501978534e-2+.246308771359137734711485784992*%i
-.580273565398188136945428835762e-2+.868492711071896759427679585968e-1*%i
-.462028545426255977436859646966e-2+.299662693530868528781586560365e-1*%i
-.230757782023650514187623490259e-2+.102481771280097663491753453188e-1*%i
-.988958848936025455832554105017e-3+.350162862003151880734893300977e-2*%i
29.8170324757222525035147412967+2.25836390046897857471785592665*%i
11.3803634090113144279398459530+1.65128308449074335051863645892*%i
4.27775304519946816489802744297+.977407088622118028012182911981*%i
1.57143317246494476355891472798+.512935999699563167243427596460*%i
.560915099394138886581072580702+.245211689624764947405017984432*%i
.194472669303362804518397163385+.108217490178136316233947922855*%i
.658793333056575573242885264031e-1+.446982863885049520170553816892e-1*%i
.220100020593969600147242052880e-1+.175564091429394400960495921981e-1*%i
.731645441719561100423338344158e-2+.665810096008566960397891760969e-2*%i
.243495022118594304611947958810e-2+.246782469924580456798114237784e-2*%i
.271158240148558918909345839950e-9-91389464.1616259816042610221484*%i
.412910719043979506127940118887e-9-61298639.0573799746317487947697*%i
.628909117207986171772227366365e-9-41124989.1142320671744049167935*%i
.958125358661540920320172784253e-9-27597228.9017871079587272332906*%i
.146003783172557551462855386401e-8-18523993.9237315602264521196295*%i
.222545159425312280644062248600e-8-12437077.7170721195248353198202*%i
.339304603624621866932905565189e-8-8352607.70055217250190813904291*%i
.517469287046478127342696924865e-8-5611147.57235783099718726872501*%i
.789421085835028768426537331817e-8-3770626.01256897289896285680751*%i
.120467178211515849466272733523e-7-2534627.63481193303003768554132*%i
.183895748759431234500145070407e-7-1704359.16600898132025995827084*%i
.280818172711107906547936581335e-7-1146468.76725083549666204533797*%i
.428980504572560426189620881587e-7-771482.448949815319630224169548*%i
.655567911474014419054549600257e-7-519352.091700819180291468493711*%i
.100224833524765540978709625530e-6-349767.819749245331136509300686*%i
.153292580538629277995670419670e-6-235662.772774132870022609566287*%i
.234566860934754119509078376703e-6-158857.366730328365902182275539*%i
.359107607268794496788155890990e-6-107137.676083980364889246465111*%i
.550058568030101802308858488758e-6-72295.3127614527300548557467517*%i
.843014441559354827855703202889e-6-48812.0666315617292577988656576*%i
.129276576144656835157017205749e-5-32977.0034916835539257784042462*%i
.198372865632155814579911197547e-5-22293.6876478390446238740945719*%i
.304609387598144902348216115524e-5-15082.0867911914605918790259605*%i
.468086762061811963030474400152e-5-10211.1461378363956125112466444*%i
.719876246966247768398219842673e-5-6919.08891012387679863470462713*%i
.110807067685627314668305428711e-4-4692.62844266216407262892923985*%i
.170721773979782874038533054468e-4-3185.75260812820611763100170720*%i
.263305919007133523875297965999e-4-2165.09754939616936422450009527*%i
.406561872497307899887443255314e-4-1473.19259517288897628399664530*%i
.628547155411861274744455464910e-4-1003.72053186139342374566032230*%i
.973090952250774424286188583883e-4-684.858848703728579506874658157*%i
.150883833685637838111592032032e-3-468.057759682534429339887134821*%i
.234362287398578149505548052332e-3-320.477355042798911317276093277*%i
.364742610806408064601353890252e-3-219.888412943309502105579946997*%i
.568928210987392412934084140180e-3-151.232643009374932320597890972*%i
.889704103892152404077061571278e-3-104.301140193862850829121921331*%i
.139550355728611917951297773249e-2-72.1666868502070131318431778082*%i
.219654986794540456038233581034e-2-50.1245109614265543426899411823*%i
.347191659774787848329587787607e-2-34.9761665417438032131960370799*%i
.551572845845746957922296022480e-2-24.5450973727507053814435742612*%i
.881796034115685441337487023596e-2-17.3487459906318680678493450182*%i
.142103987064501117481332096886e-1-12.3765402779755730655196565977*%i
.231424558223147128602286938583e-1-8.93961920421409328415442237766*%i
.382371782304981561257675500350e-1-6.56940681830045500832679554952*%i
.645260676949384655840265826813e-1-4.95006660780515388899289778273*%i
.112645395111422668779797783259-3.87658645474736269358698830073*%i
.209615453028109056456455629109-3.24260866307968212054017986154*%i
.462570319558706519913681423892-3.15607803198380678924548792955*%i
3.30794567339217341213100972708
1.01862781031660846222029072712
.510647582702772338485881630575
.283875940492669251895330877844
.165420592479749883722165062807
.990472326731693229231031710111e-1
.603653194333649244482315035171e-1
.372523795492874535629544949357e-1
.232033211402324400498115589333e-1
.145566175865631779451182553410e-1
.918439131643381332753614853913e-2
.582185908125283159976342272874e-2
.370469704608125815106422917727e-2
.236516658093955054038768504466e-2
.151420241664346930342747690399e-2
.971753029748621319997358469286e-3
.624949907244299493727382923711e-3
.402664198464279619850439781027e-3
.259871589453937507770084162868e-3
.167964092191945567595104316457e-3
.108705455211484805475862237332e-3
.704381860501589099049609705739e-4
.456918979144231359388280359726e-4
.296690051332863672421245992530e-4
.192824971084870399015664278204e-4
.125426180929033707826425170832e-4
.816487573288000751725977735853e-5
.531890687489145200270325515772e-5
.346724304065736923828728542168e-5
.226159721134427860560493887614e-5
.147603721111449796468578515321e-5
.963860468162645823831985727454e-6
.629725269405929176688776362171e-6
.411618401183407141147696725677e-6
.269173903718506020489374817047e-6
.176098025825820379659307011208e-6
.115252185149828794147933639920e-6
.754584031887771712869921895979e-7
.494220974178669670098749253005e-7
.323803753093913343619535158953e-7
.212218066028772198616757009495e-7
.139128390393543536632867841120e-7
.912380002923765307436739476211e-8
.598489372995541464706816040714e-8
.392692239419954235965462646825e-8
.257726011930309534936217389175e-8
.169187959610202127864037577904e-8
.111091652878928487410229287832e-8
.729608647982420274093825071865e-9
.479282020470442633785063773399e-9
.314906199092511686579979804987e-9
.206945838718124763715897892169e-9
11.6194858720744071022515287948-29.7863592577110506981511035332*%i
3.71264651340722892969981429954-11.9668116687936781413457894922*%i
1.01867387608311334727929128763-4.77468153542986019449332835989*%i
.185865065095797596550042277547-1.86435856077460654744546107139*%i
-.178193335788143390939733302975e-1-.700282487577335162817822867314*%i
-.380678286357185365052881138942e-1-.250930101798225723006181426215*%i
-.231983944510703074832853474041e-1-.864904759028162665728453042382e-1*%i
-.107617519913746346044689970870e-1-.291838913904306805352348901434e-1*%i
-.442688731012895444814194914085e-2-.978632132404490884589295725325e-2*%i
-.171361072538925962183261876541e-2-.328949171734768049554107804138e-2*%i
-17.9340347888703531716660065627-28.8860609900665228718972105013*%i
-7.97454673896384365627923214641-11.0226965566656134932120754654*%i
-3.61097007362159883655472917856-4.07256687497783511975224571526*%i
-1.62529988333567279617770643944-1.39863986642291246816816135998*%i
-.693563822798732969666108850638-.421538526565552683527932364234*%i
-.269912989932829059404005548951-.108049940792672550810631788362*%i
-.969545120605630679761421236086e-1-.241880556195310230630394940648e-1*%i
-.334422576508097459002044969562e-1-.486535727096567026014534195562e-2*%i
-.113954002079365905470518627792e-1-.837151928060739332055752049896e-3*%i
-.388504504404729756810797619546e-2-.858248427687091356503477363820e-4*%i
-35.7191218613312383689213599314-3.83133770364355049888692379361*%i
-14.7365252044641462836314095805-.674215640104696526255488368810*%i
-6.14002797630649578093283653434+.322137195249336075255789942486*%i
-2.49853226677619228741414359547+.543656845651727416661006750538*%i
-.899945456007893356320391171062+.436753890896376607182275391525*%i
-.267478508394504953450416337824+.222134151964947909834590254770*%i
-.739077450969614312014873761379e-1+.855581856208887352338404135961e-1*%i
-.211059323165419082008452734052e-1+.299800373485426329226446368756e-1*%i
-.633287177627464413369687868217e-2+.102814182359187714415794982629e-1*%i
-.197797019530103828025908132477e-2+.352370035505250654439194972267e-2*%i
-26.5022651752542297744507255830+26.3256426991339443776333223888*%i
-10.7499816085763755282240483693+11.4795446916537157435649118029*%i
-4.36439724498474092484476540776+5.35418160182650744756403885232*%i
-1.61412386818051672466292985369+2.78097547744965384695871551747*%i
-.185411870684039619305231286842+1.42674213901294846319196095884*%i
.128198496942831265040489011893+.422555924076721806078608540993*%i
.560151371901956573338058148343e-1+.114135969874453237186156970489*%i
.195466331076127560835638527587e-1+.338432204443675968481992850374e-1*%i
.666375135727954625325769192325e-2+.106415026026419268323964822791e-1*%i
.227753800656138733031788799668e-2+.346603531866418929631117817388e-2*%i
-3.29966142916195788588445711888-37.6832583819173256540709691668*%i
-1.32589274447159977312331763405-16.0335758236594565522124776458*%i
-.509157878294311287697081819487-7.25230938448274272962640132513*%i
-.781270543577025198129452530070e-1-3.76660368271152250887876631035*%i
1.47832795205771054767246366020-3.12518166514770379884153084376*%i
.511040032933338231352678311203-.784815570073218461644682873840e-1*%i
.132246804996305091471878124571-.166756479978597606750303279797e-1*%i
.396697749955164526269983625443e-1-.465562802893871267632480112660e-2*%i
.126316647402799744605703413938e-1-.142808370885786041932442820502e-2*%i
.415521232222357935542092345595e-2-.459115037046046772419634649080e-3*%i
-30.5277019499366267932964781353-21.1382778676143084655194801787*%i
-12.4085105282132873829325769863-9.39756065951839186093032002043*%i
-5.05879181307981305347266010955-4.49317608856282979215918450732*%i
-1.92180575843281486547024023278-2.38331352929428743820483121620*%i
-.417308987708251301801614971926-1.23788259002530944907836894045*%i
.189880635137405897336510071037e-1-.418795937276375826508575203106*%i
.266903510646702271769009649490e-1-.121654702785370537483366622544*%i
.111943907171919054073105907253e-1-.370307939765926430183679715232e-1*%i
.411302390543210984693061171407e-2-.117839245211433824488136020822e-1*%i
.146324468269210259958452639221e-2-.386346127462050377348886644000e-2*%i
-34.1101781201264439428637067958+10.0637208880003750077988493805*%i
-14.1660949281852792456765372153+3.20943231611856846798844956579*%i
-5.95151644068797717551930896290+.735636685308218340264560758938*%i
-2.45689095938213948336205597963-.832905477527590042316401911936e-1*%i
-.921998158608363111490892127035-.237838075652194656661925158033*%i
-.297205440797222861557644298009-.152344782402897439456405949730*%i
-.888442434993387863374505039266e-1-.652503824174880038825261073597e-1*%i
-.267952165672054458430607166770e-1-.241874018950206419855324301064e-1*%i
-.833965184763807346180554224065e-2-.856418377007879351149036819325e-2*%i
-.267244519739597041472680403241e-2-.299353700620404539041683401308e-2*%i
-12.1968650854294613021376725358+31.3017703742772298245952178617*%i
-5.73367788293711313192773619669+12.0893031978964162664842297240*%i
-2.73771085738843795535031020738+4.56068541083439503955363434105*%i
-1.29281837042578537146712166591+1.63125276503643956830242100736*%i
-.576698722522413310120719557094+.532869480894689435476696979450*%i
-.234365739071493001318496788317+.157091949653641921981547306119*%i
-.874975991507430665949251589669e-1+.433201309167785991088234861513e-1*%i
-.310886352335826261402821113279e-1+.117405630360246150891042382862e-1*%i
-.108195971194074223741049049537e-1+.322082872372749814236802727357e-2*%i
-.374413602378404553905587900738e-2+.903597680592903526314345938892e-3*%i
16.7585725558205711288175720085+26.7611852203884400787674604867*%i
5.79120715058216708415998943562+10.8865201178345533473397488324*%i
1.86480388632720635227864062329+4.40761626762795651777234721581*%i
.529458864700454716239434675160+1.75201294350989282421826678767*%i
.118604086006373119577202262629+.672914310389118618911213662617*%i
.136747919188484305737196204111e-1+.247527869452656414822123885882*%i
-.457565627478640425054964033917e-2+.876513146925976142177988103588e-1*%i
-.431199321869606445693921595329e-2+.303039455504440444774562818673e-1*%i
-.223531487999651604956369158358e-2+.103687370768985117528695575818e-1*%i
-.972816149119707655720567942170e-3+.354171218393397478603235645853e-2*%i
29.6222280310300525616666236398+1.93165980697930236257350097088*%i
11.3291506324858672448846331974+1.50057008866272901798928747171*%i
4.27239544124789924418962180136+.912681331695684726108178311056*%i
1.57627189502285973503109891634+.487931384018597785492364798177*%i
.565292071903958336566128681213+.236792331430473983421136449855*%i
.196786558434849070342436688371+.105795859466665016240550403400*%i
.668426198773974517140892041142e-1+.441104071546624954374464496813e-1*%i
.223592382481631397387992334849e-1+.174401542478126913664298792527e-1*%i
.743335564500083999648508949222e-2+.664273621376608332735214413372e-2*%i
.247244463305393732401653221749e-2+.246883763071206548137146602284e-2*%i
-.718437583987801425604772095572e-9-90246965.7220263146995584509835*%i
-.109428552828086198197431515731e-8-60515583.8008746980308224752230*%i
-.166715225894200118171241477967e-8-40587911.6225770736594935032440*%i
-.254054856468459677836039647533e-8-27228588.3562471827202509019309*%i
-.387250789639971292181320861569e-8-18270769.4546812176147771195449*%i
-.590438943665439751699377920566e-8-12262993.0487318339514162513744*%i
-.900494839715364681620733703328e-8-8232827.59744469355051395880067*%i
-.137377975851818547089906417103e-7-5528658.49870783405750036031199*%i
-.209647269652817199473478067424e-7-3713764.88937581688905110331608*%i
-.320040244688425944830151861377e-7-2495393.60436977638739816674825*%i
-.488732139429070144788380673831e-7-1677259.63192569664664903997579*%i
-.746614451082786878226979197257e-7-1127730.17529564433902001556300*%i
-.114101152352461061687035484600e-6-758510.200802161875188302138223*%i
-.174446216192589705028934254137e-6-510360.719081735399774458655818*%i
-.266821959281390383660472740960e-6-343527.582039068374205063623238*%i
-.408302142754133535580191760037e-6-231325.911125495411644213697816*%i
-.625107209265691893286500809864e-6-155838.891885554417269232492327*%i
-.957533640028231865981812453327e-6-105033.514066467725543782356742*%i
-.146755908325364069420283627896e-5-70826.0590204030674083032109000*%i
-.225058860004759896676032564784e-5-47784.3064700568125615998682469*%i
-.345361867895242163405523204546e-5-32256.6907282284140486774079297*%i
-.530336238711617822672378270922e-5-21787.8066539862098012554811164*%i
-.814986131376235508472521328749e-5-14726.0091433395627118685267306*%i
-.125342199984634539745182386571e-4-9959.90530655724555179731765366*%i
-.192939920037439437233234982290e-4-6741.35290758846577509921802119*%i
-.297274715716393344013164791344e-4-4566.53190068628781292554834128*%i
-.458503845183651177581388155301e-4-3096.01154030763806854801729641*%i
-.707979484098256144405233586067e-4-2101.00978368089693409820163874*%i
-.109456416639661436820112046312e-3-1427.25035391379035302223344840*%i
-.169458309711758827529118894413e-3-970.646548669297402818894581961*%i
-.262756633849885189664764527068e-3-660.935843359153932624728514624*%i
-.408125729395786001620415351169e-3-450.661334911730493331108627840*%i
-.635154401533676628016129911725e-3-307.750118025347040382287682210*%i
-.990660194365830833980572000645e-3-210.512261698756426962375197041*%i
-.154906711218309612816892550158e-2-144.269372670867497283281086649*%i
-.242934264103763818111217271828e-2-99.0806578239576985042293212400*%i
-.382293707112213204251192605915e-2-68.2084420479635849710120672554*%i
-.604049104613354483840734751384e-2-47.0821243991011803043644280271*%i
-.959125156387130834949044301432e-2-32.5982698774308076070192754181*%i
-.153210894578624871909665479681e-1-22.6474995104175818110099531858*%i
-.246593967699890157416771580652e-1-15.7944985545089010658886268511*%i
-.400783716488778927300538241793e-1-11.0614895495950609179371933833*%i
-.659950762056795799782801686366e-1-7.78174977341450307386720493660*%i
-.110686337549357010969190402043-5.50083783931021895774902812224*%i
-.190850895288389312276847916679-3.91118078229249017089139169098*%i
-.344622944751625904192708386412-2.81329352557547024523732028217*%i
-.682020305119840459909445330323-2.11577853193599603459361224088*%i
-1.76064471821524052938154462316-2.06891250108332311491769942505*%i
6.78742606672323608514743164970
1.35084810181539746945386880208
.614399971242543580320889604975
.326153394205385171134066599318
.184929645706131797961806875170
.108731057747549586183970886200
.654094967953210944547272503414e-1
.399715259634444186140196252744e-1
.247072838854724077824945709424e-1
.154052598787642938880122471337e-1
.967098237142119407529980802236e-2
.610454071806536708668158558959e-2
.387072525737287843889949641397e-2
.246358835929013781657890876343e-2
.157301292402095135205431438036e-2
.100713778242340339661031814322e-2
.646369112899052298446073857389e-3
.415699173968796834121420123231e-3
.267842009956209137451491290788e-3
.172858509817593327797843508959e-3
.111722531747962421140932409789e-3
.723044794112633706717965092007e-4
.468499973526861788836534164788e-4
.303897239187369717716135332980e-4
.197322109707800538115688316097e-4
.128239156066909467671059891332e-4
.834122510012808539981997051172e-5
.542969378174880254776243350297e-5
.353697715118067757606161361507e-5
.230557027965216102566437877960e-5
.150381265802545552386045445348e-5
.981432469011647042119969297764e-6
.640858589989241334768845380555e-6
.418682111163334576818023714676e-6
.273661464566383294244143504487e-6
.178952491948039967523029123487e-6
.117069988372867229019623318968e-6
.766173114181175379775822252526e-7
.501617134749312658873124427456e-7
.328528684914179891565714924816e-7
.215239375719382590665820530333e-7
.141062074536451000892313103946e-7
.924766484102422594312276269378e-8
.606430191747542975038415089675e-8
.397786973449418039373621557566e-8
.260997171130778444183768231204e-8
.171289761513798931615487368319e-8
.112443036685276751500609013115e-8
.738303259399178633923020187703e-9
.484879527368741257269366695385e-9
.318511995793245235389150000929e-9
.209269965184583777954523700301e-9
12.2313692828568814567827891282-28.5041637352488764445615990871*%i
4.10289600901420635307391105765-11.4738511458848949933352104801*%i
1.24025966010293350533096534704-4.61684612252746689174031936498*%i
.293375325970218539152415337099-1.83338594084437655748681359880*%i
.244758824139700135403978307697e-1-.704199733745729787668923530806*%i
-.248698125045345010077746363102e-1-.257456641861859198946795871832*%i
-.198353820391337765751507451963e-1-.898326218442229795079288059663e-1*%i
-.100270073931318419303622289670e-1-.304505089348719101715920675956e-1*%i
-.428676232372644212460942472720e-2-.102093791852687148709846678178e-1*%i
-.169194848249518089744521315464e-2-.342358656576652577832048673537e-2*%i
-16.3036685495724741707098521343-28.3067091038139146383283462865*%i
-7.16299058562985979923475633533-10.9310216155923806251316472794*%i
-3.23713290936722326665053312532-4.14967502450795192382566341582*%i
-1.48831411147881702371963865020-1.49651053884965752704687081351*%i
-.664470327960211618361095522949-.480263531289360186692748967071*%i
-.270330366842335327344998569583-.129853114916804792634654579994*%i
-.995325788995444096015315892203e-1-.301471846626136344199977450759e-1*%i
-.346281271181676675321419262492e-1-.629386097325109200729436764876e-2*%i
-.118107361602220500843361375389e-1-.116973683564073434458521914759e-2*%i
-.401914703921610642496465478575e-2-.164153201057387162562071730698e-3*%i
-33.7914339713828062454413982446-4.60196868288663817160840741874*%i
-13.8492429650610174721087406823-1.26618355321966700799293957532*%i
-5.79695268090964910344969032779-.126420524173572363211332770653*%i
-2.45937083432893243491149120608+.257785053471271108065727965554*%i
-.965034095817970717876269611196+.335430122242034774444862559142*%i
-.301888485195175739319285596058+.210863019531495435924947508417*%i
-.830089001306900676206629027901e-1+.868841217022834240617648582171e-1*%i
-.232388223340014009510194250607e-1+.309376523305119104605096597392e-1*%i
-.684849506198602401809882267866e-2+.106304043568847774364288958541e-1*%i
-.210963998132476327018921635122e-2+.363692886539355045812184903708e-2*%i
-25.2843456967190563118494922454+24.2799860342020219796332002385*%i
-10.2288574922869768771599259522+10.2433197005836290165599370387*%i
-4.25435724598345455335000433633+4.51268867787659134334228996720*%i
-1.86787533970974548126518324777+2.23897666247237605056156207303*%i
-.521861460308211852804801577963+1.44513657894485263506995801170*%i
.102783317777598283712609148027+.487427581542669603721285603581*%i
.568138232140857503989347278323e-1+.126830031975270485101996548286*%i
.202348161241643803519306145387e-1+.365521722471798017892919576261e-1*%i
.690120549884509104465790762149e-2+.112948117460942694965885424214e-1*%i
.235215947707666472096636159181e-2+.363749696407369286087405939491e-2*%i
-3.16408490439372337160571730800-35.1843938856920727554711230683*%i
-1.29830453176235172564019592494-14.5470927452459906433789292767*%i
-.613495857430899191223761411514-6.17774438396254183555421014897*%i
-.570014870274201229808751053943-2.77275671127670740295511318043*%i
-1.50718945928942363546511362363-4.89959805066195817528452436386*%i
.613474161325334425281746503330-.103863721696936016883237835731*%i
.146497222647330587978093926225-.191475802539656014765864642809e-1*%i
.426061115119678686970190989978e-1-.509403329503792867980013071471e-2*%i
.133447206685266860908086501877e-1-.152592886002599346419021615595e-2*%i
.434488552145302703009439231839e-2-.483761929357722466431264983945e-3*%i
-29.0949448222429410669267495493-19.3018372996453041754480747516*%i
-11.7840485331512528576827524229-8.26914705974088157203057179150*%i
-4.89165556634838559612490488531-3.72593811451310731796828900151*%i
-2.10023577020839763889276907104-1.90638924752963942453563994934*%i
-.671518693718089825250385042871-1.19733070770222836721472783708*%i
-.208017951184411002568448223618e-1-.464487581426427226740232948200*%i
.236858930283984963861453819990e-1-.133295035708425174871997280599*%i
.110904091655258657332566839328e-1-.397456104101650845182387857872e-1*%i
.416766829371052397269272733900e-2-.124652851827258075719232394413e-1*%i
.149165438067712824579779951209e-2-.404620934421566040544198715240e-2*%i
-32.1617439692295022234062428818+10.5434928520263201834058714884*%i
-13.2575986992660240369432223970+3.65589717164082288254842986208*%i
-5.58422365207094089850230481957+1.10418798275390799247859027494*%i
-2.38443353898439056102487552780+.161800777466361751303774066760*%i
-.959105791111322366219453178260-.140234858699303223475461898409*%i
-.324308981083587428110139017621-.134696414170663107613172301423*%i
-.973410819481047933752527614014e-1-.641496373800271157457498659698e-1*%i
-.290062868906162353081442502136e-1-.245315431544884416511098697624e-1*%i
-.891078459328060837843457984536e-2-.876389227574515780535444424120e-2*%i
-.282502502027962749718124692532e-2-.306906085839450883560734112110e-2*%i
-10.7313947297860749617526611340+30.5132273518234842472272854380*%i
-4.98638688462784691177534129207+11.8871319419056804095391327733*%i
-2.38293420054608903983353038365+4.57686353724919244973017836122*%i
-1.15396202345638587132618748418+1.69744467315474393511297470704*%i
-.540031749795252561690984045259+.579687268122426970750193696578*%i
-.230142084960100580873806776328+.176646552075162213533782176874*%i
-.884779540125645802227475585289e-1+.493178427777240358204624328008e-1*%i
-.318479546667071781310946619394e-1+.133392558114906727218001743653e-1*%i
-.111299949521069345087213192216e-1+.363055173633382047427805672543e-2*%i
-.385261050897032469129834937083e-2+.100921047284109575251046310052e-2*%i
17.1386959540595852499158007673+25.4494885296018752440979367447*%i
6.08002031691896242179715057524+10.3628326480561165675295391665*%i
2.04458792049173034620308381511+4.22558230585403590748372723813*%i
.622589055823447046819015398161+1.70516392491975650495820160013*%i
.157824035498558085243906422587+.668564822508316452031406742017*%i
.270299318452163611545015496409e-1+.250794500151024929627332462662*%i
-.764791644845762636111906609481e-3+.899961717121588147261262635888e-1*%i
-.334711180327348275577350469877e-2+.313156946543815705162342126378e-1*%i
-.200806332439394675034554564911e-2+.107335750256922036201031405956e-1*%i
-.921839310345295752962133072016e-3+.366352130986112391306702057911e-2*%i
29.0245540550581970274621477503+.977981703533927818027145558168*%i
11.1657212178654517006711724385+1.05753808945461446549538444400*%i
4.25086632066410023159419820134+.720417595090298308991161654963*%i
1.58846642424778330189998408648+.412640888615036484926608617859*%i
.577703127102346052728535484965+.211047271361391454901006398560*%i
.203583468061363055981831760865+.982727530694602807004425533031e-1*%i
.697245049476030654451384205332e-1+.422535092237954227542102538733e-1*%i
.234148421203153367539195825352e-1+.170644087956417465188240863925e-1*%i
.778866540912741936878662574616e-2+.658984772158671583144538230002e-2*%i
.258671459441376208336833950684e-2+.247031655132285879773102651838e-2*%i
-.732889510790761953074918063583e-9-88375043.6242082350853717045843*%i
-.111676146818612452676557489480e-8-59233080.9451522016407465931492*%i
-.170213112261260915858410379257e-8-39708627.9247010031714178050583*%i
-.259502419671021869471547325839e-8-26625316.4115193374945082474679*%i
-.395741059704608581903944548466e-8-17856555.3470578610117356334717*%i
-.603681695452120204794477475986e-8-11978363.8123112048672087214248*%i
-.921167120342156633636492895588e-8-8037081.41901314546643362387284*%i
-.140607726751936580940858711808e-7-5393922.47405440499416629534488*%i
-.214697817365144699507662157224e-7-3620938.89288247138227968325088*%i
-.327945510350022869321407100388e-7-2431380.15817661149627947073064*%i
-.501117945283707528297484542314e-7-1633071.02255228260948764024359*%i
-.766040516540640905690254907073e-7-1097194.28353237505995808662289*%i
-.117151315527332963798034429462e-6-737385.157806272186209793316599*%i
-.179240965637093771803757247718e-6-495728.874496467135208287309853*%i
-.274368409369024746399984942152e-6-333380.404676913005176118919167*%i
-.420194977662845331993847562210e-6-224279.482289333412485362340139*%i
-.643875680208317777183683355937e-6-150938.773476297035221491083976*%i
-.987196393457925104447089746392e-6-101620.820548084504962154455606*%i
-.151451335665858921576423113700e-5-68445.4686083174665938498110323*%i
-.232503885591004609997610731263e-5-46120.8297923245459799240836446*%i
-.357187813547960637041946056251e-5-31092.1719516641747017064232643*%i
-.549157164853769688828705411466e-5-20970.9741471985917514531991150*%i
-.845001577287695901419434351737e-5-14151.8370674982073672427690255*%i
-.130139733870915490405402499490e-4-9555.37845680510237138102251189*%i
-.200626624598001142084131681350e-4-6455.63874211012378263759188539*%i
-.309622835911530504734304570320e-4-4364.18849720925060220799664023*%i
-.478396908809729683816591651732e-4-2952.28873103117685322594783150*%i
-.740127824701734670589092859711e-4-1998.59480939176812322826715938*%i
-.114669617686557625204747305898e-3-1354.01135777563897498102882046*%i
-.177944112744942797222451164451e-3-918.066052106926134225452619374*%i
-.276627467949073814540764376222e-3-623.021833332151893887517419536*%i
-.430905156367658725009267601983e-3-423.189324015179482323738996716*%i
-.672760770316479944180815677455e-3-287.734825881139011970811567588*%i
-.105311337488858547952614946869e-2-195.838794101616090437656248978*%i
-.165348629356867550084803534918e-2-133.435327473531786217900450493*%i
-.260528765220387180809027175939e-2-91.0154744846535601897590776025*%i
-.412208733188732535040307458305e-2-62.1466043456886589088460443950*%i
-.655454220446097426510079741596e-2-42.4739454351686210259992439200*%i
-.104858256236678412332552798514e-1-29.0469120085718363549455060902*%i
-.169019483403041599227970894337e-1-19.8642770264186983509794833243*%i
-.275066966741068670871645854228e-1-13.5668253688829048710455748798*%i
-.453323352274532655191683571557e-1-9.22934379254169622224068581670*%i
-.760037034779757581776358273092e-1-6.21932815734540506838693044716*%i
-.130606586413188384308826882846-4.09992540163375547050122456032*%i
-.233126394490400363481437370034-2.56032310829737314387104626079*%i
-.444102142997496345580944796429-1.35544557997530291449426933286*%i
-.966512670402128120143520164178-.201130853720834271033014862803*%i
-3.13353904411927459208017979982+1.95673441376320836137984542589*%i
18.8351514361022498753919690072
2.10865792323381863115119361562
.828565311839359882161419171157
.409213978882475010031956288101
.222118883456359396795824570031
.126815700013253899840940713355
.746897573066656555144733621350e-1
.449174726006514696980062403843e-1
.274183758812278688736476621207e-1
.169239302929363520548870707745e-1
.105365106616234511965772518335e-1
.660481493150636027368679675762e-2
.416328105461108909026438588622e-2
.263636724360777764478256954289e-2
.167591733974597217948146319110e-2
.106887463557522297400802415523e-2
.683644459704160102176053128862e-3
.438331891484371913766082444564e-3
.281652720142812136951331628656e-3
.181323563777157181005045110218e-3
.116931872632295203587930201507e-3
.755219025595634698864162817131e-4
.488437070982403299804726407595e-4
.316288598293487568339278373160e-4
.205044822490280218673057676169e-4
.133064392849408182211444589052e-4
.864341519506949115357509163927e-5
.561935529460468445715780074529e-5
.365625183121909941166710588812e-5
.238071994543939448117224774234e-5
.155124355463864415137865818956e-5
.101141733591015890280549686437e-5
.659843347893470268366082525502e-6
.430719432050996412740564595246e-6
.281304039618564903147178409994e-6
.183810979701322451997196538074e-6
.120162300147426768122742928277e-6
.785877274772835773128277685406e-7
.514186087282323099315837572724e-7
.336554380951812983704978214635e-7
.220369012326759488252035536722e-7
.144343708911189356081025400899e-7
.945778822531628786015718182089e-8
.619895658884155652813000151510e-8
.406423015712593039557666429892e-8
.266540095497797355495872290003e-8
.174850003987125877481611104667e-8
.114731390254247258230935567161e-8
.753021535501970615465862189860e-9
.494352126337876733334230500527e-9
.324612259070196388302217473729e-9
.213200799336633276750409049771e-9
13.1115041606317694542671984644-26.4038847893482902053882396903*%i
4.68237408761395494542971391401-10.6429814705179077639438779271*%i
1.58175743321689352554035885529-4.33436029803996872725380023076*%i
.466892471117249510345787798741-1.76817409186233146104914733891*%i
.961881160041040263461428460356e-1-.705262292131817079599896118205*%i
-.152898918841543059695594028736e-2-.267075900553410337515933031784*%i
-.137052754108824985479521110778e-1-.952809234463803881734413663879e-1*%i
-.865735651113643676778545885442e-2-.325905666512498918834997611533e-1*%i
-.401894818238925130663459425365e-2-.109345891660271731222438524858e-1*%i
-.164830141810621919074969651664e-2-.365468361621885893079021582282e-2*%i
-13.7750771906784776591387993578-27.2635482236560057739540291403*%i
-5.88926447653160305614265513766-10.6981200569393749721103776335*%i
-2.62799093705222442462115804598-4.21962713481476636615229449962*%i
-1.24696836793865942253609749834-1.63372390706830676470168304985*%i
-.605117708988037235979117891573-.574778796637999522627322879659*%i
-.267933815296344094475801314683-.167783730538386762173464710067*%i
-.103424636970386202813226963544-.408778819532921450844881080159e-1*%i
-.366021359536291347394780985898e-1-.889172151694763684051200785405e-2*%i
-.125193776998189383140511865385e-1-.177435724034713437155956249173e-2*%i
-.424962840081202060138677447811e-2-.306030496832097347737252005868e-3*%i
-30.7482713206703005586036051386-5.65891200506090763418257306146*%i
-12.4164467735460038826603994758-2.07813793244807198385329010453*%i
-5.18713559483260248951220489767-.762379588920993944439439750759*%i
-2.32803398324450777430354575592-.193228805451094891812564043049*%i
-1.05196301015118092236184054639+.145096299110629474299857162096*%i
-.361584603839205118816572493896+.184600394342312955741019305311*%i
-.995248534279477327202433259374e-1+.883002565993324659656566616720e-1*%i
-.271065895259122656002028832984e-1+.325055658139812512538209235944e-1*%i
-.777482293781949930946569826406e-2+.112247681666761802336685149440e-1*%i
-.234392944263909225043292356048e-2+.383145329770466153028177675792e-2*%i
-23.3376608267417730643901456079+21.2317379098081230242824640579*%i
-9.34241965327612601904677868956+8.46213254384125931117123424292*%i
-3.93426635352484247725115077672+3.31290133945850786090318993507*%i
-2.05300716818533859311698788860+1.33101974486396259868093745234*%i
-1.13714672245925517384123528305+1.32955662330027798391032337795*%i
.419508960549738735175380352519e-1+.607560603623043816110844979131*%i
.573518743938710461883447443327e-1+.150479925383237639162646885910*%i
.213763365579615598188139383029e-1+.414848810985645401800502540843e-1*%i
.730882578657812567255662760163e-2+.124641158079670841951762940504e-1*%i
.248089591435173924172479565617e-2+.394068088620971273455464225129e-2*%i
-2.93035200020438256418611724501-31.4381964741186659342191654267*%i
-1.19560489719049049617359099437-12.4234240998459273501630941920*%i
-.593529902511956071058314581271-4.73926255443519595171248424867*%i
-.737096072746559581814713872014-1.32627805127724329955680564840*%i
-10.5001585103432343367460441686-3.63900866191080019473565122090*%i
.824105111089409914022667214972-.159682935253616720328267920217*%i
.173378374737584077742033562406-.239521100246201717805755157201e-1*%i
.479526780084452641094135601731e-1-.590617212291666155253060938916e-2*%i
.146180452984952999599279206399e-1-.170263255944471862690883298018e-2*%i
.467942299951370711400213321038e-2-.527580050779474241744286291526e-3*%i
-26.8113694237624530570337051176-16.5796015230610476517390772388*%i
-10.7387100349255661006536286889-6.64672158809513506790241881022*%i
-4.49853646427867340722452734855-2.62528255399910876615559574007*%i
-2.21595495608910456943800230340-1.11274126019821664435004160456*%i
-1.10762365873506712433306049756-1.02842538670951731290307441785*%i
-.104629641235135734168174595682-.543191110102293542025697414482*%i
.171465061877225258189129034577e-1-.154533910894770244315550048089*%i
.107785070204206432349419057010e-1-.446448397091441138730264891055e-1*%i
.424570956471822279259249104458e-2-.136789726638025421839205892392e-1*%i
.153818897048812644604224430371e-2-.436840828968729965186755328689e-2*%i
-29.0938651442159920546139829211+11.1461895024408128208474041984*%i
-11.7993765423639974499081232976+4.24550257436962537763257730817*%i
-4.94827406305988766107868908956+1.61891198133265478934590120681*%i
-2.21280262850508574225721939985+.542612147624248700617229611127*%i
-1.00050515088348447181813515101+.353383126119367368599857011421e-1*%i
-.369495494494259403830350479070-.987367352443861897478669396344e-1*%i
-.112420946188606014849948553187-.612630072280418504818900568896e-1*%i
-.329611689581050793322051834783e-1-.249909975711362834802668768442e-1*%i
-.992737929833857015132085347050e-2-.908971146851643044017509342745e-2*%i
-.309469684279659939476155585103e-2-.319632507784786454547058221405e-2*%i
-8.47254639880024267132194218563+29.1484837513912314684220128967*%i
-3.82116060281373925352319030588+11.4865591216895757037198264560*%i
-1.81083228918020717472840451791+4.55415606549919073869006282289*%i
-.915141652415940569467049952930+1.78391454529679565694227975343*%i
-.470458388086736311793899315805+.652960466526799658845546478582*%i
-.220149662092218849547352923492+.209898932309392264475760419952*%i
-.895653801675429961241715002918e-1+.599051731511675445456259295580e-1*%i
-.330554726185675653896525212650e-1+.161961269255532150469556415824e-1*%i
-.116492054733286002555699851261e-1+.436344166249614965193643821650e-2*%i
-.403693829412579539704920724286e-2+.119750168691653142686534003163e-2*%i
17.6478710816826063160956532038+23.3154897314476732509896932169*%i
6.49571491893555567346463343213+9.49103473052113180485791243494*%i
2.31670509988392652427020312062+3.90884411582820543380902424462*%i
.770684695748752998511327596389+1.61609262882499981507025442297*%i
.223248834022929730975452997291+.656352412630959352717105208915*%i
.501968451600123142862838087260e-1+.254865010457412157950685887323*%i
.602192112282322341830144665731e-2+.936776224085992141612746562860e-1*%i
-.160197677968205485105887517423e-2+.329933589698219980112935754798e-1*%i
-.159318302092544877828478127884e-2+.113516000120891003136881887059e-1*%i
-.828048546582827633409448538672e-3+.387170659908577027116461182667e-2*%i
27.9881034340144311410717671560-.523581227320247584471275293661*%i
10.8623943967031945917598830263+.350327609252380761479016297010*%i
4.19723655582213746285595666262+.407088697050586291331839595073*%i
1.60101853736332496053630641954+.286586194286492588557784900628*%i
.595899631508665600470704005916+.166610444838566385467708704805*%i
.214387200336033958674203515600+.848809942853790296547239464252e-1*%i
.744894959481477751771245839637e-1+.388427993984408341198980498879e-1*%i
.251983797972538135544382090637e-1+.163454648254484805020237500440e-1*%i
.839599317395276702690904388447e-2+.647814876665512120984435115295e-2*%i
.278315097709640172683651702387e-2+.246734005845095096377984291571e-2*%i
.287851172443787787487659256364e-9-85820603.9730956523013167536077*%i
.438876233511175589756698134659e-9-57483970.5530723543920198051445*%i
.669325741307073607482401204190e-9-38510157.0615529742480740180483*%i
.102108107408017326775246622450e-8-25803567.8793746213991838879035*%i
.155817565848305649904866244607e-8-17292703.6006288529083675747806*%i
.237855292072464013423850463976e-8-11591177.7625346322306588136374*%i
.363209060898767689808466369684e-8-7770997.59057436353164107458816*%i
.554824704209897579853406823096e-8-5210911.31299674927328534090206*%i
.847849178242054991161588683910e-8-3494955.15752837112152544987023*%i
.129614697011842280447041501288e-7-2344574.50945846869621036462846*%i
.198231486570627994704104951604e-7-1573202.53047430599613891518325*%i
.303308476332665824734710190614e-7-1055862.20139964802035632118091*%i
.464303249986317299734683831475e-7-708819.881259191389283816977012*%i
.711110349615029008236846516417e-7-475964.764604284957355180597907*%i
.108969367892271299894632444192e-6-319689.523090863090971979888400*%i
.167078073597262030015863556083e-6-214783.695609598609189923533353*%i
.256329794106661427936532853029e-6-144343.867469084598557380924423*%i
.393515742240505252742056640959e-6-97034.1224399489001597948013267*%i
.604546003707801730715097596231e-6-65250.6607528955780149760895175*%i
.929445633217810710178739927850e-6-43891.9565963827345793535286935*%i
.143011805932259616894929508721e-5-29534.5238778317889547546179132*%i
.220242969021384114692033122340e-5-19880.4156710379097630235780206*%i
.339505742302142860994951628999e-5-13386.8006388705446209282998638*%i
.523894724800066168461815770907e-5-9017.56311970031637716477531549*%i
.809346920875028812494989392241e-5-6076.69568240417423568818477505*%i
.125189282749458639564602597823e-4-4096.52766994065556255023281958*%i
.193908312567595607141658123941e-4-2762.72463528147000019339196354*%i
.300805849423562816054866596646e-4-1863.94998609750669847660296668*%i
.467423905288583141100374865135e-4-1258.07108252815962304483010189*%i
.727708487311570465171673798276e-4-849.466511569692282855483483079*%i
.113534768350076934382111726615e-3-573.783861866596651609261755341*%i
.177561283784531979924205206194e-3-387.699059439760545851046456238*%i
.278460806465177902515263519976e-3-262.034111017761733893358989424*%i
.438084035198548214733706938190e-3-177.130504660019991711585510167*%i
.691754921242843785975083706619e-3-119.738015885965047390312314465*%i
.109705769456083145338467399632e-2-80.9218811175509642159808926913*%i
.174882909146495587414937002692e-2-54.6545166759088272231467534194*%i
.280525242266792453521399756503e-2-36.8675163126549440180643816361*%i
.453443381461579369988003173800e-2-24.8132082974475993817937586284*%i
.740027172833657212523665558183e-2-16.6344284180915981957292042946*%i
.122275878255382170451891362785e-1-11.0742908278198122160299195045*%i
.205379291735903388090682953490e-1-7.27988801129265777178468839613*%i
.352859275782716339758963047724e-1-4.66842921315427556308499109310*%i
.626511946020817303042315427923e-1-2.83312784904609702032425865652*%i
.117096472789196504933816815818-1.46820789295776273791625596296*%i
.239215409816383158537806295788-.274624889008471888477286158654*%i
.587158741185623351291576067718+1.34609634317846210792680869190*%i
2.49607334578658537828742818599+7.56387684041759927341568585002*%i
63.6085241814863333643260511587
3.77271490492526430416255210885
1.23837129183137700510218872207
.557384125604692073073898952372
.285636389006598601761483001659
.156794141352669798789160639252
.897402551241498424324327832610e-1
.528052488581530421821470314187e-1
.316849526157158213852763360277e-1
.192882778585570647648914490379e-1
.118720067938649626102888705186e-1
.737092873608811755176749648839e-2
.460841795217036206813808500025e-2
.289779627917764064166241133261e-2
.183086379000701145729470392780e-2
.116143559270398053136860545769e-2
.739318091966727051833446463673e-3
.472020610487427590176419311741e-3
.302146995114209690016030682430e-3
.193850428697368363424806954514e-3
.124621431274261516737935445727e-3
.802602643358905920376866187754e-4
.517737014849170771830395382193e-4
.334463914765697762473544610569e-4
.216352045525845233052078621665e-4
.140117579259634133304875383311e-4
.908445627030471510287064354808e-5
.589576684846046747150153199206e-5
.382984989530190711587273255631e-5
.248995970895036036423511873702e-5
.162010974200086887394218206135e-5
.105490525991898562463222448978e-5
.687348976371051192519381718124e-6
.448142394728308195930482214964e-6
.292355790743939607352902589479e-6
.190830595742080336074423328133e-6
.124626424833495482608326612207e-6
.814300292028333574993377287173e-7
.532303139895489763583785445514e-7
.348114522751882366977921329379e-7
.227752706442937066234451647491e-7
.149064312788427843591802886839e-7
.975986318132789201049563524480e-8
.639242344616611018545309676846e-8
.418823990068438089190244546156e-8
.274495207027273916508781122576e-8
.179956969096844553891208188462e-8
.118012279454627718509418112475e-8
.774113599817063593650734061472e-9
.507920664939734244123159435267e-9
.333346434191540288437547982313e-9
.218826473983090750074595457784e-9
14.0689078019440971977735020008-23.5552366233993786019296909352*%i
5.34906652331895785628996731370-9.47247548614206603015754856470*%i
1.99928356762675563456095637221-3.90435569954114015168844976515*%i
.695213578971890722290780807202-1.64963818632516510374253434383*%i
.198104813647111517279357292433-.694830506918969092006928261394*%i
.338503337751132929433179026347e-1-.277570704778723742852473910410*%i
-.398706157996165894292278893880e-2-.102565361579217920438220789269*%i
-.641670403490029020110809251078e-2-.356343100448287710686769482792e-1*%i
-.356670712081580665350229314584e-2-.119912139809521237983747628205e-1*%i
-.157008513069602836798902694056e-2-.399442888764408779086066672293e-2*%i
-10.6167690778125718441964259017-25.6765100471426050182247369524*%i
-4.27676857918237595839227414074-10.2280369331567452994162194223*%i
-1.81679125599410126786901035198-4.20282276290530516769573307364*%i
-.888806319051366433441113371113-1.76852788973029125384096602604*%i
-.499446209519213431621611157045-.697066492063065078690366587026*%i
-.257392266888525363277839374603-.223762398094732232660280845504*%i
-.107843535764878959377429851743-.576258044805557050386887621699e-1*%i
-.393361611866786755376508683263e-1-.130140356474729055239796399420e-1*%i
-.135439953175026230860888606104e-1-.273422990975617708963585820769e-2*%i
-.458708771201847508764712625679e-2-.530183546007963064006627444843e-3*%i
-26.8435793500565364343030900481-6.72517446036849966132403120072*%i
-10.5338730904645133474286128303-2.88968396965961439756860673503*%i
-4.29156380162154465992192860580-1.42405963963905014563413358012*%i
-2.01803190664063848954490993656-.748228571168189953644069491086*%i
-1.11844161483117902652247806415-.160931356059615739164053883889*%i
-.448664933804709477176206508663+.130060134563929342106164164331*%i
-.125627157692393876371846381024+.882493653279977454692837586877e-1*%i
-.332316174884713694004543886135e-1+.346067442498599356127778277834e-1*%i
-.922332230640666798227813401587e-2+.120812838543358695577210123315e-1*%i
-.270531680144102942804800256407e-2+.411609149881319206735496656127e-2*%i
-20.8050471062539812266408880523+17.6255756795296657540136912537*%i
-8.12380028490388084479989477609+6.47905670734412434458571484295*%i
-3.30824818050152527059089182139+2.04867529978150648458285910442*%i
-1.84878792339450444329717108590+.183491684250159467113636922951*%i
-2.03692851912218512310216730609+.791779268227131634053038934406*%i
-.920819188642023329485533489199e-1+.800854504173762377493343514843*%i
.559520687806497541225113224955e-1+.189450751675206315577692266479*%i
.229386291432079354998327788193e-1+.493580172048812644028180936453e-1*%i
.790370731394209166077105287729e-2+.142844075306705549168872200522e-1*%i
.267052264845194943062834099044e-2+.440431114653613505855903370165e-2*%i
-2.61200662406784801885750871259-26.9491444083042632439805719444*%i
-1.00799948823585543826820979069-10.0646399676605382499975514334*%i
-.370557357707111060633790739568-3.36887478988328111550637911348*%i
-.576143233481757279985156279678e-1-.113513566404224031246837040822*%i
-25.2191380400202819461055161684+17.9842219043872998877066320610*%i
1.22481128228394089746799240677-.275670937139814139194949712772*%i
.218593298999253324802864666904-.323808100355869506999883530859e-1*%i
.564923670210098266801564630600e-1-.723602565943371864715298682531e-2*%i
.165941834418247402471672916416e-1-.198142150172288519087766324859e-2*%i
.518915468799478403312478031735e-2-.595131765953246732524784659365e-3*%i
-23.8481393171550796992972344532-13.3890912054068064157205245462*%i
-9.31877493780897053647363406445-4.85120795596268658087417332473*%i
-3.79634030463464753092457734025-1.45256638249299202624617651797*%i
-2.01969549384702757447192120912-.968589289054551762690802720417e-1*%i
-1.69262748748128234227083897214-.552449470369326814832406625654*%i
-.265245228947797361835177319592-.654945271939472666796985431747*%i
.414202156390379073320638607112e-2-.188436951130242623442909700810*%i
.999712407261305990037020655868e-2-.523596621589240866820271392584e-1*%i
.432218896907274374923848485733e-2-.155548264455138305551835996776e-1*%i
.160101869422605696435465946004e-2-.485896252916657007788169984368e-2*%i
-25.1717838507773238756330581788+11.6345721662041078789761371531*%i
-9.89659623290359533109793584200+4.78386195037834915097201433611*%i
-4.03870418497297531856106140924+2.13719885595539111525228289848*%i
-1.87720707776807279629803436631+1.00140598185324857140456034795*%i
-1.00936658593029774800463271255+.302609597079433271346830111359*%i
-.431190997957739546891191453581-.334922571952749839855906999372e-1*%i
-.135469384727696359860679191833-.546723975995292262281027623746e-1*%i
-.390987655211174651926997870609e-1-.253482236458084186485218076400e-1*%i
-.114955875222481538030088889196e-1-.952567109102423347131737180985e-2*%i
-.350656897994023828211952108379e-2-.337685289867164556719904123163e-2*%i
-5.67959898981432608969486948296+27.1632063547683282100828054030*%i
-2.36075578591837400231644423219+10.8136569331691478343708591133*%i
-1.05972005303272421115076315965+4.42615921102394176875877452550*%i
-.571339394632062363703291228685+1.85347709258048875829187939454*%i
-.355998446845504516969371857846+.743255843071512979218352193237*%i
-.199514197704434853635275592627+.257311561548268791271855003601*%i
-.897792055086285956067481940561e-1+.759607551956453592466982659850e-1*%i
-.345950082974860491166839092136e-1+.206182927694177030919256486583e-1*%i
-.123761509191955311547594116757e-1+.550082276314711627588242285930e-2*%i
-.430206190300658870396154167560e-2+.148847736417422947784732487708e-2*%i
18.1177870042779134440509759712+20.4486132628886221051223477860*%i
6.94502795518361868239808002278+8.28284313983506434740547209437*%i
2.63880895452526359347419112347+3.44301781603416317933077635243*%i
.960996611966341660538483063968+1.46980699809690720245190404342*%i
.314023375225202789784723892976+.628655748162226705245152018048*%i
.843678631868794042230045141565e-1+.257429872199918801084890137257*%i
.164449948983819952904673267145e-1+.982739993480097073470315164834e-1*%i
.114156414701154156698297895142e-2+.353078671644903841241503430956e-1*%i
-.931999148534357189004275878326e-3+.122355645134326593279311969351e-1*%i
-.676992722463180389703096508476e-3+.417390454541540783323754222661e-2*%i
26.4655872005042737086558761828-2.44254524387460915436435760583*%i
10.3787252096131634319979275574-.571794891018120282342004256006*%i
4.08655774360588213557420124385-.141887527984333688815825376193e-1*%i
1.60222646297713477703792467223+.110150577895940599696282332709*%i
.615852534772067823017601433272+.101543111884536965538472575013*%i
.228262750552409697045810548642+.643750551580243568898927127923e-1*%i
.810380186040602144395354033265e-1+.333882974730809187211004640294e-1*%i
.277381397139066928555264819185e-1+.151345895180398511873153066356e-1*%i
.927720271038915906143738269603e-2+.626907470173457229970809972626e-2*%i
.307082199782270773318144338968e-2+.245087134297133302742459273708e-2*%i
.965475544089098173682914659492e-9-82646493.4736014345280615533102*%i
.147312313156321321897421659479e-8-55312208.4534932314727577728195*%i
.224839171847858719192584485861e-8-37023276.8745872749506924764246*%i
.343278644262017926116480833769e-8-24784918.6552337823413522116580*%i
.524288953238375331695847810024e-8-16594357.8863037642305571000502*%i
.801035062032383315449698635999e-8-11112077.5397254769954312283857*%i
.122432760760046396425398535391e-7-7442065.55309329563851926672811*%i
.187205298353701765665797952214e-7-4984902.88891265593079195280739*%i
.286366913428288295465223418076e-7-3339538.52531992637145826184255*%i
.438250498600053070247236381379e-7-2237609.52005591218955311894376*%i
.671009207228749947428813312948e-7-1499518.19066210292533209254851*%i
.102790662617729599746070884927e-6-1005055.90304678824117462303953*%i
.157547600557903873153270791202e-6-673753.607592569310856989732207*%i
.241611718226527681142020020120e-6-451736.969450145322445275890162*%i
.370756594456101840940168413186e-6-302931.813363378533446611777036*%i
.569302071540661091765782812738e-6-203179.416209684268447181913320*%i
.874782013842818106399048922902e-6-136298.370863214955738026773252*%i
.134518656767825764488668601776e-5-91448.7834763498432098839110994*%i
.207021614792465786896169571620e-5-61367.8901993297015339074477333*%i
.318879889955639875612888174184e-5-41188.8328301897749956573169759*%i
.491640837617005743346453829961e-5-27649.7382167594009324253386104*%i
.758775202919970040152773183048e-5-18564.0596026525475074859807071*%i
.117236320813901164417822084083e-4-12465.8256144090608245514843040*%i
.181359344502586079132129693548e-4-8372.00147204022068122049714947*%i
.280929620554623082801163689113e-4-5623.27585227371873556060062150*%i
.435806397903760251199363583898e-4-3777.37422354755246878706303799*%i
.677166994668372991502851973488e-4-2537.55772189082241242445252176*%i
.105410190796050752854513074226e-3-1704.69519347584035522325925310*%i
.164416674073225434330083914781e-3-1145.13101914568123705878418253*%i
.257035861413824716911916659067e-3-769.139031559342532285635954013*%i
.402860501717425327268827377477e-3-516.472266803881183184323368538*%i
.633261196395626527706409401232e-3-346.669860957222189094076923214*%i
.998768925135784096515938210432e-3-232.553767782409475484655899795*%i
.158135736830716903111240317702e-2-155.864744702672845564373680787*%i
.251513991295446426947038221561e-2-104.333316401194537834751500889*%i
.402179206444203553673268704851e-2-69.7134762732040225918898084631*%i
.647234248748873302060132692051e-2-46.4624233212138356433223584681*%i
.104975408916114533507006502741e-1-30.8539027425465043496941372490*%i
.171909297035525580373125943909e-1-20.3826331780713222741143909994*%i
.284968421402136128616996651323e-1-13.3641913041563074838360488634*%i
.479885824261221249544153868794e-1-8.66617596838331716731728724327*%i
.825312220743270544142324009152e-1-5.52757647990781486459064504044*%i
.146146492666041869407547144347-3.43743290951203180029319919473*%i
.270084568434005149072517276383-2.05338674070602683581059775834*%i
.533655740947696244474770044468-1.14711170269105861812413938396*%i
1.18427985347740644694590169218-.567916800275705659410487900991*%i
3.33727007422528536139886322010-.218718788011679627638970692127*%i
19.0572116064186513705954616847-.405566316017783440740401465186e-1*%i
246.416897741364016583506104025
7.55018355124086943656770578023
2.02656159881843034125663719713
.818565021868491865427914565349
.391600527024850071662332382857
.204928176805448049729507406265
.113232090674047613302005214494
.648517055579562255196028840866e-1
.380890653416881724434413485122e-1
.227873810564132371840271961450e-1
.138253975402884224716699866479e-1
.848044189305979793922491083567e-2
.524762987192581091695869803427e-2
.327045496352064409726901701906e-2
.205031892411150484185177429433e-2
.129179067042221337040005079375e-2
.817329797100954893234444491296e-3
.519013853996799356026688106720e-3
.330619133422873671397547302020e-3
.211189840077543696745144498510e-3
.135229655583726843474258599890e-3
.867772203458989126881838783868e-4
.557922467083323167061226657970e-4
.359327658821972122569380177889e-4
.231783567461312571322072867278e-4
.149722254271290289548769069869e-4
.968381791674748467117027466205e-5
.627068783369904327143186133834e-5
.406489815021258229670848235970e-5
.263762252218967934891542462439e-5
.171305337620147099653851191511e-5
.111351184473759529894395459781e-5
.724365935578805091443439711072e-6
.471559688942065834497450744275e-6
.307191646843720464621691605991e-6
.200242780058676712587421831909e-6
.130605519186071045924419250215e-6
.852329364822349710708441844160e-7
.556519127400197661047498471059e-7
.363551698240568770864319964187e-7
.237603878072146305681720542670e-7
.155357046695732240333415343441e-7
.101622104240125020824739550841e-7
.664990916204499033005156320566e-8
.435316143268414849195511406203e-8
.285067193601428591004727380704e-8
.186739236871068348892415861247e-8
.122366570547653942657022964190e-8
.802088609840166678205688628828e-9
.525906071198131248231059242025e-9
.344917016425787628114220253561e-9
.226274884839606025600598091844e-9
14.8737045374708792791303282657-20.0797707509208007746158532542*%i
5.97126496085660129090398120609-7.98205719855849849125212747890*%i
2.42881421976693973468886948555-3.30756282948272711981892754586*%i
.957603652331196705620591787823-1.45440023102608656362849513146*%i
.329064509075647472068711913534-.660175105296402993685816282648*%i
.835926539847265709607806971993e-1-.285169768910583649881868793959*%i
.105236778299485105854213423182e-1-.111115806020340326044848864412*%i
-.293686698689206976755886843592e-2-.395928868345788360081746317349e-1*%i
-.283930257434080974737178932282e-2-.134176710667897526992119682616e-1*%i
-.143695183987972624181513898186e-2-.445952013455515760085043876823e-2*%i
-7.17066314971744442565761688749-23.4968867106282575425987032272*%i
-2.50133387426345940245260389621-9.43265063903927102342542218603*%i
-.871046172306915642805457841609-4.00749564234623383961364806532*%i
-.411562303303413498798494579830-1.83918277894754982774118263412*%i
-.326457075268385459454799299989-.829747783360482640822914295575*%i
-.229870981561713727475808737398-.299279778096733249647308343686*%i
-.111283926411961936508173642900-.822026853153027590971296704886e-1*%i
-.427331609852741117466812605545e-1-.192190220686192774073955320226e-1*%i
-.149112840894099829412434498265e-1-.418247634214329761101723988289e-2*%i
-.504651191363511455482404624758e-2-.866572316983481861943580460467e-3*%i
-22.4183587504047327332669726319-7.52591686586353217313440540147*%i
-8.37050412623691223434296302226-3.47416885036891534785276565264*%i
-3.15115277286803378788741383413-1.91103441600094161507079473660*%i
-1.44425040622673743940195918587-1.28232103577210544092749099988*%i
-1.08626313046217207146354086529-.603564077613878631563626020582*%i
-.562186741976413998030875099978+.243995200064795224835855341925e-1*%i
-.164626274594888140299095846019+.836907973966068472472395227951e-1*%i
-.424593808914487209742255764698e-1+.370489559960753641530354245046e-1*%i
-.113741604618698446157412520052e-1+.132174563303302728564127616866e-1*%i
-.323290381281654030211192298021e-2+.450328301646971894069770095677e-2*%i
-17.8976970319697501177479547928+13.9182688529790800828114017678*%i
-6.69416389090168743951408643997+4.63003639623496519484280281950*%i
-2.42137689986506097472599808428+1.05986315047014402937557402562*%i
-.969462624907181390149002018375-.804218084901316747691796715490*%i
-2.99897492488412475374257398266-.676095589506938762506312087395*%i
-.377274362109029857247217300002+1.08892579859270696504127294702*%i
.490288016605738420827666522372e-1+.251271614921322911813882157024*%i
.248140939190036267737516036566e-1+.613786535936547902896265310931e-1*%i
.870759840278235769458037263166e-2+.169765250220253043804225959102e-1*%i
.293093893388814414945330184492e-2+.507430780165453883589436437636e-2*%i
-2.24918526184889148295200682877-22.2244672208384794347297395350*%i
-.796917642843468255353374976052-7.81569568628700561869903111448*%i
-.984795319933908316067055412328e-1-2.41389123648735218622596766002*%i
1.14751534649678444533618589720-.237348427589441805940435446214*%i
-.505905015959660490802696030758+99.9929549699905487169262658274*%i
1.98950120983209174020123100726-.520339678160753077204529761643*%i
.292558499759783186032991943842-.468988478274114910233803288432e-1*%i
.695600973175665308965775247887e-1-.933616756097114175855424196820e-2*%i
.195066711589684957850442801161e-1-.240111584246597996669878590061e-2*%i
.592248213155698765991550870756e-2-.693806622957644227050183404549e-3*%i
-20.4514593328230675853964891609-10.1592945445335609806867986058*%i
-7.65709469995347530323805543197-3.20314830287742674572009116992*%i
-2.81926992522864579291926935271-.521145389897065521794565530970*%i
-1.26810566229682993480306010106+.848224165224646902122342903729*%i
-2.24461398052973491088432432322+.507845909685123071942272453002*%i
-.563032810353532959232431851584-.788470523677522001007215940016*%i
-.209618452913276955302497457131e-1-.239924678351555379466267239313*%i
.825222023481942077783270425480e-2-.639270940487588835726351311551e-1*%i
.434946801404008763504011435121e-2-.183026023721966589529019635557e-1*%i
.167616379950827404505482685318e-2-.556373421530192725120507123556e-2*%i
-20.7473763198632107976366917959+11.7789896413115266118971020336*%i
-7.72366711299565932944305809328+5.07213913637846826539256598096*%i
-2.90302761930407612338343487916+2.48360460782116612485146017566*%i
-1.31702509753062311165698498607+1.43039985036820493006213346027*%i
-.923328362892927187784885281386+.666137366853463256119950331100*%i
-.503262856291771807772049146511+.784939384605331363017669702833e-1*%i
-.168376537518492568212655150535-.409261305956526231456934167298e-1*%i
-.481038149424597216838008397716e-1-.251911114748892384090754146371e-1*%i
-.137835166169417060409356599984e-1-.100366980959296968558040163095e-1*%i
-.410021015221442396370819265077e-2-.361142499115376843182284576328e-2*%i
-2.67952880147731385708819993650+24.5498655757111766399412437624*%i
-.775946599416146318476390226980+9.80563174456364277506159568238*%i
-.199025979946201696599722795617+4.11835051829432220851470107805*%i
-.128120289238412960197135746181+1.85327288827200836044524065057*%i
-.182091164906566695949351981643+.832801072338766200605825958868*%i
-.160594844008488344918513216402+.318277696738743696713839460338*%i
-.873981202756375097373840423179e-1+.986652750867076077779317852679e-1*%i
-.362377944192400779145999541402e-1+.270718251954070175532461007147e-1*%i
-.133002097479610429056391381957e-1+.716976233261592727676861202374e-2*%i
-.465399113128766373229764380704e-2+.191356057829352861659958744180e-2*%i
18.3492065431053995859714778246+16.9917137510614638656434985447*%i
7.30960933439851560901194143549+6.77295420729090072421539417169*%i
2.95094780227717226826091882567+2.81921215518184154605074218002*%i
1.17193047735094616577425658790+1.24884366417613517673995143440*%i
.426968835579401470374154666973+.574679265089118490255435450664*%i
.130799726282065724456315568615+.254771242628963785089638821296*%i
.314303566190630617357950593935e-1+.103019901665272756254479975508*%i
.521358388914837199227877550825e-2+.381820898573438612378591334666e-1*%i
.669531999706937981841756346577e-4+.133981308758493659404082313307e-1*%i
-.445880705913735484658684520192e-3+.458044384174549661683499779209e-2*%i
24.4158100480248253895813424387-4.60106249123315606915644427182*%i
9.67011547943071060010975563608-1.63615741498725265926498135007*%i
3.88769917869744606627130695704-.520585332686908577801113903556*%i
1.57588647288478381326481034750-.113639966064279813330936279978*%i
.631390970954077644853130480592+.139143613727180407830642831717e-1*%i
.243600432381312322901224039862+.351105956699387741392518236678e-1*%i
.891393342975907804379099591771e-1+.251772220595347936709822398826e-1*%i
.310555099056214604874559689418e-1+.132042908244826964635214784775e-1*%i
.104607276294122515277131138004e-1+.590190195196688085609714073209e-2*%i
.346252648400503485919372932704e-2+.240640489197863860962379736371e-2*%i
.311691127714755509724835794428e-9-78928884.4027739063654418061188*%i
.476011160847487601296231442697e-9-52770997.4523716540459348010767*%i
.727213167934441111755609276839e-9-35285186.3729769418806637792660*%i
.111138888355963906078059371398e-8-23595406.6782157849434712990161*%i
.169917649567137226836431954951e-8-15779764.7478364587526230931759*%i
.259889145400678962472086918024e-8-10553865.0625467062120440365226*%i
.397671809438787322190537516074e-8-7059278.48165693388674795268424*%i
.608778220688153590889411096728e-8-4722223.05624415721892155340652*%i
.932400655623860461836314896352e-8-3159144.73582607389456959074175*%i
.142878777215979098048410067251e-7-2113628.17983477094826040648720*%i
.219062592455850605052684440172e-7-1414238.33984529227080163997362*%i
.336061664818947710963354869965e-7-946346.401037535220966460597800*%i
.515865283794129542562129852263e-7-633299.759494468668699007617343*%i
.792388421156239706890892978185e-7-423835.980712808317820581193070*%i
.121799118757663208549726516776e-6-283669.528053271601564490446769*%i
.187359680668229574351265793767e-6-189867.331473232155138487612039*%i
.288441790269061827213216762489e-6-127088.415761490868171333828895*%i
.444443982756277392447255731279e-6-85069.5728133456098807088076360*%i
.685460589981440613505750424475e-6-56944.0340093801642412607601383*%i
.105824907464597419926671479105e-5-38117.0657665704247653764471596*%i
.163557580414198795903206839067e-5-25513.9435830432702786824432107*%i
.253088854590318760134834295457e-5-17076.9341565597898683763125642*%i
.392141403774605847801004277287e-5-11428.8035701152065722209718410*%i
.608462844836152532129545078280e-5-7647.70140987455589285129989270*%i
.945603917178959303913556680660e-5-5116.54228380015250446367823581*%i
.147210827992214545253964501236e-4-3422.22203042113230767409619161*%i
.229619198677634039667042340931e-4-2288.17376101096825886856973031*%i
.358930870415002514438165385632e-4-1529.23064403777285231496191288*%i
.562419557502749159100752204529e-4-1021.41491003901503612474957240*%i
.883670360352008646809959291419e-4-681.715449118063122424025104354*%i
.139270533940874171920695815797e-3-454.550372990152947897730768388*%i
.220271474387362519918865372863e-3-302.703965681172055751579125085*%i
.349799688002989619955124868630e-3-201.258706847098844517295959853*%i
.558120513792221440885491437418e-3-133.532317594574312806920397835*%i
.895445528289637978561527751420e-3-88.3571656354603494337639297113*%i
.144611150094755803803971363861e-2-58.2584568567244939016996600448*%i
.235392360402493333198548659125e-2-38.2342749516476651918527231992*%i
.386870733201521601148349797559e-2-24.9386879484346457269909201092*%i
.643477050266907689473014065915e-2-16.1348688116668063244402649368*%i
.108663318711186418669477733807e-1-10.3292323207499475695941189027*%i
.187147991824702047015047430658e-1-6.52721943268412196145134731548*%i
.330933794244542897009466502125e-1-4.07156896106522306239623280125*%i
.607063533855136234053627624092e-1-2.53859797820161165236425925696*%i
.117498947177505984384224864545-1.68198046825240785167177732758*%i
.247352007699471391770603881522-1.44098421689355256409533958584*%i
.602131850667677645087070827189-2.15372204007167783379950985968*%i
1.97165058917802363293161144305-6.16566110009144695107724201746*%i
15.3261364544371289792308716831-47.1820569460262994911144642361*%i
1058.79921014270674949484064821
16.5717362115069505815793721995
3.58996480705909516004522304454
1.28700781841680785728394860636
.569731170117977902940099934936
.282236565401222755899537123035
.149701655811553559416218044815
.830663910208264752281174598248e-1
.475703462260035715955653346091e-1
.278792068336495492402650359842e-1
.166273395837927033054087655515e-1
.100526576052008716684662205551e-1
.614399622489138075851426642637e-2
.378831714732576294205493413778e-2
.235287075161612997709914807626e-2
.147024862871744065376220030223e-2
.923464560184126967798016481434e-3
.582591786773168532780584665480e-3
.368946155557640937596662978971e-3
.234424698591482138728809950816e-3
.149385888871934287631897320136e-3
.954409444435454647952739485492e-4
.611160210325852060693786237635e-4
.392161988682063392324654730202e-4
.252101868289453149535249318495e-4
.162333927498380951411022485315e-4
.104688271182571931471168554824e-4
.676057604363561951578950508212e-5
.437134407980792752749181778469e-5
.282974100198356711383283597693e-5
.183374431789296698859269753089e-5
.118947609543226653240524576942e-5
.772263975122479266163822808692e-6
.501811421246556943482029118205e-6
.326328104858413176229202407204e-6
.212365791360837355829404192305e-6
.138296107468710179099164132164e-6
.901180466877216287526687657183e-7
.587587851755343614820280238884e-7
.383334043395389830172802236636e-7
.250213752050633785541662059712e-7
.163403374170798022283420390338e-7
.106761544928894619728802402209e-7
.697849140196434592400923001008e-8
.456342438997954026705780554082e-8
.298533660135977110278341222754e-8
.195371004555883505600849557557e-8
.127903706125391748699479800304e-8
.837634963881962444258118475558e-9
.548741836386690797359448803701e-9
.359597273380777232729005247862e-9
.235718474469550159257447566309e-9
15.2942813641763955635987774511-16.1630357158701093256514595439*%i
6.40320708991124886370480399152-6.22944463806873291714963456220*%i
2.78764259358211396940303582999-2.54094978676372557552761612054*%i
1.21982833429161967319342326402-1.15974358386620358071850420945*%i
.483340930433283584448158914797-.584498315811883491903236025392*%i
.149900714657227996444942010889-.283885692474876218995350176177*%i
.314362608128669442611581928477e-1-.119827769576457875638354411263*%i
.232098936427968783790040542071e-2-.444154655459311493737684945100e-1*%i
-.169917693526676423517932564404e-2-.152570480946551315707777871427e-1*%i
-.121759262336765288119797296727e-2-.507187490133498212788459231510e-2*%i
-3.81007458103093891272578137192-20.7497119969675624498899516985*%i
-.779559551926982057618923734109-8.27064925166317461048553589097*%i
.962429410802521518550473210864e-1-3.55503669963057819703005477238*%i
.160445727967700665153612042471-1.76697912813219363121233365249*%i
-.642747859554335291137934194522e-1-.939850433650502012898688657816*%i
-.171782367175443378378608333974-.393533513541997912273855147926*%i
-.111014451022910836248157539040-.116974328843342931606143363671*%i
-.465467562923539090267355922231e-1-.283326058532764782746761478309e-1*%i
-.166438779131861518117519753330e-1-.632145194349312368321551225573e-2*%i
-.564711067703497346420822588921e-2-.136082614275750070685686176716e-2*%i
-17.8630501485280875547888998791-7.86576273563017267123014403809*%i
-6.16539751970605534872668396912-3.67051330686865835802427927439*%i
-1.90848455883821414759913019224-2.03697986291262938041265849698*%i
-.580095547684494600422749227701-1.58957830511363858220967904264*%i
-.827604670680092764559100579672-1.16815222876760722345170293826*%i
-.691480434540155316193384044494-.168905789026758930381858067147*%i
-.221130742324363466274495302559+.689077782037931008675113043293e-1*%i
-.560920239433354678065338738395e-1+.394007573379392593117022195919e-1*%i
-.145054731155728549191240814327e-1+.146418119488940649372643018469e-1*%i
-.398624835685242947174890524521e-2+.500887454222578221275173954005e-2*%i
-14.8664237622509141444201202663+10.4756753929497846339515691479*%i
-5.25236684230383505458465035450+3.13337241171763447180209328644*%i
-1.52790181275218741516105470937+.582069342331029224624115446396*%i
.506674736434945555211087748758-.914680296865867931979534336087*%i
-3.15594382226107898218917887832-3.74603933073168730222517791423*%i
-.970063997922874812746340158290+1.48251473019941032067020952111*%i
.290950870887494564917165218983e-1+.348478063271450498210397523366*%i
.267206563515208840593465868051e-1+.795105580717549123287216916296e-1*%i
.974249622086424043688295051143e-2+.208873971709691406613851886918e-1*%i
.327547409475657377457029077897e-2+.602078056135310701329413887537e-2*%i
-1.88938537522441777074716271762-17.6709082334677647596706346245*%i
-.651618262107727435905139491999-5.85158437250426787124269170845*%i
-.933797353721020349267795659580e-1-1.87422897694524261123763069797*%i
1.07574026626002109747428868284-2.07095283409682743097369713435*%i
289.204587133751886865775298561+211.702823960897552809086779209*%i
3.49140808872204855036071824062-1.05419137691369845456237190191*%i
.414018951344832351783070763723-.721727786169173121990563874915e-1*%i
.893655854836589643338353139542e-1-.126391275389958306121848959684e-1*%i
.237233898719065631613859464473e-1-.302438082249679142976770745163e-2*%i
.695317194063433588112994273649e-2-.835076428077938268320484721098e-3*%i
-16.9119515702704033038643064983-7.23108605388285130614603217272*%i
-5.96714692673887079633299564969-1.91897916993996510403638453522*%i
-1.78893816242910003829229173335-.756756806748736312907920065767e-1*%i
.558271339832799409000063283378e-1+1.17288567647958344626233223142*%i
-2.22955101213324902132035259584+2.45886698123868063926398789166*%i
-1.10360366145357446969407518472-.898488313400010028947455408707*%i
-.687759320778977085798460185478e-1-.316387800770949019700233792444*%i
.463315700662642995476225982848e-2-.809803220802442801438326625420e-1*%i
.423947615735334121085595150107e-2-.222465147262048935825068057839e-1*%i
.175553572962924189141398898639e-2-.655206837313800166634196545609e-2*%i
-16.2200909543597846942615138865+11.4278594114307303075140038940*%i
-5.51960386929038748800228797090+4.97138446508232468885682040184*%i
-1.67511620854236162744582613361+2.49445217791340505637386569714*%i
-.519419422954197422349562095279+1.66155695022440244334177729830*%i
-.649261729281105140898970978917+1.09879443277493075251546737160*%i
-.569222043497410567646707566708+.262417267673648817755378545303*%i
-.213294642809490012024049714529-.140599181020203976218112831981e-1*%i
-.609795042829586531894656565401e-1-.237664902644800614871216917389e-1*%i
-.170439110116783298220354076300e-1-.105509752987287431331205192008e-1*%i
-.493485613939362309006027198590e-2-.389813104842578148020639969210e-2*%i
.174827836325659611872543106897+21.3734020173875402065489653524*%i
.727522627694819667016578703744+8.44456223657584576521667389312*%i
.663140213485516536467580999000+3.57031870870205237757969635075*%i
.385553222340913112651425618828+1.71889940769242781742812226229*%i
.642759978231545838377365061580e-1+.891296801841399748412459042008*%i
-.924122153785972482743933454514e-1+.389397668284639084482252912091*%i
-.795519880350088488597755300654e-1+.129360914086386361156299168646*%i
-.375566373664231760018033550317e-1+.362140144071029712292136167185e-1*%i
-.143886869480693917996750954210e-1+.955768678251927125354405459341e-2*%i
-.509840907578036527934093364586e-2+.251952307415911925066847414275e-2*%i
18.1470552409181382826715473616+13.1484241961678082729773877216*%i
7.46157747853841184560789710746+5.03215427884458241176834791927*%i
3.17821831562171047696528404486+2.04474676726340294777882930996*%i
1.37038983616963239231177759006+.937937837845953595006530708762*%i
.554437259012821866470696407868+.480905699889572036042582181403*%i
.190226712425760018318748749162+.241329796187824719150832947143*%i
.521330443153533990393523931659e-1+.106605144896214033142652463375*%i
.110784013046602074975517206851e-1+.414444083682015498277895930584e-1*%i
.153802110682281230127825256884e-2+.148446014649718311937762775842e-1*%i
-.100672948660506894056610282469e-3+.510365461415449956243880818320e-2*%i
21.8251080161253855977087213138-6.78311986099424103233591220345*%i
8.69970247241426510196985530122-2.74595514095977344840030393618*%i
3.56806618243483825078391364866-1.07621190190959927314250303262*%i
1.50209870048640538261204422574-.376672182490440511161763316013*%i
.633840138789998084573043289577-.972507173434529693849213118903e-1*%i
.257812610706050017707521750306-.478060457547483825835008587733e-2*%i
.983250290987345947691526922546e-1+.132620551713016012026945021109e-1*%i
.351413509860068897001728998582e-1+.102296606039884312750175867961e-1*%i
.119782001578932928726923569952e-1+.528644277779274029557015563046e-2*%i
.397470269534818631523395088739e-2+.231186298331912281514337518740e-2*%i
-.859288000941088736956145518919e-9-74754189.3320917280051532366891*%i
-.131370287581696447256177435013e-8-49920587.0868500577794216611685*%i
-.200921847649456538432844917815e-8-33337934.3019994389374989374833*%i
-.307424073678352837180514380849e-8-22264407.8596557739921297594581*%i
-.470586085650517149893931205868e-8-14869468.2324850298460225209929*%i
-.720678189278623085446640701847e-8-9930923.52605238767742751124930*%i
-.110422156857687966718053747320e-7-6632717.73017537073156959601952*%i
-.169276259313258056766240302328e-7-4429946.33581914415599381737169*%i
-.259641654657618707373033387284e-7-2958744.42133212959458367649582*%i
-.398479403410708290338358844848e-7-1976127.40909397150182384444514*%i
-.611936891703458450037047614909e-7-1319826.42802451839392475070236*%i
-.940360114114483776013977947363e-7-881471.542555450749719703670809*%i
-.144606503166076962159828068062e-6-588686.106009787266254478100453*%i
-.222540304023183393968792048519e-6-393130.535012806744119988292466*%i
-.342752075836424290158850334341e-6-262518.349579771885813078621475*%i
-.528357495668322022677462339285e-6-175284.515602763675963410333878*%i
-.815230883481909522522549658076e-6-117024.828552094726232645724682*%i
-.125912884531274578009016949956e-5-78117.9432968551864900240660977*%i
-.194684802583784077555563420553e-5-52137.1746153446029901215100607*%i
-.301374195377395934818253497544e-5-34789.7299963463848889626160844*%i
-.467129165543194670950269423989e-5-23208.1926405277575916695552264*%i
-.725062385867678114937270077802e-5-15477.2675595994878284749015908*%i
-.112714192075664227395087743443e-4-10317.6628647582017577334848618*%i
-.175514113708523197725148655987e-4-6874.92748642150649694008948170*%i
-.273810821917899395313011346133e-4-4578.39555895620375736479577259*%i
-.428036278993089914470195876394e-4-3046.96064620646732804326037508*%i
-.670659299316206884965182096950e-4-2026.13217486781367284627968282*%i
-.105349225110450881494631766073e-3-1345.98874518632715692724810995*%i
-.165960885632342178419687918141e-3-893.091019446143374568342368130*%i
-.262293344632943326004861135041e-3-591.720007088731040971875980783*%i
-.416072903408153190927795718240e-3-391.344994991503247604763077594*%i
-.662804330452024963371893858364e-3-258.253042335004688477599384865*%i
-.106100805827909871440504074803e-2-169.958465040119733846411307610*%i
-.170812126304526526072920811129e-2-111.469347483694484715720791841*%i
-.276834876074461391084236799136e-2-72.7944980926437884882361760045*%i
-.452247034556238119755318667936e-2-47.2789485176272315199982680900*%i
-.745918808145478999076602407897e-2-30.4928436289578258451229396503*%i
-.124478951672439412540269884759e-1-19.4899369408219855080077226120*%i
-.210780689380360705034016455056e-1-12.3129686349415916905876775350*%i
-.363581924922208694178709980326e-1-7.66405249239100036451792584846*%i
-.642431078561398725889361193818e-1-4.68563422885692941018919977951*%i
-.117234576009870318289761504575-2.81633950383740570590497871898*%i
-.223749133724338984743638455971-1.69995820104912153291680817274*%i
-.455928933499468375394550735668-1.14044606745103059954774285383*%i
-1.02889590605076450203163645164-1.13052781665058609912739463614*%i
-2.76735044254507330247169319085-2.16155298725361078483715384772*%i
-10.6142604826778455196336926813-7.75293862663218636119564906295*%i
-113.152959050958826871381146266-82.2144184534014650423603884257*%i
4941.83104628321335407996632988
39.2946767604079456209469293239
6.81545866136579347602866273437
2.15189169499468189025331049033
.875540019000002218361082371014
.408249518334950426831801152696
.206872433714384774374484388274
.110762893300280103901394897383
.616381683134129402713090889406e-1
.352835268655778388614955352879e-1
.206337001390327190777466655731e-1
.122687361690936873585416209315e-1
.739198594473257343377903313006e-2
.450164828170846088089831819320e-2
.276572658945543506290934101405e-2
.171175433984649607197818085233e-2
.106603709429084290035891144940e-2
.667432441848607524411238632044e-3
.419786163183348887255461409884e-3
.265078694501397553419138031404e-3
.167970444164262303034813291758e-3
.106763650031720334617637216377e-3
.680449714757354132029539326692e-4
.434733609640321252919403402155e-4
.278353085315737942646989649168e-4
.178575078145929504154144611072e-4
.114766889590506043282604135436e-4
.738776053338647450155475110161e-5
.476263993831665361958329747440e-5
.307444826252879035054551645688e-5
.198711599245960038263947846158e-5
.128579975633694450461424756783e-5
.832874756397344275332300471771e-6
.540018278176943923247846130352e-6
.350452579625312315164790069141e-6
.227622282798882761972923227826e-6
.147958637117441904601308982387e-6
.962461917005760648498860549952e-7
.626504466412587823079206104978e-7
.408078476428511044311303622627e-7
.265965454804076676488219149206e-7
.173441633701925432439432587409e-7
.113165461005819754447376860299e-7
.738743777198317589509822274038e-8
.482482070508867362956371717735e-8
.315257088048230497991469217933e-8
.206079429592747109495375418469e-8
.134766221213919738348231219803e-8
.881648120993225308966989500311e-9
.576991179068338446071645049301e-9
.377741850409029639632455458347e-9
.247380794547276891972408073456e-9
15.1413887030495733954511353867-12.0553930044108209690800075986*%i
6.50928106055172661917939588232-4.32285376729684090603257146348*%i
2.98173436131537480505211465988-1.63236374295868604038128842533*%i
1.43122311981309850604408807072-.751904789850128725869076052933*%i
.646977382633036846088109111444-.448083696276861800806631795739*%i
.233799113443959503964117591663-.264740552441494172486642395008*%i
.607277682757391263094488280776e-1-.126701505553944536421364430349*%i
.101151163418152688777547578033e-1-.499149079209526957102108790094e-1*%i
.567018354597478754570043877964e-4-.175479636532738104221842031504e-1*%i
-.864897972670649543207521885284e-3-.585842653595532505887591856983e-2*%i
-.882401097492140190049418043104-17.5605542559576583078213588859*%i
.661784224912042552382617811089-6.78305477527833851100260352906*%i
.927583439701934735891041948565-2.81568645035478828253231580031*%i
.756502102116722577169142949940-1.46979813720115058962053239122*%i
.300546951957882380474259453311-.971828622814678624551436001699*%i
-.636232081651129065830485166394e-1-.499974370608889533037482837538*%i
-.102269695108906501451276641119-.164682525941691952128029707748*%i
-.502388773147331024836600125312e-1-.415329894694121337336691518029e-1*%i
-.187445129768211784261491531339e-1-.945168388000251210371189743894e-2*%i
-.641151429975528139895532261836e-2-.208105381903048234015936972392e-2*%i
-13.5549687865722228090400167280-7.68106466653600109229124679674*%i
-4.18431758391579714818708282299-3.44727063827768456215664880889*%i
-.814243337270219945442132862848-1.71647668118653369427352276415*%i
.453217358082714642483253219817-1.40597117745914477876367895199*%i
-.164327838564549860207028748655-1.74716101909012444784558718498*%i
-.802553939200109130022201671836-.503979775623920391319768956953*%i
-.300967236177913835039845933183+.334061689124595948955420145095e-1*%i
-.760877180184513799938217656825e-1+.407595397389921007475754582810e-1*%i
-.190393806400349328545505775879e-1+.163344904473901977357345450726e-1*%i
-.505450924705611846573967029726e-2+.565125034755650439221182852988e-2*%i
-11.9453125507601766602680523747+7.51509441488932313586820028740*%i
-3.99394616979262503326480509990+2.02259262751231870679942079879*%i
-1.00524176545682759428432220152+.548192195897311962853253522258*%i
1.66922618005974025302767726089+.552352862152242593974878071482*%i
-.254766097849839354022862363071-8.69401727785026166054573680015*%i
-2.17778432321106888794093523524+1.93407657680860919064993028763*%i
-.193287914678237254382288486860e-1+.501669082165416365371549722096*%i
.280002518700512896086694132053e-1+.106926480430365320105106053977*%i
.110206353322143740052504579602e-1+.265562610327261455958969584285e-1*%i
.372104792721922667332086669599e-2+.734919020521280499299054739138e-2*%i
-1.55533889990216649739217663686-13.5559913416993040780972670307*%i
-.588396479210918359138516532136-4.17617651799396299183800173588*%i
-.464679998927826185890135202580-1.32158435018155508660993078917*%i
-2.36016431574864279091090329014-3.11619106633398234528044458504*%i
1328.64032767187023453494952826-427.624857827255543364297389684*%i
6.55317862938606761543389206821-2.26396127196641377253168932439*%i
.617042116745406626954692497431-.117156009820813352080146798228*%i
.119562160135180483046134708600-.178874568970500699469264291599e-1*%i
.298187123287493196776590701462e-1-.395180984073818487538551060372e-2*%i
.839202658964203763500372634328e-2-.103654362229642650505633004319e-2*%i
-13.5055728371574301969736147554-4.79806777122876858044664724500*%i
-4.47146474101651577749291661613-1.03890622241026114374017449688*%i
-1.06899097051331141127133021303-.115845998292147924138902036419*%i
1.39581307164653051732628312216+.237534358948880307869311331629*%i
-.458600785630022402868446578325+5.31139643610870904663107666856*%i
-2.06175879010674518770938582824-.852404747662031291390395268369*%i
-.159214495569245922777246126194-.428306376672449694821894552480*%i
-.252948799546569865109949276157e-2-.106053839829777262864952777443*%i
.383166226481555399036984698450e-2-.278806699393712266722770870796e-1*%i
.182345268640752094681918980537e-2-.792705975060922028400192445393e-2*%i
-11.9747431668278230806553132940+10.5557314432111662699896964083*%i
-3.54866323597498388527246047023+4.46116023753100824397101915210*%i
-.581779707055646573104352816756+2.08986403391630041424206714699*%i
.415426521733256031770363170762+1.48569288982725786329218658735*%i
-.701148168368962401504310276368e-1+1.50307981877775524570416953723*%i
-.591817854370823859206266683475+.550583193618142043260715898492*%i
-.271928983231075924985539506644+.359879200173956250765918745241e-1*%i
-.791382512082616981182332881013e-1-.197237667590837103137899017077e-1*%i
-.216481481100899225799952975792e-1-.109285239479644140091265369329e-1*%i
-.609736794040138968912960131553e-2-.422880557912981429849008089269e-2*%i
2.56004638930632852880489065572+17.7923823966684112642662561240*%i
1.93822093237671206665918903137+6.78761711899006177143041411486*%i
1.38285012669188154394313811011+2.76589168739539078917694578514*%i
.902762755550452581313200464207+1.38694138722661054048892268980*%i
.386432105418439196925458163731+.871939085398849125333621123001*%i
.195205970209322958362366680284e-1+.461578672941892735065330068142*%i
-.616211409382959062772342462209e-1+.169202383566383312117142155575*%i
-.377833408885011338395856792235e-1+.489245935280587767011954634570e-1*%i
-.155648461393903406580442601373e-1+.129330050149263307148577122780e-1*%i
-.563803128225713811944199543071e-2+.337433364943732953802829127138e-2*%i
17.3610979821876909250703407612+9.17981370360201718237344792124*%i
7.28627647042191035204331799718+3.17632688670070318968753837847*%i
3.23854396947904187135373214059+1.15505498408299812720508714423*%i
1.51034228586735336683402166819+.531286728438901724382529985166*%i
.681503094082141618569548202256+.332610562625401456087864648151*%i
.261847229120961918738319814638+.209280902324531947868898669753*%i
.798238666197401145379885213592e-1+.106883809981460892142473691379*%i
.193575410094666639441367912837e-1+.447532978896174944221652356956e-1*%i
.367233410046755331967861886449e-2+.165600927500021445305245050033e-1*%i
.408178385499821713300712726758e-3+.575640942920613215503793559721e-2*%i
18.7291693995441605415032203033-8.75124479015484892496358348246*%i
7.45265821083851039782102744313-3.78327781037901468645111001207*%i
3.10062108078049361448148107092-1.62963963428779721469240790411*%i
1.35919309200435280493475849356-.662853471158145811752950211984*%i
.611853456023865876727416472874-.230554233039863075861578554507*%i
.266959448339916773533501681153-.570492632593455053044365599890e-1*%i
.107731720286854514327018441977-.352815197981448331113721022109e-2*%i
.399171988024460418978475591188e-1+.576637417980965375255822148883e-2*%i
.138581347811529550761204101613e-1+.429293512535656411551984272704e-2*%i
.462697118534207750263516758802e-2+.213452182581197506975524611486e-2*%i
-.912027345930196528926439094859e-9-70215682.8163854765274418958826*%i
-.139605412132155200055756058345e-8-46825870.9881791695737370101986*%i
-.213791720520638050433222332045e-8-31226708.0919301282379372566613*%i
-.327555042658846117477188732779e-8-20823415.8407832429601752245526*%i
-.502104214043867049436927370396e-8-13885438.4045706701844692705724*%i
-.770073062294680068875747706254e-8-9258594.05311142630277066736225*%i
-.118171251924879698745765778225e-7-6173106.26844747074794163433116*%i
-.181446283307173630496279510546e-7-4115575.47788762731439536924900*%i
-.278776668267951132378002009347e-7-2743592.78294901612710696673430*%i
-.428601880431458511847456962731e-7-1828792.21393908465809988237800*%i
-.659416503761265149515703176976e-7-1218869.38275574667722446220144*%i
-.101529962088402554739013831828e-6-812249.542534232403596622671860*%i
-.156451561802000148724311236084e-6-541192.144156998689323272075429*%i
-.241291333139249180021742777912e-6-360522.172449442367938566328118*%i
-.372483586390617986685064702524e-6-240114.342814074549330520072954*%i
-.575581131653845684869381981262e-6-159880.341968585156524025178546*%i
-.890376517192286032576430465537e-6-106425.531986686269105489659774*%i
-.137894257663209386402853836750e-5-70819.1437358568747848740676250*%i
-.213828713639333119586065254957e-5-47107.1379540445583697567037272*%i
-.332032325843495714518127480957e-5-31320.4027880520554483965024541*%i
-.516347772534286192222880102571e-5-20813.3219654646803253192419336*%i
-.804288550330318806151781792172e-5-13822.6841260135236067732905676*%i
-.125503923476785119835404264028e-4-9173.54578341502457296434186731*%i
-.196225928021643405611212304079e-4-6083.10028069703169040266175721*%i
-.307466945764888819156378598418e-4-4029.90634187921427470792761642*%i
-.482932465950983920608671578662e-4-2666.70261115532291749354359155*%i
-.760571009249239822417752104253e-4-1762.28657931381355981107288786*%i
-.120142876490898716953503916930e-3-1162.77323713377994604490256939*%i
-.190425540777233112755637240642e-3-765.774880321392855539755094097*%i
-.302981146153592639235665154884e-3-503.195137234877261118079809138*%i
-.484173912436793273023443191568e-3-329.765295295973550177787876784*%i
-.777611020176516780754096598800e-3-215.408018731950993183474750490*%i
-.125614418078597756426472815022e-2-140.151763624727218258354472820*%i
-.204292480572660844504503634659e-2-90.7447827454117539518758139790*%i
-.334907247120758053826029875270e-2-58.4013912902458299528924411800*%i
-.554265809724825394967167888608e-2-37.3023696221707213978208193703*%i
-.927863367255261413235749293924e-2-23.5975120435164814529479948091*%i
-.157520281908318411089234813321e-1-14.7423961822196681017226425559*%i
-.272123112993918053932836525790e-1-9.05744082823639142444376446199*%i
-.480633539540770606507677110189e-1-5.43453690914251228033130126055*%i
-.873714003401281182821625440639e-1-3.14106301873577353158105290332*%i
-.165067534405703292119724510405-1.68661340750945814585124717084*%i
-.328988651137857266298379142584-.725279770029233348285503315594*%i
-.708747845500940878149475163263+.400124328894811210829727640142e-1*%i
-1.72284563735399032979705293969+1.04541223234183386229000695146*%i
-5.14695952719049949366069970049+3.66710425580690185336574528391*%i
-23.2484409787052149736651868977+16.8743643792261479764941549990*%i
-341.381590553863841590033708600+248.027086896405916867949398331*%i
24706.8168175659082761531674005
99.5142766362329503896481848884
13.7503177536387799168434072387
3.80296513083031178355696279260
1.41491375651873141598041296522
.618168328421886838389805932551
.298068099618636038203259016186
.153460087794790189402509332842
.827348492901962891320809727271e-1
.461371226516206185036793777203e-1
.263950365277646758051921505631e-1
.154039960088803082272532204453e-1
.913295150873438037861600200037e-2
.548463578170141720138467736113e-2
.332855611180729898411618369230e-2
.203786219458763114377747139446e-2
.125692242362419196455195256242e-2
.780157965051037761475987633790e-3
.486871692655367752163686802154e-3
.305275703518276167965143389052e-3
.192202126845238809480353285164e-3
.121450104832943967271815044178e-3
.769894377312941890858504931584e-4
.489446608780270860280343539998e-4
.311953747539580976510572233790e-4
.199284700565605496837246164530e-4
.127573339470284921546207682734e-4
.818208708105080742858589238752e-5
.525669857724664193237124062830e-5
.338253581031986213892519477739e-5
.217969247769221644443808680640e-5
.140643987977237383087868563710e-5
.908605667881963173683194081001e-6
.587649041699411550879302436002e-6
.380463591956776976127791904724e-6
.246563301073008683946914428137e-6
.159931854029299104287627689714e-6
.103826073420876004825156392504e-6
.674557492882851273786324831935e-7
.438582111214703791700209816479e-7
.285353031756834845750831212417e-7
.185778578480046880257857229937e-7
.121024639133530819292601566733e-7
.788863349978935971260461197434e-8
.514476576813551571249549518656e-8
.335700813579449184554592273432e-8
.219154423317709303169242080827e-8
.143135756698898994686511195686e-8
.935267585845839612241243627115e-9
.611369828738157758560653907738e-9
.399800827527459528846590804897e-9
.261545191428667213397402586838e-9
14.3120958833232805233972030988-8.05462848665582207736368822226*%i
6.19571284944977979778595890340-2.42255142649922318306334287708*%i
2.92198085352189344805402176105-.653624042360391505934922484083*%i
1.52537150003639996034319746544-.238192301687281969632941486553*%i
.793295519135343879391591356313-.231685788645158500309209012799*%i
.333271540132032744776929317421-.215082178765668584681511373663*%i
.100565495727712637399886468552-.128315369875515303463174840255*%i
.214767697792628035783431997404e-1-.556431162951628739185021609106e-1*%i
.272284108675926084595031223247e-2-.203070367849432084225203051125e-1*%i
-.308827689985511985179436257532e-3-.685003206993372833990933089043e-2*%i
1.35448203023890945429586764133-14.1524761437917795793692719255*%i
1.63654970419589661891052021102-5.11015033951216713403133294896*%i
1.44574279240498234814657755240-1.84797586877243361579934232752*%i
1.24295119735363170900770392809-.893047762534854433982630417647*%i
.755215301674195800088522703388-.843019628611258698828261648353*%i
.120181589210759263986501085727-.600356848069327733846708353424*%i
-.770279146520999169026157326812e-1-.227877370039962427344810145964*%i
-.527337968048844033283919989180e-1-.604478875969154363583964615931e-1*%i
-.211661141132077037968575556781e-1-.140137408460031059722553624807e-1*%i
-.736360058396071049340930989451e-2-.312807102147685969814518243603e-2*%i
-9.78520801058124211968135639184-7.04479022060828766834048789605*%i
-2.63628799906579816983580212766-2.92524884287936047262522038042*%i
-.159263670398061053800150106196-1.06218255133036251148637896708*%i
1.28917267926839566949121446539-.520401411094765658036508545432*%i
1.08800557353896208752112423164-2.04737186502737723010111290179*%i
-.812244212082446205799250887855-1.05210715682845345193659694793*%i
-.410348637438633965795868194858-.416876961258050893693409133289e-1*%i
-.105343309325117966041996179327+.393236270096086264689543340202e-1*%i
-.256129616942507299195141019382e-1+.182095205733611599365155519411e-1*%i
-.657056339326017839717510499358e-2+.644903529477381780644060202447e-2*%i
-9.29528604076459712845309526336+5.11390255096386418779668787998*%i
-2.99513223723498985888560885584+1.18177955148657712271980859282*%i
-1.04907082255573408171186337850+.500679046317284943014620236455*%i
.605700880282174272379700656895+3.24138201516979360863144437300*%i
10.1402786611382749878387470068-13.4317185812204360605187567470*%i
-4.58760078873299506957301147665+2.20248153930995280939920900664*%i
-.128107317953050234750176124591+.744398784598374855669159500749*%i
.272137238174772752596931103036e-1+.148771705119965022203954608603*%i
.125229681945457671338299241566e-1+.348228427119930679763680237838e-1*%i
.428783296391950128346279016391e-2+.921797841725483210715497008568e-2*%i
-1.23460784416396038825588096503-10.0339008607711801959247971852*%i
-.496696731085120651929791733094-2.75665722327520582262780042247*%i
-.709595524142435673227379944721-.322235804099388479035136953218*%i
-6.78035900238613984895265323399+2.14275591202912042929475696479*%i
1811.97375541696735076958756447-5533.85621884687579221060936764*%i
13.0436550991742823658175317612-5.10959617637785463357680115801*%i
.964708945453061063945776635802-.199378793889212301109741785624*%i
.166251995232058154413471176852-.263720429629362516811373022516e-1*%i
.386930969216771536302921460162e-1-.534592685625381170405033065093e-2*%i
.104053910092643599634136675208e-1-.132526188526427529021741734354e-2*%i
-10.4305449597847077668510386037-2.91077121497265031571605794413*%i
-3.28769518210159111321270630782-.442273877481939881424559173501*%i
-.932016870457762398327382577088-.275563892707860055408303798296*%i
1.36673222554261000627370459702-2.05223502612320418349246986325*%i
5.13059182947399098463211653703+7.85652536163149176494515678081*%i
-3.70184590791727241113862422938-.310478917858827235219214330818*%i
-.329691167079471535517720122684-.589318884497142562472310416261*%i
-.162987572617167469411141264258e-1-.143062175019025910123976416759*%i
.283540363223179723670284499479e-2-.359569629035976728852149056399e-1*%i
.185049511981319167614569034813e-2-.984149932886804719234045829608e-2*%i
-8.30894845920504325460520787810+9.26798325600058873203247472022*%i
-2.02492845059518079278755504813+3.66370893297587379823953036427*%i
.108882241132805141568304264408+1.35641178135505847767646241144*%i
1.20445246173687603293369110530+.732968492713611771150344722594*%i
.915610401202478926005283066215+1.65545997994340686959691034862*%i
-.495681835964666695938281993990+.975856061010859726219349352030*%i
-.343796992496451611263950747120+.125823661722185195862840463178*%i
-.104493923160564262256408604144-.106727680461129505706200533875e-1*%i
-.281355346182163777687669850534e-1-.109059265635632598781216912394e-1*%i
-.771414450224550754322709253212e-2-.458262267408003337840393514902e-2*%i
4.24231426672723579739906087746+14.0530508441561011697843929587*%i
2.68529497346600693151262624588+4.98080669630966189406724418533*%i
1.80260371399218332724049861680+1.76545290179640695266301195279*%i
1.30786428910242174845466673572+.820471962188509049437958547317*%i
.764008548351453802624241852495+.710409221864211577472541613619*%i
.192100833691811609204706688400+.515503538256050890536921674800*%i
-.264169545402233236784078174234e-1+.218398891688312741108391184169*%i
-.355780880830199871548598764763e-1+.663176876254502620930771106545e-1*%i
-.166701723387782645232074535294e-1+.176726073374234789935205303829e-1*%i
-.626776274124981312936142792734e-2+.457560818578875649251353984707e-2*%i
15.9254312879127735131266427251+5.38467721179215099062917793881*%i
6.71085046987492112461632053281+1.36548710384435266598197880825*%i
3.05775893917603905360092107069+.223602666246793845433700971330*%i
1.53470245852932394498407569677+.425052315721703636480368675672e-1*%i
.782838086783561388352564944329+.117265131244506469828638779392*%i
.341691152372598470469358585640+.148338339696639042597183876776*%i
.115624704629901517043867140654+.100481825545380068791686722866*%i
.308439537642043905850286163137e-1+.474788495517207078564284238239e-1*%i
.673576651999963358230974870820e-2+.184875730105643501729550342184e-1*%i
.115176015193436239052895370603e-2+.654926560662086609656433898658e-2*%i
15.2302850794714434203594636871-10.2719727433535272385949571413*%i
5.95092988862626585594640308102-4.61813930376297789954986622231*%i
2.47322534845913806329060413553-2.11391722634930199865583483904*%i
1.12736844630540148642029117940-.945290217088591434672405634490*%i
.551755526651637049333370575512-.380279821185670400710557965680*%i
.265354303559832479471597376328-.122723041909173457487446960422*%i
.115881638191640573864041704573-.265232687904938368583611908044e-1*%i
.451738948979587796867984484249e-1-.770865505775436436126860017471e-3*%i
.161146692220364943940497127983e-1+.273883052950174393220446522546e-2*%i
.544093523984758807145382100225e-2+.182667461876027886057836145453e-2*%i
.372668300602855700136141055106e-9-65410016.5480368676397234023722*%i
.571245184622616916203141099248e-9-43553917.1409985503455078486016*%i
.876077197739997369529826683190e-9-28998081.4937953668270166058502*%i
.134429354467595372353768357823e-8-19304797.1400720456829581993967*%i
.206391084004044008018844223225e-8-12850185.9287298573250195736853*%i
.317064116433816770863634527883e-8-8552545.12961666149419863319582*%i
.487391629875002885448410389675e-8-5691359.02645644118688694185905*%i
.749722702541257724915872739324e-8-3786720.38066466212760601609253*%i
.115407275333278678517081410158e-7-2519000.00146006716305073050693*%i
.177785207985390256992197006826e-7-1675331.28522451911650138212846*%i
.274100497963479880674551915880e-7-1113959.71546225534369759513287*%i
.422960438484768124601512555646e-7-740494.314741388025508883823565*%i
.653268510640016350134384911461e-7-492088.198759207298519290513563*%i
.100998463856064293183181707119e-6-326901.364770057378397937533450*%i
.156315100906600585225576268284e-6-217082.300620285744848759158442*%i
.242206472633397991648479294521e-6-144093.607565868384806879620894*%i
.375758379750798757323352756644e-6-95598.9876399514391943463064113*%i
.583732322302123791858898541096e-6-63390.2155685324516829899748496*%i
.908134538694038029671881864068e-6-42006.7783316500935734997905623*%i
.141505502385038102609058981242e-5-27816.8270752040126193177506766*%i
.220874447505177491511178547886e-5-18405.3379331633572287997107472*%i
.345411814894365207412122877600e-5-12166.8405598157905175528789951*%i
.541288332907627378504795220184e-5-8034.35399531334661511042224421*%i
.850181228540935475222506196207e-5-5299.00412327449501837301675676*%i
.133872347310812778204165216475e-4-3490.00646122253567956005194759*%i
.211391796709140643726013149319e-4-2294.82801937261516206706975172*%i
.334845265178487136543420293604e-4-1506.08841026476904193273135953*%i
.532259697953277724917341542573e-4-986.253101847474479137094563776*%i
.849415203231882889814923445329e-4-644.163316652458948331360931639*%i
.136164218875044408257178079113e-3-419.438946703916999762348795434*%i
.219394998508116127623306150776e-3-272.116932898969685720595898648*%i
.355583705166712590633053776487e-3-175.770284998076252897788334475*%i
.580244503718677100282942760592e-3-112.940442084913830562991123051*%i
.954399154664006404251373102373e-3-72.1066564571337401411033621067*%i
.158458985192525865242344240043e-2-45.6762277690746460933467847123*%i
.266043462817669603961284654697e-2-28.6524649171730212707976739529*%i
.452730838755823103913178340422e-2-17.7523310368083169088933557983*%i
.783231876396990959677087524979e-2-10.8222036483690104459218130897*%i
.138309953267140050846049249717e-1-6.45091276809119254265368943879*%i
.250682093514793930471554117649e-1-3.71264758347653140770566587899*%i
.469972414721690215939097878640e-1-1.99371040752035648564591692506*%i
.921773952275745448534064339918e-1-.868704739718995381042938378959*%i
.192441782782255299987780545955+.989426714797514091963756932824e-2*%i
.439820702389279854186561230568+1.08564024440080688713184490554*%i
1.15592562280558273320831683692+3.45086450316011839274232439990*%i
3.85058514985721976379349843265+11.8175947174197869864024898519*%i
20.5574289590846222108679450944+63.2628419010213183031210580827*%i
416.919838483094184402947411045+1283.14700118868357414166305619*%i
130997.237250794658209501059043
266.818996386721698370971819795
29.2759106124063912595101876504
7.06563025217258303093451589302
2.39465982065450688099919024349
.976743059393372137140796682548
.446678370570969589387528988327
.220488559348407390776380393205
.114863119225954459831407872664
.622549020873910735815258295292e-1
.347708506569290055451049976152e-1
.198799842363655165413943716381e-1
.115796721260102670674242041029e-1
.684728918427295991717968455140e-2
.409940198127591870666791031517e-2
.247973336239258007610067807312e-2
.151310346356502504777077686573e-2
.930146436294907397414973278044e-3
.575441582861653512077097406750e-3
.357972412516107020458553961869e-3
.223764946412703895696475110875e-3
.140467349228034255325040175256e-3
.885088631427268099476270276744e-4
.559559185253026074675871599084e-4
.354813037510806177855578210546e-4
.225587754588765376354747335640e-4
.143773883579729102141548027356e-4
.918320135943189690456934317107e-5
.587721357103130290746015240259e-5
.376822070805876270747832407354e-5
.242003642815686775992002960544e-5
.155657150632364673893496942627e-5
.100259450449790400848137450533e-5
.646612023033255512705484955094e-6
.417525012264362407134929068686e-6
.269900576174737098031920236619e-6
.174652085323205345124092251367e-6
.113125813834223663601536128535e-6
.733398201424388705083182667194e-7
.475864046623697149842667763847e-7
.309006682370817103047468371612e-7
.200804651982942633910934452507e-7
.130581413696706038607799613843e-7
.849714500248250566780579921420e-8
.553264183217710918482628687964e-8
.360449994748171946817351705003e-8
.234961476980262829018537717945e-8
.153240919642435605126800164708e-8
.999925164098635526452754430658e-9
.652775699848125674977421621155e-9
.426337996314408653724120314673e-9
.278566080600842745568274179568e-9
12.8226236988671760076537571757-4.46750568031384129245705141281*%i
5.44424503914002729992340429666-.724521082138684805348644746698*%i
2.55071032411362170597868403453+.274201923185138258120245950731*%i
1.42815604609902931126092391388+.338034486943018343108167723518*%i
.878541899444141562919538885013+.763537521025711445805955401577e-1*%i
.440230319837202046484590130688-.118448072840075975864739268928*%i
.152845526602208007016523625313-.119104194613651309386306375651*%i
.377543566634200186975793314833e-1-.606880173251282513638017362044e-1*%i
.672003690279702971383352232408e-2-.234967681073125477875407643924e-1*%i
.553911353522095634589336077739e-3-.807857254112630899364162726806e-2*%i
2.78437299744001908565733805097-10.8061279962769038376916461571*%i
2.06015317613997206125384428217-3.47298304182718252143188130486*%i
1.51093984106499477960053440044-.824770558288155498766558185915*%i
1.42453083719240074741894128100-.622366757242348108291639783270e-1*%i
1.23152233620904754963127148552-.448727447741658254602676663066*%i
.408415958618460571256124341161-.655300661875759181257839715492*%i
-.222730004302687977482453577182e-1-.307539610265354726244139500168*%i
-.520016444928866166943484493383e-1-.872401787359800705186197300047e-1*%i
-.237568340283393783228459685604e-1-.206470636193296937573721910182e-1*%i
-.852361672749821991680028940723e-2-.465057857559792055525724016856e-2*%i
-6.70443099637322020293432932949-6.11796512534771304981127267602*%i
-1.58112204708005304141680062714-2.32610789221486906720245282956*%i
-.109672064864706264137587391817-.425859218706750924266089042817*%i
1.29297769344976226201050427845+.981551440401567349228750993227*%i
2.96980818942647786513249237951-1.47556102843032537274309690685*%i
-.542653676666224565174118728024-1.88604940386547267518484493094*%i
-.553133731255687355481566668755-.189622914667156945564135399687*%i
-.148069902365283700324269889941+.316100180900270623328362754537e-1*%i
-.351865731601556856973000714410e-1+.200429359073042428707486724403e-1*%i
-.873269935927333294048932138291e-2+.741591745874492624580212672958e-2*%i
-6.98681424374731657476909525459+3.26953867553835848342857690818*%i
-2.15918710067464285163218885625+.495505720253470994906148831356*%i
-1.27550431998863175230947100969-.134655655785552460270738088149*%i
-4.39982763665774040640501263499+4.15508524150529910572493357847*%i
33.7933866726871454387485976422-8.56168563391812137123373160832*%i
-9.27269146726962320910430239824+1.49431925872987224852267178052*%i
-.362745100447204014041495637374+1.13061868576858042539932612812*%i
.213287013035687693335130264182e-1+.213455465356731477386697079617*%i
.141545490628377743010295039121e-1+.470046337594842693007263356600e-1*%i
.499769612497801118836552769070e-2+.118664461073259403416818729170e-1*%i
-.913399615676753680460407236150-7.18967266241372970996902032656*%i
-.248403190963709729635672142614-1.68453590131619705709236481696*%i
.464729314651420266298592808819e-1+.701347075424804997506761408571*%i
-.462472358670632282930445969240+14.0519686184554772633008431741*%i
-15103.7807817892584226577279702-20872.8645452578355966303741142*%i
27.3383408486885798907154582950-12.0437309278796210116002384968*%i
1.57639004115867550519488201847-.353935275408671217839180984815*%i
.239782905789520302345138860233-.403743199353850707970169659448e-1*%i
.517726314895759175863550329598e-1-.747242452878887539888508502820e-2*%i
.132445758587322325479880769256e-1-.174314162258484972530527089573e-2*%i
-7.77902711564685126568399998974-1.53575180423966777047090003013*%i
-2.35331957587453978638197718937+.244536839800683399479658423804e-1*%i
-1.19038678854531302692122804319+.341969606566563126101329312803e-1*%i
-1.77787915020664319786591519469-4.07638197637252866898803096845*%i
16.8476361866328670876227047186+5.66617533329842771050065764851*%i
-6.35260869858996780018394270928+1.53181920577374935536614313351*%i
-.650606457342730189693169378079-.814146541180823024277827428604*%i
-.423136432883124525664958152267e-1-.198037884615080043710504578962*%i
.726307343043551188429513159368e-3-.476241793536805985241231653051e-1*%i
.178268874436406556114489922813e-2-.125226107857242318359401820516e-1*%i
-5.37688212623852288211933755164+7.75486115912161447109800177205*%i
-1.02489143400249650216137000652+2.80407170169549432167074043945*%i
.218064006674378742113114789197+.591129527631653491575942572374*%i
1.36209759953720896485762456769-.555652339002440337199815159451*%i
2.28655758543345811604271560011+1.14938533381789638289246342797*%i
-.141159395501251929264269545445+1.55051147517780072136391329027*%i
-.422343631857882097284358758748+.282152521153986767225958878036*%i
-.139507281568832970979801200956+.757154131930614737057644152880e-2*%i
-.372827784340298670823458892014e-1-.999964337099912922925240133089e-2*%i
-.996877655133368160930319162756e-2-.491471288891816437639309290040e-2*%i
5.12648983797482492036906677228+10.4499771443157738977031258455*%i
2.89315612974756944258269075422+3.24199712502137605768886679855*%i
1.79947247236966947869626782126+.726724889327069756939528072981*%i
1.44052890907945416179620108668+.497001325061247300990155174376e-1*%i
1.13201253935451695338852803559+.332284666028509342909761840749*%i
.440629714584609353940981888993+.515190680078872495378138470234*%i
.368191612913114404919511918534e-1+.274705159347948789566568892688*%i
-.286648952994932086829481020638e-1+.896953327305622403127454531732e-1*%i
-.174004874431807215421790897546e-1+.242962327887747258713814914684e-1*%i
-.696603102616967447313268095601e-2+.626257842739029876292897614846e-2*%i
13.8868083483128729602933310620+2.06141543925866965187717391653*%i
5.73357437847873403684890169920-.212833796887546041158866573961*%i
2.59268477957094751258428169586-.635400741180563952824194687581*%i
1.38338877028748950845334260567-.483867075290345988075598082816*%i
.820226930246795374335224566754-.169174729236422988089925422285*%i
.420180065788984581928724676724+.462070859367176930638467274117e-1*%i
.159972803614461804656410901712+.823139420296287284818584168985e-1*%i
.464885525415070308757400353051e-1+.485221901577824156714847647711e-1*%i
.110904803581960244072791342348e-1+.204911544815549096548927862065e-1*%i
.223101950593671159342587952186e-2+.748516077737127657114600305173e-2*%i
11.5041451505962281895430974600-11.1490633543850754166771437660*%i
4.26503065735242735489287934360-5.12506769197203718045466463568*%i
1.69947265906427195091315777168-2.45108836605464912346935415725*%i
.794554446248606924758695080670-1.18451710191074254953303121715*%i
.438862335141334829577631721038-.533985690721894093612144151006*%i
.245263145244326394811569021418-.201117486409350712336701887871*%i
.120395208646216731944878282795-.570459863852106157379109437599e-1*%i
.504777354634369588478124210682e-1-.101215271815110070627421970497e-1*%i
.187282969952676939246727618773e-1+.372538749965283159165787100829e-3*%i
.643761633458304939733950346228e-2+.131967350073745885099055397050e-2*%i
.130029005202634778978324202177e-8-60433810.4176886488290340421920*%i
.199625087035667827862478823477e-8-40171562.6796708588231639201941*%i
.306646514557663096629073532884e-8-26698316.0198910660736702703624*%i
.471327718413735106932377776357e-8-17740590.5163105849489847314117*%i
.724911690900762308079443196217e-8-11785912.5969240910646588956711*%i
.111568297449542610827462605811e-7-7828171.01777401241615166223091*%i
.171833522897618885142950354107e-7-5198156.45219370271038059072611*%i
.264853511901295635686675899833e-7-3450795.51323313776276207189603*%i
.408559617432874522466234426113e-7-2290116.34324679018751239346212*%i
.630783103453551833281183552513e-7-1519324.23456396012725888110088*%i
.974775951344997022558168431008e-7-1007586.82437291962146620977677*%i
.150784736737298292331244781305e-6-667938.060822050991185685847223*%i
.233489965598634427339416166475e-6-442580.245625241663941687413274*%i
.361968592820797724013330691483e-6-293108.155385327768219367254709*%i
.561826859450513276957808218205e-6-194007.646705853014282965111197*%i
.873180833536303918893313128510e-6-128332.463740437962182047917722*%i
.135900714791648222636802190539e-5-84829.8542130916478395225183492*%i
.211839134996755910934919206385e-5-56029.7413965339296122382747010*%i
.330761316091452372597934350682e-5-36974.6505413958300036418037581*%i
.517382229212005709877498696322e-5-24375.6750500526616761195963780*%i
.810903186310321058614551715909e-5-16051.6776920421300477089245760*%i
.127370607877642816015961753461e-4-10556.7597245332344940514226538*%i
.200542039396442831135245622268e-4-6932.85138540663727527805261582*%i
.316580531253608048615820796044e-4-4545.44150414535417562450034138*%i
.501219478153561729689948544437e-4-2974.53902512121655012704748129*%i
.796118901799868490239764711577e-4-1942.31853450029591780320188953*%i
.126910706982593604169536010466e-3-1265.12457280221245425214067243*%i
.203133072708600863691019364174e-3-821.646170944251915777948060935*%i
.326625877180329579418247147427e-3-531.822527703359973822684347477*%i
.527928844990632391027635162929e-3-342.867900221700590643575210064*%i
.858369650081180231145822785195e-3-220.017770194561857089431819138*%i
.140518121084934821580098486540e-2-140.404772638374191580009798937*%i
.231855684390521974907947213118e-2-89.0084369182792754887648638558*%i
.386106319845307973530102089262e-2-55.9783767341745066859058410117*%i
.650006217572289332032431561196e-2-34.8665913313913870569454906433*%i
.110855060109827579413293116562e-1-21.4611567225313397525286100120*%i
.192035868455550129951276904917e-1-13.0174742968365275485765753436*%i
.339088760435584253903162551565e-1-7.75213080644924776600958193246*%i
.613150063026340550033690115307e-1-4.51008225397667839714288634039*%i
.114260375395699109679999968599-2.54612323664594953346994450073*%i
.221393910721942970170923620719-1.38163349121051053883557952984*%i
.451855492392719143953625591421-.710849805715435361019973882804*%i
.990712470049410519254495677708-.339679992590421622213285924533*%i
2.40874838548034405407649458465-.145872573532594102940010874070*%i
6.86436410399028390525131138417-.531868706518377848975945488373e-1*%i
25.5699037088231268082800759292-.147403419152668083582292690034e-1*%i
161.758482720453887821743807578-.238592232395995623240959027801e-2*%i
4538.82214854696577653693607023-.862265880414920317659257162900e-4*%i
731102.215995554053639982600819
752.245097910403946071424805520
65.4011829984643299700364525078
13.7365354691175281195824014279
4.22860822049431108279373424351
1.60566925786124961204006518418
.694559180812307417226004353830
.327895529049095326591525207002
.164684060760066919624585010221
.865741850917250703560262296586e-1
.471193460604021223912141364608e-1
.263491474703339928864443981870e-1
.150555245018035703150625503689e-1
.875411939339808452026430480882e-2
.516382009246108307716277392024e-2
.308270871601972906420417021912e-2
.185900343739297344864555279093e-2
.113074180204275337073272320917e-2
.692878068750311140612631366543e-3
.427298270010486816222856873330e-3
.264991682617139289994220407422e-3
.165144884603523150516845705336e-3
.103367008231871635191122854669e-3
.649490618291991848966431162142e-4
.409504829714175030590093841395e-4
.258992294532223900752239094928e-4
.164256950810656645455595317820e-4
.104437066055935471982485581899e-4
.665547568980741108977221461930e-5
.425019611003811975821814179112e-5
.271935966462760424608109345080e-5
.174294419660214972360859235360e-5
.111891855375556223184682933831e-5
.719378177539418312440956395541e-6
.463138829378023948349314243262e-6
.298549686245492015734012278265e-6
.192678929980606215441519148938e-6
.124488293980112399954639498850e-6
.805132469205756323429613762050e-7
.521220532279958411707664819142e-7
.337725979180065770455910252028e-7
.219014042398754080396948919900e-7
.142141803031424946134555062430e-7
.923195601982483083952747350666e-8
.600024550022224988845049756835e-8
.390238870441365671820725680261e-8
.253958299999615146105895025778e-8
.165367458204809297645630884982e-8
.107740729926929240826426617301e-8
.702327149230789544542438371676e-9
.458054378509130514002971340515e-9
.298883427809882172571256133136e-9
10.8171594140812036343018640683-1.55461652833276219210451175065*%i
4.33688925863763170675635392268+.577640465671702198633585760652*%i
1.87570001413649947288238312011+.992000919477408241357956627849*%i
1.07761045181763162880159310654+.883400571550194169165508818920*%i
.839999309464057559469266282800+.467684676309832024926668083262*%i
.536001107795864319313567346601+.441308131809273761416691489475e-1*%i
.218209223372900098395772290248-.904570814692720230950858353914e-1*%i
.606163231437735541386930899584e-1-.633526835753579902531825605537e-1*%i
.126396701790924658052514493764e-1-.269687633888213177557932325624e-1*%i
.187457743969731022457638027505e-2-.957064198245489789722303015656e-2*%i
3.45120772004503448369460398430-7.78995204566145022202902690015*%i
1.99603368703604927349238454477-2.10956542979126882100121611983*%i
1.10658351582126715156624680217-.174992501228267348595405068052e-1*%i
1.08758752355827826753548400025+.848947726451116955180433081655*%i
1.56609370917249322890891896335+.309696470852316123913784376627*%i
.823256168206383963273328391213-.590874296575590443534210685310*%i
.822508312479510118281135731017e-1-.400139054666919666841464430796*%i
-.443674702204572982812298106172e-1-.124620679641285794699342801548*%i
-.261612597900550867546227600968e-1-.302697727398148339970380169857e-1*%i
-.989820859241184333474301112139e-2-.686748977814454660579536845821e-2*%i
-4.31908603664391417295253723729-5.06876393147474656601437797581*%i
-.891078141247444165977651068563-1.84364140618771579385274091953*%i
-.487195496477540008597108520638-.280316675559449194654291794870*%i
-.219347070558209943427660256002+2.36401163985118155098246598775*%i
5.02599330016570567834275188379+.916352180813983273131993682659*%i
.351342419308906208548544881697-3.02389801787028014874649468089*%i
-.723688780598642350622189494413-.467610066215464261551977388485*%i
-.210237966294970389455792400170+.110352702116713071372281628462e-1*%i
-.492076751840311321981601437853e-1+.213377394521397336745944306568e-1*%i
-.118379423722453401070725134742e-1+.854988719780820523511787187299e-2*%i
-5.03990692426444823505011359469+1.95867435699810839936745243315*%i
-1.32784222381676212557573306289+.179426386838305703495906484146e-1*%i
-.682469133532689393427872503646-1.30250439526182507466669489734*%i
-11.0080237895722846744019966179-2.69027335215773395998766986256*%i
69.5353292944815867825043292750+31.6445797078780598603145735639*%i
-18.0465577049725191857835324940-2.43990014274621328818414247919*%i
-.857973551725280640767125787872+1.74497082877317466097557193763*%i
.409137128041456933634388010916e-2+.314843553909746347297297118519*%i
.156541196949048399030270921234e-1+.651894281544806911447697614159e-1*%i
.586997287568587953761544894648e-2+.156591043981148884347672541182e-1*%i
-.627092570020336582781049856773-5.04209338687477265285454785994*%i
.645784630640302362888197785975e-1-1.14385805421586325619554412101*%i
1.66221517527749628753007429299+.188736663186844941442363143667*%i
27.1516736591341691945697306991+10.8402493436762318262983254547*%i
-119999.750003240887296413042628-199.999580875096752391027745968*%i
59.9829617157117379615678915907-29.5079476312842134523134606256*%i
2.68314147613305406656290443540-.652674690276711412305765613475*%i
.358006848089354991462865124875-.639992809632553611289780100859e-1*%i
.713455753921700625753902008966e-1-.107718452384350310026693089593e-1*%i
.172930007249062410920581337564e-1-.235582674995403130911675438963e-2*%i
-5.56809003828517537443968642409-.623899955052475304148496076242*%i
-1.49256061501712445066409528026+.370343239106018048706263791251*%i
-1.00178008283977863556258449429+1.05044504529238823110643142274*%i
-7.95258178520846124269266124139-1.56433763939510256821550596815*%i
33.6575499861722509168047298025-12.0313464897082703353953153689*%i
-10.2019573003035457706170133018+6.46990533182903758102792356725*%i
-1.25450296982333861192955455161-1.11017818087792325039159817469*%i
-.910032401210511893836239933039e-1-.280243264602042262946750220701*%i
-.344134096411693076255381608879e-2-.646484940350234222131516980029e-1*%i
.152243848250617039292714635235e-2-.163105632995977368023274174336e-1*%i
-3.17969801954344072887175614099+6.21161649115530371432345012634*%i
-.440605454117322382727538204664+2.09804431049380795584321907450*%i
-.158282126621974427810105165750+.226810096456941018375772684738*%i
.339864327453418969892943973013-1.87830191857524386722902992781*%i
3.67715309732803916268690731342-.605674488123044961345175902253*%i
.708681180230134660455084003900+2.21345434081942097539831661909*%i
-.486796748863219275917977281758+.546432473820954396426326374257*%i
-.187065933324497800874694331407+.422669052566531326515847060878e-1*%i
-.501984900558766802010465979975e-1-.733752761984031660500082397869e-2*%i
-.131280394180823871838929046024e-1-.513608753720175108395869432053e-2*%i
5.27389935903174150511024210734+7.25922379718527147830890615635*%i
2.62397936940425455164333592270+1.80449443729418506070317115009*%i
1.35593131637880777442475695065-.108162344610053819976543806407*%i
1.13165424339255157470604239739-.777969902349637405378417720592*%i
1.35524979241411852444123388134-.321988101133160132923282623185*%i
.769049118256706424546789435022+.400125163192318192815126280654*%i
.143389848467227823352995113064+.330608595873245496460997047609*%i
-.132700109493987526157183625397e-1+.120363447241933542916778092555*%i
-.171991679683338341421925115465e-1+.335052099706655531992714816647e-1*%i
-.767956811493452074813120972280e-2+.863272812351698224475854566205e-2*%i
11.4103793990131249033115490477-.544192790330496783642207306920*%i
4.44447685620769108410807768787-1.37877571894171060129612936632*%i
1.85947812022895779358824015696-1.27837881704881619857658990452*%i
1.01063889886463790229359551533-.962722547681783793886970062716*%i
.742705725429046386937958401145-.512224868896108977867588641716*%i
.478810761770869067873710080618-.109578152962576585030267855019*%i
.211632466341354067422136924326+.450769824807816242916108996945e-1*%i
.673231252328380939852643194415e-1+.460493725150854871564788413080e-1*%i
.172178152954368372465188893247e-1+.222960688155830513382011424447e-1*%i
.378794911793379802612187444301e-2+.854994634572143774892865430897e-2*%i
7.79054780129638761040383370067-11.2601458871156678409017516912*%i
2.51813757587916359800797687402-5.20706423842258819344172322863*%i
.828835050783404292435311645056-2.56317110851284762648912032970*%i
.364611634000403039828225298867-1.32934524359946802073945526743*%i
.260388660563324145654750789443-.669972475282393902517362141282*%i
.196917867799465802902521974376-.288344168573170176319169049583*%i
.117646062383787255946143497401-.960703189983285806788424483886e-1*%i
.550319572940072278269834370186e-1-.231689977850407099551713674791e-1*%i
.216140246879774571380820831641e-1-.314494090603903552068937483567e-2*%i
.763251709895681242230688176123e-2+.515959810531085495087370358867e-3*%i
.436637895638161957854570168279e-9-55380485.6194397438496555050450*%i
.671489855740771421896198179707e-9-36743192.2278098634361541063584*%i
.103332418170892424788534450581e-8-24371801.5121677592053333702902*%i
.159121481422276896638282226573e-8-16161411.7757107151384894938822*%i
.245207307779903598080345619117e-8-10713741.7750599638204145673033*%i
.378154371180207388975140819452e-8-7100050.75827052889584873282340*%i
.583655146877980655261070990622e-8-4703564.02314535809874081808860*%i
.901606735522656738347705633918e-8-3114752.21310468461223829253321*%i
.139404169909576619512187899269e-7-2061743.75326723496613492000801*%i
.215753856113015788607075299153e-7-1364088.96569397101723292739435*%i
.334267734434897943624605586140e-7-902043.620756940958359125871187*%i
.518459893251934156551989979610e-7-596165.534842687478543599869938*%i
.805110704680246239029800770791e-7-393763.642928485849022272748346*%i
.125185570429601143781900027902e-6-259899.606354381525667708370688*%i
.194918821494932304517796033506e-6-171413.548302010367076035759295*%i
.303949451171747627872715087640e-6-112958.341322457827976817812911*%i
.474733196316951469206220768215e-6-74367.7140848162280451749581161*%i
.742774803403633669818455877294e-6-48909.9549929938758734808316161*%i
.116436663934023933299542037448e-5-32129.5032351695318078734118777*%i
.182903163288230526867209533192e-5-21078.7193747724947908924649999*%i
.287961783307236612389442062905e-5-13808.5604407288061715011936220*%i
.454490721271791361654028587793e-5-9031.01079333317942925376288237*%i
.719281760840873246364137042134e-5-5895.42534302187549276451536933*%i
.114177252504655800461483108257e-4-3840.40080704275272661188753402*%i
.181847568355848969951332896451e-4-2495.70948387435203796020776080*%i
.290700241904299645032621804354e-4-1617.40508158017181655117704620*%i
.466640127093936236669013281880e-4-1044.90077252363618101151440616*%i
.752554809487508596376318436681e-4-672.595245644620228845101494076*%i
.122003687471370864678213856277e-3-431.126926903790227171814333986*%i
.198972856310494138986256457479e-3-274.997290828325396477287448322*%i
.326713948071150886742254181345e-3-174.405166520258440675404950451*%i
.540675138073101715895369767142e-3-109.863595354326433297863450310*%i
.902895304079988873824735420733e-3-68.6541961464677689042464781648*%i
.152381105408617654878712765766e-2-42.4941295025203974140350814385*%i
.260398799542765019345855751413e-2-26.0026863918483874774282125333*%i
.451643996274269286424392529595e-2-15.6947811669422209258268189147*%i
.797494374476896347044351491619e-2-9.32144147635269761553183742822*%i
.143932167576203534521417145383e-1-5.43886861025485793561003539132*%i
.266918153216043522856517682826e-1-3.12860328906116251272909909372*%i
.512277124905046292147405213581e-1-1.81935150492257829704332836363*%i
.102777990479069964305443053379-1.18252769801764406781570721561*%i
.218718092171811262905734710839-1.09815163367188038022818298258*%i
.504699679071227298883541226361-1.74514129123606616878407171263*%i
1.30831689684477992358174749580-4.10339592232111139338308354608*%i
4.05184465962813853192359084023-12.4959196308987146115087284912*%i
16.9136790740382137212474044914-52.0612566253577120775509162314*%i
127.014014882751666711203053840-390.909798861535427465087553075*%i
4936.62936334811958851027011130-15193.3829429974410302741031677*%i
4270190.80415763940413411177928
2217.94945067445953508816854728
152.568670485493905992449608616
27.8324226060240149964296053028
7.76500841776523288840327262810
2.73869833441458215086001868802
1.11810493551517687871903896250
.503780118290014914845891747377
.243465710630769419716069491126
.123920505156759009060284220887
.656163356544039502957409449992e-1
.358340109313613100449510470911e-1
.200576195847873058715770097868e-1
.114537239116165596697413643928e-1
.664913028772788539254661746305e-2
.391333773492951159844005819383e-2
.233002481081480197204762076590e-2
.140106806638348517041921105149e-2
.849651714757900282154225335355e-3
.519054668122765754184907227081e-3
.319130944277054559229298274480e-3
.197319181413863396151438397363e-3
.122610952900484129445252393481e-3
.765257217808173897801236117201e-4
.479510311663873985720672862729e-4
.301525550917354176798521399361e-4
.190210009431997514216551914877e-4
.120335349232249969544496980982e-4
.763287376243450527978049433301e-5
.485307012320390874694376333948e-5
.309235536757798888264810799159e-5
.197436570254538510147862771267e-5
.126287699018460457415050533991e-5
.809146687174370866504344661917e-6
.519242629117618163021945214610e-6
.333687659270778062005816840638e-6
.214729417155000528700684136930e-6
.138351477726856686966061227337e-6
.892442085224370474619864067635e-7
.576297586529769788951136133396e-7
.372523462404779985456269224029e-7
.241030923682925971046938685356e-7
.156091344894067233483526497343e-7
.101169255299488971965627232836e-7
.656236851631008024438119183295e-8
.425986051244695661423796629873e-8
.276716308624554532272761581723e-8
.179871372210398507627474980379e-8
.116993521470114626333730340499e-8
.761412054369232065264636030492e-9
.495818333578952266109853795166e-9
.323041249744975818720401737666e-9
8.54240215855912453682774241594+.527946086069209027576571472571*%i
3.05661288738775054345498385401+1.34898615106619367714237653080*%i
1.00184677101461023193674619123+1.33898378789919299278179952920*%i
.458824583562932116808048278523+1.25001979197341394446384683750*%i
.601020350464556929289774898893+.895407226607873895230665823645*%i
.585322641002781913163536493944+.289826677713371765852247328351*%i
.294165961159935101021085708162-.297636019215506005108538561834e-1*%i
.919483201797630857974889835762e-1-.606650160682385710071379160224e-1*%i
.212957441313390285140589570718e-1-.303662788090494251389223971370e-1*%i
.387299584640480514669255351491e-2-.113350772420186247196992788953e-1*%i
3.52741687336170320791114867579-5.28492007060114611264960386104*%i
1.65240481585019578612892216851-1.17581922031803996330789887312*%i
.423673011293796140532510682105+.293106086706902946435948893786*%i
.113766869365970955389954358830+1.46452918010809311578662566531*%i
1.46160223602980916862938108079+1.45321687170189745210028828324*%i
1.35656709157231639342305546965-.282776336554965777539965681480*%i
.266436849631774930600531337975-.491844791303008100848193004388*%i
-.233912148978110879650937977965e-1-.175650662055951640310547446821*%i
-.276459892908517387166719024830e-1-.441814334686232764549043463627e-1*%i
-.114611325508161604974448647693e-1-.101004692151258606165349350208e-1*%i
-2.54844167418685660308054370383-4.00587630027510763182183113441*%i
-.333865654140150239765606208384-1.49611639849209676618413932655*%i
-.655467125034902727103310834312-.864752167874447345523547627376*%i
-3.30004310305884163838968845085+1.99620016347134823569641392509*%i
5.66336606631823660048903927792+6.19207901696989485066320691696*%i
2.47868033495420224876034075072-4.27946840750504451076575209800*%i
-.890188910976796657233537164494-.971211394978733273024849629588*%i
-.299974046146710499323291328255-.346393914625880559796116419046e-1*%i
-.698557534680618846593698766606e-1+.210728209629042018121734350581e-1*%i
-.163332959159617266627153604721e-1+.981190153047935569762788553639e-2*%i
-3.48726846925185436697377641305+1.13886028346889082792102679934*%i
-.539753616884397130188827500748-.361954503840325758576943915426e-1*%i
1.40749508958672907200951167514-1.57902083647665139918792234350*%i
-7.20872974815222191569434149335-20.8414754059817435420350423073*%i
79.4563122847922426938921262536+156.740837234225775941528908740*%i
-33.5071993298949043937850303462-15.4882927411233053340415284307*%i
-1.89133888339228603050251514142+2.71403387967656131526053231555*%i
-.372444326963718695252016950527e-1+.475993361703683390456531334428*%i
.164134225791059588517155187774e-1+.927221134921331470371863522515e-1*%i
.691172100451506875983401054508e-2+.211568077381940569080878663144e-1*%i
-.454762381232340876026266818342-3.49868393918115837087919750895*%i
.591791732696263497669208245685e-1-1.07912878881119985772667969089*%i
1.54507084011908791091204922143-2.65653525672331074708528071150*%i
42.1779712390986561110034347854-47.2611973940542250794768257045*%i
-344511.040344752654155077027201+472715.314182764372540945057070*%i
137.103720279080037847109399708-74.8689925299683694742696857896*%i
4.74242009584522604409937187300-1.24597277192005821555071729058*%i
.552281883868881005419725174705-.104769587916152975865452363112*%i
.101137105805568188020672474187-.159858123849102367731019055186e-1*%i
.231424923400045743489558057404e-1-.326742905025184123287039149165e-2*%i
-3.80805996312270335308394644446-.128803267548459023542225255508*%i
-.649706335086700937058397633162+.403061541870355371229511686230*%i
.597514267978666657959267253506+1.86116398654788809274624726778*%i
-10.9607668546859694964049360985+10.5623436987958083036302513657*%i
40.1782269157350108388461127552-64.0261329949392915407965251399*%i
-14.5293720502058525842200043390+18.2907935731310003533161559918*%i
-2.39055152464428387878604151108-1.45222561979335689292635033801*%i
-.181757529202249952418423965373-.403782496503670584552893378214*%i
-.113756473102827735650877760073e-1-.897637750580056882290864703863e-1*%i
.894829007055481799668797818496e-3-.217187758088074046791985695006e-1*%i
-1.61648751506210875588339992398+4.76624605577660803812513391603*%i
-.354734452931525387058878863704e-1+1.60951106996469409737401499688*%i
-.520742752140372511834598713120+.566791724940663099370412950578*%i
-2.02938802699617619780538670169-2.07556041457674596900521949812*%i
4.01492140265521666272519563489-4.18814714750310047868238187172*%i
2.41304797448998463015462571756+2.71547249434308881726802955378*%i
-.485876626119284669629601016484+.979710079285473458909459569792*%i
-.249929256217914981266850418066+.105880350121193954371649165411*%i
-.684448337165661470042634539232e-1-.136605427213994220113655730066e-2*%i
-.175799161104106175001138803526e-1-.507841872739951010990964869206e-2*%i
4.87337909433090102653029610349+4.66545435253837121224881211727*%i
2.07819213141883098179552771124+.828549959734974588880912855857*%i
.630538378081859550008727058743-.484052932144476017559675979655*%i
.290293419326594856469362297387-1.36069397048811997087104712760*%i
1.20839724710227161842400349895-1.24200330493909093274743002273*%i
1.14999683488420396737248892731+.784584232080118415764734036927e-1*%i
.313488429870751302463305375583+.368377652451016922258953272412*%i
.167150557056841711537149757713e-1+.159157492765982111999883216424*%i
-.150808553077819435492253924215e-1+.462172662432880787343528344702e-1*%i
-.829708727540043756495072878372e-2+.119643863065606118588508478716e-1*%i
8.75392799310749282037796159910-2.29305729587809836191877547603*%i
3.02447509883925330101251971603-2.01048773218920229690965466042*%i
.958935926946949674962357619721-1.56441674539398637859144429345*%i
.413388991499668632108958422638-1.26736771815747996090835463613*%i
.492761165968049260209254855012-.865059081263940145680669051111*%i
.486253535478275073170598797006-.327262757641930755126115518229*%i
.265999069769851137885003098121-.210955229656080749369239631053e-1*%i
.942548209949865818617928307375e-1+.371155920084873225441722418681e-1*%i
.257366286967091465982255666611e-1+.233925854932387099557899611932e-1*%i
.602013050260771462683808431138e-2+.969599023921350710119892132539e-2*%i
4.36461781095420220276283078050-10.5887862424478078058684290543*%i
.877186562949441877512422286224-4.82377130799992757331248275092*%i
-.477697526151825800207093798467e-1-2.39066108335366639857345863007*%i
-.132915850535659956697536810222-1.32245879351235865234941727695*%i
.106058286747979001907159326863e-1-.755430207483107475694157535591*%i
.109220672627577235542739978270-.375250719771702182077880660830*%i
.102404938452566332730473851704-.143599429777191638251856325625*%i
.574805970320888814955442520831e-1-.408799293155072365942465837803e-1*%i
.245703719043514626388514110966e-1-.825776788999428764551871691136e-2*%i
.902671358834982423613843759673e-2-.721254632644576208132458966683e-3*%i
-.125193418404244053253870267891e-8-50337479.4790011540521006484505*%i
-.192890256888324148687416349111e-8-33328798.7878276077342008718582*%i
-.297407529240955946466952598055e-8-22059706.0234329455901661190690*%i
-.458906933867480360990459530825e-8-14595513.7753168261837155357873*%i
-.708676267994951756415078884327e-8-9653064.03116663509273660407294*%i
-.109532510490199981250571577601e-7-6381492.74428904666409909493572*%i
-.169446729475389657510289229167e-7-4216715.40139867272267524065414*%i
-.262387715343218044248024527009e-7-2784858.37345335422335031162259*%i
-.406725506807375415656556982372e-7-1838182.77817222259385351129550*%i
-.631156302310392066525953091852e-7-1212575.41926124970141148442453*%i
-.980579712715285946106047272129e-7-799352.869059175990251501946534*%i
-.152537082097516537536194499945e-6-526563.064456045273054358580721*%i
-.237604263757591840074896123992e-6-346587.924508773456938725853487*%i
-.370649238570785845483162305825e-6-227925.550023656713988235646057*%i
-.579096002587611107345955725051e-6-149744.272994497716489865939703*%i
-.906296678428857321218026920852e-6-98274.5778877668897655535837130*%i
-.142096191649360536343720852659e-5-64419.3462483140701280842744989*%i
-.223230505191313130408255777147e-5-42171.5301095248412001542800981*%i
-.351445950603529849258961755378e-5-27566.7987488595795415146391723*%i
-.554602171410614945910466647158e-5-17990.5395035211752064368664866*%i
-.877440168875232289103080614174e-5-11719.5030790933656841544408978*%i
-.139211104448658684733976976748e-4-7618.77351822259722150014637211*%i
-.221550604254409361940307203211e-4-4941.51990414628047852598838807*%i
-.353797212047984323719518977835e-4-3196.73480452974352163550991111*%i
-.567124880584151661997107408304e-4-2061.92494315648197674014191923*%i
-.912916332375659513135738213634e-4-1325.51042469168884999676122934*%i
-.147647513904866692829266431541e-3-848.848432290872218344242630339*%i
-.240057420553312326554753305810e-3-541.213250376763439115703700576*%i
-.392638546065951888833112252498e-3-343.325223784389134286591088251*%i
-.646559827489835365079860480362e-3-216.516943351814052252741128110*%i
-.107294902571013436096154114817e-2-135.614066757545162860553133483*%i
-.179640950610824481072140129734e-2-84.2620213281273013636908205436*%i
-.303875991979256174307576371397e-2-51.8618400708915664989016798442*%i
-.520235046996828506161563150518e-2-31.5636735521191771690574155961*%i
-.903323040783613900839469358942e-2-18.9548258261744615813954169304*%i
-.159512431245202717756208560212e-1-11.2033943891262602704349327605*%i
-.287438626002061341472723954410e-1-6.50054113172277968325098537394*%i
-.530923466209558788570575547005e-1-3.69854375609936952403227402253*%i
-.101116389561616807576858273476-2.07778994444396007597141269504*%i
-.200168363131801543812369102201-1.20070092317446542145164931771*%i
-.416495807575281693449913612143-.830544186724271021450174316769*%i
-.925726173820932405165979934417-.919384390098815187199331152106*%i
-2.25216248805829161812795982924-1.74143032102618266387937578930*%i
-6.23588213190850439756938340624-4.56985401355369207481014308281*%i
-21.0248698906714307678440881147-15.2874254298175040454291722228*%i
-98.5086785417020616335839468937-71.5733564626105062812324840489*%i
-879.289071330390467206150575457-638.841202261669208205665051306*%i
-47377.5131170859577053445025553-34421.7781562699458951202202824*%i
25981326.8403943402912134723617
6808.92408673150754311743752741
370.185438531494700960644786044
58.5685045878993021271616674675
14.7839557442220692794454944571
4.83458747126229411527713795574
1.85953267907242593753888603009
.798248764562368995104089712021
.370592498149152265425027365127
.182345682187099585029253246372
.937980217509221092381389763319e-1
.499586639224074443839269973781e-1
.273596895194749027230968808286e-1
.153261262996611626849393287588e-1
.874684721473030810510357979419e-2
.507027857119452388280653905479e-2
.297796334458332900917027868810e-2
.176877048598996867203331873039e-2
.106073297674964482036809481145e-2
.641452815235465481360083024198e-3
.390738091950071699845889604408e-3
.239543301488885557371402925568e-3
.147684731967662376404839763294e-3
.915094456211686380127011127936e-4
.569561669030564931944461677823e-4
.355925362788954942403058824610e-4
.223227003676079571427181447504e-4
.140460190032346328188939646601e-4
.886434820638950308061559160922e-5
.560934186952226823606461759722e-5
.355833502272604931844054535337e-5
.226235949579784213637804820799e-5
.144137297409338646439547346744e-5
.920068003032781472470473505571e-6
.588340340137335148478034000935e-6
.376829918779809794037258525200e-6
.241723458381182367548158019019e-6
.155275354799738183712273208927e-6
.998744991021319522253582352433e-7
.643186595937889940712238617193e-7
.414681843371157019247612458698e-7
.267643780119517958818015416382e-7
.172915747532745002913500603702e-7
.111820333455924937057550698771e-7
.723755087082251066812754358832e-8
.468840157611856625387310839887e-8
.303948343081945914762595183898e-8
.197195781534682979499944501841e-8
.128026777744588977406549111953e-8
.831750659576974617876512564976e-9
.540704025523755356909814062752e-9
.351711199881969394632263037208e-9
6.28676708641615623572294895180+1.76877974592734744375759267524*%i
1.84960145140747120655971104816+1.57220835944543036355551014308*%i
.141596889046716135289400933666+1.21744664507863174985416960547*%i
-.347961521227356796037899076814+1.25446831757251397046233301015*%i
.901548961604254909059756481050e-1+1.25122861771885396392338602615*%i
.529760643860253990665079244365+.624269903761518511017722746907*%i
.371786956997025217203806184814+.802117127580962421023365599559e-1*%i
.133522284817599564939526736856-.476590817519088172117369616950e-1*%i
.337772344254094682361547612533e-1-.329612004849016988744716473423e-1*%i
.686574902930162939406559448783e-2-.133396958141604844053130413938e-1*%i
3.23537672719037494171993118394-3.34042381050499054642264075123*%i
1.30004413597552326836930012081-.652620071058189543755625170089*%i
-.121953325771436601328388539019-.860889905581523960711054241475e-2*%i
-1.32187022476594970953424453232+1.23373542140054875861905415973*%i
.483887363357644686314602857582+2.78634589568139334681439172444*%i
1.92149039673960966068933342301+.454780781953611398266943016664*%i
.571147331250873493364647125099-.547835916085800098174209194789*%i
.218968918657745075278242118877e-1-.243047193799168464096041887435*%i
-.267964257918155814285673642621e-1-.641838793402360269267980675258e-1*%i
-.131172456525130583022860598066e-1-.148207809562890424547814441256e-1*%i
-1.31073536564061321295366338311-2.97466962314047472544096732287*%i
.216406858727093239730946206642-1.08519063056609793049127080946*%i
.210337165278499821444685753743-1.68245759212065636196531410996*%i
-6.15675461177173675317669042633-2.20731303226162722196733876412*%i
1.29110563695317783990253782764+14.4867836103562492509232323057*%i
6.79078074110391325414033098503-4.91831731960328690047424738825*%i
-.958022075808364429735936135507-1.85361438678615764515809042541*%i
-.427555120148026230127042757292-.127868815157400709430646752401*%i
-.100402155007296929124647476421+.172395336588589971832947559282e-1*%i
-.228945916125925620610028558882e-1+.110848058248345327725698340157e-1*%i
-2.38257125996907018458918425227+.690765689890397428149828974519*%i
-.184305831015151535050487530893+.380338511631535083944995443937*%i
3.43816417664271881371620301161+1.19617932584544295130323992669*%i
27.5079284319993118405137521187-35.1768181154791805834767729121*%i
-85.8432649494679906089978643515+413.038539000656606420452419791*%i
-57.8036117560231978269015246379-52.2257760355701429596403405719*%i
-4.03564222611820021987212166971+4.20906520463560424884306966532*%i
-.128509899808109455246957634369+.735525110877471542392571926515*%i
.151189648616005411789431149294e-1+.135021736798850583794764406570*%i
.809688404735556757394819958462e-2+.292318709601953991551949386796e-1*%i
-.417699301794891212565382370945-2.34811643427838104076173487596*%i
-.496670409319604186808111944915-.887269330386325176193894410797*%i
-3.39544320142030581222096578495-4.16275925234641528189828967183*%i
-67.5212497417680885544444942631-125.615473826084890040431237516*%i
914122.426986904114681008447909+2826026.57243505090597827593826*%i
325.128948930077694758544685072-196.125095575364180686130840474*%i
8.68025260657973936534662477417-2.45536774821532080535028022840*%i
.878704058446897363272567203043-.176724850416713504382889131018*%i
.147303928374670724804378095687-.243823458704450858143717047095e-1*%i
.317181470850731797612992630002e-1-.464526925722464662635411319381e-2*%i
-2.53632226114875792229469342145+.441159900790860895676401136972e-1*%i
-.112525805076889047655427929047-.337360860465620738547631118519e-1*%i
3.11278121845178003987442901832+.350978268207007661793583225901*%i
4.59889685937428458053523662889+29.3114483345856749200198690457*%i
-17.6858124676988906877587742778-166.084755047399259393761878217*%i
-15.3724415537165169879025811072+44.4646450815067857234311666017*%i
-4.52507499492961772974715453507-1.71503177227718958399052437740*%i
-.350828812802567399347334605668-.589780464774722425616740146054*%i
-.261710858978701710806446428711e-1-.127228825880262516051464991488*%i
-.412165048045063375690934243824e-3-.295289447474257754154986524594e-1*%i
-.572663057070315415317120408087+3.46309915800679370820534564027*%i
.375821169879019250891111532051+1.17990887135285196735873880307*%i
-.105487986794078012019603551853+1.36341774597473904711221266588*%i
-4.71418920479968048639752202167+.460483652019763071432570271140*%i
1.10345031331467686523822436180-9.49945843790942422761517975904*%i
5.42188347370065772945386783203+2.39553211799290340735735171006*%i
-.306532071431262552873452316398+1.66419650154021295716042814605*%i
-.329155980922382576075014591521+.219604114783242756940482180375*%i
-.941789120664788529693120412073e-1+.106570595559633723809298997483e-1*%i
-.238887274273618509800949516234e-1-.443247081429368411285638602708e-2*%i
4.16671344312059502685052612799+2.71608023967818160606983722759*%i
1.52660930881197387042850317728+.313893699549954104350947626669*%i
-.215790595457536827896976034302e-1-.273006427776208207954907872058*%i
-.950692151777693702733898592720-1.26563657999433186166786062481*%i
.387617789752055171130262818380-2.25044155932476263614015426040*%i
1.48884358807648665907517515013-.571783463517253925367606008631*%i
.570502911933104973125740272600+.351836769340138872418807452787*%i
.709235583606793943584803430578e-1+.205393711355999810520644289279*%i
-.934419653471825115226504794970e-2+.635766988706632798269044541429e-1*%i
-.860430529897831641525977770112e-2+.166464056023115146662185468719e-1*%i
6.20976652108634477409833853206-3.18963541482952555253773472639*%i
1.71103448826636215084682003277-2.09640121729401580794628357449*%i
.835496114317071100292320200418e-1-1.40989960726613787252093470198*%i
-.331714978524195257562060263586-1.24763002519309037688148459043*%i
.236467812025990142160115632569e-1-1.13316887084600717205850910758*%i
.394974331601146185624577790247-.602294582695702682992799676667*%i
.312377764494154779804779972605-.128406610531082088561237581766*%i
.127620491749375527506106936709+.171654504849562548652842832113e-1*%i
.374040485847910102736191224823e-1+.228855921556850244360645043803e-1*%i
.919874221980175298041746536704e-2+.108144430417266441835406157755e-1*%i
1.48986210934933299740571843719-9.24119948062222528272391243966*%i
-.473122121157703072054121093553-4.01679358532985767369728096911*%i
-.802481545365250848087029731203-1.91736085279924866192766062408*%i
-.633859607487044678043855819308-1.11308454690062126862313117080*%i
-.301286443370595112047210833296-.746773002696659569676315841175*%i
-.282765453706718565424851749222e-1-.444890832483008115619979069035*%i
.675883369240375863841091934125e-1-.197625758290677248256583521462*%i
.556451079389199756916120631889e-1-.641476742643036659749267627842e-1*%i
.272001149722365003156977353856e-1-.155262307997012031947701597255e-1*%i
.105914925296312869101877537848e-1-.258075109183287077029975869634e-2*%i
-.138177874255614090110225552175e-8-45383947.8813872093305268186772*%i
-.213326522446540761636728438582e-8-29982400.9746840621402410035763*%i
-.329610072687757840693728610091e-8-19798886.3631028528204933659435*%i
-.509713088452492493361788171568e-8-13068037.2860208783226153097041*%i
-.788938032407071632790065740069e-8-8621022.65107589603899459427478*%i
-.122229427647446605270777003500e-7-5684181.92890398887074454157389*%i
-.189561660896991535400716494422e-7-3745570.96834456640342911611354*%i
-.294303517561838846394378082376e-7-2466533.55249471762705175998250*%i
-.457447841912739260380140753483e-7-1623120.28226431068679353098598*%i
-.711906152535909913041072048855e-7-1067289.37558708647917648323275*%i
-.110936901449754067298847361662e-6-701215.699362795807397987134103*%i
-.173117977325800531408020185135e-6-460283.945314822204950797740535*%i
-.270561498607053490496507104712e-6-301833.696963105140299330175514*%i
-.423542496033602420012933022659e-6-197713.297503279064691125619508*%i
-.664186291223884445678219511358e-6-129355.180084875420811757472639*%i
-.104353133386697575609397371292e-5-84519.9637386728129399431125824*%i
-.164290086434074191340798643649e-5-55144.6487227289116364187545156*%i
-.259228633321386535978429445053e-5-35921.0787076145600708442596369*%i
-.410019825333395093484562593740e-5-23357.2452653573426067547353579*%i
-.650237502416779067655687001414e-5-15157.7227948222692689782626504*%i
-.103416921084326227681004781697e-4-9814.94593959005340713091279610*%i
-.165000395086518712677053392583e-4-6339.72627786714842097749672410*%i
-.264174056643536109248842940380e-4-4083.67936793943144169130053762*%i
-.424585148194222171751933703701e-4-2622.29054321129011768331576556*%i
-.685314363561311849872157424873e-4-1677.96611317582498913498366740*%i
-.111140931367707743978286252324e-3-1069.43567086785632014398674930*%i
-.181200573296829782598048910909e-3-678.509249335585873426157288479*%i
-.297186488767579684329786456166e-3-428.256519265590193400270491608*%i
-.490698199805192239786478701386e-3-268.697736714525055431389416023*%i
-.816410193695205321016489076349e-3-167.430787823168534700209040856*%i
-.137018406539676114610074078538e-2-103.498930625045643870062355150*%i
-.232267501309218063256272025531e-2-63.3840711369654451088863400285*%i
-.398308348670666889244833651021e-2-38.3926495330584473473498705251*%i
-.692322034371227531314013786431e-2-22.9528440962792115348319989968*%i
-.122262020006576028061057563421e-1-13.5073207625328582947669876119*%i
-.220024900158082771543159388520e-1-7.79451814555551409350539697653*%i
-.405049839819518784006840284722e-1-4.38279013394926789670903416644*%i
-.766570821629843797795532104707e-1-2.36827305813926865401624744976*%i
-.150122600858913570439155358212-1.17712801991894362585410386834*%i
-.306927222824219058746744688844-.430115446408430217404176421675*%i
-.663238782429086470493658422759+.168532982218241286189390666165*%i
-1.54188937364409247352261147917+.980789030212014893497569746363*%i
-3.96074837203873967313296365842+2.82162143747203912302715194153*%i
-11.7308092639103656275336464286+8.50347086878544623170103140890*%i
-43.1184394773400273822735952136+31.3219552269976455842523207536*%i
-227.037225664030894110698446547+164.951149263515784282147713583*%i
-2411.13511401517887394016419645+1751.79210076189409710790808315*%i
-180212.462911487347576990187460+130932.018380430921079690289032*%i
164051896.703654650063057375654
21685.0205056711285809912699375
931.085562062073749998370731054
127.618609796393239772236887820
29.1074719121012721470665792520
8.81289337653705934776223390537
3.18882231973022868765961712791
1.30228828066648867891553289082
.579979834279498427710553736194
.275498347541720144155773770747
.137496849811977827848878673674
.713384829626238491531650629972e-1
.381816801696542524026687903996e-1
.209593446370425751955343787498e-1
.117483471597199575565484576320e-1
.670136397675185377074929038200e-2
.387936600568171708261654356971e-2
.227419293899783146565834656745e-2
.134771788428158855949586429414e-2
.806212764593213550679885126003e-3
.486251600504633050503176503895e-3
.295393044605851774565894991663e-3
.180593836675157503615192401145e-3
.111035017213845132795808614597e-3
.686131712769297412781746955453e-4
.425910922210083302825765282961e-4
.265459264671352995590412008634e-4
.166063658146466622050509260498e-4
.104231814107865657901378819593e-4
.656212666450857155106697863542e-5
.414278779777246793067251011662e-5
.262206191269600340227547838245e-5
.166343241709054441679282289367e-5
.105754523822221723336456059827e-5
.673678114577203273418785207960e-6
.429933348054660255973666874237e-6
.274844478514322939456732597161e-6
.175977740401326939818327370666e-6
.112840739478949875738188706408e-6
.724550406359537543707297350113e-7
.465829192069471660413395431593e-7
.299850372254376742082255460207e-7
.193227856628145340611322841691e-7
.124650016608086637229216438036e-7
.804905830907305267210031337116e-8
.520238887913345552463076228458e-8
.336544442340902377470009727406e-8
.217892640488404395582042095476e-8
.141183357377661328924344247384e-8
.915476069599996941169937316496e-9
.594040573316528756743491985748e-9
.385722635165542688681363654768e-9
4.29841913445714810384808014484+2.30074115783128313781547355688*%i
.945028250759684628313544306262+1.38105796808829745885487872053*%i
-.421820264808160527983579193227+.674843624820974116927809223552*%i
-1.11950360308533559603264247478+.737989400741118589764563388609*%i
-.716194602713421013507820576949+1.34609700667416110303098096847*%i
.283420812616129811156316610161+1.02304702524113302417069540217*%i
.430289728634975015894723326617+.260752740819305462672107428162*%i
.186216860936756117317413761749-.163798495596721772539354047950e-1*%i
.514813106763279305789486314985e-1-.333879275949664741468088318749e-1*%i
.113034992627702755286016912955e-1-.154695492735408697519437836093e-1*%i
2.75435891640092883362504486913-1.89268923518997788963965770917*%i
1.11761009191702915264789781097-.329004356114120473211463267772*%i
-.312758502233800030643766002200e-1-.662358935933570935913614769888*%i
-2.51209796868737788563467305558-.350444428248865907108280039593*%i
-1.82899583034131490295014075741+3.68245961081889356083131274825*%i
2.26538038635116691414901350703+1.85605764746423605192896021479*%i
1.04534150503868672637394681873-.493727340273362579423688838070*%i
.109672632572650600854535055745-.327420793560068970560023524775*%i
-.209972357264499257268115863826e-1-.926976541387713917115704941142e-1*%i
-.146369064256839996687035629153e-1-.217155800484402248363291736157e-1*%i
-.568662693397211007957110268994-2.02419152138454009877523217931*%i
.569313218832631365658164353301-.388540640210363027892990434131*%i
2.24835382749801181029897126587-1.28250643675961125386914906840*%i
-3.99844476276562329386582605815-10.7244912474412521471530950982*%i
-14.0868175735337424626760355259+22.3080706309611390754845083623*%i
14.4872445389666751850360499011-2.95072584596041296572029313302*%i
-.693333605340222344157399296843-3.34529564913381236905880135192*%i
-.604096563483165807460459763893-.309381811175712952510971204181*%i
-.145724208670521066012983635327+.599100830248540755542805873444e-2*%i
-.325477806587435587514461586049e-1+.120957305109833658797939252896e-1*%i
-1.70509570653107289068076342234+.390495306441051608054612382735*%i
-.662858644961664788659052144321+.707276544233690979155163752697*%i
.741799374025404400585891570942+6.51179000447883185343679035486*%i
93.4309633629615099511943094942+8.16992186605647150559629250896*%i
-810.223545887064464848619270437+671.573126441407857566143315548*%i
-86.5155935722807165516300671760-146.993051131457461353958025708*%i
-8.47485139747744013430649042164+6.40820596331893853601958576913*%i
-.321965536860036789717894698597+1.15847080935521696148509654045*%i
.904446408724350339143038174980e-2+.200964486152606752720865319070*%i
.932355198934789623453791463249e-2+.412560961816714530554333402424e-1*%i
-.375158449644290729341125768828-1.39570065224899838714742989487*%i
-.939515880211650183119630043432+.146028154006014801493129525006*%i
-9.15043462710342151903720380147+3.38856850883274612833383147100*%i
-329.226743953005884938777233194+47.7608934247030674559317761238*%i
14880296.7583969530533844542047+4854493.91094069915718259227775*%i
797.134793238621995841028822024-529.095947525791600982177512287*%i
16.4121881372939581737441886842-4.98277641818398995087220049743*%i
1.43946159246261431988587595595-.306542416223637342857047436450*%i
.220178792622452188410235193991-.381635391097265846395892955445e-1*%i
.444850465441198785689828211763e-1-.676191634767069808938626609653e-2*%i
-1.75030404245455929665859537533+.903527774187558318677801744715e-1*%i
-.359577141862329561139671064158-.599692014692466217455973376572*%i
2.96730023657747188416105947031-4.61979131219429155686213551852*%i
53.7965544501384687849279466334+26.5159729270161642075969270708*%i
-267.766212968576224008609674770-274.939175837565339493322133736*%i
.840315792444667564161826967723+98.3395505099519651481635509913*%i
-8.52303909444106130010947805356-1.50326022787207392258317510145*%i
-.666380341762061182709856621104-.868908578887610314639076944327*%i
-.534572220485696528175667960296e-1-.183713129295368137587289212954*%i
-.295423778216968992023396669517e-2-.409417383204063723261178206910e-1*%i
.164331428205042072439259508314e-1+2.32063635803499998578325414280*%i
.708954260665322791482213138352+.552802178075778165484606917254*%i
1.49580060477373669740754666178+1.51893821999085789707884291156*%i
-4.59590221516311083807945017031+6.57557679027657215655567021048*%i
-8.42573190726104324641958265067-14.2374414878955513232653135779*%i
10.0618022795908484642092935000-.207127866558992931444516518425*%i
.283585664433500176453044898204+2.69191717398494768745357930839*%i
-.420298543470615087984467258522+.419012193944528079830766446041*%i
-.130281233364053426798073156341+.335395651612512262481319609965e-1*%i
-.328739935537146294253420197809e-1-.264072145117733644992052870203e-2*%i
3.35551843132907483330178773991+1.33297407219004007958445754932*%i
1.17496365083025580829131679164+.717358495450088204097444249941e-1*%i
-.149526562187743679297782248708+.349808787447052966016112953418*%i
-2.06257231476137309555767320308-.877153349324512175408230646138e-1*%i
-1.39582252917457316529840424962-2.86651427154909501767900521383*%i
1.56636597613489406980685219340-1.67796298919200725260995906837*%i
.934288142186763979849286039368+.213616298492499807874084540321*%i
.164084104674159313818437351559+.254735354749238606851099823183*%i
.288934461309765945776210531188e-2+.868941022178165583100684706352e-1*%i
-.820788522954318058850381478488e-2+.232151272158941643454205779526e-1*%i
4.02677881059195861568829043451-3.38134195620064031740489148603*%i
.726830680592818015482510075912-1.76559852243609760981795129734*%i
-.514028408681054980014512415138-.856446434829445900494436497733*%i
-1.03387156082565450492099067736-.779574991366342946680476665881*%i
-.666255354607063706480736525205-1.16427681200230309502787928302*%i
.141069313287669729716243919145-.902665015799641347451896296327*%i
.329928197315065935778728425416-.289788927736043502852484712103*%i
.166316647232026694268777131304-.205704315083624123337681174401e-1*%i
.530723379882381717568375390268e-1+.192648852619234651899998412316e-1*%i
.136891051435959119767825690377e-1+.116892640320108253886236621104e-1*%i
-.638682766603033618255748535356-7.43683525485204018465593247477*%i
-1.37344866116517447818940192888-2.92136802678957631593728033057*%i
-1.29105500444294971637472288136-1.19639694194484310000700131596*%i
-1.03593460140528146510069892853-.678285028574111110570148839909*%i
-.640827277230989402802761845413-.594561631882697393233398244759*%i
-.221312491522547145015497490629-.469979928697235988857896590742*%i
.434930692285582159858166748264e-2-.252520162760723814785167089667*%i
.461966617174054208074492009646e-1-.934668327964229590793844899958e-1*%i
.287909148189356880729501889194e-1-.256186462959997060363633827567e-1*%i
.122427556339116564735509798971e-1-.531799089337305626690054506903e-2*%i
.587053501096342198179527116896e-9-40589023.2414170540616949561060*%i
.908296204569028395149621767514e-9-26750862.3881126099663400513936*%i
.140658361711133725929254956573e-8-17621089.9670397678711043617137*%i
.218029222574761386912766046992e-8-11600473.0685960073682895349842*%i
.338298218821856505959454649080e-8-7632152.40652589788897836354456*%i
.525469400344862912146527953608e-8-5017938.31649495877590545588036*%i
.817122297964825200738825207711e-8-3296757.22993660236196233601563*%i
.127218537743159995134828195768e-7-2164242.89541562517830709888004*%i
.198322567832922426805481830590e-7-1419559.96474427825014198574150*%i
.309592340895328863656331593666e-7-930247.426992611194449378728048*%i
.484000910915218275561774538983e-7-608982.832333950154922645067395*%i
.757854266655478483365092653391e-7-398230.394071391502714282017137*%i
.118866376727840012568445199628e-6-260101.613788546979641804772244*%i
.186776233517081065408152791385e-6-169661.158018279619482970382091*%i
.294059240462275160444266056689e-6-110509.140643988359401102236691*%i
.463945285711000881556791535376e-6-71866.9779223136047971332270210*%i
.733657199921586421154874779979e-6-46655.9812201966398026906604955*%i
.116305071734101439518456467551e-5-30231.1415696390078282833125102*%i
.184874867458794246735247376564e-5-19547.1430073727939494402654222*%i
.294738766910409856818787960073e-5-12609.3835558983305072440327177*%i
.471407861126314398037229455608e-5-8112.83357016766355404443301825*%i
.756645432706547451725067807947e-5-5204.62374284588629948030670002*%i
.121920995016546069745694831266e-4-3328.08742467605009699332288252*%i
.197301973602350119445867064773e-4-2120.39287625877861988957368655*%i
.320814161104250482054861741862e-4-1345.40932359091362833330639692*%i
.524418596105209015157010452275e-4-849.721322626191092491952431741*%i
.862334052908520292508980006975e-4-533.839362208460877467428095787*%i
.142745118159795664436706850306e-3-333.377842663208357420060888475*%i
.238070386899949164598646657296e-3-206.764675649127848739215555477*%i
.400447168680814118316497432201e-3-127.226712710851917493628963607*%i
.680145029286221933243753034867e-3-77.5711777565233041574222395804*%i
.116815209542611640970509061783e-2-46.7932067828781013158998690551*%i
.203233887047672271115096533470e-2-27.8744344152760603698632287456*%i
.358937219705030736038788939057e-2-16.3572343615670131952586198237*%i
.645228515728184863412533464940e-2-9.42316859280659553736804873624*%i
.118445662805085953295845283202e-1-5.29835356399181358454421075916*%i
.222979036204062411940284680516e-1-2.86975764114260504992135944817*%i
.432825719719644809687626096324e-1-1.43573350108079611661325587341*%i
.872538471146900862841948259741e-1-.537518577573800511541425203305*%i
.184453271575199401363703435400+.173210346834178364199327765328*%i
.414435215997729453683406290191+1.09413317031461827507685457962*%i
1.00897520904271448264534460474+3.02850273124589956338083868171*%i
2.73994921736013727647887943300+8.40361103024324571684861392203*%i
8.69086782232145104946933272450+26.7383397593763824849855384041*%i
34.8642030283086281259634270433+107.298589913861310001983880204*%i
206.502443406282967437529453451+635.548759387990185576984708645*%i
2611.19831066970611816836820665+8036.44202014001696660071519361*%i
270845.151634016035087564721593+833575.664307426841167950697876*%i
1071628944.78175282800375628393
71428.5698539418350513234046663
2420.67081198225762953277185797
287.190956412477036804367540272
59.1255300088004659896441367340
16.5551754854900790143811896128
5.62843036734157352418924150266
2.18411052134957911090609932158
.931972541667870461342559588786
.426882047178801716904685724780
.206476262498504535377878878758
.104244384252702866201119284038
.544725699771445964892490805379e-1
.292746091261773991653354499213e-1
.161021774165331160986557320089e-1
.903058765129647377878609025085e-2
.514855582594885547001347272596e-2
.297680134003423134120919286477e-2
.174205660567816287584958662491e-2
.103021375230577051019173551427e-2
.614849446918350744993652454119e-3
.369917384943992055921149590775e-3
.224145036349713671812287156024e-3
.136677560988258261195253627834e-3
.838135909543610095775128651620e-4
.516568040413155916803566122764e-4
.319828727985165492953791309577e-4
.198835484538762611060788746957e-4
.124076777960906319185643528163e-4
.776893333992778102710256368919e-5
.487952962575394680092426128553e-5
.307345186106797105631825174271e-5
.194091137565260036887435468412e-5
.122864312707003273482153263813e-5
.779481859153950659409559816907e-6
.495534856296319444868534577301e-6
.315620582054791457267128647345e-6
.201382003070969159867718682009e-6
.128702544720507372656804029485e-6
.823790132409764515824201396299e-7
.528038044127567557128766888071e-7
.338916801227473248267646996121e-7
.217802958550774254554212782209e-7
.140134110164057199288824838536e-7
.902615392163956438924195656774e-8
.581985626670496582336654350630e-8
.375618107967443751464489415683e-8
.242650740415687846360058847938e-8
.156890077273207036638029907821e-8
.101523750328088535099449307352e-8
.657474939942245284997169156329e-9
.426100993081368856741505565678e-9
2.71272839831876768845417923324+2.34817077865199628789547007547*%i
.450631258786350874163376651154+1.03387158244641894851818275665*%i
-.441133146900814150671550003708-.320282161642534434256353375308e-1*%i
-1.47475710621483729238661500248-.318489996990910754966523791828*%i
-1.71911554377059021478649500772+.912937690108483611407679791366*%i
-.262379639755452693799106980729+1.40096281201108260590901075697*%i
.428844135601808244129652789606+.533644528264544698731123012434*%i
.248409814405926155550797346884+.453793785518216400481130131994e-1*%i
.760842210835736904218122804419e-1-.292197687200489965335164937105e-1*%i
.178179481792838540304874759529e-1-.174541151481917423954609498546e-1*%i
2.16825658312050156884265069872-.845764012442895012707462024832*%i
1.03787863940648849952215770009+.719787103882512978351915867163e-1*%i
.913824096734063447512012168130-.935744991165474753029485156738*%i
-2.10817686561144325165454127246-3.22790761524031590205346909069*%i
-5.61451604338244896376597299349+2.84501827918194677668184662984*%i
1.83316878297966883607184579818+4.12316924033828306570218529435*%i
1.73193244394210051687017516138-.185436069268798420529879513009*%i
.269156746805419219805760375830-.423354611283928507441988439123*%i
-.555485623466776626253829475422e-2-.132811787130047786214985042146*%i
-.155385984124460137932714348770e-1-.317793139636555143273509644268e-1*%i
-.274317189893465146077128427474-1.27907353987359823084498709012*%i
.277115201907741044862666217459+.440602183783870591504674146016*%i
3.69892506498682812816599131476+1.89063505494218090975719502725*%i
10.0013629088613334451914413937-18.0843629848283500485202158125*%i
-46.6737546717020826604010105763+17.3452353841004442231327770215*%i
26.3131405846143963608354854027+6.15998468986417449375278985934*%i
.430206804353322593625913880980-5.75597694700140884781532094452*%i
-.836801308881509068605760768454-.652229235163162651739434239738*%i
-.213006048204759911352595324609-.199127977787353348191182331023e-1*%i
-.468551075376474128021453608231e-1+.122713092876832109224167315969e-1*%i
-1.24208010747724437350495380486+.330030017831696021503579025782e-1*%i
-1.51157940659358220568723865883-.801921820816603866958143562252e-1*%i
-10.0790289377011652843219190783+6.54477745353875192050410365223*%i
96.0723847448078024979666981875+179.585194597439839582382585811*%i
-2717.89755813093674678456649004+50.4037627454597135875061638242*%i
-86.6163624953348450748880789045-376.428832666268099452775719007*%i
-17.6577604192964227089359460758+9.32314384785868984356291011470*%i
-.723442946105603353753874682410+1.85463044722082747995787982759*%i
-.734536284262484112351964664196e-2+.305243022010985236081861443936*%i
.103283888627992095575313768363e-1+.594107302747279813328537296166e-1*%i
-.120659898729812164547296392755-.686449966631726106347201694383*%i
.136188529992605636914638424293+1.45654894306869100091551603274*%i
.478854522965697105775037693486+18.4318145099558445079808526658*%i
-163.458745629519571428888489387+785.031312537084451680842741341*%i
69089146.1378962982009066515445-50081555.5462654918181020958620*%i
2014.51710931957393786914308147-1466.80509499155925795380512479*%i
31.9847582032286314315479465933-10.3914491490616320905818858331*%i
2.42407452021928886571551084225-.545813109518728647926345812523*%i
.337371875707358867818657277400-.612132334705126079601089501750e-1*%i
.637945301964610655166154294168e-1-.100674774558385480905776973105e-1*%i
-1.27814863464717094688600927098+.234990685055362203653925474405*%i
-1.30892569636912059280383591858-.314099260435935709117140925758*%i
-4.90007380489355176642714143760-8.63981635677252401035763172076*%i
110.228272953446747833312200581-59.7810083796771027678765779554*%i
-905.575395871201883855235724261-120.979930599540486478941477118*%i
73.3648374631558549287907097055+199.644064461526156377908054032*%i
-15.9639942582911676987776899212+.261652671288149494095597778202*%i
-1.25728242383791671953037913081-1.28313690365605424799799394748*%i
-.103527084391031346367034677893-.269699195439026879148876169945*%i
-.772162639629908654924511471897e-2-.578171780917226675857797536960e-1*%i
.192529358967556036702429248385+1.41597865403645838363809854334*%i
.571826301051798521959533299537-.281741393305666134512162849441*%i
3.30976587762687124239645436439-.506518706419562206405367311466*%i
3.33576684523969158221816682459+13.6163137634103205627508805891*%i
-27.6312423002409495113217015118-11.2435373799614448593423777141*%i
15.8550719307713353067063739532-7.91917811048778016493611344685*%i
1.73684213870926017713222306952+4.11650162171679821728897538824*%i
-.504890598573090587872467495574+.762859556060048050545461350257*%i
-.180378856953284166308309050483+.756640677529669216835274057202e-1*%i
-.457208693102990223399515353757e-1+.128963843911117003335667405608e-2*%i
2.53927222799194432602352115057+.387089706410949901000463626006*%i
1.01528747186267233402219541492-.183014194683966907184401673288*%i
.516050277812668905287505676132+.803591054052610137226668432480*%i
-2.03826936081863554905969391620+2.18087623085147141622180372358*%i
-4.16125452295276471720897057609-2.17570121791504972624946391922*%i
.961420207088171454302525534245-3.29446134978032359158883124136*%i
1.40357616148964723072608700368-.162766296230133245709683822456*%i
.317824291785344009332595435833+.295087963628365122054367429277*%i
.264027599513123797398659275718e-1+.117420868639550039322022967525*%i
-.640802360410022218516372903266e-2+.323961925894651501571135013014e-1*%i
2.33971500056667606491304344601-3.10921601683641081860415565416*%i
.186118306784408390655804155500-1.26715832946908062672876917734*%i
-.608692144481731662859049480006-.124336155487056594369732045584*%i
-1.38128729982103572563646621592+.144854578994206743522917701798*%i
-1.47805328986686155757555074846-.757797840191784063922736941237*%i
-.347312956294965620532270543928-1.14684039000126241698788640045*%i
.282183260714445506071548296242-.514462888720392809148297560782*%i
.206215812499247840072360006535-.856757757352115628593983567319e-1*%i
.735518310498920450379324747417e-1+.100647181284574936774134946061e-1*%i
.199705224277899527073107597771e-1+.119223845506031115904309476746e-1*%i
-1.94550764012037952859515059664-5.46672397628725124666996078605*%i
-1.74277473156923911908419038169-1.75205280696199729198082676905*%i
-1.39329185565808227962716916488-.366973854193507557287462871584*%i
-1.20788375729439225549997104112-.518225672722049601818077525115e-1*%i
-.937353467723022882744239875084-.256246147827112863557389425946*%i
-.463839010320975550785162423635-.411456014419255872501932887430*%i
-.970564908835710688384163188186e-1-.296730595989210676765478191106*%i
.242978753193034540667895532486e-1-.128328199146091199857502101774*%i
.281417662764494864232044408718e-1-.392613843250063021087078482078e-1*%i
.137995899416123914477319396286e-1-.926987942795628079036431216389e-2*%i
.212937168605124415430714616356e-8-36010657.1635021214720645348065*%i
.330224854125944081795359167243e-8-23673130.5705043281783507484655*%i
.512622579442754669515654143250e-8-15552458.0238231351854680321209*%i
.796600987350895874312487334188e-8-10210340.3502051095196877439963*%i
.123927201189403946838519638889e-7-6698173.83688447947395796895437*%i
.193021211764358195121644450947e-7-4390587.25486573887890257057578*%i
.301015274285920487642073665174e-7-2875486.62241391001902362152606*%i
.470059167878042394538046781097e-7-1881448.88930784225376892884876*%i
.735081760293979466232814073414e-7-1229794.48269812619423299150427*%i
.115127778851864360364963545219e-6-802961.882295785643389704141783*%i
.180606029150938660641706394042e-6-523647.335234706035259122886081*%i
.283819888637557065210993978133e-6-341050.984376261709756994555179*%i
.446856228119596852492238358024e-6-221812.477282646639889633731263*%i
.704967264779913360837648649727e-6-144039.949249371723699386438506*%i
.111458844164685907389220074231e-5-93378.6892340388439415793055641*%i
.176636455602350763113273490289e-5-60424.1287277582669072355530192*%i
.280640712209534556780498818077e-5-39020.4406660385416529797430195*%i
.447115380584678741780464483077e-5-25142.2685486260379951805548762*%i
.714483939483416594203069967962e-5-16160.2136508490485065933848613*%i
.114548015031026115415984460416e-4-10358.7296451909852163057068118*%i
.184305492940000950921635450942e-4-6619.93054310146416967912422185*%i
.297711455213464369940985779354e-4-4216.38580617059401245592632519*%i
.482981927745591280501042965116e-4-2675.45776443294383142813341763*%i
.787299578260995746801398509323e-4-1690.56576881498180788377659766*%i
.129017130001409327726799176937e-3-1063.20575445952302224313135085*%i
.212672599246914088646984972980e-3-665.108801863684077292102695611*%i
.352884074247202959924938188106e-3-413.574301536169224541892976005*%i
.589872241551809217753339259324e-3-255.412767265231790587624210978*%i
.994256529902293866028857726241e-3-156.508726962310713974353690495*%i
.169175156821037944695745575984e-2-95.0476897767924451140825630281*%i
.290969071035111543505773164358e-2-57.1287431932466261849413654537*%i
.506661520856654607582777110651e-2-33.9281189475518207570498748522*%i
.894917708842401162344638331402e-2-19.8694644048334479365908143545*%i
.160716506930384959086786365760e-1-11.4463891527296375956468435177*%i
.294312061111876415778987452577e-1-6.46681337258466755548994407444*%i
.551569058289875435429028431692e-1-3.56948819766354673051947823440*%i
.106275708769544361161554827842-1.91571460202005095517816654330*%i
.211781911177402706091121465835-.993535010669186721580122587473*%i
.439903019503974533765482467161-.493911342554722071909528781588*%i
.962510556720885491290747194126-.232819893548127847489057604382*%i
2.25090385328742566511496623574-.102521139089086865066504863009*%i
5.74474693296238866040599061775-.412847912908264668899192358563e-1*%i
16.5087743905442114158169879620-.147294817164655423414288296344e-1*%i
56.1345455457875641937470395359-.442851591383184872513312380867e-2*%i
245.989583551609738852929831682-.102966101880665292240507800993e-2*%i
1640.22945893853147935141326747-.156734969001893983921269149249e-3*%i
24709.2965911865883648806685107-.105155093358437131874790911092e-4*%i
3558026.56726243155723796214195-.734725623884451050235640226208e-7*%i
7222711822.33107515436333429783
242711.834619838271816652124405
6489.21736443253953836745682330
665.961411334712942977626905609
123.654012181820383807305309592
31.9893120185620132204631295131
10.2085717612595175676461026205
3.76023478182190318975673182082
1.53573919316858769199521592509
.677609833494269905581809617357
.317323672050919188817868081875
.155749028424268588320635912469
.793875598380483212517353738298e-1
.417334299193622200062760581806e-1
.225071215967290925050434047221e-1
.124012110060600680579132265492e-1
.695812634061631436113935386300e-2
.396515215928271581735149490277e-2
.229000051433594805761965365382e-2
.133799339045429254902092973247e-2
.789731894752077548809907258013e-3
.470306353944006036544502541068e-3
.282298612584727026704549658725e-3
.170640483177089967242015061511e-3
.103794586253975264688505460125e-3
.634900987215496513886543106187e-4
.390331087272552669961954221943e-4
.241070963443097870571659934171e-4
.149505333236713979552570369325e-4
.930692927177300268907397012435e-5
.581368095354257591963861993246e-5
.364304508737355051778041326508e-5
.228946545511629084159787962012e-5
.144264559112503310115207013660e-5
.911279498421413204434200382756e-6
.576938496804761276423478825068e-6
.366033669829578393344964992071e-6
.232680953662539360998617491124e-6
.148180074945160040959752335802e-6
.945266659691205202938882760472e-7
.603956505145344594610676273890e-7
.386455358516772027945467137794e-7
.247625149133069691013332211382e-7
.158874701403823949997691573357e-7
.102057572804765031511540567142e-7
.656349088103732030415664453015e-8
.422566297331391371832701731006e-8
.272331916498007506496775669907e-8
.175679613733982641076110057169e-8
.113433305945512587978504640957e-8
.733052583331385576172119950263e-9
.474116882022906076945709990280e-9
1.52744556380586621237365746764+2.13431025213559597596395241355*%i
.272840059861105987753349787191+.805480724972972360044871875332*%i
.120769949706717235179620502801-.453708591500280343244523834768*%i
-.949830083335039939045721891504-1.63337781093801472762012652957*%i
-2.59189829116432082982908161672-.333856223235585285153854379429*%i
-1.21254145713464278960794357934+1.56779030145346529930750173312*%i
.295423828208755307469113953063+.911394733769746286538623678688*%i
.312921336489512626796031358788+.155434501083262353359742269086*%i
.109361727697329562813188885505-.163134960120824316265543814758e-1*%i
.272759476534168851804149366132e-1-.187432015930173703466507467824e-1*%i
1.50111519417589531315369594312-.164443625815379391658892336028*%i
.737100285143327473099383952403+.630162227015047860917195111697*%i
2.14432709735324391333643292237+.105938277887061361741931228979*%i
1.49909135025602613404623998595-5.95297136557708388922529937054*%i
-9.92137242347050127115518521993-1.75169569872290928270261365514*%i
-.407009162697435983459375261591+7.19341575460187899396117939155*%i
2.62779728642679880696237595464+.635340083837969888872295320009*%i
.545634862463444499980497088137-.511312559442534421170764123687*%i
.277615458352586993467655552906e-1-.188119757720189227638235047588*%i
-.148818145836972912366376769765e-1-.464346961347274176293078085444e-1*%i
-.243027025987843100256432134372-.899897861787279946389386545757*%i
-.814136210088002938982011388081+.615300177650573781704697362096*%i
.685734375675985162031889889054+6.99419291449199754428776698781*%i
37.6617673934110994455766139280-7.93850305377398695743720103654*%i
-93.1191494662673149268405425372-28.3489052928509317714696953028*%i
40.1940419071881746914077474681+31.4873651572404676131952033612*%i
3.52581534797826881188062179503-9.40515708930271870185563432091*%i
-1.11597513544342471757235060153-1.28583517175627590186580637519*%i
-.312614377581844180467039841828-.739371070454502636478179640606e-1*%i
-.681995052975201645051257198063e-1+.104698012312635063695251521385e-1*%i
-.664320021211174919848248485108-.314424665047840570514762486338*%i
-.919817876307288873322926972487-2.09326361562562975456069323950*%i
-19.4526604946537873255399503830-11.4325362348190832557854059483*%i
-218.503604747794676575037717775+400.396626905581849835044849996*%i
-5750.35216345518376820975204297-4415.62064886855644183245824588*%i
72.9935326616729387572308794267-899.509311525102151279783661719*%i
-36.6446433390598183911203326085+12.2263156054795553110363077359*%i
-1.54783906774445520657550030781+3.00921862128204091861219415222*%i
-.451530393675859556757973594046e-1+.472420217862874173583918276529*%i
.105177356914755347870253780114e-1+.872020622718144275884286367952e-1*%i
.266467201547755911579055052671-.503113898688932068770231415352*%i
2.64938481361783876488337322665+.517925807288459328954867417862*%i
34.2213142559582922223984426768+10.7858290051613951446709494068*%i
1693.55850754052427600083303307+1049.54840637915012831880042401*%i
479999.833333437909541160874692-479999700.000104166094573074796*%i
5233.96636740971483040521671138-4171.01410927302382110898289470*%i
64.1216934485914672036808326251-22.2307980628685182493219032764*%i
4.19027612619628112404712945893-.996036231786473171429252080822*%i
.529358906110726287719052748980-.100486708367601495382674027691*%i
.934711280874322616681106663224e-1-.153153960356061024578959926497e-1*%i
-.775908135835957723385256037014+.497067477929308898794444561545*%i
-1.51162577645210265474074698238+1.49607088392585118073919566707*%i
-18.3846118917012775985400213191+.461090212292516205080681224527*%i
32.6202656483444144523840961357-268.480539607154009846084193197*%i
-1935.10877562540515027490618815+1141.07036417713556001122616435*%i
304.900612469844715111145748959+363.864979462853951070816912782*%i
-29.6575817991430687780632120793+6.32145981577935363648104929804*%i
-2.36843177105543774241148868807-1.88311515106854497608958978488*%i
-.195306195259880576271466997336-.401683621187249008242467013778*%i
-.164828944984634667121181030529e-1-.830600813331508719523134739230e-1*%i
.911382023243111115649975062366e-1+.889173483944092126806335760722*%i
-.352484794514340510754940580487-.753311585876353708120955491878*%i
2.35905925953126972807040866736-4.97017963674170561314361726725*%i
22.3265059987039363635883051193+11.8084193635666882562599515236*%i
-53.8673527546252717278728469193+14.5116819346021679929506948697*%i
19.8029266857321083945992457669-25.4880968454836070890605831081*%i
4.89038722819923246236155716366+5.81326228389056405801972512482*%i
-.532304714689276223144283261027+1.34605437674252678136815951636*%i
-.248537501535008392948904094684+.151574240169755625649931466022*%i
-.641295407147277694951586236395e-1+.911206076477018647524434714202e-2*%i
1.73259861587093613462314308792-.203262618398588943607521218052*%i
.779619685967489186567800143358-.608863983995683027320484349473*%i
1.65100355598820355018021287402+.261826538884449873374973479305*%i
.361163280696046940525275670702+4.57612279674918126850108479042*%i
-7.15678050446742426649315630177+1.15181041501960936938711319423*%i
-1.02292146862515119825135005540-5.21970077672436056176428607948*%i
1.91695124103444731757998540819-.964031133660755263716160106728*%i
.562101549598300930543211045953+.299046957302848714410568911151*%i
.690042686270713035519400347889e-1+.155770780646341930867340422153*%i
-.198692903375737219074427890492e-2+.451425092167049799240208700464e-1*%i
1.14059382254483077203052313322-2.61929524764596979920987915117*%i
.186169522682366546338997160106e-1-.878700094034046977727799257071*%i
-.145091687766708170363808468592+.397449475158709202496855968135*%i
-1.00299456912937152693068183874+1.29723297310658849875841602928*%i
-2.14058279350433767213849010483+.281851168509976663186516693339*%i
-1.12361983692300445877462753954-1.17559097798182767783077413218*%i
.110747727576569042398509288099-.798251439205999334094913391363*%i
.237442742089371225570627690808-.190851997771224154376816890636*%i
.992888142949421169189961706357e-1-.862147644995083274454495085920e-2*%i
.286474273932587300870604375804e-1+.108140256707020447946938655999e-1*%i
-2.49952167822898347607596353146-3.62366190858300634815267385684*%i
-1.62430784194847987975345847216-.753695874939776569627103808199*%i
-1.07054853788728805298550790404+.353678329176455293850246204490*%i
-1.02006881792993263276670161645+.645805691885348170235890545481*%i
-1.07716507237265829032334249282+.279885318850955422909467445225*%i
-.727175694556840391772845802367-.220348227171805133654878863014*%i
-.244908789833323913846650223707-.309821644866440492178232839345*%i
-.166879310195224764486072791448e-1-.166177130112941663033502332064*%i
.233214611502666585427745089844e-1-.571069475240012904480787510444e-1*%i
.149189566274784937119482136679e-1-.148651597081096429081607368727e-1*%i
.743215943814612748821958947157e-9-31695040.2882787240093648726713*%i
.115543572446866717356760380336e-8-20779886.5211606763393035328329*%i
.179825024041710389368906077610e-8-13613320.6612184967121042680967*%i
.280192292007926783171290395564e-8-8911073.07006138067886337258499*%i
.437113745454402924559047002858e-8-5827935.32528096201778581018713*%i
.682807154256742664786427665467e-8-3807934.83982085528677518436194*%i
.106807797197011103457482733810e-7-2485552.05074745946896246181616*%i
.167320182129533062559074427720e-7-1620616.22575326442440754361212*%i
.262528781804957293618969583570e-7-1055415.28852484369485580034691*%i
.412605945693331437029479398447e-7-686452.429645083586756274948314*%i
.649643675425238731434656170879e-7-445856.339997931780541974689025*%i
.102483123902087945002110097690e-6-289151.499182515843536471008181*%i
.162005140608003572140594916474e-6-187216.813964490902560004208293*%i
.256668647727431008758436436765e-6-121001.180117291233701461174743*%i
.407624211458713728404418576555e-6-78052.8600655699046557517727380*%i
.649043823047524218313850532178e-6-50241.5694896355411617824441475*%i
.103635406467778596956031282010e-5-32264.4148782325696247718099777*%i
.165984039904751844972634066521e-5-20666.6728639254929238644592769*%i
.266725716354217879033895142332e-5-13200.5079378528750423537840887*%i
.430164406704321445015150076884e-5-8405.35929669990856789877513793*%i
.696501877170174419171114131558e-5-5333.62435467429653301466755938*%i
.113264774169073056350220009787e-4-3371.50468904316688600103897062*%i
.185072246642985516723259321065e-4-2122.12636487567560522158181150*%i
.304002584812581814123146211181e-4-1329.37570908234085464481687857*%i
.502284670527395030822474072315e-4-828.329114455817863584477923710*%i
.835302489407682846658000054355e-4-513.034866158856159021141105762*%i
.139922699941960196778628859387e-3-315.603841922324936485015927909*%i
.236301518849540910406945968917e-3-192.661436902535506553867210646*%i
.402742849478771320321586175578e-3-116.584640969007727762093660084*%i
.693588136890531346712393237609e-3-69.8451408879008955229629839247*%i
.120869553855856785219780914356e-2-41.3653171852259524649823024806*%i
.213514183720528095189516467391e-2-24.1764625312682782300862536021*%i
.383125348462833040698298205957e-2-13.9178996983401468606165002051*%i
.700114977817562111650359635442e-2-7.87809006636950450562771947629*%i
.130701756667590495433150277055e-1-4.38457088401116328031624977854*%i
.250257636212603357776582629447e-1-2.41857205580687592107311410863*%i
.493917044304073292811588851185e-1-1.37583687343954676728883933511*%i
.101128234924001305861760065745-.927386370223120803604912656883*%i
.216624367875307633286055037344-.962924651047723527075071631804*%i
.491000973306563380224234003204-1.64556948058978166993726511525*%i
1.19618833179764768071401990763-3.73815357908949485640505832586*%i
3.20321957920102824798952289999-9.88018514733776764960930945719*%i
9.74956849911316817628379408920-30.0133735699666882730803183170*%i
35.5669727916175249682740673839-109.465923839629343981195921654*%i
170.380358016229073317310898921-524.377255303749668217017951811*%i
1279.72088442103885462562575026-3938.57595648902467576969629061*%i
22977.9131589589428206259252756-70718.7450512495283045772697649*%i
4594561.94469882922599268342654-14140607.6577315202324140814406*%i
50114622679.0459648289402251450
848889.918400871097557834435701
17899.2971642490500578382385929
1588.12492941545873950930786267
265.771838755957486873367751654
63.4760817369727142250825627964
18.9982860877645548692699572284
6.63664362378416167488701934657
2.59203177583264792571316223604
1.10072006003875361888863443869
.498636618082865529001486395491
.237729089225267189803318162794
.118102682279718435789057932917
.606838545042901333226422807852e-1
.320649459501142192169499930862e-1
.173453239715598213111535888738e-1
.957150485962169084660170962368e-2
.537250763445223756421009026435e-2
.306025063629779492931354796563e-2
.176556499097683034509435766711e-2
.103005891177408142958939208790e-2
.606889236084541507294688607103e-3
.360689665728535915456552002765e-3
.216031084980638968489410726440e-3
.130286282280416244842780513676e-3
.790628341998585974330905043520e-4
.482469668619841794676837317136e-4
.295909526105754206409520504973e-4
.182320581070763673496510075191e-4
.112803226320525270724558016844e-4
.700581633903462110538584109184e-5
.436624143334540813413442083132e-5
.272988537593985336679284148296e-5
.171181984094352699349554906751e-5
.107634037916544101102945066449e-5
.678469368563578157784301013316e-6
.428666815076102422918802100919e-6
.271422753202364901331264394150e-6
.172204313146840112565572142189e-6
.109459601039826266334854904903e-6
.696982388529393454736785663924e-7
.444527539185414791868529279200e-7
.283948467692403362016457525260e-7
.181636550293810657116656856698e-7
.116346169078470869603293930405e-7
.746193365170294301842444181013e-8
.479147477668156056055232865177e-8
.308018011807077224784323015306e-8
.198218827320930097416608366637e-8
.127688093744972769816220350212e-8
.823321182016392614389173025132e-9
.531349049077036090564549263058e-9
.650854760745414818694557973853+1.79204114478945825989036114183*%i
.132960814670349174831299104662+.817367041936458462262154743868*%i
.909206025608335832622000854590-.120664237909020767349001073566*%i
.766498101711155098115912755979-2.47926606171281485346312072908*%i
-2.67362132235403575395213044322-2.53043793764976704512800653148*%i
-2.59790576180276722679144355177+1.17711651591435561223156376325*%i
-.858234706659047536645917217703e-1+1.37571182106630831449288093025*%i
.361549372350107665875920443910+.338110443325360714800864305737*%i
.152689250367659902987341839332+.121701568237796588815263822826e-1*%i
.408312806736823271266055144361e-1-.182996518165692816248570538025e-1*%i
.829772433183054731582896258672+.109580306324650154976485438033*%i
-.923767712081075174778122047520e-1+.983801221519278588530978012957*%i
2.02816120811499378308959772177+2.74281861460705175155498314030*%i
8.79408264461185116597085029868-4.97744256359476647779218166577*%i
-11.4435624048325773967221559498-12.2465445284422867840947402253*%i
-6.09232549555536467371826896676+10.2127634858946145757031728459*%i
3.59004393789563672491906281448+2.39716119594104651882293495580*%i
1.00588457456668364160712171385-.541796497301032135136081960871*%i
.931020099127143287085889104810e-1-.262021277050495034564950496437*%i
-.109057888525580482820258778380e-1-.676820056577066422192432172400e-1*%i
-.117810903998910790196376763575-.877909991199964291321103663271*%i
-1.74553159669137371233995492290-.785486954781392194972257850198*%i
-9.63672288975241293923927798938+7.70360290199882903510247496812*%i
58.9143406173514252898502471824+44.5223068526581522302064962938*%i
-114.827676128635145244377414584-159.395719045011089082650389824*%i
44.9503307926322650998057722585+88.7231339144802144948021790090*%i
10.8316672666518040297082375542-14.3411091569731321200645935304*%i
-1.38337251601254284209319809828-2.43612208436816936190990006533*%i
-.458997826787944205255393779840-.180912297573775087425080082122*%i
-.100215332630159878243434828934+.448818503177485413314904606687e-2*%i
.779222096915454374939947258336e-1-.233745170200134464594847488589*%i
2.61053202279660538879358888461-2.71268860914257016908578646363*%i
2.92448916887024991834111807883-43.3951283877961272517878156020*%i
-1047.78807526189689250412702250+85.7865944663095471091801274141*%i
-4786.10202625627842558754807466-19333.4520634574489193107726471*%i
823.462681445618726260883972780-2008.19762215725455855436430431*%i
-75.8587460663234456387113825479+11.9727334102365226778006760688*%i
-3.23319258121001259005160485888+4.93278923549616350775783399076*%i
-.126511434238197333661564344977+.743937563811251359647768680961*%i
.863697737322989741962405924808e-2+.130326654723117379151537187795*%i
.220984308133881989351538304304-.860642521831819205655317913215*%i
2.45863509088060692229312266577-4.10066554070968836364711872469*%i
42.6473430094943870846736605455-57.6051806558821832106494728927*%i
4003.24419042437413498618461677-3147.89330139375428690338881723*%i
-2247235307.95526228231949848562-1635893301.49192374853563922519*%i
13947.5733056632409477173666547-12146.1494814825910637709250185*%i
132.003376590982581613787921495-48.7113817703004214705145593332*%i
7.42506705398951739239002851977-1.86027175011913741705492919325*%i
.849684786236694394870375140787-.168627988283594714334093100100*%i
.139819198511890225416773994275-.237839701633299353531732159976e-1*%i
-.429797115878089170641250643521e-1+.509930857854865339513021711393*%i
1.13363061191277921057063147774+3.24244445850877007996682163433*%i
-15.7325502348041788770091587954+31.1651903618440083250664187569*%i
-443.269753692071976259721160324-404.984195061556283669415624168*%i
-2071.67867995734075100253976926+5300.77169007526605506980843166*%i
943.045375853617744414401732513+548.420569550136783332546145013*%i
-54.3811734140597254269841969219+23.3635542337467420849459936311*%i
-4.46733548999775158063171009037-2.71121648863949985464384290825*%i
-.363801761419426580825859418852-.605577165770998114095962578717*%i
-.324077135998244241311500730563e-1-.121240731785865039194739228132*%i
.237089362355050891657925782495e-1+.785088570055317551677330330711*%i
-1.54704475213986659245960412010+.935090172113226207626873318286e-1*%i
-4.79479610177729973871956001814-8.10605548093559293345422814506*%i
43.9678607256462255678854317623-16.2377458998008813137137475874*%i
-65.9592908641044296647829644027+85.2653907648177689753651123055*%i
12.6518208787141303705806566918-59.2996347415772072765033370478*%i
11.2075711813385762282395816930+7.12905527982061136647307887782*%i
-.382382296819024747220218257832+2.31703232087118648376442811202*%i
-.338110253167686677411265598817+.286377284670330479402108823441*%i
-.905056060590077553513071996888e-1+.239063353323938687901813660387e-1*%i
.965628953736668021674383927132-.429664551981172051970347252350*%i
.126318572374742985003811101711-.991123015881799750288707087143*%i
2.04070176311828736351258813716-1.73683064514707877646737636013*%i
5.69293885086342586473837375682+4.63419681807953188738250663207*%i
-8.09710330236091649966933415551+8.38398368985724286375013359176*%i
-5.35184668632506044453795789881-6.63670931591920512617669524079*%i
2.27470630549225310858258224018-2.46217761660911045120269757375*%i
.934596196864018438715471472793+.210559663077596078559047036347*%i
.143201030390689554702981988652+.200629032712702954089958949496*%i
.713904383828397210401253578687e-2+.626461282900072580334521003841e-1*%i
.317649664165845078212142270778-2.07138257439900204098301977151*%i
-.291436964231939925938616298530e-1-.756850549995769963041538187950*%i
.610390542082511888141125724449+.283063925076764077407910196781*%i
.351821813721443036482468783152+2.10804216123023175916190197218*%i
-2.14789540787796867639072887556+2.01510294823428083988393903941*%i
-2.16457884376430096208265514753-.725938588703538922986896021771*%i
-.269536554908952498578619927743-1.10503380862067355970536580742*%i
.239936320472569031997638154103-.351257967474842191940984898804*%i
.129698441895749907443759901756-.427952808842445220151903541507e-1*%i
.404346384825993772215439790064e-1+.717481839716847414383004181973e-2*%i
-2.49490499667830687892782536899-2.12245720385270475466652039104*%i
-1.19911299545591045511886856876-.120352512366291818747437643998*%i
-.425324883638017732404024662475+.720060341669476097061473504226*%i
-.403589640331222726480470184007+1.19103389942111480331141205526*%i
-.909780805000422424528553812728+.957889038841836710399044862696*%i
-.945585706553790057848923107789+.153307008468999920595885659661*%i
-.441072203351377456244636252043-.259271519855051514965968187764*%i
-.851998004557246473094490402064e-1-.200733271097430244659260703113*%i
.113519578164686269535358746373e-1-.794528338120707308051162824231e-1*%i
.149954084844262076128103358831e-1-.226211658285440252734903200797e-1*%i
-.221451655360296091080792759482e-8-27676559.8235971675063461855412*%i
-.345179672726461782006181589002e-8-18093572.9399937680572800934637*%i
-.538680512653762784659164613875e-8-11818258.7719147129847987159615*%i
-.841720857063416579065247144047e-8-7712093.73158974688319020424142*%i
-.131701058246498498939165220926e-7-5027487.06834947911412773683404*%i
-.206362712297547812031340578692e-7-3273835.95162128438381709301552*%i
-.323842302633464162544771035839e-7-2129386.40246333828316440441861*%i
-.509025386915422350360834737711e-7-1383262.16821992968835844445916*%i
-.801485864556420476140325508384e-7-897354.274658258686122457278787*%i
-.126431207525293109798495557465e-6-581279.979405443909195832944507*%i
-.199834764381875945630512463730e-6-375938.182751319745239418412796*%i
-.316524985953732085544905827518e-6-242716.466612482342377589274477*%i
-.502496711208563733940862197813e-6-156411.818149953293266494310166*%i
-.799690260452622610946116353569e-6-100590.286817165636996890610983*%i
-.127601794863082884340353613670e-5-64547.4644605924470083787301125*%i
-.204188004014666995195584178500e-5-41319.0370075188818004978196615*%i
-.327751360031261700964856366901e-5-26379.6857156740925716046416469*%i
-.527853963367778988295243353624e-5-16792.9033011951387212311954228*%i
-.853229364861585831630859038603e-5-10655.9681138458686763047333612*%i
-.138466230856892266343912400527e-4-6737.96683864937477822344616759*%i
-.225688521157588693516246366435e-4-4243.97244259139427010722841560*%i
-.369611196210512990083764951506e-4-2661.58734739548270483612987605*%i
-.608496345770303307723662047796e-4-1661.20863058002491385535458858*%i
-.100759071575155032270599884830e-3-1031.29564184728564882961345029*%i
-.167916744022540099489748974080e-3-636.417138572982381220606061129*%i
-.281837342476905322313499136153e-3-390.104907970243684196768562188*%i
-.476823262638330127509496253283e-3-237.318555606479634652876381702*%i
-.813933670847181507763638971485e-3-143.139999573460672443630818307*%i
-.140340406746687613311782539276e-2-85.4995097422027856669396593894*%i
-.244745709310226845467206705030e-2-50.5062639984215433046378103130*%i
-.432384421956604834987904931293e-2-29.4583567824059645544228782114*%i
-.775292337715400490980345861454e-2-16.9335514684577526253729585535*%i
-.141412615543201628028752042919e-1-9.57398780747262390824966045541*%i
-.263111639244671909044724045916e-1-5.31551137776158617921017906086*%i
-.501073780320001108767660993170e-1-2.90141930493400213817904033307*%i
-.980887391850393859303516836814e-1-1.57839950354916140435308730432*%i
-.198439204343831999653268342842-.910903616473843546087075744296*%i
-.417761838749850837031661184748-.678067485350940630053116107644*%i
-.923544514924706274615560301485-.845056274881321422191814012704*%i
-2.17015960737307420107516640838-1.65271922854775336947889233702*%i
-5.51197852394439441672826405027-4.03534418757271617681870353338*%i
-15.4987059087728729912244942134-11.2716181119093809998660487940*%i
-49.9992709123722156232881200228-36.3301229807749466184407905926*%i
-195.823178926836691875018780378-142.274783832326234559081584330*%i
-1026.08385903403576498636763125-745.493738379671052434597699628*%i
-8685.64236646216173043129292853-6310.48858349402318509371263230*%i
-185950.011936093701620702632994-135100.591755675699995966868076*%i
-51642563.3671366446973977921115-37520518.5414365034641263733530*%i
357260759980.632836317995583408
3050108.66153773853746131713749
50706.0495276677486990744609310
3887.89930149519512855702933364
586.094888937891291261441860649
129.150988542640261076083910790
36.2278517288822635540272467538
11.9933169333869194103534167517
4.47599640382363469039273551873
1.82796285674289565297930723899
.800439589711961543921585370710
.370405850123108919327578326936
.179221686318567308142506417033
.899459477876333573078925000863e-1
.465337792403819085100555918110e-1
.246972438374583239320050755035e-1
.133951998222116087217757961261e-1
.740152688511060900495875004650e-2
.415588973657815792019863643919e-2
.236629905568005087568521607626e-2
.136390085165027743389204445403e-2
.794638504058394046503286046724e-3
.467405665026286575481800612288e-3
.277267786997669503137157435026e-3
.165727561194049754697130137417e-3
.997338811337942275036812997670e-4
.603880607408124698499458967431e-4
.367675958199910186063361317375e-4
.224989552089934939568677760811e-4
.138307769186864697919702489817e-4
.853778150094588795505179459646e-5
.529059551530141329613961961591e-5
.328994729792232029038007335793e-5
.205246919582722960291809047634e-5
.128427754540608912697798312273e-5
.805819892979493179983822714317e-6
.506904298216263972544615271967e-6
.319626982615598701359785340233e-6
.201984697091044947873702576416e-6
.127904498345789726389053039162e-6
.811495526924681097098103908139e-7
.515780932887574937564545732898e-7
.328377831337801510804974687109e-7
.209395092566313723473558655966e-7
.133721659922313312663912643333e-7
.855148304627534513972965203139e-8
.547583551458955975205969719982e-8
.351072012058461165678754562212e-8
.225345522511756966989397758196e-8
.144804099313455354844916885580e-8
.931464473026531830123521146966e-9
.599765404319688518687115949973e-9
.817392482123615667176084202721e-2+1.33924521924153908565554644214*%i
-.262770816682217422752395162022+.893742403170012169142177775549*%i
1.13318387410191273656946469106+1.09250564886056283100117230529*%i
3.39410170869510102156417975423-1.70394857458308701774420707816*%i
-.949329523018102712352664087619-5.33170948807464943307363064847*%i
-4.23022484352825873375374254172-.305794986568759891521573270883*%i
-.883129149792341897723641134886+1.83582310929377906139186808074*%i
.355832630008395232737198909196+.623331124712015525463945902996*%i
.205908114168958128837494664821+.671633270394639861629807775391e-1*%i
.599497782148807640932255702950e-1-.142596486927098533168386678378e-1*%i
.371002404745179910919081712529-.189638410931185356390194939745e-1*%i
-1.21487251408814293049630580117+.419607357914230701267930619767*%i
-1.46439834301679332810674935156+5.30566477645103686001435732029*%i
16.4299457828717831589436030263+4.81945645492083927966168246044*%i
-3.08235570737278561891542111801-28.6820411442438542136299465739*%i
-17.2886391854367533134687801103+10.5236991711972031320693088349*%i
4.13915195162589562540996854674+5.74536582352884664005949821804*%i
1.74113889705665192502695132277-.405648980214739553702671189975*%i
.214335886743170709762127832264-.355826829482160234561826985762*%i
-.405798175601121840360007218286e-3-.982593661808219984753004736319e-1*%i
.379899292662383693015265994358-.823908379596885595647967417948*%i
-.384847183799394443173107041178-3.25308237215569340270822153374*%i
-21.1793890025609501839192078058-6.86687386702848955439417331361*%i
10.3554753906012483251474311315+145.319220346256084102216859277*%i
10.7952434051626565776517973325-408.090868685487287645138242211*%i
5.87714161393135425519723013486+199.224605857361371347056779444*%i
26.6289244310862269568643458236-19.5101663100296790967903449321*%i
-1.45972111672085494211408718024-4.48988619294316760996596202768*%i
-.671091794653577142700684913703-.386327363486964038421590657385*%i
-.148431640113205168566148370905-.984151606894456863477333341986e-2*%i
.368118691530683268055988142082+.545954160133865009696194536001*%i
6.14363476872294134766491231535+2.36131891422979683943114369070*%i
79.2835974692363717728468243806-33.3295361498521738469440978767*%i
-1533.61330077233111122762335472-1960.16869953952039613941966399*%i
23470.1363133862452941728621750-51108.7407328134439597417817784*%i
3447.33233997585521225019560679-4108.35390383263566167607824879*%i
-156.629486237013947675020316689-1.62666655586449309904355218284*%i
-6.67644931000773678441260534194+8.13901863447146416495249399113*%i
-.295443831454999995555429448541+1.19029355905803541239604512557*%i
.212599876337827906223272821307e-2+.198135630365083637395900554868*%i
-.685573242042026729345210787577-.903845027762520812441085591915*%i
-5.43216168032721667620717313468-6.48747492733671660638244532161*%i
-83.0624847772865568770947705027-121.032528988828828590743448258*%i
-4161.54968650895305970360284474-12702.0422422862434183899669733*%i
-15733008621.3222650806308358510+5096973761.70506944917005055425*%i
38041.8929626699959407622860700-36169.4979866305145993035213018*%i
278.608762550612659068095862384-109.170307281405880518661818977*%i
13.4702233417029187656220940702-3.55143708311701044467471773168*%i
1.39384156721166480808217193461-.288963700403072656567819981681*%i
.213369736202775643959578890893-.376710231870661035265097962034e-1*%i
.500726603479272025701342189935-.174847644157721456510944232547*%i
5.86034905293161808197049286455+.500934755231897664922759035482*%i
38.8983999250080746064413770691+55.7280000300195950620009457772*%i
-1339.32329592068271069173173520+285.312692652738709560306976685*%i
4277.66348010060872410512043698+14192.6745604962869899255197965*%i
2534.86417239823588072271511984+458.912533229133505584991924180*%i
-97.6073302226042728300001731857+67.2558934000999624323374297763*%i
-8.44980661897224374026722248203-3.74451342741635281754660334350*%i
-.674171976508910424288079860953-.921812919387496296068666919663*%i
-.612018669669130291725306845827e-1-.179597367839324411298390394594*%i
.326255382914900711633716832714+.818746537893299908760244402561*%i
-1.23047166042852739191252298598+2.41993051122852957316620245460*%i
-16.5928248255259544822884117629-1.07724422745928999833492994261*%i
33.1434975531020723974394443516-83.0898914500777651619852593828*%i
-2.03826068521130102778369931704+214.600722623890522195491300442*%i
-28.1627078539514091319201267380-113.791855273301642100597246230*%i
23.0578144293385737461175190971+6.07939231670435426669046637594*%i
.209480435289831921448994559642+3.89653441152579235585554649998*%i
-.448629488459942631795558403539+.523170619667706316087574872354*%i
-.128175864370948089335768154781+.510615000538348234551606168675e-1*%i
.390252525166579342916200512736-.277330498210032248465908452565*%i
-.920329001057922257412475813269-.721932248121880107460512115318*%i
-.878057207762275318209272501951e-1-4.26621630941868231913516878493*%i
12.0269781380192883413291567869-1.36905963214388166306254833535*%i
-2.40930948962812875403919213752+19.2696934151602661111799306664*%i
-12.9785724843845057953878332587-5.50906212494639213932803044746*%i
1.99512987855236901655232394808-4.99674339021433704466913988111*%i
1.47413206829711904262118246704-.776310771127497284536749928079e-1*%i
.268585743649183207873752417648+.246077913317806407855696430253*%i
.244855312987440973469972209908e-1+.862739124077429135217475440628e-1*%i
-.245612407232774680476385300626-1.50062371363827631000583995530*%i
-.262110955709522257616735805574-.797155416041686063642069803454*%i
1.01608117130624619916380202615-.645393852990220561825096250625*%i
2.49069089783316716134540470555+1.68575160386146109372307581336*%i
-.771070366367829378397861409858+4.13065993160517479072582565444*%i
-3.26294205024094675396297852450+.570018072787124248835138338947*%i
-.968170226878136574948488317781-1.33463327994798977455356590385*%i
.176642062445435834765204670453-.581525755023986744595991477706*%i
.161881807941956970867749187008-.101359099972966158037746582293*%i
.560822992183821193575165820309e-1-.963010972525850024655941449195e-3*%i
-2.18333584407469422236655622238-1.04130169977432065283722584699*%i
-.741712116364359619923894882413+.955744682775634713748148274775e-1*%i
.268437846730772450106540717091+.558828601408197720011258259829*%i
.563795604048677749431525619884+1.27971467356738793409704788378*%i
-.281290017814767280300736854418+1.60833839154041639821927940947*%i
-1.00086151388529722912642919824+.738991072800006093543587664663*%i
-.671984671270164737256889449493-.982496055592127579510546449219e-1*%i
-.190759614453818232182919349760-.219452734985320314447206983451*%i
-.121695555279346827028972870447e-1-.105703141803431622114633794195*%i
.130114591459901461411788925838e-1-.331091002416409172085422086409e-1*%i
-.253954905191755400170636021697e-8-23978229.7242268504416107969609*%i
-.396935887084850744485137639530e-8-15628751.5311779501311334679847*%i
-.621229917775932270491964437443e-8-10176394.6275907880311132863939*%i
-.973613440199825319476965413005e-8-6619046.07184859587132641687750*%i
-.152812803396847039537833316976e-7-4300265.07979996444349725868879*%i
-.240221468780122707818028262159e-7-2790338.35039386091871961090718*%i
-.378256288313127645778270484937e-7-1808174.48961856936360990374874*%i
-.596664199377416370039039148653e-7-1170042.93720314096273809429274*%i
-.942963321223254492648557148570e-7-755950.061247029765725920928234*%i
-.149326510834954878561991488536e-6-487597.283448080463257173259039*%i
-.236983439004481534965397316522e-6-313940.894221942695015858887786*%i
-.376969077037568153399604721190e-6-201738.317066555438668528431880*%i
-.601138533605564980776458287543e-6-129363.363177812134576438227456*%i
-.961184229598013231333907779194e-6-82763.1966760220467543282239216*%i
-.154131964093523883286145364950e-5-52817.5179052141453857699336226*%i
-.247932475798926220637724186143e-5-33615.1476517676718420356055755*%i
-.400166372075692555137597832192e-5-21330.3627451086740363414728444*%i
-.648244592022301496892821728803e-5-13491.0003175763571913446269467*%i
-.105430862255049064807756237552e-4-8502.25008176800161586662326842*%i
-.172219983771759834395817011595e-4-5337.16635033077752713755758496*%i
-.282658664395549549506274557089e-4-3335.78033033790949042341973501*%i
-.466340284461432597704995296879e-4-2074.87842868909678257184539417*%i
-.773804119001234014146961885234e-4-1283.71002671674058275096822352*%i
-.129212214067288179540653191577e-3-789.510296529696515740629830781*%i
-.217277370251984098518026290291e-3-482.351624629391472249566108740*%i
-.368215230258682603584630373161e-3-292.507427744042526490162877983*%i
-.629442088528527633324608864506e-3-175.903260821769822917653049730*%i
-.108650129455043359104847941088e-2-104.786252014844229698953711696*%i
-.189607460078956328086453575047e-2-61.7554727693660937731939025516*%i
-.335007995672327231629422130166e-2-35.9526181936361931545664147746*%i
-.600300605389004759645885132425e-2-20.6382092938577431473891085322*%i
-.109314855917169712526932224154e-1-11.6542241979444915527551132779*%i
-.202791673953151133949744289356e-1-6.45224769651056745752015912863*%i
-.384393118045682747790941592975e-1-3.48111615118423256226987447607*%i
-.747217494755626921804275853434e-1-1.80177770581819301405270060507*%i
-.149639343909170455560106095948-.843790993655892319985619429367*%i
-.310508827439319142245032227907-.245858860919371254826876987440*%i
-.672578819509866450207371057496+.265292086458634529430005855015*%i
-1.53552243373013599791766471634+1.01532381343586195293168225590*%i
-3.74317492902977952057296385092+2.67744966059697260459871620452*%i
-9.91844202053131450929338333247+7.18991715432227486162683424433*%i
-29.3030883472593695131314489184+21.2843260344170117592985596689*%i
-100.257862588460494015777409730+72.8399299881902228448124228772*%i
-421.797067638958792963065730213+306.453104302244101770575279950*%i
-2418.71277861158964098227124232+1757.29762538071494567782970935*%i
-23083.6143167952389316388197341+16771.2274936748173837955125746*%i
-589422.664072476255324320002925+428240.632418573612035487162604*%i
-227400806.919253910368815550604+165216357.129573696916293100064*%i
2612274409359.07850418916198751
11239550.3168701176083970827295
147283.187076382975398410258822
9755.81185347298323165898322183
1324.18843192851016603046249986
269.077990082252657382705527754
70.6980371799866186480635478387
22.1662628760022115450865631711
7.89980175362931107013976619886
3.10059042215134508643012368053
1.31150045799205167640033421963
.588682105435927063727826664507
.277234047425203910543530419723
.135812775940195193731271684367
.687529047519360657087632966887e-1
.357802692778213879699756387545e-1
.190634542525940623658038580257e-1
.103636767301309853700470902130e-1
.573316637412913240553559367573e-2
.322006446547684246756077841220e-2
.183277028750076609802456464170e-2
.105545419763829406219597157509e-2
.614155327407668131648456121713e-3
.360686390880137424876265690540e-3
.213584411014285116326529439268e-3
.127418178590376026818685119831e-3
.765239891058794397448554910102e-4
.462371684616956976500566199989e-4
.280911631962624061124022808047e-4
.171521956375705049040565562305e-4
.105208976046190650550341526040e-4
.648040109365862666777652637396e-5
.400699104516905331389833435747e-5
.248639181988447728155007828259e-5
.154787773687050038362713949273e-5
.966524567169252465949722015264e-6
.605204509621462431462481280801e-6
.379942247177893805236086821887e-6
.239100537324665950944074671088e-6
.150806361773405278140147455758e-6
.953169117631557838174479129971e-7
.603631949153426532713025471609e-7
.382976650109838338494028144372e-7
.243400029633989695253313368503e-7
.154942917737862616214043802126e-7
.987833612678164687840924424600e-8
.630693476651573074350362613963e-8
.403217931527247324628297663480e-8
.258116331909660910733847998993e-8
.165430247047008134008029819253e-8
.106147555565532788893494936696e-8
.681827639482219150228319011097e-9
-.364005324240196166488501005506+.760076605449862547317585072126*%i
-.923156778500495568474832349326+.593318268860212204369381688998*%i
-.128545454145063826902444408043+2.50898147850121555090262626425*%i
5.50135029187245860807300313096+1.83152279551891690847993162626*%i
3.70041373680584675469159012959-7.40437699298938524576936293029*%i
-5.44977185096084095621977133198-3.55213620248996597858863068421*%i
-2.30730454139027204403302740512+2.05559980907940044473682657075*%i
.222348483612179426130336912664+1.04098536983487350703671363150*%i
.265000082768528321232080783223+.165547742342631140883038322835*%i
.863536929505755696840060865640e-1-.338702555186498756414375946430e-2*%i
.386349285573262123978375879518-.298351796349522754059767975166*%i
-1.46511503100721320214794282210-1.40833037396606035303305764126*%i
-8.44370615600345020654503845650+3.46563810074582356448630870288*%i
14.0333724163587242530184419362+26.3003782785444474285916428628*%i
26.1874733843154639758144239026-43.9737213103802259862298391386*%i
-35.3842734785556070431591771855+2.02223122274809224670487652509*%i
3.07994367659480856420913037303+11.5113358033499358117175922631*%i
2.85977131524540606541739993796+.119343330783518412393391551615*%i
.430929739149931374225127731317-.464341332368143456463403820336*%i
.223329417527830015137153762940e-1-.141758046247694299313343761095*%i
.961647349907760936540401458490-.136331873135535708057878766698*%i
4.44460444752231462962038658920-3.31275163939106589270072107924*%i
-11.1108443240476640503175582301-39.6376148455690943637744336884*%i
-207.372766600652737451889400954+209.859346650482559688647458239*%i
545.995397540921565578357405093-679.378988682604074696896463005*%i
-164.079112733981349362023716643+375.840518737523479283851734846*%i
58.6409110170215491539655764186-20.6060255573281715096299497169*%i
-.885382983568753069458844458842-8.09166387076230958952104414808*%i
-.970826181514682168697310048824-.773056179180559501312738215461*%i
-.221211297113155418993263468142-.403050520722710189032399413417e-1*%i
-.635611207944991415855575917860+1.24004534478378390408513661767*%i
.539296275391446459092416274800+11.7924594342650081695268405207*%i
132.518891801609748244536455061+113.062025112864473393507525114*%i
1922.85584955552202670642418236-5727.93753786838638375616534863*%i
145477.626145186757972733966768-73387.5730624731101044598002010*%i
11493.9158454217837151798826184-7254.30256140287676987089756277*%i
-322.103682420830803737162147394-58.1128027450365247912748775878*%i
-13.7232803829098009167417612691+13.4558484444436248919389379685*%i
-.639548015287833377249605838786+1.93228426527063167735711414148*%i
-.141355125127870468390503853126e-1+.306132880887142984642032628172*%i
-1.45770475217821133860989623095+.527500422766253025133884833782*%i
-14.2877717047611584494850945581+5.57273185957346322664894674303*%i
-296.774616609341392226862532659+81.9166403833094349749041868352*%i
-35945.9949870920790068856952406-1194.66962583815253456926908176*%i
-31264932963.4479984687139208278+95960182318.7583961743812013464*%i
105995.358074467095590312452623-110002.036317593574634985121100*%i
602.024807784538931411107548658-249.945744135718123939606105392*%i
24.9898577494937050027409163398-6.92260699531505205507886794886*%i
2.33465148785167723269950833635-.505154039094198652149787848337*%i
.331947032099917280722060719836-.608052695693525555921781036572e-1*%i
-.104129493292444357120415280086-1.18961438310232627065144214059*%i
5.14092710688134366122002699746-9.08231166889590254285888875530*%i
134.639115287307593031032494652-15.4195249415528708402625679758*%i
-1281.82351596975358030737927058+2935.46646211102858139157950308*%i
32410.3531577666561440825728663+22789.5533102787581395778109669*%i
6150.75505995807828756985326157-1051.81754078621828079754452119*%i
-169.042221852848608711214800728+174.877957697611440019399472049*%i
-16.0369401786789744425564789740-4.73384180095169016075564098577*%i
-1.24846196951284231818727415888-1.41265014163223711040434421571*%i
-.113188548656771790582027642639-.269657756103203417663031727236*%i
.919938590422204011461125196724+.387321630563963828169183943626*%i
2.44122838343828616204143336821+3.90250207200822476561315608569*%i
-18.6657181883573410293793746377+23.6294303087277278447314746139*%i
-77.1486843281529128318049917306-157.409291862409462240778341696*%i
261.977655633245263678119459785+352.460563108235635780072112502*%i
-149.490979552080593742114711470-178.428178311999040658674648629*%i
43.8244624146162601192554426285-2.37505250879267025858449137937*%i
1.79889823520778078917576492390+6.38526621599957051085238323296*%i
-.568391666195677989091638971583+.935411448727490604611670125597*%i
-.181568146361678411529810827908+.999821197551024986936348331977e-1*%i
.249822882274322680939090930834+.877120619612379337411859926629e-1*%i
-1.53589747338718713635605960450+.708639295145202010627278182630*%i
-5.50925120680604827301569330139-4.21065739191129977627606889217*%i
12.7058430811396733685365840211-16.1118364829452763010702321949*%i
16.5650912968608335177859746404+28.9942188964745452949362852267*%i
-23.8975252093607221023709542694+2.24105988237842236149698461713*%i
.728844173514105418562306725727e-1-8.86036003430432909900549564804*%i
2.19959105847511784750015387747-.760183632692181025443738881351*%i
.474993489024160978277789994591+.276318963112168192575112281532*%i
.559101665942226063241982363838e-1+.117321466357706233918817147064*%i
-.567706547909179624623554268848-.875689416007343119587361122653*%i
-.781609216364809020713146448194-.625564830778801486482113762383*%i
.262540578996944224784616945292-1.94435464090927062367344863342*%i
4.37228951645991690742825389394-.866888439919034440826746578985*%i
2.73193873667447081710431780051+5.61085921298976327131744326051*%i
-3.85974807413760404009707245085+3.11255882498750956479457248457*%i
-2.09696905003043476664354642003-1.27261920186554055772583658983*%i
-.161354302052103171842694409680e-1-.887875939419788481045320509502*%i
.188285291277221312936533282784-.196945591988977231420352562807*%i
.761748610265814769445312719708e-1-.167784608010202015716840407591e-1*%i
-1.77674507549316090228978201896-.318083901817157600576970868947*%i
-.507303699834781521493018330021+.389415938392366499315127683752e-1*%i
.609780642834145503983904536869-.945129164987569695503624714658e-1*%i
1.56681386923735847897393010398+.620636459915997665448619274502*%i
.887827035227705368764150351883+1.90910804933709770944433574640*%i
-.713352930037034155846551965843+1.50497064679330247234265661312*%i
-.893954879555472680556290992091+.232912058701573122364656667715*%i
-.341742532920868319994685707697-.199986604147384947120564014119*%i
-.534468171251927215248920771202e-1-.133407619597910905422741769904*%i
.732177366525129816756377978979e-2-.468553190071020060234161071526e-1*%i
.112080183095872282339881530961e-8-20612510.4714992119261714573138*%i
.175691584197763615336258002283e-8-13392727.5021473844618586858584*%i
.275798544381116414530423358304e-8-8691865.24027530536304971857191*%i
.433599626384212378904171298260e-8-5634152.31438611046241505020786*%i
.682781671663501224998010586481e-8-3647359.79601957509421226685008*%i
.107699662193639204808751826580e-7-2357883.95478062864694701093569*%i
.170189841164578960455390297113e-7-1522003.42251868019835513623515*%i
.269458067853417398295245810165e-7-980865.745306520551997384621551*%i
.427506911956458177741357760801e-7-631031.255479420914416556862109*%i
.679752497351532741399708727936e-7-405210.661861283924815575914774*%i
.108338136459017287301263520078e-6-259677.857770005095039785427010*%i
.173104549475007054501970336237e-6-166051.079844794948070368957754*%i
.277340455135056976686819229139e-6-105930.814506269208629872633799*%i
.445640789225413269808843934214e-6-67404.5578696006122777468692233*%i
.718327270962843273588521764502e-6-42770.6010609856006182513224720*%i
.116180940210936286643645931331e-5-27057.1650174091210489188954525*%i
.188601038886815038724815231516e-5-17060.0041511191883427408640544*%i
.307386910237120438719890666358e-5-10717.6714553062614279854892815*%i
.503164642966494904739961229539e-5-6706.47183891176793357679023281*%i
.827538161054310917605739784200e-5-4178.19584030690448647984114575*%i
.136807542921467438653968469870e-4-2590.54352897572627663185808319*%i
.227453037012773736699812402890e-4-1597.64728739765402449284254013*%i
.380519994776850931816437341971e-4-979.510458670704476061894100238*%i
.640981341639516273480963150843e-4-596.609490279553830729698391546*%i
.108796115799731564672429004556e-3-360.742244436423768741072886268*%i
.186228719190112219398651541689e-3-216.347904199012526389970754186*%i
.321785694802480032756661115290e-3-128.564355333152758105379073293*%i
.561905045503468073503027546607e-3-75.6120720384937245354826170625*%i
.992902492677161879243794109135e-3-43.9504083318578155250130328706*%i
.177815336424881862410214573079e-2-25.2063156214920606935433682447*%i
.323329650140332990180390718742e-2-14.2332768381537202953402041163*%i
.598251209127421185371471117095e-2-7.88882390797599658742881802151*%i
.112933829802435015773029760785e-1-4.26725246769280909646426615000*%i
.218198976188186106749200467097e-1-2.21905476002971948606438871738*%i
.433182974461767947357751230847e-1-1.04864106955410848796742004705*%i
.887965159939992495101577000625e-1-.318214399712071503658327458923*%i
.189101210155014560027272000991+.297260039753639959142547714824*%i
.421683060316148344856977505554+1.16702280159308860230170553231*%i
.994809164040865167508521233124+3.00498545120071300240377689252*%i
2.51726980342712707716164131854+7.72445271862187874866855035256*%i
6.96260959371138650892877710772+21.4202582287042758528489531532*%i
21.6255161782835355591224390258+66.5537235898522442495813070905*%i
78.5120890529671110906786312207+241.634587826321366409653397246*%i
354.988379954062455533978789651+1092.54171873727957206968770803*%i
2228.62836797641865093964604513+6859.01281053142104125485491459*%i
23988.5851604270311438835974849+73829.2736257403329261997591409*%i
730740.961875896364531258807948+2248989.42830496872270664582426*%i
391691538.547125213955794102762+1205502599.83733344439481397502*%i
19561821735878.0529364632470845
42413529.2812157383997257333048
438012.136938616543480146261498
25056.8274164284094746970396840
3061.14024461984033087920806427
573.345904772591831541429119359
141.030383760022832602542049900
41.8553548244066603325121869635
14.2364270367716053283354207969
5.36692928878591488932693646709
2.19157377094872515482543727644
.953620232665538106033006018090
.436858882973544902079072766859
.208780663845624576981464245601
.103362472669833235811634546532
.527173736361007291681509626462e-1
.275767487193387905362845013563e-1
.147427308444160268346101111754e-1
.803133452436847913986779365682e-2
.444756061777380532346374965883e-2
.249864122349151447737820555520e-2
.142166214364682626133841084021e-2
.818039682091657965676806496092e-3
.475449574317434871737604335667e-3
.278823055395742433711971227389e-3
.164835780897481342284491130971e-3
.981588522152795448563188139914e-4
.588386904987654661234185901223e-4
.354804769872286239654795663737e-4
.215118447740552920798536002943e-4
.131076041681587941350054729831e-4
.802315549128777099780480753726e-5
.493153362805016738456186033193e-5
.304291339730672877618213390593e-5
.188425156091603592262820192992e-5
.117061437808310954608807357546e-5
.729474223756295451618810876753e-6
.455861275894854974970152451176e-6
.285625204411741676644860866203e-6
.179400528687766279191837494909e-6
.112938897250767988132725274265e-6
.712510853737342234227724439829e-7
.450410565593908155995564835382e-7
.285259938172612419587013714494e-7
.180983323516170708797499897856e-7
.115015487549130173677089702684e-7
.732069156761893545491094492972e-8
.466645619987862704638768276363e-8
.297869335882047766911345196882e-8
.190385910363833766929963001092e-8
.121838213740977719940466715650e-8
.780626804983521735264557184246e-9
-.338686723173495689908320156337+.159604231940431386700039554875*%i
-1.32028749388837591192411412591-.447633309059715313550902101895*%i
-3.10553051331005400425728835080+2.43653767886246637071257199709*%i
4.18303505286158292929051748315+8.12279301421700033733096749150*%i
11.6850191966404017408794362168-5.88716500810259450226078751185*%i
-4.75936870162386350560780647395-9.10139402907048332381662359533*%i
-4.55261051555853149425495185202+1.53914887939323546749522741780*%i
-.168974780482120135610096033538+1.60478793021667771996661389938*%i
.317613669538353815784357459554+.332335282647466195955637577980*%i
.121774056672044573053739590512+.197839443922964735538839495374e-1*%i
.842889373772496449623682600087-.190744571259343147093366640601*%i
.727390516804316541085650731046-3.29852786604048466332825341254*%i
-13.4832436174084591336428281941-7.74015872968211350962235195024*%i
-15.8276087239591964288057716318+50.8442074564946002522056891076*%i
86.3504843335889461118528810327-35.4733044948892452286989406556*%i
-57.7832456073126337798957476261-26.8761439553644245467729576285*%i
-2.16672518858490021554938877746+20.4302459179656634881159191243*%i
4.45103993068332187201299951613+1.46015723374357193739913777051*%i
.806640060050204031497647793373-.566359492803615167326552269018*%i
.673387672604906226101720996859e-1-.202551388283199182206363649252*%i
.602159649696826530089754492746+1.19280998217596377353514448131*%i
8.74035537682223501993327056150+3.88507948662375013950347946152*%i
50.6429790140403495975176181766-59.1548027053215077930565594894*%i
-611.285228682005557017546680058-35.2786899787864877118006397508*%i
1852.07302594397715329042397447-460.020260106191565458176281465*%i
-652.121130188598563466378976635+568.180467437856905573418698962*%i
119.703085573726038743678548049-4.93337494028858804010907007218*%i
1.41967207586786558419526819609-14.2728673079262374863724497238*%i
-1.37630217097546733925292324620-1.49128335002878959009255241849*%i
-.331071942430972869234163473542-.101324126786049938804296597854*%i
-2.34710894179238924931058889183+.574777668663049178112653483532e-2*%i
-19.3038475099058794644263142167+9.61767549456435314207965256580*%i
-85.3505144106237640468144756985+350.672864535749447504953802082*%i
14515.8112917966722913665384006-3858.15927638864483287892964750*%i
473394.233241053579650477190966+98833.9380572743415256261986505*%i
34155.0287163722007740962748884-8823.21147952744287057985152234*%i
-657.906414629644574935354353861-238.369121642400261602432968741*%i
-28.1907516572198773296679001539+22.1550478835581480204042532668*%i
-1.33350726388415675255908128845+3.17812165652596200068674001286*%i
-.502718008643790607074037056833e-1+.480269973921655324221339907441*%i
.251611596980949685482187023881+2.56615514639330654112786730678*%i
1.33394384050225790857432545174+28.4358941645975195788330518681*%i
-41.5386181778336178825856935991+659.110172126942455754164391699*%i
-37035.2399072621542378282400587+91890.1253317893287274981175913*%i
370371097320.102689073531506533+510585060498.892006995308966975*%i
301158.851146401235451230220397-341285.614966827479804675536153*%i
1330.09911142970678763870616150-583.953134284016733779752498640*%i
47.3591868515050836768891908462-13.7635870330714872823741207661*%i
3.98943978142951090683980215883-.900079782332388265261846466244*%i
.526114801249628796932408065601-.999432606240090393162216735410e-1*%i
-1.99379003258832063732216867250-.804297758017951953155772150805*%i
-10.9898608177247699559659064089-15.4046150114451180881975916520*%i
103.219669252210971151883112324-256.462280770099850117422021926*%i
3923.00890034441702974879854408+6594.24036467990145104151800556*%i
108353.565573477197861428522202-5671.44198481525414665316583807*%i
13446.7231186915142604693918181-7672.59783091996499047241698666*%i
-274.785068198749317648114738751+430.436207820470797634393848219*%i
-30.5396162129264562685984766586-4.78437766458571149695674766423*%i
-2.31670951551471822442286456118-2.17165916452070221248570588491*%i
-.207148835644159572718732432059-.409860698795583508345400966307*%i
.961702746663091402674153240384-.825694357324370400720910432127*%i
7.85827806777639144843656820812-.211351071962886929548602860689*%i
16.2359042704692168443720404498+53.3965751218820052878816860728*%i
-338.253641644922553952578721611-97.8655916200156706672487821286*%i
885.205555149687524287339112714+257.526309220907957207221264265*%i
-433.293653786510816324478732338-191.996708540717431777099025424*%i
77.1458803291162613417305119804-29.8085575877970792134109087550*%i
5.51230998862407414345589303457+10.1231191286010859209983171881*%i
-.657876192139388301480512954989+1.64714466872545136880679875530*%i
-.256185982433215653293675195640+.187046156153231630938131643821*%i
.615393555560259397199700433263+.210672284571730641579650299115*%i
-.271302919673065996155416393862+2.71241768489747263025809991542*%i
-11.2131143784858924724121368187+2.82452724813737394356290822829*%i
-4.19093855903569668485221799731-35.4494845301137513849112146439*%i
54.2161238310737963069936539641+23.4709870875394639914379463413*%i
-34.8421805987082891777314470493+23.4099229323757815893415637890*%i
-5.38125450467350159170005445060-13.9508604466254822455423118191*%i
3.05691246956884562835632855288-2.17314846845777810668499620906*%i
.806115286576045784645986567426+.255627385926356382999389040412*%i
.111052824380648246045986527101+.156372481465330104171905561050*%i
-.555441582240285594596735081940-.239326283179384749410218317608*%i
-1.23476787578425038529930173712+.154536218345059756914527659660*%i
-2.02090021529159525177031454938-2.32624701679732800098396187826*%i
3.86763155509257268203710812008-5.65436559683849712867346975483*%i
8.52508826470564295390666160262+4.41707738437281742710208206743*%i
-2.83262765979624993669388516537+7.09977151342226028982464920787*%i
-3.70497042866162909431711704500-.521733887288876002618027008748*%i
-.440793798639464766911802116769-1.25076081244860879525880088707*%i
.192612938834175617179731037078-.346389977668354142843476244669*%i
.100683364070788352546160812215-.452892215371492936074803234282e-1*%i
-1.36607436843895562030840807552+.181232494335194543369855085258*%i
-.577072713507771550167297214937+.144975524146390187394092668538e-1*%i
.233140038440300936545671488274-.878334767795084572402779527448*%i
2.01219899472303701003510380042-.874380079779648051724776390985*%i
2.46689515834141890477338689695+1.38828952523530289341004242177*%i
.144816885636872416580535599725+2.29298085227594700607127905385*%i
-1.01173549795124400513946538152+.796367532973700733936640818696*%i
-.540314815344916555118397077113-.105776030771566271418364789193*%i
-.120693313064728429420813168903-.156640067869733968815779673397*%i
-.464468895409209632925405948958e-2-.641217922021171072205510365246e-1*%i
.422224902542648347367200502333e-8-17582425.2050698898670190617652*%i
.663871643490071221580343644090e-8-11386372.9695375583276894025550*%i
.104543255601965399625491210501e-7-7364428.49946070863693029909558*%i
.164899660097516204681111595539e-7-4756658.46825164320369155578595*%i
.260554679825655859418184046715e-7-3067842.59374472859260539505355*%i
.412458818314996847021040226056e-7-1975547.82749917462860890121728*%i
.654208535970358020301372382252e-7-1270037.21970342205109506259818*%i
.103982809988525372439233473361e-6-815016.149965283539036507618759*%i
.165644682631804387696291470903e-6-522009.174102992150269053854993*%i
.264502975376907007438547031090e-6-333647.390930760210518049610630*%i
.423441618435116530178375431930e-6-212776.693497664079993165990579*%i
.679745439743581329295245543528e-6-135365.774152299399688216035583*%i
.109440143856414092971467533987e-5-85892.5974395456246484241202618*%i
.176758929684485188305133753997e-5-54346.1674600697603588462513567*%i
.286462198952510215121272486560e-5-34280.1075703999205397398610435*%i
.465964594535483727686607912858e-5-21550.4961011509149764003564781*%i
.760973667741345205747422431315e-5-13498.4013035852786245417763796*%i
.124814163667935197873989922674e-4-8421.12027742102371749084330613*%i
.205683379821721781324922467562e-4-5230.63542067620345316331414279*%i
.340689613421814248987858401374e-4-3233.32969510458586244961925022*%i
.567477989607180220360419648413e-4-1988.13795837899746212473376447*%i
.951047288899034651458275570454e-4-1215.36385692644419185406764544*%i
.160465453121900697343022435897e-3-738.175003251159287223783642111*%i
.272763887035636167222677931298e-3-445.141030901426483309590294783*%i
.467476989561415810745145470116e-3-266.298457576017227051498256124*%i
.808526582965853832965739748632e-3-157.894527183928825552528371421*%i
.141267394769091487788684139651e-2-92.6882629325662690494288288434*%i
.249648121364038281659253276329e-2-53.8019747578035538629183171865*%i
.446854357713109452239200462408e-2-30.8356613685359601585697285611*%i
.811473238155026933080571442270e-2-17.4198856666741326051401432078*%i
.149797021607607647084107424558e-1-9.68042476581249391577669484488*%i
.281751335172245758233048326264e-1-5.27901935276871345895671326824*%i
.541477030218492682572538877399e-1-2.81685826709329026527780090461*%i
.106689693034015064050051520362-1.46557351521726962890121570490*%i
.216423761389481841024695732518-.740318578887859496065088409179*%i
.454335748625513634563055704703-.361153472257902084727684050124*%i
.993507195401877211032610811613-.169017359424078549720000259763*%i
2.28198723799442243290798135534-.752388315304892543759411276948e-1*%i
5.56589935237367974195204718330-.315077335805632180007817758490e-1*%i
14.6270495088098472385739976782-.122308703165384730850811914878e-1*%i
42.2530011134798730243333729418-.431318888956505473393580231831e-2*%i
138.034134106335840137495305974-.134278212826243153380821119441e-2*%i
532.007156133702477341063402478-.353686175707766043989960455941e-3*%i
2586.21416940349307444819423698-.737119457504971304175595361718e-4*%i
17782.1176635859507020199343792-.108375261188188185563040414646e-4*%i
215934.108562386076182328103933-.900073654058872796515239645306e-6*%i
7848833.45422028977768352748998-.249112935814302181396920682182e-7*%i
5845920246.32534864357881559657-.335601861742090452754605989591e-10*%i
149821726836882.421314130619380
163683808.124481855947625692704
1331976.36176299602607119708084
65790.2316003976567282332740498
7231.90141592668937505571286846
1248.03598021230939833431449858
287.279063021190333249137006859
80.6664323235964264049916809023
26.1730517431490571545093439835
9.47225355071426895451941861594
3.73218259510816920785694901776
1.57347959783147469857627498213
.700809258595929986761887004860
.326572791150886808540683395867
.158035722550224747402609985414
.789533254069023392500628740039e-1
.405306193667105578701058621802e-1
.212980427465290697404439985736e-1
.114204859407694046423558465068e-1
.623298526601732785024029110062e-2
.345491305618227194567810374091e-2
.194141492472913780613471407700e-2
.110425685145917163528288902833e-2
.634921776036992908871337307746e-3
.368618358889418698323642598068e-3
.215881396759469465043995564247e-3
.127428212687984613988888424238e-3
.757539894348983303518772408898e-4
.453264831304453152253733786421e-4
.272807241479683141627729574146e-4
.165080852577349776050233593378e-4
.100387306134986562035168941118e-4
.613236383630720080493309828292e-5
.376173593046176801961719809025e-5
.231643632001865976574466438712e-5
.143152381780254578602440296175e-5
.887584647154124070200396111286e-6
.552016023085316736119992245825e-6
.344295691239442406596264455130e-6
.215310538763983595056124564578e-6
.134982081089310502880976108966e-6
.848191923223440733851785833382e-7
.534140328283851445974100530906e-7
.337055357185181992454587649970e-7
.213097299137332466506079464292e-7
.134969626378450682280091069418e-7
.856307952313580555719137324237e-8
.544148834019841754669068918203e-8
.346306283689761120448313217949e-8
.220710005706444817755693389138e-8
.140854042491529878783106017444e-8
.900059672977484715239739672293e-9
.106440983371705874639394541742-.145704544872974771167655306879*%i
-.522008202015466667653209828271-1.90482849962166631676136159322*%i
-6.14878260945101209699489658964-1.20253258367022422473788846326*%i
-4.23486564280838604949265925579+14.1699526568327110658463041353*%i
20.9866454562358536907772621335+3.69048268887692608816987994751*%i
.564831842567435129290241108169-16.6498230494252441874829824442*%i
-7.62848349470720062493471187318-.623940322013609575009561144239*%i
-1.03334945922295051160710044679+2.27491955661425815488176769722*%i
.334866866277754612143733777609+.602573972107310146778697326446*%i
.167293223699671008464266927224+.642590678459687315121604668889e-1*%i
1.06863297401798873049384506544+.717865505675774469824704495596*%i
5.29416151666828696754593739846-1.99970105073471231402441508592*%i
-3.85153764319592353632449015284-26.8519658771987043158209341525*%i
-86.4653711252109381214792327123+44.9702261616121262474849676924*%i
169.074564515798290937808486414+43.8659675626730573515213429347*%i
-70.2246345211493482820914028788-94.1502388895709539195112681736*%i
-16.6163683671904647805201465041+32.2113154878661834307972222537*%i
6.47868390624384297216572406741+4.39717950407107279289430612086*%i
1.44147552118003832671792988196-.605218057756729856728045610593*%i
.151969090615075865276555831575-.285215868989315722478774414241*%i
-1.47786145488078923906514059302+1.67612666322360453978788801718*%i
1.56547125494107862176631293029+16.8257484343467323968827752851*%i
149.541744831826958011857661132+17.5002797484015321100596113656*%i
-802.882563470545748775805883459-1022.98163688337347922771726715*%i
3929.04752667968715518675071152+1692.69435704572974361387432902*%i
-1797.85809450998152338867341982+503.741635487498280877418326846*%i
228.320881654697404537964414375+60.1234098291160060229857918969*%i
7.86389811013390192629574195582-24.5782022578384558536048112117*%i
-1.88168407058409863911469708501-2.81162228632994093614996965556*%i
-.496426697198103270921151130636-.219461460494473790129447626456*%i
-1.54583476564739080328897130826-3.56608836039663929922623168348*%i
-30.9460966209874185070161540577-25.6096530338232685689338788556*%i
-743.940249965016897823449333138+173.986849207943455416596218406*%i
28533.3738530657141353578337342+25371.5637953934444029278081409*%i
936903.355534963505505736748197+1130568.89308588163771407441475*%i
93482.8967802966811570402011603+5414.29319597234873998554969263*%i
-1328.65299159486269503781194301-756.421571125889647182055252744*%i
-58.0121797300971338541423614462+36.0111302638000480696258604937*%i
-2.72686466408196840369237489263+5.28827900086671226538557223125*%i
-.126179879053999506674538441457+.764383019000181855944300447103*%i
4.42077360754716315578778292141+.962028197593789761050602002140*%i
51.8568330144290500914584815927+14.8523962963823664152565082592*%i
1335.68268994400311070337211160+557.323644737710515442151388510*%i
207352.304761615363531620085260+186716.909111860661950823618051*%i
4031998800000.12499998263894205+2879999600.00004166665422931534*%i
871064.118262462569689459702920-1079064.06508649974307388223801*%i
3001.20752370633930766254386458-1390.82388756519353934100587511*%i
91.5943704493304572661904346591-27.8862045098107032180995219650*%i
6.94917618831657924493707961371-1.63326343311244462005826077234*%i
.848958904394596897778160350558-.167160799869746537736354900423*%i
-2.64880956680036964469599429891+2.45732523799458748610228454991*%i
-34.4012673792884927384189130340+6.31192136400456874249287767988*%i
-366.977080652510202057934766138-444.302098388306783773952623416*%i
18727.7407041222083801536504231+1622.38414496106683732048978964*%i
229079.089012226225776827303536-199852.357843701365348683111025*%i
25387.4336843540549832001238450-29984.1953938326572406567562380*%i
-393.054191895973134220677495172+1022.88752882214205108924018140*%i
-58.3234303825700478158254102453-1.30941994161585494203333625514*%i
-4.31517756064357009562450748690-3.33346370450511413000768245925*%i
-.377452873060035468804344895360-.629780186423300439610706308360*%i
-.620709507763869859997238509488-1.86306865372408477282137865088*%i
6.58727702391159634085246723343-12.0157696359032105604993734217*%i
100.553425519035442272848218838+32.6884968230900886850227352259*%i
-617.094966590521572680325536406+378.633063100023696739654427984*%i
1851.34063854044091035407383707-707.957221527682662528713149884*%i
-987.022001947204909168054754043+39.9395349919220479468788847261*%i
123.366509559444308128926752076-100.891309584537943350977672119*%i
13.5666946816560593260677503613+15.3024345731792775455481639509*%i
-.614116723352438039507105958182+2.86519421420935608212887044070*%i
-.357968375310948201063128595192+.340721415791238095709030872410*%i
1.02080459341524650802037293315-.402703752185414549486505939975*%i
3.51953222235449574985546163977+2.82700796410371410227628474011*%i
-8.18732746175727696393042258748+17.9888086877111096146815937864*%i
-49.8564507254682560844029062775-39.5544748106610598172735646240*%i
104.353435062624754157689320031-24.9128847532607533088949162694*%i
-34.6698391987984493543873823611+66.8169524278521349107404532966*%i
-17.5728166122483040973706024904-18.9234949788221082050632720333*%i
3.80046404642265208733214909374-4.86528284201474225082065898014*%i
1.32225534081890096373324844491+.109806679344906345986731318028*%i
.205569147474141556100591628855+.201846985351133014743564668045*%i
-.148420630420271604646324884215+.175137819772438463859386405508*%i
-.833840823449710251192098272634+1.45801553015234853530120989540*%i
-4.83372851217186451312727862029-.273066126512285308423226246084e-1*%i
-1.78071534862183878474599925067-10.6893588801430982529588065375*%i
15.0405225759148305464974416174-2.46058035128432024019702341961*%i
1.66655091179040306146610735924+11.9974321527510394580158484580*%i
-5.63025484467515339217546501297+1.57123419716459395773200533902*%i
-1.24995118682889461737186627340-1.59045609337424870331000070127*%i
.142979475736546812627716410398-.569935646516443465240219373301*%i
.128055497981410151321227485427-.942196787757698972007274091611e-1*%i
-.913580981783020700148619738295+.544390968897880266603483173510*%i
-.740920663189928812981668068775+.317021702298535160572278460747*%i
-.906970560817921005070989196408-1.11275628340699532080657998608*%i
1.13448231762248606826997764392-2.81559511603906816120436180547*%i
3.92886825705585539789375346383-.468656626808900826467920590613*%i
1.78653660787824172782371778848+2.73083147033854098662607697823*%i
-.851749847143202629729583892624+1.62870752111691771703288586990*%i
-.772485786335266395495160554788+.118345650171996228662067762459*%i
-.223811621513535732200032655546-.163401663806894050411402526657*%i
-.267705729095362264783827670327e-1-.844700280278540575429690354858e-1*%i
.153021617414880665143768343594e-8-14882876.1899069199480162247728*%i
.241362533161122094695051363369e-8-9605079.95744770501250864777680*%i
.381340831037260107929933812721e-8-6190152.09803528076278123109786*%i
.603568591573298579955585630125e-8-3983331.66693790239275454553467*%i
.957099079245014544481699543370e-8-2559124.31921433671664031784118*%i
.152074063521844919490455116985e-7-1641296.26586636897495945008724*%i
.242145737721731255430684999322e-7-1050702.31866790855238261743496*%i
.386440162120813825744751406736e-7-671291.184246622138775275273372*%i
.618211652278417029328408875842e-7-427973.222272419650337113584916*%i
.991547302601607197702779484472e-7-272223.909945445823097172581437*%i
.159473894293008286268761841602e-6-172727.935752681804600144199752*%i
.257247912853735188093477351943e-6-109305.071520404735572226333540*%i
.416289005619047326403842836010e-6-68970.8180106549754658898602678*%i
.675963409891991936719657182937e-6-43384.4103962933220819651048291*%i
.110167075706633068059843351825e-5-27197.5564270309914395617285893*%i
.180263747436212951792099049767e-5-16987.3520549889102973183607653*%i
.296233719907067270817632634445e-5-10567.6448556221664962197708779*%i
.489088792448139754320100580956e-5-6545.27393431737845488574164751*%i
.811603662700238057365583453232e-5-4034.55584732428637065713216754*%i
.135425485945158706474636363660e-4-2473.89373244204120998155149300*%i
.227341300887886486245060200935e-4-1508.19460917627995245149229493*%i
.384173577645300697384322117386e-4-913.626828551116980585583303542*%i
.653928803389313131929948879569e-4-549.572646884663100881202159465*%i
.112204025521444208604680368322e-3-328.016496239308949754690267639*%i
.194235216628561195418423195290e-3-194.089926918318924146794212628*%i
.339554422152371492564077885366e-3-113.740285240873981262183242943*%i
.600118525731608233992552633826e-3-65.9375701401455693306668653479*%i
.107367302322843831668206312570e-2-37.7651287231854053859587884429*%i
.194745901373340814269227182827e-2-21.3379628996153919748955432972*%i
.358750720955001798700358215952e-2-11.8758926453636442307974822377*%i
.672591088914539231634869721854e-2-6.50423714175659110251640609525*%i
.128653381267180288288478291933e-1-3.51150641732329150491733569479*%i
.251823888586178733980233482933e-1-1.89385624648226458773185856344*%i
.506228132346852231948528885294e-1-1.08070378846395216299360718873*%i
.104976017678925507510910757165-.779421965073189808950278741914*%i
.225793006673846040239736926607-.911859461194750853473956328236*%i
.507228403698969671465210484941-1.65976152395671104532392575464*%i
1.20060468529847065037203459881-3.73763818670521851680355173714*%i
3.02895859413622147988853106733-9.33937860176146242158806247473*%i
8.27075386646154564624333074738-25.4611801017917702081712018545*%i
24.9630099169932981319292418691-76.8304073100107861067107902227*%i
85.8110151129464519825507860736-264.099787476383750973372425471*%i
351.240100450175036472809711458-1081.00603301997364263122473627*%i
1836.42054975749332008626302622-5651.92132395249895536982491024*%i
13833.0071431336054347410934087-42573.6183581571355141836192543*%i
189552.496961904561191000802475-583382.599330417952445095691516*%i
8222683.68049696349778557768650-25306818.1948651328297698003750*%i
8510823646.18077040845827014871-26193621823.6524208147644351493*%i
1172182256009233.00414436475530
645263968.665517445672124738354
4136945.19502524044898806938954
176392.962542319279840014452882
17441.7555234675691350092702838
2772.46408192565278442799008365
596.985618757294649470623514299
158.535935328248004609877931828
49.0471037864487072130441123352
17.0329821872295442476886356053
6.47259885632643237806758588480
2.64272709138587671714634271425
1.14382658751191058206246346591
.519480184886376015293441280580
.245610706553123375334901512449
.120140941351852909135218322676
.604973522938641155197297894029e-1
.312340790176958774063679481737e-1
.164789183963639368965340209969e-1
.886019984618084161149211237742e-2
.484368117588377313631926606144e-2
.268709888316888350434477270872e-2
.151026561337619072283025638308e-2
.858763615123717320176540483801e-3
.493422427984572879540893168626e-3
.286176693121057348603069520981e-3
.167387946775254802505634359143e-3
.986604158911022233407068739405e-4
.585581113279186080730780757609e-4
.349775203849589528691914199628e-4
.210141616143790080354355355000e-4
.126924637217473641487926910431e-4
.770376793790281861977489625975e-5
.469695362954993162638797833769e-5
.287564234811206803952878938718e-5
.176735498106504126930833082531e-5
.109008679832624257948204427993e-5
.674584668863766182562115755716e-6
.418745325322022557449260254226e-6
.260681819828928278242679512339e-6
.162718165771777197363422454763e-6
.101824043033513465058316075042e-6
.638681832700399728014693228804e-7
.401490634469725770073324323116e-7
.252909294622548126544003469239e-7
.159624380035416731754532456990e-7
.100932136944000959391876977011e-7
.639307900226579116058608533637e-8
.405600999342478843141643087358e-8
.257725508485019826306600377888e-8
.164002010499328670456043522076e-8
.104505905040771365960694087358e-8
.617937071710838427206226170307+.208258088624833001029942199208*%i
1.97523603519878400691329184354-2.30739123200593256321877404719*%i
-5.02278262343922243400597722082-8.80868791309323384211033281093*%i
-21.2981288866400628663115760827+12.1773815529205129218543687786*%i
24.4590470509882905375932813348+25.9347453780609473200399478433*%i
14.5544712100969738366739559280-23.5809466932552053325246589717*%i
-10.9786373801302061116709093418-5.91382737147387529291273934948*%i
-2.70075582119995184660707932889+2.88086501707056826868625780529*%i
.256957586591896510768184307847+1.02133037388700649773056690917*%i
.221866799716431779601060580407+.144517755802627073459935990631*%i
-.149209701323830737203017842737e-1+1.89924187492909642285615719803*%i
7.77146766136983586939890790256+5.60099328005043162113549345135*%i
33.3829323376042523458153730788-35.0199521121308945307849562816*%i
-173.927737785438202806662961535-55.2956317715567387701550769144*%i
208.746898317332159152267523464+261.593170121364053408456901695*%i
-31.9194153571541180409109061362-219.243001474358485947572749626*%i
-49.0870409955176961442323848677+43.1425547969913100385706089262*%i
8.51850967460287710037934063652+10.2855071836194228559100966675*%i
2.48606643915144720251051992759-.450450629694306831194406062803*%i
.305882651931266304061887160758-.392755424210780559804403278908*%i
-3.70755030931243324006060008231-1.02236655240884125494860184692*%i
-25.0622559650851126596736300284+17.3683207990609871347933503491*%i
136.408380490626967296149736387+264.089907069451898719329083026*%i
508.732642318307311562810584458-2776.55055822069234225870389304*%i
4820.34085623888503800242471355+8539.80812789369522671982355043*%i
-4059.61388288201283555212441385-702.061144608106769828298474683*%i
403.180231256137996734056313142+251.540925216232960459579773533*%i
23.6255389603880213079948354917-41.0478430748139641853723504461*%i
-2.40601273921602181919659236097-5.21837426457518049890729679095*%i
-.743595886514259361198684581533-.443451652738214418530628414544*%i
4.67171326673757171059688921858-4.74765434603354462201800552176*%i
20.5993363414277976953174181716-73.4463930329614455884475064941*%i
-1062.21777288258983023121316510-1263.66461148559242905795365342*%i
-14046.0131662088534798803443237+98143.0553210991476964855906211*%i
86833.1425037067388877719358596+4554233.75753964748405376784563*%i
236832.987790576448252552327797+91555.3552554687948986757241161*%i
-2633.91045877654624000022695166-2165.96858285983314376573525868*%i
-119.753395501211218444366600298+56.9736470835664209502570068929*%i
-5.52207673511965290427490962718+8.88839953268361454498069867745*%i
-.280863486158741968665367838158+1.23315541559982016126213037701*%i
4.10550561794630371528034631612-6.80591485383999905186917975024*%i
59.2666827030690251855437144595-85.7045961613172335309358946929*%i
2153.16077811460168807626119124-2416.98845388451771396376966850*%i
709003.808726046287386377479309-376089.383441302599577834461973*%i
15489855043849.9964116769731052-21289691157758.2483337668846530*%i
2560548.00072349611054286853480-3473623.33985790306544268336577*%i
6908.57704445897669174622950405-3373.95440287999664068158166460*%i
180.618664790734731394719487623-57.5278141313744387860130519911*%i
12.3298512026104983768310170014-3.01591625121976209290104305696*%i
1.39385885987299992984301443702-.284311800242417522373955255815*%i
2.04205233092158935989297411738+5.79991970850295564677021493976*%i
-16.7965462413122682582239613937+63.7165384244252080726463059185*%i
-1203.66629303389233562898995892+233.531067099936425914509127282*%i
30666.8712465380085436275340131-35674.0327846713976709756460529*%i
163020.971743369198987768115251-854960.183171787888423807891036*%i
35155.8565811545181956167279700-95599.2202723194857480307584988*%i
-393.532809019035192745711665967+2368.13518298469482844962012154*%i
-111.590511914479798129089577421+12.5106838639248071927244479060*%i
-8.07614826181443369095094802463-5.07617207040505725787274945191*%i
-.687384629297570971404712545951-.976883986042403702911147942042*%i
-3.29257833710674662617702666239-.403174874066228548158517374208*%i
-12.5450571208788350978385964180-20.9282025194130348275206528170*%i
163.453740423826675873293223144-122.975895248401504923602445667*%i
-286.933405339611944562775380176+1494.37235383723604564231057792*%i
2305.10000558697724334057541623-3698.69435353994640362906935251*%i
-1848.35622873065250505263937862+1007.40434819728179149099893735*%i
168.379764611198990877362758354-264.654660226905854026430337908*%i
30.2024258056736690093909118539+21.3983424059227588958333942832*%i
-.196203463948520118852529750736+4.92826536197957750309984886760*%i
-.491106321691325990671314339549+.610387019174253437999581161579*%i
.461688483012408691143641633199-1.58965161599275574178188962805*%i
7.22043336155053819970732356207-2.23970262125426574716848162437*%i
15.5402654306227283597124375967+30.8581935407583846739376621059*%i
-115.425992346250573045811296609+12.6853210467337022287642863458*%i
127.629526206577077807367103286-153.458037435180041760289989242*%i
3.29648209107287818581106856055+138.164809863123893508544005183*%i
-41.2710317603446283965588486296-19.3733757312894050252845755892*%i
3.74679809783628716959682688867-9.66978682585743006123548872546*%i
2.09853719582682377320562288358-.307074355208112041121571873790*%i
.364498197955730396265270734509+.246942369493824620949995885469*%i
.428528591654216491825598627913+.222675537051960235624956944221e-1*%i
1.06467355962334436003279640356+2.23897007391148791676320815636*%i
-5.10220286297116162872635266079+5.76014604499453091849936134220*%i
-14.0274332648655285309905741992-10.6002193661281124246450230266*%i
17.2894933169140426317639203448-17.8860486327750832082588942167*%i
12.0664063271713638905582513948+15.5624296317504044144138290372*%i
-7.20874499383664868759051098587+5.94431330868234344285061764174*%i
-2.64853355209465438489159164552-1.70405532250374494331358521403*%i
-.190516945803586903693994752501e-1-.887222209770820612604605841263*%i
.153469311156094902446143143792-.175116475936399746705773094492*%i
-.352832235218620504933647363930+.717068756466211104362527466185*%i
-.539998119547751574980123886475+.958609872737591206041764974515*%i
-2.21946676057723798634492598413-.661831561900635922938825645156e-1*%i
-1.63215756709264712627773205816-4.07449735177055255454432681364*%i
4.17418151991827025825078338457-3.92248430305260924088707204152*%i
4.25518913864062918466337504705+2.14628152671759529831200350035*%i
-.137452163495362408979537079808+2.68195140437886051215523501453*%i
-.990391193239487975296279410022+.548104960334109574694218266064*%i
-.372826705700955276755170725975-.131692607858403016784838170278*%i
-.647003291805428337103499373777e-1-.105953084870777922811683844759*%i
-.473328361215495447337866571907e-8-12502069.3360975922529525809334*%i
-.749055291729860620159825522223e-8-8039777.28387263234944386165155*%i
-.118754015672827763595452641472e-7-5162138.54045197360308097966342*%i
-.188630821567872804426387645013e-7-3308976.40621174619841158137956*%i
-.300232452820435265224320496227e-7-2117322.36341456544830402834907*%i
-.478892683868409046664101811193e-7-1352247.42401790077215136596617*%i
-.765621365368536825510544140221e-7-861872.315973922901149776900792*%i
-.122701559717571390933314995156e-6-548130.074669417265216354232738*%i
-.197159209847151303570164850570e-6-347783.203553160124593190344413*%i
-.317681736054019499657705941113e-6-220110.864619937304481529908116*%i
-.513405035989890546691897340719e-6-138930.750325940883370132927170*%i
-.832364097554025186700135141519e-6-87435.3389579880702208959140037*%i
-.135410913929752587886570231971e-5-54853.6501923926376680546840638*%i
-.221102260484778544188005486793e-5-34295.8431658366933786121381712*%i
-.362456236199863124476140713871e-5-21363.3937601762153200930313342*%i
-.596729795769155638050352910700e-5-13254.1985487085830616951345325*%i
-.986987101874372684510357575003e-5-8187.23384257284613240991142222*%i
-.164068715980277009799152101822e-4-5033.26281102780142895932698485*%i
-.274226319371851168352735866393e-4-3078.21166689068911879508289039*%i
-.461076015812971183246036534769e-4-1871.83735587452288819374668196*%i
-.780284359889654376631856295220e-4-1131.13834561020080331184305927*%i
-.132989465863170692684220251337e-3-678.839658279893222392980429948*%i
-.228437579536278411946247425747e-3-404.307684607293795394611738286*%i
-.395773559510980783411055053868e-3-238.779491560222723649616472903*%i
-.692223023344705299367903636491e-3-139.707424805410606328113536889*%i
-.122352664508088809759860088119e-2-80.8944095547491742899440445602*%i
-.218808836876312653652298540179e-2-46.2984368845824918670498355098*%i
-.396458264828162235288169293498e-2-26.1554620893962719377957079637*%i
-.728964724327033426101351887050e-2-14.5627638474086154441621322035*%i
-.136271961696186468300150636539e-1-7.97929611502275641381944498301*%i
-.259572360150746533440939589807e-1-4.29984162274489345929726906256*%i
-.505131925610881251521487145772e-1-2.28712816415224345045518529995*%i
-.100743152007283773747566554912-1.22713669361693899334570332310*%i
-.206704034334176123891952559305-.725091644522063496192766831682*%i
-.438363470236523202601154135079-.595466639412164302449700384912*%i
-.966463781407959895061799409045-.830453577489451260275337785959*%i
-2.23131570734661422144535257629-1.67783505213354018643319015291*%i
-5.44495958093249460390801118410-3.97967647315633292440332971720*%i
-14.2147666653996977366881138906-10.3368704074670901849637707427*%i
-40.3457747127295559603078721376-29.3162318046437621807855703387*%i
-127.282947182057587485035872514-92.4775402476584583442099438733*%i
-460.567251877661601389813318976-334.621994336403919777816123737*%i
-2002.76959142497804644115979439-1455.09735156407336696738900938*%i
-11265.5099061502363598782660214-8184.87205899249433232261427717*%i
-92989.1411496785538860695073550-67560.5656894639325171645457958*%i
-1438166.97795730153127538413584-1044889.47185902754921201402124*%i
-74465903.2139250943365094428771-54102645.5712476679846615708863*%i
-107117965168.905329714733896787-77825757208.6066724322427154356*%i
9358423215437790.53950287015867
2595587036.62894449076748900264
13109336.7579189595259445002298
482440.303666305464226986575872
42901.3679393075068092646749094
6279.53751808823372406044054832
1264.46977168764783291327955834
317.463988163663903525711569299
93.6138357943666294856895187486
31.1833734477084339756051590227
11.4238137788686422181195094870
4.51521336860578890530328124826
1.89833122282335254102913430707
.839897519786685714435263863959
.387816298765451465330339516764
.185660443942077387686038896661
.916688322563772247348319027487e-1
.464813186750433875498328285722e-1
.241194054712467050007283394538e-1
.127709324821454817573649271953e-1
.688317163179981308966227145174e-2
.376852733601214156949009474768e-2
.209224538082915879986706818210e-2
.117614697692260198679425332819e-2
.668588605948380449578119953381e-3
.383901750977824518733691023871e-3
.222445224360547080688834361676e-3
.129956786138950525437429977041e-3
.764933281234236567838077279032e-4
.453326289027609410379302315201e-4
.270338416714776198258778669495e-4
.162139587164158787031301586938e-4
.977583966396098289559245638031e-5
.592274728391097808973164425737e-5
.360441926186815270944374044927e-5
.220264918403316031261773471821e-5
.135120863493474784205551751314e-5
.831855946437836914512295048023e-6
.513824816655638580946765342272e-6
.318365230258441799129355802677e-6
.197829401469982764613175848340e-6
.123262075603714524119165130879e-6
.769958368216598996442837281725e-7
.482098770051344731953825567710e-7
.302533353782638625438713246866e-7
.190248572460832337359776271147e-7
.119874668313425431551516170290e-7
.756732411764876619061277520315e-8
.478542913941912023956024737575e-8
.303124585987234871386544999894e-8
.192311069323896871441501079814e-8
.122189574127784158634170288602e-8
.429819549176077848935906906421+1.15090908358389027505934815604*%i
4.84590668152564655336034118524+.445860058691942849763328771430*%i
5.58444302024669683223229670471-15.8086041250978320504161556054*%i
-40.4690479984624561462442395854-9.82639087341478613135787990910*%i
7.05972091093358289436137063302+60.7175400410556142478095605367*%i
41.5005685240959888416723083371-22.4656171052594706841254921902*%i
-12.7313128048081096440351857569-16.3987908607477656470251043404*%i
-5.62720365018737453731285980758+2.97467225559099478034369706492*%i
-.310266829993481577044632307589e-1+1.63789065765776807742038400862*%i
.279273551668379495052756091123+.283224203330471500520546542412*%i
-2.59199761936684881016091570292+1.45188443978610525247477946060*%i
-.620187145730676255095901361863+16.4622096609811089616243671720*%i
87.7125609076045197883352400058+8.08114013672440817454978833301*%i
-160.401371416805622316362422813-310.218126226575277869211224038*%i
19.8211823380283463255737153042+655.337400397728910404420955229*%i
147.702221147425460420064205085-400.779475400631767729351848757*%i
-113.209608831721284318894155390+40.6928786257286142867033852859*%i
9.16989881380913652059109965294+21.3376313997388308604956663734*%i
4.15367001530645921222020489912+.175533229646009846779719926258*%i
.579094833133009024407212417092-.522209025402545811347320458464*%i
-1.32627672307545555008876576681-6.47660400644642843881925635379*%i
-50.5166732737384546480544285320-24.3595484475839004246950129257*%i
-286.582178205435208521162253239+525.523052096888616746635469664*%i
5352.73630858520486041685467653-3236.53111704019175613386851619*%i
-3116.26644623331019949204149837+22742.3423572263828036191803343*%i
-7573.31514966387868596127119233-5365.83009253131354558317386096*%i
637.035658804724510654997191544+739.236866458770839833056051400*%i
59.5193728803702276225025984525-65.6243680727844595476325948072*%i
-2.67208039297188651344798605868-9.57076415247534312932219312862*%i
-1.10841172253531685779171407968-.862457875350957366472583386622*%i
10.8456315877836273147367442293+4.46406467957901789334241126250*%i
146.041929878846102958620549306-21.3574820371282971186716692713*%i
1422.66906391503243007145034660-3347.43709175912834135263320220*%i
-237328.266860317639418991778366+112568.883471571117077704073681*%i
-8771919.50596155629704006943636+11447551.0075319103115815298164*%i
546203.336007648216970517055406+441909.710657998509796530370264*%i
-5064.09741037083381799368887592-5876.19880236792983046266943224*%i
-248.153128810936365894014219129+85.4944490059126300008877199199*%i
-11.1377655975816290160147577094+15.0644181658853557151472635314*%i
-.590770991639040971558559544674+2.01484787655090822200674727264*%i
-9.12725004760139974011259513642-10.7702713657976253408303732200*%i
-122.400609098481305778537574514-164.517529589953990545397219610*%i
-3607.11969840455790632397218697-6440.33113686951583414066455105*%i
-323176.379334207791779782133937-2332812.89866495360746526484975*%i
-54105590086133.7410793732538449-166883807730822.463156174726352*%i
7637105.72865268531410763001724-11375075.1387447648151192941755*%i
16208.3943050839651315020247692-8329.61353586067798467877242054*%i
362.844551569877238774024834823-120.743249961246326037380982740*%i
22.2677872428411846219689395040-5.66324324855239423511792040029*%i
2.32713320144874286865251027751-.491433643483350292038012403157*%i
10.7190980671692607192644379367+.699503535004395727694366419246*%i
96.9112738896623606791723669558+81.2752206317027917703027452942*%i
-806.291673604797137449816819995+2535.24260768630576751365904847*%i
-28159.8656424229351074276062554-116788.108310121299331206664326*%i
-1166716.07173170692262375001068-2260020.92154131010783458508647*%i
489.489122642748221315049904212-269492.201956264216539846594293*%i
205.252048198351408090617509012+5359.92967883001037008728481356*%i
-213.583655727644905710730391624+53.7946867372711866327578500665*%i
-15.1963447151823534997748454683-7.59386462523669589808583451482*%i
-1.25419447001130853676427934025-1.52721178101725659453337363356*%i
-3.20159020265544201968281335283+4.69308635260286039129775008717*%i
-44.3049317626791069075335453929+.377665107632241988800827083069*%i
-12.8529632341265677158783769139-403.490320465420998876901987036*%i
1950.21306462280679324826016198+2619.14416375147814925313571047*%i
-887.681852290571625810133141640-9747.54442827619943420498836765*%i
-2633.00370036983192632304169499+3748.43019542517064206333784439*%i
153.655425976160557712948432718-610.951249399623315988527376020*%i
63.2806299791634977862152610983+25.6676226577668155595015276351*%i
1.12734316018335800761653561996+8.37662703135726415637805993261*%i
-.652294672961893669802423610283+1.08147012868228428523072447579*%i
-1.69165264976002843723275673130-1.89464603325374833173372905258*%i
3.75801110582127628731249499562-12.2739926717554304435614292296*%i
60.2703947259440852165970591126+13.0745811128121010737541341254*%i
-136.681333629687202175580168480+167.977329154090644359115101571*%i
19.4646472502870715738790030138-379.305275705542151534294262540*%i
130.668647604193240255620253370+224.092012311771091955493145309*%i
-82.0759641782590001353094832063-4.32590303193577903648244166417*%i
1.29346793687433243906990097394-17.7146785643957551919381696529*%i
3.20957640598121295410618337953-1.27055325797110164861985773517*%i
.627133987167174670277836778917+.273475277031340614570547745670*%i
.542746063962471693341585065572-.779138512781557842204713234836*%i
3.81704534193004340462581675952+.669459287998669468220012071425*%i
1.57015445464077790375222927940+12.3973409834350540983631501161*%i
-29.0345827602663127808249380145+3.12716110387309691606537389671*%i
5.33448113055667049176075949486-41.3049064871169416076797808342*%i
30.3689200432933263822886165555+12.3698450554343401833184672388*%i
-6.76772342464810478295006764964+13.6817853690190435770564351603*%i
-4.86505447187809996305913191940-1.15841806466719253033607502944*%i
-.395065993681669199527378108578-1.30615429692092399245724087715*%i
.165619210353099513616418452193-.304599490961431705807589390788*%i
.239915809868132848603043104886+.529516422127488465007891050751*%i
.425764083641130869582126881310+1.44221697125077427267694328315*%i
-2.36509340708778392945961744151+2.43972319922493783303668650712*%i
-5.94068987390535238420842455869-2.77869582540440218447005321581*%i
1.52332602526641622381179994325-8.41822560357438876596972295831*%i
7.13119227190137365328208072116-.451631078760406370067206907404*%i
1.51296687308423825144315887316+3.71683659854399803295785488349*%i
-1.08336898340093951756676917295+1.27383004063706687659772503941*%i
-.573753008841001814933902228490-.239794691755601192004873260445e-1*%i
-.126260806493159338152426610300-.123693433234580846230749313520*%i
-.563356008596583326039140275316e-8-10422963.4262866887825088094427*%i
-.894591725291118000429567454256e-8-6677952.86176036652142700487731*%i
-.142333931697157160194543442483e-7-4271245.31119831196389863412140*%i
-.226925827723352351332001001235e-7-2726941.12502349659877100458260*%i
-.362581582219455472299795103677e-7-1737616.42420263851281884591293*%i
-.580674636394608343986839820280e-7-1104920.71055400838224303377100*%i
-.932243367255313652062923853603e-7-701042.452713738751677253727764*%i
-.150059915914486711810243788304e-6-443736.044074045324379652178845*%i
-.242222729910581670680371912863e-6-280154.133604194735451011428716*%i
-.392159440192993753300446348000e-6-176391.997044280159576383300732*%i
-.636940069236721455822967859117e-6-110733.692490508459476865238702*%i
-.103805841906451447746435144987e-5-69294.7436750310349974154460511*%i
-.169801412626774255673773673499e-5-43214.6331510784733241675996494*%i
-.278854079046679299656054122688e-5-26850.3783794888495703697671787*%i
-.459897666163969611047387690517e-5-16615.9491736331558338437737999*%i
-.761974147993197049577578660766e-5-10237.7985873107477690246798815*%i
-.126875087430897787571177001013e-4-6278.11985171723163425453837518*%i
-.212397783443120270962069535351e-4-3830.10079138481116283203359854*%i
-.357653364850480879536021191926e-4-2323.50019910931576385829400762*%i
-.606091822189431755921673337541e-4-1400.86604534490985136379097906*%i
-.103426275645059036785114289473e-3-838.904865316247209393220394583*%i
-.177837826346764018788781800466e-3-498.653301436019549678679357622*%i
-.308346977009356256373397251024e-3-293.983988083130639188150878731*%i
-.539563272156390323671432944237e-3-171.755884325863093915045428229*%i
-.953779420431168667983771504058e-3-99.3420612543728329076944965918*%i
-.170503119691134674177851455739e-2-56.8191414647590100421777468491*%i
-.308633469820934846440160523235e-2-32.0938418899300359636166178858*%i
-.566517316280139804372090814725e-2-17.8742351895559795130344665236*%i
-.105628061480109100364648119757e-1-9.79561760286050879629227700657*%i
-.200448790852387187957897728932e-1-5.26622268558062750783674627378*%i
-.388062471971414129767307409083e-1-2.75961726102909592625866974551*%i
-.768565176621687866386981687424e-1-1.38239109560384540858636209423*%i
-.156237814793422693170958754488-.609112871430184861149883176033*%i
-.327315184487669924090534082094-.114345776248777904657752997991*%i
-.710162438973656021319644759228+.350345368623862135852605223095*%i
-1.60548201799016780053269738592+1.09174645760141255950311015619*%i
-3.81091211310381675517622575697+2.73672083644145892242332253826*%i
-9.59100374325617786727285553798+6.95529938963006200946916909428*%i
-25.9192385484702961544310770933+18.8265468197084535405291246283*%i
-76.4968550106686716102031541337+55.5765378289123932608673203724*%i
-252.339643739392072251033319662+183.334965740750320429888951846*%i
-961.446424458256656523438814559+698.531578295623605530067347870*%i
-4442.91469137616127317590975626+3227.96644148707567998183197394*%i
-26893.8583758239622903921029462+19539.5318471670613898809939340*%i
-243314.305207128587668698054431+176778.190404495419749974856270*%i
-4248008.84639262679120973349710+3086359.08624720357322875589905*%i
-262574380.379500310951199626311+190771454.110363386063163154548*%i
-524971029324.858585967606801099+381413778775.259200078046408343*%i
76168378669435852.9881665518814
10643404893.1660561540972773042
42343499.2605808717685394370825
1344765.19948011767476063184873
107524.437652135724254653353715
14489.0656054563360105962960872
2727.61970615582142095559241451
647.229580435806367514356182391
181.852548837441256990188370997
58.0838485004527375310668827830
20.5061711597293370258993198046
7.84300367950316215932094715477
3.20181967508227496176942007605
1.37952903320773916627734149326
.621851573949463357896464383161
.291249975545026084517487623732
.140949589494312247407552934092
.701659845167458663452215440721e-1
.357971239368825712655328637056e-1
.186592608651140594205751289180e-1
.991168839100976071563871080410e-2
.535381386433312873347984187074e-2
.293519859659964349381093236976e-2
.163072837290212004272074492168e-2
.916857970161639155457803084717e-3
.521055861623125405021418157665e-3
.299006097362021745340876908153e-3
.173099963495965943680389456288e-3
.101015988855180961470548551050e-3
.593820170093793360968015745996e-4
.351416044555251176438710024411e-4
.209242564557736372836276711460e-4
.125292800064236847931372887582e-4
.754150632833385750446323421074e-5
.456114457617037737144174912414e-5
.277088384886726692465167578065e-5
.169025253889667464057418603115e-5
.103501581912530232325715426213e-5
.636047501560137722799879433963e-6
.392170347469096008526614042271e-6
.242553371159324540828668543042e-6
.150452778588295185516547575604e-6
.935780089196405015397779634925e-7
.583519058660876319734501863192e-7
.364734509194077521562882015962e-7
.228495414206853258730101264283e-7
.143449825897403900658882939214e-7
.902385093559173193325334405045e-8
.568727918529022303708394523230e-8
.359081406553026553388803068431e-8
.227099025058851966140625497515e-8
.143857604549447679131426840363e-8
-1.06572916289638493598316330198+1.68386910968762636980117297120*%i
4.08764611799301137817400708274+6.83499200690130014464103619347*%i
26.3237575691749875015897092304-10.3972427491042650688774350095*%i
-39.4392752221903719675234913907-60.5261005083483600891699727384*%i
-53.6879073148744288234207547879+92.8183727019974408951252195526*%i
82.1277950766657181752475498083+2.26126265079785874122098292341*%i
-8.39449616015010029688326505531-34.2685775253909183235039441344*%i
-10.3373222167796639408627724107+1.57202259967971827727828494084*%i
-.737803163028882874637241985822+2.48593495810121059415522777697*%i
.322157119196965716253259014590+.514730851820504808427589415512*%i
-4.17481439433909823041751361574-2.53143605661416958733715831483*%i
-24.5754389654789072190041526559+15.0934404273687565227411446910*%i
89.6158275810555511558145798641+136.784281637185060725920328794*%i
206.268140034028136854683826292-650.153323795582231438770178793*%i
-754.464984274623207654824173925+1072.82621428312202803253144770*%i
632.577669803981766635923767173-553.581651581067567325606916136*%i
-225.744157347420821519792335509-7.44880661097112896454683465541*%i
4.82136715470664396783065425571+40.8626383395841641868372225416*%i
6.71511217057871552827662963556+1.83371232713093637569710205916*%i
1.05472432433926412403034480649-.654795056683456673371848738636*%i
8.97188952124210848851635717580-7.14421521323007022163168868849*%i
-7.12714632563367305492371808421-104.788117460580441468500089309*%i
-1222.77835100243936559704988684+118.749684156501743585062499356*%i
13499.7320522149942482888262610+4193.11876726268058311776431746*%i
-38788.3550247680808662776754569+38729.6950448732349825938233426*%i
-10384.5370663147286223382046753-18627.5441766156779745031337853*%i
811.120635605033264344810183474+1874.65911005052808039557939261*%i
137.548808042184056995662189307-97.8182866670118742367038935690*%i
-1.93200002067441680613504745555-17.3755651679120421578944922474*%i
-1.63540800856521038349537756786-1.63925004357191565876170790024*%i
.432324010360818076100569104313e-2+21.0239719759506002621210425959*%i
155.574670670517987949801441620+245.621886657173545908760906125*%i
8145.54507661599624938352202042-559.825219330224888329463610280*%i
-607539.899706082620854262289387-366271.252965804319453577130000*%i
-45176236.1774380069909011698498+11251756.7631364139073506137946*%i
1084326.07705820534557718014733+1658903.21735151695670308048297*%i
-9236.65797787984615573313584218-15426.6903131424098277881163882*%i
-516.323569263781551766529437884+114.809675929912435570936010941*%i
-22.4540714839915576710656129662+25.6951612868239375625171572057*%i
-1.20597913990968730846120016056+3.33136474347583096332897818115*%i
-23.6929916634050247498021272355+9.47082724483448984086860958152*%i
-390.778070095450018052032704011+126.664353973704167737667924764*%i
-16877.9533716711318328055618499+3036.02846420719698674213244794*%i
-6885482.91675508347626042413137-1485061.19334703171610470494094*%i
-1133170467828464.79848402298650-368953459590693.957661932364167*%i
23072963.7819125122035795847528-37863652.8895832752282926024214*%i
38722.5286644247087480238022256-20912.4459219139629139960152437*%i
742.000916365180808336553663945-257.654296560432646147026043160*%i
40.9073620855642616630360620469-10.8071665583994771570819472242*%i
3.94866946342004759736370274842-.862764155000072787543685889638*%i
8.69553486639178860281262519892-17.0622620950591475565141580843*%i
224.475642821368006979452609008-103.471559157777414441217032233*%i
4062.91780115071213673409368369+4252.36422318510789824039519266*%i
-289510.999386983049932419304103-118306.237349367103373475343898*%i
-6890824.51349845224583923671428-3154506.59574300106355039130792*%i
-248643.494336963043756098132024-683073.554622832122745178273717*%i
2925.25328870626200434192758334+11857.1609581060467489115020398*%i
-408.089226342639937453075997173+164.272768221982320250761579884*%i
-28.7550501126259228031569527335-10.9784139244042879791008832706*%i
-2.29649056761318623331470331133-2.40189158684764148859312494681*%i
4.59957651551212970744984242392+8.65745783790796456750775213640*%i
-41.0628813533143953656060168235+70.9022926570513399675344406413*%i
-678.021005069183201499447485491-446.911788618591167890675890873*%i
7110.39647406745369024947561736+726.957129634883511412103565012*%i
-15103.9443110673964430031144761-16579.1868982102161262492859001*%i
-1541.73697310474636951567110005+10050.4628060342071436064001256*%i
-96.9024951046945570146019282935-1286.13597981025331352483673404*%i
126.825731587061118937776268806+19.4928062695872850334742154731*%i
4.48611284569410702273418111001+14.0377297408143572612042608387*%i
-.817131481210361477757739918324+1.90124011637482074570729425955*%i
-4.00350177325408347651832504925+.802982096918904770590631194477*%i
-13.8284232652237275360789692611-17.3208852484531956598470885229*%i
87.6892168864522223431221243772-70.1171769399466480320743635712*%i
38.5998338464583074813314508392+410.502755990962626995698370139*%i
-411.361994777839152065256541474-612.954057896491276393844918754*%i
427.034670353893109348164907488+254.569336676787553099507808328*%i
-142.696594847484782022050138263+49.8150461590327647319485622351*%i
-6.96835294881848478812566390076-30.2016807718391459389092648287*%i
4.68045848455172563483549780357-3.28293115448178328155380075416*%i
1.05361737750446370582245407946+.239878838389601848443218913139*%i
-.493099767049111969460887741152-1.54955419938124012911357982559*%i
4.50741771619491417730787577223-4.31603160267522970370222246543*%i
17.1422096455300814534428148620+11.6326961278832701125235410562*%i
-32.3963961803123836485029837620+37.5350476550945586142260133449*%i
-34.9262420984197287909721739414-62.2436798187652717919030968661*%i
55.2976109985378205912576944273-7.79136029213015987192585699676*%i
-.859323268924878749293364840359+25.4451181166788982969764459849*%i
-8.04647358337503864959265356266+.876665793437442054557481846957*%i
-1.15301125152288096431172661714-1.79726198059080473603463047363*%i
.141001973729794612248585054122-.505343350007575179673710387786*%i
.536754755442421288687763760996-.962722422049615611063517289314e-1*%i
1.95762207000688508535804227702+.849603377338972073063589400896*%i
.279079448215878139589979115046+5.21716250690014709356198688580*%i
-9.59545795600984481262890433118+3.03591534861608847004236065802*%i
-5.82145217239176461515253435408-11.7776364330483452325417262299*%i
9.07366878874146809239279177094-6.18438694508202079809863763186*%i
4.52311890539530772918065875284+4.13401404017303749012909308233*%i
-.835076267977029207113798906374+2.37577767479981510603335448625*%i
-.819608259272140413381419711099+.219806293821734082383839082443*%i
-.221610455159498069478541107266-.127487311475537716876723066202*%i
.257983243233047614826776726278e-8-8624673.34692614066192569227705*%i
.411130001045283266524046460516e-8-5504632.65436412872038007019536*%i
.656551470744395337590107227417e-8-3506766.70940771580207573919782*%i
.105078565499921665157203296610e-7-2229592.22885566501721779646269*%i
.168567346360982535250710436692e-7-1414577.38392632160853275143857*%i
.271087687842199143968060821000e-7-895464.443545241029886770695819*%i
.437110877361578325945037680849e-7-565486.797281719096007434716212*%i
.706794764207691068181719432920e-7-356184.522919473181218455923273*%i
.114629384906620234424356533454e-6-223730.492341166940290629262130*%i
.186503913608478798966614567327e-6-140114.904468785050283096124539*%i
.304485031458934869389083320955e-6-87469.2560083691691714286567088*%i
.498925660072553206524861525039e-6-54416.6515854244754588895798996*%i
.820755615441615227284546516580e-6-33728.4259188079253526274735130*%i
.135590072588698560025510210964e-5-20821.8202563492954192062718241*%i
.225018876236643242750501651730e-5-12798.4239214932402316041990406*%i
.375269206786803747877277951143e-5-7829.80258173577106275008722199*%i
.629176661623335962617854833852e-5-4765.68607798270890328974267065*%i
.106096240031266905161360848949e-4-2884.59013628429612355193272116*%i
.180027604630219211316081215942e-4-1735.43261770419708989902646296*%i
.307559525536823808655162012567e-4-1037.17256739894694914571989862*%i
.529344687972061851679618639133e-4-615.372902046064337933432169067*%i
.918478958909330517265855421698e-4-362.209052091358255954227439685*%i
.160791183307787603703978721506e-3-211.330712844504479967980774856*%i
.284252569382506270518330085744e-3-122.109441197285540538504824344*%i
.507967756138657614081116608420e-3-69.8011546745258229261753919251*%i
.918673649926395244743176772042e-3-39.4251843918179779574296153121*%i
.168367711919297224632149866233e-2-21.9710872638921572878515571931*%i
.313182807821167071594344106795e-2-12.0582498816216243954128785541*%i
.592319715230870611425982903252e-2-6.49861932851953788326952610559*%i
.114141358885330139777971738172e-1-3.41821214618829408087173246973*%i
.224661863630669411769147655463e-1-1.72203525176091500961074121910*%i
.452987137457384570118985287925e-1-.767226616269077356301536754772*%i
.938930202267573123070606928215e-1-.157274848538109543544115279369*%i
.200913463418963402303384036745+.405687359886923818303400757564*%i
.446125526608096807975017844812+1.27542498874971085174448798490*%i
1.03455122607706447530148413419+3.14115090956984177314640832952*%i
2.52565163775268129764680997474+7.75528434429010118360039673813*%i
6.55779715233231126602805116403+20.1758249492506410922028432227*%i
18.3515908472716575485632045293+56.4778481036950510954109131690*%i
56.3374801741109319217236468649+173.388095320367298249159337626*%i
194.375460933717202253033120962+598.225909394099576036284014322*%i
780.047765847006535404479057331+2400.74010491743553445932122602*%i
3831.61009055324201285835153404+11792.4832837622195597932988076*%i
24964.9505981373056655135913175+76834.2174602966622474254544383*%i
247606.462174355989370034522775+762054.332332020957998130481278*%i
4880751.21644432200117366701111+15021407.6678987714713266544529*%i
360180017.277103695214179804743+1108520109.59324038322821182295*%i
1000939183916.40364532243626063+3080574048053.14868120292869181*%i
631433034593845358.519635504180
44451958950.7262516985781510070
139290703.155953668628636230995
3817006.97799601033444702576892
274373.873980674140999704398606
34030.0064690728321559103955099
5987.74136056622237768582758917
1342.48262554688623315751914177
359.300302065280066430186764483
110.004598351306553982954843723
37.4144533367043741558618337609
13.8427302267659761088114289756
5.48539598515589627980466267870
2.30075961435072883671729901402
1.01212145747016512090284507715
.463604564007278975218638222784
.219832969449476552903060357865
.107402768667048950921697052996
.538550963920306219346304123911e-1
.276263143641663700574461011273e-1
.144586018923505913206888709196e-1
.770266507480670884042606261071e-2
.416887411992269269700804540906e-2
.228840121343524303899842811922e-2
.127219482824746423572643491891e-2
.715383247503270324285763649243e-3
.406455441135063748430474122911e-3
.233109707221603602979765453976e-3
.134838895481354153119348466909e-3
.786057368030147349330993975960e-4
.461520439179187168492831489203e-4
.272753436022920743467384858271e-4
.162167710043854289537275974965e-4
.969548226294596631446526494306e-5
.582642379540042154389176822120e-5
.351801146935101679143783502233e-5
.213356473772955805243365709441e-5
.129925004455695520604998942043e-5
.794210093436986039007441031444e-6
.487216815305987425195741965884e-6
.299882853315030052744126234700e-6
.185152921489965757195641985974e-6
.114649982284036760385720617501e-6
.711875195090493906003229215946e-7
.443147656929815361679038758565e-7
.276529687696743361866597558496e-7
.172950929758298981048095472744e-7
.108401588442636707085318076604e-7
.680813233902601639844957744520e-8
.428402255725279944381830276369e-8
.270061220610758403829008978195e-8
.170536715705058409195130907328e-8
-3.15142965790085997145251926393+.134840279350667957600178120868*%i
-5.08358654889918177955303356846+12.2343318676442669711419060624*%i
43.3073497526873942845428483478+22.3293109295634975590915258925*%i
22.3488215378286168379881169056-125.950436135320620373585703198*%i
-176.486008902264268349621070210+75.9589071304447431905796448569*%i
124.284211922301543956842142990+76.6892260301347192894084485606*%i
11.1003706099273497540107970707-60.1307072068875876516915789988*%i
-17.1851046937898532312365751885-3.26812592081854555898794944929*%i
-2.22387048901055525933513277792+3.53313418558944041092906270147*%i
.310850437047032968824479417380+.888943817332350692543850740461*%i
.161726121482793538650921805799-8.23462810993465680799001397177*%i
-46.7243003441976546086826480975-21.4070583157136837566586881310*%i
-96.4164695017073519719580047242+293.882223945712385502685942338*%i
1204.62949510182461442130517722-627.606391505405725436131700639*%i
-2544.49133046267091398505170819+828.733572724267558983856817137*%i
1646.59863045550907458339752471-366.726336934617385112256348464*%i
-395.824723485352826599261851614-173.364127473123658338959977701*%i
-12.7956485456900609859021831979+73.0987274780479049625953085049*%i
10.4387526126068208080483791833+5.61434473275686489312103179397*%i
1.86850397470139357502436363277-.735011320175895770812243126340*%i
18.3798373898493388533132185928+8.40356463123751035022298219125*%i
166.680332283250630805944066571-110.778258027694235076500672159*%i
-1642.25096551073085838363102214-1973.70527512717796761802326779*%i
13429.1687565063523431276327206+29649.1079704937895513571679486*%i
-132180.870513582580928778770077+17916.5721758243590629801588696*%i
-3105.04429118696143089997744216-49835.0091020019087849506479047*%i
453.759364040854606458557860702+4330.65023065039778873241686590*%i
301.304536525792204234447611252-127.681140836562126146232426658*%i
1.63684172449459573256609848210-31.2328359069443062187187621247*%i
-2.36944941772536395853454074119-3.07037079834986734189070199040*%i
-35.3750310864896037474511084507+14.6341337090559693866797165266*%i
-322.301906480093434201468000578+485.414323503408303777963547624*%i
9586.66634543268483027624564417+16007.1221050590839235630159262*%i
-84128.2447440756283065211319333-1949516.97239754242220240219544*%i
-139239805.294864488169737512173-63646436.3944236476135166417249*%i
1502686.76272397632434342930553+5492201.67576130944803803184741*%i
-15234.5586507846659093875117678-39603.3314311829867472536644078*%i
-1078.57311481081744567658371167+113.876504705761586516456575634*%i
-45.3508152830836814709170763549+44.0061104198323092636062044609*%i
-2.42192986777229769597018130639+5.56918901502986495443652214383*%i
2.69840251650901657299911303808+46.8344102899794026114591371944*%i
-10.7343642794660543434702879950+837.114775445161766913109599845*%i
-6246.69653845324389534042221412+40069.9771436953425377036855961*%i
-11442388.6099828962489749638763+18148224.9368709920151883381179*%i
-6673515025006272.56165998894492+4842666942292770.36011307632795*%i
70481773.9576852581414337866740-128019153.512148205214375299772*%i
94124.8668561107355788717339958-53355.7535799364624301653677489*%i
1543.47731546190357687122424474-558.622539489106602052719763108*%i
76.3939879723014632361323947088-20.9458178462868767211859361749*%i
6.80575417367893140288234316577-1.53758928235454637757494995110*%i
-22.1271646771905025453180527112-26.7397703784053861394027002219*%i
4.85626296536545080840602267741-491.410959674130756854936010049*%i
12785.8351226429097368445650661-3425.22500638282854010641943711*%i
-703504.773205801826388152427532+439079.279332624361215726717297*%i
-22369101.2429488409674689857339+5369681.80787068566434721863223*%i
-1287119.24716230504059801521029-1527180.13908895349697731705864*%i
12213.7329531283489080727919021+25541.6019918450413552976348791*%i
-776.108010163650075657771344080+443.773518304843839630161113751*%i
-54.7186688336676015617912791560-14.8566235395635224540027485113*%i
-4.22442593105257898636496674454-3.79178677325743880572623448363*%i
17.1430645788562485599519995165-.761246683011510907028424441737e-1*%i
75.3637332971140417857920811633+134.504876685553333559620550946*%i
-1549.68745362367649286599607419+604.894122627139444293722317859*%i
11918.8945833584845687094731468-10586.3838817896832749962726317*%i
-51495.1609949783812812484932073-9580.52062883668561174540484144*%i
6984.47643949870018450820232640+21914.5480429163126027851570983*%i
-1042.31866271159479295998939907-2479.38224720648374390145525513*%i
244.563391191542485192837583586-20.0690441463753062150112922446*%i
12.2184085526289046081552075453+23.0952415666261088736058929044*%i
-.909735079002785978589728908371+3.32233122495634516267478527210*%i
-2.23773089624148605954031564846+6.40807699348015066087180655145*%i
-38.8434236900121530698522461448+2.79485590528202498570216357486*%i
2.14372599552989877467742630255-208.261569199576732691719739308*%i
611.517668991329784569744023356+516.665881566682653062195605843*%i
-1381.17906263260312210321437089-484.688517846272642211754129745*%i
971.326885046319665926422595665+30.3040291309137204313425619476*%i
-211.764073137342038903066969924+188.127576119248228619080673098*%i
-27.7861589845071390782275913459-47.5419811866339505095265296688*%i
6.36112430005142548176592792250-7.22897800254617054389670103808*%i
1.73280991099462964653911893268+.583932809310619236370860601547e-1*%i
-2.46683971362393771315464585582-.819066487649210129238527949490*%i
-1.22771629415818430084254164484-10.1659049557898394369076389713*%i
33.9463286874275196206723143990-8.65258448811303975420253524657*%i
3.19317697987020111521570001425+85.8950500908362819460816389321*%i
-114.138918835631295872178353224-50.9546665002760960250023597035*%i
76.2169079102298379815336943216-60.2095809055023314845788764421*%i
16.6664127909974372892424832935+39.9788153314695542951812781349*%i
-11.9874682672018556398688038136+5.85815367048743322649391650537*%i
-2.55553633307474837631104297381-2.24023784343323037036838842862*%i
.340791903612146110705351073027e-1-.805737179164287997832716151486*%i
.100272392870455505244020771113-.842911860168648120953953658168*%i
2.79752158029022714874087067574-1.49252825302687470676667293850*%i
6.24506015735025800486989469825+5.22625875692414650255487831834*%i
-7.93857921159191649860216337699+13.6716763202338850078465918957*%i
-18.4115384410830045553827764149-9.43551740084684989469490026081*%i
7.26215183276532233378963980508-15.6679928771181905159546452041*%i
9.14878567715824519362063288116+2.74779287904392665607866341468*%i
.132026386229701591707415514609+3.86134674522127060901494218416*%i
-1.07285174796263559224763114353+.689478199519984059964523767724*%i
-.362585433087196488475459181828-.979379925286095536893062788122e-1*%i
.100816916255077035455495894103e-7-7083771.43398839911981900009656*%i
.161257801934876061887699646549e-7-4503278.58472009214792860870542*%i
.258506819764320499706531284778e-7-2857052.08645197377850538664763*%i
.415379075469196637751261544155e-7-1808738.76083381130507151881418*%i
.669114811684256240214024697254e-7-1142458.24591544758035442697222*%i
.108070542051153707262625935748e-6-719854.571698814995608786905191*%i
.175040129291516962539179609030e-6-452393.520095744982650288863443*%i
.284361510742667548042837462535e-6-283514.878912696274329910354115*%i
.463439669783594585044615864300e-6-177148.150451558936140701400669*%i
.757877383747568662694139646801e-6-110332.632279985697329625315052*%i
.124391559920474315350724719994e-5-68481.6431331538193131281811942*%i
.204965967053316139748509390210e-5-42348.0389927947958195609053138*%i
.339152545693861846629145323124e-5-26082.9135036319948023452844166*%i
.563724386285256902073563448302e-5-15995.7455670693003429864097370*%i
.941557420764600222523107849746e-5-9763.95907103636706852219012743*%i
.158088615985940297245469590906e-4-5929.95839556218152514852928941*%i
.266938719833553121698518228459e-4-3581.74124590695056671793152074*%i
.453506418640174880140285702360e-4-2150.52842670902613997856310751*%i
.775609455331739680176646949010e-4-1282.83874911299384626221915949*%i
.133611566720128811059007870447e-3-759.827072582909911799290649816*%i
.231990646219685962623214593189e-3-446.561691449793989609792616920*%i
.406295420670199755712976249700e-3-260.221841657774937382693563171*%i
.718321959855312247498017145794e-3-150.221021988136429725664599437*%i
.128324884858857040267444554281e-2-85.8266136908983110910264386015*%i
.231890131498735336474472795264e-2-48.4773869019964555097364749490*%i
.424389783916035762809782181834e-2-27.0355865360432591193322050250*%i
.787715580681547968491524219497e-2-14.8656642164271133068931779787*%i
.148525418695289562268764888078e-1-8.04564582145265604914504971309*%i
.285021475941787553173311616936e-1-4.27785338157510443892232677522*%i
.557900022970061197797481754044e-1-2.22945835494924186005126786522*%i
.111676711171004720373125181844-1.13587382876012744067648688082*%i
.229314020765606992505142223500-.563969339151352441053048581146*%i
.484792420101056208847307445191-.271862490325575143571811719253*%i
1.05989848136472708965706700190-.126663683650308427978777440875*%i
2.40938542780943870415235977686-.567254328616466662173931567662e-1*%i
5.73304758159585200796305551521-.242540661358830287201676981730e-1*%i
14.3992811348176584084435186658-.981732901279671467103515010630e-2*%i
38.5840805167547134242395801458-.372156923577706904356067300803e-2*%i
111.843595715979642393559350044-.130291470885312210526651669247e-2*%i
357.241287087428768437519077657-.413530021222965027804661939988e-3*%i
1289.51217172108597653024234041-.116008425185146299849677648932e-3*%i
5451.98346490201611694123901982-.277503358645031979086677839933e-4*%i
28472.8375712142757802169117649-.536685546541481105264680251573e-5*%i
199724.450858898491121441297592-.771664876840779844369032935257e-6*%i
2171962.23594512715199521251737-.714601099616934805693876537805e-7*%i
48343888.8407124864856970528648-.322810117105720657014628142672e-8*%i
4259724962.87558295058680949103-.367766978509940479347799070566e-10*%i
16455008221604.6288052673111379-.954107456833899452971483319875e-14*%i
5327337172353039320.69055134470
188937569319.900259644624178168
466276353.067938585994210628287
11023939.8824759129905355553127
712280.598446528539742233432217
81297.4976301055164396786793432
13367.2911215806238036941363427
2831.10861554858632707360164562
721.572874988153767522407497521
211.704390347417511964920554417
69.3475084394409701518745944855
24.8122554475895176635158798187
9.54090600470069339205399121608
3.89444526245303817748026560423
1.67137948749276063809630636186
.748494629983467481195379662941
.347651799757773797553560021365
.166644850889465477378807034631
.821031743528046323558930807289e-1
.414357515333057168629065965776e-1
.213599738326777364130927240205e-1
.112199124763182917421710494669e-1
.599306326582204673566103839486e-2
.324947226122624040251269377874e-2
.178574716006046137453331152275e-2
.993335708448339161178591568077e-3
.558650290527289935176479342823e-3
.317331121819323764305702322883e-3
.181897705673874274802320312224e-3
.105133664470289477047351531379e-3
.612284167927589215832222377617e-4
.359079610179143986929226242027e-4
.211940314046630706790840159960e-4
.125836081519839999209541349481e-4
.751226896731088637660040453837e-5
.450750404354291891531073225804e-5
.271732613918599204722455130195e-5
.164529786064380092819629446221e-5
.100026272103831569022505302880e-5
.610424248515588754029916629407e-6
.373843119639592319723056107772e-6
.229714286003102618318595949873e-6
.141591445347109334570904526682e-6
.875292661907572512923038460795e-7
.542575776752655196434543856266e-7
.337200323413149933190763088821e-7
.210073428335052194749804226651e-7
.131174632525284804061366761212e-7
.820859251916276018145024878308e-8
.514726150742935555905324980716e-8
.323388635750288652257526498769e-8
.203549447635336155401924047801e-8
-2.98161097884504246745656141596-4.09881183233362673346793249279*%i
-21.7101453927032298581771144627+5.49837170883441656388583764709*%i
20.7364449288299257697987312712+82.9037852000675837877773599539*%i
184.740069244497377174347064589-138.604535935019514780039946433*%i
-341.716594469434769667311602069-81.2283575808580576200031731533*%i
124.886446036500131542240326539+233.431237475899518844870846610*%i
61.6554560165920532633280022772-88.6391119264109032863242345850*%i
-25.7007943182445335597122205700-15.0518857028292982120854712534*%i
-5.08004029502490569545529519560+4.56862362664699549569180481332*%i
.163117542352397937886807619147+1.47399536841416242252288251815*%i
12.3067172220789455358394818796-6.92383379546928460405168675159*%i
-15.1009456622392988930216836532-91.9339872005203948330968126033*%i
-557.676222688986632254496381816+208.907059290815018785008887345*%i
2630.69716437956678624573623811+819.558431100828407194335086877*%i
-5266.77105749052087247239289400-1792.68143515766686512970151775*%i
3313.18877038392350797501055325+957.823779327387473205093301194*%i
-589.948966565849256560656591654-600.398494350390601574049040202*%i
-61.1836985972367586055098448092+121.639189726274888759866193784*%i
15.3861227458934429995566947710+13.5659065233488705990079216478*%i
3.23717227575638314272933025415-.627952786855389190560862532737*%i
1.49736468663626715743576658945+36.1726247153541321478408796116*%i
346.728238650863479142505563439+173.640920660042617098446345042*%i
1501.90124904162041897269311764-5249.59890529028819582637751673*%i
-31004.7143657020836839941888206+69710.4545214481051955126688015*%i
-287623.444195478207942994407753-162830.935012707457339403421882*%i
44651.7842364391040610813762916-110323.912022283707308598847624*%i
-1880.93140973602793584308884289+9257.05383512054489959553140439*%i
634.554257616374569637098187147-116.947711368137007166401275779*%i
12.2337645626272465419274592540-55.5262245658431934572315662134*%i
-3.32752892020311017186138405719-5.69490428218549207467797870759*%i
-50.0363746654947332722883694110-50.0928975103001356492633615246*%i
-1170.94649644134564623664939500-195.594436470245446558441274097*%i
-23031.1078435027547578247906228+36754.7988659851777065808721810*%i
4416770.83281780503259283848413-3213786.97607364584320365893663*%i
-231720598.281729560682043912531-457035600.933998389609890897385*%i
-748959.668804336179512122274470+16632713.6891075615944708227719*%i
-19696.0974917906077701961588346-99953.5857808604078705471039095*%i
-2261.16042628525302928698218397-20.2778328309168500273329072826*%i
-91.8997242707385452710691428002+75.4547669314514328955205024327*%i
-4.82237581735397685001127850490+9.40538960457348818745922864799*%i
84.5635478707350990071505504108+22.9887210062795960983931659712*%i
1635.70964956635469568074679182+577.058837466611458797232766905*%i
86195.4132923572143082186242337+45679.9031663360019375848197455*%i
40669683.3266958622618307133051+52607107.5902220948122124835539*%i
-32255997600000.0999999950396834+58060789920000499.9999791666682*%i
217264601.073798858313076745432-439362206.368537461783674394919*%i
232613.072766912016897718475931-138254.558071642618569897270662*%i
3263.74545775589142856416995176-1229.82785511686659817090083950*%i
144.942164888901451451436315703-41.2076763850287153717583478415*%i
11.9090767584006072989541774667-2.78027857401876673629716110598*%i
-61.3640759666344019457093145777+17.7865201738043278334122760946*%i
-893.457482739967226054794748835-434.226611860647531132564891131*%i
7193.99289992734415401878253087-29440.1041590801287022177908870*%i
-150312.797258779207609523671614+2232809.41438936885576536341979*%i
-44157514.4342008415490730199872+55698288.8952068861746079454827*%i
-4849436.41696048483366343634781-2770392.91419942925250705881852*%i
40449.0079907918350349007058107+53129.3973656487965255204888783*%i
-1463.09009480568600653926681362+1128.08200982303018786036954147*%i
-104.695087956220851532688774090-17.4047511254940740587042836672*%i
-7.81232744309043527015568240177-5.99199505897607064118778677475*%i
14.0606184250117142472625966866-27.0138428627711844127353926630*%i
294.921949708274245350761840331+7.62011376650149163273517161350*%i
-840.576163105360048047873706074+3364.48395493382704128383151785*%i
616.259371855835546780523126443-36194.2923657237707984492450890*%i
-111400.276949193044192558824850+55746.3749842428876212395174513*%i
36870.2990752485255214109244321+38038.2987612819474087745727533*%i
-3771.17378244589063282927598270-4284.70713320457769229235469569*%i
453.393476350309170532670914798-149.053326306850794569979835678*%i
29.0662671358660190610273317659+37.0311848907225473030107081210*%i
-.737235014338690414888648569018+5.77514260774626386194030777572*%i
7.36180054293161008600485708863+8.85099676049657705398545202952*%i
-35.3187165147412619049051326104+59.9826054804475311617846821155*%i
-301.627520565870033570170173176-252.465366559846255134102379777*%i
1579.43622936986273915015093771-115.391917944623377276946175742*%i
-2821.80758907509248167377856465+887.202470122577379048904082107*%i
1720.29445859583740377461545378-887.063233943571015771246172760*%i
-236.228896143550240027177510888+486.216497862143052528650919338*%i
-73.6662853258823454180136451354-66.9321218378877297489702272934*%i
7.63659305357043048736373965448-14.6090358736193558093646198969*%i
2.78913426120054416846324234393-.447344999483797774303905472507*%i
-3.30601321068464068884537165322+2.49656030049052471044945781522*%i
-14.7447732638130776702813701018-8.61448660933873306162510253719*%i
27.7746725328094679966892550898-53.5942910055437778810416025470*%i
107.371928708909842353633544665+107.550537525538964191703501712*%i
-218.040250653027972928609492932+48.6495772878035799795840559110*%i
62.6529438946263801739139316920-160.544299711148966163978543018*%i
55.2277318088425488167544248075+50.8792662018267388382858109886*%i
-15.5333534101670332040492573562+16.1181549471889730065853522964*%i
-4.98492039441257056559632480665-2.31987955540140308950568199524*%i
-.239106716482432695922337478686-1.23582812190862185028694141361*%i
-1.13030360537628735951888950573-.884454914389151632514930601222*%i
.877639376953806128950393561640-4.80436848400615039519088323132*%i
12.8185270642744023163703289082-1.56397832589793852228258580391*%i
5.24790033898353254807395130532+24.8235397680416826320986845969*%i
-32.8843536289800493340696283566+5.45691883798663664193356620812*%i
-2.96985225400350809317729598729-27.5943224270472858681190683303*%i
14.9924460848376307950172037078-2.43633103348099168689495778780*%i
2.41177647991492220286456816470+5.53251308152192449462626042117*%i
-1.23362548713525562992556786679+1.50818200082632868204944018330*%i
-.560172281621331091674428793552-.502082254297597419751530842457e-3*%i
.378928251006800879376457723533e-8-5775446.60657616757726257376548*%i
.608410488608636046320820242653e-8-3656579.07251063531968696969660*%i
.979183208268585167755060070996e-8-2310043.51064377857146720587399*%i
.157986446466841941623980977841e-7-1455996.94545011287862206645327*%i
.255582033079846290423856193232e-7-915440.430617479368766849156839*%i
.414635902071643130558225203348e-7-574060.412886174708133676457719*%i
.674694398605913166458884144687e-7-358975.911667154495632656695440*%i
.110137483084403219015463830096e-6-223804.388012433197326718915511*%i
.180402559537729333092388675984e-6-139083.353071954493931718119342*%i
.296571686169423909715872129646e-6-86135.8769998409774475175258899*%i
.489446573813736169657576794141e-6-53147.7542655784081449088966222*%i
.811127277161686606499213423392e-6-32663.0324483411940334435263888*%i
.135024285910406679678368141259e-5-19987.8308786384827192900918421*%i
.225848913661208610995229823793e-5-12174.9098868459260391312388884*%i
.379722278168848939392228044924e-5-7378.95590455017692848897548868*%i
.641994627749171745929836222210e-5-4448.09558518371748653498418591*%i
.109196327396669980760934964283e-4-2665.66051952938402239297696953*%i
.186943963951278992937670327067e-4-1587.32720958279914381900865668*%i
.322315731704840855946663814847e-4-938.670324828332862332532852424*%i
.559997434360977359383589434016e-4-550.896419995868696272125209039*%i
.981126652526493840569980911177e-4-320.648441418626169516272032365*%i
.173474573599197468789211556545e-3-184.945877158881704435485065429*%i
.309812324662823349335573496871e-3-105.615331557254618437950500315*%i
.559428262299357406811104710512e-3-59.6537391151409359334427331999*%i
.102249868114063376419290352483e-2-33.2879973750395724740363744825*%i
.189414476630130675044880730226e-2-18.3295294350749136862615229165*%i
.356153871254766890283825975169e-2-9.94821023806345034596299409841*%i
.680890019216548427518054661273e-2-5.32059652762243381487438344852*%i
.132614345626681712724592027981e-1-2.81460801348960076079295947800*%i
.263743487793071801965724248102e-1-1.50259478967018833802612444193*%i
.537069378471814578318893359145e-1-.876489571215100088407648284528*%i
.112339886622876982737600417643-.692043807990340888420438980441*%i
.242304930227408568028866597533-.909194509827937301643933413956*%i
.541413798610927311387699525991-1.74074011879051587388244651375*%i
1.26034999988169008411279157134-3.91147973035949039759101423156*%i
3.07807937420996518310115268558-9.48688812514475597855302835470*%i
7.95595318208957578717311442466-24.4912240070572868856070550072*%i
22.0071069093551500107812954154-67.7328615583872957311758680193*%i
66.0951849547918829709998903844-203.420721207365089058241302488*%i
219.714477644526072972588039600-676.211831389607346727845822548*%i
829.940990723725091748334619309-2554.29577772446779399468446794*%i
3697.62260500967758833672676193-11380.1122303165128099524641592*%i
20535.3633376490613241471480373-63201.3496764103431336932515972*%i
155106.672076921264013578024240-477369.251157476806026370644331*%i
1849717.67429997197924704547031-5692845.63461514603093115178865*%i
46495392.3559355105972990601893-143098103.608366841911011299299*%i
4892071465.99564320845460534317-15056247813.5795985864288810978*%i
26269887717252.8078872192032882-80850400950831.3649091063327471*%i
45709086259702133644.6266236069
816664532738.179974880413165117
1587213432.70493689735329332627
32372703.8805710789247134345456
1879884.06232950888759617197322
197421.370551131887105463961684
30328.0235492388182670916765759
6066.42583797477952423107963565
1472.07747051589902115021748220
413.779274180115511100018799855
130.505322879297281550467128342
45.1437984923098990615017269719
16.8397911020238692197747252476
6.68746028384914654119026002479
2.79919563627272742701809065793
1.22523517638604035388426126558
.557263006464549814204270038556
.262003783756179500298953026677
.126796970696777957346986853512
.629392584018581727990786655955e-1
.319484457283220181457449896615e-1
.165422808385307174761355559324e-1
.871810037843291517484730946967e-2
.466793304109739430144351847554e-2
.253517807559150359698980824801e-2
.139466351551465080210841141319e-2
.776211585122131437550256295362e-3
.436594062986948781218939175210e-3
.247944736054161086049180842081e-3
.142053092829796062269805822983e-3
.820436579411660321628642338778e-4
.477367149782188939675478060441e-4
.279652147064928480930877577197e-4
.164859188643868306035420938690e-4
.977533850161953901891352075062e-5
.582758431091368685030294596603e-5
.349152919330517638552466528717e-5
.210165330050364390052365729485e-5
.127053486929834114357160203656e-5
.771198903228430416377043117139e-6
.469878637668059176273625199819e-6
.287302555630738468661970465064e-6
.176250993050145535893522434138e-6
.108461011764913723129685526363e-6
.669398181552098722486388621765e-7
.414275651867354310791968013496e-7
.257050993000311035462473946302e-7
.159885981045484795786845451202e-7
.996790035637584563041279092703e-8
.622794094558117500064555043925e-8
.389925828239210967392277813293e-8
.244607093159724166210746980139e-8
2.93235109161763205228066059944-7.78854252593453183995559584853*%i
-29.9606642055771771222315910603-24.1390633155779178074059933867*%i
-86.4344319258257880693215353057+125.714453816307223663061674530*%i
422.361712181951505152222810868+45.1508443664976815894874997260*%i
-420.392281471757567825344454367-501.400025729051278977077557376*%i
-17.8636985292721019327434849505+488.603968883625716949245264390*%i
166.899717840348908612261854065-99.0869282583221179662185433586*%i
-33.0850720362309748549089373540-39.5641438357982869484852492446*%i
-10.2147021008827635149889115172+4.97113548278034473283006624206*%i
-.281410199935247451989116169969+2.35361436193464667746136111836*%i
21.2767445621749047792117796360+12.2708184922103963070703864018*%i
124.783169197426992845549844270-117.906191527385658948282723915*%i
-1003.09728054254662771971122662-595.175113838160262841005642006*%i
2663.80132332695037251999204678+5026.63675766284528322399805204*%i
-6647.26932582714679805416389072-9719.16388997372353760652417405*%i
5088.66342930517797758696503362+5060.99834483055384995079779743*%i
-640.242440009899196368171394247-1540.30931987595608686696742847*%i
-175.076035335791204384172628571+183.996665377047527290499952821*%i
20.8644444894987805038635170474+29.4117091731428284696541379217*%i
5.49638297295271379394196864600-.345492956070468931097358221898e-1*%i
-57.4020490847325822060553908697+32.3253607526606105119136503758*%i
43.3146834491594264609879824777+762.299175227784722181853909690*%i
11206.1799760784797945103934713-3717.97693740850943256744356538*%i
-173299.649054910353964090230080+55322.5407862144414970944519789*%i
-328941.666288917964540710814561-765527.846577533587220590334376*%i
213309.709933589302049712371626-194383.590080071530760581178726*%i
-10102.1271493185547858338576044+18226.4636115302738241636200498*%i
1292.14560711662095460028541380+48.3332083033896739065911539055*%i
39.1953407706096668670017216741-97.3919610294759732286512423984*%i
-4.42267771682120390804747693630-10.4902385959422340546262639051*%i
50.9043548752269927155935028083-122.833483656657778070312421285*%i
-621.403085409698420189539936978-2377.77784582466857549285799508*%i
-102106.408712439664736034286210-9003.51422859752192714298599452*%i
14575985.7173505738657553204395+5414070.97249866668005882120952*%i
352632349.404416016744975264416-1708351031.87530611020031095887*%i
-17313274.4646955689192713811982+46384067.3818787932493674812923*%i
-5355.26875660272315920267378979-248608.812798242683415889870693*%i
-4754.21300745442286834739425711-590.696590237186159850358259765*%i
-187.025981838849725170847934653+129.044383720307728933287492679*%i
-9.56572875122584656140583732872+16.0319251168384592669325580300*%i
92.2703545639925718778758206658-138.246777824839551632149100875*%i
2254.55096976637936137786978233-2871.92651498747447507547192571*%i
174407.761444192213208192285814-162723.290253224783866644639566*%i
199703585.061127841209010086100-63518394.2602966193038560024736*%i
336241971775311308.324573889325+244567459577607075.151050860977*%i
674295016.107025694637158612227-1529669538.87285841120583343367*%i
584049.256627437951479923743932-363617.952426965535332434891420*%i
7011.01443971547131817881607269-2747.71835387420895361097857693*%i
279.233819305940125648147858912-82.2483610213720820838839328565*%i
21.1469515874014658823446251468-5.09833422186855583371979866386*%i
-15.2091364056973424257376652198+118.439568563972053252833772249*%i
-1592.53854471362086930529815717+1275.41647614218952467666535129*%i
-52018.4954460329204220058615925-47645.1885446029832613461185804*%i
4726088.67693850691912177198598+3921931.60882981003545525444140*%i
-1225973.49000100077008626864964+223370892.349033939436086231858*%i
-15661430.8484310446208077777399-2645817.18161278324335748420742*%i
120907.993386458722838047927427+104976.059362864716761315504478*%i
-2717.31735002497277653516769745+2769.03420221812885504595631995*%i
-201.343742329446508196210034289-12.8320693538165526854329799218*%i
-14.5309896718815820567641153971-9.44421686856265204417428575813*%i
-31.2728895881441805311442025633-45.1883216400668427895792843491*%i
306.502356851116831027131063796-484.952788287697621164986838606*%i
4780.88310328392268220967812047+5584.30897180702265770732979381*%i
-60564.6431502957790526970616517-57662.2096971796559141820435882*%i
-133539.000379732362561937722190+270248.094752072329581789531698*%i
117054.981234188416560669473684+41310.1519171869606253161680623*%i
-10663.9481071894257510565136193-6168.22446476301601954273449837*%i
802.078822260590633313605950558-496.812536384782523364560280674*%i
64.4788657224263409342912415542+57.1319730672308140735647363652*%i
.148141776329605059567394618663+9.98580157800691526657576301891*%i
19.6099979403680386912025636847-2.93164397360453166798689371914*%i
53.0366462898643902006085816643+114.826796235555012329179894507*%i
-742.742671632784342100569214932+139.543487874791342281111135005*%i
2113.06717684804576138034169683-2388.29447706379646099717928654*%i
-3556.81904271631289164975441329+4938.81703670297735870473293710*%i
2172.55670641267931692079745057-3268.21650986821567006939055759*%i
-61.5122291770592135361501879149+1047.82061448965057670075509547*%i
-166.162139788448592170269247610-76.4591667521061559089718549655*%i
6.80066884302196320679967366880-27.8494043432352685080588100958*%i
4.38140939713561323107475400317-1.61955609036140141223282858965*%i
.360184310160139654095448655641+6.70754153619717617574366393567*%i
-26.7673053926243467425480166413+10.9961735650178691976801222371*%i
-37.5553269405311143055433859307-99.0082299481859512887875594185*%i
273.549657810447853029824555778+11.0307480711068588147997274264*%i
-265.916142137981320472585777115+308.120099789506544781378762461*%i
-49.4223807068094608467803396952-307.649111707969104610978931971*%i
126.201883647297468052477697728+40.5366348467773463812280813237*%i
-15.3922920378362194052822009914+34.9601863890408574575733334871*%i
-8.93909544362707308590687192534-1.33488724792816291159977701111*%i
-.827198365006321355470626410997-1.81449956795109465796221220993*%i
-2.23824343267848558212257561135+.645946634005160984072716043877*%i
-5.04363105102001820571251577996-5.83474899613917534884383631261*%i
12.3478981905400066071265037566-16.8032033672582292286329369248*%i
33.5493938608376612493636015008+24.5046836812508658873038490521*%i
-38.1301251106915641465889918217+39.4402379698349584544612174881*%i
-27.5706969738683126352708115304-36.2224930292805718008559178528*%i
20.0678301469807721626139568340-14.2499197213492819610335964930*%i
6.82891155288690620142844377728+6.73761054914858545760530385903*%i
-1.08617142509403581050845109011+2.82324573769238607086173830818*%i
-.818082404659114504684653275448+.223151756703535722961489584849*%i
-.121525242241261054958528909236e-7-4674496.05709135759004896023117*%i
-.195889022877695706881791782746e-7-2947116.69765372069033839878165*%i
-.316552982473257565851796361795e-7-1853723.62134412293588755403412*%i
-.512908840583305008985065886893e-7-1163089.34008353865843061535194*%i
-.833415210870370878704386422570e-7-727832.639589288892022691415467*%i
-.135826934182920539695267580162e-6-454176.118875643403209607716632*%i
-.222073005647254266564020753718e-6-282558.731015331019217176716609*%i
-.364317698352492646527939534437e-6-175224.519899647218275265439683*%i
-.599841447259423645143711868553e-6-108289.078140563599890781985826*%i
-.991448539222164088821150799756e-6-66676.2166249574947177029281061*%i
-.164549633512213316777096283720e-5-40891.8315374046154541369654610*%i
-.274310921794258700971355579445e-5-24971.9837767653214548879920573*%i
-.459459567609172601649487005539e-5-15180.2638708793299783301658228*%i
-.773502608582482652640071863614e-5-9182.48337675280348877486885178*%i
-.130934539273294120131884078696e-4-5524.89889821362566474851742315*%i
-.222951148064163891477280361256e-4-3305.08517077661821762258673868*%i
-.382061320263778667887917900383e-4-1964.83229040560058312924751746*%i
-.659252166740688518595257724781e-4-1160.16569819992914145481402698*%i
-.114608826473313530560374320427e-3-679.997052567056207614804203550*%i
-.200869857685603205335643330708e-3-395.363966839466782101746685357*%i
-.355187448359260729599447595322e-3-227.858976358227982671154873130*%i
-.634163805522250665344830794913e-3-130.062010120162854695768287981*%i
-.114431698011652845415430909688e-2-73.4583334999964043291046022864*%i
-.208903151431442043626672432674e-2-41.0089727745385988492145793896*%i
-.386288532834962991349439027355e-2-22.6024341178112784672217006895*%i
-.724492600173696956491190754780e-2-12.2838884140280433867711171701*%i
-.138033586635700992104509612067e-1-6.57629524925454557012610689693*%i
-.267633561354391401544169756383e-1-3.46939940334680148205642134167*%i
-.529177580375334284164163938958e-1-1.81555822515033222421404801905*%i
-.106959039996216480004904280552-.972973070605166378253560984691*%i
-.221626874719069871263475705712-.600830362537658630620516573489*%i
-.472363793287738042621878378063-.553168444729746224563658074112*%i
-1.03973724279547022209827254713-.852441275051386412380802546536*%i
-2.37500817861664814692307439204-1.76872764245559250982695557582*%i
-5.66320311198538713482923710328-4.13295850656820942447517817558*%i
-14.1995415867335108022928168134-10.3240225661233070566707954721*%i
-37.7794828808012325042883966050-27.4512428517848895872845065004*%i
-107.904446089809459163781713169-78.3981778329573377199651767881*%i
-335.857739179675907141119534093-244.015259184980239296055230645*%i
-1162.20495081222682074945688444-844.391419039905287404353187098*%i
-4595.04669701143478657273950484-3338.49686810078817064630778888*%i
-21577.3460221662665250247752039-15676.8595318709775223570029469*%i
-127455.662427703097412303071448-92601.9591897228812597204969588*%i
-1036770.38574468709766704009015-753257.777020149789481088104574*%i
-13560263.6374876741597187989072-9852108.22359947396751280325874*%i
-384974779.647197493785891683501-279700549.623181621420732296591*%i
-48371503712.7973884917145655295-35143954590.9165146985672878847*%i
-361095282353756.462279568953531-262351079292107.801007024509592*%i
398574408881831456715.900216584
3587347693645.13229860213006201
5490447149.44772074402610975615
96597132.3099075878963702189837
5040854.67062152974302421707034
487015.344837133061869138434784
69888.2287454769424586568303069
13200.3904667019213246798504701
3049.07967574101200316657028219
820.915431983354351293951302485
249.237771358216798422673082460
83.3318659414324170459925642369
30.1477093782935353045852928213
11.6448589411325525515019842389
4.75263069437731566900923388202
2.03271840417838233831281914961
.905080304509543494422531906834
.417271730523587526123860574349
.198307432976116887103530208831
.967912173596350524793924910905e-1
.483676579616251909887306359825e-1
.246801557536256745794292616804e-1
.128302127001710251694218699330e-1
.678219200562516556895569443565e-2
.363938294842881169189613895132e-2
.197958074609048691463627220279e-2
.109006593061410217980231776764e-2
.606988265821248272975658246945e-3
.341450091653283483122754758284e-3
.193871606272979351515439615294e-3
.111020748271699578308847003035e-3
.640761676679942080584775533348e-4
.372496777351683271679774523696e-4
.217992180739399728817806498007e-4
.128361465318311628655176216168e-4
.760165088200128752233838285969e-5
.452567642418965265348037189498e-5
.270770112323241704877972644579e-5
.162747204869534605561219238264e-5
.982401185192548069092263840812e-6
.595395111184456055328232817224e-6
.362202605559823412249611552228e-6
.221118937927122236704730765374e-6
.135436226082529212988137967323e-6
.832132044344638963724958331968e-7
.512765587415480163822561367892e-7
.316841127556811334825097591127e-7
.196287501864460248412913277350e-7
.121901640095240180690541422839e-7
.758812018583420693115583970085e-8
.473383054801266762376560626970e-8
.295934067952225665409569372130e-8
13.5745242355635696096599730721-3.09092912578133937004983015421*%i
2.10552175498207293783918032901-67.1290095850309327044682251803*%i
-274.918466474142488312376284549+33.9836597146290653478861198700*%i
521.442327501131557057736664997+600.236785838292546509525787257*%i
-72.1495074553886829421701919366-1238.84715542981513357129495001*%i
-492.328305906014323536638403087+776.120580981821721889430234336*%i
352.911460651688458238775150835-37.8013767845727662501949169029*%i
-31.0891182624710929589827539313-85.2817144903674272047261054856*%i
-18.9022432909347966211682797457+3.25952885649986018413065078737*%i
-1.32160649956395389796272436618+3.60965165039503863749728823634*%i
.601848614834105587283204120674+43.3433911167928241944389932608*%i
313.775786645397934401133862078+69.4502421025433721322336482778*%i
-330.054186177648155081330082340-2298.61946121451007160051104104*%i
-3455.16557528199970237579763521+11434.2030493747446497160458584*%i
1087.89819785322480979536884006-25326.0148899821325018075415608*%i
4289.31259360407352016172556542+14571.3718267401962535882383816*%i
-33.8969133014810340653964460289-3360.44248537119151508877597302*%i
-419.108262761716510447082850839+236.720814303489742924209666141*%i
24.1122833450963222912195180623+59.6754777643645795482891064372*%i
9.14305475112536781222980901450+1.67296848040927981819491850417*%i
-101.431165862702239941791045615-67.2100210438346899574596342285*%i
-1278.16159818071476241846534223+835.223845792969043123798979447*%i
20641.6818246512518482932189158+15714.3183564874240120689230317*%i
-379561.054286757607999039460411-224370.088740449945501297581692*%i
515766.251492390593435056964398-2072207.35234962104572187487753*%i
681363.555053435066896054964840-204405.876763008640104018470894*%i
-33915.5928453659559902218554471+32129.0747059458763452431223725*%i
2544.91076554672152075877660002+671.510744215330843233482117660*%i
102.767219641513817864381041095-167.805181959902482010554226969*%i
-5.27757886696676632031072859796-19.2221860812871408415756797763*%i
253.425949273548821789447627215-.186197904865543484483595204751*%i
4026.31247492158200586420172577-3237.36166114843144410468915338*%i
-92239.5436550560296565207248393-228152.617899733484394854680037*%i
10283833.1627127585410084518724+43789659.0241348704355218033337*%i
4637493907.44638490587354690922-3862393209.33823056191166494581*%i
-92871362.4472086170498965662177+117309885.695837691204419914381*%i
93250.5759379337104779324586638-609589.337143384519670823043802*%i
-10015.6841810527202475677362034-2437.13532234430644814026361598*%i
-382.483616383427308022756588816+218.982336729256874678829389611*%i
-18.9617991192024865669339222482+27.5551280089137946432005374120*%i
-195.932350824205317984013233584-252.916306643171435491896226062*%i
-4269.14480992782819851611168389-6533.05071426798782297981779755*%i
-240517.585984875502657922930934-541493.464296431520803356977456*%i
28341087.8357817983766699133064-670525174.329079243680472703949*%i
2878289851099939759.27606075973-933589782544917502.042315687067*%i
2101191976.66452495848415387877-5399455441.37756287511788831849*%i
1488910.84452175982498442709082-970159.241875034669760706245827*%i
15291.1649931101041905474842772-6226.96305740527263353670196503*%i
545.950237999205875280822100182-166.468716604747385889578970861*%i
38.0879226001214279820257608385-9.47687416407013772527388390119*%i
194.495283537255853974679349683+116.103109032154988441382527198*%i
976.698338276607946409643933833+4141.88683737722212711674374978*%i
-157973.663199753900295651397833+53572.4166917879967418719606780*%i
16585756.5144409639708601931408-4277941.20314914818556287653674*%i
437082642.138927197627139087145+563947870.132665958159377896559*%i
-45129107.3582791057710101156202+8422629.68095741837721707403168*%i
340567.319360063300040273519097+190275.722630040783808495480446*%i
-4924.16809552270727088159706969+6649.17252348310312084673944715*%i
-389.005935755184858673145087427+14.8202817429970483385246744634*%i
-27.1907585451570652461512570770-14.7725099928014648193746171627*%i
-99.9587061807201184238165601399+11.9072843067443481130361941721*%i
-511.376425715449254372266589870-1011.10356518090930226637641148*%i
15772.8005932077725836975042538-1411.77990992134873454364395414*%i
-195960.162247910644270616318826+12881.0758454857308935280837203*%i
139253.873257862276329976334962+728460.033664932140638703008074*%i
293472.284182106522222935313696-36235.0069151812516781379972732*%i
-26488.9787876980387650377790650-5341.03209808982798965847716607*%i
1329.98785735362849784666353708-1349.23102485168225750825163012*%i
136.975217342832894731121986834+82.7666234314120951406129931568*%i
2.73446782180674469155588812395+17.1624260842600808492496891057*%i
13.4749414743249536700471233873-31.9197817877419153899375793976*%i
229.929188452813017998775124018+40.6605539620002543655960869181*%i
-712.669434653986605061044275017+1292.71488653871644809169200275*%i
-316.101099249161394891771707160-6523.54654104572473036082776852*%i
227.018222043500570278279736716+12737.9943724804869811163320408*%i
630.605541527810268171421253293-8069.27691216236203720025518594*%i
683.727719547599218155864663465+1956.13798260954466679321896025*%i
-338.944852681303005331658445195-41.9975776601227066866736403971*%i
-.234033231133436357950446248367-50.6182560958114041033747990709*%i
6.67600594039420019589716270313-4.10408421254246930038664611658*%i
9.52764456125006493601675189540+5.69622100836932613067134826803*%i
-13.0499682312382762924432513993+48.0819476121942415478764034480*%i
-176.195251988045326683489774248-68.2703798184287838775565188864*%i
382.562523506451682052376682903-325.101687274487269486196633703*%i
-54.9704813413680581143728705710+753.054673203275426995591132294*%i
-365.834280998907680510452123706-441.737628025362630904228025881*%i
236.197416507214873871031725002-29.6291815019668776164319016886*%i
-3.97580217042848190049726762459+66.1390637985865508757565517094*%i
-14.9361164334214474093003949358+2.13410108088555494351911618992*%i
-1.98362765174900268616126259863-2.51778555431171398800075674925*%i
-1.29693599112324248066559579593+3.47422313855439160734029111647*%i
-12.4044540699603932066068991082+.363754061788750951584256687953*%i
-6.11110305130173179742161913420-33.7268141130387641372742320250*%i
68.9955187334551798118080662272-6.82686069461481077902279966725*%i
-12.0143307577829480138627332291+91.2947657485345503675422673163*%i
-70.8213589442153307611416753608-27.8841925692213940028781899413*%i
19.2550182706236447579204559808-35.7541752477857577738399625313*%i
14.3182402899120972534828604531+5.95299875451691496305108279318*%i
-.214939470419250675426599034683+4.76513429147279457628980302425*%i
-1.11879017968399776794257787741+.666657553517662907353902532671*%i
-.149923405451264093736530774235e-7-3756137.95051863485997866847593*%i
-.242642709952777000080512283414e-7-2357907.12158955749123093614763*%i
-.393753444203102835659732673185e-7-1476471.18481967023952751340571*%i
-.640780537796115164203862398738e-7-922078.036757929994611878442819*%i
-.104591436764703014144811932383e-6-574222.759623559438883104181357*%i
-.171263549501942043776172230108e-6-356518.823535323961733632731829*%i
-.281386072058005621721414461517e-6-220641.008221009900792706217779*%i
-.463984410623935511504873008767e-6-136080.651706252291484086156125*%i
-.768015282538987245460891338071e-6-83619.7838024258529038947955091*%i
-.127647918892223549069381750138e-5-51181.2458090614360957856754945*%i
-.213087005593629280041582345695e-5-31194.4891877798632988361493966*%i
-.357382196732070693877552524500e-5-18926.6765930467611418005475414*%i
-.602403849271034608811450524896e-5-11427.5023039052443088269359724*%i
-.102089706400754058008454596169e-4-6863.48860731027038633429720931*%i
-.174017227438815359434751956291e-4-4098.96890328212736982783564722*%i
-.298478837194410492502577498381e-4-2432.99405598292621766855827163*%i
-.515420235765209605265390824235e-4-1434.57567798810628276121881026*%i
-.896551248468753435502131302949e-4-839.802018349575479710348529372*%i
-.157188372420517299501834551434e-3-487.785436933996551102389513137*%i
-.277967450015958643113229466153e-3-280.915066201938049774100864352*%i
-.496166610412773303112872121461e-3-160.278373989550943063188677494*%i
-.894733534482391162897294277545e-3-90.5201994637381750416886660435*%i
-.163159426518146679900235298485e-2-50.5537112159445154910282004355*%i
-.301201780474764701240126802016e-2-27.8868355559146999313962169496*%i
-.563597153583095448531617732587e-2-15.1736362643627097718243929684*%i
-.107043600687293833715820493290e-1-8.12904195260283529375130010708*%i
-.206698760798359992174810355863e-1-4.27497283810336155535659236768*%i
-.406548177236066462508355725020e-1-2.19061471785294751210326108386*%i
-.816250885718836600808362719013e-1-1.06601195160802709653241192905*%i
-.167714022899914474130225913249-.435353071709978958573283105293*%i
-.353701155327674013688510535977-.117370331529614863023629855217e-1*%i
-.768330101251123646045513564016+.432458100489941283094970800208*%i
-1.72631662288394849168120707831+1.19735902066387824093821976736*%i
-4.03220914350112404180740010739+2.90483475344288216021500440316*%i
-9.85101776714448101090837493592+7.14690466621423082643092898239*%i
-25.3642016060313044298078258631+18.4241211207092022097719782471*%i
-69.4823213225105291482508144538+50.4803625169563541321419636082*%i
-204.960117755459471246120602315+148.911727349639089782667931410*%i
-661.286575500831987664339370724+480.452658816490612945355523942*%i
-2382.57091356936397745821968517+1731.03904937214589549538393620*%i
-9861.79656483720779264826310237+7165.01459582882019889201144894*%i
-48817.3511261840162097506589202+35467.8816954877325974098990746*%i
-306750.960345305097759282866796+222867.618196988354237379987194*%i
-2687602.26801153393628120044941+1952657.34607399974722663333420*%i
-38557723.5476704606841745077119+28013825.9404563256580107453743*%i
-1236444462.88236777432704213574+898329485.800786086975605472589*%i
-185538578992.580244129308873949+134801668223.791594963750886196*%i
-1925524630277635.58608896211970+1398975532618501.21841166539091*%i
3529869999724152417869.85102414
16004302624090.4901029877897250
19288233096.4746265282742369207
292704115.556685342561666074842
13725000.2085357582685740287933
1219751.73052921912305120309419
163485.755656819817172187399867
29153.0270534652518949425132764
6408.69099521368163325421693176
1652.35552840889220224475107089
482.816768422499138682283657814
155.994737250139178456512393963
54.7214019410014464230211757640
20.5536661233083078060105466455
8.17733576533531164400052743256
3.41669061967260708946659372833
1.48894231740875700058959552487
.672957144340026089612930344970
.313992888873890881014392561469
.150659152129923548753229400952
.740971249160573209541644722043e-1
.372510569381477400353891105840e-1
.190977839699655667788606264159e-1
.996445372262966279436002640056e-2
.528187166214572950580084895666e-2
.284002912223652961006411895806e-2
.154695757485752132566293160497e-2
.852599787284261148059734994627e-3
.474978318413853165217192298890e-3
.267218175680729922457090280997e-3
.151693830410348629741011013173e-3
.868288018513085408222428903109e-4
.500807780127346076541099598167e-4
.290894821815422469218886675352e-4
.170070958604803452025405444684e-4
.100033937043953349909801977573e-4
.591699159669852824492666670177e-5
.351820861227551555870828000324e-5
.210210914801182966917371305809e-5
.126171601298464010458499941271e-5
.760523168279713051892021304098e-6
.460246445668121105709436333034e-6
.279568364650329408680851808720e-6
.170414436224643768168228701604e-6
.104220843091037581424435169791e-6
.639364930978792983077382338856e-7
.393379469771214139878613618412e-7
.242701057094650881390253142755e-7
.150128271313170728707322960832e-7
.930942142356216598217609811301e-8
.578622375743767525765186793987e-8
.360435053150358943716133234338e-8
17.1519138738414030256723807890+16.2969208561925463391920251697*%i
97.0749448899085249586934957398-68.9478399963263968991841109688*%i
-384.056796098854761945063233244-337.404412726761825934158875732*%i
-49.6268681295489519880750791434+1512.71457022316912164118250891*%i
1314.56656301047460196281582706-2000.76333226959730396800004289*%i
-1561.87078683544623822901092487+805.105542770182425010626048261*%i
625.440852455551288231118153002+209.978572707838618067545952989*%i
-.102937134597756888686038320216-162.281304296446291665213892351*%i
-32.6597667238944129583449623265-3.73166776794808718280609505364*%i
-3.49341253526322576011433983919+5.26919000658118606173799513608*%i
-66.0690876102357304233673500639+40.7297246535337073379939831177*%i
226.289370378887470947598277044+567.331430887377385380167032555*%i
3197.91433329940174216982035180-3439.86679317019387448202750345*%i
-22402.4946543879857618267622352+12157.3002553451109140138380269*%i
35122.7526378197586966404928755-42933.7037867813608085566581811*%i
-7005.12615431844126347954726713+31912.9873286527242548851209884*%i
2517.99932140627454985424153531-6401.18862704683831431938283553*%i
-904.641091692183161343169427184+199.138350626448656267395931306*%i
17.3471593999200157324887651171+115.277659018636370172809806099*%i
14.8608328970627537800400757608+5.76401997820222254799387400970*%i
25.3470986887567920706062584332-226.584057179300709226278248891*%i
-2764.56503038213743528515939537-1401.04896176673032366207619061*%i
-2908.55070106101510142287730591+57814.4172654931394904133883784*%i
-209735.048987711259606798330542-1065152.38841244523712907495292*%i
4333609.88046152455592949214635-3483769.90794406089107700698173*%i
1759574.10343344375480381279315+277483.066327537376136308436549*%i
-95714.3698761962550161129261584+46401.4696000256701632268818493*%i
4825.56877343106887307647027651+2508.75368510472485447338204104*%i
246.017031873618650131776056212-281.973035616893352277806963226*%i
-4.79167295465694640824855746110-35.0656171212067885575181723215*%i
188.472946086858722999787121083+452.291639223241760799271748037*%i
9819.60215746648916355255650405+5007.78455781828032873916046972*%i
392913.999192493536651368556395-453309.023705031151487514086791*%i
-90434359.6310432565401777627766+96366406.4943632726753058148812*%i
21204373471.1026726985408286184-460151904.873608463502319717738*%i
-381955194.927282075017412302413+254973808.697063828546456154665*%i
496449.461643730380026128806490-1471398.03289602682277249692953*%i
-21114.7181145630060232139245846-7807.16737768554786095214994800*%i
-786.323710610140261491499414180+365.882997345627285499949967353*%i
-37.6398557342729120581831265096+47.7061070277394813883422263277*%i
-589.766300181605110072203830304+205.921024380226072514278190012*%i
-16393.5772611940291632938922829+4226.59812987517658968795171129*%i
-1488844.98542434106175152004956+127174.324847632250331188354979*%i
-2016753848.66589507194977152285-834771826.172435602892607176976*%i
6921975844512079865.06713177629-21268171355137594218.4550483538*%i
6551171693.37520003655260479224-19312845710.9101312710954284664*%i
3851495.38563303564016395577226-2624539.71239009815979182757585*%i
33842.2007535842609257163573905-14306.9133205406823509998809775*%i
1082.77222233055566690687942735-341.503950129993199880214490190*%i
69.5518368139992512325064854984-17.8490471172460220106851987243*%i
354.348545926822551515043279017-253.821208730555942147506908569*%i
8805.49579522327654811577947322+1900.87524196468348471404196442*%i
-70017.2558943524551497210324748+394355.410029085807894813736598*%i
17702137.4023847909046855836665-45174428.4809517546620694941425*%i
2244873924.50813616219569022978+565220537.534352940488380409400*%i
-115832880.085674368608049708117+68891659.4560560498334972459579*%i
920980.184512841755201110258957+288606.761259129998707907266772*%i
-8562.34113171585477344273908284+15732.0266476523750037849176919*%i
-754.567569906836329027666097068+106.625914569331836852864023759*%i
-51.1924575209828264934290516141-22.7626028362331096042635076419*%i
-67.5533374617144786257341544783+174.458599710985891966957078076*%i
-2265.81977856244666464018669603-162.655474771863333887324097969*%i
17521.3981998036571375320279879-29887.3171701555621672486701264*%i
-294270.842515053570218237096452+364582.113563774292972343149183*%i
1376439.45310473382030045278680+1242061.22505441157133509993575*%i
596524.990888313118910643759767-395365.576641576989371191905238*%i
-59714.3395687782440795653746470+7634.18738047760106683198458358*%i
1983.20489487276592774434098155-3314.11030247270235735249913301*%i
282.230110716123064130962362649+106.515522108918283519282977350*%i
9.13298938453875461350969256852+29.2747829706672071705828528309*%i
-35.7715475070021146901723513101-49.9248246848954503652751120815*%i
309.151814964213391835855675244-309.812212598438645839029167287*%i
1076.21412173592139056281783168+2724.43909921256778506430894311*%i
-9945.00016371827246763133646827-9270.55567442893198974897864923*%i
16615.1910537846702954448717131+21421.0193485545466194300073038*%i
-7092.71491874540914005600439879-15413.9746195237566245233895865*%i
2778.92674864375680493498255511+3091.16366286981820696028415225*%i
-636.416559445916883158070547134+119.899772085488309072154773123*%i
-22.4862546303320304256379410305-87.8709669844654999615653266689*%i
9.75322407582261413881683544359-9.09031192539093571792585382351*%i
16.9001399668982504399078224766-7.89312807803237165187459376596*%i
52.6332645310227093067928701863+69.4191694390118514345486381123*%i
-306.036209361551886612577959732+154.347518512073495497230218727*%i
114.699528480933772465798972286-929.344471256297666057758965816*%i
764.446179613960604146845879747+1202.75016301622231379028628089*%i
-1010.33710200259049092999183661-364.035005563181912757052661482*%i
367.759841870145985635492557864-231.622026195426222853140346893*%i
34.1554032596968659407906906902+111.646912329453061306636116502*%i
-23.1884523443099907198933081060+10.7643676603046558262016273813*%i
-4.12368723973736177299087137072-3.20896043076141260032482352364*%i
3.22781271065059821731540746889+4.95626659963824018748564408314*%i
-12.4219072278465584976086670883+16.0485079141744711660535090746*%i
-47.9072206663428819830591975244-31.4615065628745461516844125548*%i
79.8192884944784264477231139159-86.6444649651984552512175386466*%i
76.4078353169060117989022501435+137.676893943165732015759138177*%i
-127.698191913355393605613264879+22.1098326595582995097789490551*%i
2.19100812737780517253827005077-68.1351943448740052724882141894*%i
25.4732090631917556536630168955+.158141142401958032898845291561*%i
2.11456862762512988455004353784+7.33755910478868213202543221497*%i
-1.39581108089488529153310285217+1.47214558861299577856817771512*%i
.711444730762461895063783462890e-8-2996645.21132701219378203433212*%i
.115622480244317110376562310749e-7-1872811.41271065218864763240221*%i
.188438955554130921333660051295e-7-1167327.35715911743033198254549*%i
.308034042561221435777940992044e-7-725535.094397781604573548612326*%i
.505131546669837802513493368421e-7-449585.801619272030940203479470*%i
.831136860488722441596200335428e-7-277696.116893574112394368180342*%i
.137244344325089663261612229883e-6-170937.537005740742174282519755*%i
.227493835360721074998784352811e-6-104837.046580965404295346297133*%i
.378622252851801434015538250618e-6-64046.0198814347233325905919532*%i
.632880413749278684404470289278e-6-38962.7793913823616522807006141*%i
.106278301544979622448164359193e-5-23597.0347954456019171967969565*%i
.179355775534335154939654766092e-5-14222.3576296132756341392196720*%i
.304290025018637923656262991999e-5-8527.77082765379267780311453783*%i
.519194956235745064509018937605e-5-5084.83423051226899521089582820*%i
.891311150488351209724928820230e-5-3013.73853061603704592166263679*%i
.154024269975660587954919772380e-4-1774.64830033533115336950977294*%i
.268062680262108248947640973592e-4-1037.68414597566427907763458470*%i
.470134272357630584586472741624e-4-602.153415379712770036064217486*%i
.831428280848110976276784982457e-4-346.539172864381771561016288599*%i
.148373374852956751918778870831e-3-197.643157132013554628041427148*%i
.267401108919598157108499094361e-3-111.619009742260135590203438099*%i
.487120754703361425326725886047e-3-62.3617509176722251192084781305*%i
.897874335036424287227341896824e-3-34.4318391724078616306588001532*%i
.167647268378888643526166001768e-2-18.7634550261933404172926472460*%i
.317499376286943650714504325342e-2-10.0749492427075069034627515356*%i
.610797207029228475913061770222e-2-5.31496453750039976080896707258*%i
.119562406300509296885736405266e-1-2.73518623334215837420571439755*%i
.238606733203183063385394888488e-1-1.33933319533463870638071534709*%i
.486566203935630426196736771200e-1-.554742398665175362903391001891*%i
.101651811524559121899467480007-.299500280392205418594362757112e-1*%i
.218244310260664963826517082210+.509426824317339389107062741473*%i
.483292857676385012557970745213+1.41298811013532446227317368656*%i
1.10868308112353411478174332479+3.37922871958133629516067441379*%i
2.64855754827101062272420463661+8.13742490837517424940960598483*%i
6.63110237427069675944169116469+20.4027638327437106960322081378*%i
17.5367579482258581464943562175+53.9704175645101533682521737741*%i
49.4728690679915894832690082634+152.261054129578449742551018462*%i
150.752318100795374612387737925+463.967668316236349232353025863*%i
504.283706806602174309519703935+1552.02558410302179024858173676*%i
1892.08821067301665657831218194+5823.24871575531205161914073623*%i
8200.31472895732269291747330202+25237.9736360485885017160210087*%i
42798.4664809507237988560462551+131720.135703818313049330082918*%i
286122.883481251932593942286288+880595.688099219060983095346134*%i
2700480.76382803266306878368007+8311225.18929197439130047097399*%i
42500406.6039984722341274799247+130802801.728380516260252078190*%i
1539538103.97994294270815421406+4738211077.47307386405427021965*%i
275916140580.660992102284705306+849182563506.033198432111975275*%i
3980967428207342.43788493097842+12252157915824645.3309147329041*%i
31732088995625033409150.5353852
72474090790847.4264243692887862
68776668038.0389515175932027479
900177284.607033915400894421259
37924142.8332412548621276739105
3099892.54412618880858493965966
388011.567928608189417519178501
65313.6565808603117653682208683
13662.2097859350715785444328714
3372.72648398389484191059761331
948.286682720771383456044218205
296.012148469616840586074276756
100.662859543475484683847266572
36.7586176312864483955760506465
14.2530567804669605087644272515
5.81640626254050263936020485457
2.48022267387405451999046802994
1.09869964289362451382788302512
.503181870967929275120951317521
.237290953147970087790598268895
.114835545508260172247117861418
.568671803671939336937269213124e-1
.287454789970786702078573599629e-1
.148006559173382136613130213883e-1
.774819029058943299845926351753e-2
.411751140473919479484137980658e-2
.221808653378084512783758225750e-2
.120975814367744863786486060897e-2
.667305529149474805186949229832e-3
.371911990616049338453725446677e-3
.209254183310887657734486585597e-3
.118766966524311518121532840609e-3
.679529542871045248363358858012e-4
.391693137737563980985370340226e-4
.227336260449931062547117631674e-4
.132788351976430828600205023175e-4
.780231755716609572741812613965e-5
.460979471062158942737422210350e-5
.273761187231159584238142016686e-5
.163360398950610813022642195048e-5
.979199881610157700461113301139e-6
.589416128263079569159865292991e-6
.356193046150472085962394144547e-6
.216051590089322281926190811831e-6
.131504990593759623664495002464e-6
.803066186058681070766148650852e-7
.491929812518563915803057700275e-7
.302219255044620418788009624963e-7
.186182283947672178619317255916e-7
.114997109341112938476662167412e-7
.712045204606926262555014921647e-8
.441920568976776215769604715510e-8
-6.90814931952200556949854830413+40.2010704641154132831323422050*%i
204.553546324502251116635821078+63.8159473275281188483700146134*%i
-7.30409212593403768053472250737-958.242597837231493597144490019*%i
-2059.08610177431211167781325261+2081.37111066283038407725297752*%i
4409.38645489868689010228626979-1610.03120082223496821586412227*%i
-3409.02651128454235554951481010-185.289972094572252224211751156*%i
906.516887676269328418194063615+854.500337322817943725743408371*%i
101.034917235572231124758246601-276.670825212081728227422786001*%i
-52.6321022385190446364496945385-22.2785735695269903344779987369*%i
-7.72280284187593982452837778991+7.17414100757911216293862928108*%i
-125.123389307082177974609391575-64.8763291808088103069389985530*%i
-657.968787471139157179971597751+977.149108894226480716697247471*%i
9621.57429812873086367883874505+662.736094318971502670315770794*%i
-53050.6327577857459920189549986-15392.3086504821270547283022477*%i
119686.237925683847247900066251-29600.5031693006285918625077401*%i
-47007.1429994544482881240317597+53715.8008060927773202283587661*%i
9853.97503711092208578561720203-10356.7338582176164454353573452*%i
-1803.02501601205961416101656372-148.254221507977595549707987043*%i
-18.5554565049412467884818235895+213.359788470027392590576497026*%i
23.4665142369394442040504741834+14.7332446579886267477238978353*%i
404.931890191324024151860171594-153.959120255530565761518378498*%i
-348.736361386880612128785920649-6373.16723664246081273410941916*%i
-111715.077082690442587144205762+68607.9591390324870503892387114*%i
1637409.03732864851538708836872-2163960.98575848629773388719394*%i
14694656.1865162199638265373733-402707.144372728214178772506196*%i
3726033.92011623461404062003551+2574056.88641102140980196700532*%i
-243282.401266929637460412767300+35255.9788356252054499129380742*%i
8709.46309227338412673049859095+7360.30789582687524083370331416*%i
559.104769986922843143269562017-456.371930206873732359895036336*%i
-.168576325851371906756507195459-63.6907873464348379665038784642*%i
-676.553872232406226561005462092+681.923622087523423589225455077*%i
-1174.28998673534180301474238908+23827.9088238139274143813957394*%i
1440912.48145470164118376713599+354801.828794929974535623874541*%i
-388620959.670592573569602487629-65520653.5772664661729853435900*%i
60184897155.4188668487179895609+45852767509.7315031513096337146*%i
-1376653787.24960868535114548603+389836497.577034538662302177340*%i
1900004.04489559957075126783450-3484043.76741186557665558860273*%i
-44469.4140195451724894001006132-22587.5169641895506817693395210*%i
-1625.32768517943413713102153880+594.445082749085840992480340148*%i
-74.9274886776123365274040344573+83.0987478119695351776303150531*%i
15.6832301288765592918642798125+1236.61504641778496654556314140*%i
-2761.63361794468123235859543131+37150.8234183162866993836050278*%i
-937192.894017394337299577441179+3707350.33136729339288930712735*%i
-4872425436.62296450710342838086+5307678636.70386359879421245523*%i
-98572857076334759116.2623033760-135808566882754359186.222827924*%i
20340677830.5537690353284453416-69962866088.6553003135353356815*%i
10103840.0837630608212401537001-7195665.41020485697163187257022*%i
75964.9450753662425059537469822-33310.7427904822774275966328020*%i
2177.30665237615880150145853571-709.790735625936061913435077041*%i
128.716170472306813678022947758-34.0490436404107580536361086969*%i
-177.296442191445610232336794481-831.780255551542413061862399411*%i
11818.5195189096143201503425089-15314.7756058974278077221871983*%i
759637.384787699963702592575360+612678.606785493685338922839646*%i
-75427859.6770463301438829087280-117356197.801069289787842746594*%i
6967726586.84454687684395422629-3095997702.64830523009090387572*%i
-253172156.979010305112961199613+311762475.941846330924101379240*%i
2411721.98368371385779278189424+236013.904303505250455281935393*%i
-13819.9281118802446420256993817+36828.6198922742351644326293607*%i
-1468.27157409729663042129946929+364.285197661359107767365036807*%i
-96.9723906416589186702357192040-34.1428079831149754497968882583*%i
230.429615231149388520631016937+266.844929441762067432179013959*%i
-2656.41770263784782932198573733+3780.88689132613929320747740923*%i
-31395.4370472261746416025571829-70232.9019664183369644439683059*%i
165805.924247150854244557985530+1122711.20474343191362543630747*%i
4688536.09024139400507449939402+405958.518050141470101429781986*%i
877950.697801317682634453815562-1523728.19112680528528428206336*%i
-122353.988857841704035464144682+59690.7091615937339104473650412*%i
2356.58968723517426145759555005-7633.43658080975176063665642614*%i
567.636629990832923397054932447+101.651625907528330821891546447*%i
23.7558436890126103168628503135+49.4380857225604718927507586744*%i
-110.139007332112844800279783908+7.78093946177869023874953161890*%i
-145.575094786509767952896779503-819.727216754099655526806192251*%i
5610.67035133754693425794421221+1831.97058234039349294172345876*%i
-28740.2964596005486928244889919+608.057207722539084374540051164*%i
56490.0830819386007518827240214+15587.9881400183707246412123437*%i
-29198.8107770194125508752047530-21279.8830631765399099440374670*%i
7654.53266248463591338831810127+3618.21924736396323085881495420*%i
-1095.51147656800311417561359884+594.298555034080475397033986394*%i
-78.7507136481748898521959681163-144.833048204396207469120103434*%i
13.3563257547570839895101334627-18.7170334175993739896536410488*%i
5.09375373180604495860231568461-31.3998535836306788992722529708*%i
154.628649859645343004672608955+1.59717114736620453327438970166*%i
-167.540482908156710780208753148+608.948447451232616706000833668*%i
-1031.26538635548900298425786561-1444.81646692510123661910518978*%i
2553.63591718083322095821841608+977.762860114203218283073583607*%i
-2007.72779813756223105255916646+382.398931732636293924519435545*%i
435.048293037951726662813551575-678.721916825211418871917329085*%i
127.369937631973036624586268559+165.555060769434101761884904073*%i
-32.7619500304389402277546624602+29.2940325509668454274973174675*%i
-7.89658043632648364627080623737-3.49468281805629327316237538834*%i
9.52829949529069059434814034169+.547210514271626369613430090578*%i
7.37857584477580069724133823137+32.8807965153829890283544156120*%i
-94.9208865618638532220775862856+21.9357702949304400097601015506*%i
3.68319618006172991614885652936-203.598163847743144674958273814*%i
249.437492165113063368886315251+113.422681682548790691576324361*%i
-168.914588182641367025066246369+147.895075855216409754217164688*%i
-48.6993029706509538770616603125-105.662216592106844145718433798*%i
39.4044925151529165859525487075-15.9396236649361250641805716107*%i
7.09995591703358856911319823219+10.1726012870883605851583711813*%i
-1.48213068460856044392550045177+2.84044359194881167350922440123*%i
.288021514053779580733073501765e-7-2373809.68754438640978720182258*%i
.470085922223562860008512764312e-7-1476830.11358625806296252602772*%i
.769531049108569930119925485454e-7-916179.783042154466231444749833*%i
.126371112597598849471381377364e-6-566656.097892747862387588007452*%i
.208220982319152342376564832952e-6-349352.633478503370616007753309*%i
.344306450360325766074529473932e-6-214646.614281044101614815403115*%i
.571486769034651615257091296194e-6-131401.996643726812427131446443*%i
.952384035349308303238859542580e-6-80129.3593959526922881235750240*%i
.159395685954992713085745550736e-5-48660.6247787356804369201191255*%i
.267992875549465523538844369696e-5-29419.4204912545949007020744070*%i
.452779838299428436098861858561e-5-17702.0480284993252657712031932*%i
.768980787811327753564511593108e-5-10597.3070847938415829044606138*%i
.131331804381707511173778753008e-4-6309.36029981242378258395533852*%i
.225645918860786950115731064901e-4-3734.32373752680790578610976418*%i
.390196174204794108369814164893e-4-2196.22215603143397689883139869*%i
.679440153003187578367140180704e-4-1282.79892145897257955535886520*%i
.119198107606834660570383518877e-3-743.731374451092729106555253815*%i
.210814426915507057945900489905e-3-427.739874070108282832901987886*%i
.376128407305650247981324734472e-3-243.865590185688877888401958327*%i
.677488837230510108205512416932e-3-137.719481109533405743497036668*%i
.123299691431943675196651025876e-2-76.9736519724033625419669482077*%i
.226946468216751893682753639688e-2-42.5376447934490719345119262004*%i
.422907426081714255389363446660e-2-23.2177504600608070180877360214*%i
.798814518064702946381642126276e-2-12.5012207421629910031738341467*%i
.153148665210871466590827349359e-1-6.63086054239779179665931021378*%i
.298481094268362223938639912431e-1-3.45930760114583294370172780527*%i
.592411386076299478496426687197e-1-1.77185775929006995824119358137*%i
.119981703489801394379903667471-.889182268142836102559213931688*%i
.248549268464602090866920653906-.436151101777548425002855693931*%i
.528085767710520456902550518369-.208526020782230879678911906043*%i
1.15447545588194275180136228128-.968606089342270511815632577515e-1*%i
2.60675386301815681679641548777-.435441797866102369938463892913e-1*%i
6.10679001852072521062368106340-.188592525139590086103606559612e-1*%i
14.9239950388762709004834839794-.782610678288788598341168063062e-2*%i
38.2991507479322328707136188204-.309098793993950582698002826100e-2*%i
104.055215260709199875502850298-.115243319070913222889992501730e-2*%i
302.365017720414313654727962839-.401470507279281972571826872855e-3*%i
951.946335434592204228540466299-.128992755398714904037483516856e-3*%i
3302.11642343844409997273583854-.375871696346878207311247471167e-4*%i
12904.5542378369644030285440958-.971359069109501289656206015475e-5*%i
58570.6008066567700492159247041-.215946508188800102073907982677e-5*%i
322343.881559395033401689801330-.395547398628715559267885064632e-6*%i
2293043.17462846133146520581367-.559970536131791785954832454011e-7*%i
23316233.0280711719845263349249-.554020780437093256479089628236e-8*%i
402583572.799875706502126668906-.322452393628276073956754681389e-9*%i
16474750116.3030403359756758535-.790961839839447071378571231075e-11*%i
3526587225571.77939440263380601-.370489869954070091077135740873e-13*%i
70741672992130654.1751074516408-.184972798177103816924683319779e-17*%i
289398055113728958040306.055628
332949783210192.083184813782430
248784324759.847987238686835903
2808240436.54564522732164231070
106289654.923126968114767852573
7990057.85213724843386476959910
933868.865797609162232264935732
148368.594591351923133417211392
29527.3799539133696014176380830
6978.14660200348901186704292072
1887.56691089340818100805275228
569.160023979642510879448596180
187.595744273696929015615920406
66.5862166497631726052731574168
25.1577025036870706966695527826
10.0249106313303984029060515021
4.18204846168594252412692263015
1.81536716395622542878563980131
.815891228235306420058361675064
.378074477263221730665008799880
.179999289003877274601140176373
.877837293355805588471780933609e-1
.437417511954110637170855616046e-1
.222208420268748568717414599083e-1
.114862488985157883624181464628e-1
.603152714348915719791010974915e-2
.321274008374781281363427291619e-2
.173367296349961932249484561843e-2
.946696924059753225941184873656e-3
.522602499563448988857961066635e-3
.291380931424316789054756596020e-3
.163958421789259916385034287914e-3
.930420182562500566087598574875e-4
.532130999762499685494792797012e-4
.306549645433473588053319516061e-4
.177786537574157126304815824076e-4
.103754524130830129723282507476e-4
.609029799622090162288362786751e-5
.359437474423248111112040556013e-5
.213209418142000295131522260304e-5
.127070830832653338129305530120e-5
.760697459382521443812726110315e-6
.457283498148554372866530746281e-6
.275966925557760426920661653727e-6
.167157407688811274612311098038e-6
.101601069379950514458018439735e-6
.619568100129353964660635123980e-7
.378981858237035539545502083634e-7
.232494516811896627808450376329e-7
.143022235857129245727280875038e-7
.882119535837849830681836642544e-8
.545412696754401166710453921861e-8
-65.0562945179502303856200850025+29.1755598799009646383245968101*%i
134.188996300001371608959362424+367.499901689035046269317159978*%i
1349.79524036024025203998806596-1225.95929622903251182743969822*%i
-5745.85444185920320506354427002+254.655214520856349150243730473*%i
8960.45151229586047967091492934+2666.42573478137034514295577359*%i
-5615.85729019532341643971210941-3720.84774488651219089938799252*%i
889.741030992876258941985714690+2216.19576509141763456545199726*%i
350.501417894716648250606962779-413.999232799867611665761592910*%i
-77.7796012411758237868729814245-64.0625402015966930226428615148*%i
-15.5461612550816314896155800079+8.69068668187056954803243823550*%i
-16.3442920910602925497906041609-258.946687693330735321538398330*%i
-2304.38082754993538315931322384+16.5664107610262233292272045119*%i
11549.4499545063117032016076533+16444.6305360227253553005675717*%i
-59242.8080680104437256704320832-106087.403582998774483683658452*%i
256205.902049525820626119658743+108377.815283096658478277184889*%i
-148762.360338386500594951201932+54082.7909814643339407080717537*%i
27482.6564808863324082312323560-12395.8648407360844040895436968*%i
-3325.88237297193976027661343273-1335.58983467421007654340931678*%i
-127.066338889427700296809995521+378.121636735054079474667199210*%i
35.6195468797182719072188082028+33.3660704710458716738261059783*%i
620.677632011262946539796948446+557.560861767927836326096925018*%i
11155.9302839491904014661143253-7294.83245457514818929268118981*%i
-275197.377470433510917922082109-122403.740969962805204072310831*%i
6860012.16783078498328462163090-557942.409175593374600614825470*%i
32045070.6148470558137530546782+22988152.7077219651109093913571*%i
5783351.89959565352696330184843+10150765.2097760421844633449911*%i
-568600.691398341894493728093630-94129.6523541380784185192769261*%i
14601.1554226664531028855472139+19356.4331004715385321718625356*%i
1228.03382947480811109123250594-694.874120253624485508516998442*%i
15.2204873680725074214921388876-115.130456568334182755684101657*%i
-1767.84293946085345768582984606-719.511942972337867001870255610*%i
-48744.9263395189074546521721863+19099.6523781707132756608883341*%i
854343.847571495579771780529146+3623872.30668722405775257872451*%i
-485881906.786252280969292049897-1088811141.36467930057719413983*%i
66956304232.4498675045707968263+265533850438.396869981472050796*%i
-4519305786.51274549335931888852-166466176.107190569441817290232*%i
6414753.91370272351413961191281-8041545.55971746873035208779934*%i
-93353.9416271150523821489151017-61979.9278887217937633437658267*%i
-3377.86845961662308987780633339+917.998534342140702583172824143*%i
-149.722462293858342957962214116+145.439794682055615669942659563*%i
2362.69391558907304024790031811+758.409238901912640977727056118*%i
76529.1145386114496413773359275+32424.5741109312534250778632178*%i
8299527.42891523384878108149181+5442919.61153015543679219321660*%i
11096052682.5414204533020040559+21423702914.2237613873965225018*%i
-1277337454848004199999.91666667-580607973120000599.999988095238*%i
62468141833.3824791699497365629-256571194259.819484291031920293*%i
26866455.2205672573611706819123-19985039.0144344456097146602665*%i
172860.815274444409759193173920-78560.9931366642462296445576853*%i
4437.22349568326896970745982376-1494.03717513794943990737847643*%i
241.318755531729212162287457644-65.7614431194087255831801837199*%i
-1647.64292489260466137564623982-337.507486125117633076165573403*%i
-19019.9560858441589522427252373-37582.3910354095793683472866490*%i
2231927.18517164997242657564335-914277.154931597597699251801979*%i
-406322265.970007773905703387431-22369783.7169081300786905244037*%i
11943767195.3226376856568451348-22506419770.5606928734367708685*%i
-393139065.452004982463199611978+1148771444.84400803134337345365*%i
6134931.57466769725772487537820-670411.839280820586011263078129*%i
-19046.1152162155787067257636679+85505.9113014696547461707279336*%i
-2863.08243429903745748815339234+1033.69859984013196870607835468*%i
-184.802499133469948886216214449-48.7950403450143693891079436521*%i
656.922224670044079558339357265-148.480050209179337020288332493*%i
3858.18787670225048723156672812+8715.89004003280861264721790455*%i
-169833.582641138793330422391870-34496.8263316789481052070156472*%i
2304148.24651906866425275467917+1572272.71579643835582811173443*%i
10262302.3543140208669197430871-6453321.14214385854327659042107*%i
261600.185703342880871699205363-4377261.84743061481915743524401*%i
-221791.820619840379982138159097+219915.648313021448382289246401*%i
985.884667340276011729173915023-16730.3454874791977657561839519*%i
1117.47880084996419858304158225-8.27285108404409454676171308813*%i
55.6735035191076564651182998039+82.3452705145074645252190713975*%i
-93.3016555664245336990955648882+178.295217070197112701301395065*%i
-1455.95867633997544206467404239-678.705572178645932479694447057*%i
10208.8880438701804250320255098-6435.28257904182344899598200748*%i
-43334.6101968605560898301348024+43918.9774182710551262778061361*%i
119782.141101174545834532638091-46810.5851697701324312459918302*%i
-77541.9223353322449474048686747-9319.30353209907079952343491382*%i
17484.9119158445502340169257723+764.933380566989899026941758704*%i
-1679.24032685621109310212803696+1760.78107202383179129829144656*%i
-206.406766403200637931531806016-222.919736885029590369647384294*%i
16.2911221219580752216071199105-36.7332704588736676722964465966*%i
-39.8388960118474631757855012863-37.9334213654887682769050650812*%i
173.209122461544131044265962924-218.093535829831599510406567598*%i
632.899577872560970573235735452+997.671669631987519719799245066*%i
-3343.37196435185305649143231103-709.035272986271796156226342814*%i
5132.04575070171947231602285624-1438.07788430294928372271865066*%i
-2962.66813152963394758357829484+2613.72917831716707153215249437*%i
196.819464827624820386142656710-1505.50303060745908648210295647*%i
322.420398919377530278270404860+199.630013365570273904805743699*%i
-39.6680974399820609162869822006+65.5484972264337874404454823931*%i
-14.2546354568341230413749104126-2.44381583667737803428181125225*%i
9.97626184868345514663153016337-12.0214547853068759868635386523*%i
50.5465446802428903629964690144+25.8839166718730947733335120989*%i
-86.1286109448629168471405905380+144.501735815489582326009488393*%i
-232.411924831202068823855732401-272.016488400354876613523421385*%i
474.153670474533930993104132622-101.305206915548143599904815115*%i
-117.955900435843434335638854780+377.377181088125135756169576696*%i
-157.745584359971018353195620687-125.751745548517680431649862794*%i
51.3178575979660615509224201416-50.5084422787204172687806256053*%i
16.5189268899030514175780924228+12.0413771595935319916643079065*%i
-1.01949773554962597324895116129+5.02590659905579713938899181584*%i
.112115930042407270703917098865e-7-1867252.67802222173437738989085*%i
.183788166230978727143033241045e-7-1156291.73094503441863070677555*%i
.302228127658306151426229522014e-7-713874.432073332353206496546553*%i
.498654094573507054257992949804e-7-439324.474867492656254260442050*%i
.825652877412529302246284103907e-7-269445.322067746557737977022593*%i
.137221654488583574586063683599e-6-164658.007917367406822889358543*%i
.228968653472032121795142472931e-6-100234.983535134983933549121924*%i
.383678421593475437818005183734e-6-60767.1015304492044319765798979*%i
.645826563583588603621645480010e-6-36678.2961863186960448190455252*%i
.109232370990244383841601421297e-5-22034.7978766956772739041443560*%i
.185701408017007909229960529669e-5-13171.1611773006622563497719663*%i
.317440201309731160362496021623e-5-7830.62581816005912577160268935*%i
.545834102412494608969783589066e-5-4628.64213484068078663021487869*%i
.944489005438151449604979249394e-5-2718.97952293322026859303935478*%i
.164541156276389265246582399689e-4-1586.51811916717333061120786346*%i
.288747497563580401669775048148e-4-919.054315119137215735602832028*%i
.510712019458472053707947434934e-4-528.251333196080393226583308005*%i
.911009374445875036324986570697e-4-301.066449707499996716685467289*%i
.164007461103725896739800453394e-3-170.017955989356841158249806656*%i
.298220909176351897177347525098e-3-95.0586878909202142904596293239*%i
.548183292809773480075107862078e-3-52.5739027223191754791535157609*%i
.101965214522202538378005667085e-2-28.7350666480272555617412738413*%i
.192129993252129980674683545222e-2-15.5056557825393120992733418560*%i
.367193705492537512989177902592e-2-8.25427939467720345315497662369*%i
.712794593784453854486400081489e-2-4.33732131492602342724948179864*%i
.140766622584057417034294395536e-1-2.26366643628790646444627823739*%i
.283333885989221289408012573459e-1-1.20786254667547455105583383275*%i
.582475822045746999181980477840e-1-.732936465293954263210295561994*%i
.122602251629514004280711729548-.644428618173175531302725292016*%i
.264968657837157475289197569762-.940943149964963936401706485235*%i
.589946502848343052390492527813-1.87284581654811421742654752430*%i
1.35850459756529666415671604295-4.20623341866617933704716387924*%i
3.25068394707683304714603943833-10.0152484829986547180055097904*%i
8.12831984027319588348759110761-25.0207213583092644284804104647*%i
21.3852817740317969974439507862-65.8187947689494545694952589035*%i
59.7009626168687416859239670521-183.741273572582093173430823803*%i
178.721580844348639017619752236-550.048671132931686108710515841*%i
581.456162012393613443948475336-1789.53812081171668130643033111*%i
2091.88234333855395878826413093-6438.15186760139942833717219368*%i
8516.06859489878456951344124196-26209.7641203886262000911459463*%i
40484.1928124334008235798336676-124597.533735591274186474315458*%i
234976.168836806594073958189947-723182.286457715002408206428402*%i
1778833.47370526967957716666129-5474686.49739899911451036334631*%i
19488683.4103369352376783802968-59980000.0932144612671549795678*%i
369200091.172234346868855628308-1136281042.52438825317662372471*%i
17069393205.2952264422624264682-52534190457.5082488850786215232*%i
4364382257940.83733699466265487-13432187425204.2754328849336487*%i
121720536282136565.670585158952-374617290651674833.496204248578*%i
2676283496137962172000059.53371
1550986256945540.36989155621000
912479579776.629698900465103156
8882502333.38791503066326220607
302015638.943648947293631459948
20877434.3593549316719597711436
2278266.68858552209832063990607
341589.352010021178403832314885
64668.7058874694134701471911536
14628.5055695658393785066378746
3806.24649982801982370749769070
1108.45490042767134858843243628
354.045470550811841043638405589
122.127266675407481793375391856
44.9526867054612960874902287459
17.4881919670567166169193159389
7.13578562518504823017926385564
3.03472455216734934334073340708
1.33820747813618699677985443197
.609217024309075834941919368634
.285284776883524255158754338553
.136991975312946846981423039852
.672771734295248752703807738288e-1
.337133700173583113816855937124e-1
.172042819198661791549043957643e-1
.892523545769878427290059026800e-2
.469995308399775964521881395101e-2
.250887475819654822393929309199e-2
.135601431145877349487705354098e-2
.741302222220001628088734859810e-3
.409512990870693490436486021418e-3
.228412603183077768911286343211e-3
.128537102292213714810087943073e-3
.729292485344049741273180319306e-4
.416943421223108534730687209130e-4
.240058568593204430641438001987e-4
.139125510660592705116077270371e-4
.811241682459893713885008618631e-5
.475739925962242025101824430011e-5
.280480258978126058459702831443e-5
.166188035077647224136457931252e-5
.989294978879673523806692413426e-6
.591500982326659304224547373775e-6
.355118921368591889842215890239e-6
.214030150500922753267583173687e-6
.129467634208779626568766776300e-6
.785854781354981586602458694167e-7
.478558092149095544987876665718e-7
.292321567876221694192010158514e-7
.179080790048674659963513495351e-7
.110010029482589706701271328272e-7
.677561189515650889968331677167e-8
-107.300649114301970547566984964-66.6269379870121942342795163427*%i
-388.865763338295745276680620039+611.151044416378489325435126289*%i
3501.74264971071649639061960572+360.412234443283841821011985094*%i
-8758.92329084501553387328335345-7400.87994771513603287058961654*%i
11321.2384934384381404484570809+15132.9630678727895862839896705*%i
-5920.05572110150146061598233585-12123.4407464901138614314042656*%i
-243.418437693620196405460182643+4638.68673980449579705106855589*%i
882.040050161251434418848393880-498.504200771685254307273317469*%i
-100.413102014241901716085472866-149.483261940981771637981144068*%i
-29.3890364370485785457318192342+8.10232844042475940625192791649*%i
397.923492528819635144270362562-275.544235417539564085169891083*%i
-2610.72005069485766268490131538-3751.00982078159913371045032928*%i
-11600.0405251793169093194004873+40849.3462014091914496684321391*%i
72162.5175791704267626008326656-261363.944185310948817267270712*%i
320835.334122412438311276809792+550078.745166533916275286031976*%i
-351834.208561427821486230704452-54926.6080449740791638621892421*%i
64445.9776128985563572408556516-2351.17759171135938872033604775*%i
-5585.52032371915337551794719199-4541.60221271005358740380091478*%i
-401.769273083235754708883007891+636.813479268940177999865856048*%i
50.9220516433413483999217650619+70.6378750711627743624917915906*%i
-411.491499211353490851813724467+1575.20326389356511930394381007*%i
25198.6766630289688136582830781+12692.3019367905944482171463465*%i
-128024.976550725264391660944944-689818.438762856199070637982244*%i
12826456.1090396754373402103914+12202414.3409547332813201979864*%i
31593865.7081060883400430815181+102553600.180606822598167785219*%i
2116068.56379252521108335318878+30491659.0580759646910323423135*%i
-1220033.47932298275827257780880-623524.408506220054577268939885*%i
21440.5816578094101609412112715+47657.5523630632345010726595254*%i
2630.96329185394533915357521002-944.079678234784388131636435410*%i
56.4551005609621975457007254723-206.903394204540079516001313289*%i
-33.6212264902184681156329561614-3841.97898998446736332033458570*%i
-83236.6205281556708012194350468-81421.1463270403203427391336054*%i
-7214510.79649262642912119640536+6134901.42304424805566285056286*%i
1955805433.49184816841460728704-3090715419.79249560208504413573*%i
-415067824212.988616939873367544+915358984822.647910121223262976*%i
-13617103691.2722332555557144261-4965774741.39026794461261783531*%i
20266713.4628406908707736462457-17889800.9659962865610310975360*%i
-194744.270614110218451695274937-164868.401130902452232466937439*%i
-7057.77999867353408812080717422+1282.44394823619620684863241005*%i
-300.525595189481466453421405446+255.359998347954069332515197979*%i
2987.69035484652193636606465170-4064.05762970619519223606156104*%i
124953.702877949590917554068318-140371.755695089528803349956364*%i
20670589.2061274988690832119238-15959236.6020935056055641111963*%i
81249936753.5856991123804691126-10427599769.4035977885242180677*%i
-5798439595501178649457.97418104+7973510831104447001035.61232569*%i
187754043874.118865407644823743-952078336370.052109855576115990*%i
72374477.7608928609203181487929-56205110.9136105934877179013820*%i
398577.956797396310752154516200-187603.414770848791533781701528*%i
9160.80153151512261966474810217-3183.64178263814543985687645916*%i
458.164194973083545057200841472-128.546373360325734771682817364*%i
-1942.88437276455402752851707236+2753.11328520189578923813968239*%i
-92928.2338207112088333666336761+2146.96425791449469931173864347*%i
692084.115703575839859908878045-6003456.41518320793694839199960*%i
-758148408.300210763658924161458+934878727.347498924429054358275*%i
-15191854220.6686674504204763321-84996232600.8955617548014810461*%i
84531072.6319929821911662564927+3721324723.75857612350025085523*%i
15148575.4304152918209212422229-4944285.45290689732939947313209*%i
-15604.9419299771482017572402314+197118.739874045132146764738662*%i
-5587.52187488230760371463598816+2700.39582022027469082468520671*%i
-354.252327392050933967390070290-63.4681703618480489384919325842*%i
345.916466864671894229129000722-1256.80648746514039628509910757*%i
19772.7652615447215304242930072+2496.31440461776559986762967749*%i
-289880.331354270352701968634427+269567.814858881167747791782950*%i
6776333.10924986166827338039134-1560179.05309717876015123631739*%i
11209551.8153083085353820652224-29623825.0152706048841706271438*%i
-4355162.90769399513206906514261-10198976.8596685218307482380410*%i
-323821.380718211951116097712517+650492.557331600677789755900624*%i
-6464.91223085875859734672648015-35048.9466112964468558801863161*%i
2153.72817703113114180674783558-420.562673497484758192763136461*%i
123.292412298955809832411690871+134.484162205356933348511042492*%i
189.391128726243752913007845345+319.776895147046756217157383994*%i
-2724.66955390690168656724790064+1565.44305542183857301993149092*%i
3272.57459190767228196651672483-24811.3357974787510097964853358*%i
-1104.96403105972542872754802073+134343.183112522229563178687557*%i
151260.402359877021478741899235-243150.201410486393535288167499*%i
-158356.450052837429969037611681+65269.6456745358424542876487157*%i
34409.4704627384465456355667817-12751.4392786059211911483872761*%i
-2088.75661619644269906416934085+4339.79204896115106748178971088*%i
-476.580948640691402066416191574-307.902785810413118133466114362*%i
15.0808635887003667248292009029-69.5157725862472758382899188811*%i
-94.3385400385224797326016346952+19.8959342636611216704893584682*%i
-119.492585937695424544489939521-494.462163051953119944934073239*%i
2209.15269380929306127141576763+385.835906199328292544735543913*%i
-5755.31299318681604353962331424+3389.50557315030807088504553282*%i
6455.68791742920906641323731075-8339.14350452148240947886684186*%i
-2384.25078589914387362984189679+7376.54711094772061760752959302*%i
-888.347894892663133490345419665-2762.32604300143639432682619686*%i
685.415515604565054397205665226+133.379550169832199195748991915*%i
-32.8873976387907435604277007277+131.339373881658016133752326955*%i
-24.4616570436975010675859997625+1.93861548361392854204168063648*%i
-6.18573620490635849937136522144-25.1874413764604605410924903914*%i
89.3710741513528545415805297249-37.9165153857670284883423081461*%i
77.7832835953815689794466770592+284.451863739559414743950101657*%i
-632.311292497926810414654721908-88.8766150746712488941874636325*%i
576.810525348194797341820010368-653.498207315243793916568956609*%i
172.668019427831286071179304009+685.922552057983725702285520653*%i
-347.688706786192825049077056774-72.4688110536960130148310167742*%i
47.9788328558791834609800569562-114.081901118723423059682664191*%i
32.6698789642455870087300627453+9.95634872755974688272107423057*%i
.692378845218029506642931439491+8.28772758081815953517533166309*%i
-.372281198709038957344138899835e-7-1458602.09980240140130178072058*%i
-.613006026667720109902895275529e-7-898950.946124744039643190207847*%i
-.101273821649016827624380434076e-6-552266.615191043176961914739851*%i
-.167900673905127935750427934682e-6-338135.061884406063355368520135*%i
-.279396584032812322629320937708e-6-206285.339733133205065643158094*%i
-.466768035823477212232201019643e-6-125367.176540582784079220347574*%i
-.783066268532462888093298080344e-6-75880.2761178356487583724445048*%i
-.131955736383355392711725272646e-5-45728.4623293576775652436848699*%i
-.223416489789840914618446728548e-5-27430.2529914069495070933502781*%i
-.380185174638734236754416057322e-5-16372.6937674383282048440461658*%i
-.650453341074917711071762350278e-5-9720.90310934758178539207486209*%i
-.111928260740030056981518972070e-4-5738.84234460354485934708330876*%i
-.193795111641603587705965168639e-4-3367.38376741776059015530491226*%i
-.337768539047151390020491578964e-4-1962.96937344484043532858207084*%i
-.592900600383600730933533381394e-4-1136.23809029146343288832882697*%i
-.104873431916610908435493615913e-3-652.710057990257240180607200403*%i
-.187037605367956664030007556676e-3-371.879051174744408813088082160*%i
-.336557195368448379878697138467e-3-210.000690629391255851813218389*%i
-.611467573754902348921722370602e-3-117.449922470780414419457031196*%i
-.112260420124959968204193116490e-2-65.0036616848096103475560695281*%i
-.208455758440838002082318142691e-2-35.5695819149076827108076860820*%i
-.391902430398950055092408221561e-2-19.2241450665062134204511911131*%i
-.746821187229114847120313249069e-2-10.2523101590311313242959663850*%i
-.144441372767457512640913947215e-1-5.39213890696367022302582176084*%i
-.283948298569595762188811616891e-1-2.80100949581954544073482819388*%i
-.568308054257428053755336548841e-1-1.45194904650756319505494000027*%i
-.116025457397372305807547821289-.785796743453128241176351689352*%i
-.242158365889373751034451744366-.517094536006803333404127584864*%i
-.517991452617152722565636621669-.538182221641967462168273604851*%i
-1.13894420712814652145633533551-.902157592965056078700293805000*%i
-2.58308155157073273543279483536-1.91010395143547093395354537527*%i
-6.06735017911276283327970539626-4.42259556338023427949501238634*%i
-14.8317354909551369102683082389-10.7818584320802111185748268274*%i
-37.9532930416201868794613955987-27.5770449392675475378458328179*%i
-102.388181600562048257921388610-74.3902550846841205989340574345*%i
-293.752730618753011006165834882-213.424164197420881581376269018*%i
-906.102192241416570710945627585-658.321879867558961898843278012*%i
-3046.80659872254195051573051710-2213.63459937225839331679753779*%i
-11370.2675333930963618118695692-8260.98292613919995559966874708*%i
-48226.4097111245158917769336259-35038.5376301240798570406905746*%i
-240158.166765147448637725793980-174485.121603084337816927372443*%i
-1470230.71825055457503055340831-1068185.14278896137854318448248*%i
-11845709.9044571468913388154730-8606412.02000244570960434227412*%i
-139845508.200949401542797393091-101603709.058512206711159451765*%i
-2906978871.73797646972039977686-2112043778.33068115998099830661*%i
-151850742059.728447860616234233-110326022015.565088003493120627*%i
-46377603579823.8392330889599993-33695301347715.6869919706604686*%i
-1798373206967993087.40816777389-1306594616087633786.37207521630*%i
25084494611562149500881789.8628
7322649123112997.36174421941970
3391883144209.58916239850603256
28472975693.7870974142291164469
869632782.504193492512821007743
55276040.9059028445993958414577
5631367.04568501765790860256211
796726.437895416568276734759617
143467.131363899103814639950890
31059.2008128311316206534576394
7772.46845688368973861076598347
2185.75963577182527649475557124
676.434581707230208550649411018
226.724715248762964798720926514
81.2874065291609252273674991704
30.8684989759094621493305865641
12.3175030168298637536124390988
5.13125119689944241303802002603
2.21964917353145208788183539986
.992559799127185147652827872067
.457084756857472942792008750547
.216076350703559453960065799664
.104566250096838281621506390472
.516794638813720654493847456413e-1
.260310628672937439447600912265e-1
.133392980596841387301539019922e-1
.694316319617568367916100200224e-2
.366575102639070576409202379877e-2
.196072788986143477730100613342e-2
.106132356376617291307407779060e-2
.580808920282660695307860075279e-3
.321068156972438646498644823662e-3
.179143886217567185770689229601e-3
.100819320414270600306827595733e-3
.571937415676185420872802329306e-4
.326864935516241691206673599860e-4
.188095522835924827618096736676e-4
.108936787132993568461642199112e-4
.634702940439029270138327940602e-5
.371874472181495590442582920638e-5
.219026503932321551266982874709e-5
.129636986883832684182905151925e-5
.770836524425013615463802611185e-6
.460337509124562686781867528552e-6
.276032512592983636544871793533e-6
.166154277354050398770066547205e-6
.100377315744487713773421643960e-6
.608477841288904271046152631500e-7
.370047820647314439957376930118e-7
.225735258205298756132155371014e-7
.138101781986217236600544528799e-7
.847212246410513636604397028569e-8
-8.94584707632303704952122857875-226.494438107903308936532825689*%i
-1354.11403293108969835985257604+120.448288547881032876369774888*%i
4056.31240472134997389741900695+5571.19410136397039209258327994*%i
-2867.25011168314619464119787602-23012.1118458247696894935540443*%i
119.369071185978924425067021012+38758.1144470272738781889929607*%i
2124.70563251198149018268158697-27326.1411596036087125507190456*%i
-4292.38219394452126307777933259+8094.84113939907970894242735324*%i
1894.01830895551142073151817114-304.227880137823301915715992427*%i
-96.2459458819862342084934654638-311.540270988420482423075214893*%i
-52.8234417273863478162325166288+1.40225807536247237247719494337*%i
834.556837045244328345569852987+374.108830773910769263517184194*%i
3243.71549193105424551786585510-8592.48129261460463302080415745*%i
-83575.1103390237287383528724560+35910.5048021356898117390375530*%i
531437.927754220414559764426339-306476.068725939314284067567159*%i
-168950.299071929771596087794717+1468488.08814344080055266724560*%i
-642320.668731881438909688972276-497212.397742897853009898935767*%i
131293.324498358444357674919137+48137.1420436505264359733640703*%i
-8109.03521397664501858485751922-12205.7611801579064081543826912*%i
-1035.41473625086263225905444337+1000.44636402742299523886203294*%i
65.5712052355020490999169288051+142.998304276706434834968693588*%i
-3138.91571576325929578358235186+707.018206636258307365462581245*%i
3572.95886914529503120316145629+60404.3145384533798160214216999*%i
1170552.30558876419679149999811-1171828.54805429806337884178760*%i
-1433710.82291748970330953389641+46136802.5051920204825082242820*%i
-101718497.716534733503220152807+277972520.087904432223404782766*%i
-30028806.9353360466316062622108+75292982.4901170258243194681745*%i
-2343957.05271661970928766402475-2324647.38159731891914914485476*%i
22527.7958474275932506726708020+111880.353032562969314251619949*%i
5524.56744626879511165406755212-967.884123510698024542772404988*%i
156.927052982984083113191444855-369.023827220669739409643449329*%i
7200.96830858917276804229651029-3081.54677173640180533692220186*%i
90235.8852609740760920138810847-246343.355703547059105025656156*%i
-22551199.8995557929320274847146-9341754.52545133835789882653118*%i
11368629935.7635429236262783469-259183037.190333287007944605130*%i
-3329458618583.48012531819259048+1701159755211.07091286847031507*%i
-37118864436.5308652381647471331-28965493581.0300465581361734733*%i
61422729.2088163784848417144478-37551616.1633296819025011139460*%i
-401944.135486951831224253782262-430057.310523795265995864308961*%i
-14823.0052265970851114574978700+1394.71281744470646650819131249*%i
-606.215564823986807245776411096+448.912199822141274366851782980*%i
-5978.19443812249856740680506310-8489.93406333138416955410021760*%i
-212700.927453484791411028009553-374245.030992337259836623591001*%i
-22205009.6810339476874340782337-65989601.5763439784699360128092*%i
62233040872.8930495700891322517-274916310005.782285342107438221*%i
23801680428446665630338.0634207+73359794217684852442148.7418710*%i
542168321468.715459470158526011-3573368072959.53364969763920162*%i
197427903.728819944787369096905-159998101.721487738052292403440*%i
930849.808723140560308504951699-453443.070406457496978753216571*%i
19152.1306038116748576260778942-6865.36003178834791499719572323*%i
880.582068125225415372825355002-254.228490764561980209677019124*%i
3534.86050258443162014586564864+5852.42101821833040177658856071*%i
-85237.5225808002729651023150247+189526.739919017584078610757279*%i
-12500672.1983417308789775092119-8897441.05448345444523186308124*%i
937715601.841616585129471443902+3484412203.51255963606711677343*%i
-221162259568.386606249233075995-197596057967.909590249380956577*%i
4239119186.19070540896045019880+10761100048.9766149073535921506*%i
36136194.1794673219997851673347-20802780.8941916874472670781091*%i
27783.9684017652578439936139670+451342.958723614605595912086390*%i
-10895.5213184800414530925357934+6744.58405021715711639632001238*%i
-682.906683555822510055271976417-65.7417032715571759178196918171*%i
-1851.77927711033881906880090362-1760.88230466997661809658206269*%i
26170.9780908100518422484625470-33131.6155067795841630121806044*%i
116375.132526418622913513611465+908977.652624497268012946035042*%i
8725969.92559084874728089218310-15251800.6500018535233555695778*%i
-23662712.7747739029639496166334-80489970.7764725186538281415956*%i
-21677268.0536065773548530099313-18397140.3900331277391965693537*%i
-228410.581340868130155936213782+1698098.29922524192745111016151*%i
-31615.3015304877794846500219001-69988.0252841178386991908526513*%i
4054.84232369947712870237674062-1615.09147288533741385685254479*%i
263.554296544177367497713892308+213.309404695384277475172970862*%i
695.154408163134917677145347357+14.2398204585011301520855168829*%i
-576.156610468221128340011439769+6202.66566064438734068895525139*%i
-35682.4361789253765934230552933-38663.6986631275906617945098942*%i
204751.616221480929529970968866+214634.537093083014283830297397*%i
-55029.5793378611563938805946509-644270.411856470603584598254085*%i
-236218.364567423651583265634550+298810.555094925731919360221992*%i
56852.2647368382235584547969870-53409.5957805285529428214796961*%i
-1295.52553716093320816883567813+9574.86034062452033844675966921*%i
-1018.26953888184292845201081249-339.916086765234009572810657662*%i
1.08456116762977477937186351005-127.497394018952550401944027555*%i
-66.0222045803209827432525671094+157.955072108032605045268205666*%i
-857.342324838086009695075687703-389.913341954431029781515880104*%i
3414.02568340047176249414236233-2641.84722485222762407883048610*%i
-3887.19023130117627868478248293+12658.3561982338112672893097750*%i
423.776003991962517413882144906-21167.2134668221745568886194444*%i
3415.15572747275896165852652675+15049.2667596293322601837362450*%i
-3847.15863679381377711930326842-4102.44901542075641727162580524*%i
1284.36833635554212983480989490-222.315889057891438052131590370*%i
13.3695853383233054814941182241+242.065436618071762798697444624*%i
-39.8899301756522202660192815650+13.6546227649411788737436278605*%i
-40.2239257083338924310885974670-16.9454334069307538917647978545*%i
49.2591657244286818102237701275-160.917523423970557995681861690*%i
460.055312719776704848917646926+251.923926124061868479342069362*%i
-965.308093658536546498126138921+637.384299143104509276328994959*%i
136.765282976853830355472350764-1585.05809308678852001273574759*%i
918.686744823678354657111225950+897.798118576517400251873562877*%i
-612.588109321183293601338998425+165.242539267918057814917395387*%i
.200446630083710492146602934452-215.728809965255337039378351999*%i
57.7843987423449582637910300803-2.34317484725481652772236666542*%i
4.93056671083841261660588500103+12.7392649529007045649061161880*%i
-.475381686406504010837946561827e-7-1131558.71930978614788566589915*%i
-.786364408011606543158667349277e-7-694012.956530720703923562176658*%i
-.130531961596416631504761223097e-6-424223.116810339900964022054636*%i
-.217475034977298310232088586467e-6-258385.548500234673300299899793*%i
-.363744415765636486698326508979e-6-156780.835257610716658987734563*%i
-.610914068050945920933193575297e-6-94746.7806498277965291405860330*%i
-.103055621124092911933147995761e-5-57012.4750252175596573735379901*%i
-.174659096818815585094237733048e-5-34149.7020567387796037040357715*%i
-.297487820150711586081781112513e-5-20355.5386889781180392938093162*%i
-.509386612498557410125462503718e-5-12070.1390392030498216032145829*%i
-.877164035414600469688108536431e-5-7117.34860120668812674480852642*%i
-.151962978435208276911225901867e-4-4171.84610136108585560808616672*%i
-.264973843285477891237826911341e-4-2429.70740532481663379270112948*%i
-.465241745317563440850533964772e-4-1405.36384940281736853453439386*%i
-.822975534850463496309528778096e-4-806.874093430376319139651881000*%i
-.146748022269510871949704916474e-3-459.573661994813114816065149986*%i
-.263939555792941799905706930841e-3-259.514193183962698289111440241*%i
-.479161694124448979123035112546e-3-145.183905473491691593255861460*%i
-.878691071071313954118835170006e-3-80.4058931560269581356887745427*%i
-.162905306903577526817221856077e-2-44.0442426925204370553229387353*%i
-.305625966905978628953222471822e-2-23.8390021975797451611083573910*%i
-.580846725164082071536273451855e-2-12.7338928092422310225034596497*%i
-.111960870801015704309666326175e-1-6.70157236453336530001485057417*%i
-.219173311124347250011372032207e-1-3.46368159257564999321899318163*%i
-.436401495714357678620852844149e-1-1.74212593844630041894408377964*%i
-.885346333711996783833060748548e-1-.823011132028316628290698335065*%i
-.183369508964711807624977216267-.301468528287063960741495315885*%i
-.388610353002042478951656469700+.742761139171589711639893521547e-1*%i
-.844918004325681481750222567601+.516821457707907198384166434386*%i
-1.89039585924044726958623703732+1.32947930925090947023532473168*%i
-4.36797639093054858350533189627+3.15423383158560024587265627875*%i
-10.4671269577045389700075147071+7.59665950980175448647999939687*%i
-26.1440372887968552121168124482+18.9914495030265417159181030387*%i
-68.4752137778333489746248157547+49.7488776016920332905256012495*%i
-189.448063933402153107063476207+137.641608259005959102923288528*%i
-558.671142786509822114953965850+405.898184282342907324592979119*%i
-1775.89366610005533727710696658+1290.26222274021836291211050272*%i
-6172.70264310069624845257131090+4484.73096815767618280866922219*%i
-23898.2595618446385455977108063+17363.1019131371500723969023957*%i
-105620.597106195563009909502752+76737.8556300917987795826641172*%i
-551034.171673315014179690022412+400349.760104700511373253908912*%i
-3558467.54129716984248144975304+2585378.00327904024417315539476*%i
-30517149.3657265248196185370701+22172006.8476921417499049180696*%i
-388246084.328373599928533036128+282077291.596119080132718396404*%i
-8856126440.39457604551808145396+6434352492.33939328091093530642*%i
-522709544489.042872951660448954+379770713865.599863439159184397*%i
-190701693285491.092570552503326+138552890334543.654135467050971*%i
-10281715689309983987.2060749165+7470103709143657446.32424248994*%i
238191177341902260642855170.977
35024380542346488.2153464025164
12772867760371.7728088466266182
92457286298.6573560398434668121
2536456524.62126575017457759032
148234645.028248203511916163720
14097368.2645607380794691425177
1881851.92949889950431595427648
322279.916801265338734384988120
66765.1474184279982785682348194
16066.9242487139226536798364334
4362.51925148980121432934399275
1307.91299407305524726840302908
425.896846726169371587096333062
148.710294550538097009451524816
55.1144267534509433567041386173
21.5035609410006558353846244154
8.77325427219302646884050803953
3.72224195750009011505159751690
1.63465558480120688091007753951
.740159391954750639882074139578
.344393778853259216977401848766
.164201532714041310171760649472
.800243513271638349986319839744e-1
.397798121580791853281738956311e-1
.201321298658794034216176841391e-1
.103560370666905992635040439813e-1
.540691176888407583422797739258e-2
.286156621502652018921856501679e-2
.153343722918148866595688220752e-2
.831185720029556740881594839268e-3
.455311263304170461826454142385e-3
.251852088012123192376095810776e-3
.140570207767632545244456662889e-3
.791163306482225326026827441073e-4
.448751375011699121167007708810e-4
.256376320967221657266133721505e-4
.147458358441429260449497024314e-4
.853465615057222701297430366663e-5
.496878757320878755095749306120e-5
.290870891428076834759349136026e-5
.171153848514177575979400483279e-5
.101198227743906625519650857605e-5
.601081186505750947534602649654e-6
.358551341658023063661719607577e-6
.214743710639467150084029085964e-6
.129104504639445889547032020462e-6
.778973089120644626070567567717e-7
.471605173582258949603919406775e-7
.286438050691206179871260460662e-7
.174504017890849708114868789289e-7
.106618928639725696188985452343e-7
331.401128224875625203510529943-244.730503989310750403100351271*%i
-1753.16522075545204837038988081-1899.58609621988503625143513231*%i
-2832.68210434063418288015185017+13377.3353382728924841685509577*%i
27657.5286291510969261850798652-38673.9471004761401009842430733*%i
-47875.9205622201673439922734892+64830.1570350671010117727932267*%i
32333.5426495139473924265333589-46275.4681689010639033007581278*%i
-14613.9214609409914844000339182+11046.6648732706589662361977249*%i
3608.98510700286717229636496627+720.530267904449966286443435627*%i
-3.79359052729920461474378087997-597.970581216085822685151767366*%i
-90.5383046874953242928109361266-20.0102275804265502221600365144*%i
215.285717680022754525161204198+1736.54227550518937318665786064*%i
18152.7913796973772121879164204-4474.53908960980829471833597900*%i
-174955.395187320753154706691905-91491.8568707206142967875794481*%i
1361253.23847497353452595129611+354636.654711474708927290761809*%i
-2388414.92191168921299363627152+2527681.55270639005170292893027*%i
-744901.884687258883292410403930-1723758.06862483373854640770736*%i
226930.084937711474315187433014+207154.972809730352132392597576*%i
-8463.36037413379857493820828675-29007.5464346649788642909519061*%i
-2408.93223423967780013659264646+1403.32790862548333474193890511*%i
66.7427957994309207527815164498+279.823690461987201596057035988*%i
-4143.75954267318378046121745792-4927.07786475050556780011209734*%i
-109551.781527291688729675328045+72605.9098472774411977742356244*%i
3895682.78302454686809271503511+717071.531132754522747940290222*%i
-93379351.9184451377272461752157+78421150.3724823790418919239426*%i
-696339566.720854683422371071621+446704759.823715806450733540543*%i
-160507694.940853092581220804784+147250614.363447329958978089543*%i
-3723796.23665502159826079465980-7145998.31341075655281711140708*%i
-6528.87278400395165817916297633+252348.644897376691209186361839*%i
11394.7604793245186676197889743-19.6523478813786529288167697233*%i
389.190145612537667175296490213-651.478973690473869801486919758*%i
11598.9393810666086937580825861+11259.3028231637269963194057125*%i
597032.001535961081556151033900-43283.9776821950266967759856550*%i
-5144697.24607050763791765183036-63519500.1881000891459846608568*%i
20514684380.7405905825430033048+29359958732.9000028082757503162*%i
-13809477065395.4261669207567410-2804270158810.62978446512636097*%i
-86863856604.0349608350437435933-128307122770.251310249958274777*%i
180773049.412832782222717012935-70973529.2089779315405330312844*%i
-815479.625532015092262634759145-1107422.41227694898366825555170*%i
-31284.4450595518549474009129663+237.636005519739587017412201620*%i
-1229.29925868962411127345808659+788.202895093796768540588545930*%i
-20734.5083251320042170328149034+6189.98029933479941915531714931*%i
-980474.791612883222420515025143+188737.346197416517648973066799*%i
-188015471.506784261124282971642-1563741.35051873486208203441523*%i
-825676253276.434744614804012431-532605704771.610489125797547635*%i
581231789350415545203532.507027+189117049747735640601179.370358*%i
1448733931764.18107226478067093-13559637720155.4585400030043523*%i
545114500.652791481447746005612-460854077.840766710844987774777*%i
2201011.79435454033001623218748-1108918.36430227138275202323758*%i
40532.3865982468424446914856979-14977.2471592200062885291949902*%i
1712.73855320276449791669598779-508.541014282378544230302309437*%i
13925.6380440201227460955859012-1821.91438430060929978781008599*%i
303861.727040495528324155215734+359206.362248226563180923897959*%i
-35563737.6827787953739356442992+17100718.8921983270826014304610*%i
10241922233.7811572078899112217+3898984592.62922822191140220211*%i
-1029940820789.74389066440494062-66466259133.6661699415038301526*%i
24223330799.6804609370714389958+27181731902.4141401324067067751*%i
82400204.9982737014420081471188-73652184.6997428748757032983430*%i
210370.535083316522082982480766+1025946.69766086161280524739467*%i
-21183.1151038365034723191465821+16397.7080196651511688186481518*%i
-1323.50433320410081973118712711-18.8725122415715121033047238766*%i
-4817.07690716155495747731253224+1586.59168540171884209301104945*%i
-31800.0845616278025032571289010-84824.9118587645597888050255784*%i
1891354.19180421678355233973950+1020670.10246646465917126490867*%i
-13507027.0160133385354243124618-42915363.4997728956006821784227*%i
-180988531.296055715311138592951-133972653.746406396247521876152*%i
-71740361.0732518407330764878979-17559826.3380124033775540735845*%i
792586.846243102996273104415314+4015619.73179367773184149043921*%i
-103653.710073206637471190676826-131715.944620203252027491224223*%i
7419.46304448739385292827460289-4713.36051066739415385909846285*%i
549.854841063535173275692386215+323.102157807238183338674871471*%i
718.281492151015945969126806734-1104.07124396065809565152359247*%i
9505.60526389699440758008909347+8131.70921454770620126977550732*%i
-111937.400321700271998578466807+5636.57569841675570503803383660*%i
663287.191575620037615794141944+26058.7810172121655179025054376*%i
-983485.455150142704686564293171-1105889.57623225035027613472653*%i
-134856.604819627952159190742612+847882.394702776019998456892183*%i
68008.1721295309412608377003366-153649.645026688698228626765381*%i
3524.72836004255387934584702890+19317.3982616330842296851910932*%i
-2051.80890569576068353213510765-143.228341548019492618250432690*%i
-45.4675970146827977897976830527-226.824668989025848803972410363*%i
166.022322205512028028445816139+259.264864558171558217559012213*%i
-1568.27958047161916981220891615+813.875671960635035322473501596*%i
687.488964883348895880740693845-8394.71387836217965798707288805*%i
11388.4153233132430691309267267+24057.8174873085788632967206781*%i
-24995.6670552147161085085769680-35109.6837186989808339743440143*%i
21443.9885259749592453967855623+22590.2644084610087983761025662*%i
-10284.5185662702324409330998040-4041.84789933740353618309759269*%i
2119.51799856977868712706945375-1259.69069828652950996592422068*%i
153.744669197540761581271837200+411.924700883890780841093667313*%i
-61.2562641970935213609211110756+40.3271980504462059716806339978*%i
-64.1904781110550832473661189013+37.6454306782311120348849144158*%i
-160.462055666643913160897125346-248.350263236463026046269543377*%i
903.677630690744647257373294145-280.048714954567676585897853739*%i
-556.337526804489351390776692003+2051.81754611766218320277745318*%i
-1542.34792748511468063863520863-2510.38040214068723663605887420*%i
2308.08513317640148235999050915+523.328756573282452946746993413*%i
-853.781056111536199875439499608+769.768536754234695743390653248*%i
-147.731460135660518917764325225-351.392898395692024876292750914*%i
92.1718863020807122380247465783-36.6994524542864155938988094381*%i
13.8826004638356395715053093279+17.9818467484098643789804592818*%i
.233429412329750737219744523323e-7-871874.231084951426542075728000*%i
.387942998753673187992810379763e-7-532100.249153717871857297550509*%i
.647091527501681501666169148920e-7-323587.042912184989480755509470*%i
.108352975403366604813555453333e-6-196044.008572943318626636107676*%i
.182176520476799790043760290991e-6-118298.745580802358414859709501*%i
.307629117354367354172918434989e-6-71082.3830454413827157161632136*%i
.521869295830198908849667503967e-6-42518.8253282540978598249719727*%i
.889653274916985018500188492921e-6-25311.0528933271480041725582735*%i
.152454658742708171091085962704e-5-14990.2921311457990720135208778*%i
.262705709644256638514083171852e-5-8829.37579329487285018840111351*%i
.455374183383710136451482847106e-5-5170.17807600011721276102477249*%i
.794352468026967645585423998531e-5-3008.54928236651419919438909045*%i
.139507097966376299362368456679e-4-1738.95616264281684259103004431*%i
.246790357717918484466715439138e-4-997.895309075726234111697577321*%i
.439987279886088619237736088414e-4-568.211552616172215357528129874*%i
.791018303592047284415769286941e-4-320.851443972636709892817055953*%i
.143498730481709695476143704147e-3-179.547745578388688485663138717*%i
.262866374565083718275077169769e-3-99.4992930563270226131415322925*%i
.486621812397708088359486602514e-3-54.5593056051817802262373296881*%i
.911171918134224926621731708916e-3-29.5747649774642863500720387550*%i
.172738097306784681047193520327e-2-15.8302520672634307817095570445*%i
.331919414422819302572966661222e-2-8.35366352611384373467746217007*%i
.647247436294215540236365623855e-2-4.33257917029311151286338424681*%i
.128264331679390752762936177737e-1-2.18901895474692813609313247985*%i
.258716317348008211071187008676e-1-1.04118243988910020377311503689*%i
.532111026108467337124362275113e-1-.388954965905229620193709997649*%i
.111822742368668000834869899235+.774460966553722697403197905057e-1*%i
.240673471429352090591440016774+.615087903578815151942836074272*%i
.531955588488906310229319937719+1.57958469784484590407939704611*%i
1.21127193341601246017081198199+3.70227904404256656330428280267*%i
2.85187457086553697829831087974+8.76614080674655935929880337002*%i
6.97320844299863660907017142121+21.4567631133608272043977623037*%i
17.7990934859154480051080923470+54.7781667956611005947047558189*%i
47.7230782112128861967598244842+146.875849220255260527159600533*%i
135.427419431288773847798820518+416.802495953948871846780632057*%i
410.553401719409231671911770079+1263.55336450204696122361605866*%i
1345.10582669588553761418737256+4139.81003358203046855815672722*%i
4833.51856068543882771120531382+14876.0404938314771136243884860*%i
19416.6394904484728604401533968+59758.2717052573416867496462130*%i
89428.4085072240689880927927486+275232.340618081136793550901355*%i
488843.468409936023845690851381+1504505.49498084007522571191132*%i
3330374.33899155978928161276802+10249838.2757452296813962441752*%i
30403029.8273518266776579665896+93570904.3798889025419689412945*%i
416857766.775969513185882150347+1282956286.15004267987669517130*%i
10435051225.8876415676214892123+32115785367.4948408977542224042*%i
695942667814.431265035864680103+2141891291550.30119594728891822*%i
303308685088640.630708263756201+933488146779582.533931025039135*%i
22737547781411927146.1929569876+69978976482587195408.0784577637*%i
2290421118564914155465682992.76
169643579459057825.571263040721
48706808403791.5359330302035432
304008618796.190027071484808995
7490867312.68132597584667008009
402482095.726451544785231493579
35728248.8602406121958554389755
4499574.38758115193682559791803
732789.768099158976098993261734
145253.268668379714742956624458
33610.1494319984243927822982603
8810.08565809872256112518349915
2558.47163135559941813854838610
809.276563566388343055033101545
275.157824541659232674820981162
99.5113059965696509103293697878
37.9566851287177512544424235432
15.1642199663836149489382424809
6.30924972448730399252360091396
2.72069038818834369229157526035
1.21106434043645702026717668272
.554557964204876328370959633524
.260457451148545133869964831597
.125150015778787258902273334772
.613859993347065505778316734665e-1
.306770849160523368725938361385e-1
.155930133306215460692953549900e-1
.804950755338180973202787193344e-2
.421461993569631044757463228768e-2
.223556754891914026747460080367e-2
.120006010202041959452646181928e-2
.651324378246314311076497212543e-3
.357113041348971162834303187252e-3
.197651169764894843420229238537e-3
.110352337505591560703209932203e-3
.621131312497230113091961509532e-4
.352258233423557970586536035737e-4
.201183725833551268357487466593e-4
.115658140830983582699635308179e-4
.669000426241146758282087801149e-5
.389201211803492072939484130410e-5
.227648265252575150279898578244e-5
.133830230668546209393133244711e-5
.790519348962482321023329544835e-6
.469048856630522952618508627081e-6
.279485391402319731423392759099e-6
.167198407062979359966661232078e-6
.100401755129804423520589496167e-6
.605058968235300533683969949542e-7
.365863197263496684872052936640e-7
.221935888116162149172184259581e-7
.135036933430929688063069725644e-7
715.421455162686278826387515840+250.480270062448628503879571075*%i
831.054842258063650896960282311-4908.08433529182541200541248641*%i
-23786.2113220542846117159469629+13775.6057585462889523460207388*%i
96699.9684295084230771520227917-20171.3914635029169467866067930*%i
-162462.456661636435534850697847+49469.8621600236937230982058654*%i
107183.640187822263919440533215-48935.3382542345395590722038309*%i
-36289.5136696373513135124712054+7755.83739320469033261758463691*%i
6079.80005049970969080591098284+3764.79032008420909830008548422*%i
315.619134237492715745401581056-1064.49336202730828519250470408*%i
-147.318519115395187338914367648-73.5455708075816124055826323507*%i
-2658.20012050644244032940675152+2101.82571591069490293595956852*%i
28826.1025965459750717459831579+25574.9934088222314943646235594*%i
-87017.1870683928442778183101982-425203.893493058020213063174977*%i
1675092.98616717826793472330468+2805387.09105519992575297896318*%i
-8167233.15700541479388289364611+1412199.71702974382884780626760*%i
423743.963311756857445633395338-4377210.37362766269055488215493*%i
292473.929342949731187651721680+618112.178309111888769827246650*%i
1222.07874162043088095717831369-63082.0345033724807942316383847*%i
-5242.72091459039973482670397858+1540.83751158589355498068285129*%i
19.8584652108010977199695216947+531.932457173669754156640606055*%i
4995.57232403856869599760945788-12041.9592949244132888284779406*%i
-259106.989638682851573913723165-127992.716510334680319713495058*%i
3921518.43601531576938869851591+8754557.35772350165435521172758*%i
-322949694.201864061223805143413-46315199.7321324397517886255280*%i
-2334624029.48097180742212414255-185347041.046049391955265815962*%i
-567496615.795755998530749723870+171351897.461597846365755863521*%i
-3387861.84449846416961977982185-19627793.0152994334653403149474*%i
-140344.321134286336330439750624+547598.036456633164642962762492*%i
23091.0078437937500092523446634+3976.98414119951918043364157373*%i
908.673033650430332381240903014-1133.89919075857072504790447778*%i
-12346.2089894529588433868005149+31423.6899151853930830613085131*%i
658104.271896273747203427619122+1215929.55065904240843584245536*%i
143216019.074016578108527548493-88700068.2067033179691118546743*%i
-41710973700.3945985091187861425+106353436399.450167724675331926*%i
-34555606761333.0131410922239559-41213456824645.1969516760340388*%i
-143702500243.572514854435732972-495972357080.034318941679628172*%i
519958852.451085041256957660768-105055547.769055207661917719992*%i
-1609501.08027285406457425343296-2826650.50030489674000605449141*%i
-66326.8818038326297005796282817-5243.23002305816683550948479075*%i
-2506.42965270642252640328324115+1377.72040701076441649444458019*%i
-1519.88947913635234855200075984+45609.3822726490509187688342367*%i
-319028.378297585588400113093961+2322586.94420439846794671742638*%i
-172043657.292266879849057472545+484445059.734418255236773738277*%i
-2765968796755.93422678561642762+2092354591485.86827257962815864*%i
396974029068