/* The following code was generated by JFlex 1.4.3 on 22/01/11 19:49 */

//CHECKSTYLE:OFF

package org.scilab.forge.scidoc.scilab;

import java.util.Arrays;
import java.util.Set;
import java.util.Map;
import java.util.HashSet;
import java.util.List;
import java.util.ArrayList;
import java.util.Iterator;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.Reader;
import java.io.StringReader;
import java.io.IOException;


/**
 * This class is a scanner generated by 
 * <a href="http://www.jflex.de/">JFlex</a> 1.4.3
 * on 22/01/11 19:49 from the specification file
 * <tt>scilab.jflex</tt>
 */
public final class ScilabLexer {

  /** This character denotes the end of file */
  public static final int YYEOF = -1;

  /** initial size of the lookahead buffer */
  private static final int ZZ_BUFFERSIZE = 16384;

  /** lexical states */
  public static final int CLEANFIRST = 28;
  public static final int BREAKINARGS = 24;
  public static final int QSTRING = 2;
  public static final int CLEAN = 30;
  public static final int FUNNAME = 18;
  public static final int FIELD = 6;
  public static final int ARGS = 22;
  public static final int COMMANDS = 8;
  public static final int WHITESEOL = 26;
  public static final int YYINITIAL = 0;
  public static final int COMMANDSWHITE = 10;
  public static final int RETS = 20;
  public static final int BREAKSTRING = 12;
  public static final int FUNCTION = 14;
  public static final int TYPEID = 16;
  public static final int COMMENT = 4;

  /**
   * ZZ_LEXSTATE[l] is the state in the DFA for the lexical state l
   * ZZ_LEXSTATE[l+1] is the state in the DFA for the lexical state l
   *                  at the beginning of a line
   * l is of the form l = 2*k, k a non negative integer
   */
  private static final int ZZ_LEXSTATE[] = { 
     0,  0,  1,  1,  2,  2,  3,  3,  4,  4,  5,  5,  6,  6,  7,  7, 
     8,  8,  9,  9, 10, 10, 11, 11, 12, 12, 13, 13, 14, 14, 15, 15
  };

  /** 
   * Translates characters to character classes
   */
  private static final String ZZ_CMAP_PACKED = 
    "\1\104\10\0\1\76\1\2\2\0\1\1\22\0\1\73\1\100\1\13"+
    "\1\102\1\74\1\14\1\46\1\12\1\4\1\7\1\47\1\52\1\77"+
    "\1\52\1\42\1\11\12\101\1\75\1\103\1\43\1\45\1\44\1\100"+
    "\1\53\2\102\1\30\1\40\1\36\1\20\1\102\1\33\1\31\3\102"+
    "\1\35\1\102\1\34\1\37\1\102\1\41\1\27\1\16\2\102\1\32"+
    "\3\102\1\3\1\50\1\6\1\51\1\100\1\0\1\26\1\65\1\63"+
    "\1\64\1\21\1\17\1\102\1\60\1\23\1\102\1\66\1\61\1\71"+
    "\1\24\1\55\1\22\1\67\1\56\1\25\1\15\1\70\1\102\1\57"+
    "\1\72\1\62\1\20\1\5\1\54\1\10\1\53\uff81\0";

  /** 
   * Translates characters to character classes
   */
  private static final char [] ZZ_CMAP = zzUnpackCMap(ZZ_CMAP_PACKED);

  /** 
   * Translates DFA states to action switch labels.
   */
  private static final int [] ZZ_ACTION = zzUnpackAction();

  private static final String ZZ_ACTION_PACKED_0 =
    "\1\0\1\1\1\2\2\0\1\1\12\0\2\3\1\4"+
    "\1\5\1\6\1\7\1\10\1\11\14\12\1\13\1\14"+
    "\1\15\1\7\1\16\2\7\6\12\1\17\2\20\1\21"+
    "\1\22\1\23\2\1\1\24\1\25\1\1\1\26\1\27"+
    "\1\30\1\1\2\2\1\31\1\32\1\33\1\34\1\35"+
    "\1\36\2\37\1\40\1\37\1\41\1\42\1\43\1\1"+
    "\1\4\1\1\2\44\1\45\2\44\1\37\1\46\1\47"+
    "\1\37\1\50\1\37\1\51\1\52\1\53\1\37\1\54"+
    "\1\52\1\37\1\55\1\56\1\57\1\37\1\60\1\52"+
    "\1\37\1\61\1\62\1\63\2\37\2\64\1\37\1\17"+
    "\1\37\2\65\1\52\1\66\1\67\1\70\1\71\1\72"+
    "\2\73\1\12\1\73\12\12\1\74\4\12\1\7\1\75"+
    "\1\20\1\7\1\22\1\76\1\77\1\100\1\0\5\12"+
    "\1\22\2\0\1\101\1\0\1\102\1\103\5\0\1\104"+
    "\1\105\1\0\6\12\1\74\5\12\1\73\10\12\1\22"+
    "\1\101\1\106\3\12\1\74\1\107\27\12\1\110\1\111"+
    "\2\12\1\112";

  private static int [] zzUnpackAction() {
    int [] result = new int[230];
    int offset = 0;
    offset = zzUnpackAction(ZZ_ACTION_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackAction(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }


  /* error codes */
  private static final int ZZ_UNKNOWN_ERROR = 0;
  private static final int ZZ_NO_MATCH = 1;
  private static final int ZZ_PUSHBACK_2BIG = 2;

  /* error messages for the codes above */
  private static final String ZZ_ERROR_MSG[] = {
    "Unkown internal scanner error",
    "Error: could not match input",
    "Error: pushback value was too large"
  };

  /** the input device */
  private java.io.Reader zzReader;

  /** the current state of the DFA */
  private int zzState;

  /** the current lexical state */
  private int zzLexicalState = YYINITIAL;

  /** this buffer contains the current text to be matched and is
      the source of the yytext() string */
  private char zzBuffer[] = new char[ZZ_BUFFERSIZE];

  /** the textposition at the last accepting state */
  private int zzMarkedPos;

  /** the current text position in the buffer */
  private int zzCurrentPos;

  /** startRead marks the beginning of the yytext() string in the buffer */
  private int zzStartRead;

  /** endRead marks the last character in the buffer, that has been read
      from input */
  private int zzEndRead;

  /** number of newlines encountered up to the start of the matched text */
  private int yyline;

  /** the number of characters up to the start of the matched text */
  private int yychar;

  /**
   * the number of characters from the last newline up to the start of the 
   * matched text
   */
  private int yycolumn;

  /** 
   * zzAtBOL == true <=> the scanner is currently at the beginning of a line
   */
  private boolean zzAtBOL = true;

  /** zzAtEOF == true <=> the scanner is at the EOF */
  private boolean zzAtEOF;

  /** denotes if the user-EOF-code has already been executed */
  private boolean zzEOFDone;

  /* user code: */
    private static Set<String> commands;
    private static Set<String> macros;

    private int beginString;
    private boolean transposable;
    private boolean breakstring;
    private boolean breakargs;
    private int whitesOnFirstLine;
    private int saveLexState;

    private String id;
    private List<String> returnValues = new ArrayList();
    private List<String> argsValues = new ArrayList();
    private List<String> localFun = new ArrayList();

    private AbstractScilabCodeHandler handler;

    public ScilabLexer(String[] primFile, String[] macroFile) {
       if (commands == null) {
          commands = new HashSet();
          macros = new HashSet();
          loadNames(primFile, commands);
          loadNames(macroFile, macros);
       }
    }

    public ScilabLexer(String primFile, String macroFile) {
       this(new String[]{primFile}, new String[]{macroFile});
    }

    public ScilabLexer(Set primitives, Set macros) {
       commands = primitives;
       this.macros = macros;
    }

    private void loadNames(String[] files, Set set) {
       for (int i = 0; i < files.length; i++) {
          loadNames(files[i], set);
       }
    }

    private void loadNames(String file, Set set) {
       if (file == null) {
          return;
       }
       BufferedReader input = null;
       try {
          input =  new BufferedReader(new FileReader(file));
          String line = null;
          while ((line = input.readLine()) != null) {
             set.add(line);
          }
       } catch (IOException e) {
          System.err.println(e);
       }
       if (input != null) {
          try {
             input.close();
          } catch (IOException e) {
             System.err.println(e);
          }
       }
    }

    private String trimEnd(String str) {
        int end = str.length() - 1;
        int i = end;
        for (; i >= 0; i--) {
           char c = str.charAt(i);
           if (c != ' ' && c != '\t' && c != '\r' && c != '\n') {
              break;
           }
        }
        if (i != end) {
           return str.substring(0, i + 1);
        }

        return str;
    }

    public String convert(AbstractScilabCodeHandler h, String code) {
        Reader reader = new StringReader(trimEnd(code));
        String str = convert(h, reader, true);
        try {
          reader.close();
        } catch (IOException e) { }

        return str;
    }

    public String convert(AbstractScilabCodeHandler h, Reader code, boolean ret) {
        if (code == null) {
           return null;
        } else {
           handler = h;
           transposable = false;
           breakargs = false;
           breakstring = false;
           whitesOnFirstLine = 0;
           localFun.clear();
           yyreset(code);
           yybegin(CLEANFIRST);
           try {
               yylex();
           } catch (IOException e) {
               return null;
           }
           if (ret) {
               return h.toString();
           }
           return "";
        }
    }


  /**
   * Creates a new scanner
   * There is also a java.io.InputStream version of this constructor.
   *
   * @param   in  the java.io.Reader to read input from.
   */
  public ScilabLexer(java.io.Reader in) {
    this.zzReader = in;
  }

  /**
   * Creates a new scanner.
   * There is also java.io.Reader version of this constructor.
   *
   * @param   in  the java.io.Inputstream to read input from.
   */
  public ScilabLexer(java.io.InputStream in) {
    this(new java.io.InputStreamReader(in));
  }

  /** 
   * Unpacks the compressed character translation table.
   *
   * @param packed   the packed character translation table
   * @return         the unpacked character translation table
   */
  private static char [] zzUnpackCMap(String packed) {
    char [] map = new char[0x10000];
    int i = 0;  /* index in packed string  */
    int j = 0;  /* index in unpacked array */
    while (i < 176) {
      int  count = packed.charAt(i++);
      char value = packed.charAt(i++);
      do map[j++] = value; while (--count > 0);
    }
    return map;
  }


  /**
   * Refills the input buffer.
   *
   * @return      <code>false</code>, iff there was new input.
   * 
   * @exception   java.io.IOException  if any I/O-Error occurs
   */
  private boolean zzRefill() throws java.io.IOException {

    /* first: make room (if you can) */
    if (zzStartRead > 0) {
      System.arraycopy(zzBuffer, zzStartRead,
                       zzBuffer, 0,
                       zzEndRead-zzStartRead);

      /* translate stored positions */
      zzEndRead-= zzStartRead;
      zzCurrentPos-= zzStartRead;
      zzMarkedPos-= zzStartRead;
      zzStartRead = 0;
    }

    /* is the buffer big enough? */
    if (zzCurrentPos >= zzBuffer.length) {
      /* if not: blow it up */
      char newBuffer[] = new char[zzCurrentPos*2];
      System.arraycopy(zzBuffer, 0, newBuffer, 0, zzBuffer.length);
      zzBuffer = newBuffer;
    }

    /* finally: fill the buffer with new input */
    int numRead = zzReader.read(zzBuffer, zzEndRead,
                                            zzBuffer.length-zzEndRead);

    if (numRead > 0) {
      zzEndRead+= numRead;
      return false;
    }
    // unlikely but not impossible: read 0 characters, but not at end of stream    
    if (numRead == 0) {
      int c = zzReader.read();
      if (c == -1) {
        return true;
      } else {
        zzBuffer[zzEndRead++] = (char) c;
        return false;
      }     
    }

	// numRead < 0
    return true;
  }

    
  /**
   * Closes the input stream.
   */
  public final void yyclose() throws java.io.IOException {
    zzAtEOF = true;            /* indicate end of file */
    zzEndRead = zzStartRead;  /* invalidate buffer    */

    if (zzReader != null)
      zzReader.close();
  }


  /**
   * Resets the scanner to read from a new input stream.
   * Does not close the old reader.
   *
   * All internal variables are reset, the old input stream 
   * <b>cannot</b> be reused (internal buffer is discarded and lost).
   * Lexical state is set to <tt>ZZ_INITIAL</tt>.
   *
   * @param reader   the new input stream 
   */
  public final void yyreset(java.io.Reader reader) {
    zzReader = reader;
    zzAtBOL  = true;
    zzAtEOF  = false;
    zzEOFDone = false;
    zzEndRead = zzStartRead = 0;
    zzCurrentPos = zzMarkedPos = 0;
    yyline = yychar = yycolumn = 0;
    zzLexicalState = YYINITIAL;
  }


  /**
   * Returns the current lexical state.
   */
  public final int yystate() {
    return zzLexicalState;
  }


  /**
   * Enters a new lexical state
   *
   * @param newState the new lexical state
   */
  public final void yybegin(int newState) {
    zzLexicalState = newState;
  }


  /**
   * Returns the text matched by the current regular expression.
   */
  public final String yytext() {
    return new String( zzBuffer, zzStartRead, zzMarkedPos-zzStartRead );
  }


  /**
   * Returns the character at position <tt>pos</tt> from the 
   * matched text. 
   * 
   * It is equivalent to yytext().charAt(pos), but faster
   *
   * @param pos the position of the character to fetch. 
   *            A value from 0 to yylength()-1.
   *
   * @return the character at position pos
   */
  public final char yycharat(int pos) {
    return zzBuffer[zzStartRead+pos];
  }


  /**
   * Returns the length of the matched text region.
   */
  public final int yylength() {
    return zzMarkedPos-zzStartRead;
  }


  /**
   * Reports an error that occured while scanning.
   *
   * In a wellformed scanner (no or only correct usage of 
   * yypushback(int) and a match-all fallback rule) this method 
   * will only be called with things that "Can't Possibly Happen".
   * If this method is called, something is seriously wrong
   * (e.g. a JFlex bug producing a faulty scanner etc.).
   *
   * Usual syntax/scanner level error handling should be done
   * in error fallback rules.
   *
   * @param   errorCode  the code of the errormessage to display
   */
  private void zzScanError(int errorCode) {
    String message;
    try {
      message = ZZ_ERROR_MSG[errorCode];
    }
    catch (ArrayIndexOutOfBoundsException e) {
      message = ZZ_ERROR_MSG[ZZ_UNKNOWN_ERROR];
    }

    throw new Error(message);
  } 


  /**
   * Pushes the specified amount of characters back into the input stream.
   *
   * They will be read again by then next call of the scanning method
   *
   * @param number  the number of characters to be read again.
   *                This number must not be greater than yylength()!
   */
  public void yypushback(int number)  {
    if ( number > yylength() )
      zzScanError(ZZ_PUSHBACK_2BIG);

    zzMarkedPos -= number;
  }


  /**
   * Resumes scanning until the next regular expression is matched,
   * the end of input is encountered or an I/O-Error occurs.
   *
   * @return      the next token
   * @exception   java.io.IOException  if any I/O-Error occurs
   */
  public void yylex() throws java.io.IOException {
    int zzInput;
    int zzAction;

    // cached fields:
    int zzCurrentPosL;
    int zzMarkedPosL;
    int zzEndReadL = zzEndRead;
    char [] zzBufferL = zzBuffer;
    char [] zzCMapL = ZZ_CMAP;


    while (true) {
      zzMarkedPosL = zzMarkedPos;

      yychar+= zzMarkedPosL-zzStartRead;

      zzAction = -1;

      zzCurrentPosL = zzCurrentPos = zzStartRead = zzMarkedPosL;
  
      zzState = ZZ_LEXSTATE[zzLexicalState];


      zzForAction: {
        while (true) {
    
          if (zzCurrentPosL < zzEndReadL)
            zzInput = zzBufferL[zzCurrentPosL++];
          else if (zzAtEOF) {
            zzInput = YYEOF;
            break zzForAction;
          }
          else {
            // store back cached positions
            zzCurrentPos  = zzCurrentPosL;
            zzMarkedPos   = zzMarkedPosL;
            boolean eof = zzRefill();
            // get translated positions and possibly new buffer
            zzCurrentPosL  = zzCurrentPos;
            zzMarkedPosL   = zzMarkedPos;
            zzBufferL      = zzBuffer;
            zzEndReadL     = zzEndRead;
            if (eof) {
              zzInput = YYEOF;
              break zzForAction;
            }
            else {
              zzInput = zzBufferL[zzCurrentPosL++];
            }
          }
          zzInput = zzCMapL[zzInput];

          boolean zzIsFinal = false;
          boolean zzNoLookAhead = false;

          zzForNext: { switch (zzState) {
            case 0:
              switch (zzInput) {
                case 0: 
                case 63: 
                case 67: zzIsFinal = true; zzNoLookAhead = true; zzState = 16; break zzForNext;
                case 1: zzIsFinal = true; zzState = 17; break zzForNext;
                case 2: zzIsFinal = true; zzNoLookAhead = true; zzState = 18; break zzForNext;
                case 3: 
                case 4: 
                case 5: zzIsFinal = true; zzNoLookAhead = true; zzState = 19; break zzForNext;
                case 6: 
                case 7: 
                case 8: zzIsFinal = true; zzNoLookAhead = true; zzState = 20; break zzForNext;
                case 9: zzIsFinal = true; zzState = 21; break zzForNext;
                case 10: zzIsFinal = true; zzNoLookAhead = true; zzState = 22; break zzForNext;
                case 11: zzIsFinal = true; zzNoLookAhead = true; zzState = 23; break zzForNext;
                case 12: zzIsFinal = true; zzState = 24; break zzForNext;
                case 13: zzIsFinal = true; zzState = 25; break zzForNext;
                case 14: zzIsFinal = true; zzState = 26; break zzForNext;
                case 15: zzIsFinal = true; zzState = 27; break zzForNext;
                case 17: zzIsFinal = true; zzState = 29; break zzForNext;
                case 18: zzIsFinal = true; zzState = 30; break zzForNext;
                case 19: zzIsFinal = true; zzState = 31; break zzForNext;
                case 21: zzIsFinal = true; zzState = 32; break zzForNext;
                case 22: zzIsFinal = true; zzState = 33; break zzForNext;
                case 23: zzIsFinal = true; zzState = 34; break zzForNext;
                case 26: zzIsFinal = true; zzState = 35; break zzForNext;
                case 34: zzIsFinal = true; zzState = 36; break zzForNext;
                case 35: zzIsFinal = true; zzState = 37; break zzForNext;
                case 36: zzIsFinal = true; zzState = 38; break zzForNext;
                case 37: 
                case 43: zzIsFinal = true; zzState = 39; break zzForNext;
                case 38: zzIsFinal = true; zzState = 40; break zzForNext;
                case 39: zzIsFinal = true; zzState = 41; break zzForNext;
                case 40: 
                case 41: 
                case 42: 
                case 44: zzIsFinal = true; zzNoLookAhead = true; zzState = 42; break zzForNext;
                case 46: zzIsFinal = true; zzState = 43; break zzForNext;
                case 47: zzIsFinal = true; zzState = 44; break zzForNext;
                case 51: zzIsFinal = true; zzState = 45; break zzForNext;
                case 52: zzIsFinal = true; zzState = 46; break zzForNext;
                case 53: zzIsFinal = true; zzState = 47; break zzForNext;
                case 55: zzIsFinal = true; zzState = 48; break zzForNext;
                case 59: zzIsFinal = true; zzNoLookAhead = true; zzState = 49; break zzForNext;
                case 60: zzIsFinal = true; zzState = 50; break zzForNext;
                case 61: zzIsFinal = true; zzNoLookAhead = true; zzState = 51; break zzForNext;
                case 62: zzIsFinal = true; zzNoLookAhead = true; zzState = 52; break zzForNext;
                case 65: zzIsFinal = true; zzState = 53; break zzForNext;
                case 68: zzIsFinal = true; zzNoLookAhead = true; zzState = 54; break zzForNext;
                default: zzIsFinal = true; zzState = 28; break zzForNext;
              }

            case 1:
              switch (zzInput) {
                case 2: zzIsFinal = true; zzNoLookAhead = true; zzState = 18; break zzForNext;
                case 1: zzIsFinal = true; zzState = 56; break zzForNext;
                case 10: zzIsFinal = true; zzState = 57; break zzForNext;
                case 11: zzIsFinal = true; zzState = 58; break zzForNext;
                case 34: zzIsFinal = true; zzState = 59; break zzForNext;
                case 35: zzIsFinal = true; zzNoLookAhead = true; zzState = 60; break zzForNext;
                case 36: zzIsFinal = true; zzNoLookAhead = true; zzState = 61; break zzForNext;
                case 38: zzIsFinal = true; zzNoLookAhead = true; zzState = 62; break zzForNext;
                case 62: zzIsFinal = true; zzNoLookAhead = true; zzState = 63; break zzForNext;
                default: zzIsFinal = true; zzState = 55; break zzForNext;
              }

            case 2:
              switch (zzInput) {
                case 68: zzIsFinal = true; zzNoLookAhead = true; zzState = 54; break zzForNext;
                case 1: zzIsFinal = true; zzState = 65; break zzForNext;
                case 2: zzIsFinal = true; zzNoLookAhead = true; zzState = 66; break zzForNext;
                case 10: zzIsFinal = true; zzNoLookAhead = true; zzState = 67; break zzForNext;
                case 11: zzIsFinal = true; zzNoLookAhead = true; zzState = 68; break zzForNext;
                case 35: zzIsFinal = true; zzNoLookAhead = true; zzState = 69; break zzForNext;
                case 36: zzIsFinal = true; zzNoLookAhead = true; zzState = 70; break zzForNext;
                case 38: zzIsFinal = true; zzNoLookAhead = true; zzState = 71; break zzForNext;
                default: zzIsFinal = true; zzState = 64; break zzForNext;
              }

            case 3:
              switch (zzInput) {
                case 2: zzIsFinal = true; zzNoLookAhead = true; zzState = 18; break zzForNext;
                case 0: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 34: 
                case 35: 
                case 36: 
                case 37: 
                case 38: 
                case 39: 
                case 40: 
                case 41: 
                case 42: 
                case 43: 
                case 44: 
                case 59: 
                case 61: 
                case 62: 
                case 63: 
                case 65: 
                case 67: 
                case 68: zzIsFinal = true; zzNoLookAhead = true; zzState = 72; break zzForNext;
                case 1: zzIsFinal = true; zzState = 73; break zzForNext;
                case 60: zzIsFinal = true; zzState = 75; break zzForNext;
                default: zzIsFinal = true; zzState = 74; break zzForNext;
              }

            case 4:
              switch (zzInput) {
                case 2: zzIsFinal = true; zzNoLookAhead = true; zzState = 18; break zzForNext;
                case 1: zzIsFinal = true; zzState = 73; break zzForNext;
                case 4: zzIsFinal = true; zzNoLookAhead = true; zzState = 76; break zzForNext;
                case 59: zzIsFinal = true; zzState = 77; break zzForNext;
                case 62: zzIsFinal = true; zzState = 78; break zzForNext;
                default: zzIsFinal = true; zzNoLookAhead = true; zzState = 72; break zzForNext;
              }

            case 5:
              switch (zzInput) {
                case 2: zzIsFinal = true; zzNoLookAhead = true; zzState = 18; break zzForNext;
                case 59: zzIsFinal = true; zzNoLookAhead = true; zzState = 49; break zzForNext;
                case 62: zzIsFinal = true; zzNoLookAhead = true; zzState = 52; break zzForNext;
                case 35: zzIsFinal = true; zzNoLookAhead = true; zzState = 60; break zzForNext;
                case 36: zzIsFinal = true; zzNoLookAhead = true; zzState = 61; break zzForNext;
                case 38: zzIsFinal = true; zzNoLookAhead = true; zzState = 62; break zzForNext;
                case 63: 
                case 67: zzIsFinal = true; zzNoLookAhead = true; zzState = 72; break zzForNext;
                case 1: zzIsFinal = true; zzState = 80; break zzForNext;
                case 9: zzIsFinal = true; zzState = 81; break zzForNext;
                default: zzIsFinal = true; zzState = 79; break zzForNext;
              }

            case 6:
              switch (zzInput) {
                case 59: zzIsFinal = true; zzNoLookAhead = true; zzState = 49; break zzForNext;
                case 62: zzIsFinal = true; zzNoLookAhead = true; zzState = 52; break zzForNext;
                case 1: zzIsFinal = true; zzState = 83; break zzForNext;
                case 2: zzIsFinal = true; zzNoLookAhead = true; zzState = 84; break zzForNext;
                case 9: zzIsFinal = true; zzState = 85; break zzForNext;
                case 34: zzIsFinal = true; zzState = 86; break zzForNext;
                default: zzIsFinal = true; zzNoLookAhead = true; zzState = 82; break zzForNext;
              }

            case 7:
              switch (zzInput) {
                case 0: 
                case 2: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 34: 
                case 35: 
                case 36: 
                case 37: 
                case 38: 
                case 39: 
                case 40: 
                case 41: 
                case 42: 
                case 43: 
                case 44: 
                case 59: 
                case 61: 
                case 62: 
                case 63: 
                case 65: 
                case 67: 
                case 68: zzIsFinal = true; zzNoLookAhead = true; zzState = 72; break zzForNext;
                case 1: zzIsFinal = true; zzState = 87; break zzForNext;
                case 3: zzIsFinal = true; zzNoLookAhead = true; zzState = 88; break zzForNext;
                case 60: zzIsFinal = true; zzState = 90; break zzForNext;
                default: zzIsFinal = true; zzState = 89; break zzForNext;
              }

            case 8:
              switch (zzInput) {
                case 1: zzIsFinal = true; zzState = 87; break zzForNext;
                case 4: zzIsFinal = true; zzNoLookAhead = true; zzState = 91; break zzForNext;
                case 9: zzIsFinal = true; zzState = 92; break zzForNext;
                case 37: zzIsFinal = true; zzNoLookAhead = true; zzState = 93; break zzForNext;
                case 59: 
                case 62: zzIsFinal = true; zzState = 94; break zzForNext;
                default: zzIsFinal = true; zzNoLookAhead = true; zzState = 72; break zzForNext;
              }

            case 9:
              switch (zzInput) {
                case 0: 
                case 2: 
                case 3: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 10: 
                case 11: 
                case 34: 
                case 35: 
                case 36: 
                case 37: 
                case 38: 
                case 39: 
                case 40: 
                case 41: 
                case 42: 
                case 43: 
                case 44: 
                case 61: 
                case 63: 
                case 65: 
                case 67: 
                case 68: zzIsFinal = true; zzNoLookAhead = true; zzState = 72; break zzForNext;
                case 1: zzIsFinal = true; zzState = 87; break zzForNext;
                case 4: zzIsFinal = true; zzNoLookAhead = true; zzState = 95; break zzForNext;
                case 9: zzIsFinal = true; zzState = 96; break zzForNext;
                case 59: 
                case 62: zzIsFinal = true; zzState = 98; break zzForNext;
                case 60: zzIsFinal = true; zzState = 99; break zzForNext;
                default: zzIsFinal = true; zzState = 97; break zzForNext;
              }

            case 10:
              switch (zzInput) {
                case 0: 
                case 2: 
                case 4: 
                case 5: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 35: 
                case 36: 
                case 38: 
                case 39: 
                case 40: 
                case 41: 
                case 42: 
                case 43: 
                case 44: 
                case 61: 
                case 65: 
                case 67: 
                case 68: zzIsFinal = true; zzNoLookAhead = true; zzState = 72; break zzForNext;
                case 1: zzIsFinal = true; zzState = 87; break zzForNext;
                case 3: zzIsFinal = true; zzNoLookAhead = true; zzState = 100; break zzForNext;
                case 6: zzIsFinal = true; zzNoLookAhead = true; zzState = 101; break zzForNext;
                case 34: zzIsFinal = true; zzState = 103; break zzForNext;
                case 37: zzIsFinal = true; zzNoLookAhead = true; zzState = 104; break zzForNext;
                case 59: 
                case 62: zzIsFinal = true; zzState = 105; break zzForNext;
                case 60: zzIsFinal = true; zzState = 106; break zzForNext;
                case 63: zzIsFinal = true; zzNoLookAhead = true; zzState = 107; break zzForNext;
                default: zzIsFinal = true; zzState = 102; break zzForNext;
              }

            case 11:
              switch (zzInput) {
                case 0: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 35: 
                case 36: 
                case 37: 
                case 38: 
                case 39: 
                case 40: 
                case 41: 
                case 42: 
                case 43: 
                case 44: 
                case 61: 
                case 65: 
                case 67: 
                case 68: zzIsFinal = true; zzNoLookAhead = true; zzState = 72; break zzForNext;
                case 1: zzIsFinal = true; zzState = 87; break zzForNext;
                case 59: 
                case 62: zzIsFinal = true; zzState = 105; break zzForNext;
                case 63: zzIsFinal = true; zzNoLookAhead = true; zzState = 107; break zzForNext;
                case 7: zzIsFinal = true; zzNoLookAhead = true; zzState = 108; break zzForNext;
                case 34: zzIsFinal = true; zzState = 110; break zzForNext;
                case 60: zzIsFinal = true; zzState = 111; break zzForNext;
                default: zzIsFinal = true; zzState = 109; break zzForNext;
              }

            case 12:
              switch (zzInput) {
                case 1: zzIsFinal = true; zzState = 112; break zzForNext;
                case 2: zzIsFinal = true; zzNoLookAhead = true; zzState = 113; break zzForNext;
                case 9: zzIsFinal = true; zzState = 114; break zzForNext;
                case 59: zzIsFinal = true; zzState = 115; break zzForNext;
                case 62: zzIsFinal = true; zzState = 116; break zzForNext;
                default: zzIsFinal = true; zzNoLookAhead = true; zzState = 72; break zzForNext;
              }

            case 13:
              switch (zzInput) {
                case 59: zzIsFinal = true; zzNoLookAhead = true; zzState = 49; break zzForNext;
                case 1: zzIsFinal = true; zzState = 118; break zzForNext;
                default: zzIsFinal = true; zzNoLookAhead = true; zzState = 117; break zzForNext;
              }

            case 14:
              switch (zzInput) {
                case 1: 
                case 2: zzIsFinal = true; zzState = 119; break zzForNext;
                case 59: 
                case 62: zzIsFinal = true; zzState = 120; break zzForNext;
                default: zzIsFinal = true; zzNoLookAhead = true; zzState = 72; break zzForNext;
              }

            case 15:
              switch (zzInput) {
                case 1: 
                case 2: zzIsFinal = true; zzState = 122; break zzForNext;
                case 59: 
                case 62: zzIsFinal = true; zzState = 123; break zzForNext;
                default: zzIsFinal = true; zzNoLookAhead = true; zzState = 121; break zzForNext;
              }

            case 17:
              switch (zzInput) {
                case 2: zzIsFinal = true; zzNoLookAhead = true; zzState = 18; break zzForNext;
                default: break zzForAction;
              }

            case 21:
              switch (zzInput) {
                case 34: zzIsFinal = true; zzNoLookAhead = true; zzState = 42; break zzForNext;
                case 9: zzIsFinal = true; zzNoLookAhead = true; zzState = 124; break zzForNext;
                default: break zzForAction;
              }

            case 24:
              switch (zzInput) {
                case 13: 
                case 14: 
                case 15: 
                case 16: 
                case 21: zzIsFinal = true; zzState = 125; break zzForNext;
                case 17: zzIsFinal = true; zzState = 126; break zzForNext;
                case 18: zzIsFinal = true; zzState = 127; break zzForNext;
                case 19: zzIsFinal = true; zzState = 128; break zzForNext;
                case 20: zzIsFinal = true; zzState = 129; break zzForNext;
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 34: 
                case 35: 
                case 36: 
                case 37: 
                case 38: 
                case 39: 
                case 40: 
                case 41: 
                case 42: 
                case 43: 
                case 44: 
                case 59: 
                case 61: 
                case 62: 
                case 63: 
                case 67: 
                case 68: break zzForAction;
                default: zzIsFinal = true; zzState = 28; break zzForNext;
              }

            case 25:
              switch (zzInput) {
                case 46: zzIsFinal = true; zzState = 130; break zzForNext;
                case 48: zzIsFinal = true; zzState = 131; break zzForNext;
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 34: 
                case 35: 
                case 36: 
                case 37: 
                case 38: 
                case 39: 
                case 40: 
                case 41: 
                case 42: 
                case 43: 
                case 44: 
                case 59: 
                case 61: 
                case 62: 
                case 63: 
                case 67: 
                case 68: break zzForAction;
                default: zzIsFinal = true; zzState = 28; break zzForNext;
              }

            case 26:
              switch (zzInput) {
                case 29: zzIsFinal = true; zzState = 132; break zzForNext;
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 34: 
                case 35: 
                case 36: 
                case 37: 
                case 38: 
                case 39: 
                case 40: 
                case 41: 
                case 42: 
                case 43: 
                case 44: 
                case 59: 
                case 61: 
                case 62: 
                case 63: 
                case 67: 
                case 68: break zzForAction;
                default: zzIsFinal = true; zzState = 28; break zzForNext;
              }

            case 27:
              switch (zzInput) {
                case 45: zzIsFinal = true; zzState = 133; break zzForNext;
                case 56: zzIsFinal = true; zzState = 134; break zzForNext;
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 34: 
                case 35: 
                case 36: 
                case 37: 
                case 38: 
                case 39: 
                case 40: 
                case 41: 
                case 42: 
                case 43: 
                case 44: 
                case 59: 
                case 61: 
                case 62: 
                case 63: 
                case 67: 
                case 68: break zzForAction;
                default: zzIsFinal = true; zzState = 28; break zzForNext;
              }

            case 28:
              switch (zzInput) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 34: 
                case 35: 
                case 36: 
                case 37: 
                case 38: 
                case 39: 
                case 40: 
                case 41: 
                case 42: 
                case 43: 
                case 44: 
                case 59: 
                case 61: 
                case 62: 
                case 63: 
                case 67: 
                case 68: break zzForAction;
                default: zzIsFinal = true; break zzForNext;
              }

            case 29:
              switch (zzInput) {
                case 20: zzIsFinal = true; zzState = 135; break zzForNext;
                case 49: zzIsFinal = true; zzState = 136; break zzForNext;
                case 58: zzIsFinal = true; zzState = 137; break zzForNext;
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 34: 
                case 35: 
                case 36: 
                case 37: 
                case 38: 
                case 39: 
                case 40: 
                case 41: 
                case 42: 
                case 43: 
                case 44: 
                case 59: 
                case 61: 
                case 62: 
                case 63: 
                case 67: 
                case 68: break zzForAction;
                default: zzIsFinal = true; zzState = 28; break zzForNext;
              }

            case 30:
              switch (zzInput) {
                case 22: zzIsFinal = true; zzState = 138; break zzForNext;
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 34: 
                case 35: 
                case 36: 
                case 37: 
                case 38: 
                case 39: 
                case 40: 
                case 41: 
                case 42: 
                case 43: 
                case 44: 
                case 59: 
                case 61: 
                case 62: 
                case 63: 
                case 67: 
                case 68: break zzForAction;
                default: zzIsFinal = true; zzState = 28; break zzForNext;
              }

            case 31:
              switch (zzInput) {
                case 15: zzIsFinal = true; zzState = 139; break zzForNext;
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 34: 
                case 35: 
                case 36: 
                case 37: 
                case 38: 
                case 39: 
                case 40: 
                case 41: 
                case 42: 
                case 43: 
                case 44: 
                case 59: 
                case 61: 
                case 62: 
                case 63: 
                case 67: 
                case 68: break zzForAction;
                default: zzIsFinal = true; zzState = 28; break zzForNext;
              }

            case 32:
              switch (zzInput) {
                case 17: zzIsFinal = true; zzState = 140; break zzForNext;
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 34: 
                case 35: 
                case 36: 
                case 37: 
                case 38: 
                case 39: 
                case 40: 
                case 41: 
                case 42: 
                case 43: 
                case 44: 
                case 59: 
                case 61: 
                case 62: 
                case 63: 
                case 67: 
                case 68: break zzForAction;
                default: zzIsFinal = true; zzState = 28; break zzForNext;
              }

            case 33:
              switch (zzInput) {
                case 53: zzIsFinal = true; zzState = 141; break zzForNext;
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 34: 
                case 35: 
                case 36: 
                case 37: 
                case 38: 
                case 39: 
                case 40: 
                case 41: 
                case 42: 
                case 43: 
                case 44: 
                case 59: 
                case 61: 
                case 62: 
                case 63: 
                case 67: 
                case 68: break zzForAction;
                default: zzIsFinal = true; zzState = 28; break zzForNext;
              }

            case 34:
              switch (zzInput) {
                case 24: zzIsFinal = true; zzState = 142; break zzForNext;
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 34: 
                case 35: 
                case 36: 
                case 37: 
                case 38: 
                case 39: 
                case 40: 
                case 41: 
                case 42: 
                case 43: 
                case 44: 
                case 59: 
                case 61: 
                case 62: 
                case 63: 
                case 67: 
                case 68: break zzForAction;
                default: zzIsFinal = true; zzState = 28; break zzForNext;
              }

            case 35:
              switch (zzInput) {
                case 23: zzIsFinal = true; zzState = 143; break zzForNext;
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 34: 
                case 35: 
                case 36: 
                case 37: 
                case 38: 
                case 39: 
                case 40: 
                case 41: 
                case 42: 
                case 43: 
                case 44: 
                case 59: 
                case 61: 
                case 62: 
                case 63: 
                case 67: 
                case 68: break zzForAction;
                default: zzIsFinal = true; zzState = 28; break zzForNext;
              }

            case 36:
              switch (zzInput) {
                case 41: zzIsFinal = true; zzNoLookAhead = true; zzState = 42; break zzForNext;
                case 9: 
                case 40: zzIsFinal = true; zzState = 144; break zzForNext;
                case 10: zzIsFinal = true; zzNoLookAhead = true; zzState = 145; break zzForNext;
                case 34: zzIsFinal = true; zzState = 146; break zzForNext;
                case 39: zzIsFinal = true; zzState = 147; break zzForNext;
                case 65: zzIsFinal = true; zzState = 148; break zzForNext;
                default: break zzForAction;
              }

            case 37:
              switch (zzInput) {
                case 36: zzIsFinal = true; zzNoLookAhead = true; zzState = 149; break zzForNext;
                case 37: zzIsFinal = true; zzNoLookAhead = true; zzState = 150; break zzForNext;
                default: break zzForAction;
              }

            case 38:
              switch (zzInput) {
                case 37: zzIsFinal = true; zzNoLookAhead = true; zzState = 151; break zzForNext;
                default: break zzForAction;
              }

            case 39:
              switch (zzInput) {
                case 37: zzIsFinal = true; zzNoLookAhead = true; zzState = 42; break zzForNext;
                default: break zzForAction;
              }

            case 40:
              switch (zzInput) {
                case 67: zzIsFinal = true; zzNoLookAhead = true; zzState = 16; break zzForNext;
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 34: 
                case 35: 
                case 36: 
                case 37: 
                case 38: 
                case 39: 
                case 40: 
                case 41: 
                case 42: 
                case 43: 
                case 44: 
                case 59: 
                case 60: 
                case 61: 
                case 62: 
                case 63: 
                case 64: 
                case 68: break zzForAction;
                default: zzState = 152; break zzForNext;
              }

            case 41:
              switch (zzInput) {
                case 39: zzIsFinal = true; zzNoLookAhead = true; zzState = 42; break zzForNext;
                default: break zzForAction;
              }

            case 43:
              switch (zzInput) {
                case 17: zzIsFinal = true; zzState = 153; break zzForNext;
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 34: 
                case 35: 
                case 36: 
                case 37: 
                case 38: 
                case 39: 
                case 40: 
                case 41: 
                case 42: 
                case 43: 
                case 44: 
                case 59: 
                case 61: 
                case 62: 
                case 63: 
                case 67: 
                case 68: break zzForAction;
                default: zzIsFinal = true; zzState = 28; break zzForNext;
              }

            case 44:
              switch (zzInput) {
                case 48: zzIsFinal = true; zzState = 154; break zzForNext;
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 34: 
                case 35: 
                case 36: 
                case 37: 
                case 38: 
                case 39: 
                case 40: 
                case 41: 
                case 42: 
                case 43: 
                case 44: 
                case 59: 
                case 61: 
                case 62: 
                case 63: 
                case 67: 
                case 68: break zzForAction;
                default: zzIsFinal = true; zzState = 28; break zzForNext;
              }

            case 45:
              switch (zzInput) {
                case 22: zzIsFinal = true; zzState = 155; break zzForNext;
                case 45: zzIsFinal = true; zzState = 156; break zzForNext;
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 34: 
                case 35: 
                case 36: 
                case 37: 
                case 38: 
                case 39: 
                case 40: 
                case 41: 
                case 42: 
                case 43: 
                case 44: 
                case 59: 
                case 61: 
                case 62: 
                case 63: 
                case 67: 
                case 68: break zzForAction;
                default: zzIsFinal = true; zzState = 28; break zzForNext;
              }

            case 46:
              switch (zzInput) {
                case 45: zzIsFinal = true; zzState = 139; break zzForNext;
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 34: 
                case 35: 
                case 36: 
                case 37: 
                case 38: 
                case 39: 
                case 40: 
                case 41: 
                case 42: 
                case 43: 
                case 44: 
                case 59: 
                case 61: 
                case 62: 
                case 63: 
                case 67: 
                case 68: break zzForAction;
                default: zzIsFinal = true; zzState = 28; break zzForNext;
              }

            case 47:
              switch (zzInput) {
                case 46: zzIsFinal = true; zzState = 157; break zzForNext;
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 34: 
                case 35: 
                case 36: 
                case 37: 
                case 38: 
                case 39: 
                case 40: 
                case 41: 
                case 42: 
                case 43: 
                case 44: 
                case 59: 
                case 61: 
                case 62: 
                case 63: 
                case 67: 
                case 68: break zzForAction;
                default: zzIsFinal = true; zzState = 28; break zzForNext;
              }

            case 48:
              switch (zzInput) {
                case 56: zzIsFinal = true; zzState = 137; break zzForNext;
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 34: 
                case 35: 
                case 36: 
                case 37: 
                case 38: 
                case 39: 
                case 40: 
                case 41: 
                case 42: 
                case 43: 
                case 44: 
                case 59: 
                case 61: 
                case 62: 
                case 63: 
                case 67: 
                case 68: break zzForAction;
                default: zzIsFinal = true; zzState = 28; break zzForNext;
              }

            case 50:
              switch (zzInput) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 34: 
                case 35: 
                case 36: 
                case 37: 
                case 38: 
                case 39: 
                case 40: 
                case 41: 
                case 42: 
                case 43: 
                case 44: 
                case 59: 
                case 61: 
                case 62: 
                case 63: 
                case 67: 
                case 68: break zzForAction;
                default: zzIsFinal = true; zzState = 28; break zzForNext;
              }

            case 53:
              switch (zzInput) {
                case 65: zzIsFinal = true; break zzForNext;
                case 34: zzIsFinal = true; zzState = 148; break zzForNext;
                case 17: 
                case 30: 
                case 32: 
                case 52: zzIsFinal = true; zzState = 158; break zzForNext;
                default: break zzForAction;
              }

            case 55:
              switch (zzInput) {
                case 10: 
                case 11: zzState = 159; break zzForNext;
                case 34: zzState = 160; break zzForNext;
                case 1: 
                case 2: 
                case 35: 
                case 36: 
                case 38: 
                case 62: break zzForAction;
                default: zzIsFinal = true; break zzForNext;
              }

            case 56:
              switch (zzInput) {
                case 2: zzIsFinal = true; zzNoLookAhead = true; zzState = 18; break zzForNext;
                default: break zzForAction;
              }

            case 57:
              switch (zzInput) {
                case 10: 
                case 11: zzIsFinal = true; zzState = 55; break zzForNext;
                default: break zzForAction;
              }

            case 58:
              switch (zzInput) {
                case 10: 
                case 11: zzIsFinal = true; zzState = 55; break zzForNext;
                default: break zzForAction;
              }

            case 59:
              switch (zzInput) {
                case 34: zzIsFinal = true; zzState = 161; break zzForNext;
                case 1: 
                case 2: 
                case 10: 
                case 11: 
                case 35: 
                case 36: 
                case 38: 
                case 62: break zzForAction;
                default: zzIsFinal = true; zzState = 55; break zzForNext;
              }

            case 64:
              switch (zzInput) {
                case 2: 
                case 10: 
                case 11: 
                case 35: 
                case 36: 
                case 38: 
                case 68: break zzForAction;
                default: zzIsFinal = true; break zzForNext;
              }

            case 65:
              switch (zzInput) {
                case 2: zzIsFinal = true; zzNoLookAhead = true; zzState = 66; break zzForNext;
                case 10: 
                case 11: 
                case 35: 
                case 36: 
                case 38: 
                case 68: break zzForAction;
                default: zzIsFinal = true; zzState = 64; break zzForNext;
              }

            case 73:
              switch (zzInput) {
                case 2: zzIsFinal = true; zzNoLookAhead = true; zzState = 18; break zzForNext;
                default: break zzForAction;
              }

            case 74:
              switch (zzInput) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 34: 
                case 35: 
                case 36: 
                case 37: 
                case 38: 
                case 39: 
                case 40: 
                case 41: 
                case 42: 
                case 43: 
                case 44: 
                case 59: 
                case 61: 
                case 62: 
                case 63: 
                case 67: 
                case 68: break zzForAction;
                default: zzIsFinal = true; break zzForNext;
              }

            case 75:
              switch (zzInput) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 34: 
                case 35: 
                case 36: 
                case 37: 
                case 38: 
                case 39: 
                case 40: 
                case 41: 
                case 42: 
                case 43: 
                case 44: 
                case 59: 
                case 61: 
                case 62: 
                case 63: 
                case 67: 
                case 68: break zzForAction;
                default: zzIsFinal = true; zzState = 74; break zzForNext;
              }

            case 77:
              switch (zzInput) {
                case 4: zzIsFinal = true; zzNoLookAhead = true; zzState = 76; break zzForNext;
                case 59: 
                case 62: zzState = 162; break zzForNext;
                default: break zzForAction;
              }

            case 78:
              switch (zzInput) {
                case 4: zzIsFinal = true; zzNoLookAhead = true; zzState = 76; break zzForNext;
                case 59: 
                case 62: zzState = 162; break zzForNext;
                default: break zzForAction;
              }

            case 79:
              switch (zzInput) {
                case 1: 
                case 2: 
                case 9: 
                case 35: 
                case 36: 
                case 38: 
                case 59: 
                case 62: 
                case 63: 
                case 67: break zzForAction;
                default: zzIsFinal = true; break zzForNext;
              }

            case 80:
              switch (zzInput) {
                case 2: zzIsFinal = true; zzNoLookAhead = true; zzState = 18; break zzForNext;
                default: break zzForAction;
              }

            case 81:
              switch (zzInput) {
                case 9: zzIsFinal = true; zzNoLookAhead = true; zzState = 124; break zzForNext;
                case 1: 
                case 2: 
                case 35: 
                case 36: 
                case 38: 
                case 59: 
                case 62: 
                case 63: 
                case 67: break zzForAction;
                default: zzIsFinal = true; zzState = 79; break zzForNext;
              }

            case 83:
              switch (zzInput) {
                case 2: zzIsFinal = true; zzNoLookAhead = true; zzState = 84; break zzForNext;
                default: break zzForAction;
              }

            case 85:
              switch (zzInput) {
                case 9: zzIsFinal = true; zzNoLookAhead = true; zzState = 124; break zzForNext;
                default: break zzForAction;
              }

            case 86:
              switch (zzInput) {
                case 34: zzIsFinal = true; zzState = 163; break zzForNext;
                default: break zzForAction;
              }

            case 87:
              switch (zzInput) {
                case 2: zzIsFinal = true; zzNoLookAhead = true; zzState = 72; break zzForNext;
                default: break zzForAction;
              }

            case 89:
              switch (zzInput) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 34: 
                case 35: 
                case 36: 
                case 37: 
                case 38: 
                case 39: 
                case 40: 
                case 41: 
                case 42: 
                case 43: 
                case 44: 
                case 59: 
                case 61: 
                case 62: 
                case 63: 
                case 67: 
                case 68: break zzForAction;
                default: zzIsFinal = true; break zzForNext;
              }

            case 90:
              switch (zzInput) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 34: 
                case 35: 
                case 36: 
                case 37: 
                case 38: 
                case 39: 
                case 40: 
                case 41: 
                case 42: 
                case 43: 
                case 44: 
                case 59: 
                case 61: 
                case 62: 
                case 63: 
                case 67: 
                case 68: break zzForAction;
                default: zzIsFinal = true; zzState = 89; break zzForNext;
              }

            case 92:
              switch (zzInput) {
                case 9: zzIsFinal = true; zzNoLookAhead = true; zzState = 164; break zzForNext;
                default: break zzForAction;
              }

            case 94:
              switch (zzInput) {
                case 9: zzState = 165; break zzForNext;
                case 59: 
                case 62: zzState = 166; break zzForNext;
                default: break zzForAction;
              }

            case 96:
              switch (zzInput) {
                case 9: zzIsFinal = true; zzNoLookAhead = true; zzState = 76; break zzForNext;
                default: break zzForAction;
              }

            case 97:
              switch (zzInput) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 34: 
                case 35: 
                case 36: 
                case 37: 
                case 38: 
                case 39: 
                case 40: 
                case 41: 
                case 42: 
                case 43: 
                case 44: 
                case 59: 
                case 61: 
                case 62: 
                case 63: 
                case 67: 
                case 68: break zzForAction;
                default: zzIsFinal = true; break zzForNext;
              }

            case 98:
              switch (zzInput) {
                case 9: zzState = 167; break zzForNext;
                case 59: 
                case 62: zzState = 168; break zzForNext;
                default: break zzForAction;
              }

            case 99:
              switch (zzInput) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 34: 
                case 35: 
                case 36: 
                case 37: 
                case 38: 
                case 39: 
                case 40: 
                case 41: 
                case 42: 
                case 43: 
                case 44: 
                case 59: 
                case 61: 
                case 62: 
                case 63: 
                case 67: 
                case 68: break zzForAction;
                default: zzIsFinal = true; zzState = 97; break zzForNext;
              }

            case 102:
              switch (zzInput) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 34: 
                case 35: 
                case 36: 
                case 37: 
                case 38: 
                case 39: 
                case 40: 
                case 41: 
                case 42: 
                case 43: 
                case 44: 
                case 59: 
                case 61: 
                case 62: 
                case 63: 
                case 67: 
                case 68: break zzForAction;
                default: zzIsFinal = true; break zzForNext;
              }

            case 103:
              switch (zzInput) {
                case 34: zzState = 169; break zzForNext;
                default: break zzForAction;
              }

            case 105:
              switch (zzInput) {
                case 59: 
                case 62: zzIsFinal = true; break zzForNext;
                default: break zzForAction;
              }

            case 106:
              switch (zzInput) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 34: 
                case 35: 
                case 36: 
                case 37: 
                case 38: 
                case 39: 
                case 40: 
                case 41: 
                case 42: 
                case 43: 
                case 44: 
                case 59: 
                case 61: 
                case 62: 
                case 63: 
                case 67: 
                case 68: break zzForAction;
                default: zzIsFinal = true; zzState = 102; break zzForNext;
              }

            case 109:
              switch (zzInput) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 34: 
                case 35: 
                case 36: 
                case 37: 
                case 38: 
                case 39: 
                case 40: 
                case 41: 
                case 42: 
                case 43: 
                case 44: 
                case 59: 
                case 61: 
                case 62: 
                case 63: 
                case 67: 
                case 68: break zzForAction;
                default: zzIsFinal = true; break zzForNext;
              }

            case 110:
              switch (zzInput) {
                case 34: zzIsFinal = true; zzState = 170; break zzForNext;
                default: break zzForAction;
              }

            case 111:
              switch (zzInput) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 34: 
                case 35: 
                case 36: 
                case 37: 
                case 38: 
                case 39: 
                case 40: 
                case 41: 
                case 42: 
                case 43: 
                case 44: 
                case 59: 
                case 61: 
                case 62: 
                case 63: 
                case 67: 
                case 68: break zzForAction;
                default: zzIsFinal = true; zzState = 109; break zzForNext;
              }

            case 112:
              switch (zzInput) {
                case 2: zzIsFinal = true; zzNoLookAhead = true; zzState = 113; break zzForNext;
                default: break zzForAction;
              }

            case 114:
              switch (zzInput) {
                case 9: zzIsFinal = true; zzNoLookAhead = true; zzState = 171; break zzForNext;
                default: break zzForAction;
              }

            case 115:
              switch (zzInput) {
                case 1: zzIsFinal = true; zzState = 112; break zzForNext;
                case 2: zzIsFinal = true; zzNoLookAhead = true; zzState = 113; break zzForNext;
                case 59: 
                case 62: zzState = 172; break zzForNext;
                default: break zzForAction;
              }

            case 116:
              switch (zzInput) {
                case 1: zzIsFinal = true; zzState = 112; break zzForNext;
                case 2: zzIsFinal = true; zzNoLookAhead = true; zzState = 113; break zzForNext;
                case 59: 
                case 62: zzState = 172; break zzForNext;
                default: break zzForAction;
              }

            case 118:
              switch (zzInput) {
                case 2: zzIsFinal = true; zzNoLookAhead = true; zzState = 117; break zzForNext;
                default: break zzForAction;
              }

            case 119:
              switch (zzInput) {
                case 1: 
                case 2: zzIsFinal = true; break zzForNext;
                default: break zzForAction;
              }

            case 120:
              switch (zzInput) {
                case 1: 
                case 2: zzIsFinal = true; zzState = 119; break zzForNext;
                case 59: 
                case 62: zzIsFinal = true; break zzForNext;
                default: break zzForAction;
              }

            case 122:
              switch (zzInput) {
                case 1: 
                case 2: zzIsFinal = true; break zzForNext;
                default: break zzForAction;
              }

            case 123:
              switch (zzInput) {
                case 59: 
                case 62: zzIsFinal = true; break zzForNext;
                default: break zzForAction;
              }

            case 125:
              switch (zzInput) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 34: 
                case 35: 
                case 36: 
                case 37: 
                case 38: 
                case 39: 
                case 40: 
                case 41: 
                case 42: 
                case 43: 
                case 44: 
                case 59: 
                case 61: 
                case 62: 
                case 63: 
                case 67: 
                case 68: break zzForAction;
                default: zzIsFinal = true; zzState = 28; break zzForNext;
              }

            case 126:
              switch (zzInput) {
                case 18: zzIsFinal = true; zzState = 173; break zzForNext;
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 34: 
                case 35: 
                case 36: 
                case 37: 
                case 38: 
                case 39: 
                case 40: 
                case 41: 
                case 42: 
                case 43: 
                case 44: 
                case 59: 
                case 61: 
                case 62: 
                case 63: 
                case 67: 
                case 68: break zzForAction;
                default: zzIsFinal = true; zzState = 28; break zzForNext;
              }

            case 127:
              switch (zzInput) {
                case 19: zzIsFinal = true; zzState = 125; break zzForNext;
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 34: 
                case 35: 
                case 36: 
                case 37: 
                case 38: 
                case 39: 
                case 40: 
                case 41: 
                case 42: 
                case 43: 
                case 44: 
                case 59: 
                case 61: 
                case 62: 
                case 63: 
                case 67: 
                case 68: break zzForAction;
                default: zzIsFinal = true; zzState = 28; break zzForNext;
              }

            case 128:
              switch (zzInput) {
                case 20: zzIsFinal = true; zzState = 174; break zzForNext;
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 34: 
                case 35: 
                case 36: 
                case 37: 
                case 38: 
                case 39: 
                case 40: 
                case 41: 
                case 42: 
                case 43: 
                case 44: 
                case 59: 
                case 61: 
                case 62: 
                case 63: 
                case 67: 
                case 68: break zzForAction;
                default: zzIsFinal = true; zzState = 28; break zzForNext;
              }

            case 129:
              switch (zzInput) {
                case 22: zzIsFinal = true; zzState = 175; break zzForNext;
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 34: 
                case 35: 
                case 36: 
                case 37: 
                case 38: 
                case 39: 
                case 40: 
                case 41: 
                case 42: 
                case 43: 
                case 44: 
                case 59: 
                case 61: 
                case 62: 
                case 63: 
                case 67: 
                case 68: break zzForAction;
                default: zzIsFinal = true; zzState = 28; break zzForNext;
              }

            case 130:
              switch (zzInput) {
                case 50: zzIsFinal = true; zzState = 139; break zzForNext;
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 34: 
                case 35: 
                case 36: 
                case 37: 
                case 38: 
                case 39: 
                case 40: 
                case 41: 
                case 42: 
                case 43: 
                case 44: 
                case 59: 
                case 61: 
                case 62: 
                case 63: 
                case 67: 
                case 68: break zzForAction;
                default: zzIsFinal = true; zzState = 28; break zzForNext;
              }

            case 131:
              switch (zzInput) {
                case 17: zzIsFinal = true; zzState = 176; break zzForNext;
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 34: 
                case 35: 
                case 36: 
                case 37: 
                case 38: 
                case 39: 
                case 40: 
                case 41: 
                case 42: 
                case 43: 
                case 44: 
                case 59: 
                case 61: 
                case 62: 
                case 63: 
                case 67: 
                case 68: break zzForAction;
                default: zzIsFinal = true; zzState = 28; break zzForNext;
              }

            case 132:
              switch (zzInput) {
                case 31: zzIsFinal = true; zzState = 177; break zzForNext;
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 34: 
                case 35: 
                case 36: 
                case 37: 
                case 38: 
                case 39: 
                case 40: 
                case 41: 
                case 42: 
                case 43: 
                case 44: 
                case 59: 
                case 61: 
                case 62: 
                case 63: 
                case 67: 
                case 68: break zzForAction;
                default: zzIsFinal = true; zzState = 28; break zzForNext;
              }

            case 133:
              switch (zzInput) {
                case 46: zzIsFinal = true; zzState = 139; break zzForNext;
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 34: 
                case 35: 
                case 36: 
                case 37: 
                case 38: 
                case 39: 
                case 40: 
                case 41: 
                case 42: 
                case 43: 
                case 44: 
                case 59: 
                case 61: 
                case 62: 
                case 63: 
                case 67: 
                case 68: break zzForAction;
                default: zzIsFinal = true; zzState = 28; break zzForNext;
              }

            case 134:
              switch (zzInput) {
                case 20: zzIsFinal = true; zzState = 178; break zzForNext;
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 34: 
                case 35: 
                case 36: 
                case 37: 
                case 38: 
                case 39: 
                case 40: 
                case 41: 
                case 42: 
                case 43: 
                case 44: 
                case 59: 
                case 61: 
                case 62: 
                case 63: 
                case 67: 
                case 68: break zzForAction;
                default: zzIsFinal = true; zzState = 28; break zzForNext;
              }

            case 135:
              switch (zzInput) {
                case 52: zzIsFinal = true; zzState = 179; break zzForNext;
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 34: 
                case 35: 
                case 36: 
                case 37: 
                case 38: 
                case 39: 
                case 40: 
                case 41: 
                case 42: 
                case 43: 
                case 44: 
                case 59: 
                case 61: 
                case 62: 
                case 63: 
                case 67: 
                case 68: break zzForAction;
                default: zzIsFinal = true; zzState = 28; break zzForNext;
              }

            case 136:
              switch (zzInput) {
                case 21: zzIsFinal = true; zzState = 180; break zzForNext;
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 34: 
                case 35: 
                case 36: 
                case 37: 
                case 38: 
                case 39: 
                case 40: 
                case 41: 
                case 42: 
                case 43: 
                case 44: 
                case 59: 
                case 61: 
                case 62: 
                case 63: 
                case 67: 
                case 68: break zzForAction;
                default: zzIsFinal = true; zzState = 28; break zzForNext;
              }

            case 137:
              switch (zzInput) {
                case 19: zzIsFinal = true; zzState = 181; break zzForNext;
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 34: 
                case 35: 
                case 36: 
                case 37: 
                case 38: 
                case 39: 
                case 40: 
                case 41: 
                case 42: 
                case 43: 
                case 44: 
                case 59: 
                case 61: 
                case 62: 
                case 63: 
                case 67: 
                case 68: break zzForAction;
                default: zzIsFinal = true; zzState = 28; break zzForNext;
              }

            case 138:
              switch (zzInput) {
                case 56: zzIsFinal = true; zzState = 182; break zzForNext;
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 34: 
                case 35: 
                case 36: 
                case 37: 
                case 38: 
                case 39: 
                case 40: 
                case 41: 
                case 42: 
                case 43: 
                case 44: 
                case 59: 
                case 61: 
                case 62: 
                case 63: 
                case 67: 
                case 68: break zzForAction;
                default: zzIsFinal = true; zzState = 28; break zzForNext;
              }

            case 139:
              switch (zzInput) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 34: 
                case 35: 
                case 36: 
                case 37: 
                case 38: 
                case 39: 
                case 40: 
                case 41: 
                case 42: 
                case 43: 
                case 44: 
                case 59: 
                case 61: 
                case 62: 
                case 63: 
                case 67: 
                case 68: break zzForAction;
                default: zzIsFinal = true; zzState = 28; break zzForNext;
              }

            case 140:
              switch (zzInput) {
                case 49: zzIsFinal = true; zzState = 183; break zzForNext;
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 34: 
                case 35: 
                case 36: 
                case 37: 
                case 38: 
                case 39: 
                case 40: 
                case 41: 
                case 42: 
                case 43: 
                case 44: 
                case 59: 
                case 61: 
                case 62: 
                case 63: 
                case 67: 
                case 68: break zzForAction;
                default: zzIsFinal = true; zzState = 28; break zzForNext;
              }

            case 141:
              switch (zzInput) {
                case 45: zzIsFinal = true; zzState = 184; break zzForNext;
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 34: 
                case 35: 
                case 36: 
                case 37: 
                case 38: 
                case 39: 
                case 40: 
                case 41: 
                case 42: 
                case 43: 
                case 44: 
                case 59: 
                case 61: 
                case 62: 
                case 63: 
                case 67: 
                case 68: break zzForAction;
                default: zzIsFinal = true; zzState = 28; break zzForNext;
              }

            case 142:
              switch (zzInput) {
                case 25: zzIsFinal = true; zzState = 185; break zzForNext;
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 34: 
                case 35: 
                case 36: 
                case 37: 
                case 38: 
                case 39: 
                case 40: 
                case 41: 
                case 42: 
                case 43: 
                case 44: 
                case 59: 
                case 61: 
                case 62: 
                case 63: 
                case 67: 
                case 68: break zzForAction;
                default: zzIsFinal = true; zzState = 28; break zzForNext;
              }

            case 143:
              switch (zzInput) {
                case 24: zzIsFinal = true; zzState = 186; break zzForNext;
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 34: 
                case 35: 
                case 36: 
                case 37: 
                case 38: 
                case 39: 
                case 40: 
                case 41: 
                case 42: 
                case 43: 
                case 44: 
                case 59: 
                case 61: 
                case 62: 
                case 63: 
                case 67: 
                case 68: break zzForAction;
                default: zzIsFinal = true; zzState = 28; break zzForNext;
              }

            case 144:
              switch (zzInput) {
                case 34: zzIsFinal = true; zzNoLookAhead = true; zzState = 42; break zzForNext;
                default: break zzForAction;
              }

            case 146:
              switch (zzInput) {
                case 34: zzIsFinal = true; break zzForNext;
                default: break zzForAction;
              }

            case 147:
              switch (zzInput) {
                case 34: 
                case 39: zzIsFinal = true; zzNoLookAhead = true; zzState = 42; break zzForNext;
                default: break zzForAction;
              }

            case 148:
              switch (zzInput) {
                case 65: zzIsFinal = true; break zzForNext;
                case 17: 
                case 30: 
                case 32: 
                case 52: zzIsFinal = true; zzState = 158; break zzForNext;
                default: break zzForAction;
              }

            case 152:
              switch (zzInput) {
                case 67: zzIsFinal = true; zzNoLookAhead = true; zzState = 16; break zzForNext;
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 34: 
                case 35: 
                case 36: 
                case 37: 
                case 38: 
                case 39: 
                case 40: 
                case 41: 
                case 42: 
                case 43: 
                case 44: 
                case 59: 
                case 60: 
                case 61: 
                case 62: 
                case 63: 
                case 64: 
                case 68: break zzForAction;
                default: break zzForNext;
              }

            case 153:
              switch (zzInput) {
                case 13: zzIsFinal = true; zzState = 187; break zzForNext;
                case 21: zzIsFinal = true; zzState = 188; break zzForNext;
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 34: 
                case 35: 
                case 36: 
                case 37: 
                case 38: 
                case 39: 
                case 40: 
                case 41: 
                case 42: 
                case 43: 
                case 44: 
                case 59: 
                case 61: 
                case 62: 
                case 63: 
                case 67: 
                case 68: break zzForAction;
                default: zzIsFinal = true; zzState = 28; break zzForNext;
              }

            case 154:
              switch (zzInput) {
                case 19: zzIsFinal = true; zzState = 189; break zzForNext;
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 34: 
                case 35: 
                case 36: 
                case 37: 
                case 38: 
                case 39: 
                case 40: 
                case 41: 
                case 42: 
                case 43: 
                case 44: 
                case 59: 
                case 61: 
                case 62: 
                case 63: 
                case 67: 
                case 68: break zzForAction;
                default: zzIsFinal = true; zzState = 28; break zzForNext;
              }

            case 155:
              switch (zzInput) {
                case 13: zzIsFinal = true; zzState = 190; break zzForNext;
                case 21: zzIsFinal = true; zzState = 191; break zzForNext;
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 34: 
                case 35: 
                case 36: 
                case 37: 
                case 38: 
                case 39: 
                case 40: 
                case 41: 
                case 42: 
                case 43: 
                case 44: 
                case 59: 
                case 61: 
                case 62: 
                case 63: 
                case 67: 
                case 68: break zzForAction;
                default: zzIsFinal = true; zzState = 28; break zzForNext;
              }

            case 156:
              switch (zzInput) {
                case 20: zzIsFinal = true; zzState = 192; break zzForNext;
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 34: 
                case 35: 
                case 36: 
                case 37: 
                case 38: 
                case 39: 
                case 40: 
                case 41: 
                case 42: 
                case 43: 
                case 44: 
                case 59: 
                case 61: 
                case 62: 
                case 63: 
                case 67: 
                case 68: break zzForAction;
                default: zzIsFinal = true; zzState = 28; break zzForNext;
              }

            case 157:
              switch (zzInput) {
                case 17: zzIsFinal = true; zzState = 193; break zzForNext;
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 34: 
                case 35: 
                case 36: 
                case 37: 
                case 38: 
                case 39: 
                case 40: 
                case 41: 
                case 42: 
                case 43: 
                case 44: 
                case 59: 
                case 61: 
                case 62: 
                case 63: 
                case 67: 
                case 68: break zzForAction;
                default: zzIsFinal = true; zzState = 28; break zzForNext;
              }

            case 158:
              switch (zzInput) {
                case 42: 
                case 65: zzIsFinal = true; zzState = 194; break zzForNext;
                default: break zzForAction;
              }

            case 159:
              switch (zzInput) {
                case 10: 
                case 11: zzIsFinal = true; zzState = 55; break zzForNext;
                default: break zzForAction;
              }

            case 160:
              switch (zzInput) {
                case 1: 
                case 2: 
                case 10: 
                case 11: 
                case 34: 
                case 35: 
                case 36: 
                case 38: 
                case 62: break zzForAction;
                default: zzIsFinal = true; zzState = 55; break zzForNext;
              }

            case 161:
              switch (zzInput) {
                case 34: zzIsFinal = true; break zzForNext;
                case 59: 
                case 62: zzIsFinal = true; zzState = 195; break zzForNext;
                default: break zzForAction;
              }

            case 162:
              switch (zzInput) {
                case 4: zzIsFinal = true; zzNoLookAhead = true; zzState = 76; break zzForNext;
                case 59: 
                case 62: break zzForNext;
                default: break zzForAction;
              }

            case 163:
              switch (zzInput) {
                case 34: zzIsFinal = true; break zzForNext;
                default: break zzForAction;
              }

            case 165:
              switch (zzInput) {
                case 9: zzIsFinal = true; zzNoLookAhead = true; zzState = 164; break zzForNext;
                default: break zzForAction;
              }

            case 166:
              switch (zzInput) {
                case 9: zzState = 165; break zzForNext;
                case 59: 
                case 62: break zzForNext;
                default: break zzForAction;
              }

            case 167:
              switch (zzInput) {
                case 9: zzIsFinal = true; zzNoLookAhead = true; zzState = 76; break zzForNext;
                default: break zzForAction;
              }

            case 168:
              switch (zzInput) {
                case 9: zzState = 167; break zzForNext;
                case 59: 
                case 62: break zzForNext;
                default: break zzForAction;
              }

            case 169:
              switch (zzInput) {
                case 34: zzIsFinal = true; zzNoLookAhead = true; zzState = 196; break zzForNext;
                default: break zzForAction;
              }

            case 170:
              switch (zzInput) {
                case 34: zzIsFinal = true; break zzForNext;
                default: break zzForAction;
              }

            case 172:
              switch (zzInput) {
                case 1: zzIsFinal = true; zzState = 112; break zzForNext;
                case 2: zzIsFinal = true; zzNoLookAhead = true; zzState = 113; break zzForNext;
                case 59: 
                case 62: break zzForNext;
                default: break zzForAction;
              }

            case 173:
              switch (zzInput) {
                case 21: zzIsFinal = true; zzState = 125; break zzForNext;
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 34: 
                case 35: 
                case 36: 
                case 37: 
                case 38: 
                case 39: 
                case 40: 
                case 41: 
                case 42: 
                case 43: 
                case 44: 
                case 59: 
                case 61: 
                case 62: 
                case 63: 
                case 67: 
                case 68: break zzForAction;
                default: zzIsFinal = true; zzState = 28; break zzForNext;
              }

            case 174:
              switch (zzInput) {
                case 15: zzIsFinal = true; zzState = 125; break zzForNext;
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 34: 
                case 35: 
                case 36: 
                case 37: 
                case 38: 
                case 39: 
                case 40: 
                case 41: 
                case 42: 
                case 43: 
                case 44: 
                case 59: 
                case 61: 
                case 62: 
                case 63: 
                case 67: 
                case 68: break zzForAction;
                default: zzIsFinal = true; zzState = 28; break zzForNext;
              }

            case 175:
              switch (zzInput) {
                case 20: zzIsFinal = true; zzState = 125; break zzForNext;
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 34: 
                case 35: 
                case 36: 
                case 37: 
                case 38: 
                case 39: 
                case 40: 
                case 41: 
                case 42: 
                case 43: 
                case 44: 
                case 59: 
                case 61: 
                case 62: 
                case 63: 
                case 67: 
                case 68: break zzForAction;
                default: zzIsFinal = true; zzState = 28; break zzForNext;
              }

            case 176:
              switch (zzInput) {
                case 20: zzIsFinal = true; zzState = 139; break zzForNext;
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 34: 
                case 35: 
                case 36: 
                case 37: 
                case 38: 
                case 39: 
                case 40: 
                case 41: 
                case 42: 
                case 43: 
                case 44: 
                case 59: 
                case 61: 
                case 62: 
                case 63: 
                case 67: 
                case 68: break zzForAction;
                default: zzIsFinal = true; zzState = 28; break zzForNext;
              }

            case 177:
              switch (zzInput) {
                case 32: zzIsFinal = true; zzState = 197; break zzForNext;
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 34: 
                case 35: 
                case 36: 
                case 37: 
                case 38: 
                case 39: 
                case 40: 
                case 41: 
                case 42: 
                case 43: 
                case 44: 
                case 59: 
                case 61: 
                case 62: 
                case 63: 
                case 67: 
                case 68: break zzForAction;
                default: zzIsFinal = true; zzState = 28; break zzForNext;
              }

            case 178:
              switch (zzInput) {
                case 51: zzIsFinal = true; zzState = 198; break zzForNext;
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 34: 
                case 35: 
                case 36: 
                case 37: 
                case 38: 
                case 39: 
                case 40: 
                case 41: 
                case 42: 
                case 43: 
                case 44: 
                case 59: 
                case 61: 
                case 62: 
                case 63: 
                case 67: 
                case 68: break zzForAction;
                default: zzIsFinal = true; zzState = 28; break zzForNext;
              }

            case 179:
              switch (zzInput) {
                case 15: zzIsFinal = true; zzState = 199; break zzForNext;
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 34: 
                case 35: 
                case 36: 
                case 37: 
                case 38: 
                case 39: 
                case 40: 
                case 41: 
                case 42: 
                case 43: 
                case 44: 
                case 59: 
                case 61: 
                case 62: 
                case 63: 
                case 67: 
                case 68: break zzForAction;
                default: zzIsFinal = true; zzState = 28; break zzForNext;
              }

            case 180:
              switch (zzInput) {
                case 17: zzIsFinal = true; zzState = 200; break zzForNext;
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 34: 
                case 35: 
                case 36: 
                case 37: 
                case 38: 
                case 39: 
                case 40: 
                case 41: 
                case 42: 
                case 43: 
                case 44: 
                case 59: 
                case 61: 
                case 62: 
                case 63: 
                case 67: 
                case 68: break zzForAction;
                default: zzIsFinal = true; zzState = 28; break zzForNext;
              }

            case 181:
              switch (zzInput) {
                case 13: zzIsFinal = true; zzState = 201; break zzForNext;
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 34: 
                case 35: 
                case 36: 
                case 37: 
                case 38: 
                case 39: 
                case 40: 
                case 41: 
                case 42: 
                case 43: 
                case 44: 
                case 59: 
                case 61: 
                case 62: 
                case 63: 
                case 67: 
                case 68: break zzForAction;
                default: zzIsFinal = true; zzState = 28; break zzForNext;
              }

            case 182:
              switch (zzInput) {
                case 21: zzIsFinal = true; zzState = 202; break zzForNext;
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 34: 
                case 35: 
                case 36: 
                case 37: 
                case 38: 
                case 39: 
                case 40: 
                case 41: 
                case 42: 
                case 43: 
                case 44: 
                case 59: 
                case 61: 
                case 62: 
                case 63: 
                case 67: 
                case 68: break zzForAction;
                default: zzIsFinal = true; zzState = 28; break zzForNext;
              }

            case 183:
              switch (zzInput) {
                case 17: zzIsFinal = true; zzState = 203; break zzForNext;
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 34: 
                case 35: 
                case 36: 
                case 37: 
                case 38: 
                case 39: 
                case 40: 
                case 41: 
                case 42: 
                case 43: 
                case 44: 
                case 59: 
                case 61: 
                case 62: 
                case 63: 
                case 67: 
                case 68: break zzForAction;
                default: zzIsFinal = true; zzState = 28; break zzForNext;
              }

            case 184:
              switch (zzInput) {
                case 46: zzIsFinal = true; zzState = 181; break zzForNext;
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 34: 
                case 35: 
                case 36: 
                case 37: 
                case 38: 
                case 39: 
                case 40: 
                case 41: 
                case 42: 
                case 43: 
                case 44: 
                case 59: 
                case 61: 
                case 62: 
                case 63: 
                case 67: 
                case 68: break zzForAction;
                default: zzIsFinal = true; zzState = 28; break zzForNext;
              }

            case 185:
              switch (zzInput) {
                case 27: zzIsFinal = true; zzState = 204; break zzForNext;
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 34: 
                case 35: 
                case 36: 
                case 37: 
                case 38: 
                case 39: 
                case 40: 
                case 41: 
                case 42: 
                case 43: 
                case 44: 
                case 59: 
                case 61: 
                case 62: 
                case 63: 
                case 67: 
                case 68: break zzForAction;
                default: zzIsFinal = true; zzState = 28; break zzForNext;
              }

            case 186:
              switch (zzInput) {
                case 25: zzIsFinal = true; zzState = 125; break zzForNext;
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 34: 
                case 35: 
                case 36: 
                case 37: 
                case 38: 
                case 39: 
                case 40: 
                case 41: 
                case 42: 
                case 43: 
                case 44: 
                case 59: 
                case 61: 
                case 62: 
                case 63: 
                case 67: 
                case 68: break zzForAction;
                default: zzIsFinal = true; zzState = 28; break zzForNext;
              }

            case 187:
              switch (zzInput) {
                case 56: zzIsFinal = true; zzState = 205; break zzForNext;
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 34: 
                case 35: 
                case 36: 
                case 37: 
                case 38: 
                case 39: 
                case 40: 
                case 41: 
                case 42: 
                case 43: 
                case 44: 
                case 59: 
                case 61: 
                case 62: 
                case 63: 
                case 67: 
                case 68: break zzForAction;
                default: zzIsFinal = true; zzState = 28; break zzForNext;
              }

            case 188:
              switch (zzInput) {
                case 56: zzIsFinal = true; zzState = 206; break zzForNext;
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 34: 
                case 35: 
                case 36: 
                case 37: 
                case 38: 
                case 39: 
                case 40: 
                case 41: 
                case 42: 
                case 43: 
                case 44: 
                case 59: 
                case 61: 
                case 62: 
                case 63: 
                case 67: 
                case 68: break zzForAction;
                default: zzIsFinal = true; zzState = 28; break zzForNext;
              }

            case 189:
              switch (zzInput) {
                case 49: zzIsFinal = true; zzState = 191; break zzForNext;
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 34: 
                case 35: 
                case 36: 
                case 37: 
                case 38: 
                case 39: 
                case 40: 
                case 41: 
                case 42: 
                case 43: 
                case 44: 
                case 59: 
                case 61: 
                case 62: 
                case 63: 
                case 67: 
                case 68: break zzForAction;
                default: zzIsFinal = true; zzState = 28; break zzForNext;
              }

            case 190:
              switch (zzInput) {
                case 51: zzIsFinal = true; zzState = 207; break zzForNext;
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 34: 
                case 35: 
                case 36: 
                case 37: 
                case 38: 
                case 39: 
                case 40: 
                case 41: 
                case 42: 
                case 43: 
                case 44: 
                case 59: 
                case 61: 
                case 62: 
                case 63: 
                case 67: 
                case 68: break zzForAction;
                default: zzIsFinal = true; zzState = 28; break zzForNext;
              }

            case 191:
              switch (zzInput) {
                case 17: zzIsFinal = true; zzState = 139; break zzForNext;
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 34: 
                case 35: 
                case 36: 
                case 37: 
                case 38: 
                case 39: 
                case 40: 
                case 41: 
                case 42: 
                case 43: 
                case 44: 
                case 59: 
                case 61: 
                case 62: 
                case 63: 
                case 67: 
                case 68: break zzForAction;
                default: zzIsFinal = true; zzState = 28; break zzForNext;
              }

            case 192:
              switch (zzInput) {
                case 13: zzIsFinal = true; zzState = 208; break zzForNext;
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 34: 
                case 35: 
                case 36: 
                case 37: 
                case 38: 
                case 39: 
                case 40: 
                case 41: 
                case 42: 
                case 43: 
                case 44: 
                case 59: 
                case 61: 
                case 62: 
                case 63: 
                case 67: 
                case 68: break zzForAction;
                default: zzIsFinal = true; zzState = 28; break zzForNext;
              }

            case 193:
              switch (zzInput) {
                case 22: zzIsFinal = true; zzState = 209; break zzForNext;
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 34: 
                case 35: 
                case 36: 
                case 37: 
                case 38: 
                case 39: 
                case 40: 
                case 41: 
                case 42: 
                case 43: 
                case 44: 
                case 59: 
                case 61: 
                case 62: 
                case 63: 
                case 67: 
                case 68: break zzForAction;
                default: zzIsFinal = true; zzState = 28; break zzForNext;
              }

            case 194:
              switch (zzInput) {
                case 65: zzIsFinal = true; break zzForNext;
                default: break zzForAction;
              }

            case 195:
              switch (zzInput) {
                case 59: 
                case 62: zzIsFinal = true; break zzForNext;
                default: break zzForAction;
              }

            case 197:
              switch (zzInput) {
                case 25: zzIsFinal = true; zzState = 210; break zzForNext;
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 34: 
                case 35: 
                case 36: 
                case 37: 
                case 38: 
                case 39: 
                case 40: 
                case 41: 
                case 42: 
                case 43: 
                case 44: 
                case 59: 
                case 61: 
                case 62: 
                case 63: 
                case 67: 
                case 68: break zzForAction;
                default: zzIsFinal = true; zzState = 28; break zzForNext;
              }

            case 198:
              switch (zzInput) {
                case 13: zzIsFinal = true; zzState = 211; break zzForNext;
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 34: 
                case 35: 
                case 36: 
                case 37: 
                case 38: 
                case 39: 
                case 40: 
                case 41: 
                case 42: 
                case 43: 
                case 44: 
                case 59: 
                case 61: 
                case 62: 
                case 63: 
                case 67: 
                case 68: break zzForAction;
                default: zzIsFinal = true; zzState = 28; break zzForNext;
              }

            case 199:
              switch (zzInput) {
                case 56: zzIsFinal = true; zzState = 212; break zzForNext;
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 34: 
                case 35: 
                case 36: 
                case 37: 
                case 38: 
                case 39: 
                case 40: 
                case 41: 
                case 42: 
                case 43: 
                case 44: 
                case 59: 
                case 61: 
                case 62: 
                case 63: 
                case 67: 
                case 68: break zzForAction;
                default: zzIsFinal = true; zzState = 28; break zzForNext;
              }

            case 200:
              switch (zzInput) {
                case 19: zzIsFinal = true; zzState = 31; break zzForNext;
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 34: 
                case 35: 
                case 36: 
                case 37: 
                case 38: 
                case 39: 
                case 40: 
                case 41: 
                case 42: 
                case 43: 
                case 44: 
                case 59: 
                case 61: 
                case 62: 
                case 63: 
                case 67: 
                case 68: break zzForAction;
                default: zzIsFinal = true; zzState = 28; break zzForNext;
              }

            case 201:
              switch (zzInput) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 34: 
                case 35: 
                case 36: 
                case 37: 
                case 38: 
                case 39: 
                case 40: 
                case 41: 
                case 42: 
                case 43: 
                case 44: 
                case 59: 
                case 61: 
                case 62: 
                case 63: 
                case 67: 
                case 68: break zzForAction;
                default: zzIsFinal = true; zzState = 28; break zzForNext;
              }

            case 202:
              switch (zzInput) {
                case 17: zzIsFinal = true; zzState = 201; break zzForNext;
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 34: 
                case 35: 
                case 36: 
                case 37: 
                case 38: 
                case 39: 
                case 40: 
                case 41: 
                case 42: 
                case 43: 
                case 44: 
                case 59: 
                case 61: 
                case 62: 
                case 63: 
                case 67: 
                case 68: break zzForAction;
                default: zzIsFinal = true; zzState = 28; break zzForNext;
              }

            case 203:
              switch (zzInput) {
                case 51: zzIsFinal = true; zzState = 213; break zzForNext;
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 34: 
                case 35: 
                case 36: 
                case 37: 
                case 38: 
                case 39: 
                case 40: 
                case 41: 
                case 42: 
                case 43: 
                case 44: 
                case 59: 
                case 61: 
                case 62: 
                case 63: 
                case 67: 
                case 68: break zzForAction;
                default: zzIsFinal = true; zzState = 28; break zzForNext;
              }

            case 204:
              switch (zzInput) {
                case 28: zzIsFinal = true; zzState = 214; break zzForNext;
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 34: 
                case 35: 
                case 36: 
                case 37: 
                case 38: 
                case 39: 
                case 40: 
                case 41: 
                case 42: 
                case 43: 
                case 44: 
                case 59: 
                case 61: 
                case 62: 
                case 63: 
                case 67: 
                case 68: break zzForAction;
                default: zzIsFinal = true; zzState = 28; break zzForNext;
              }

            case 205:
              switch (zzInput) {
                case 46: zzIsFinal = true; zzState = 215; break zzForNext;
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 34: 
                case 35: 
                case 36: 
                case 37: 
                case 38: 
                case 39: 
                case 40: 
                case 41: 
                case 42: 
                case 43: 
                case 44: 
                case 59: 
                case 61: 
                case 62: 
                case 63: 
                case 67: 
                case 68: break zzForAction;
                default: zzIsFinal = true; zzState = 28; break zzForNext;
              }

            case 206:
              switch (zzInput) {
                case 57: zzIsFinal = true; zzState = 202; break zzForNext;
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 34: 
                case 35: 
                case 36: 
                case 37: 
                case 38: 
                case 39: 
                case 40: 
                case 41: 
                case 42: 
                case 43: 
                case 44: 
                case 59: 
                case 61: 
                case 62: 
                case 63: 
                case 67: 
                case 68: break zzForAction;
                default: zzIsFinal = true; zzState = 28; break zzForNext;
              }

            case 207:
              switch (zzInput) {
                case 48: zzIsFinal = true; zzState = 139; break zzForNext;
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 34: 
                case 35: 
                case 36: 
                case 37: 
                case 38: 
                case 39: 
                case 40: 
                case 41: 
                case 42: 
                case 43: 
                case 44: 
                case 59: 
                case 61: 
                case 62: 
                case 63: 
                case 67: 
                case 68: break zzForAction;
                default: zzIsFinal = true; zzState = 28; break zzForNext;
              }

            case 208:
              switch (zzInput) {
                case 19: zzIsFinal = true; zzState = 216; break zzForNext;
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 34: 
                case 35: 
                case 36: 
                case 37: 
                case 38: 
                case 39: 
                case 40: 
                case 41: 
                case 42: 
                case 43: 
                case 44: 
                case 59: 
                case 61: 
                case 62: 
                case 63: 
                case 67: 
                case 68: break zzForAction;
                default: zzIsFinal = true; zzState = 28; break zzForNext;
              }

            case 209:
              switch (zzInput) {
                case 54: zzIsFinal = true; zzState = 201; break zzForNext;
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 34: 
                case 35: 
                case 36: 
                case 37: 
                case 38: 
                case 39: 
                case 40: 
                case 41: 
                case 42: 
                case 43: 
                case 44: 
                case 59: 
                case 61: 
                case 62: 
                case 63: 
                case 67: 
                case 68: break zzForAction;
                default: zzIsFinal = true; zzState = 28; break zzForNext;
              }

            case 210:
              switch (zzInput) {
                case 33: zzIsFinal = true; zzState = 125; break zzForNext;
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 34: 
                case 35: 
                case 36: 
                case 37: 
                case 38: 
                case 39: 
                case 40: 
                case 41: 
                case 42: 
                case 43: 
                case 44: 
                case 59: 
                case 61: 
                case 62: 
                case 63: 
                case 67: 
                case 68: break zzForAction;
                default: zzIsFinal = true; zzState = 28; break zzForNext;
              }

            case 211:
              switch (zzInput) {
                case 19: zzIsFinal = true; zzState = 217; break zzForNext;
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 34: 
                case 35: 
                case 36: 
                case 37: 
                case 38: 
                case 39: 
                case 40: 
                case 41: 
                case 42: 
                case 43: 
                case 44: 
                case 59: 
                case 61: 
                case 62: 
                case 63: 
                case 67: 
                case 68: break zzForAction;
                default: zzIsFinal = true; zzState = 28; break zzForNext;
              }

            case 212:
              switch (zzInput) {
                case 20: zzIsFinal = true; zzState = 218; break zzForNext;
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 34: 
                case 35: 
                case 36: 
                case 37: 
                case 38: 
                case 39: 
                case 40: 
                case 41: 
                case 42: 
                case 43: 
                case 44: 
                case 59: 
                case 61: 
                case 62: 
                case 63: 
                case 67: 
                case 68: break zzForAction;
                default: zzIsFinal = true; zzState = 28; break zzForNext;
              }

            case 213:
              switch (zzInput) {
                case 13: zzIsFinal = true; zzState = 139; break zzForNext;
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 34: 
                case 35: 
                case 36: 
                case 37: 
                case 38: 
                case 39: 
                case 40: 
                case 41: 
                case 42: 
                case 43: 
                case 44: 
                case 59: 
                case 61: 
                case 62: 
                case 63: 
                case 67: 
                case 68: break zzForAction;
                default: zzIsFinal = true; zzState = 28; break zzForNext;
              }

            case 214:
              switch (zzInput) {
                case 29: zzIsFinal = true; zzState = 219; break zzForNext;
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 34: 
                case 35: 
                case 36: 
                case 37: 
                case 38: 
                case 39: 
                case 40: 
                case 41: 
                case 42: 
                case 43: 
                case 44: 
                case 59: 
                case 61: 
                case 62: 
                case 63: 
                case 67: 
                case 68: break zzForAction;
                default: zzIsFinal = true; zzState = 28; break zzForNext;
              }

            case 215:
              switch (zzInput) {
                case 20: zzIsFinal = true; zzState = 201; break zzForNext;
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 34: 
                case 35: 
                case 36: 
                case 37: 
                case 38: 
                case 39: 
                case 40: 
                case 41: 
                case 42: 
                case 43: 
                case 44: 
                case 59: 
                case 61: 
                case 62: 
                case 63: 
                case 67: 
                case 68: break zzForAction;
                default: zzIsFinal = true; zzState = 28; break zzForNext;
              }

            case 216:
              switch (zzInput) {
                case 20: zzIsFinal = true; zzState = 220; break zzForNext;
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 34: 
                case 35: 
                case 36: 
                case 37: 
                case 38: 
                case 39: 
                case 40: 
                case 41: 
                case 42: 
                case 43: 
                case 44: 
                case 59: 
                case 61: 
                case 62: 
                case 63: 
                case 67: 
                case 68: break zzForAction;
                default: zzIsFinal = true; zzState = 28; break zzForNext;
              }

            case 217:
              switch (zzInput) {
                case 45: zzIsFinal = true; zzState = 221; break zzForNext;
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 34: 
                case 35: 
                case 36: 
                case 37: 
                case 38: 
                case 39: 
                case 40: 
                case 41: 
                case 42: 
                case 43: 
                case 44: 
                case 59: 
                case 61: 
                case 62: 
                case 63: 
                case 67: 
                case 68: break zzForAction;
                default: zzIsFinal = true; zzState = 28; break zzForNext;
              }

            case 218:
              switch (zzInput) {
                case 51: zzIsFinal = true; zzState = 222; break zzForNext;
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 34: 
                case 35: 
                case 36: 
                case 37: 
                case 38: 
                case 39: 
                case 40: 
                case 41: 
                case 42: 
                case 43: 
                case 44: 
                case 59: 
                case 61: 
                case 62: 
                case 63: 
                case 67: 
                case 68: break zzForAction;
                default: zzIsFinal = true; zzState = 28; break zzForNext;
              }

            case 219:
              switch (zzInput) {
                case 30: zzIsFinal = true; zzState = 125; break zzForNext;
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 34: 
                case 35: 
                case 36: 
                case 37: 
                case 38: 
                case 39: 
                case 40: 
                case 41: 
                case 42: 
                case 43: 
                case 44: 
                case 59: 
                case 61: 
                case 62: 
                case 63: 
                case 67: 
                case 68: break zzForAction;
                default: zzIsFinal = true; zzState = 28; break zzForNext;
              }

            case 220:
              switch (zzInput) {
                case 56: zzIsFinal = true; zzState = 202; break zzForNext;
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 34: 
                case 35: 
                case 36: 
                case 37: 
                case 38: 
                case 39: 
                case 40: 
                case 41: 
                case 42: 
                case 43: 
                case 44: 
                case 59: 
                case 61: 
                case 62: 
                case 63: 
                case 67: 
                case 68: break zzForAction;
                default: zzIsFinal = true; zzState = 28; break zzForNext;
              }

            case 221:
              switch (zzInput) {
                case 20: zzIsFinal = true; zzState = 223; break zzForNext;
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 34: 
                case 35: 
                case 36: 
                case 37: 
                case 38: 
                case 39: 
                case 40: 
                case 41: 
                case 42: 
                case 43: 
                case 44: 
                case 59: 
                case 61: 
                case 62: 
                case 63: 
                case 67: 
                case 68: break zzForAction;
                default: zzIsFinal = true; zzState = 28; break zzForNext;
              }

            case 222:
              switch (zzInput) {
                case 13: zzIsFinal = true; zzState = 224; break zzForNext;
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 34: 
                case 35: 
                case 36: 
                case 37: 
                case 38: 
                case 39: 
                case 40: 
                case 41: 
                case 42: 
                case 43: 
                case 44: 
                case 59: 
                case 61: 
                case 62: 
                case 63: 
                case 67: 
                case 68: break zzForAction;
                default: zzIsFinal = true; zzState = 28; break zzForNext;
              }

            case 223:
              switch (zzInput) {
                case 3: zzIsFinal = true; zzNoLookAhead = true; zzState = 225; break zzForNext;
                case 59: 
                case 62: zzIsFinal = true; zzState = 226; break zzForNext;
                case 0: 
                case 1: 
                case 2: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 34: 
                case 35: 
                case 36: 
                case 37: 
                case 38: 
                case 39: 
                case 40: 
                case 41: 
                case 42: 
                case 43: 
                case 44: 
                case 61: 
                case 63: 
                case 67: 
                case 68: break zzForAction;
                default: zzIsFinal = true; zzState = 28; break zzForNext;
              }

            case 224:
              switch (zzInput) {
                case 19: zzIsFinal = true; zzState = 227; break zzForNext;
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 34: 
                case 35: 
                case 36: 
                case 37: 
                case 38: 
                case 39: 
                case 40: 
                case 41: 
                case 42: 
                case 43: 
                case 44: 
                case 59: 
                case 61: 
                case 62: 
                case 63: 
                case 67: 
                case 68: break zzForAction;
                default: zzIsFinal = true; zzState = 28; break zzForNext;
              }

            case 226:
              switch (zzInput) {
                case 59: 
                case 62: zzIsFinal = true; break zzForNext;
                default: break zzForAction;
              }

            case 227:
              switch (zzInput) {
                case 45: zzIsFinal = true; zzState = 228; break zzForNext;
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 34: 
                case 35: 
                case 36: 
                case 37: 
                case 38: 
                case 39: 
                case 40: 
                case 41: 
                case 42: 
                case 43: 
                case 44: 
                case 59: 
                case 61: 
                case 62: 
                case 63: 
                case 67: 
                case 68: break zzForAction;
                default: zzIsFinal = true; zzState = 28; break zzForNext;
              }

            case 228:
              switch (zzInput) {
                case 20: zzIsFinal = true; zzState = 229; break zzForNext;
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 34: 
                case 35: 
                case 36: 
                case 37: 
                case 38: 
                case 39: 
                case 40: 
                case 41: 
                case 42: 
                case 43: 
                case 44: 
                case 59: 
                case 61: 
                case 62: 
                case 63: 
                case 67: 
                case 68: break zzForAction;
                default: zzIsFinal = true; zzState = 28; break zzForNext;
              }

            case 229:
              switch (zzInput) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 34: 
                case 35: 
                case 36: 
                case 37: 
                case 38: 
                case 39: 
                case 40: 
                case 41: 
                case 42: 
                case 43: 
                case 44: 
                case 59: 
                case 61: 
                case 62: 
                case 63: 
                case 67: 
                case 68: break zzForAction;
                default: zzIsFinal = true; zzState = 28; break zzForNext;
              }

            default:
              // if this is ever reached, there is a serious bug in JFlex
              zzScanError(ZZ_UNKNOWN_ERROR);
              break;
          } }

          if ( zzIsFinal ) {
            zzAction = zzState;
            zzMarkedPosL = zzCurrentPosL;
            if ( zzNoLookAhead ) break zzForAction;
          }

        }
      }

      // store back cached position
      zzMarkedPos = zzMarkedPosL;

      switch (zzAction < 0 ? zzAction : ZZ_ACTION[zzAction]) {
        case 49: 
          { handler.handleDefault(", ");
          }
        case 75: break;
        case 2: 
          { handler.handleComment(yytext());
          }
        case 76: break;
        case 8: 
          { if (transposable) {
                                       handler.handleOperator("&#0039;");
                                   } else {
                                       beginString = zzStartRead;
                                       yybegin(QSTRING);
                                       handler.handleString("&#0039;");
                                   }
          }
        case 77: break;
        case 56: 
          { handler.handleNothing("\n");
          }
        case 78: break;
        case 9: 
          { transposable = false;
                                   beginString = zzStartRead;
                                   yybegin(QSTRING);
                                   handler.handleString("&#0034;");
          }
        case 79: break;
        case 63: 
          { transposable = false;
                                   handler.handleOperator("&#0060;=");
          }
        case 80: break;
        case 50: 
          { handler.handleOpenClose(")");
                                   yybegin(YYINITIAL);
          }
        case 81: break;
        case 68: 
          { handler.handleSpecial(yytext());
                                   yybegin(BREAKINARGS);
          }
        case 82: break;
        case 36: 
          { handler.handleDefault(yytext());
          }
        case 83: break;
        case 44: 
          { id = yytext();
                                   localFun.add(id);
                                   handler.handleFunctionIdDecl(id);
          }
        case 84: break;
        case 62: 
          { transposable = false;
                                   handler.handleOperator("&#0060;&#0062;");
          }
        case 85: break;
        case 65: 
          { yypushback(yylength());
                                   yybegin(BREAKSTRING);
                                   transposable = false;
                                   handler.handleString(yytext());
          }
        case 86: break;
        case 28: 
          { handler.handleComment("&#0060;");
          }
        case 87: break;
        case 30: 
          { handler.handleComment("&#0038;");
          }
        case 88: break;
        case 1: 
          { handler.handleString(yytext());
          }
        case 89: break;
        case 37: 
          { if (breakstring) {
                                      breakstring = false;
                                      saveLexState = QSTRING;
                                   } else {
                                      saveLexState = YYINITIAL;
                                   }
                                   handler.handleNothing("\n");
                                   yybegin(CLEAN);
          }
        case 90: break;
        case 74: 
          { transposable = false;
                                   returnValues.clear();
                                   argsValues.clear();
                                   handler.handleFKeywords("endfunction");
          }
        case 91: break;
        case 22: 
          { transposable = false;
                                   handler.handleString("&#0060;");
          }
        case 92: break;
        case 41: 
          { returnValues.add(id);
                                   handler.handleInputOutputArgsDecl(id);
                                   handler.handleOperator("=");
                                   yybegin(FUNNAME);
          }
        case 93: break;
        case 58: 
          { transposable = false;
                                   yypushback(2);
                                   yybegin(COMMENT);
          }
        case 94: break;
        case 16: 
          { transposable = false;
                                   handler.handleSpecial(yytext());
          }
        case 95: break;
        case 73: 
          { transposable = false;
                                   handler.handleFKeywords("function");
                                   handler.handleNothing(" ");
                                   yybegin(FUNCTION);
          }
        case 96: break;
        case 24: 
          { transposable = false;
                                   handler.handleString("&#0038;");
          }
        case 97: break;
        case 48: 
          { handler.handleOperator("=");
                                   yybegin(FUNNAME);
          }
        case 98: break;
        case 10: 
          { transposable = true;
                                   String str = yytext();
                                   if (commands.contains(str)) {
                                       yybegin(COMMANDS);
                                       handler.handleCommand(str);
                                   } else if (macros.contains(str)) {
                                       yybegin(COMMANDS);
                                       handler.handleMacro(str);
                                   } else if (localFun.contains(str)) {
                                        yybegin(COMMANDS);
                                        handler.handleFunctionId(str);
                                   } else {
                                       if (returnValues.contains(str) || argsValues.contains(str)) {
                                           handler.handleInputOutputArgs(str);
                                       }  else {
                                           handler.handleId(str);
                                       }
                                   }
          }
        case 99: break;
        case 45: 
          { handler.handleOpenClose("[");
          }
        case 100: break;
        case 34: 
          { yybegin(COMMANDSWHITE);
                                   handler.handleNothing(" ");
          }
        case 101: break;
        case 72: 
          { transposable = false;
                                   handler.handleFKeywords("function");
                                   handler.handleNothing(" ");
                                   handler.handleOpenClose("[");
                                   yybegin(RETS);
          }
        case 102: break;
        case 66: 
          { breakstring = true;
                                   handler.handleSpecial(yytext());
          }
        case 103: break;
        case 46: 
          { handler.handleOpenClose("]");
          }
        case 104: break;
        case 12: 
          { transposable = false;
                                   handler.handleOperator("&#0060;");
          }
        case 105: break;
        case 14: 
          { transposable = false;
                                   handler.handleOperator("&#0038;");
          }
        case 106: break;
        case 69: 
          { breakargs = true;
                                   yypushback(2);
                                   yybegin(COMMENT);
          }
        case 107: break;
        case 64: 
          { transposable = false;
                                   handler.handleOperator("&#0062;=");
          }
        case 108: break;
        case 21: 
          { transposable = false;
                                   yybegin(YYINITIAL);
                                   handler.handleString("&#0034;");
          }
        case 109: break;
        case 18: 
          { transposable = true;
                                   handler.handleNumber(yytext());
          }
        case 110: break;
        case 70: 
          { handler.handleNothing("...");
          }
        case 111: break;
        case 43: 
          { handler.handleOpenClose("(");
                                   yybegin(ARGS);
          }
        case 112: break;
        case 7: 
          { transposable = false;
                                   handler.handleOperator(yytext());
          }
        case 113: break;
        case 20: 
          { transposable = false;
                                   yybegin(YYINITIAL);
                                   handler.handleString("&#0039;");
          }
        case 114: break;
        case 57: 
          { int len = yylength() - whitesOnFirstLine;
                                   if (len > 0) {
                                      yypushback(len);
                                   }
                                   yybegin(saveLexState);
          }
        case 115: break;
        case 32: 
          { handler.handleField(yytext());
          }
        case 116: break;
        case 5: 
          { transposable = false;
                                   handler.handleOpenClose(yytext());
          }
        case 117: break;
        case 61: 
          { transposable = false;
                                   handler.handleOperator(".&#0039;");
          }
        case 118: break;
        case 17: 
          { handler.handleNothing("    ");
          }
        case 119: break;
        case 4: 
          { handler.handleNothing("\n");
                                   saveLexState = YYINITIAL;
                                   yybegin(CLEAN);
          }
        case 120: break;
        case 51: 
          { id = yytext();
                                   argsValues.add(id);
                                   handler.handleInputOutputArgsDecl(id);
          }
        case 121: break;
        case 15: 
          { handler.handleNothing(" ");
          }
        case 122: break;
        case 6: 
          { transposable = true;
                                   handler.handleOpenClose(yytext());
          }
        case 123: break;
        case 31: 
          { yypushback(1);
                                   yybegin(YYINITIAL);
          }
        case 124: break;
        case 38: 
          { handler.handleOpenClose("[");
                                   yybegin(RETS);
          }
        case 125: break;
        case 25: 
          { if (breakstring) {
                                     saveLexState = QSTRING;
                                     breakstring = false;
                                   } else if (breakargs) {
                                     saveLexState = WHITESEOL;
                                     breakargs = false;
                                   } else {
                                     saveLexState = YYINITIAL;
                                   }
                                   handler.handleNothing("\n");
                                   yybegin(CLEAN);
          }
        case 126: break;
        case 35: 
          { yybegin(COMMANDSWHITE);
                                   handler.handleNothing("    ");
          }
        case 127: break;
        case 55: 
          { yypushback(1);
                                   yybegin(saveLexState);
          }
        case 128: break;
        case 33: 
          { yypushback(yylength());
                                   yybegin(YYINITIAL);
          }
        case 129: break;
        case 67: 
          { localFun.add(id);
                                   handler.handleFunctionIdDecl(id);
                                   yypushback(yylength());
                                   yybegin(YYINITIAL);
          }
        case 130: break;
        case 52: 
          { handler.handleNothing("\n");
                                   saveLexState = WHITESEOL;
                                   yybegin(CLEAN);
          }
        case 131: break;
        case 47: 
          { id = yytext();
                                   returnValues.add(id);
                                   handler.handleInputOutputArgsDecl(id);
          }
        case 132: break;
        case 59: 
          { transposable = true;
                                   handler.handleConstants(yytext());
          }
        case 133: break;
        case 53: 
          { yypushback(1);
                                   yybegin(ARGS);
          }
        case 134: break;
        case 29: 
          { handler.handleComment("&#0062;");
          }
        case 135: break;
        case 60: 
          { transposable = false;
                                   handler.handleSKeywords(yytext());
          }
        case 136: break;
        case 3: 
          { transposable = false;
                                   handler.handleDefault(yytext());
          }
        case 137: break;
        case 11: 
          { transposable = false;
                                   yybegin(FIELD);
                                   handler.handleOperator(yytext());
          }
        case 138: break;
        case 19: 
          { return;
          }
        case 139: break;
        case 23: 
          { transposable = false;
                                   handler.handleString("&#0062;");
          }
        case 140: break;
        case 39: 
          { id = yytext();
                                   yybegin(TYPEID);
          }
        case 141: break;
        case 54: 
          { whitesOnFirstLine = yylength();
                                   yybegin(YYINITIAL);
          }
        case 142: break;
        case 27: 
          { handler.handleComment("&#0034;");
          }
        case 143: break;
        case 71: 
          { transposable = false;
                                   handler.handleCKeywords(yytext());
          }
        case 144: break;
        case 40: 
          { localFun.add(id);
                                   handler.handleFunctionIdDecl(id);
                                   handler.handleOpenClose("(");
                                   yybegin(ARGS);
          }
        case 145: break;
        case 26: 
          { handler.handleComment("&#0039;");
          }
        case 146: break;
        case 13: 
          { transposable = false;
                                   handler.handleOperator("&#0062;");
          }
        case 147: break;
        case 42: 
          { 
          }
        case 148: break;
        default: 
          if (zzInput == YYEOF && zzStartRead == zzCurrentPos) {
            zzAtEOF = true;
              {
                return;
              }
          } 
          else {
            zzScanError(ZZ_NO_MATCH);
          }
      }
    }
  }


}
