//  Scicos
//
//  Copyright (C) INRIA - METALAU Project <scicos@inria.fr>
//                      - Serge Steer <serge.steer@inria.fr> - 2003
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
//
// See the file ../license.txt
//

function [ok,name,nipar,nrpar,nopar,nz,nx,nx_der,nx_ns,nin,nout,nm,ng,dep_u]=compile_modelica(filemo,Mblocks)

// Copyright INRIA
// Modelica_Init becomes true only in "Modelicainitialize_.sci"
  if exists('%Modelica_Init')==0 then %Modelica_Init=%f;end
  if exists('%Jacobian')==0 then %Jacobian=%t; end
  if exists('%Modelica_ParEmb')==0 then %Modelica_ParEmb=%t; end

  //Initialize lhs arguments in case of return on error
  name='';
  dep_u=%t; nipar=0;nrpar=0;nopar=0;
  nz=0;nx=0;nx_der=0;nx_ns=0;nin=0;nout=0;nm=0;ng=0;

  // modelica UI initialization is always ignored
  running="off";
 
  //set paths for generated files  
  outpath=pathconvert(TMPDIR,%t,%t);  


  name=basename(filemo)
  namef=name+'f';
  
  
  //Flat modelica file generated by translator
  Flat=outpath+namef+'.mo';// flat modelica file path
  
  //xml files generated by translator and/or edited by Initialization GUI
  xmlfile=outpath+namef+'_init.xml';// initialization XML 
  Relfile=outpath+namef+'_relations.xml';

  //files generated by modelicac
  Cfile=outpath+name+'.c' //C code of the simulation function
  incidence=outpath+name+"_incidence_matrix.xml" //incidence matrix

  //files generated for the scicos simulation by translator 
  Flat_functions=outpath+namef+'_functions.mo';
  xmlfileTMP=outpath+name+'Sim.xml';  

  //do not update C code if not required this allows C code
  //modifications for debugging purposes  
  updateC=needcompile<>0|fileinfo(Cfile)==[]| %Modelica_Init 
  
  if updateC  then
    
    //Generate the flat model if it does not exist yet (It may have been
    //generated by the initialization GUI
    if ( %Modelica_Init ) then 
      if (fileinfo(xmlfile)==[]) then 
	overwrite=%t;//Yes
      else
	overwrite=messagebox([_('The initialization file already exists!');
		              _('Do you want to overwrite it?') ],..
			     '','question',[_('Yes'),_('No')],'modal')==1      
      end
    else     
      // do not generate the flat file when it is already generated by
      // the initialization GUI
      overwrite=(running <>"1")
    end
       
    if overwrite then 
      // generate with filemo the Modelica flat model,the xml files,
      //  and files needed for the scicos simulation
      [ok]=translator(filemo,Mblocks,modelica_libs,Flat)
      if ~ok then  dep_u=%t; return,end
    end

    // if the initialisation GUI is used
    if (%Modelica_Init) then //---------------------------
      mprintf('%s',' Init XML file : '+xmlfile); mprintf('\n\r');
      mprintf('%s',' Init Rel file : '+Relfile); mprintf('\n\r');
      name=Flat;
      //<<ALERT dep_u of the initialization block is obtained only when the  C
      // code is generated.
      dep_u=%t;
      ok=%t,
      return;
    else
      mprintf('%s\n',' Flat Modelica : '+Flat); 
    end

    //Generate the C file with modelicac
    //---------------------------------------------------------------------
    ok=modelicac(Flat,Flat_functions,xmlfileTMP,%Jacobian,Cfile,running=="1")

    if ~ok then return,end
    mprintf(' Simulation C code :%s\n', Cfile);
    //---------------------------------------------------------------------
  end // if update

  [nipar,nrpar,nopar,nz,nx,nx_der,nx_ns,nin,nout,nm,ng,dep_u]=reading_incidence(incidence)
  depu(dep_u)='T';  depu(~dep_u)='F';depu=strcat(depu);
  
  messagebox([_('Modelica blocks are reduced to a block with:') ;
	      msprintf(_('Number of differential states: %d'),nx_der);
	      msprintf(_('Number of algebraic states: %d'),nx-nx_der);
	      msprintf(_('Number of discrete time states  : %d'),nz);
	      msprintf(_('Number of zero-crossing surfaces: %d'),ng);
	      msprintf(_('Number of modes  : %d'),nm);
	      msprintf(_('Number of inputs : %d'),nin);
	      msprintf(_('Number of outputs: %d'),nout);
	      msprintf(_('Input/output dependency:[%s]'),depu)
	      msprintf(_('Analytical Jacobian: enabled  (%%Jacobian=%s)'),sci2exp(%Jacobian));
	      msprintf(_('Parameter embedding mode: enabled (%%Modelica_ParEmb=%s)'),sci2exp(%Modelica_ParEmb))
	      ''
	      msprintf(_('Generated files path: %s'),outpath)
	      ''],'info');

  //compile and link the generated C file
  ok=Link_modelica_C(Cfile)

endfunction
