//
// Scilab ( http://www.scilab.org/ ) - This file is part of Scilab
// Copyright (C) 2008 - INRIA - Pierre MARECHAL
//
// This file must be used under the terms of the CeCILL.
// This source file is licensed as described in the file COPYING, which
// you should have received as part of this distribution.  The terms
// are also available at
// http://www.cecill.info/licences/Licence_CeCILL_V2-en.txt
//

function uicontrol_plot3d()
	
	global margin_x;
	global margin_y;
	
	global padding_x;
	global padding_y;
	
	global frame_w;
	global frame_h;
	
	global plot_w;
	global plot_h;
	
	// Parameters
	// =========================================================================
	
	frame_w            = 300;     // Frame width
	frame_h            = 550;     // Frame height
	
	plot_w             = 600;     // Plot width
	plot_h             = frame_h; // Plot height
	
	margin_x           = 15;      // Horizontal margin between each elements
	margin_y           = 15;      // Vertical margin between each elements
	
	padding_x          = 10;      // Horizontal padding between each elements
	padding_y          = 10;      // Vertical padding between each elements
	
	button_w           = 100;     // Button width
	button_h           = 30;      // Button height
	
	defaultfont        = "arial"; // Default Font
	subframe_font_size = 12;      // Title font size (Rotation angle, Colormap, ...)
	text_font_size     = 11;      // Text font size
	
	
	// Figure creation
	// ========================================================================= 
	
	axes_w       = 3*margin_x + frame_w + plot_w; // axes width
	axes_h       = 2*margin_y + frame_h;          // axes height (100 => toolbar height)
	
	demo_plot3d = scf(100001);
	
	// Remove Scilab graphics menus & toolbar
	
	delmenu(demo_plot3d.figure_id, gettext("&File"));
	delmenu(demo_plot3d.figure_id, gettext("&Tools"));
	delmenu(demo_plot3d.figure_id, gettext("&Edit"));
	delmenu(demo_plot3d.figure_id, gettext("&?"));
	toolbar(demo_plot3d.figure_id, "off");
	
	demo_plot3d.background      = -2;
	demo_plot3d.color_map       = jetcolormap(128);
	demo_plot3d.figure_position = [0 0];
	demo_plot3d.figure_name     = gettext("Control Plot3d");
	
	// New menu
	
	h = uimenu( "parent", demo_plot3d,       ..
				"label" , gettext("File"));
	
	uimenu( "parent"    , h,                 ..
			"label"     , gettext("Close"),  ..
			"callback"  , "demo_plot3d=get_figure_handle(100001);delete(demo_plot3d);", ..
			"tag"       , "close_menu");
	
	sleep(500);
	demo_plot3d.axes_size       = [axes_w axes_h];
	
	// Frames creation [Control Panel]
	// =========================================================================
	
	my_frame = uicontrol( ...
		"parent"              , demo_plot3d,...
		"relief"              , "groove",...
		"style"               , "frame",...
		"units"               , "pixels",...
		"position"            , [ margin_x margin_y frame_w frame_h],...
		"horizontalalignment" , "center", ...
		"background"          , [1 1 1], ...
		"tag"                 , "frame_control" ...
	);
	
	// Frame title
	my_frame_title = uicontrol( ...
		"parent"              , demo_plot3d,...
		"style"               , "text",...
		"string"              , "Control Panel",...
		"units"               , "pixels",...
		"position"            , [ 30+margin_x margin_y+frame_h-10 frame_w-60 20 ],...
		"fontname"            , defaultfont,...
		"fontunits"           , "points",...
		"fontsize"            , 16,...
		"horizontalalignment" , "center", ...
		"background"          , [1 1 1], ...
		"tag"                 , "title_frame_control" ...
	);
	
	
	// Rotation Angle
	// =========================================================================
	
	my_slider_angle = 0;
	
	my_ra_frame_w     = frame_w-2*padding_x
	my_ra_frame_h     = 50;
	my_ra_frame_pos_x = padding_x+margin_x;
	my_ra_frame_pos_y = (margin_y+frame_h) - 4*padding_y - my_ra_frame_h;
	
	my_slider_width      = my_ra_frame_w - 20;
	my_slider_height     = 20;
	my_slider_position_x = my_ra_frame_pos_x + 10;
	my_slider_position_y = my_ra_frame_pos_y + 10;
	
	// frame
	
	my_ra_frame = uicontrol( ...
		"parent"              , demo_plot3d,...
		"relief"              , "groove",...
		"style"               , "frame",...
		"units"               , "pixels",...
		"position"            , [ my_ra_frame_pos_x my_ra_frame_pos_y my_ra_frame_w my_ra_frame_h],...
		"horizontalalignment" , "center", ...
		"background"          , [1 1 1], ...
		"tag"                 , "frame_control" ...
	);
	
	// Frame title
	
	my_ra_frame_title = uicontrol( ...
		"parent"              , demo_plot3d,...
		"style"               , "text",...
		"string"              , "Rotation angle",...
		"units"               , "pixels",...
		"position"            , [ 70+my_ra_frame_pos_x my_ra_frame_pos_y+my_ra_frame_h-9 my_ra_frame_w-140 18 ],...
		"fontname"            , defaultfont,...
		"fontunits"           , "points",...
		"fontsize"            , subframe_font_size,...
		"horizontalalignment" , "center", ...
		"background"          , [1 1 1], ...
		"tag"                 , "title_frame_control" ...
	);
	
	my_slider_angle = uicontrol( ...
		"parent"              , demo_plot3d,...
		"style"               , "slider",...
		"Min"                 , 0,...
		"Max"                 , 360,...
		"Value"               , 70,...
		"SliderStep"          , [2 30],...
		"units"               , "pixels",...
		"position"            , [ my_slider_position_x my_slider_position_y my_slider_width my_slider_height ],...
		"tag"                 , "slider_angle", ...
		"callback"            , "update_plot3d_angle()" ...
	);
	
	// Colormap frame creation
	// =========================================================================
	
	my_cmap_frame_w     = frame_w-2*padding_x
	my_cmap_frame_h     = 100;
	my_cmap_frame_pos_x = padding_x+margin_x;
	my_cmap_frame_pos_y = my_ra_frame_pos_y - 2*padding_y - my_cmap_frame_h;
	
	// Colormap : frame
	
	my_cmap_frame = uicontrol( ...
		"parent"              , demo_plot3d,...
		"relief"              , "groove",...
		"style"               , "frame",...
		"units"               , "pixels",...
		"position"            , [ my_cmap_frame_pos_x my_cmap_frame_pos_y my_cmap_frame_w my_cmap_frame_h],...
		"horizontalalignment" , "center", ...
		"background"          , [1 1 1], ...
		"tag"                 , "frame_control" ...
	);
	
	// Colormap : Frame title
	
	my_cmap_frame_title = uicontrol( ...
		"parent"              , demo_plot3d,...
		"style"               , "text",...
		"string"              , "Colormap",...
		"units"               , "pixels",...
		"position"            , [ 100+my_cmap_frame_pos_x my_cmap_frame_pos_y+my_cmap_frame_h-9 my_cmap_frame_w-200 18 ],...
		"fontname"            , defaultfont,...
		"fontunits"           , "points",...
		"fontsize"            , subframe_font_size,...
		"horizontalalignment" , "center", ...
		"background"          , [1 1 1], ...
		"tag"                 , "title_frame_control" ...
	);
	
	// Colormap : Jetcolormap
	
	jetcolormap_radio = uicontrol( ...
		"parent"             , demo_plot3d,...
		"style"              , "radiobutton",...
		"string"             , "Jetcolormap",...
		"position"           , [ my_cmap_frame_pos_x+10 my_cmap_frame_pos_y+my_cmap_frame_h-50 my_cmap_frame_w-25 15],...
		"horizontalalignment", "left",...
		"fontname"           , defaultfont,...
		"fontunits"          , "points",...
		"fontsize"           , text_font_size,...
		"min"                , 0, ...
		"max"                , 1, ...
		"value"              , 1, ...
		"background"          , [1 1 1], ...
		"callback"           , "update_colormap",...
		"tag"                , "jetcolormap_radio");
	
	// Colormap : Hotcolormap
	
	hotcolormap_radio = uicontrol( ...
		"parent"             , demo_plot3d,...
		"style"              , "radiobutton",...
		"string"             , "Hotcolormap",...
		"position"           , [ my_cmap_frame_pos_x+10 my_cmap_frame_pos_y+my_cmap_frame_h-70 my_cmap_frame_w-25 15],...
		"horizontalalignment", "left",...
		"fontname"           , defaultfont,...
		"fontunits"          , "points",...
		"fontsize"           , text_font_size,...
		"min"                , 0, ...
		"max"                , 1, ...
		"value"              , 0, ...
		"background"          , [1 1 1], ...
		"callback"           , "update_colormap",...
		"tag"                , "hotcolormap_radio");
	
	// Colormap : Graycolormap
	
	graycolormap_radio = uicontrol( ...
		"parent"             , demo_plot3d,...
		"style"              , "radiobutton",...
		"string"             , "Graycolormap",...
		"position"           , [ my_cmap_frame_pos_x+10 my_cmap_frame_pos_y+my_cmap_frame_h-90 my_cmap_frame_w-25 20],...
		"horizontalalignment", "left",...
		"fontname"           , defaultfont,...
		"fontsize"           , text_font_size,...
		"fontunits"          , "points",...
		"min"                , 0, ...
		"max"                , 1, ...
		"value"              , 0, ...
		"background"          , [1 1 1], ...
		"callback"           , "update_colormap",...
		"tag"                , "graycolormap_radio");
	
	
	// Background axes color
	// =========================================================================
	
	
	my_bac_frame_w     = frame_w-2*padding_x
	my_bac_frame_h     = 65;
	my_bac_frame_pos_x = padding_x+margin_x;
	my_bac_frame_pos_y = my_cmap_frame_pos_y - 2*padding_y - my_bac_frame_h;
	
	my_bac_pushbutton_w     = 100;
	my_bac_pushbutton_h     = 30;
	my_bac_pushbutton_pos_x = my_bac_frame_pos_x + floor( (my_bac_frame_w/2) - (my_bac_pushbutton_w/2) );
	my_bac_pushbutton_pos_y = my_bac_frame_pos_y + floor( (my_bac_frame_h/2) - (my_bac_pushbutton_h/2) );
	
	// Background axes color : frame
	
	my_bac_frame = uicontrol( ...
		"parent"              , demo_plot3d,...
		"relief"              , "groove",...
		"style"               , "frame",...
		"units"               , "pixels",...
		"position"            , [ my_bac_frame_pos_x my_bac_frame_pos_y my_bac_frame_w my_bac_frame_h],...
		"horizontalalignment" , "center", ...
		"background"          , [1 1 1], ...
		"tag"                 , "frame_bac" ...
	);
	
	// Background axes color : Frame title
	
	my_bac_frame_title = uicontrol( ...
		"parent"              , demo_plot3d,...
		"style"               , "text",...
		"string"              , "Background Color",...
		"units"               , "pixels",...
		"position"            , [ 70+my_bac_frame_pos_x my_bac_frame_pos_y+my_bac_frame_h-9 my_bac_frame_w-140 18 ],...
		"fontname"            , defaultfont,...
		"fontunits"           , "points",...
		"fontsize"            , subframe_font_size,...
		"horizontalalignment" , "center", ...
		"background"          , [1 1 1], ...
		"tag"                 , "title_frame_bac" ...
	);
	
	// Background axes color : Pushbutton
	
	my_bac_frame_title = uicontrol( ...
		"parent"              , demo_plot3d,...
		"style"               , "pushbutton",...
		"string"              , "",...
		"units"               , "pixels",...
		"position"            , [ my_bac_pushbutton_pos_x my_bac_pushbutton_pos_y my_bac_pushbutton_w my_bac_pushbutton_h],...
		"background"          , [1 1 1], ...
		"callback"            , "update_background_color",...
		"tag"                 , "pushbutton_bac" ...
	);
	
	// show/hide frame creation
	// =========================================================================
	
	my_sh_frame_w     = frame_w-2*padding_x
	my_sh_frame_h     = 120;
	my_sh_frame_pos_x = padding_x+margin_x;
	my_sh_frame_pos_y = my_bac_frame_pos_y - 2*padding_y - my_sh_frame_h;
	
	// show/hide : frame
	
	my_sh_frame = uicontrol( ...
		"parent"              , demo_plot3d,...
		"relief"              , "groove",...
		"style"               , "frame",...
		"units"               , "pixels",...
		"position"            , [ my_sh_frame_pos_x my_sh_frame_pos_y my_sh_frame_w my_sh_frame_h],...
		"horizontalalignment" , "center", ...
		"background"          , [1 1 1], ...
		"tag"                 , "frame_show_hide" ...
	);
	
	// show/hide : Frame title
	
	my_sh_frame_title = uicontrol( ...
		"parent"              , demo_plot3d,...
		"style"               , "text",...
		"string"              , "Show/Hide",...
		"units"               , "pixels",...
		"position"            , [ 100+my_sh_frame_pos_x my_sh_frame_pos_y+my_sh_frame_h-9 my_sh_frame_w-200 18 ],...
		"fontname"            , defaultfont,...
		"fontunits"           , "points",...
		"fontsize"            , subframe_font_size,...
		"horizontalalignment" , "center", ...
		"background"          , [1 1 1], ...
		"tag"                 , "title_frame_show_hide" ...
	);
	
	// show/hide : tics
	
	tics_checkbox = uicontrol( ...
		"parent"             , demo_plot3d,...
		"style"              , "checkbox",...
		"string"             , "Tics",...
		"position"           , [ my_sh_frame_pos_x+10 my_sh_frame_pos_y+my_sh_frame_h-50 my_sh_frame_w-25 15],...
		"horizontalalignment", "left",...
		"fontname"           , defaultfont,...
		"fontunits"          , "points",...
		"fontsize"           , text_font_size,...
		"value"              , 1, ...
		"background"          , [1 1 1], ...
		"callback"           , "update_tics_visible",...
		"tag"                , "tics_checkbox");
	
	// show/hide : title
	
	title_checkbox = uicontrol( ...
		"parent"             , demo_plot3d,...
		"style"              , "checkbox",...
		"string"             , "Title",...
		"position"           , [ my_sh_frame_pos_x+10 my_sh_frame_pos_y+my_sh_frame_h-70 my_sh_frame_w-25 20],...
		"horizontalalignment", "left",...
		"fontname"           , defaultfont,...
		"fontunits"          , "points",...
		"fontsize"           , text_font_size,...
		"value"              , 1, ...
		"background"          , [1 1 1], ...
		"callback"           , "update_title_visible",...
		"tag"                , "title_checkbox");
		
	// show/hide : labels
	
	labels_checkbox = uicontrol( ...
		"parent"             , demo_plot3d,...
		"style"              , "checkbox",...
		"string"             , "Labels",...
		"position"           , [ my_sh_frame_pos_x+10 my_sh_frame_pos_y+my_sh_frame_h-90 my_sh_frame_w-25 20],...
		"horizontalalignment", "left",...
		"fontname"           , defaultfont,...
		"fontunits"          , "points",...
		"fontsize"           , text_font_size,...
		"value"              , 1, ...
		"background"          , [1 1 1], ...
		"callback"           , "update_labels_visible",...
		"tag"                , "labels_checkbox");
		
	// show/hide : edges
	
	labels_checkbox = uicontrol( ...
		"parent"             , demo_plot3d,...
		"style"              , "checkbox",...
		"string"             , "Edges",...
		"position"           , [ my_sh_frame_pos_x+10 my_sh_frame_pos_y+my_sh_frame_h-110 my_sh_frame_w-25 20],...
		"horizontalalignment", "left",...
		"fontname"           , defaultfont,...
		"fontunits"          , "points",...
		"fontsize"           , text_font_size,...
		"value"              , 1, ...
		"background"          , [1 1 1], ...
		"callback"           , "update_edges_visible",...
		"tag"                , "edges_checkbox");
	
	// Edit title
	// =========================================================================
	
	my_edittitle_frame_w     = frame_w-2*padding_x
	my_edittitle_frame_h     = 75;
	my_edittitle_frame_pos_x = padding_x+margin_x;
	my_edittitle_frame_pos_y = my_sh_frame_pos_y - 2*padding_y - my_edittitle_frame_h;
	
	// Edit title : frame
	
	my_edittitle_frame = uicontrol( ...
		"parent"              , demo_plot3d,...
		"relief"              , "groove",...
		"style"               , "frame",...
		"units"               , "pixels",...
		"position"            , [ my_edittitle_frame_pos_x my_edittitle_frame_pos_y my_edittitle_frame_w my_edittitle_frame_h],...
		"horizontalalignment" , "center", ...
		"background"          , [1 1 1], ...
		"tag"                 , "frame_edittitle" ...
	);
	
	// Edit title : Frame title
	
	my_edittitle_frame_title = uicontrol( ...
		"parent"              , demo_plot3d,...
		"style"               , "text",...
		"string"              , "Title",...
		"units"               , "pixels",...
		"position"            , [ 100+my_edittitle_frame_pos_x my_edittitle_frame_pos_y+my_edittitle_frame_h-9 my_edittitle_frame_w-200 18 ],...
		"fontname"            , defaultfont,...
		"fontunits"           , "points",...
		"fontsize"            , subframe_font_size,...
		"horizontalalignment" , "center", ...
		"background"          , [1 1 1], ...
		"tag"                 , "title_frame_edittitle" ...
	);
	
	// Edit title : tics
	
	tics_checkbox = uicontrol( ...
		"parent"             , demo_plot3d,...
		"style"              , "edit",...
		"position"           , [ my_edittitle_frame_pos_x+10 my_edittitle_frame_pos_y+my_edittitle_frame_h-50 my_edittitle_frame_w-25 25],...
		"horizontalalignment", "left",...
		"fontname"           , defaultfont,...
		"fontunits"          , "points",...
		"fontsize"           , text_font_size,...
		"string"             , "My Beautiful Plot", ...
		"callback"           , "update_title_string",...
		"tag"                , "edittitle");
	
	// Plot3d creation
	// =========================================================================
	
	drawlater();
	
	newaxes();
	my_plot_axes = gca();
	
	my_plot_axes.x_label.text       = "X";
	my_plot_axes.y_label.text       = "Y";
	my_plot_axes.z_label.text       = "Z";
	my_plot_axes.title.text         = "My Beautiful Plot";
	my_plot_axes.title.font_size    = 5;
	my_plot_axes.rotation_angles(1) = 80;
	my_plot_axes.axes_bounds        = [1/3,0,2/3,1];
	
	// define colormap
	colormapSize = 128;
	f = gcf();
	f.color_map = jetcolormap(128);
	
	// generate facet coordinates
	x = %pi * [-1:0.05:1]';z = sin(x)*cos(x)';
	[x,y,z] = genfac3d(x,x,z);
	
	// generate colors
	// colors depending on z, between 1 and colormap size
	facetsColors = (z + 1) * (colormapSize - 1) / 2 + 1;
	
	// plot
	plot3d(x,y,list(z, facetsColors));
	
	my_plot3d = gce();
	my_plot3d.color_flag = 3;
	
	my_plot_axes.rotation_angles(1) = 80;
	
	drawnow();
	
endfunction





function update_plot3d_angle()
	
	my_plot_axes = gca();
	my_new_angle = get(gcbo,"Value");
	
	if( my_new_angle>0 & my_new_angle<360 ) then
		my_plot_axes.rotation_angles(2) = my_new_angle;
	end
	
endfunction

function update_colormap()
	
	my_figure    = gcf();
	my_plot_axes = gca();
	
	my_figure.immediate_drawing = "off";
	
	my_cur_color_map    = my_figure.color_map;
	my_cur_bg_color_id  = my_plot_axes.background;
	
	if my_cur_bg_color_id > 32 then
		my_cur_bg_color_r = my_cur_color_map(my_cur_bg_color_id,1);
		my_cur_bg_color_g = my_cur_color_map(my_cur_bg_color_id,2);
		my_cur_bg_color_b = my_cur_color_map(my_cur_bg_color_id,3);
	end
	
	set(findobj("tag", "jetcolormap_radio") , "value", 0);
	set(findobj("tag", "hotcolormap_radio") , "value", 0);
	set(findobj("tag", "graycolormap_radio"), "value", 0);
	
	set(gcbo, "value", 1);
	
	my_wanted_colormap = get(gcbo,"tag");
	
	if get(gcbo, "tag") == "jetcolormap_radio" then
		my_figure.color_map = jetcolormap(128);
	elseif get(gcbo, "tag") == "hotcolormap_radio" then
		my_figure.color_map = hotcolormap(128);
	elseif get(gcbo, "tag") == "graycolormap_radio" then
		my_figure.color_map = graycolormap(128);
	end
	
	if my_cur_bg_color_id > 32 then
	
		color_id = color( ..
						my_cur_bg_color_r*255, ..
						my_cur_bg_color_g*255, ..
						my_cur_bg_color_b*255  ..
						);
		
		my_plot_axes.background = color_id;
	end
	
	my_figure.immediate_drawing = "on";
	
endfunction

function update_background_color()
	
	// Lancement du colorchooser
	[my_red, my_green, my_blue] = uigetcolor();
	
	if( (my_red<>[]) & (my_green<>[]) & (my_blue<>[]) ) then
		
		set(gcbo,"BackgroundColor",[ my_red/255 my_green/255 my_blue/255 ]);
		
		my_plot_axes            = gca();
		color_id                = color(my_red,my_green,my_blue);
		my_plot_axes.background = color_id;
		
	end
	
endfunction

function update_tics_visible()
	
	my_plot_axes = gca();
	
	if get(gcbo,"Value") == 0 then
		my_plot_axes.axes_visible = ["off" "off" "off" ];
	else
		my_plot_axes.axes_visible = ["on" "on" "on" ];
	end
	
endfunction

function update_title_visible()

	my_plot_axes = gca();
	
	if get(gcbo,"Value") == 0 then
		my_plot_axes.title.visible = "off";
	else
		my_plot_axes.title.visible = "on";
	end

endfunction

function update_labels_visible()

	my_plot_axes = gca();
	
	if get(gcbo,"Value") == 0 then
		my_plot_axes.x_label.visible = "off";
		my_plot_axes.y_label.visible = "off";
		my_plot_axes.z_label.visible = "off";
	else
		my_plot_axes.x_label.visible = "on";
		my_plot_axes.y_label.visible = "on";
		my_plot_axes.z_label.visible = "on";
	end

endfunction

function update_edges_visible()

	my_plot_axes = gca();
	my_plot3d    = my_plot_axes.children;
	
	if get(gcbo,"Value") == 0 then
		my_plot3d.color_mode = -1;
	else
		my_plot3d.color_mode = +1;
	end

endfunction

function update_title_string
	
	my_plot_axes = gca();
	my_plot_axes.title.text = get(gcbo,"String");
	
endfunction

function str = html2str(filename)
	
	str = mgetl(filename);
	str = strsubst(str,"SCI",SCI);
	str = stripblanks(str,%T) + " ";
	str = strcat(str);
	
endfunction

