/*
 * Scilab ( http://www.scilab.org/ ) - This file is part of Scilab
 * Copyright (C) 2009 - Calixte Denizet
 * 
 * This file must be used under the terms of the CeCILL.
 * This source file is licensed as described in the file COPYING, which
 * you should have received as part of this distribution.  The terms
 * are also available at    
 * http://www.cecill.info/licences/Licence_CeCILL_V2-en.txt
 *
 */

package org.scilab.modules.graphic_export;

import java.awt.Component;
import java.awt.Color;
import java.awt.Insets;
import java.awt.geom.AffineTransform;
import java.io.ByteArrayOutputStream;
import java.io.Writer;
import java.io.OutputStreamWriter;

import org.scilab.modules.renderer.utils.textRendering.SpecialTextException;
import org.scilab.modules.renderer.textDrawing.TeXObjectGL;

import org.scilab.forge.jlatexmath.TeXConstants;
import org.scilab.forge.jlatexmath.TeXFormula;

import org.apache.batik.svggen.SVGGraphics2D;
import org.apache.batik.dom.GenericDOMImplementation;

import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;

/**
 * Class to generate a LaTeX label in SVG.
 * @author Calixte Denizet
 */
public class TeXObjectSVG extends TeXObjectGL {
    
    private String code;
    private final static DOMImplementation dom = GenericDOMImplementation.getDOMImplementation();

    /** 
     * Default constructor.
     * @param content the LaTeX code
     * @param color the color of the content
     * @param fontSize the size of the font
     */
    public TeXObjectSVG(TeXObjectGL t) {
		super(t);
		makeImage();
    }

    public String getCode() {
		return code;
    }
        
    public void makeImage() {
		texi.setInsets(new Insets(1, 1, 1, 1));
		width = texi.getIconWidth();
		height = texi.getIconHeight();

		if (width <= 0 || height <= 0) {
			formula = new TeXFormula("\\mbox{An error occured, please contact the author of \\JLaTeXMath}");
			this.texi = formula.createTeXIcon(TeXConstants.STYLE_DISPLAY, 10);
			texi.setInsets(new Insets(1, 1, 1, 1));
			width = texi.getIconWidth();
			height = texi.getIconHeight();
		}   
		
		SVGGraphics2D g2d = new SVGGraphics2D(dom.createDocument("", "svg", null));
	
		AffineTransform gt = new AffineTransform();
		gt.translate(0, -height);
		g2d.transform (gt);
		
		texi.paintIcon(COMPONENT, g2d, 0, 0);
		ByteArrayOutputStream buf = new ByteArrayOutputStream();
		
		try {
		    g2d.stream(new OutputStreamWriter(buf, "UTF-8"), true, true);
		} catch (Exception e) {
			System.out.println(e.toString());
		}
				
		code = buf.toString();
		code = code.substring(code.indexOf("<!--Generated by the Batik "), code.indexOf("</svg"));
		g2d.dispose();
    }
}