/*
 * Scilab ( http://www.scilab.org/ ) - This file is part of Scilab
 * Copyright (C) 2010 - DIGITEO - Yann Collette
 * 
 * This file must be used under the terms of the CeCILL.
 * This source file is licensed as described in the file COPYING, which
 * you should have received as part of this distribution.  The terms
 * are also available at    
 * http://www.cecill.info/licences/Licence_CeCILL_V2-en.txt
 *
 */
#include <sci_mysql.h>

int sci_mysql_check_null(char * fname)
{
  int * sql_pointer_in = NULL;
  void * mysql_ptr_in = NULL;
  SciErr _SciErr;
  double result;

  CheckRhs(1,1);
  CheckLhs(0,1);

  _SciErr = getVarAddressFromPosition(pvApiCtx, 1, &sql_pointer_in);
  getPointer(pvApiCtx, sql_pointer_in, &mysql_ptr_in);

  result = (double)(mysql_ptr_in==NULL);
  createScalarDouble(pvApiCtx, Rhs+1, result);

  LhsVar(1) = Rhs + 1;

  return 0;
}
