/***************************************************************************
 *   Copyright (C) 2006-2007 by Tomasz Moń                                 *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; under version 2 of the License.         *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.         *
 ***************************************************************************/

#include <QApplication>
#include "qtscrob.h"

int main(int argc, char **argv) {
	QApplication app(argc, argv);
#ifndef Q_OS_MACX
	/* Don't override the higher quality OS X .icns file */
	app.setWindowIcon(QIcon(":/resources/icons/128.png"));
#endif
	app.setApplicationName("QTScrobbler");

	QTranslator translator;
	if (QFile::exists(":/language.qm")) {
		translator.load(":/language");
		app.installTranslator(&translator);
	}

	QTScrob mainWin;
	mainWin.setupWindow();
	mainWin.show();

	return app.exec();
}
