#!/usr/bin/python

from bug_task                        import BugTask

class BugTasks(object):
    # __init__
    #
    # Initialize the instance from a Launchpad bug.
    #
    def __init__(self, service, lp_tasks):
        self.__service       = service
        self.__lp_tasks      = lp_tasks

    # __len__
    #
    def __len__(self):
        return len(list(self.__iter__()))

    # __getitem__
    #
    def __getitem__(self, key):
        return BugTask(self.__service, self.__lp_tasks[key])

    # __iter__
    #
    def __iter__(self):
        for task in self.__lp_tasks:
            d = BugTask(self.__service, task)
            yield d

    # __contains__
    #
    def __contains__(self, item):
        return item in self.__iter__()

# vi:set ts=4 sw=4 expandtab:
