/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jna;

import com.sun.jna.Library;
import com.sun.jna.NativeLibrary;
import com.sun.jna.Platform;
import com.sun.jna.Pointer;
import com.sun.jna.TypeMapper;
import java.awt.Component;
import java.awt.Toolkit;
import java.awt.Window;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.lang.ref.WeakReference;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Proxy;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.Map;
import java.util.WeakHashMap;

public final class Native {
    private static Map typeMappers = Collections.synchronizedMap(new WeakHashMap());
    private static Map alignments = Collections.synchronizedMap(new WeakHashMap());
    private static Map libraries = Collections.synchronizedMap(new WeakHashMap());
    public static final int POINTER_SIZE;
    public static final int LONG_SIZE;
    public static final int WCHAR_SIZE;
    private static final ThreadLocal lastError;

    private Native() {
    }

    private static native void initIDs();

    public static synchronized native void setProtected(boolean var0);

    public static synchronized native boolean isProtected();

    public static synchronized native void setPreserveLastError(boolean var0);

    public static synchronized native boolean getPreserveLastError();

    public static long getWindowID(Window w) {
        return Native.getComponentID(w);
    }

    public static long getComponentID(Component c) {
        if (c.isLightweight()) {
            throw new IllegalArgumentException("Component must be heavyweight");
        }
        if (!c.isDisplayable()) {
            throw new IllegalStateException("Component must be displayable");
        }
        if (Platform.isX11() && System.getProperty("java.version").matches("^1\\.4\\..*") && !c.isVisible()) {
            throw new IllegalStateException("Component must be visible");
        }
        return Native.getWindowHandle0(c);
    }

    public static Pointer getWindowPointer(Window w) {
        return Native.getComponentPointer(w);
    }

    public static Pointer getComponentPointer(Component c) {
        return new Pointer(Native.getComponentID(c));
    }

    private static native long getWindowHandle0(Component var0);

    public static Pointer getByteBufferPointer(ByteBuffer b) {
        return Native.getDirectBufferPointer(b);
    }

    public static native Pointer getDirectBufferPointer(Buffer var0);

    public static String toString(byte[] buf) {
        int term;
        String encoding = System.getProperty("jna.encoding");
        String s = null;
        if (encoding != null) {
            try {
                s = new String(buf, encoding);
            }
            catch (UnsupportedEncodingException e) {
                // empty catch block
            }
        }
        if (s == null) {
            s = new String(buf);
        }
        if ((term = s.indexOf(0)) != -1) {
            s = s.substring(0, term);
        }
        return s;
    }

    public static String toString(char[] buf) {
        String s = new String(buf);
        int term = s.indexOf(0);
        if (term != -1) {
            s = s.substring(0, term);
        }
        return s;
    }

    public static Object loadLibrary(String name, Class interfaceClass) {
        return Native.loadLibrary(name, interfaceClass, Collections.EMPTY_MAP);
    }

    public static Object loadLibrary(String name, Class interfaceClass, Map options) {
        Library.Handler handler = new Library.Handler(name, interfaceClass, options);
        ClassLoader loader = interfaceClass.getClassLoader();
        Library proxy = (Library)Proxy.newProxyInstance(loader, new Class[]{interfaceClass}, (InvocationHandler)handler);
        if (options.containsKey("type-mapper")) {
            typeMappers.put(interfaceClass, options.get("type-mapper"));
        }
        if (options.containsKey("structure-alignment")) {
            alignments.put(interfaceClass, options.get("structure-alignment"));
        }
        libraries.put(interfaceClass, new WeakReference<Library>(proxy));
        return proxy;
    }

    private static boolean loadInstance(Class cls) {
        if (libraries.containsKey(cls)) {
            return true;
        }
        if (cls != null) {
            try {
                Field[] fields = cls.getFields();
                for (int i = 0; i < fields.length; ++i) {
                    Field field = fields[i];
                    if (field.getType() != cls || !Modifier.isStatic(field.getModifiers())) continue;
                    libraries.put(cls, new WeakReference<Object>(field.get(null)));
                    return true;
                }
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Could not access instance of " + cls + " (" + e + ")");
            }
        }
        return false;
    }

    public static TypeMapper getTypeMapper(Class interfaceClass) {
        if (!Native.loadInstance(interfaceClass) || !typeMappers.containsKey(interfaceClass)) {
            try {
                Field field = interfaceClass.getField("TYPE_MAPPER");
                return (TypeMapper)field.get(null);
            }
            catch (NoSuchFieldException e) {
            }
            catch (Exception e) {
                throw new IllegalArgumentException("TYPE_MAPPER must be a public TypeMapper field (" + e + "): " + interfaceClass);
            }
        }
        return (TypeMapper)typeMappers.get(interfaceClass);
    }

    public static int getStructureAlignment(Class interfaceClass) {
        Integer value;
        if (!Native.loadInstance(interfaceClass) || !alignments.containsKey(interfaceClass)) {
            try {
                Field field = interfaceClass.getField("STRUCTURE_ALIGNMENT");
                return (Integer)field.get(null);
            }
            catch (NoSuchFieldException e) {
            }
            catch (Exception e) {
                throw new IllegalArgumentException("STRUCTURE_ALIGNMENT must be a public int field (" + e + "): " + interfaceClass);
            }
        }
        return (value = (Integer)alignments.get(interfaceClass)) != null ? value : 0;
    }

    static byte[] getBytes(String s) {
        String encoding = System.getProperty("jna.encoding");
        if (encoding != null) {
            try {
                return s.getBytes(encoding);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
        return s.getBytes();
    }

    private static String getNativeLibraryResourcePath() {
        String osPrefix;
        String arch = System.getProperty("os.arch");
        if (Platform.isWindows()) {
            osPrefix = "win32-" + arch;
        } else if (Platform.isMac()) {
            osPrefix = "darwin";
        } else if (Platform.isLinux()) {
            osPrefix = "linux-" + arch;
        } else if (Platform.isSolaris()) {
            osPrefix = "sunos-" + arch;
        } else {
            osPrefix = System.getProperty("os.name").toLowerCase();
            int space = osPrefix.indexOf(" ");
            if (space != -1) {
                osPrefix = osPrefix.substring(0, space);
            }
            osPrefix = osPrefix + "-" + arch;
        }
        return "/com/sun/jna/" + osPrefix;
    }

    private static void loadNativeLibrary() {
        String resourceName;
        String libname = System.mapLibraryName("jnidispatch");
        URL url = Native.class.getResource(resourceName = Native.getNativeLibraryResourcePath() + "/" + libname);
        if (url == null) {
            throw new UnsatisfiedLinkError("jnidispatch (" + resourceName + ") not found in resource path");
        }
        File lib = null;
        if (url.getProtocol().toLowerCase().equals("file")) {
            try {
                lib = new File(URLDecoder.decode(url.getPath(), "UTF8"));
            }
            catch (UnsupportedEncodingException e) {
                throw new Error("JRE is unexpectedly missing UTF8 encoding");
            }
        }
        InputStream is = Native.class.getResourceAsStream(resourceName);
        if (is == null) {
            throw new Error("Can't obtain jnidispatch InputStream");
        }
        FileOutputStream fos = null;
        try {
            int count;
            lib = File.createTempFile("jna", null);
            lib.deleteOnExit();
            if (Platform.isWindows()) {
                Runtime.getRuntime().addShutdownHook(new W32Cleanup(lib));
            }
            fos = new FileOutputStream(lib);
            byte[] buf = new byte[1024];
            while ((count = is.read(buf, 0, buf.length)) > 0) {
                fos.write(buf, 0, count);
            }
        }
        catch (IOException e) {
            throw new Error("Failed to create temporary file for jnidispatch library", e);
        }
        finally {
            try {
                is.close();
            }
            catch (IOException e) {}
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException e) {}
            }
        }
        Toolkit.getDefaultToolkit();
        if (Platform.isWindows()) {
            try {
                System.loadLibrary("jawt");
            }
            catch (UnsatisfiedLinkError e) {
                e.printStackTrace();
            }
        }
        System.load(lib.getAbsolutePath());
    }

    private static native int pointerSize();

    private static native int longSize();

    private static native int wideCharSize();

    public static int getLastError() {
        return (Integer)lastError.get();
    }

    public static native void setLastError(int var0);

    static void updateLastError(int e) {
        lastError.set(new Integer(e));
    }

    public static Library synchronizedLibrary(final Library library) {
        Class<?> cls = library.getClass();
        if (!Proxy.isProxyClass(cls)) {
            throw new IllegalArgumentException("Library must be a proxy class");
        }
        InvocationHandler ih = Proxy.getInvocationHandler(library);
        if (!(ih instanceof Library.Handler)) {
            throw new IllegalArgumentException("Unrecognized proxy handler: " + ih);
        }
        final Library.Handler handler = (Library.Handler)ih;
        InvocationHandler newHandler = new InvocationHandler(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                NativeLibrary nativeLibrary = handler.getNativeLibrary();
                synchronized (nativeLibrary) {
                    return handler.invoke(library, method, args);
                }
            }
        };
        return (Library)Proxy.newProxyInstance(cls.getClassLoader(), cls.getInterfaces(), newHandler);
    }

    static {
        try {
            System.loadLibrary("jnidispatch");
        }
        catch (UnsatisfiedLinkError e) {
            Native.loadNativeLibrary();
        }
        POINTER_SIZE = Native.pointerSize();
        LONG_SIZE = Native.longSize();
        WCHAR_SIZE = Native.wideCharSize();
        Native.initIDs();
        if (Boolean.getBoolean("jna.protected")) {
            Native.setProtected(true);
        }
        lastError = new ThreadLocal(){

            protected synchronized Object initialValue() {
                return new Integer(0);
            }
        };
    }

    public static class W32Cleanup
    extends Thread {
        private File file;

        public W32Cleanup(File file) {
            this.file = file;
        }

        public void run() {
            try {
                Runtime.getRuntime().exec(new String[]{System.getProperty("java.home") + "/bin/java", "-cp", System.getProperty("java.class.path"), this.getClass().getName(), this.file.getAbsolutePath()});
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }

        public static void main(String[] args) {
            File file;
            if (args.length == 1 && (file = new File(args[0])).exists()) {
                long start = System.currentTimeMillis();
                while (!file.delete() && file.exists()) {
                    try {
                        Thread.sleep(10L);
                    }
                    catch (InterruptedException e) {
                        // empty catch block
                    }
                    if (System.currentTimeMillis() - start <= 1000L) continue;
                }
            }
            System.exit(0);
        }
    }
}

