/*
  Plee the Bear

  Copyright (C) 2005-2010 Julien Jorge, Sebastien Angibaud

  This program is free software; you can redistribute it and/or modify it
  under the terms of the GNU General Public License as published by the
  Free Software Foundation; either version 2 of the License, or (at your
  option) any later version.

  This program is distributed in the hope that it will be useful, but WITHOUT
  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
  more details.

  You should have received a copy of the GNU General Public License along
  with this program; if not, write to the Free Software Foundation, Inc.,
  51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

  contact: plee-the-bear@gamned.org

  Please add the tag [PTB] in the subject of your mails.
*/
/**
 * \file throwable_item.hpp
 * \brief A item that Plee can throw.
 * \author Angibaud Sebastien
 */
#ifndef __PTB_THROWABLE_ITEM_HPP__
#define __PTB_THROWABLE_ITEM_HPP__

#include "engine/base_item.hpp"
#include "visual/animation.hpp"

namespace ptb
{
  class player;

  /**
   * \brief A item that Plee can throw.
   *
   * \author Sebastien Angibaud
   */
  class throwable_item
  {
   public:
    enum throwable_item_type
      {
        stone_throwable_item_type = 0,
        air_honeypot_throwable_item_type,
        fire_honeypot_throwable_item_type,
        water_honeypot_throwable_item_type,
        hazelnut_throwable_item_type
      }; // enum throwable_item_type

  public:
    throwable_item(player* p);
    ~throwable_item();

    virtual bear::engine::base_item* create_throwable_item() const;
    virtual bool can_throw() const;
    virtual bool appears() const;
    virtual void decrease_stock() const;
    virtual unsigned int get_stock() const;
    virtual const bear::visual::animation& get_animation() const;
    virtual std::string get_name() const;

  public:
    /** \brief Number of throwable_items type. */
    static const unsigned int s_throwable_items_cardinality = 5;

  protected:
    /** \brief The pointer on the player. */
    player* m_player;

    /** \brief Indicates if the throwable_item appears with no stock. */
    bool m_always_appear;
  }; // class throwable_item
} // namespace ptb

#endif // __PTB_THROWABLE_ITEM_HPP__
