/*
  Plee the Bear

  Copyright (C) 2005-2010 Julien Jorge, Sebastien Angibaud

  This program is free software; you can redistribute it and/or modify it
  under the terms of the GNU General Public License as published by the
  Free Software Foundation; either version 2 of the License, or (at your
  option) any later version.

  This program is distributed in the hope that it will be useful, but WITHOUT
  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
  more details.

  You should have received a copy of the GNU General Public License along
  with this program; if not, write to the Free Software Foundation, Inc.,
  51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

  contact: plee-the-bear@gamned.org

  Please add the tag [PTB] in the subject of your mails.
*/
/**
 * \file honeypot_throwable_item.cpp
 * \brief Implementation of the ptb::honeypot_throwable_item class.
 * \author Sebastien Angibaud
 */
#include "ptb/throwable_item/honeypot_throwable_item.hpp"

#include "ptb/game_variables.hpp"
#include "ptb/player.hpp"
#include "ptb/item/small_honeypot.hpp"

/*----------------------------------------------------------------------------*/
/**
 * \brief Contructor.
 * \param p The pointer on the player.
 * \param t The type of the honeypot.
 */
ptb::honeypot_throwable_item::honeypot_throwable_item
(player* p, throwable_item::throwable_item_type t)
  : throwable_item(p), m_type(t)
{
} // honeypot_throwable_item::honeypot_throwable_item()

/*----------------------------------------------------------------------------*/
/**
 * \brief Create the throwable_item.
 */
bear::engine::base_item*
ptb::honeypot_throwable_item::create_throwable_item() const
{
  small_honeypot* new_small_honeypot = new small_honeypot();

  if ( m_type == throwable_item::air_honeypot_throwable_item_type )
    new_small_honeypot->set_type(base_bonus::air_power);
  else if ( m_type == throwable_item::fire_honeypot_throwable_item_type )
    new_small_honeypot->set_type(base_bonus::fire_power);
  else
    new_small_honeypot->set_type(base_bonus::water_power);

  return new_small_honeypot;
} // honeypot_throwable_item::create_throwable_item()

/*----------------------------------------------------------------------------*/
/**
 * \brief Indicates if Plee can throw this throwable_item.
 */
bool ptb::honeypot_throwable_item::can_throw() const
{
  bool result(super::can_throw());

  if ( result )
    {
      if ( ( m_type == throwable_item::air_honeypot_throwable_item_type ) &&
           !m_player->can_throw_power(monster::air_attack) )
        result = false;
      else if ( ( m_type == throwable_item::fire_honeypot_throwable_item_type)
                && !m_player->can_throw_power(monster::fire_attack) )
        result = false;
      else if ((m_type == throwable_item::water_honeypot_throwable_item_type )
               && !m_player->can_throw_power(monster::water_attack) )
        result = false;
    }

  return result;
} // honeypot_throwable_item::can_throw()

/*----------------------------------------------------------------------------*/
/**
 * \brief Decrease the stock.
 */
void ptb::honeypot_throwable_item::decrease_stock() const
{
  if ( m_type == throwable_item::air_honeypot_throwable_item_type )
    game_variables::set_air_power(m_player->get_index(),false);
  else if ( m_type == throwable_item::fire_honeypot_throwable_item_type )
    game_variables::set_fire_power(m_player->get_index(),false);
  else if ( m_type == throwable_item::water_honeypot_throwable_item_type )
    game_variables::set_water_power(m_player->get_index(),false);
} // honeypot_throwable_item::decrease_stock()

/*----------------------------------------------------------------------------*/
/**
 * \brief Get the stock.
 */
unsigned int ptb::honeypot_throwable_item::get_stock() const
{
  unsigned int result = 0;

  if ( m_type == throwable_item::air_honeypot_throwable_item_type )
    {
      if ( game_variables::get_air_power(m_player->get_index()) )
        result = 1;
    }
  else if ( m_type == throwable_item::fire_honeypot_throwable_item_type )
    {
      if ( game_variables::get_fire_power(m_player->get_index()) )
        result = 1;
    }
  else if ( m_type == throwable_item::water_honeypot_throwable_item_type )
    {
      if ( game_variables::get_water_power(m_player->get_index()) )
        result = 1;
    }

  return result;
} // honeypot_throwable_item::get_stock()

/*----------------------------------------------------------------------------*/
/**
 * \brief Get the animation of the throwable_item.
 */
const bear::visual::animation&
ptb::honeypot_throwable_item::get_animation() const
{
  bear::engine::level_globals& glob = m_player->get_level_globals();

  if ( m_type == throwable_item::air_honeypot_throwable_item_type )
    return glob.get_animation("animation/powerup/small_air.canim");
  else if ( m_type == throwable_item::fire_honeypot_throwable_item_type )
    return glob.get_animation("animation/powerup/small_fire.canim");
  else
    return glob.get_animation("animation/powerup/small_water.canim");
} // honeypot_throwable_item::get_animation()
